-----------------------------------------------------
-- localization.lua
-- English strings by default, localizations override with their own.
------------------------------------------------------

-- Key bindings
BINDING_HEADER_FEEDOMATIC = "Fizzwidget Feed-O-Matic";
BINDING_NAME_FEEDOMATIC = "Feed Pet";

-- Diet names. These should be the all-lowercase versions of the six diets returned from GetPetFoodTypes(). (Want to get them all nice and quick for your localization? Go tame a bear or boar... they eat anything.)
-- THESE STRINGS MUST BE LOCALIZED for Feed-O-Matic to work properly in other locales.
FOM_DIET_MEAT	= "meat";
FOM_DIET_FISH	= "fish";
FOM_DIET_BREAD	= "bread";
FOM_DIET_CHEESE = "cheese";
FOM_DIET_FRUIT	= "fruit";
FOM_DIET_FUNGUS = "fungus";

-- It's not clear whether the 5th and 6th returns from GetItemInfo() are supposed to be localized... so we have localized keys for them just in case. If these aren't localized, we'll just needlessly search your ammo bags for food.
FOM_AMMO_POUCH = "Ammo Pouch";
FOM_QUIVER = "Quiver";

-- Beast family names; we use these to provide immersive pet-specific sounds when the pet is hungry. If not localized, all pets will just play a bell sound when hungry.
FOM_BAT = "Bat";
FOM_BEAR = "Bear";
FOM_BOAR = "Boar";
FOM_CARRION_BIRD = "Carrion Bird";
FOM_CAT = "Cat";
FOM_CRAB = "Crab";
FOM_CROCOLISK = "Crocolisk";
FOM_GORILLA = "Gorilla";
FOM_HYENA = "Hyena";
FOM_OWL = "Owl";
FOM_RAPTOR = "Raptor";
FOM_SCORPID = "Scorpid";
FOM_SPIDER = "Spider";
FOM_TALLSTRIDER = "Tallstrider";
FOM_TURTLE = "Turtle";
FOM_WIND_SERPENT = "Wind Serpent";
FOM_WOLF = "Wolf";
-- expansion beast families
FOM_DRAGONHAWK = "Dragonhawk";
FOM_NETHER_RAY = "Nether Ray";
FOM_RAVAGER = "Ravager";
FOM_SERPENT = "Serpent";
FOM_SPOREBAT = "Sporebat";
FOM_WARP_STALKER = "Warp Stalker";

-- From here on down, the localized strings are just for readability... they don't affect whether Feed-O-Matic works.
FOM_BINDING_FEED = "Feed Pet";
FOM_BINDING_OPTIONS = "Feed-O-Matic Options";

FOM_FEEDBUTTON_TOOLTIP1 = "<Left-Click to feed pet %s>";
FOM_FEEDBUTTON_TOOLTIP1_FALLBACK = "<Alt-Left-Click to feed pet %s>";
FOM_FEEDBUTTON_TOOLTIP2 = "<Right-Click for Feed-O-Matic Options>";

-- Special diet keyword used in the chat-line interface for listing all diets.
FOM_DIET_ALL	= "all";

-- Used in tooltips to indicate food quality.
FOM_QUALITY_UNDER	= "%s doesn't like this anymore.";
FOM_QUALITY_WILL	= "%s will eat this.";
FOM_QUALITY_LIKE	= "%s likes to eat this.";
FOM_QUALITY_LOVE	= "%s loves to eat this.";

-- User-visible errors
FOM_ERROR_NO_FOOD		= "Could not find any food in your bags for %s.";
FOM_ERROR_NO_FOOD_NO_FALLBACK	= "Could not find any food in your bags for %s that you haven't told Feed-O-Matic to avoid.";
FOM_FALLBACK_MESSAGE	= "Hold Alt while pressing the Feed Pet button or key to feed %s anyway.";

-- Feeding status messages
FOM_FEEDING_EAT			= "Feeding %s a %s..."; 
FOM_FEEDING_FEED		= "feeds %s a %s. ";

FOM_PET_HUNGRY		= "%s is hungry!";
FOM_PET_VERY_HUNGRY	= "%s is very hungry!";

-- Key bindings
BINDING_NAME_FOM_FEED		= "Feed Pet";

-- Options panel
FOM_OPTIONS_SUBTEXT = "To feed your pet with Feed-O-Matic, bind a key to Feed Pet in the Key Bindings menu, click the pet happiness icon, or put '/click FOM_FeedButton' in a macro."

FOM_OPTIONS_TOOLTIP			= "Show food quality in tooltips"
FOM_OPTIONS_LOW_LVL_1ST		= "Prefer lower-level foods"
FOM_OPTIONS_OPEN_SLOTS		= "Keep bag space open"

FOM_OPTIONS_HEADER_AVOID	= "Avoid foods:"
FOM_OPTIONS_AVOID_BONUS		= "With a “well fed” bonus"
FOM_OPTIONS_AVOID_QUEST		= "Needed for quests"
FOM_OPTIONS_AVOID_COOK		= "Used for Cooking recipes"
FOM_OPTIONS_COOK_UNKNOWN	= "Save for unknown recipes"

FOM_DIFFICULTY_RECIPES		= "%s recipes"	-- "all recipes", "easy recipes", etc. (the key word gets colored.)
FOM_DIFFICULTY_ALL			= "all"
FOM_DIFFICULTY_GREEN		= "easy"
FOM_DIFFICULTY_YELLOW		= "medium"
FOM_DIFFICULTY_ORANGE		= "difficult"

FOM_OPTIONS_HEADER_WARNING	= "Warn that pet needs feeding:"

FOM_OPTIONS_WARN_ICON		= "Flash icon"
FOM_OPTIONS_WARN_TEXT		= "Show text"
FOM_OPTIONS_WARN_SOUND		= "Play sound"
FOM_OPTIONS_SOUND_BELL		= "Generic bell sound"

FOM_OPTIONS_WARN_LEVEL		= "Warn when pet is:"
FOM_OPTIONS_LEVEL_CONTENT	= "Content"
FOM_OPTIONS_LEVEL_UNHAPPY	= "Unhappy"
FOM_OPTIONS_LEVEL_NONE		= "Don't warn"

FOM_OPTIONS_FEED_NOTIFY 	= "Notify when feeding:"
FOM_OPTIONS_NOTIFY_EMOTE	= "With an emote"
FOM_OPTIONS_NOTIFY_TEXT		= "In chat window"
FOM_OPTIONS_NOTIFY_NONE		= "Don't notify"

------------------------------------------------------

if (GetLocale() == "frFR") then

-- Diet names. These should be the all-lowercase versions of the six diets returned from GetPetFoodTypes(). (Want to get them all nice and quick for your localization? Go tame a bear... they eat anything.)
-- THESE STRINGS MUST BE LOCALIZED for Feed-O-Matic to work properly in other locales.
	FOM_DIET_MEAT	= "viande";
	FOM_DIET_FISH	= "poisson";
	FOM_DIET_BREAD	= "pain";
	FOM_DIET_CHEESE = "fromage";
	FOM_DIET_FRUIT	= "fruit";
	FOM_DIET_FUNGUS = "champignon";

	-- It's not clear whether the 5th and 6th returns from GetItemInfo() are supposed to be localized... so we have localized keys for them just in case. If these aren't localized, we'll just needlessly search your ammo bags for food.
	FOM_AMMO_POUCH = "Giberne";
	FOM_QUIVER = "Carquois";

	-- Beast family names; we use these to provide immersive pet-specific sounds when the pet is hungry. If not localized, all pets will just play a bell sound when hungry.
	FOM_BAT = "Chauve-souris";
	FOM_BEAR = "Ours";
	FOM_BOAR = "Sanglier";
	FOM_CARRION_BIRD = "Charognard";
	FOM_CAT = "Félin";
	FOM_CRAB = "Crabe";
	FOM_CROCOLISK = "Crocilisque";
	FOM_GORILLA = "Gorille";
	FOM_HYENA = "Hyène";
	FOM_OWL = "Chouette";
	FOM_RAPTOR = "Raptor";
	FOM_SCORPID = "Scorpide";
	FOM_SPIDER = "Araignée";
	FOM_TALLSTRIDER = "Haut-trotteur";
	FOM_TURTLE = "Tortue";
	FOM_WIND_SERPENT = "Serpent des vents";
	FOM_WOLF = "Loup";

-- From here on down, the localized strings are just for readability... they don't affect whether Feed-O-Matic works.

	-- Special diet keyword used in the chat-line interface for listing all diets.
	FOM_DIET_ALL	= "tous";

	-- Used in tooltips to indicate food quality.
	FOM_QUALITY_UNDER	= "%s n'en mange plus désormais.";
	FOM_QUALITY_WILL	= "%s en mangera.";
	FOM_QUALITY_LIKE	= "%s aime en manger.";
	FOM_QUALITY_LOVE	= "%s adore en manger.";
	
	-- User-visible errors
	FOM_ERROR_NO_FOOD		= "%s n'a pas trouvé de nourriture dans votre sac.";
	
	-- Feeding status messages
	FOM_FEEDING_EAT			= "%s mange un(e) %s."; 
	FOM_FEEDING_FEED		= "donne à %s à manger un(e) %s. ";

	FOM_PET_HUNGRY  = "%s a faim!";
	FOM_PET_VERY_HUNGRY = "%s a très faim!";

end

------------------------------------------------------

if (GetLocale() == "deDE") then

-- Diet names. These should be the all-lowercase versions of the six diets returned from GetPetFoodTypes(). (Want to get them all nice and quick for your localization? Go tame a bear... they eat anything.)
-- THESE STRINGS MUST BE LOCALIZED for Feed-O-Matic to work properly in other locales.
	FOM_DIET_MEAT	= "fleisch";
	FOM_DIET_FISH	= "fisch";
	FOM_DIET_BREAD	= "brot";
	FOM_DIET_CHEESE = "käse";
	FOM_DIET_FRUIT	= "obst";
--	FOM_DIET_FUNGUS = "fungus";	-- same as English (?), so we don't need to re-define it.

	-- It's not clear whether the 5th and 6th returns from GetItemInfo() are supposed to be localized... so we have localized keys for them just in case.
	FOM_AMMO_POUCH = "Munitionsbeutel";
	FOM_QUIVER = "Köcher";

	-- Beast family names; we use these to provide immersive pet-specific sounds when the pet is hungry. If not localized, all pets will just play a bell sound when hungry.
	FOM_BAT = "Fledermaus";
	FOM_BEAR = "Bär";
	FOM_BOAR = "Eber";
	FOM_CARRION_BIRD = "Aasvogel";
	FOM_CAT = "Katze";
	FOM_CRAB = "Krebs";
	FOM_CROCOLISK = "Krokilisk";
--	FOM_GORILLA = "Gorilla";		-- same as enUS
	FOM_HYENA = "Hyäne";
	FOM_OWL = "Eule";
--	FOM_RAPTOR = "Raptor";		-- same as enUS
	FOM_SCORPID = "Skorpid";
	FOM_SPIDER = "Spinne";
	FOM_TALLSTRIDER = "Weitschreiter";
	FOM_TURTLE = "Schildkröte";
	FOM_WIND_SERPENT = "Windnatter";
--	FOM_WOLF = "Wolf";		-- same as enUS
	
-- From here on down, the localized strings are just for readability; they don't affect whether Feed-O-Matic works.

-- Special diet keyword used in the chat-line interface for listing all diets.
	FOM_DIET_ALL	= "alles";

	-- Used in tooltips to indicate food quality.
	FOM_QUALITY_UNDER = "%s mag das nicht mehr fressen.";
	FOM_QUALITY_WILL = "%s mag das fressen.";
	FOM_QUALITY_LIKE = "%s frisst das gerne.";
	FOM_QUALITY_LOVE = "%s liebt es, das zu fressen.";

	-- User-visible errors
	FOM_ERROR_NO_FOOD  = "%s findet nichts zu fressen in Deinem Rucksack.";

	-- Feeding status messages
	FOM_FEEDING_EAT   = "%s frisst ein %s aus Deinem Rucksack."; 
	FOM_FEEDING_FEED  = "füttert %s ein %s. ";

end

------------------------------------------------------

if (GetLocale() == "koKR") then

-- Diet names. These should be the all-lowercase versions of the six diets returned from GetPetFoodTypes(). (Want to get them all nice and quick for your localization? Go tame a bear... they eat anything.)
-- THESE STRINGS MUST BE LOCALIZED for Feed-O-Matic to work properly in other locales.
--	FOM_DIET_MEAT	= "meat";
--	FOM_DIET_FISH	= "fish";
--	FOM_DIET_BREAD	= "bread";
--	FOM_DIET_CHEESE = "cheese";
--	FOM_DIET_FRUIT	= "fruit";
--	FOM_DIET_FUNGUS = "fungus";

	-- It's not clear whether the 5th and 6th returns from GetItemInfo() are supposed to be localized... so we have localized keys for them just in case.
--	FOM_AMMO_POUCH = "Ammo Pouch";
	FOM_QUIVER = "화살통";
	
end

------------------------------------------------------

if (GetLocale() == "zhTW") then
-- Diet names. These should be the all-lowercase versions of the six diets returned from GetPetFoodTypes(). (Want to get them all nice and quick for your localization? Go tame a bear or boar... they eat anything.)
-- THESE STRINGS MUST BE LOCALIZED for Feed-O-Matic to work properly in other locales.
FOM_DIET_MEAT	= "肉";
FOM_DIET_FISH	= "魚";
FOM_DIET_BREAD	= "麵包";
FOM_DIET_CHEESE = "乳酪";
FOM_DIET_FRUIT	= "水果";
FOM_DIET_FUNGUS = "蘑菇";

-- It's not clear whether the 5th and 6th returns from GetItemInfo() are supposed to be localized... so we have localized keys for them just in case. If these aren't localized, we'll just needlessly search your ammo bags for food.
FOM_AMMO_POUCH = "彈藥袋";
FOM_QUIVER = "箭袋";

-- Beast family names; we use these to provide immersive pet-specific sounds when the pet is hungry. If not localized, all pets will just play a bell sound when hungry.
FOM_BAT = "蝙蝠";
FOM_BEAR = "熊";
FOM_BOAR = "野豬";
FOM_CARRION_BIRD = "禿鷹";
FOM_CAT = "貓";
FOM_CRAB = "螃蟹";
FOM_CROCOLISK = "鱷魚";
FOM_GORILLA = "猩猩";
FOM_HYENA = "土狼";
FOM_OWL = "貓頭鷹";
FOM_RAPTOR = "迅猛龍";
FOM_SCORPID = "蠍子";
FOM_SPIDER = "蜘蛛";
FOM_TALLSTRIDER = "陸行鳥";
FOM_TURTLE = "烏龜";
FOM_WIND_SERPENT = "風蛇";
FOM_WOLF = "狼";
-- expansion beast families
FOM_DRAGONHAWK = "龍鷹";
FOM_NETHER_RAY = "虛空鰭刺";
FOM_RAVAGER = "破壞者";
FOM_SERPENT = "毒蛇";
FOM_SPOREBAT = "孢子蝙蝠";
FOM_WARP_STALKER = "扭曲行者";

end
