------------------------------------------------------
-- localization.lua
-- English strings by default, localizations override with their own.
------------------------------------------------------

-- Zone names must be localized or automatic switching of the reputation watch bar will not work!
ZONE_AV             = "Alterac Valley";
ZONE_AB             = "Arathi Basin";
ZONE_WSG            = "Warsong Gulch";
ZONE_HINTERLANDS	= "The Hinterlands";
ZONE_SILITHUS       = "Silithus";
ZONE_AQ20           = "Ruins of Ahn'Qiraj";
ZONE_AQ40           = "Ahn'Qiraj";
ZONE_ZG             = "Zul'Gurub";
ZONE_WPL            = "Western Plaguelands";
ZONE_EPL            = "Eastern Plaguelands";
ZONE_STRATHOLME     = "Stratholme";
ZONE_SCHOLOMANCE    = "Scholomance";
ZONE_NAXXRAMAS      = "Naxxramas";
ZONE_FELWOOD		= "Felwood";
ZONE_WINTERSPRING	= "Winterspring";
ZONE_GHOSTLANDS		= "Ghostlands";

-- Faction names must be localized; otherwise neither automatic rep-watch-bar switching nor display of potential rep from item turnins will work!
FACTION_FROSTWOLF			= "Frostwolf Clan";   -- ???
FACTION_DEFILERS			= "The Defilers";     -- ???
FACTION_WARSONG				= "Warsong Outriders";     -- ???
FACTION_STORMPIKE			= "Stormpike Guard";
FACTION_ARATHOR				= "The League of Arathor";
FACTION_SILVERWING			= "Silverwing Sentinels";
FACTION_DARKMOON            = "Darkmoon Faire";
FACTION_ZANDALAR            = "Zandalar Tribe";
FACTION_BROOD_NOZDORMU      = "Brood of Nozdormu";
FACTION_CENARION_CIRCLE     = "Cenarion Circle";
FACTION_ARGENT_DAWN         = "Argent Dawn";
FACTION_TIMBERMAW           = "Timbermaw Hold";
FACTION_THORIUM_BROTHERHOOD = "Thorium Brotherhood";
FACTION_GADGETZAN			= "Gadgetzan";
FACTION_WILDHAMMER			= "Wildhammer Clan";
FACTION_DWARF               = "Ironforge";
FACTION_NELF                = "Darnassus";
FACTION_GNOME               = "Gnomeregan Exiles";
FACTION_HUMAN               = "Stormwind";
FACTION_ORC                 = "Orgrimmar";
FACTION_TAUREN              = "Thunder Bluff";
FACTION_TROLL               = "Darkspear Trolls";
FACTION_FORSAKEN            = "Undercity";
-- Burning Crusade factions
FACTION_DRAENEI				= "Exodar";
FACTION_BELF				= "Silvermoon City";
FACTION_TRANQUILLIEN			= "Tranquillien";
FACTION_CENARION_EXPEDITION	= "Cenarion Expedition";
FACTION_SPOREGGAR			= "Sporeggar";
FACTION_KURENAI				= "Kurenai";
FACTION_MAGHAR				= "The Mag'har";
FACTION_CONSORTIUM			= "The Consortium";
FACTION_ALDOR				= "The Aldor";
FACTION_SCRYER				= "The Scryers";
FACTION_SHATAR				= "The Sha'tar";
FACTION_LOWER_CITY			= "Lower City";
FACTION_NETHERWING			= "Netherwing";
FACTION_SKYGUARD			= "Sha'tari Skyguard";

------------------------------------------------------
-- Localized strings below this line are just text shown by the addon's UI; it will still function if they aren't localized.
------------------------------------------------------

-- We keep the names of these items because it's quite possible for them to show up without being cached by the WoW client.
FFF_AD_TOKEN = "Argent Dawn Valor Token";
FFF_ZG_TOKEN = "Zandalar Honor Token";

FFF_UNKNOWN_ITEM = "(Unknown Item #%d)";
FFF_REPUTATION_TICK_TOOLTIP = "%d reputation points available:";
FFF_AFTER_TURNINS_LABEL = "After turnins:";
FFF_AFTER_TURNINS_INFO = "%s (%d/%d)";		-- e.g. "Friendly (2150/6000)"

FFF_REPORT_LINE_ITEM = "%dx %s";            -- C in example below
FFF_REPORT_NUM_TURNINS = " (%d turnins)";	-- B in example below
FFF_REPORT_NUM_POINTS = "%d points";		-- A in example below
FFF_COUNT_IN_BANK = "%d in bank";			-- D in example below
FFF_COUNT_CREATED = "%d from turnins";		-- E in example below
FFF_ALL_CREATED = "from turnins";			-- F in example below

-- example 1:
--	100 points (2 turnins):		20x [Invader's Scourgestone] (13 in bank)
--  |---A----||----B-----|		|------------C-------------|  |---D----|
--	300 points:		3x [Argent Dawn Valor Token] (1 in bank, 2 from turnins)
--  |---A----|		|------------C-------------|  |---D---|  |-----E------|
-- example 2:
--	150 points:		2x [Blue Hakkari Bijou]
--  |---A----|		|----------C----------|
--	100 points:		2x [Zandalar Honor Token] (from turnins)
--  |---A----|		|------------C----------|  |----F-----|

-- Options panel

FFF_OPTIONS_SWITCHBAR = "Show/switch the reputation watch bar:";
FFF_OPTION_ZONES = "When entering zones with faction objectives";
FFF_OPTION_REP_GAINED = "When gaining reputation with any faction";
FFF_OPTIONS_OTHER = "Other options:";
FFF_OPTION_SHOW_POTENTIAL = "Show potential reputation from item turnins on bar";
FFF_OPTION_TOOLTIP = "Show faction turnin info in item tooltips";

-- Item Tooltip
FFF_FACTION_TURNIN = "Reputation turnin for";
FFF_RACIAL_FACTIONS = " racial factions";
FFF_CAULDRON = "Cauldrons";

-- ReputationWatchBar menu
FFF_SHOW_REPUTATION_PANE = "Show Reputation Pane";
FFF_SHOW_OPTIONS = "Show FactionFriend Options";


------------------------------------------------------
if (GetLocale() == "deDE") then
	
	-- Zone names must be localized or automatic switching of the reputation watch bar will not work!
	ZONE_AV             = "Alteractal"; 
	ZONE_AB             = "Arathibecken";
	ZONE_WSG            = "Kriegshymnenschlucht";
	ZONE_HINTERLANDS    = "Das Hinterland";
	ZONE_SILITHUS       = "Silithus";
	ZONE_AQ20           = "Ruinen von Ahn'Qiraj"; 
	ZONE_AQ40           = "Ahn'Qiraj";
	ZONE_ZG             = "Zul'Gurub";
	ZONE_WPL            = "Westliche Pestl\195\164nder";
	ZONE_EPL            = "\195\150stliche Pestl\195\164nder"; 
	ZONE_STRATHOLME     = "Stratholme";
	ZONE_SCHOLOMANCE    = "Scholomance";
	ZONE_NAXXRAMAS      = "Naxxramas";
	ZONE_FELWOOD        = "Teufelswald";
	ZONE_WINTERSPRING   = "Winterspring"; 
	ZONE_GHOSTLANDS     = "Geisterlande";

	-- Faction names must be localized; otherwise neither automatic rep-watch-bar switching nor display of potential rep from item turnins will work!
	FACTION_FROSTWOLF           = "Frostwolfklan";   -- ??? 
	FACTION_DEFILERS            = "Die Entweihten";     -- ???
	FACTION_WARSONG             = "Kriegshymnenvorhut";     -- ???
	FACTION_STORMPIKE           = "Sturmlanzengarde";
	FACTION_ARATHOR             = "Der Bund von Arathor"; 
	FACTION_SILVERWING          = "Schildwache der Silverwing";
	FACTION_DARKMOON            = "Dunkelmondjahrmarkt";
	FACTION_ZANDALAR            = "Stamm der Zandalar";
	FACTION_BROOD_NOZDORMU      = "Brut Nozdormus"; 
	FACTION_CENARION_CIRCLE     = "Zirkel des Cenarius";
	FACTION_ARGENT_DAWN         = "Argentumd\195\164mmerung";
	FACTION_TIMBERMAW           = "Holzschlundfeste";
	FACTION_THORIUM_BROTHERHOOD = "Thoriumbruderschaft"; 
	FACTION_GADGETZAN           = "Gadgetzan";
	FACTION_WILDHAMMER          = "Wildhammerklan";
	FACTION_DWARF               = "Eisenschmiede";
	FACTION_NELF                = "Darnassus"; 
	FACTION_GNOME               = "Gnomeregangnome";
	FACTION_HUMAN               = "Sturmwind";
	FACTION_ORC                 = "Orgrimmar";
	FACTION_TAUREN              = "Donnerfels"; 
	FACTION_TROLL               = "Darkspear";
	FACTION_FORSAKEN            = "Unterstadt";

	-- Burning Crusade factions
	FACTION_DRAENEI             = "Die Exodar";
	FACTION_BELF                = "Silbermond";
	FACTION_TRANQUILLIEN        = "Tristessa";
	FACTION_CENARION_EXPEDITION = "Expedition des Cenarius";
	FACTION_SPOREGGAR           = "Sporeggar";
	FACTION_KURENAI             = "Kurenai";
	FACTION_MAGHAR              = "Die Mag'har";
	FACTION_CONSORTIUM          = "Das Konsortium";
	FACTION_ALDOR               = "Die Aldor";
	FACTION_SCRYER              = "Die Seher";
	FACTION_SHATAR              = "Die Sha'tar";
	FACTION_LOWER_CITY          = "Das untere Viertel";
	FACTION_NETHERWING			= "Netherschwingen";
	FACTION_SKYGUARD			= "Himmelswache der Sha'tari";
	
	-- Localized strings below this line are just text shown by the addon's UI; it will still function if they aren't localized.
	FFF_AD_TOKEN = "Ehrenmarke der Argentumd\195\164mmerung";
	FFF_ZG_TOKEN = "Zandalarianische Ehrenm\195\188nze";
		
	FFF_UNKNOWN_ITEM = "(Unbekannter Gegenstand #%d)";
	FFF_REPUTATION_TICK_TOOLTIP = "%d Rufpunkte m\195\182glich:"; 
	FFF_AFTER_TURNINS_LABEL = "Nach Abgabe:"; 
	FFF_AFTER_TURNINS_INFO = "%s (%d/%d)";		-- e.g. "Friendly (2150/6000)"
	
	FFF_REPORT_LINE_ITEM = "%dx %s";            -- C in example below
	FFF_REPORT_NUM_TURNINS = " (%d Abgaben)";   -- B in example below
	FFF_REPORT_NUM_POINTS = "%d Punkte";        -- A in example below 
	FFF_COUNT_IN_BANK = " (%d auf der Bank)";   -- D in example below
	FFF_COUNT_CREATED = "%d von Abgaben";		-- E in example below
	FFF_ALL_CREATED = "von Abgaben";			-- F in example below
	-- example usage:
	--    100 points (4 turnins):        40x [Invader's Scourgestone] (13 in bank)
	--  |---A----||----B-----|        |------------C-------------||-----D-----| 

	-- Options panel

	FFF_OPTIONS = "FactionFriend Optionen";
	FFF_OPTIONS_SWITCHBAR = "Zeige/wechsel die Rufleiste:";
	FFF_OPTION_ZONES = "Wenn man Gebiete mit Fraktionsaufgaben betritt."; 
	FFF_OPTION_REP_GAINED = "Wenn man Ruf bei einer Fraktion erh\195\164lt.";
	FFF_OPTIONS_OTHER = "Andere Optionen:";
	FFF_OPTION_SHOW_POTENTIAL = "Zeige gesch\195\164tzten Rufgewinn durch Abgaben."; 
	FFF_OPTION_TOOLTIP = "Zeige Ruf-Abgabe Informationen im Tooltip";
	
	-- Item Tooltip
	FFF_FACTION_TURNIN = "Ruf-Abgabe f\195\188r"; 
	FFF_RACIAL_FACTIONS = " Rassen-Fraktion"; 
	FFF_CAULDRON = "Gei\195\159elkessel";

	-- ReputationWatchBar menu
	FFF_SHOW_REPUTATION_PANE = "Zeige Ruf Balken"; 
	FFF_SHOW_OPTIONS = "Zeige FactionFriend Optionen"; 
	
end
------------------------------------------------------
if (GetLocale() == "frFR") then

	-- Zone names must be localized or automatic switching of the reputation watch bar will not work!
	ZONE_AV			= "Vallée d'Alterac";
	ZONE_AB			= "Bassin d'Arathi";
	ZONE_WSG		= "Goulet des Chanteguerres";
	ZONE_HINTERLANDS	= "Les Hinterlands";
	ZONE_SILITHUS		= "Silithus";
	ZONE_AQ20		= "Ruines d'Ahn'Quiraj";
	ZONE_AQ40		= "Ahn'Qiraj";
	ZONE_ZG			= "Zul'Gurub";
	ZONE_WPL		= "Maleterres de l'ouest";
	ZONE_EPL		= "Maleterres de l'est";
	ZONE_STRATHOLME		= "Stratholme";
	ZONE_SCHOLOMANCE	= "Scholomance";
	ZONE_NAXXRAMAS		= "Naxxramas";
	ZONE_FELWOOD		= "Gangrebois";
	ZONE_WINTERSPRING	= "Berceau-de-l'Hiver";
	ZONE_GHOSTLANDS		= "Les Terres fantômes";
	
	-- Faction names must be localized; otherwise neither automatic rep-watch-bar switching nor display of potential rep from item turnins will work!
	FACTION_FROSTWOLF		= "Clan Loup-de-givre";
	FACTION_DEFILERS		= "Les Profanateurs";
	FACTION_WARSONG			= "Voltigeurs Chanteguerre";
	FACTION_STORMPIKE		= "Guarde Foudrepique";
	FACTION_ARATHOR			= "La Ligue d'Arathor";
	FACTION_SILVERWING		= "Sentinelles d'Aile-argent";
	FACTION_DARKMOON		= "Foire de Sombrelune";
	FACTION_ZANDALAR		= "Tribu Zandalar";
	FACTION_BROOD_NOZDORMU		= "Brood of Nozdormu";
	FACTION_CENARION_CIRCLE		= "Cercle cénarien";
	FACTION_ARGENT_DAWN		= "Aube d'argent";
	FACTION_TIMBERMAW		= "Les Grumegueules";
	FACTION_THORIUM_BROTHERHOOD	= "Confrérie du Thorium";
	FACTION_GADGETZAN		= "Gadgetzan";
	FACTION_WILDHAMMER		= "Clan Marteau-hardi";
	FACTION_DWARF			= "Forgefer";
	FACTION_NELF			= "Darnassus";
	FACTION_GNOME			= "Exilés de Gonmeragan";
	FACTION_HUMAN			= "Hurlevent";
	FACTION_ORC			= "Orgrimmar";
	FACTION_TAUREN			= "Les Pitons du Tonnerre";
	FACTION_TROLL			= "Trolls Sombrelance";
	FACTION_FORSAKEN		= "Fossoyeuse";
	-- Burning Crusade factions
	FACTION_DRAENEI			= "Exodar";
	FACTION_BELF			= "Lune-d'argent";
	FACTION_TRANQUILLIEN		= "Tranquillien";
	FACTION_CENARION_EXPEDITION	= "Expédition cénarienne";
	FACTION_SPOREGGAR		= "Sporeggar";
	FACTION_KURENAI			= "Kurenaï";
	FACTION_MAGHAR			= "Mag'har";
	FACTION_CONSORTIUM		= "Le Consortium";
	FACTION_ALDOR			= "L'Aldor";
	FACTION_SCRYER			= "Les Clairvoyants";
	FACTION_SHATAR			= "Les Sha'tar";
	FACTION_LOWER_CITY		= "Ville basse";

	-- Localized strings below this line are just text shown by the addon's UI; it will still function if they aren't localized.
	
	FFF_REPUTATION_TICK_TOOLTIP = "%d points de réputation disponibles:";
	FFF_REPORT_LINE_ITEM = "%dx %s";            -- C in example below
	FFF_REPORT_NUM_TURNINS = " (%d retours)";	-- B in example below
	FFF_REPORT_NUM_POINTS = "%d points";        -- A in example below
	FFF_COUNT_IN_BANK = " (%d en banque)";        -- D in example below
	-- example usage:
	--	100 points (4 turnins):		40x [Invader's Scourgestone] (13 in bank)
	--  |---A----||----B-----|		|------------C-------------||-----D-----|
	
	-- Options panel
	
	FFF_OPTIONS = "Options de FactionFriend";
	FFF_OPTIONS_SWITCHBAR = "Montrer/Changer de barre de réputation :";
	FFF_OPTION_ZONES = "En entrant dans une zone avec des objectifs de faction";
	FFF_OPTION_REP_GAINED = "En gagnant de la réputation avec une faction";
	FFF_OPTIONS_OTHER = "Autres options de la barre : ";
	FFF_OPTION_SHOW_POTENTIAL = "Montrer le gain de réputation potentiel pour les retours d'objets";
	
end
------------------------------------------------------
