------------------------------------------------------
-- FFF_ItemInfo.lua
------------------------------------------------------
-- LOCALIZATION: nothing locale-specific here (the localized names are all in comments)
------------------------------------------------------

FFF_ZoneFactions = {
	["Horde"] = {
		[ZONE_AV] = FACTION_FROSTWOLF,
		[ZONE_AB] = FACTION_DEFILERS,
		[ZONE_WSG] = FACTION_WARSONG,
		[ZONE_GHOSTLANDS] = FACTION_TRANQUILLIEN,
	},
	["Alliance"] = {
		[ZONE_AV] = FACTION_STORMPIKE,
		[ZONE_AB] = FACTION_ARATHOR,
		[ZONE_WSG] = FACTION_SILVERWING,
	},
	["Neutral"] = {
		[ZONE_SILITHUS] = FACTION_CENARION_CIRCLE,
		[ZONE_AQ20] = FACTION_CENARION_CIRCLE,
		[ZONE_AQ40] = FACTION_BROOD_NOZDORMU,
		[ZONE_ZG] = FACTION_ZANDALAR,
		[ZONE_WPL] = FACTION_ARGENT_DAWN,
		[ZONE_EPL] = FACTION_ARGENT_DAWN,
		[ZONE_STRATHOLME] = FACTION_ARGENT_DAWN,
		[ZONE_SCHOLOMANCE] = FACTION_ARGENT_DAWN,
		[ZONE_NAXXRAMAS] = FACTION_ARGENT_DAWN,
		[ZONE_FELWOOD] = FACTION_TIMBERMAW,
		[ZONE_WINTERSPRING] = FACTION_TIMBERMAW,
	},
};

FFF_ExcludedFactions = {
	["Alliance"] = {
		FACTION_FORSAKEN,
		FACTION_TROLL,
		FACTION_TAUREN,
		FACTION_ORC,
		FACTION_BELF,
		FACTION_FROSTWOLF,
		FACTION_MAGHAR,
		FACTION_TRANQUILLIEN,
	},
	["Horde"] = {
		FACTION_HUMAN,
		FACTION_GNOME,
		FACTION_NELF,
		FACTION_DWARF,
		FACTION_DRAENEI,
		FACTION_STORMPIKE,
		FACTION_KURENAI,
	},
};

FFF_ItemInfo = {
	
	-- Racial factions: Horde
	[FACTION_FORSAKEN] = {
		Runecloth = {
			value = 75,
			items = {
				[14047] = 20,	-- Runecloth
			},
		},

		-- AQ war effort turnins
		CommendationSignet_10 = {
			value = 150,
			items = {
				[21438] = 10,	-- Horde Commendation Signet
			},
		},
		CommendationSignet_01 = {
			value = 5,
			items = {
				[21438] = 1,	-- Horde Commendation Signet
			},
		},
	},
	[FACTION_TROLL] = {
		Runecloth = {
			value = 75,
			items = {
				[14047] = 20,	-- Runecloth
			},
		},

		-- AQ war effort turnins
		CommendationSignet_10 = {
			value = 150,
			items = {
				[21438] = 10,	-- Horde Commendation Signet
			},
		},
		CommendationSignet_01 = {
			value = 5,
			items = {
				[21438] = 1,	-- Horde Commendation Signet
			},
		},
	},
	[FACTION_TAUREN] = {
		Runecloth = {
			value = 75,
			items = {
				[14047] = 20,	-- Runecloth
			},
		},
		Morrowgrain = {
			value = 75,
			items = {
				[11040] = 10,	-- Morrowgrain
			},
		},

		-- AQ war effort turnins
		CommendationSignet_10 = {
			value = 150,
			items = {
				[21438] = 10,	-- Horde Commendation Signet
			},
		},
		CommendationSignet_01 = {
			value = 5,
			items = {
				[21438] = 1,	-- Horde Commendation Signet
			},
		},
	},
	[FACTION_ORC] = {
		Runecloth = {
			value = 75,
			items = {
				[14047] = 20,	-- Runecloth
			},
		},
		
		-- AQ war effort turnins
		CommendationSignet_10 = {
			value = 150,
			items = {
				[21438] = 10,	-- Horde Commendation Signet
			},
		},
		CommendationSignet_01 = {
			value = 5,
			items = {
				[21438] = 1,	-- Horde Commendation Signet
			},
		},

		-- AV turnins
		AV_RiderHarnesses = {
			value = 10,
			items = {
				[17642] = 1,	-- Alterac Ram Hide
			},
		},
		AV_BossSummon_5 = {
			value = 50,
			items = {
				[17306] = 5,	-- Stormpike Soldier's Blood
			},
		},
		AV_BossSummon_1 = {
			value = 10,
			items = {
				[17306] = 1,	-- Stormpike Soldier's Blood
			},
		},
		AV_ArmorScraps = {
			value = 10,
			items = {
				[17422] = 20,	-- Armor Scraps
			},
		},
		AV_3rdAirstrike = {
			value = 10,
			items = {
				[17328] = 1,	-- Stormpike Commander's Flesh
			},
		},
		AV_2ndAirstrike = {
			value = 10,
			items = {
				[17327] = 1,	-- Stormpike Lieutenant's Flesh
			},
		},
		AV_1stAirstrike = {
			value = 10,
			items = {
				[17326] = 1,	-- Stormpike Soldier's Flesh
			},
		},
	},
	
	-- Racial factions: Alliance
	[FACTION_HUMAN] = {
		Runecloth = {
			value = 75,
			items = {
				[14047] = 20,	-- Runecloth
			},
		},

		-- AQ war effort turnins
		CommendationSignet_10 = {
			value = 150,
			items = {
				[21436] = 10,	-- Alliance Commendation Signet
			},
		},
		CommendationSignet_01 = {
			value = 5,
			items = {
				[21436] = 1,	-- Alliance Commendation Signet
			},
		},
	},
	[FACTION_GNOME] = {
		Runecloth = {
			value = 75,
			items = {
				[14047] = 20,	-- Runecloth
			},
		},

		-- AQ war effort turnins
		CommendationSignet_10 = {
			value = 150,
			items = {
				[21436] = 10,	-- Alliance Commendation Signet
			},
		},
		CommendationSignet_01 = {
			value = 5,
			items = {
				[21436] = 1,	-- Alliance Commendation Signet
			},
		},
	},
	[FACTION_NELF] = {
		Runecloth = {
			value = 75,
			items = {
				[14047] = 20,	-- Runecloth
			},
		},
		Morrowgrain_10 = {
			value = 75,
			items = {
				[11040] = 10,	-- Morrowgrain
			},
		},
		Morrowgrain_05 = {
			value = 25,
			items = {
				[11040] = 5,	-- Morrowgrain
			},
		},
		
		-- AQ war effort turnins
		CommendationSignet_10 = {
			value = 150,
			items = {
				[21436] = 10,	-- Alliance Commendation Signet
			},
		},
		CommendationSignet_01 = {
			value = 5,
			items = {
				[21436] = 1,	-- Alliance Commendation Signet
			},
		},
	},
	[FACTION_DWARF] = {
		Runecloth = {
			value = 75,
			items = {
				[14047] = 20,	-- Runecloth
			},
		},
		
		-- AQ war effort turnins
		CommendationSignet_10 = {
			value = 150,
			items = {
				[21436] = 10,	-- Alliance Commendation Signet
			},
		},
		CommendationSignet_01 = {
			value = 5,
			items = {
				[21436] = 1,	-- Alliance Commendation Signet
			},
		},

		-- AV turnins
		AV_RiderHarnesses = {
			value = 10,
			items = {
				[17643] = 1,	-- Frostwolf Hide
			},
		},
		AV_BossSummon_5 = {
			value = 50,
			items = {
				[17423] = 5,	-- Storm Crystal
			},
		},
		AV_BossSummon_1 = {
			value = 10,
			items = {
				[17423] = 1,	-- Storm Crystal
			},
		},
		AV_ArmorScraps = {
			value = 10,
			items = {
				[17422] = 20,	-- Armor Scraps
			},
		},
		AV_3rdAirstrike = {
			value = 10,
			items = {
				[17504] = 1,	-- Frostwolf Commander's Medal
			},
		},
		AV_2ndAirstrike = {
			value = 10,
			items = {
				[17503] = 1,	-- Frostwolf Lieutenant's Medal
			},
		},
		AV_1stAirstrike = {
			value = 10,
			items = {
				[17502] = 1,	-- Frostwolf Soldier's Medal
			},
		},
	},
	
	-- BG factions
	[FACTION_FROSTWOLF] = {
		AV_RiderHarnesses = {
			value = 1,
			items = {
				[17642] = 1,	-- Alterac Ram Hide
			},
		},
		AV_BossSummon_5 = {
			value = 5,
			items = {
				[17306] = 5,	-- Stormpike Soldier's Blood
			},
		},
		AV_BossSummon_1 = {
			value = 1,
			items = {
				[17306] = 1,	-- Stormpike Soldier's Blood
			},
		},
		AV_ArmorScraps = {
			value = 1,
			items = {
				[17422] = 20,	-- Armor Scraps
			},
		},
		AV_3rdAirstrike = {
			value = 3,
			items = {
				[17328] = 1,	-- Stormpike Commander's Flesh
			},
		},
		AV_2ndAirstrike = {
			value = 2,
			items = {
				[17327] = 1,	-- Stormpike Lieutenant's Flesh
			},
		},
		AV_1stAirstrike = {
			value = 1,
			items = {
				[17326] = 1,	-- Stormpike Soldier's Flesh
			},
		},
	},
	[FACTION_STORMPIKE] = {
		AV_RiderHarnesses = {
			value = 1,
			items = {
				[17643] = 1,	-- Frostwolf Hide
			},
		},
		AV_BossSummon_5 = {
			value = 5,
			items = {
				[17423] = 5,	-- Storm Crystal
			},
		},
		AV_BossSummon_1 = {
			value = 1,
			items = {
				[17423] = 1,	-- Storm Crystal
			},
		},
		AV_ArmorScraps = {
			value = 1,
			items = {
				[17422] = 20,	-- Armor Scraps
			},
		},
		AV_3rdAirstrike = {
			value = 3,
			items = {
				[17504] = 1,	-- Frostwolf Commander's Medal
			},
		},
		AV_2ndAirstrike = {
			value = 2,
			items = {
				[17503] = 1,	-- Frostwolf Lieutenant's Medal
			},
		},
		AV_1stAirstrike = {
			value = 1,
			items = {
				[17502] = 1,	-- Frostwolf Soldier's Medal
			},
		},
	},

	-- Other factions
	[FACTION_DARKMOON] = {
		LW5_RuggedArmorKit = {
			value = 100,
			items = {
				[15564] = 8,	-- Rugged Armor Kit
			},
		},
		LW4_TurtleScaleLeggings = {
			value = 100,
			maxStanding = 4,
			maxValue = 2500, 
			items = {
				[8185] = 1,	-- Turtle Scale Leggings
			},
		},
		LW3_BarbaricHarness = {
			value = 100,
			maxStanding = 4,
			maxValue = 1700, 
			items = {
				[5739] = 3,	-- Barbaric Harness
			},
		},
		LW2_ToughenedLeatherArmor = {
			value = 100,
			maxStanding = 4,
			maxValue = 1100, 
			items = {
				[2314] = 3,	-- Toughened Leather Armor
			},
		},
		LW1_EmbossedLeatherBoots = {
			value = 100,
			maxStanding = 4,
			maxValue = 500, 
			items = {
				[2309] = 3,	-- Embossed Leather Boots
			},
		},

		Junk5_EvilBatEye = {
			value = 100,
			items = {
				[11404] = 10,	-- Evil Bat Eye
			},
		},
		Junk5_GlowingScorpidBlood = {
			value = 100,
			items = {
				[19933] = 10,	-- Glowing Scorpid Blood
			},
		},
		Junk4_VibrantPlume = {
			value = 100,
			maxStanding = 4,
			maxValue = 2500, 
			items = {
				[5117] = 5,		-- Vibrant Plume
			},
		},
		Junk3_SoftBushyTail = {
			value = 100,
			maxStanding = 4,
			maxValue = 1700, 
			items = {
				[4582] = 5,		-- Soft Bushy Tail
			},
		},
		Junk2_TornBearPelt = {
			value = 100,
			maxStanding = 4,
			maxValue = 1100, 
			items = {
				[11407] = 5,	-- Torn Bear Pelt
			},
		},
		Junk1_SmallFurryPaw = {
			value = 100,
			maxStanding = 4,
			maxValue = 500, 
			items = {
				[5134] = 5,		-- Small Furry Paw
			},
		},

		Eng5_ThoriumWidget = {
			value = 100,
			items = {
				[15994] = 6,	-- Thorium Widget
			},
		},
		Eng4_MechanicalRepairKit = {
			value = 100,
			maxStanding = 4,
			maxValue = 2500, 
			items = {
				[11590] = 6,	-- Mechanical Repair Kit
			},
		},
		Eng3_GreenFirework = {
			value = 100,
			maxStanding = 4,
			maxValue = 1700, 
			items = {
				[9313] = 36,	-- Green Firework
			},
		},
		Eng2_WhirringBronzeGizmo = {
			value = 100,
			maxStanding = 4,
			maxValue = 1100, 
			items = {
				[4375] = 7,		-- Whirring Bronzze Gizmo
			},
		},
		Eng1_CopperModulator = {
			value = 100,
			maxStanding = 4,
			maxValue = 500, 
			items = {
				[4363] = 5,		-- Copper Modulator
			},
		},

		BS5_DenseGrindingStone = {
			value = 100,
			items = {
				[12644] = 8,	-- Dense Grinding Stone
			},
		},
		BS4_BigBlackMace = {
			value = 100,
			maxStanding = 4,
			maxValue = 2500, 
			items = {
				[7945] = 1,		-- Big Black Mace
			},
		},
		BS3_GreenIronBracers = {
			value = 100,
			maxStanding = 4,
			maxValue = 1700, 
			items = {
				[3835] = 3,		-- Green Iron Bracers
			},
		},
		BS2_HeavyGrindingStone = {
			value = 100,
			maxStanding = 4,
			maxValue = 1100, 
			items = {
				[3486] = 7,		-- Heavy Grinding Stone
			},
		},
		BS1_CoarseWeightstone = {
			value = 100,
			maxStanding = 4,
			maxValue = 500, 
			items = {
				[3240] = 10,	-- Coarse Weightstone
			},
		},
	},
	[FACTION_ZANDALAR] = {
		Coins_ZulianRazzashiHakkari = {
			creates = {
				[19858] = 1,	-- Zandalar Honor Token
			},
			value = 25,
			items = {
				[19698] = 1,	-- Zulian Coin
				[19699] = 1,	-- Razzashi Coin
				[19700] = 1,	-- Hakkari Coin
			},
		},
		Coins_GurubashiVilebranchWitherbark = {
			creates = {
				[19858] = 1,	-- Zandalar Honor Token
			},
			value = 25,
			items = {
				[19701] = 1,	-- Gurubashi Coin
				[19702] = 1,	-- Vilebranch Coin
				[19703] = 1,	-- Witherbark Coin
			},
		},
		Coins_SandfurySkullsplitterBloodscalp = {
			creates = {
				[19858] = 1,	-- Zandalar Honor Token
			},
			value = 25,
			items = {
				[19704] = 1,	-- Sandfury Coin
				[19705] = 1,	-- Skullsplitter Coin
				[19706] = 1,	-- Bloodscalp Coin
			},
		},
		
		Bijou_Red = {
			creates = {
				[19858] = 1,	-- Zandalar Honor Token
			},
			value = 75,
			items = {
				[19707] = 1,		-- Red Hakkari Bijou
			},
		},
		Bijou_Blue = {
			creates = {
				[19858] = 1,	-- Zandalar Honor Token
			},
			value = 75,
			items = {
				[19708] = 1,		-- Blue Hakkari Bijou
			},
		},
		Bijou_Yellow = {
			creates = {
				[19858] = 1,	-- Zandalar Honor Token
			},
			value = 75,
			items = {
				[19709] = 1,		-- Yellow Hakkari Bijou
			},
		},
		Bijou_Orange = {
			creates = {
				[19858] = 1,	-- Zandalar Honor Token
			},
			value = 75,
			items = {
				[19710] = 1,		-- Orange Hakkari Bijou
			},
		},
		Bijou_Green = {
			creates = {
				[19858] = 1,	-- Zandalar Honor Token
			},
			value = 75,
			items = {
				[19711] = 1,		-- Green Hakkari Bijou
			},
		},
		Bijou_Purple = {
			creates = {
				[19858] = 1,	-- Zandalar Honor Token
			},
			value = 75,
			items = {
				[19712] = 1,		-- Purple Hakkari Bijou
			},
		},
		Bijou_Bronze = {
			creates = {
				[19858] = 1,	-- Zandalar Honor Token
			},
			value = 75,
			items = {
				[19713] = 1,		-- Bronze Hakkari Bijou
			},
		},
		Bijou_Silver = {
			creates = {
				[19858] = 1,	-- Zandalar Honor Token
			},
			value = 75,
			items = {
				[19714] = 1,		-- Silver Hakkari Bijou
			},
		},
		Bijou_Gold = {
			creates = {
				[19858] = 1,	-- Zandalar Honor Token
			},
			value = 75,
			items = {
				[19715] = 1,		-- Gold Hakkari Bijou
			},
		},

		A_HonorTokens = {
			value = 50,
			useItem = 1,
			items = {
				[19858] = 1,	-- Zandalar Honor Token
			},
		},
	},
	[FACTION_BROOD_NOZDORMU] = {
		MortalChampions = {
			value = 500,
			items = {
				[21229] = 1,	-- Qiraji Lord's Insignia
			},
		},
		SecretsOfTheQiraji = {
			value = 1000,
			items = {
				[21230] = 1,	-- Ancient Qiraji Artifact
			},
		},
	},
	[FACTION_CENARION_CIRCLE] = {
		_MortalChampions = {
			value = 200,
			items = {
				[21229] = 1,	-- Qiraji Lord's Insignia
			},
		},

		TwilightTexts = {
			value = 500,
			items = {
				[20404] = 10,	-- Encrypted Twilight Text
			},
		},

		Abyssal3_Scepters = {
			value = 300,		-- TODO: Needs verification post-2.2
			items = {
				[20515] = 3,	-- Abyssal Scepter
			},
		},
		Abyssal2_Signets = {
			value = 500,
			items = {
				[20514] = 3,	-- Abyssal Signet
			},
		},
		Abyssal1_Crests = {
			value = 150,
			items = {
				[20513] = 3,	-- Abyssal Crest
			},
		},
	},
	[FACTION_ARGENT_DAWN] = {
		UseHealthyDragonScale = {
			value = 150,
			items = {
				[13920] = 1,	-- Healthy Dragon Scale
			},
		},

		Scourgestones_3_Corruptors = {
			creates = {
				[12844] = 1,	-- Argent Dawn Valor Token
			},
			value = 50,
			items = {
				[12843] = 1,	-- Corruptor's Scourgestone
			},
		},
		Scourgestones_2_Invaders = {
			creates = {
				[12844] = 1,	-- Argent Dawn Valor Token
			},
			value = 50,
			items = {
				[12841] = 10,	-- Invader's Scourgestone
			},
		},
		Scourgestones_1_Minions = {
			creates = {
				[12844] = 1,	-- Argent Dawn Valor Token
			},
			value = 50,
			items = {
				[12840] = 20,	-- Minion's Scourgestone
			},
		},

		Insignia_CryptFiendParts = {
			value = 20,
			minStanding = 5,
			items = {
				[22525] = 30,	-- Crypt Fiend Parts
			},
		},
		Insignia_BoneFragments = {
			value = 20,
			minStanding = 5,
			items = {
				[22526] = 30,	-- Bone Fragments
			},
		},
		Insignia_CoresOfElements = {
			value = 20,
			minStanding = 5,
			items = {
				[22527] = 30,	-- Core of Elements
			},
		},
		Insignia_DarkIronScraps = {
			value = 20,
			minStanding = 5,
			items = {
				[22528] = 30,	-- Dark Iron Scraps
			},
		},
		Insignia_SavageFronds = {
			value = 20,
			minStanding = 5,
			items = {
				[22529] = 30,	-- Savage Frond
			},
		},

		Cauldron3_FelstoneField = {
			value = 50,
			note = FFF_CAULDRON,
			items = {
				[13357] = 6,	-- Osseous Agitator
				[14047] = 4,	-- Runecloth
			},
		},
		Cauldron2_WrithingHaunt_or_DalsonsTears = {
			value = 50,
			note = FFF_CAULDRON,
			items = {
				[13356] = 5,	-- Somatic Intensifier
				[14047] = 4,	-- Runecloth
			},
		},
		Cauldron1_GahrronsWithering = {
			value = 50,
			note = FFF_CAULDRON,
			items = {
				[13354] = 4,	-- Ectoplasmic Resonator
				[14047] = 4,	-- Runecloth
			},
		},

		A_ValorTokens = {
			value = 100,
			useItem = 1,
			items = {
				[12844] = 1,	-- Argent Dawn Valor Token
			},
		},
	},
	[FACTION_TIMBERMAW] = {
		Totem_Winterfall = {
			value = 700,		-- TODO: Needs verification post-2.2
			minStanding = 4, 
			items = {
				[20742] = 1,	-- Winterfall Ritual Totem
			},
		},
		Totem_Deadwood = {
			value = 700,		-- TODO: Needs verification post-2.2
			minStanding = 4, 
			items = {
				[20741] = 1,	-- Deadwood Ritual Totem
			},
		},
		Feathers_Deadwood = {
			value = 150,
			items = {
				[21377] = 5,	-- Deadwood Headdress Feather
			},
		},
		Beads_Winterfall = {
			value = 150,
			items = {
				[21383] = 5,	-- Winterfall Spirit Beads
			},
		},
	},
	[FACTION_THORIUM_BROTHERHOOD] = {
		FieryFluxLeather = {
			value = 25,
			minStanding = 4,
			maxStanding = 4, 
			items = {
				[4234] = 10,	-- Heavy Leather
				[18944] = 2,	-- Incendosaur Scale
			},
		},
		FieryFluxKingsblood = {
			value = 25,
			minStanding = 4,
			maxStanding = 4, 
			items = {
				[3356] = 4,		-- Kingsblood
				[18944] = 2,	-- Incendosaur Scale
			},
		},
		FieryFluxIron = {
			value = 25,
			minStanding = 4,
			maxStanding = 4, 
			items = {
				[3575] = 4,		-- Iron Bar
				[18944] = 2,	-- Incendosaur Scale
			},
		},
		DarkIronResidue = {
			value = 25,
			minStanding = 5,
			maxStanding = 5, 
			items = {
				[18945] = 4,	-- Dark Iron Residue
			},
		},
		DarkIronOre = {
			value = 75,
			items = {
				[11370] = 10,	-- Dark Iron Ore
			},
		},
		CoreLeather = {
			value = 300,
			items = {
				[17012] = 2,	-- Core Leather
			},
		},
		FieryCore = {
			value = 300,
			items = {
				[17010] = 1,	-- Fiery Core
			},
		},
		LavaCore = {
			value = 300,
			items = {
				[17011] = 1,	-- Lava Core
			},
		},
		BloodOfTheMountain = {
			value = 300,
			items = {
				[11382] = 1,	-- Blood of the Mountain
			},
		},
	},
	[FACTION_GADGETZAN] = {
		WaterPouchBounty = {
			value = 10,
			items = {
				[8483] = 5,	-- Wastewander Water Pouch
			},
		},
	},

	-- Burning Crusade factions
	[FACTION_BELF] = {
		Runecloth = {
			value = 50,
			items = {
				[14047] = 20,	-- Runecloth
			},
		},

		-- AQ war effort turnins
		CommendationSignet_10 = {
			value = 150,
			items = {
				[21438] = 10,	-- Horde Commendation Signet
			},
		},
		CommendationSignet_01 = {
			value = 5,
			items = {
				[21438] = 1,	-- Horde Commendation Signet
			},
		},
	},
	[FACTION_DRAENEI] = {
		Runecloth = {
			value = 50,
			items = {
				[14047] = 20,	-- Runecloth
			},
		},

		-- AQ war effort turnins
		CommendationSignet_10 = {
			value = 150,
			items = {
				[21436] = 10,	-- Alliance Commendation Signet
			},
		},
		CommendationSignet_01 = {
			value = 5,
			items = {
				[21436] = 1,	-- Alliance Commendation Signet
			},
		},
	},

	[FACTION_CONSORTIUM] = {
		Prisons2_AThousandWorlds = {
			value = 500,
			minStanding = 7, 
			items = {
				[29460] = 5,	-- Ethereum Prison Key
			},
		},
		Prisons1_EthereumSecrets = {
			value = 250,
			minStanding = 6, 
			items = {
				[31957] = 1,	-- Ethereum Prisoner I.D. Tag
			},
		},
		Netherstorm_HeapOfEtherials = {
			value = 250,
			minStanding = 5, 
			items = {
				[29209] = 10,	-- Zaxxis Insignia
			},
		},
		Nagrand_Warbeads = {
			value = 250,
			minStanding = 5, 
			items = {
				[25433] = 10,	-- Obsidian Warbeads
			},
		},
		IvoryTusks = {
			value = 250,
			minStanding = 4, 
			maxStanding = 4, 
			items = {
				[25463] = 3,	-- Pair of Ivory Tusks
			},
		},
		CrystalFragments = {
			value = 250,
			minStanding = 4, 
			maxStanding = 4, 
			items = {
				[25433] = 10,	-- Oshu'gun Crystal Fragment
			},
		},
	},
	[FACTION_MAGHAR] = {
		Warbeads = {
			value = 500,
			minStanding = 4, 
			items = {
				[25433] = 10,	-- Obsidian Warbeads
			},
		},
	},
	[FACTION_KURENAI] = {
		Warbeads = {
			value = 500,
			minStanding = 4, 
			items = {
				[25433] = 10,	-- Obsidian Warbeads
			},
		},
	},
	[FACTION_CENARION_EXPEDITION] = {
		Junk_IdentifyPlantParts = {
			value = 250,
			minStanding = 4, 
			maxStanding = 5, 
			items = {
				[24401] = 10,	-- Unidentified Plant Parts
			},
		},
		Junk_UncataloguedSpecies = {
			value = 500,
			minStanding = 4, 
			items = {
				[24407] = 1,	-- Uncatalogued Species
			},
		},
		
		CoilfangArmaments = {
			value = 75,
			minStanding = 4, 
			items = {
				[24368] = 1,	-- Coilfang Armaments
			},
		},
	},
	[FACTION_SPOREGGAR] = {
		Part3_BringMeAShrubbery = {
			value = 750,
			minStanding = 5, 
			items = {
				[24246] = 5,	-- Sanguine Hibiscus
			},
		},
		Part2_Glowcaps = {
			value = 750,
			minStanding = 4, 
			maxStanding = 4, 
			items = {
				[24245] = 10,	-- Glowcap
			},
		},
		Part2_FertileSpores = {
			value = 750,
			minStanding = 4, 
			items = {
				[24449] = 10,	-- Fertile Spores
			},
		},
		Part1_Tendrils = {
			value = 750,
			maxStanding = 4, 
			items = {
				[24291] = 6,	-- Bog Lord Tendril
			},
		},
		Part1_SporeSacs = {
			value = 750,
			maxStanding = 4, 
			items = {
				[24290] = 10,	-- Mature Spore Sac
			},
		},
	},
	[FACTION_ALDOR] = {
		Unfriendly_VenomSacs = {
			value = 250,
			maxStanding = 3, 
			items = {
				[25802] = 8,	-- Dreadfang Venom Sac
			},
		},
		MarksOfSargeras_10 = {
			value = 250,
			minStanding = 5, 
			items = {
				[30809] = 10,	-- Mark of Sargeras
			},
		},
		MarksOfSargeras_01 = {
			value = 25,
			minStanding = 5, 
			items = {
				[30809] = 1,	-- Mark of Sargeras
			},
		},
		MarksOfKiljaeden_10 = {
			value = 250,
			minStanding = 4, 
			maxStanding = 5,
			items = {
				[29425] = 10,	-- Mark of Kil'jaeden
			},
		},
		MarksOfKiljaeden_01 = {
			value = 25,
			minStanding = 4,
			maxStanding = 5,
			items = {
				[29425] = 1,	-- Mark of Kil'jaeden
			},
		},
		FelArmament = {
			value = 350,
			minStanding = 5, 
			items = {
				[29740] = 1,	-- Fel Armament
			},
		},
	},
	[FACTION_SCRYER] = {
		Unfriendly_BasiliskEyes = {
			value = 250,
			maxStanding = 3, 
			items = {
				[25744] = 8,	-- Dampscale Basilisk Eye
			},
		},		
		SunfurySignet_10 = {
			value = 250,
			minStanding = 5, 
			items = {
				[30810] = 10,	-- Sunfury Signet
			},
		},
		SunfurySignet_01 = {
			value = 25,
			minStanding = 5, 
			items = {
				[30810] = 1,	-- Sunfury Signet
			},
		},
		FirewingSignet_10 = {
			value = 250,
			minStanding = 4, 
			maxStanding = 5,
			items = {
				[29426] = 10,	-- Firewing Signet
			},
		},
		FirewingSignet_01 = {
			value = 25,
			minStanding = 4, 
			maxStanding = 5,
			items = {
				[29426] = 1,	-- Firewing Signet
			},
		},
		ArcaneTome = {
			value = 350,
			minStanding = 5, 
			items = {
				[29739] = 1,	-- Arcane Tome
			},
		},
	},
	[FACTION_LOWER_CITY] = {
		ArakkoaFeathers = {
			value = 250,
			minStanding = 4, 
			maxStanding = 5, 
			items = {
				[25719] = 30,	-- Arakkoa Feather
			},
		},
	},
	[FACTION_NETHERWING] = {
		GreatEggHunt = {
			value = 250,
			minStanding = 4, 
			items = {
				[32506] = 1,	-- Netherwing Egg
			},
		},
	},
	[FACTION_SKYGUARD] = {
		ElixirOfShadows = {
			value = 75,
			minStanding = 4, 
			items = {
				[32388] = 6,	-- Shadow Dust
			},
		},
	},

	[FACTION_SHATAR] = {
		Scryer_ArcaneTome = {
			value = 175,
			maxStanding = 5,
			otherFactionRequired = {
				faction = FACTION_SCRYER,
				minStanding = 5,
			},
			items = {
				[29739] = 1,	-- Arcane Tome
			},
		},
		Scryer_SunfurySignet_10 = {
			value = 125,
			maxStanding = 5,
			otherFactionRequired = {
				faction = FACTION_SCRYER,
				minStanding = 5,
			},
			items = {
				[30810] = 10,	-- Sunfury Signet
			},
		},
		Scryer_FirewingSignet_10 = {
			value = 125,
			maxStanding = 5,
			otherFactionRequired = {
				faction = FACTION_SCRYER,
				minStanding = 4, 
				maxStanding = 5,
			},
			items = {
				[29426] = 10,	-- Firewing Signet
			},
		},

		Aldor_FelArmament = {
			value = 175,
			maxStanding = 5,
			otherFactionRequired = {
				faction = FACTION_ALDOR,
				minStanding = 5,
			},
			items = {
				[29740] = 1,	-- Fel Armament
			},
		},
		Aldor_MarksOfSargeras_10 = {
			value = 125,
			maxStanding = 5,
			otherFactionRequired = {
				faction = FACTION_ALDOR,
				minStanding = 5,
			},
			items = {
				[30809] = 10,	-- Mark of Sargeras
			},
		},
		Aldor_MarksOfKiljaeden_10 = {
			value = 125,
			maxStanding = 5,
			otherFactionRequired = {
				faction = FACTION_ALDOR,
				minStanding = 4, 
				maxStanding = 5,
			},
			items = {
				[29425] = 10,	-- Mark of Kil'jaeden
			},
		},
	},

};



