--[[
flagRSP2 - Alexia E. Smith - http://www.nonamestudios.com/flagRSP2.php
Idea contributions by ClemSnide and Vastare(Feathermoon.).

With some code from:
flagRSP 0.5.6 - Florian Kruse - http://flokru.org/flagrsp/
AF_Tooltip Mini -  AquaFlare7 and devFreak - http://afstudios.net/
TinyTip - Thrae of Maelstrom (aka "Matthew Carras")
]]--

--Ace2 Intialization
local Tablet = AceLibrary("Tablet-2.0")
flagRSP2 = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceDB-2.0", "AceEvent-2.0", "AceHook-2.1", "FuBarPlugin-2.0")
flagRSP2:RegisterChatCommand("/flagrsp", "/rsp")
flagRSP2:RegisterDB("flagRSP2FuDB")

--Variable Declaration
local name = "FlagRSP2";
frspversion = "1.5.2";
local textsendupdate = 0;
local descupdate = 0;
local dpcooldown = 0;
local rName = GetRealmName();
local pName = UnitName("player");
local cttip = "";
local nttip = "";
local rspcombat = 0;
rspsendbuffer = {};
local difftime = 0;
local polledtime = 0;
local lasttime = 0;
local i = 0;

--Functions
function flagRSP2:OnTextUpdate()
    if self:IsTextShown() then
        self:SetText("flagRSP2")
    end
    if not self:IsIconShown() then
        self:HideIcon()
    end
end

function flagRSP2:OnClick()
	if (IsShiftKeyDown()) then
		flagRSP2SetClearView()
	elseif (IsControlKeyDown()) then
		name = UnitName("target");
		if (FlagList[rName][name] ~= nil) then
			if (FlagList[rName][name]["HideDesc"] == nil) then
				FlagList[rName][name]["HideDesc"] = 1;
				DEFAULT_CHAT_FRAME:AddMessage("|cffB100DD" .. name .. FLAGRSP2_LUA_DESCSHOW);
			elseif (FlagList[rName][name]["HideDesc"] == 1) then
				FlagList[rName][name]["HideDesc"] = 0;
				DEFAULT_CHAT_FRAME:AddMessage("|cffB100DD" .. name .. FLAGRSP2_LUA_DESCSHOW);
			else
				FlagList[rName][name]["HideDesc"] = 1;
				DEFAULT_CHAT_FRAME:AddMessage("|cffB100DD" .. name .. FLAGRSP2_LUA_DESCHIDE);
			end
		end
	else
		if (flagRSP2Player_Frame:IsVisible() or flagRSP2Options_Frame:IsVisible() or flagRSP2Tooltip_Frame:IsVisible() or flagRSP2Viewer_Frame:IsVisible()) then
			if not (flagRSP2Player_Frame:IsVisible()) then
				frameTop = (GetScreenHeight() - getglobal(currentwindow):GetTop()) * -1;
				flagRSP2Player_Frame:SetPoint("TOPLEFT", UIParent, "TOPLEFT", getglobal(currentwindow):GetLeft(), frameTop);
			end
			flagRSP2Player_Frame:Hide();
			flagRSP2Options_Frame:Hide();
			flagRSP2Tooltip_Frame:Hide();
			flagRSP2Viewer_Frame:Hide();
		else
			flagRSP2Player_Frame:Show();
		end
	end
end

function flagRSP2:OnTooltipUpdate()
	local cat = Tablet:AddCategory(
		'columns', 1,
		'child_textR', 1,
		'child_textG', 1,
		'child_textB', 1
	)
	cat:AddLine(
		'text', FLAGRSP2_MM_TOOLTIP
	)
end

function flagRSP2:OnInitialize()
	FRSPLOADED = 0;
	flagRSP2Options_Initialize()
    currenttime = time();

	flagRSP2_Frame:Show();
	
	if (cid == 0) then 
		JoinChannelByName("xtensionxtooltip2", "", -1);
		cidd = GetChannelName("xtensionxtooltip2");
	end

	self.hasIcon = true
    self:SetIcon(true)
end

function flagRSP2:OnEnable()
	flagRSP2HookOnTooltipSetUnit(GameTooltip, aftt_format, 1);
    self:RegisterEvent("UPDATE_MOUSEOVER_UNIT");
	self:RegisterEvent("CHAT_MSG_CHANNEL");
	self:RegisterEvent("PLAYER_TARGET_CHANGED");
	self:RegisterEvent("PLAYER_REGEN_DISABLED");
	self:RegisterEvent("PLAYER_REGEN_ENABLED");
end

function flagRSP2:OnDisable()
	flagRSP2UnhookOnTooltipSetUnit(GameTooltip, aftt_format, 1);
	self:UnregisterEvent("UPDATE_MOUSEOVER_UNIT");
	self:UnregisterEvent("CHAT_MSG_CHANNEL");
	self:UnregisterEvent("PLAYER_TARGET_CHANGED");
	self:UnregisterEvent("PLAYER_REGEN_DISABLED");
	self:UnregisterEvent("PLAYER_REGEN_ENABLED");
end

function flagRSP2:CHAT_MSG_CHANNEL()
	if string.lower(arg9) == string.lower("xtensionxtooltip2") then
		--The DRUNK ...hic! code.
		sober = string.gsub(arg1, " ...hic!", "");
		flaggedChanHandle(sober, arg2);
	end
	cid, cname = GetChannelName("xtensionxtooltip2");
	if (cid == 0) then
		JoinChannelByName("xtensionxtooltip2", "", -1);
		cidd = GetChannelName("xtensionxtooltip2");
	end
end

function flagRSP2:PLAYER_TARGET_CHANGED()
	cName = UnitName("target");
	if (cName == nil and PlayerFlags[rName][pName]["flagRSP2OptionsStickyDescCheck"] == 0) then
		flagRSP2Info_Frame:Hide();
		flagRSP2Gametooltip_Frame:Hide();
	end
	if (FlagList[rName][cName] ~= nil and UnitIsPlayer("target")) then
		if (PlayerFlags[rName][pName]["flagRSP2OptionsTargetDescCheck"] == 1) then
			popup_desc(cName);
		end
	else
		if (PlayerFlags[rName][pName]["flagRSP2OptionsStickyDescCheck"] == 0) then
			flagRSP2Info_Frame:Hide();
			flagRSP2Gametooltip_Frame:Hide();
		end
	end
end

function flagRSP2:PLAYER_REGEN_DISABLED()
	if (FRSPLOADED == 1) then
		if (PlayerFlags[rName][pName]["flagRSP2OptionsHideCombatCheck"] == 1) then
			rspcombat = 1;
			flagRSP2Info_Frame:Hide();
		else
			rspcombat = 0;
		end
	end
end

function flagRSP2:PLAYER_REGEN_ENABLED()
	if (FRSPLOADED == 1) then
		if (PlayerFlags[rName][pName]["flagRSP2OptionsHideCombatCheck"] == 1) then
			rspcombat = 0;
		else
			rspcombat = 0;
		end
	end
end

function flagRSP2:UPDATE_MOUSEOVER_UNIT()
	newtime = time();
	temptime = currenttime + 300;
	if (newtime >= temptime) then
		currenttime = newtime;
		flagRSP2AdvOptions_Update("timedupdate");
		dpcooldown = 0;
	end
end

function flagRSP2:GetMessage()
    return self.message
end

function flagRSP2:SetMessage(newValue)
    self.message = newValue
end


function flagRSP2_SlashCommandHandler(cmd)
	if (cmd == "" or cmd == nil) then
		flagRSP2Minimap_Clicked();
	end
	if (cmd == "cv") then
		flagRSP2SetClearView();
	end
end

function flagRSP2GameTooltipUpdate()
	flagRSP2Gametooltip_Frame:SetAlpha(GameTooltip:GetAlpha());
	nttip = GameTooltipTextLeft1:GetText();
	if (nttip == nil) then
		cttip = nttip;
	elseif (nttip ~= cttip) then
		cttip = nttip;
	end
	if (not GameTooltip:IsShown() or not GameTooltip:IsVisible() or not GameTooltip:GetUnit()) then
		flagRSP2Gametooltip_Frame:Hide();
	end
end

function aftt_format(unit, name, realm, isPlayer, isPlayerOrPet, isDead)
--CODING MINE FIELD - Clean up in progress!
	cName = UnitName(unit);
	--Use the enhanced colorful tooltip or the default one?
	if (PlayerFlags[rName][pName]["flagRSP2TooltipLightModeCheck"] == 0) then
		if (UnitRace(unit) and UnitIsPlayer(unit)) then
			--race, it is a player
				aftt_text_race = UnitRace(unit);
		elseif (UnitPlayerControlled(unit)) then
			--creature family, its is a pet
				aftt_text_race = UnitCreatureFamily(unit);
				aftt_color_race = aftt_color_race_mob;
		else
			--creature type, it is a mob
				if (UnitCreatureType(unit) == "Not specified") then
					aftt_text_race = ""
					aftt_color_race = aftt_color_race_mob;
				else
					aftt_text_race = UnitCreatureType(unit);
					aftt_color_race = aftt_color_race_mob;
				end
		end
		if (aftt_text_race == nil) then
			aftt_text_race = ("");
		else
			aftt_text_race = (aftt_text_race .. " ");
		end
			aftt_color_race = "FFFFFF";

		if (UnitClass(unit) and UnitIsPlayer(unit)) then
			aftt_text_class = (UnitClass(unit) .. " ");
			if (UnitClass(unit) == "Mage") then
				aftt_color_class = "69CCF0";
			elseif (UnitClass(unit) == "Warlock") then
				aftt_color_class = "9482CA";
			elseif (UnitClass(unit) == "Priest") then
				aftt_color_class = "CCCCCC";
			elseif (UnitClass(unit) == "Druid") then
				aftt_color_class = "FF7D0A";
			elseif (UnitClass(unit) == "Shaman") then
				aftt_color_class = "2459FF";
			elseif (UnitClass(unit) == "Paladin") then
				aftt_color_class = "F58CBA";
			elseif (UnitClass(unit) == "Rogue") then
				aftt_color_class = "FFF569";
			elseif (UnitClass(unit) == "Hunter") then
				aftt_color_class = "ABD473";
			elseif (UnitClass(unit) == "Warrior") then
				aftt_color_class = "C79C6E";
			else
				aftt_color_class = "FFFFFF";
			end
		else
			aftt_text_class = "";
			aftt_color_class = "FFFFFF";
		end

		if (UnitClassification(unit) and UnitClassification(unit) ~= "normal" and UnitHealth(unit) > 0) then
			if (UnitClassification(unit) == "elite") then
				aftt_text_elite = ("(Elite)");
				aftt_color_elite = "FFCC00";
			elseif (UnitClassification(unit) == "worldboss") then
				aftt_text_elite = ("(Boss)");
				aftt_color_elite = "FF0000";
			elseif (UnitClassification(unit) == "rare") then
				aftt_text_elite = ("(Rare)");
				aftt_color_elite = "FF66FF";
			elseif (UnitClassification(unit) == "rareelite") then
				aftt_text_elite = ("(Rare Elite)");
				aftt_color_elite = "FFAAFF";
			else
				aftt_text_elite = ("(" .. UnitClassification(unit) .. ")");
				aftt_color_elite = "FFFFFF";
			end
		else
			aftt_text_elite = "";
			aftt_color_elite = "FFFFFF";
		end

		if (UnitPlayerControlled(unit)) then
			if (UnitCanAttack(unit, "player") and UnitCanAttack("player", unit)) then
				--red, hostile, both can attack
					GameTooltip:SetBackdropColor(0.5, 0.0, 0.0);
					aftt_color_name = "FF0000";
					aftt_color_description = "DD0000";
					aftt_text_reaction = "Hostile";
			elseif (not UnitCanAttack(unit, "player") and UnitCanAttack("player", unit)) then
				--yellow, neutral, only I can attack
					GameTooltip:SetBackdropColor(0.5, 0.5, 0.0);
					aftt_color_name = "FFFF00";
					aftt_color_description = "CCCC00";
					aftt_text_reaction = "Neutral";
			elseif (UnitCanAttack(unit, "player") and not UnitCanAttack("player", unit)) then
				--purple, caution, only they can attack
					GameTooltip:SetBackdropColor(0.5, 0.0, 0.5);
					aftt_color_name = "FF66FF";
					aftt_color_description = "BB55BB";
					aftt_text_reaction = "Caution";
			elseif (not UnitCanAttack(unit, "player") and not UnitCanAttack("player", unit)) then
				if (UnitIsPVP(unit)) then
					--green, friendly pvp, neither can attack
						GameTooltip:SetBackdropColor(0.0, 0.0, 0.5);
						aftt_color_name = "00FF00";
						aftt_color_description = "00AA00";
						aftt_text_reaction = "Friendly";
				else
					--blue, friendly, neither can attack
						GameTooltip:SetBackdropColor(0, 0, 0.5);
						aftt_color_name = "00AAFF";
						aftt_color_description = "0088FF";
						aftt_text_reaction = "Friendly";
				end
			end
		elseif (UnitReaction(unit, "player") and UnitReaction(unit, "player") <= 3) then
			--red, they are hostile
				GameTooltip:SetBackdropColor(0, 0, 0);
				aftt_color_name = "FF0000";
				aftt_text_reaction = "Hostile";
				aftt_color_description = "DD0000";
		elseif (UnitReaction(unit, "player") and UnitReaction(unit, "player") == 4) then
			--yellow, they are neutral
				GameTooltip:SetBackdropColor(0, 0, 0);
				aftt_color_name = "FFFF00";
				aftt_text_reaction = "Neutral";
				aftt_color_description = "CCCC00";
		else
			if (UnitIsPVP(unit)) then
				--green, pvp enabled friend
					GameTooltip:SetBackdropColor(0, 0, 0);
					aftt_color_name = "00FF00";
					aftt_color_description = "00AA00";
			else
				--blue, they are friendly
					GameTooltip:SetBackdropColor(0, 0, 0);
					aftt_color_name = "00AAFF";
					aftt_color_description = "0088FF";
			end
			aftt_text_reaction = "Friendly";
		end

		if (UnitIsTapped(unit)and (not UnitIsTappedByPlayer(unit))) then
			aftt_color_name = "888888";
			aftt_color_description = "888888";
			aftt_text_reaction = "Tapped";
		elseif (UnitIsTappedByPlayer(unit)) then
			GameTooltip:SetBackdropColor(0, 0, 0);
			aftt_color_name = "FF0000";
			aftt_color_description = "DD0000";
			aftt_text_reaction = "Hostile";
		end

		if (UnitLevel(unit) and UnitLevel(unit) >= 1) then
			aftt_text_level = UnitLevel(unit);
		else
			aftt_text_level = "??";
		end
		aftt_text_level = ("Level " .. aftt_text_level .. " ");
		local levelDiff = UnitLevel(unit) - UnitLevel("player");
		if (UnitFactionGroup(unit) ~= UnitFactionGroup("player")) then
			if ( levelDiff >= 5 or UnitLevel(unit) == -1) then
				aftt_color_level = "FF0000";
			elseif ( levelDiff >= 3 ) then
				aftt_color_level = "FF6600";
			elseif ( levelDiff >= -2 ) then
				aftt_color_level = "FFFF00";
			elseif ( -levelDiff <= GetQuestGreenRange() ) then
				aftt_color_level = "00FF00";
			else
				aftt_color_level = "888888";
			end
		else
				aftt_color_level = "FFCC00";			
		end

		if (UnitHealth(unit) == 0) then
			aftt_text_corpse = "Corpse";
			aftt_color_class = "888888";
			aftt_color_race = "888888";
			aftt_color_elite = "888888";
			aftt_color_name = "888888";
			aftt_color_description = "888888";
			aftt_color_level = "888888";
		else
			aftt_text_corpse = "";
		end
		--I love if then.
		if (PlayerFlags[rName][pName]["flagRSP2TooltipShowAddNameCheck"] ==1 and FlagList[rName][cName] ~= nil and ((FlagList[rName][cName]["AN1"] ~= nil and FlagList[rName][cName]["AN1"] ~= "") or (FlagList[rName][cName]["AN3"] ~= nil and FlagList[rName][cName]["AN3"] ~= "")) and UnitIsPlayer(unit)) then
			if (FlagList[rName][cName]["AN1"] ~= nil and FlagList[rName][cName]["AN1"] ~= "") then
				nametext = "|cff" .. aftt_color_name .. FlagList[rName][cName]["AN1"] .. " " .. UnitName(unit) .. " " .. FlagList[rName][cName]["AN3"] .. "|r"
			else
				nametext = "|cff" .. aftt_color_name .. UnitName(unit) .. " " .. FlagList[rName][cName]["AN3"] .. "|r"
			end
		elseif(UnitName(unit)) then
			nametext = "|cff" .. aftt_color_name .. UnitName(unit) .. "|r"
		end

		local levelLine, matched;
		if (GameTooltipTextLeft2:GetText() == nil) then
			GameTooltip:Hide();
		else
			levelLine, matched = string.gsub(GameTooltipTextLeft2:GetText(), (FLAGRSP2_LUA_LEVELFINDER), "");
			if (matched == 1) then
				levelLine = 2;
			else
				if (GameTooltipTextLeft3:GetText()) then
					levelLine, matched = string.gsub(GameTooltipTextLeft3:GetText(), (FLAGRSP2_LUA_LEVELFINDER), "");
					if (matched == 1) then
						levelLine = 3;
					else
						levelLine = nil;
					end
				else
					levelLine = nil;
				end
			end
		end
		
		leveltext = "|cff" .. aftt_color_level .. aftt_text_level .. "|r" .. "|cff" .. aftt_color_race .. aftt_text_race .. "|r" .. "|cff" .. aftt_color_class .. aftt_text_class .. "|r" .. "|cff" .. aftt_color_elite .. aftt_text_elite .. "|r" .. "|cff888888" .. aftt_text_corpse .. "|r"
		if (levelLine) then
			--At this point, they MAY not a player.  It does not matter since the tool tip will be recleared for players any way since there is no extra information to grab.
			--NPC with description.
			if (levelLine == 3 and UnitIsPlayer(unit) == nil) then
				NPCDESC = GameTooltipTextLeft2:GetText();
				GameTooltipTextLeft1:SetText(nametext);
				GameTooltipTextLeft2:SetText("|cff" .. aftt_color_description .. NPCDESC .. "|r");
				GameTooltipTextLeft3:SetText(leveltext);
			end
			--NPC, but no NPC description.
			if (levelLine == 2 and UnitIsPlayer(unit) == nil) then
				GameTooltipTextLeft1:SetText(nametext);
				GameTooltipTextLeft2:SetText(leveltext);
			end
		end

		--Playing with the GameTooltip is a very messy process.  This is around the third or fourth revision of the code to modify the tooltip.
		--Handles both users of FlagRSP2 and non-users.
		if (UnitIsPlayer(unit)) then
			GTTNL = 0;
			GTTTable = {};
			--Display description frame on targeting the player if the character has a profile.
			if (FlagList[rName][cName] ~= nil and PlayerFlags[rName][pName]["flagRSP2OptionsTargetDescCheck"] == 0) then
				popup_desc(cName);
			end
			GameTooltipTextLeft1:SetText(nametext);
			--Character Name
			GTTNL = 1;
			GTTTable[GTTNL] = nametext;
			--Title with cheesy check.
			if (FlagList[rName][cName] ~= nil) then
				if (FlagList[rName][cName]["Title"] ~= nil and FlagList[rName][cName]["Title"] ~= "" and PlayerFlags[rName][pName]["flagRSP2TooltipShowTitleCheck"] == 1) then
					GTTNL = GTTNL + 1;
					local titletext = FlagList[rName][cName]["Title"];
					if (PlayerFlags[rName][pName]["flagRSP2OptionsWordLimitCheck"] == 1) then
						words = 0;
						strstart = 0;
						strend = 0;
						for i = 1, string.len(FlagList[rName][cName]["Title"]) do
							if (string.find(FlagList[rName][cName]["Title"], " ", strstart) ~= nil) then
								strstart = string.find(FlagList[rName][cName]["Title"], " ", strstart) + 1
								words = words + 1;
							end
							if (words == 8) then
								strend = strstart - 1;
							end
						end
						if (words > 8) then
							titletext = string.sub(FlagList[rName][cName]["Title"], 1, strend - 1) .. "...";
						end
					else
						titletext = FlagList[rName][cName]["Title"];
					end
					GTTTable[GTTNL] = "|cffFFFFFF" .. "\"" .. "|cffFEF1B5" .. titletext .. "|r" .. "|cffFFFFFF" .. "\"";
				end
			end
			--Character Level
			GTTNL = GTTNL + 1;
			GTTTable[GTTNL] = leveltext;
			--Guild Information
			if (GetGuildInfo(unit) and PlayerFlags[rName][pName]["flagRSP2TooltipShowGuildCheck"] == 1) then
				--Show at Bottom
				GTTNL = GTTNL + 1;
				GTTTable[GTTNL] = "|cffFFFFFF" .. GetGuildInfo(unit) .. "|r";
			end
			--Status Information(Role Players)
			if (PlayerFlags[rName][pName]["flagRSP2TooltipShowStatusCheck"] == 1 and FlagList[rName][cName] ~= nil) then
				if ((FlagList[rName][cName]["RPFlag"] ~= nil and FlagList[rName][cName]["RPFlag"] ~= "") or (FlagList[rName][cName]["CSTATUS"] ~= nil and FlagList[rName][cName]["CSTATUS"] ~= ""  and FlagList[rName][cName]["CSTATUS"] ~= 0)) then
					generate_status_line(unit, cName);
					if (finalline ~= "false") then
							GTTNL = GTTNL + 1;
							GTTTable[GTTNL] = finalline;
					end
				end
			end
			--Role Player with hidden description?
			if (FlagList[rName][cName] ~= nil and FlagList[rName][cName]["HideDesc"] == 1) then
				GTTNL = GTTNL + 1;
				GTTTable[GTTNL] = "|cffFEF1B5" .. "(Description Hidden)";
			end
			if (UnitIsPVP(unit) and PlayerFlags[rName][pName]["flagRSP2TooltipShowPvPCheck"] == 1) then
				GTTNL = GTTNL + 1;
				GTTTable[GTTNL] = "|cffFFFFFF" .. "PvP";
			end
			if (levelLine == 2 and UnitInParty(unit) and GameTooltip:NumLines() > 2) then
				GTTNL = GTTNL + 1;
				GTTTable[GTTNL] = "|cffFFFFFF" .. GameTooltipTextLeft3:GetText();
			end
			--Remove unused GameTooltipTextLefts.
			if (GTTNL < GameTooltip:NumLines()) then
				for i = GTTNL + 1, GameTooltip:NumLines() do
					getglobal("GameTooltipTextLeft" ..  i):Hide();
				end
			end
			--Add more GameTooltipTextLefts.
			if (GTTNL > GameTooltip:NumLines()) then
				for i = 1, GTTNL - GameTooltip:NumLines() do
					GameTooltip:AddLine(" ");
				end
			end
			--Take each line from GTTTable and assign it to the proper GameTooltipTextLeft.
			for i = 1, GTTNL do
				getglobal("GameTooltipTextLeft" .. i):SetText(GTTTable[i]);
			end
			--Hide the description and extra light tooltip frames if sticky and target descriptions are turned off.
			if (FlagList[rName][cName] == nil and PlayerFlags[rName][pName]["flagRSP2OptionsStickyDescCheck"] == 0 and PlayerFlags[rName][pName]["flagRSP2OptionsTargetDescCheck"] == 0) then
				flagRSP2Info_Frame:Hide();
				flagRSP2Gametooltip_Frame:Hide();
			end
		else
			--Hide the description and extra light tooltip frames if sticky and target descriptions are turned off.
			if (PlayerFlags[rName][pName]["flagRSP2OptionsStickyDescCheck"] == 0 and PlayerFlags[rName][pName]["flagRSP2OptionsTargetDescCheck"] == 0) then
				flagRSP2Info_Frame:Hide();
				flagRSP2Gametooltip_Frame:Hide();
			end
		end
		GameTooltip:Show();
	--Default tooltip plus extra tooltip.
	elseif (FlagList[rName][cName] ~= nil and UnitIsPlayer(unit) and PlayerFlags[rName][pName]["flagRSP2TooltipFRSP2TTCheck"] == 1) then
		--Show GameTooltip first to allow all of its new properties to populate such as its points.
		GameTooltip:Show();
		if (PlayerFlags[rName][pName]["flagRSP2TooltipShowAddNameCheck"] ==1 and FlagList[rName][cName] ~= nil and ((FlagList[rName][cName]["AN1"] ~= nil and FlagList[rName][cName]["AN1"] ~= "") or (FlagList[rName][cName]["AN3"] ~= nil and FlagList[rName][cName]["AN3"] ~= "")) and UnitIsPlayer(unit)) then
			if (FlagList[rName][cName]["AN1"] ~= nil and FlagList[rName][cName]["AN1"] ~= "") then
				nametext = "|cff00AAFF" .. FlagList[rName][cName]["AN1"] .. " " .. UnitName(unit) .. " " .. FlagList[rName][cName]["AN3"] .. "|r"
			else
				nametext = "|cff00AAFF" .. UnitName(unit) .. " " .. FlagList[rName][cName]["AN3"] .. "|r"
			end
		else
			nametext = "|cff00AAFF" .. UnitName(unit) .. "|r"
		end
		flagRSP2GametooltipEtc:SetText("\b");
		hasTitle = 0;
		if (FlagList[rName][cName]["Title"] ~= nil and FlagList[rName][cName]["Title"] ~= "" and PlayerFlags[rName][pName]["flagRSP2TooltipShowTitleCheck"] == 1) then
			flagRSP2GametooltipEtc:SetText("\"" .. "|cffFEF1B5" .. FlagList[rName][cName]["Title"] .. "|r" .. "\"");
			local titletext = FlagList[rName][cName]["Title"];
			if (PlayerFlags[rName][pName]["flagRSP2OptionsWordLimitCheck"] == 1) then
				words = 0;
				strstart = 0;
				strend = 0;
				for i = 1, string.len(FlagList[rName][cName]["Title"]) do
					if (string.find(FlagList[rName][cName]["Title"], " ", strstart) ~= nil) then
						strstart = string.find(FlagList[rName][cName]["Title"], " ", strstart) + 1
						words = words + 1;
					end
					if (words == 8) then
						strend = strstart - 1;
					end
				end
				if (words > 8) then
					titletext = string.sub(FlagList[rName][cName]["Title"], 1, strend - 1) .. "...";
				end
			else
				titletext = FlagList[rName][cName]["Title"];
			end
			flagRSP2GametooltipEtc:SetText("\"" .. "|cffFEF1B5" .. titletext .. "|r" .. "\"");
			hasTitle = 1;
		end
		if (PlayerFlags[rName][pName]["flagRSP2TooltipShowStatusCheck"] == 1) then
			if ((FlagList[rName][cName]["RPFlag"] ~= nil and FlagList[rName][cName]["RPFlag"] ~= "") or (FlagList[rName][cName]["CSTATUS"] ~= nil and FlagList[rName][cName]["CSTATUS"] ~= ""  and FlagList[rName][cName]["CSTATUS"] ~= 0)) then
				generate_status_line(unit, cName);
				if (finalline ~= "false") then
					if (hasTitle == 1) then
						flagRSP2GametooltipEtc:SetText(flagRSP2GametooltipEtc:GetText() .. "\n" .. finalline);
					else
						flagRSP2GametooltipEtc:SetText(finalline);
					end
				end
			end
		end
		if (FlagList[rName][cName]["HideDesc"] == 1) then
			if (hasTitle == 1 or PlayerFlags[rName][pName]["flagRSP2TooltipShowStatusCheck"] == 1) then
				flagRSP2GametooltipEtc:SetText(flagRSP2GametooltipEtc:GetText() .. "\n" .. "|cffFEF1B5" .. FLAGRSP2_LUA_DESCHIDDEN);
			else
				flagRSP2GametooltipEtc:SetText("|cffFEF1B5" .. FLAGRSP2_LUA_DESCHIDDEN)
			end
		end
		if (PlayerFlags[rName][pName]["flagRSP2OptionsTargetDescCheck"] == 0) then
			popup_desc(cName);
		end
		flagRSP2Gametooltip:SetBackdropColor(0.0, 0.0, 0.0, 1.0);
		fontfile, fontsize, fontflags = GameTooltipTextLeft1:GetFont();
		flagRSP2GametooltipName:SetFont(fontfile, fontsize, fontflags);
		flagRSP2GametooltipName:SetText(nametext);
		flagRSP2Gametooltip_Frame:SetHeight(flagRSP2GametooltipName:GetHeight() + flagRSP2GametooltipEtc:GetHeight() + 20);
		if (flagRSP2GametooltipName:GetWidth() > flagRSP2GametooltipEtc:GetWidth()) then
			flagRSP2Gametooltip_Frame:SetWidth(flagRSP2GametooltipName:GetWidth() + 20);
		else
			flagRSP2Gametooltip_Frame:SetWidth(flagRSP2GametooltipEtc:GetWidth() + 20);
		end
		frameTop = (GetScreenHeight() - GameTooltip:GetTop()) * -1;
		flagRSP2Gametooltip_Frame:ClearAllPoints();
		flagRSP2Gametooltip_Frame:SetPoint("TOPLEFT", UIParent, "TOPLEFT", GameTooltip:GetRight() - flagRSP2Gametooltip_Frame:GetWidth(), frameTop + flagRSP2Gametooltip_Frame:GetHeight());
		flagRSP2Gametooltip_Frame:Show();
	else
		if (PlayerFlags[rName][pName]["flagRSP2OptionsStickyDescCheck"] == 0 and PlayerFlags[rName][pName]["flagRSP2OptionsTargetDescCheck"] == 0) then
			flagRSP2Info_Frame:Hide();
			flagRSP2Gametooltip_Frame:Hide();
		end
		flagRSP2Gametooltip_Frame:Hide();
	end
end

function generate_status_line(unit, cName)
	norpstatus = 0;
	nocsstatus = 0;
	rpline = "";
	if (FlagList[rName][cName]["RPFlag"] ~= nil and FlagList[rName][cName]["RPFlag"] ~= "") then
		if FlagList[rName][cName]["RPFlag"] == 0 then
			norpstatus = 1;
		elseif FlagList[rName][cName]["RPFlag"] == 1 then
			rpline = "|cffFEF1B5" .. "<" .. FLAGRSP2_LUA_RP
		elseif FlagList[rName][cName]["RPFlag"] == 2 then
			rpline = "|cffFEF1B5" .. "<" .. FLAGRSP2_LUA_CRP
		elseif FlagList[rName][cName]["RPFlag"] == 3 then
			rpline = "|cffFEF1B5" .. "<" .. FLAGRSP2_LUA_FRP
		elseif FlagList[rName][cName]["RPFlag"] == 4 then
			rpline = "|cffFEF1B5" .. "<" .. FLAGRSP2_LUA_BRP
		elseif (FlagList[rName][cName]["RPFlag"] == 5 and FlagList[rName][pName]["RPFlag"] == 5) then
			rpline = "|cffFEF1B5" .. "<" .. FLAGRSP2_LUA_MRP
		elseif (FlagList[rName][cName]["RPFlag"] == 5 and FlagList[rName][pName]["RPFlag"] ~= 5) then
			rpline = "|cffFEF1B5" .. "<" .. FLAGRSP2_LUA_FRP
		else
			norpstatus = 1;
		end
	else
		norpstatus = 1;
	end
	if (FlagList[rName][cName]["CSTATUS"] ~= nil and FlagList[rName][cName]["CSTATUS"] ~= "") then
		if (norpstatus == 1) then
			rpline = "|cffFEF1B5" .. "<";
		end
		if FlagList[rName][cName]["CSTATUS"] == 0 then
			csline = ">"
			nocsstatus = 1;
		elseif FlagList[rName][cName]["CSTATUS"] == 1 then
			csline = FLAGRSP2_LUA_OOC .. ">"
		elseif FlagList[rName][cName]["CSTATUS"] == 2 then
			csline = FLAGRSP2_LUA_IC .. ">"
		elseif FlagList[rName][cName]["CSTATUS"] == 3 then
			csline = FLAGRSP2_LUA_LFC .. ">"
		elseif FlagList[rName][cName]["CSTATUS"] == 4 then
			csline = FLAGRSP2_LUA_ST ..">"
		else
			nocsstatus = 1;
		end
	else
		nocsstatus = 1;
	end
	if (norpstatus == 0 or nocsstatus == 0) then
		if (norpstatus == 1) then
			finalline = "|cffFEF1B5" .. "<" .. csline;
		else
			if (nocsstatus == 1) then
				finalline = rpline .. ">";
			else
				finalline = rpline .. ", " .. csline;
			end
		end
	end
	dName = {"Jenine", "Azxiana", "Trela", "Mihau"};
	for i,v in pairs(dName) do
		if (rName == "Feathermoon" and cName == v) then
			finalline = finalline .. "|cffff00c6" .. " FlagRSP2 Developer"
		end
	end
	if (norpstatus == 1 and nocsstatus == 1) then
		finalline = "false"
	end
		return finalline;
end

function popup_desc(cName)
	if (cName == "" or cName == nil) then
		return
	end
	if (FlagList[rName][cName]["HideDesc"] == nil) then
		FlagList[rName][cName]["HideDesc"] = 0;
	end
	if (rspcombat == 0 and FlagList[rName][cName]["HideDesc"] == 0) then
		if (FlagList[rName][cName] ~= nil and ((FlagList[rName][cName]["AN1"] ~= nil and FlagList[rName][cName]["AN1"] ~= "") or (FlagList[rName][cName]["AN3"] ~= nil and FlagList[rName][cName]["AN3"] ~= ""))) then
			if (FlagList[rName][cName]["AN1"] ~= nil and FlagList[rName][cName]["AN1"] ~= "") then
				dsnametext = "|cff00AAFF" .. FlagList[rName][cName]["AN1"] .. " " .. cName .. " " .. FlagList[rName][cName]["AN3"] .. "|r"
			else
				dsnametext = "|cff00AAFF" .. cName .. " " .. FlagList[rName][cName]["AN3"] .. "|r"
			end
		else
			dsnametext = "|cff00AAFF" .. cName .. "|r"
		end
		if (FlagList[rName][cName]["Desc"] ~= nil and PlayerFlags[rName][pName]["flagRSP2OptionsShowDescCheck"] == 1) then
			fontfile, fontsize, fontflags = flagRSP2InfoDesc:GetFont();
			flagRSP2InfoDesc:SetFont(fontfile, "12", fontflags);
			local i = 1;
			local desctext = "";
			while FlagList[rName][cName]["Desc"]["A"][i] ~= nil do
				desctext = desctext .. FlagList[rName][cName]["Desc"]["A"][i];
				i = i + 1;
			end
			--if (PlayerFlags[rName][pName]["flagRSP2OptionsWordLimitCheck"] == 1) then
			--	words = 0;
			--	strstart = 0;
			--	strend = 0;
			--	for i = 1, string.len(desctext) do
			--		if (string.find(desctext, " ", strstart) ~= nil) then
			--			strstart = string.find(desctext, " ", strstart) + 1
			--			words = words + 1;
			--		end
			--		if (words == 150) then
			--			strend = strstart - 1;
			--		end
			--	end
			--	if (words > 150) then
			--		desctext = string.sub(desctext, 1, strend) .. "|cffFF0000" .. "...(Cut)" .. "|r";
			--	end
			--	boxexpand = 0;
			--else
			--	boxexpand = 0;
			--end
			blanktext = string.gsub(desctext, "\n", "");
			if (blanktext ~= "") then
				largestwidth = 0;
				flagRSP2Info:SetBackdropColor(0.0, 0.0, 0.0, 1.0);
				fontfile, fontsize, fontflags = flagRSP2InfoName:GetFont();
				
				--Name Line
				flagRSP2InfoName:SetFont(fontfile, "20", fontflags);
				flagRSP2InfoName:SetText(dsnametext);
				largestwidth = flagRSP2InfoName:GetWidth();
				
				--Title Line
				if (PlayerFlags[rName][pName]["flagRSP2DescShowTitleCheck"] == 1) then
					if (FlagList[rName][cName]["Title"] ~= nil or FlagList[rName][cName]["Title"] ~= "") then
						flagRSP2InfoTitle:SetText(FlagList[rName][cName]["Title"]);
					else
						flagRSP2InfoTitle:SetText("");
					end
				else
					flagRSP2InfoTitle:SetText("");
				end
				flagRSP2InfoTitle:SetWidth(flagRSP2InfoTitle:GetStringWidth() + 2);
				if (flagRSP2InfoTitle:GetWidth() > 300) then
					flagRSP2InfoTitle:SetWidth(300);
				end
				if (flagRSP2InfoTitle:GetWidth() > largestwidth) then
					largestwidth = flagRSP2InfoTitle:GetWidth();
				end
				
				--Status Line
				if (PlayerFlags[rName][pName]["flagRSP2DescShowStatusCheck"] == 1) then
				generate_status_line(unit, cName);
					if (finalline ~= "false") then
						flagRSP2InfoStatus:SetText(finalline);
					else
						flagRSP2InfoStatus:SetText("");
					end
					if (flagRSP2InfoStatus:GetWidth() > largestwidth) then
						largestwidth = flagRSP2InfoStatus:GetWidth();
					end
				else
					flagRSP2InfoStatus:SetText("");
				end
			
				if (largestwidth > 185) then
					flagRSP2Info_Frame:SetWidth(largestwidth + 40);
				else
					flagRSP2Info_Frame:SetWidth(220);
				end
				
				--Description Line
				desctext = string.gsub(desctext, "\\l", "\n");
				flagRSP2InfoDesc:SetText(desctext);
				flagRSP2InfoDesc:SetWidth(flagRSP2Info_Frame:GetWidth() - 40);
				flagRSP2InfoDescSizer:SetText(desctext);
				flagRSP2InfoDescSizer:SetWidth(flagRSP2Info_Frame:GetWidth() - 40);
				flagRSP2InfoDescScrollFrame:SetWidth(flagRSP2InfoDesc:GetWidth());
				if (flagRSP2InfoDescSizer:GetHeight() < 275) then
					flagRSP2InfoDescScrollFrame:SetHeight(flagRSP2InfoDescSizer:GetHeight());
				else
					flagRSP2InfoDescScrollFrame:SetHeight(275);
				end
				flagRSP2Info_Frame:SetHeight(flagRSP2InfoName:GetHeight() + flagRSP2InfoDescScrollFrame:GetHeight() + flagRSP2InfoTitle:GetHeight() + flagRSP2InfoStatus:GetHeight() + 20);
				if (not flagRSP2Info_Frame:IsShown()) then
					if (UIParent:IsVisible()) then
						flagRSP2Info_Frame:SetParent(UIParent);
						flagRSP2Info_Frame:Show();
					else
						flagRSP2Info_Frame:SetParent(WorldFrame);
						flagRSP2Info_Frame:Show();
					end
					flagRSP2Info_Frame:SetClampedToScreen();
				end
			else
				if (PlayerFlags[rName][pName]["flagRSP2OptionsStickyDescCheck"] == 0 and PlayerFlags[rName][pName]["flagRSP2OptionsTargetDescCheck"] == 0) then
					flagRSP2Info_Frame:Hide();
					flagRSP2Gametooltip_Frame:Hide();
				end
			end
		else
			if (PlayerFlags[rName][pName]["flagRSP2OptionsStickyDescCheck"] == 0 and PlayerFlags[rName][pName]["flagRSP2OptionsTargetDescCheck"] == 0) then
				flagRSP2Info_Frame:Hide();
				flagRSP2Gametooltip_Frame:Hide();
			end
		end
	end
end

function flaggedChanHandle(arg1, arg2)
	if string.find(arg1,"<") == nil then 
		return;
	end
	
	--IF BLOCK 1 START
	if string.find(string.sub(arg1,2,string.len(arg1)),"<") ~= nil then 
	--More than one option in the string.
      
      
		firstBrack = string.find(string.sub(arg1,2,string.len(arg1)),"<");

		firstComm = string.sub(arg1,1,firstBrack);
		rest = string.sub(arg1,firstBrack+1, string.len(arg1));

      
		flaggedChanHandle(firstComm, arg2);
		flaggedChanHandle(rest, arg2);
	
	--IF BLOCK 1 ELSEIF 1 START
	elseif string.find(string.sub(arg1,2,string.len(arg1)),"<") == nil then 
		--Only one command remaining, parse as normal.


		--Substitute encoded brackets for old compatibility. - Not needed any more?  I have not seen these used in forever.  Alexia.
		arg1 = string.gsub(arg1, "\\%(", "<");
		arg1 = string.gsub(arg1, "\\%)", ">");
			
		--IF BLOCK 2 START
 		--Character Title
		if string.sub(arg1, 1, 3) == "<T>" then
			RPaddFlag("Title", string.sub(arg1, 4, string.len(arg1)), arg2);

		--Roleplay Status
		elseif string.sub(arg1,1,3) == "<RP" and string.sub(arg1,4,4) ~= "T"  then
			local RPStyle = string.sub(arg1,4,4);
			if (tonumber(RPStyle) ~= nil) then
				RPaddFlag("RPFlag", tonumber(RPStyle), arg2)
			end

		--Character Status
		elseif string.sub(arg1, 1, 3) == "<CS" then
			local cStatus = string.sub(arg1,4,4);
			if (tonumber(cStatus) ~= nil) then
				RPaddFlag("CSTATUS", tonumber(cStatus), arg2)
			end

		--Additional Name
		elseif string.sub(arg1, 1, 3) == "<AN" then
			local cAN = string.sub(arg1,4,4);
			if (tonumber(cAN) ~= nil) then
				RPaddFlag("AN", tonumber(cAN), arg2, string.sub(arg1, 6, string.len(arg1)));
			end

		--Description Version/Revision
		elseif (string.sub(arg1, 1, 4) == "<DV>") then
			local n = tonumber(string.sub(arg1, 5, string.len(arg1)));
			if (n ~= nil) then
				RPaddFlag("DV", n, arg2);
			end

	 	--Description Pull
		elseif (arg1 == ("<DP>" .. UnitName("player")) or arg1 == ("<DPULL>" .. UnitName("player"))) then
			saveddesc = PlayerFlags[rName][pName]["Desc"]["A"];
			if (dpcooldown == 0) then
				if (strlen(saveddesc) > 245) then
					nummess = strlen(saveddesc) / 245;
					if (mod(strlen(saveddesc), 245) > 0) then
						nummess = ceil(nummess)
					end
					for i=1, nummess do
						--This if statement is a cheap formating method.  If there is a function, I can't find it.
						--if (i < 10) then
						--	formnum = "0" .. i;
						--else
						--	formnum = i;
						--end
						--dpmessage = "<D" .. formnum .. ">" .. string.sub(PlayerFlags[rName][pName]["Desc"]["A"], (245 * i) - 244, 245 * i);
						dpmessage = string.format("<D%02.f>%s", i, string.sub(PlayerFlags[rName][pName]["Desc"]["A"], (245 * i) - 244, 245 * i))
						if (i == nummess) then
							 dpmessage = dpmessage .. "\\eod";
						end
						dpmessage = string.gsub(dpmessage, "\n", "\\l");
						i = getn(rspsendbuffer);
						i = i + 1
						rspsendbuffer[i] = dpmessage;
					end
					dpcooldown = 1;
				else
					dpmessage = "<D01>" .. string.sub(PlayerFlags[rName][pName]["Desc"]["A"], 1, 245) .. "\\eod";
					dpmessage = string.gsub(dpmessage, "\n", "\\l");
					i = getn(rspsendbuffer);
					i = i + 1
					rspsendbuffer[i] = dpmessage;
					dpcooldown = 1;
				end
			end

		elseif (string.sub(arg1, 1, 2) == "<D" and tonumber(string.sub(arg1, 3, 4)) ~= nil and PlayerFlags[rName][pName]["flagRSP2OptionsSaveDescCheck"] == 1) then
			RPaddDesc(tonumber(string.sub(arg1,3,4)), string.sub(arg1, 6, string.len(arg1)), arg2);
 
		elseif (string.sub(arg1, 1, 2) == "<P" and tonumber(string.sub(arg1, 3, 4)) ~= nil and PlayerFlags[rName][pName]["flagRSP2OptionsSaveDescCheck"] == 1) then
			RPaddDesc(tonumber(string.sub(arg1, 3, 4)), string.sub(arg1, 6, string.len(arg1)), arg2, true);
		end
	end
end

function flagRSP2:UpdateSendBuffer()
	polledtime = time();
	if (getn(rspsendbuffer) == 0) then
		i = 0;
	end
	if (polledtime >= (lasttime + 5)) then
		cid, cname = GetChannelName("xtensionxtooltip2");
		if (rspsendbuffer[i] ~= nil) then
			SendChatMessage(rspsendbuffer[i], "CHANNEL", GetDefaultLanguage("player"), cid);
		end
		lasttime = time();
		if (getn(rspsendbuffer) == i) then
			i = 0;
			rspsendbuffer = {};
		end
		i = i + 1;
	end
end

function flagRSP2:HelpMe()
	if (flagRSP2PlayerDescEditScrollFrame:IsVisible() == 1) then
		flagRSP2PlayerDescEditScrollFrame:Hide();
		flagRSP2PlayerDescHelpMeScrollFrame:Show();
		flagRSP2PlayerHelpMeTitleText:Show();
	else
		flagRSP2PlayerDescHelpMeScrollFrame:Hide();
		flagRSP2PlayerHelpMeTitleText:Hide();
		flagRSP2PlayerDescEditScrollFrame:Show();
	end
end

function RPaddFlag(flag, value, name, valuetwo)
	if flag == nil then 
		return;
	end

	if (flag == "RPFlag" or flag =="Title" or flag =="CSTATUS") then
		if FlagList[rName][name] == nil then
			FlagList[rName][name] = {};
		end
		FlagList[rName][name][flag] = value;
		FlagList[rName][name].timeStamp = time();
		FlagList[rName][name].faction = UnitFactionGroup("player");
	end 
	if (flag == "AN") then
		if FlagList[rName][name] == nil then
			FlagList[rName][name] = {};
		end
		if (value == 1 and valuetwo ~= nil) then
			FlagList[rName][name]["AN1"] = valuetwo;
		elseif (value == 3 and valuetwo ~= nil) then
			FlagList[rName][name]["AN3"] = valuetwo;
		end
	end
	if (flag == "DV") then
		if (FlagList[rName][name] == nil) then
			csm = "<DP>" .. name;
			cid, cname = GetChannelName("xtensionxtooltip2");
			SendChatMessage(csm, "CHANNEL", GetDefaultLanguage("player"), cid);
			FlagList[rName][name] = {};
			FlagList[rName][name][flag] = value;
		end
		if (FlagList[rName][name][flag] == nil or FlagList[rName][name][flag] > value) then
			csm = "<DP>" .. name;
			cid, cname = GetChannelName("xtensionxtooltip2");
			SendChatMessage(csm, "CHANNEL", GetDefaultLanguage("player"), cid);
			FlagList[rName][name][flag] = value;
		end
		FlagList[rName][name].timeStamp = time();
		FlagList[rName][name].faction = UnitFactionGroup("player");
	end
end

function RPaddDesc(num, text, name, rev, partial)
	if partial == nil then
		partial = false;
	end

	--flag = "Desc";
	desc = "A";

	if FlagList[rName][name] == nil then
		FlagList[rName][name] = {};
	end

	if FlagList[rName][name]["Desc"] == nil then
		FlagList[rName][name]["Desc"] = {};
	else
		--message("Description " .. name);
	end
	if FlagList[rName][name]["Desc"][desc] == nil then
		FlagList[rName][name]["Desc"][desc] = {};
		FlagList[rName][name]["Desc"][desc].complete = false;
	elseif (num == 1 and FlagList[rName][name]["Desc"][desc] ~= nil) then
		FlagList[rName][name]["Desc"][desc] = {};
		FlagList[rName][name]["Desc"][desc].complete = false;
	end

	FlagList[rName][name]["Desc"][desc][num] = text;

	FlagList[rName][name]["Desc"][desc].revision = rev;
   
	if not partial then
		FlagList[rName][name]["Desc"][desc].complete = true;
	end

	local i = 1;
	local lastPart;
	while FlagList[rName][name]["Desc"][desc][i] ~= nil do
		lastPart = string.sub(FlagList[rName][name]["Desc"][desc][i], string.len(FlagList[rName][name]["Desc"][desc][i])-3);

		if lastPart == "\\eod" then
			FlagList[rName][name]["Desc"][desc].complete = true;
			FlagList[rName][name]["Desc"][desc][i] = string.gsub(FlagList[rName][name]["Desc"][desc][i], "\\eod", "");
		end
      
		i = i + 1;
	end

	FlagList[rName][name].timeStamp = time();
	FlagList[rName][name].faction = UnitFactionGroup("player");
end

function flagRSP2PurgeOldDB()
	for key, value in next, FlagList[rName] do
		--I could just multiply by 86,400 seconds, but I separated it for easier code editing.
		if (value.timeStamp <= time() - (flagRSP2OptionsDBDaysEdit:GetText() * 24 * 60 * 60)) then
			FlagList[rName][key] = nil;
			ReloadUI();
		end
	end
end

function flagRSP2PurgeAllDB()
	FlagList[rName] = nil;
	ReloadUI();
end

function flagRSP2WindowChange(newwindow, oldwindow)
	--I hacked this code together with separate frames because the tab implementation in the WoW UI is annoying to implement.
	currentwindow = newwindow
	frameTop = (GetScreenHeight() - getglobal(oldwindow):GetTop()) * -1;
	getglobal(newwindow):SetPoint("TOPLEFT", UIParent, "TOPLEFT", getglobal(oldwindow):GetLeft(), frameTop);
	getglobal(oldwindow):Hide();
	getglobal(newwindow):Show();
	getglobal(oldwindow):SetWidth(472);
	getglobal(newwindow):SetWidth(472);
end

function flagRSP2SetClearView()
	if (UIParent:IsVisible()) then
		CloseAllWindows();
		for i = 1, FCF_GetNumActiveChatFrames() do
			getglobal("ChatFrame" .. i):SetParent(WorldFrame);
			getglobal("ChatFrame" .. i):SetScale(UIParent:GetScale());
			ChatFrameEditBox:SetParent(WorldFrame);
			ChatFrameEditBox:SetScale(UIParent:GetScale());
		end
		for index, value in pairs(DOCKED_CHAT_FRAMES) do
			chatTab = getglobal(value:GetName() .. "Tab");
			chatTab:SetParent(WorldFrame);
			chatTab:SetScale(UIParent:GetScale());
			chatTab:Show();
		end
		ChatFrameMenuButton:SetParent(WorldFrame);
		ChatFrameMenuButton:SetScale(UIParent:GetScale());
		GameTooltip:SetParent(WorldFrame);
		GameTooltip:SetScale(UIParent:GetScale());
		GameTooltip:SetFrameStrata("TOOLTIP");
		flagRSP2Info_Frame:SetParent(WorldFrame);
		flagRSP2Info_Frame:SetScale(UIParent:GetScale());
		flagRSP2ClearViewClose:Show();
		UIParent:Hide();
		FCF_OnUpdate(1);
	else
		for i = 1, FCF_GetNumActiveChatFrames() do
			getglobal("ChatFrame" .. i):SetParent(UIParent);
			getglobal("ChatFrame" .. i):SetScale(WorldFrame:GetScale());
			ChatFrameEditBox:SetParent(UIParent);
			ChatFrameEditBox:SetScale(WorldFrame:GetScale());
		end
		for index, value in pairs(DOCKED_CHAT_FRAMES) do
			chatTab = getglobal(value:GetName() .. "Tab");
			chatTab:SetParent(UIParent);
			chatTab:SetScale(WorldFrame:GetScale());
			chatTab:Show();
		end
		ChatFrameMenuButton:SetParent(UIParent);
		ChatFrameMenuButton:SetScale(WorldFrame:GetScale());
		GameTooltip:SetParent(UIParent);
		GameTooltip:SetScale(WorldFrame:GetScale());
		GameTooltip:SetFrameStrata("TOOLTIP");
		flagRSP2Info_Frame:SetParent(UIParent);
		flagRSP2Info_Frame:SetScale(WorldFrame:GetScale());
		flagRSP2ClearViewClose:Hide();
		UIParent:Show();
		FCF_OnUpdate(1);
	end
end

function flagRSP2CloneDatabase()
	--Coded by Xiaclo.
	FlagList.temp = {}
	for key, value in next, FlagList[rName] do
		FlagList.temp[#FlagList.temp + 1] = {(value.AN1 or ""), key, (value.AN3 or "")}
	end
end

function flagRSP2ViewerOnShow()
	--Coded by Xiaclo.
	local index = 1
	local index, offset, search = 1, math.floor(flagRSP2ViewerSlider:GetValue() + 0.5), string.lower(flagRSP2ViewerSearch:GetText())
	local globals = getfenv()
	if search == "" then search = nil end
	for i = 1, #FlagList.temp do
		if not search or string.find(string.lower(FlagList.temp[i][1] .. FlagList.temp[i][2] .. FlagList.temp[i][3]), search) then
			if index > offset and index - 15 <= offset then
				local name1, name2, name3 = FlagList.temp[i][1], FlagList.temp[i][2], FlagList.temp[i][3]
				if name1 and name1 ~= "" then name1 = name1 .. " " else name1 = "" end
				if name3 and name3 ~= "" then name3 = " " .. name3 else name3 = "" end
				globals["flagRSP2ViewerTextLine" .. index - offset].name = FlagList.temp[i][2]
				globals["flagRSP2ViewerTextLine" .. index - offset .. "LeftText"]:SetText(string.gsub(name1 .. name2 .. name3, "^[ ]+", ""))
			end
			index = index + 1
		end
	end
	if index <= 15 then
		for i = index, 15 do
			globals["flagRSP2ViewerTextLine" .. i].name = nil
			globals["flagRSP2ViewerTextLine" .. i .. "LeftText"]:SetText("")
		end
		flagRSP2ViewerSlider:SetMinMaxValues(0, 0)
		if offset ~= flagRSP2ViewerSlider:GetValue() then
			flagRSP2ViewerSlider:SetValue(offset)
		end
		flagRSP2ViewerSliderUpButton:Disable()
		flagRSP2ViewerSliderDownButton:Disable()
	else
		flagRSP2ViewerSlider:SetMinMaxValues(0, index - 15)
		if offset ~= flagRSP2ViewerSlider:GetValue() then
			flagRSP2ViewerSlider:SetValue(offset)
		end
		if offset == 0 then
			flagRSP2ViewerSliderUpButton:Disable()
			flagRSP2ViewerSliderDownButton:Enable()
		elseif offset == index - 15 then
			flagRSP2ViewerSliderUpButton:Enable()
			flagRSP2ViewerSliderDownButton:Disable()
		else
			flagRSP2ViewerSliderUpButton:Enable()
			flagRSP2ViewerSliderDownButton:Enable()
		end
	end
end

--TinyTip Code
--Name: TinyTip
--Author: Thrae of Maelstrom (aka "Matthew Carras")
local function handlerOnTooltipSetUnit(origfunc,handlers,self,...)
    if not handlers then
        if origfunc then
            return origfunc(self,...)
        end
    else
        origfunc(self,...)
    end

    local _, unit = self:GetUnit()
    if unit and UnitExists(unit) and GameTooltipTextLeft1:IsShown() then
        for i = 1,#handlers do
            handlers[i](unit)
        end

        self:Show()
    end
end

local function handler(origfunc,handlers,...)
    if not handlers then
        if origfunc then
            return origfunc(...)
        end
    else
        origfunc(...)
    end

    for i = 1,#handlers do
        handlers[i](...)
    end
end

local function isHooked(handlers, handler)
    if not handlers then return true end
    for _,v in ipairs(handlers) do
        if v == handler then
            return true
        end
    end
end

local function hook(object, func, mainhandler, handler, isscript, priority)
    if not origfuncs then origfuncs = {} end
    if not origfuncs[object] then origfuncs[object] = {} end
    if not hooks then hooks = {} end
    if not hooks[object] then hooks[object] = { [func] = {} } end

    if not isHooked(hooks[object][func], handler) then
        if priority then
            table.insert(hooks[object][func], priority, handler)
        else
            table.insert(hooks[object][func], handler)
        end
    end

    if origfuncs[object][func] == nil then
        if isscript then
            origfuncs[object][func] = object:GetScript(func) or false
            object:SetScript(func, function(...) mainhandler(origfuncs[object][func], hooks[object][func], ...) end)
        else
            origfuncs[object][func] = object[func] or false
            object[func] = function(...) mainhandler(origfuncs[object][func], hooks[object][func], ...) end
        end
    end
end

local function unhook(object, func, handler)
    if not hooks or not hooks[object] or not hooks[object][func] then return end
    local handlers = hooks[object][func]
    for i = 1, #handlers do
        if handlers[i] == handler then
            table.remove(handlers, i)
            return true
        end
    end
end

function flagRSP2HookOnTooltipSetUnit(tooltip, handler, priority)
    hook(tooltip, "OnTooltipSetUnit", handlerOnTooltipSetUnit, handler, true, priority)
end

function flagRSP2UnhookOnTooltipSetUnit(tooltip, handler)
    unhook(tooltip, "OnTooltipSetUnit", handler)
end
