local KSVERSION = "$Rev: 64 $"

local killingstreak = 0
local deathstreak = 0
local dgks_multikill = 0
local dgks_lastkill = 0

-- Create the Ace2 main object
dgks = LibStub("AceAddon-3.0"):NewAddon("dgks", "AceConsole-3.0", "AceEvent-3.0")

local LS2 = LibStub("LibSink-2.0")

local options = { 
    type = "group",
	name = "dG Killshot Notifier",
	handler = dgks,
	childGroups = "tab",
	args = {
		general = {
			type = "group",
			name = "General",
			args = {
				doemote = {
					type = 'toggle',
					name = 'Show Emote',
					desc = 'Toggle Emote Spam',
					get = function()
						return dgks.db.profile.ksdoemote
					end,
					set = function(info, b)
						dgks.db.profile.ksdoemote = b
					end
				},
				msg = {
					type = 'input',
					name = 'Killshot Message',
					desc = 'Killshot Message',
					usage = "<message>",
					get = "getMessage",
					set = "setMessage"
				},
				soundpack = {
					type = 'select',
					name = 'Sound Pack',
					desc = 'Choose a sound pack',
					get = "getSoundPack",
					set = "setSoundPack",
					values = {
						male = "male",
						female = "female",
						sexy = "sexy",
						baby = "baby"
					},
				},
			},
		},
		versioncheck = {
			type = "group",
			name = "Version Checks",
			args = {
				checkguild = {  
					type = 'execute',
					name = 'Check Guild Versions',
					width = "full",
					desc = 'Check Guild dgks versions',
					func = "CheckGuildVersions",
				},
				checkbg = {
					type = 'execute',
					width = "full",
					name = 'Check Battlegroup Versions',
					desc = 'Check BG Versions',
					func = "CheckBGVersions",
				},
				checkraid = {
					type = 'execute',
					width = "full",
					name = 'Check Raid Versions',
					desc = 'Check Raid Versions',
					func = "CheckRaidVersions",
				 },
			},
		},
		ranktuning = {
			type = "group",
			name = "Rank Tuning",
			args = {
				ksrank1 = {
					type = 'range',
					name = 'KS Rank 1',
					desc = 'Number of kills to reach Rank 1',
					width = "full",
					get = function()
					return dgks.db.profile.ksrank[1]
					end,
					set = function(info, v)
						dgks.db.profile.ksrank[1] = v
						--dgks.options[args][ranktuning][args][ksrank2][min] = dgks.db.profile.ksrank[1] + 1
					end,
					min = 0,
					max = 50,
					step = 1
				},
				ksrank2 = {
					type = 'range',
					name = 'KS Rank 2',
					desc = 'Number of kills to reach Rank 2',
					width = "full",
					get = function()
						return dgks.db.profile.ksrank[2]
					end,
					set = function(info, v)
						dgks.db.profile.ksrank[2] = v
					end,
					min = 1,
					max = 50,
					step = 1
				},
				ksrank3 = {
					type = 'range',
					name = 'KS Rank 3',
					desc = 'Number of kills to reach Rank 3',
					width = "full",
					get = function()
						return dgks.db.profile.ksrank[3]
					end,
					set = function(info, v)
						dgks.db.profile.ksrank[3] = v
					end,
					min = -1,
					max = 50,
					step = 1
				},
				ksrank4 = {
					type = 'range',
					name = 'KS Rank 4',
					desc = 'Number of kills to reach Rank 4',
					width = "full",
					get = function()
						return dgks.db.profile.ksrank[4]
					end,
					set = function(info, v)
						dgks.db.profile.ksrank[4] = v
					end,
					min = -1,
					max = 50,
					step = 1
				},
				ksrank5 = {
					type = 'range',
					name = 'KS Rank 5',
					desc = 'Number of kills to reach Rank 5',
					width = "full",
					get = function()
						return dgks.db.profile.ksrank[5]
					end,
					set = function(info, v)
						dgks.db.profile.ksrank[5] = v
					end,
					min = -1,
					max = 50,
					step = 1
				},
				ksrank6 = {
					type = 'range',
					name = 'KS Rank 6',
					desc = 'Number of kills to reach Rank 6',
					width = "full",
					get = function()
						return dgks.db.profile.ksrank[6]
					end,
					set = function(info, v)
						dgks.db.profile.ksrank[6] = v
					end,
					min = -1,
					max = 50,
					step = 1
				},
				ksrank7 = {
					type = 'range',
					name = 'KS Rank 7',
					desc = 'Number of kills to reach Rank 7',
					width = "full",
					get = function()
						return dgks.db.profile.ksrank[7]
					end,
					set = function(info, v)
						dgks.db.profile.ksrank[7] = v
					end,
					min = -1,
					max = 50,
					step = 1
				},
			},
		},
		soundfilesetup = {
			type = "group",
			name = "Sound File Setup",
			desc = "For setuping up custom sounds only",
			args = {
				kssound1 = {
					type = 'input',
					name = 'KS Sound 1',
					desc = 'Choose a sound file',
					usage = "End the name of a sound file",
					get = function()
						return dgks.db.profile.kssound[1]
					end,
					set = function(info, v)
						dgks.db.profile.ksound[1] = v
					end
				},
				kssound2 = {
					type = 'input',
					name = 'KS Sound 2',
					desc = 'Choose a sound file',
					usage = "End the name of a sound file",
					get = function()
						return dgks.db.profile.kssound[2]
					end,
					set = function(info, v)
						dgks.db.profile.ksound[2] = v
					end
					},
				kssound3 = {
					type = 'input',
					name = 'KS Sound 3',
					desc = 'Choose a sound file',
					usage = "End the name of a sound file",
					get = function()
						return dgks.db.profile.kssound[3]
					end,
					set = function(info, v)
						dgks.db.profile.ksound[3] = v
					end
				},
				kssound4 = {
					type = 'input',
					name = 'KS Sound 4',
					desc = 'Choose a sound file',
					usage = "End the name of a sound file",
					get = function()
						return dgks.db.profile.kssound[4]
					end,
					set = function(info, v)
						dgks.db.profile.ksound[4] = v
					end
				},
				kssound5 = {
					type = 'input',
					name = 'KS Sound 5',
					desc = 'Choose a sound file',
					usage = "End the name of a sound file",
					get = function()
						return dgks.db.profile.kssound[5]
					end,
					set = function(info, v)
						dgks.db.profile.ksound[5] = v
					end
				},
				kssound6 = {
					type = 'input',
					name = 'KS Sound 6',
					desc = 'Choose a sound file',
					usage = "End the name of a sound file",
					get = function()
						return dgks.db.profile.kssound[6]
					end,
					set = function(info, v)
						dgks.db.profile.ksound[6] = v
					end
				},
				kssound7 = {
					type = 'input',
					name = 'KS Sound 7',
					desc = 'Choose a sound file',
					usage = "End the name of a sound file",
					get = function()
						return dgks.db.profile.kssound[7]
					end,
					set = function(info, v)
						dgks.db.profile.ksound[7] = v
					end
				},
			},
		},
		sink = LS2:GetSinkAce3OptionsDataTable()
	}
}

local defaults = {
	profile = {
    ksmsg = "killed",
    soundpack = "male", -- need this to check for available packs and create a drag down option
    soundpath = "Interface\\AddOns\\dgks\\sounds\\",
	ksdeathstreak = 0,
	ksdoemote = true,
	ksrank = {0, 2, 4, 6, 8, 10, 12},
	kssound = {"ownage.wav", "killingspree.wav", "rampage.wav", "dominating.wav", "unstoppable.wav", "godlike.wav", "whickedsick.wav"},
	kssoundM = {"doublekill.wav", "multikill.wav", "megakill.wav", "ultrakill.wav", "monsterkill.wav", "ludicrouskill.wav", "holyshit.wav"},
	kstextM = {"DOUBLEKILL!", "MULTIKILL!", "MEGAKILL!", "ULTRAKILL!!!", "MONSTERKILL!!!", "LUDICROUSKILL!!!", "H O L Y  S H I T!!!"},
	--Currently unused might be readded for dueling
	--kssoundH = "humiliation.wav";	
	},
}

function dgks:OnInitialize()
	self.db = LibStub("AceDB-3.0"):New("dgksDB", defaults, "Default")

	LibStub("AceConfig-3.0"):RegisterOptionsTable("dgks", options)
	self.optionsFrame = LibStub("AceConfigDialog-3.0"):AddToBlizOptions("dgks", "dgks")
	
	LibStub("AceConfig-3.0"):RegisterOptionsTable("dgks-general", options.args.general)
	--self.optionsFrame = LibStub("AceConfigDialog-3.0"):AddToBlizOptions("dgks-general", options.args.general.name, "dgks")
	
	LibStub("AceConfig-3.0"):RegisterOptionsTable("dgks-versioncheck", options.args.versioncheck)
	--self.optionsFrame = LibStub("AceConfigDialog-3.0"):AddToBlizOptions("dgks-versioncheck", options.args.versioncheck.name, "dgks")

	LibStub("AceConfig-3.0"):RegisterOptionsTable("dgks-ranktuning", options.args.ranktuning)
	--self.optionsFrame = LibStub("AceConfigDialog-3.0"):AddToBlizOptions("dgks-ranktuning", options.args.ranktuning.name, "dgks")

	LibStub("AceConfig-3.0"):RegisterOptionsTable("dgks-soundfilesetup", options.args.soundfilesetup)
	--self.optionsFrame = LibStub("AceConfigDialog-3.0"):AddToBlizOptions("dgks-soundfilesetup", options.args.soundfilesetup.name, "dgks")

	LibStub("AceConfig-3.0"):RegisterOptionsTable("dgks-sink", options.args.sink)
	--self.optionsFrame = LibStub("AceConfigDialog-3.0"):AddToBlizOptions("dgks-sink", options.args.sink.name, "dgks")
	
	self:RegisterChatCommand("dgks", "ChatCommand")
	self:RegisterChatCommand("ks", "ChatCommand")
	
	--FIXME
	--This solution to stupid users sucks think of a better one
	options.args.ranktuning.args.ksrank2.min = self.db.profile.ksrank[1] + 1
	options.args.ranktuning.args.ksrank3.min = self.db.profile.ksrank[2] + 1
	options.args.ranktuning.args.ksrank4.min = self.db.profile.ksrank[3] + 1
	options.args.ranktuning.args.ksrank5.min = self.db.profile.ksrank[4] + 1
	options.args.ranktuning.args.ksrank6.min = self.db.profile.ksrank[5] + 1
	options.args.ranktuning.args.ksrank7.min = self.db.profile.ksrank[6] + 1
end

function dgks:SoundEventHandler(info, sound)
    if not (PlaySoundFile(sound)) then
        self:ScheduleEvent("dgks_SoundEvent", 0.2, sound);
    end
end

function dgks:OnDisable()
    -- Called when the addon is disabled
end

function dgks:ChatCommand(input)
    if not input or input:trim() == "" then
        InterfaceOptionsFrame_OpenToFrame(self.optionsFrame)
    else
        LibStub("AceConfigCmd-3.0").HandleCommand(WelcomeHome, "ks", "dgks", input)
    end
end

--function dgks:ZoneChangedHandler()
--    if (not UnitIsPVP("Player")) then return; end; --another dueling problem maybe?
--	if (KSDEBUG) then
--		dgks:Print("Killshot streaks reset on zone change.");
--	end
	-- do we actually want to reset on zoning? nah I don't think so
 --   killingstreak = 0;
 --   deathstreak = 0;
--end

function dgks:AddonMessageHandler(info, prefix, text, type, target)
    if not (target == UnitName("player")) then
        if (prefix == "dgks_txt") then
            dgks:Print(text);
        elseif (prefix == "dgks_ScrollingTextEvent") then
            dgks:ScrollText(text);
        elseif (prefix == "dgks_KillSoundEvent") then
		    --Old troubleshooting line FIXME
		    --dgks:Print(prefix .. text .. type .. target)
            dgks:dgks_SoundPack(dgks:GetKillshotSound(tonumber(text)))
        elseif (prefix == "dgks_KilledSoundEvent") then
            dgks:dgks_SoundPack("humiliation.wav");
        elseif (prefix == "dgks_BGVersionCheckRequest") then
            dgks:dgks_SendVersionResponse(text, "BATTLEGROUND");
        elseif (prefix == "dgks_RaidVersionCheckRequest") then
            dgks:dgks_SendVersionResponse(text, "RAID");
        elseif (prefix == "dgks_GuildVersionCheckRequest") then
            dgks:dgks_SendVersionResponse(text, "GUILD");
        elseif (prefix == "dgks_VersionCheckResponse") then
            local nameLength = string.len(UnitName("player"));
            if (UnitName("player") == string.sub(text, 0, nameLength)) then
                local startIndex = nameLength + 2;
                dgks:Print(string.sub(text, startIndex));
            else
                dgks:Print("didn't match: " .. text);
            end
        end
    end
end


function dgks:CombatLogEventHandler(info, timestamp, event, sourceGUID, sourceName, sourceFlags, destGUID, destName, destFlags)
    --if (not UnitIsPVP("Player")) then return; end; -- does dueling flag you? this most likely need removed because it breaks dueling
	if (event == nil) then return; end;
	--Good job omgwtfbbq on this next part
    if (event == "PARTY_KILL") then
        if (sourceFlags == nil) then return; end;
        if (destName == nil) then return; end;
        if (destFlags == nil) then return; end;
        if (bit.band(sourceFlags, COMBATLOG_OBJECT_AFFILIATION_MINE) == COMBATLOG_OBJECT_AFFILIATION_MINE) then
            if (bit.band(destFlags, COMBATLOG_OBJECT_TYPE_PLAYER) == COMBATLOG_OBJECT_TYPE_PLAYER) then
				dgks:dgks_Killshot(UnitName("player"), destName,timestamp);
				-- Do we really want pet kills?
				--if (kspetkills) then
				--	elseif (bit.band(destFlags, COMBATLOG_OBJECT_TYPE_PET) == COMBATLOG_OBJECT_TYPE_PET) then
				--			if (bit.band(destFlags, COMBATLOG_OBJECT_CONTROL_PLAYER) == COMBATLOG_OBJECT_CONTROL_PLAYER) then
				--			if (not bit.band(destFlags, COMBATLOG_OBJECT_AFFILIATION_MINE) == COMBATLOG_OBJECT_AFFILIATION_MINE) then
				--				dgks:dgks_Killshot(UnitName("player"), "an enemy pet, " .. destName);
				--			end
				--		end
				--	end
				--end
			end
        end
    end
end

function dgks:dgks_Killshot(killer, victim, timestamp)
	killingstreak = killingstreak + 1
    deathstreak = 0
    if (dgks.db.profile.ksdoemote) then
		SendChatMessage(self.db.profile.ksmsg .. " " .. victim .. "! Streak of " .. killingstreak .. "!", "EMOTE")
	end;
    dgks:ScrollText("You " .. self.db.profile.ksmsg .. " " ..  victim .. "!");
    SendAddonMessage("dgks_ScrollingTextEvent", killer .. " " .. self.db.profile.ksmsg .. " " ..  victim .. "!",dgks:GetMessageGroup());
    SendAddonMessage("dgks_KillSoundEvent", killingstreak, dgks:GetMessageGroup());
    dgks:dgks_SoundPack(dgks:GetKillshotSound(killingstreak));
	-- Check for multikill
	if((dgks_lastkill + 5) > timestamp) then
		-- Ladies and Gentlemen we have a multikill
		dgks_multikill = dgks_multikill + 1;
		-- This most like will never be used except in test mode, but lets prevent the error anyways
		if (dgks_multikill > table.maxn(self.db.profile.kstextM)) then dgks_multikill = table.maxn(self.db.profile.kstextM); end;
		dgks:ScrollText(killer .. " has got a " .. self.db.profile.kstextM[dgks_multikill] .. "!");
		SendAddonMessage("dgks_ScrollingTextEvent", killer .. " got a " .. self.db.profile.kstextM[dgks_multikill] .. "!", dgks:GetMessageGroup());
		SendAddonMessage("dgks_KillSoundEvent", killingstreak, dgks:GetMessageGroup());
		dgks:dgks_SoundPack(self.db.profile.kssoundM[dgks_multikill]);
	else dgks_multikill = 0; end;
	dgks_lastkill = timestamp;
end

function dgks:PlayerDeathHandler(info)
    if (not UnitIsPVP("Player")) then return; end;
    dgks:PlayerDeath();
end

function dgks:PlayerDeath()
    killingstreak = 0;
    deathstreak = deathstreak + 1;
	-- fixme, deathstreak functions disabled for now
	if (ksdeathstreak) then
		if (deathstreak > 1) then
			dgks:ScrollText("On a streak of " .. deathstreak .. " deaths!");
			SendAddonMessage("dgks_ScrollingTextEvent", UnitName("player") .. " is on a streak of " .. deathstreak .. " deaths!", dgks:GetMessageGroup());
		end
		if (deathstreak == 5 or deathstreak == 10 or deathstreak == 15) then
			SendAddonMessage("dgks_KilledSoundEvent", deathstreak, dgks:GetMessageGroup());
			dgks:dgks_SoundPack("humiliation.wav");
		end
	end
end

function dgks:GetKillshotSound(killingstreak)
	for x = 7, 1, -1 do
		if (dgks.db.profile.ksrank[x] > -1) and (killingstreak >= dgks.db.profile.ksrank[x]) then return dgks.db.profile.kssound[x]; end
	end  
    --If we get here the user has messed up their config we could build some sort of safety someday but for now we will just default to kssound1 FIXME
	return dgks.db.profile.kssound1;
end

function dgks:ScrollText(msg)
    LS2.Pour(dgks, msg, 1.0, 0.1, 0.1)
end

function dgks:dgks_SendVersionResponse(requester, targetGroup)
    SendAddonMessage("dgks_VersionCheckResponse", requester .. ":" .. UnitName("player") .. " is on version " .. KSVERSION , targetGroup);
end

function dgks:CheckBGVersions()
    SendAddonMessage("dgks_BGVersionCheckRequest", UnitName("player"), "BATTLEGROUND");
    dgks:Print(UnitName("player") .. " is on version " .. KSVERSION);
end

function dgks:CheckGuildVersions()
    SendAddonMessage("dgks_GuildVersionCheckRequest", UnitName("player"), "GUILD");
    dgks:Print(UnitName("player") .. " is on version " .. KSVERSION);
end

function dgks:CheckRaidVersions()
    SendAddonMessage("dgks_RaidVersionCheckRequest", UnitName("player"), "RAID");
    dgks:Print(UnitName("player") .. " is on version " .. KSVERSION);
end

function dgks:dgks_SoundPack(sound)
	-- BANDAID FIX ME
	if not sound then sound = 1; end
    local soundfile = self.db.profile.soundpath .. sound;
    dgks:SoundEventHandler(info, soundfile);
end

function dgks:getSoundPack()
    return self.db.profile.soundpack;
end

function dgks:setSoundPack(info, newsoundset)
    if (newsoundset == "male") then
        self.db.profile.soundpack = newsoundset;
        self.db.profile.soundpath = "Interface\\AddOns\\dgks\\sounds\\";
    elseif (newsoundset == "female") then
        if (IsAddOnLoaded("dgks_female")) then
            self.db.profile.soundpack = newsoundset;
            self.db.profile.soundpath = "Interface\\AddOns\\dgks_female\\";
        else 
            message("That addon is not enabled");
        end
    elseif (newsoundset == "sexy") then
        if (IsAddOnLoaded("dgks_sexy")) then
            self.db.profile.soundpack = newsoundset;
            self.db.profile.soundpath = "Interface\\AddOns\\dgks_sexy\\";
        else 
            message("That addon is not enabled");
        end
    elseif (newsoundset == "baby") then
        if (IsAddOnLoaded("dgks_baby")) then
            self.db.profile.soundpack = newsoundset;
            self.db.profile.soundpath = "Interface\\AddOns\\dgks_baby\\";
        else 
            message("That addon is not enabled");
        end
    else
        message("Error: That is not a valid option");
    end
end

function dgks:GetMessageGroup()
    local targetGroup = "RAID";
    local zone = GetZoneText();
    if (dgks:IsInBattleground() == true) then
        targetGroup = "BATTLEGROUND";
    end
    return targetGroup;
end

function dgks:IsInBattleground()
    local inBG = 0;
    local zone = GetZoneText();
    if ((zone == "Warsong Gulch") or (zone == "Eye of the Storm") or (zone == "Arathi Basin") or (zone == "Alterac Valley")) then
        inBG = 1;
    end
    return inBG;
end

function dgks:getMessage()
    return self.db.profile.ksmsg;
end

function dgks:setMessage(newmsg)
    self.db.profile.ksmsg = newmsg;
end

function dgks:Test()
	dgks:CombatLogEventHandler(info, GetTime(), "PARTY_KILL", 1, 1, COMBATLOG_OBJECT_AFFILIATION_MINE, 1, "VictimName", COMBATLOG_OBJECT_TYPE_PLAYER)
end
	function dgks:TestPlayerDeath()
	dgks:PlayerDeath()
end

function dgks:OnEnable()
    self:RegisterEvent("dgks_SoundEvent", "SoundEventHandler");
    self:RegisterEvent("PLAYER_DEAD", "PlayerDeathHandler");
    self:RegisterEvent("CHAT_MSG_ADDON", "AddonMessageHandler");
    self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED", "CombatLogEventHandler");
    -- might need this back for bg only mode
	--self:RegisterEvent("ZONE_CHANGED_NEW_AREA", "ZoneChangedHandler");
end