function dbCraftOptions_Toggle()
  if(dbCraftOptionsFrame:IsVisible()) then
    dbCraftOptionsFrame:Hide();
  else
    dbCraftOptionsFrame:Show();
  end
end

function dbCraftOptions_ClampedToggle()
  if(dbCraftOptions.Clamped) then
    dbCraftOptions.Clamped = false;
  else
    dbCraftOptions.Clamped = true;
  end
  dbCraftFrame:SetClampedToScreen(dbCraftOptions.Clamped);
  dbCraftOptions_Init();
end

function dbCraftOptions_HideMessagesToggle()
  if(dbCraftOptions.HideMessages) then
    dbCraftOptions.HideMessages = false;
  else
    dbCraftOptions.HideMessages = true;
  end
  dbCraftOptions_Init();
end

function dbCraftOptions_OnLoad()
  UIPanelWindows['dbCraftOptionsFrame'] = {area = 'center', pushable = 0};
end

function dbCraftOptions_Init()
  dbCraftOptionsFrameToggleButton:SetChecked(dbCraftOptions.ButtonShown);
  dbCraftOptionsFrameClamped:SetChecked(dbCraftOptions.Clamped);
  dbCraftOptionsFrameHideMessages:SetChecked(dbCraftOptions.HideMessages);
  dbCraftOptionsFrameSliderButtonPos:SetValue(dbCraftOptions.ButtonPosition);
  dbCraftOptionsFrameSliderButtonRad:SetValue(dbCraftOptions.ButtonRadius);
  dbCraftOptionsFrameSliderReminder:SetValue(dbCraftOptions.Reminder);
  dbCraftOptionsFrameSliderAlpha:SetValue(dbCraftOptions.Alpha);
  dbCraftOptionsFrameSliderScale:SetValue(dbCraftOptions.Scale);
end

function dbCraftOptions_ResetPosition()
  dbCraftFrame:SetPoint("TOPLEFT", 0, -104);
  dbCraftOptions.ButtonPosition = 15;
  dbCraftOptions.ButtonRadius = 78;
  dbCraftOptions.Reminder = 7;
  dbCraftOptions.Alpha = 1.0;
  dbCraftOptions.Scale = 1.0;
  dbCraftOptions_Init();
end

function dbCraftOptions_SetupSlider(text, mymin, mymax, step)
  getglobal(this:GetName().."Text"):SetText(text.." ("..this:GetValue()..")");
  this:SetMinMaxValues(mymin, mymax);
  getglobal(this:GetName().."Low"):SetText(mymin);
  getglobal(this:GetName().."High"):SetText(mymax);
  this:SetValueStep(step);
end

local function round(num, idp)
   local mult = 10 ^ (idp or 0);
   return math.floor(num * mult + 0.5) / mult;
end

function dbCraftOptions_UpdateSlider(text)
  getglobal(this:GetName().."Text"):SetText(text.." ("..round(this:GetValue(),2)..")");
end
