function dbCraftButton_OnClick()
  dbCraft_Toggle();
end

function dbCraftButton_Init()
  if(dbCraftOptions.ButtonShown) then
    dbCraftButtonFrame:Show();
  else
    dbCraftButtonFrame:Hide();
  end
end

function dbCraftButton_Toggle()
  if(dbCraftButtonFrame:IsVisible()) then
    dbCraftButtonFrame:Hide();
    dbCraftOptions.ButtonShown = false;
  else
    dbCraftButtonFrame:Show();
    dbCraftOptions.ButtonShown = true;
  end
  dbCraftOptions_Init();
end

function dbCraftButton_UpdatePosition()
  dbCraftButtonFrame:SetPoint("TOPLEFT", "Minimap", "TOPLEFT",
    54 - (dbCraftOptions.ButtonRadius * cos(dbCraftOptions.ButtonPosition)),
    (dbCraftOptions.ButtonRadius * sin(dbCraftOptions.ButtonPosition)) - 55
  );
  dbCraftOptions_Init();
end

function dbCraftButton_BeingDragged()
    local xpos,ypos = GetCursorPosition()
    local xmin,ymin = Minimap:GetLeft(), Minimap:GetBottom()

    xpos = xmin-xpos/UIParent:GetScale()+70
    ypos = ypos/UIParent:GetScale()-ymin-70

    dbCraftButton_SetPosition(math.deg(math.atan2(ypos,xpos)));
end

function dbCraftButton_SetPosition(v)
    if(v < 0) then
        v = v + 360;
    end

    dbCraftOptions.ButtonPosition = v;
    dbCraftButton_UpdatePosition();
end

function dbCraftButton_OnEnter()
  GameTooltip:SetOwner(this, "ANCHOR_LEFT");
  GameTooltip:SetText(DBCRAFT_BUTTON_TOOLTIP_TITLE);
  GameTooltipTextLeft1:SetTextColor(1, 1, 1);
  GameTooltip:AddLine(DBCRAFT_BUTTON_TOOLTIP_HINT);
  GameTooltip:Show();
end
