function GetMinimapShape() return "SQUARE" end

local addon = CreateFrame"Frame"
  
  local frames = {
    MinimapZoomIn,
    MinimapZoomOut,
    MinimapBorderTop,
    MinimapToggleButton,
    MiniMapWorldMapButton,
    MiniMapVoiceChatFrame,
    MinimapNorthTag,
    MinimapBorder,
    GameTimeFrame,
  }
  
  addon:SetScript("OnEvent", function()
  
  	if(event=="PLAYER_LOGIN") then
  	
          Minimap:EnableMouseWheel(true)
          Minimap:SetScript("OnMouseWheel", function(self, z)
              local c = Minimap:GetZoom()
              if(z > 0 and c < 5) then
                  Minimap:SetZoom(c + 1)
              elseif(z < 0 and c > 0) then
                  Minimap:SetZoom(c - 1)
              end
          end)


-- edit the following Lines to change the minimaps location           
          Minimap:SetPoint("Top",0,-30)
          Minimap:SetPoint("Right",-30,0)

-- hide the ugly gap
	Minimap:SetBackdrop({ 
		bgFile ="Interface\\ChatFrame\\ChatFrameBackground",
		insets = {left = -2, right = -2, top = -2, bottom = -2},
	}) 
	Minimap:SetBackdropColor(0, 0, 0)

  	MiniMapMailBorder:Hide()
	MiniMapMailFrame:ClearAllPoints()
	MiniMapMailFrame:SetPoint("BOTTOMRIGHT", Minimap)
	MiniMapMailIcon:SetTexture"Interface\\AddOns\\dMiniMap\\mail"
	
	Minimap:SetScript("OnEnter", function() MinimapZoneTextButton:Show() end)
	Minimap:SetScript("OnLeave", function() MinimapZoneTextButton:Hide() end)
	MinimapZoneText:SetPoint("TOP", Minimap, 0, 17)
	MinimapZoneTextButton:Hide()
  
          MiniMapTrackingBorder:Hide()
          MiniMapTrackingBackground:Hide()
          MiniMapTracking:SetParent(Minimap)
          MiniMapTracking:ClearAllPoints()
          MiniMapTracking:SetPoint("TOPLEFT", -2, 2)
          MiniMapBattlefieldBorder:Hide()
          MiniMapBattlefieldFrame:SetParent(Minimap)
          MiniMapBattlefieldFrame:ClearAllPoints()
          MiniMapBattlefieldFrame:SetPoint("TOPRIGHT", -2, -2)
          Minimap:SetMaskTexture"Interface\\AddOns\\dMiniMap\\mask"
-- change minimap scale
          Minimap:SetScale(0.55)
      		
      		local f = CreateFrame("Frame", "bordergloss")
          f:SetPoint("TOPLEFT", Minimap, "TOPLEFT", -2, 2)
          f:SetPoint("BOTTOMRIGHT", Minimap, "BOTTOMRIGHT", 2, -2)
          
          local t = f:CreateTexture(nil,"ARTWORK")
          t:SetTexture("Interface\\AddOns\\dMiniMap\\border")
          t:SetPoint("TOPLEFT", f, "TOPLEFT", -0, 0)
          t:SetPoint("BOTTOMRIGHT", f, "BOTTOMRIGHT", 0, -0)
          f.texture = t

          
          for _, frame in pairs(frames) do
              frame:Hide()
              frame.Show = function() end
          end
          
  	end
  end)
  
  addon:RegisterEvent"PLAYER_LOGIN"