--[[
	cyCircled - simpleSquare by Scyth
	
	Skin authors may use this package a base for their own skin packs.
	Please see skins.lua in the cyCircled package for information on attributes.
]]

-- Initialize the add-on.
cyCircled_simpleSquare = AceLibrary("AceAddon-2.0"):new()

-- Configuration table.
local skins = {
	["simpleSquare"] = {
		["icon"] 	= { w=32, h=32, dl="BACKGROUND" },
		["overlay"] = { w=40, h=40, dl="BORDER", tex="Interface\\AddOns\\cyCircled_simpleSquare\\textures\\simpleSquareBase", },
		["equip"] 	= { w=40, h=40, tex="Interface\\AddOns\\cyCircled_simpleSquare\\textures\\simpleSquareHighlight", },
		["cooldown"]= { w=37, h=37, fl=2, s=.75, },
		["flash"]	= { w=40, h=40, dl="OVERLAY", tex="Interface\\AddOns\\cyCircled_simpleSquare\\textures\\simpleSquareFlash", bm="BLEND", },
		["hotkey"]	= { x=4, y=16, dl="OVERLAY", },
		["count"]	= { x=0, y=-8, dl="OVERLAY", },
		["bagicon"]	= { w=32, h=32, },
		["autocast"]= { w=29, h=28, y=-1, fl=2, },
		["autocastable"]= { w=54, h=54, y=-1, },
	
		["NormalTexture"] 		= { w=1, h=1, x=4, y=-4, r="CENTER", rp="TOPLEFT", },
		["HighlightTexture"] 	= { w=40, h=40, dl="HIGHLIGHT", tex="Interface\\AddOns\\cyCircled_simpleSquare\\textures\\simpleSquareHighlight", bm="BLEND", },
		["PushedTexture"] 		= { w=40, h=40, tex="Interface\\AddOns\\cyCircled_simpleSquare\\textures\\simpleSquareHighlight", bm="ADD", },
		["CheckedTexture"]		= { w=40, h=40, dl="ARTWORK", tex="Interface\\AddOns\\cyCircled_simpleSquare\\textures\\simpleSquareActive", bm="BLEND", },
	},
	["simpleSquare - Gloss"] = {
		["icon"] 	= { w=32, h=32, dl="BACKGROUND" },
		["overlay"] = { w=40, h=40, dl="BORDER", tex="Interface\\AddOns\\cyCircled_simpleSquare\\textures\\simpleSquareGloss", },
		["equip"] 	= { w=40, h=40, tex="Interface\\AddOns\\cyCircled_simpleSquare\\textures\\simpleSquareHighlight", },
		["cooldown"]= { w=37, h=37, fl=2, s=.75, },
		["flash"]	= { w=40, h=40, dl="OVERLAY", tex="Interface\\AddOns\\cyCircled_simpleSquare\\textures\\simpleSquareFlash", bm="BLEND", },
		["hotkey"]	= { x=4, y=16, dl="OVERLAY", },
		["count"]	= { x=0, y=-8, dl="OVERLAY", },
		["bagicon"]	= { w=32, h=32, },
		["autocast"]= { w=29, h=28, y=-1, fl=2, },
		["autocastable"]= { w=54, h=54, y=-1, },
	
		["NormalTexture"] 		= { w=1, h=1, x=4, y=-4, r="CENTER", rp="TOPLEFT", },
		["HighlightTexture"] 	= { w=40, h=40, dl="HIGHLIGHT", tex="Interface\\AddOns\\cyCircled_simpleSquare\\textures\\simpleSquareHighlight", bm="BLEND", },
		["PushedTexture"] 		= { w=40, h=40, tex="Interface\\AddOns\\cyCircled_simpleSquare\\textures\\simpleSquareHighlight", bm="ADD", },
		["CheckedTexture"]		= { w=40, h=40, dl="ARTWORK", tex="Interface\\AddOns\\cyCircled_simpleSquare\\textures\\simpleSquareActive", bm="BLEND", },
	},
}

-- Insert the skins into cyCircled
function cyCircled_simpleSquare:OnEnable()
	for k, v in pairs(skins) do
		cyCircled.skins[k] = v
	end

	cyCircled:UpdateSkinList()

	-- Make sure that it loads the right skin.
	if cyCircled.skins[cyCircled.db.profile.current] then
		cyCircled.db.profile.skin = cyCircled.db.profile.current
	end
end