--[[
	cyCircled - simpleSphere by Scyth
	
	Skin authors may use this package a base for their own skin packs.
	Please see skins.lua in the cyCircled package for information on attributes.
]]

-- Initialize the add-on.
cyCircled_simpleSphere = AceLibrary("AceAddon-2.0"):new()

-- Configuration table.
local skins = {
	["simpleSphere"] = {
		["icon"] 	= { w=26, h=25, dl="BACKGROUND" },
		["overlay"] = { w=43, h=43, tex="Interface\\AddOns\\cyCircled_simpleSphere\\textures\\simpleSphereBase", },
		["equip"] 	= { w=46, h=46, tex="Interface\\AddOns\\cyCircled_simpleSphere\\textures\\simpleSphereHighlight", },
		["flash"]	= { w=30, h=30, tex="Interface\\AddOns\\cyCircled\\textures\\overlayred", a=.6, },
		["cooldown"]= { w=36, h=36, fl=0, s=.7, },
		["hotkey"]	= { x=2, y=11, dl="OVERLAY", },
		["count"]	= { x=10, y=-8, dl="OVERLAY", },
		["bagicon"]	= { w=26, h=25, x=6, y=-6, },
		["autocast"]= { w=30, h=30, fl=0, s=.88, },
		["autocastable"]= { w=57, h=62, x=0.5, y=-0.5, },
		
		["NormalTexture"] 		= { w=1, h=1, x=4, y=-4, r="CENTER", rp="TOPLEFT", },
		["HighlightTexture"] 	= { w=43, h=43, tex="Interface\\AddOns\\cyCircled_simpleSphere\\textures\\simpleSphereHighlight", bm="BLEND", },
		["PushedTexture"] 		= { w=46, h=46, tex="Interface\\AddOns\\cyCircled_simpleSphere\\textures\\simpleSphereActive", bm="ADD", },
		["CheckedTexture"]		= { w=46, h=46, tex="Interface\\AddOns\\cyCircled_simpleSphere\\textures\\simpleSphereActive", bm="BLEND", },
	},
	["simpleSphere - Classic"] = {
		["icon"] 		= { w=26, h=25, dl="BACKGROUND" },
		["overlay"] 	= { w=43, h=43, tex="Interface\\AddOns\\cyCircled_simpleSphere\\textures\\simpleSpherebase", },
		["equip"] 		= { w=46, h=46, tex="Interface\\AddOns\\cyCircled_simpleSphere\\textures\\simpleSpherebase", },
		["flash"]		= { w=30, h=30, tex="Interface\\AddOns\\cyCircled\\textures\\overlayred", a=.6, },
		["cooldown"]	= { w=36, h=36, fl=0, s=.7, },
		["hotkey"]		= { x=2, y=11, dl="OVERLAY", },
		["count"]		= { x=10, y=-8, dl="OVERLAY", },
		["bagicon"]		= { w=26, h=25, x=6, y=-6, },
		["autocast"]	= { w=30, h=30, fl=0, s=.88, },
		["autocastable"]= { w=57, h=62, x=0.5, y=-0.5, },
		["NormalTexture"] 		= { w=1, h=1, x=4, y=-4, r="CENTER", rp="TOPLEFT", },
		
		["HighlightTexture"]	= { w=38, h=37, tex="Interface\\Minimap\\UI-Minimap-ZoomButton-Highlight", bm="ADD", },
		["PushedTexture"] 		= { w=38, h=37, tex="Interface\\Minimap\\UI-Minimap-ZoomButton-Highlight", bm="ADD", },
		["CheckedTexture"]		= { w=38, h=37, tex="Interface\\Minimap\\UI-Minimap-ZoomButton-Highlight", bm="ADD", },
	},
	["simpleSphereSphere - Gloss"] = {
		["icon"] 	= { w=26, h=25, dl="BACKGROUND" },
		["overlay"] = { w=43, h=43, tex="Interface\\AddOns\\cyCircled_simpleSphere\\textures\\simpleSphereGloss", },
		["equip"] 	= { w=46, h=46, tex="Interface\\AddOns\\cyCircled_simpleSphere\\textures\\simpleSphereHighlight", },
		["flash"]	= { w=30, h=30, tex="Interface\\AddOns\\cyCircled\\textures\\overlayred", a=.6, },
		["cooldown"]= { w=36, h=36, fl=0, s=.7, },
		["hotkey"]	= { x=2, y=11, dl="OVERLAY", },
		["count"]	= { x=10, y=-8, dl="OVERLAY", },
		["bagicon"]	= { w=26, h=25, x=6, y=-6, },
		["autocast"]= { w=30, h=30, fl=0, s=.88, },
		["autocastable"]= { w=57, h=62, x=0.5, y=-0.5, },
		
		["NormalTexture"] 		= { w=1, h=1, x=4, y=-4, r="CENTER", rp="TOPLEFT", },
		["HighlightTexture"] 	= { w=43, h=43, tex="Interface\\AddOns\\cyCircled_simpleSphere\\textures\\simpleSphereHighlight", bm="BLEND", },
		["PushedTexture"] 		= { w=46, h=46, tex="Interface\\AddOns\\cyCircled_simpleSphere\\textures\\simpleSphereActive", bm="ADD", },
		["CheckedTexture"]		= { w=46, h=46, tex="Interface\\AddOns\\cyCircled_simpleSphere\\textures\\simpleSphereActive", bm="BLEND", },
	},
}

-- Insert the skins into cyCircled
function cyCircled_simpleSphere:OnEnable()
	for k, v in pairs(skins) do
		cyCircled.skins[k] = v
	end

	cyCircled:UpdateSkinList()

	-- Make sure that it loads the right skin.
	if cyCircled.skins[cyCircled.db.profile.current] then
		cyCircled.db.profile.skin = cyCircled.db.profile.current
	end
end