--[[
	cyCircled: Winnie The Pooh by art3mis
	
	Skin authors may use this package a base for their own skin packs.
	Please see skins.lua in the cyCircled package for information on attributes.
]]

-- Initialize the add-on.
cyCircled_Pooh = AceLibrary("AceAddon-2.0"):new()

-- Configuration table.
local skins = {
	["Hunny Pots"] = {
		["HighlightTexture"]	= { w=36, h=37, dl="HIGHLIGHT", tex="Interface\\AddOns\\cyCircled_Pooh\\textures\\poohHighlight", bm="ADD", },
		["hotkey"]			= { x=3, y=13, dl="OVERLAY", },
		["count"]			= { x=8, y=-8, dl="OVERLAY", },
		["CheckedTexture"]	= { w=40, h=40, dl="OVERLAY", tex="Interface\\AddOns\\cyCircled_Pooh\\textures\checked", },
		["overlay"]			= { w=37, h=36, dl="OVERLAY", tex="Interface\\AddOns\\cyCircled_Pooh\\textures\\PoohOverlay", },
		["equip"]			= { w=36, h=36, dl="ARTWORK", tex="Interface\\AddOns\\cyCircled_Pooh\\textures\\equip", bm="ADD", },
		["flash"]			= { w=36, h=36, dl="ARTWORK", tex="Interface\\AddOns\\cyCircled_Pooh\\textures\\flash", bm="ADD", },
		["PushedTexture"] 	= { w=36, h=36, dl="ARTWORK", tex="Interface\\AddOns\\cyCircled_Pooh\\textures\\pushed", bm="ADD", },
		["cooldown"]		= { w=22, h=22, fl=2, s=1, },
		["autocast"]		= { w=24, h=24, fl=2, x=0.5, y=-0.5, },
		["autocastable"]		= { w=50, h=50, x=0.5, y=-0.5, },
		["icon"]			= { w=20.5, h=22, y=-0.5, dl="BACKGROUND",},
		["bagicon"]			= { w=20, h=22, dl="BACKGROUND", },
		["NormalTexture"]		= { w=1, h=1, dl="BACKGROUND", },
	},
}

-- Insert the skins into cyCircled
function cyCircled_Pooh:OnEnable()
	for k, v in pairs(skins) do
		cyCircled.skins[k] = v
	end

	cyCircled:UpdateSkinList()

	-- Make sure that it loads the right skin.
	if cyCircled.skins[cyCircled.db.profile.current] then
		cyCircled.db.profile.skin = cyCircled.db.profile.current
	end
end