--[[
	cyCircled: Pandarian by art3mis
	
	Skin authors may use this package a base for their own skin packs.
	Please see skins.lua in the cyCircled package for information on attributes.
]]

-- Initialize the add-on.
cyCircled_Panda = AceLibrary("AceAddon-2.0"):new()

-- Configuration table.
local skins = {
	["Pandarian"] = {
		["HighlightTexture"]	= { w=33, h=32, dl="HIGHLIGHT", tex="Interface\\AddOns\\cyCircled_Panda\\textures\\panda_highlight", bm="ADD", },
		["hotkey"]			= { x=3, y=13, dl="OVERLAY", },
		["count"]			= { x=8, y=-8, dl="OVERLAY", },
		["CheckedTexture"]	= { w=36, h=36, dl="OVERLAY", tex="Interface\\AddOns\\cyCircled_Panda\\textures\checked", },
		["overlay"]			= { w=35, h=28, dl="OVERLAY", tex="Interface\\AddOns\\cyCircled_Panda\\textures\\panda_overlay", },
		["equip"]			= { w=33, h=32, dl="ARTWORK", tex="Interface\\AddOns\\cyCircled_Panda\\textures\\equip", bm="ADD", },
		["flash"]			= { w=33, h=32, dl="ARTWORK", tex="Interface\\AddOns\\cyCircled_Panda\\textures\\flash", bm="ADD", },
		["PushedTexture"] 	= { w=32, h=32, dl="ARTWORK", tex="Interface\\AddOns\\cyCircled_Panda\\textures\\pushed", bm="ADD", },
		["cooldown"]		= { w=22, h=22, fl=2, s=1, },
		["autocast"]		= { w=24, h=24, fl=2, x=0.5, y=-0.5, },
		["autocastable"]		= { w=50, h=50, x=0.5, y=-0.5, },
		["icon"]			= { w=22, h=22, dl="BACKGROUND", },
		["bagicon"]			= { w=22, h=22, dl="BACKGROUND", },
		["NormalTexture"]		= { w=1, h=1, dl="BACKGROUND", },
	},
}

-- Insert the skins into cyCircled
function cyCircled_Panda:OnEnable()
	for k, v in pairs(skins) do
		cyCircled.skins[k] = v
	end

	cyCircled:UpdateSkinList()

	-- Make sure that it loads the right skin.
	if cyCircled.skins[cyCircled.db.profile.current] then
		cyCircled.db.profile.skin = cyCircled.db.profile.current
	end
end