--[[
	cyCircled: Onyx by Storm
]]

-- Check for cyCircled.
assert(cyCircled, "cyCircled is required for this skin to work.")
if type(cyCircled.skins) ~= "table" then
	return
end

-- Add the skin(s).
cyCircled.skins["Onyx: Square"] = {
	["icon"] 	= { w=32, h=32, dl="BACKGROUND" },
	["overlay"] = { w=40, h=40, dl="BORDER", tex="Interface\\AddOns\\cyCircled_Onyx\\textures\\Base", },
	["equip"] 	= { w=40, h=40, tex="Interface\\AddOns\\cyCircled_Onyx\\textures\\Highlight", },
	["cooldown"]= { w=37, h=37, fl=2, s=.75, },
	["flash"]	= { w=40, h=40, dl="OVERLAY", tex="Interface\\AddOns\\cyCircled_Onyx\\textures\\Flash", bm="BLEND", },
	["hotkey"]	= { x=4, y=16, dl="OVERLAY", },
	["count"]	= { x=0, y=-8, dl="OVERLAY", },
	["bagicon"]	= { w=32, h=32, },
	["autocast"]= { w=29, h=28, y=-1, fl=2, },
	["autocastable"]= { w=54, h=54, y=-1, },
	
	["NormalTexture"] 		= { w=1, h=1, x=4, y=-4, r="CENTER", rp="TOPLEFT", },
	["HighlightTexture"] 	= { w=40, h=40, dl="HIGHLIGHT", tex="Interface\\AddOns\\cyCircled_Onyx\\textures\\Highlight", bm="BLEND", },
	["PushedTexture"] 		= { w=36, h=36, tex="Interface\\Minimap\\UI-Minimap-ZoomButton-Highlight", bm="ADD", },
	["CheckedTexture"]		= { w=40, h=40, dl="ARTWORK", tex="Interface\\AddOns\\cyCircled_Onyx\\textures\\Active", bm="BLEND", },
}
cyCircled.skins["Onyx: Square Gloss"] = {
	["icon"] 	= { w=32, h=32, dl="BACKGROUND" },
	["overlay"] = { w=40, h=40, dl="BORDER", tex="Interface\\AddOns\\cyCircled_Onyx\\textures\\Gloss", },
	["equip"] 	= { w=40, h=40, tex="Interface\\AddOns\\cyCircled_Onyx\\textures\\Highlight", },
	["cooldown"]= { w=37, h=37, fl=2, s=.75, },
	["flash"]	= { w=40, h=40, dl="OVERLAY", tex="Interface\\AddOns\\cyCircled_Onyx\\textures\\Flash", bm="BLEND", },
	["hotkey"]	= { x=4, y=16, dl="OVERLAY", },
	["count"]	= { x=0, y=-8, dl="OVERLAY", },
	["bagicon"]	= { w=32, h=32, },
	["autocast"]= { w=29, h=28, y=-1, fl=2, },
	["autocastable"]= { w=54, h=54, y=-1, },
	
	["NormalTexture"] 		= { w=1, h=1, x=4, y=-4, r="CENTER", rp="TOPLEFT", },
	["HighlightTexture"] 	= { w=40, h=40, dl="HIGHLIGHT", tex="Interface\\AddOns\\cyCircled_Onyx\\textures\\Highlight", bm="BLEND", },
	["PushedTexture"] 		= { w=36, h=36, tex="Interface\\Minimap\\UI-Minimap-ZoomButton-Highlight", bm="ADD", },
	["CheckedTexture"]		= { w=40, h=40, dl="ARTWORK", tex="Interface\\AddOns\\cyCircled_Onyx\\textures\\Active", bm="BLEND", },
}

-- Refresh the skin list.
if type(cyCircled.UpdateSkinList) == "function" then
	cyCircled:UpdateSkinList()
end

if type(cyCircled.db) ~= "table" then
	return
end

-- Make sure that it loads the right skin.
if cyCircled.skins[cyCircled.db.profile.current] then
	cyCircled.db.profile.skin = cyCircled.db.profile.current
end
