--[[
	Skin elements
		
		icon		Button icon
		overlay	Base texture overlay
		equip		Texture when an equipped item is linked to an action button
		flash		Texture for an currently active button (eg. "Attack")
		cooldown	Cooldown animation
		hotkey	Hotkey string
		count		Count string
		autocast	Autocast animation
		autocastable Autocast arrows
		
		NormalTexture
		HighlightTexture
		PushedTexture
		CheckedTexture
	
	Skin parameters
	
		w		Width
		h		Height
		x		x-offset (Default: 0)
		y		y-offset (Default: 0)
		p		Point (Default: CENTER)
		rp		Relative point (Default: CENTER)
		tex		Texture file (complete path)
		bm		Blend mode (for textures)
		dl		Draw layer (for textures)
		fl		Frame level
		fs		Frame strata
		s		Scale (Default: 1.0)
		a		Alpha (Default: 1.0)

]]

cyCircled.skins = {
	["Serenity"] = {
		["icon"] 	= { w=26, h=25, dl="BACKGROUND" },
		["overlay"] = { w=43, h=43, tex="Interface\\AddOns\\cyCircled\\textures\\SerenityBase", },
		["equip"] 	= { w=46, h=46, tex="Interface\\AddOns\\cyCircled\\textures\\SerenityHighLight", },
		["flash"]	= { w=30, h=30, tex="Interface\\AddOns\\cyCircled\\textures\\overlayred", a=.6, },
		["cooldown"]= { w=36, h=36, fl=0, s=.7, },
		["hotkey"]	= { x=2, y=11, dl="OVERLAY", },
		["count"]	= { x=10, y=-8, dl="OVERLAY", },
		["bagicon"]	= { w=26, h=25, x=6, y=-6, },
		["autocast"]= { w=30, h=30, fl=0, s=.88, },
		["autocastable"]= { w=57, h=62, x=0.5, y=-0.5, },
		
		["NormalTexture"] 		= { w=1, h=1, x=4, y=-4, r="CENTER", rp="TOPLEFT", }, -- this texture needs to be hidden, but setalpha is not possible as it's overritten
		["HighlightTexture"] 	= { w=43, h=43, tex="Interface\\AddOns\\cyCircled\\textures\\SerenityHighLight", bm="BLEND", },
		["PushedTexture"] 		= { w=46, h=46, tex="Interface\\AddOns\\cyCircled\\textures\\SerenityActive", bm="BLEND", dl="BACKGROUND", },
		["CheckedTexture"]		= { w=46, h=46, tex="Interface\\AddOns\\cyCircled\\textures\\SerenityActive", bm="BLEND", dl="BACKGROUND", },
	},
	["Serenity: Classic"] = {
		["icon"] 		= { w=26, h=25, dl="BACKGROUND" },
		["overlay"] 	= { w=43, h=43, tex="Interface\\AddOns\\cyCircled\\textures\\serenitybase", },
		["equip"] 		= { w=46, h=46, tex="Interface\\AddOns\\cyCircled\\textures\\serenitybase", },
		["flash"]		= { w=30, h=30, tex="Interface\\AddOns\\cyCircled\\textures\\overlayred", a=.6, },
		["cooldown"]	= { w=36, h=36, fl=0, s=.7, },
		["hotkey"]		= { x=2, y=11, dl="OVERLAY", },
		["count"]		= { x=10, y=-8, dl="OVERLAY", },
		["bagicon"]		= { w=26, h=25, x=6, y=-6, },
		["autocast"]	= { w=30, h=30, fl=0, s=.88, },
		["autocastable"]= { w=57, h=62, x=0.5, y=-0.5, },
		
		["NormalTexture"] 		= { w=1, h=1, x=4, y=-4, r="CENTER", rp="TOPLEFT", },
		["HighlightTexture"]	= { w=38, h=37, tex="Interface\\Minimap\\UI-Minimap-ZoomButton-Highlight", bm="ADD", },
		["PushedTexture"] 		= { w=38, h=37, tex="Interface\\Minimap\\UI-Minimap-ZoomButton-Highlight", bm="ADD", },
		["CheckedTexture"]		= { w=38, h=37, tex="Interface\\Minimap\\UI-Minimap-ZoomButton-Highlight", bm="ADD", },
	},
	["Serenity: Gloss"] = {
		["icon"] 	= { w=26, h=25, dl="BACKGROUND" },
		["overlay"] = { w=43, h=43, tex="Interface\\AddOns\\cyCircled\\textures\\SerenityGloss", },
		["equip"] 	= { w=46, h=46, tex="Interface\\AddOns\\cyCircled\\textures\\SerenityHighLight", },
		["flash"]	= { w=30, h=30, tex="Interface\\AddOns\\cyCircled\\textures\\overlayred", a=.6, },
		["cooldown"]= { w=36, h=36, fl=0, s=.7, },
		["hotkey"]	= { x=2, y=11, dl="OVERLAY", },
		["count"]	= { x=10, y=-8, dl="OVERLAY", },
		["bagicon"]	= { w=26, h=25, x=6, y=-6, },
		["autocast"]= { w=30, h=30, fl=0, s=.88, },
		["autocastable"]= { w=57, h=62, x=0.5, y=-0.5, },
		
		["NormalTexture"] 		= { w=1, h=1, x=4, y=-4, r="CENTER", rp="TOPLEFT", }, -- this texture needs to be hidden, but setalpha is not possible as it's overritten
		["HighlightTexture"] 	= { w=43, h=43, tex="Interface\\AddOns\\cyCircled\\textures\\SerenityHighlight", bm="BLEND", },
		["PushedTexture"] 		= { w=46, h=46, tex="Interface\\AddOns\\cyCircled\\textures\\SerenityActive", bm="BLEND", dl="BACKGROUND", },
		["CheckedTexture"]		= { w=46, h=46, tex="Interface\\AddOns\\cyCircled\\textures\\SerenityActive", bm="BLEND", dl="BACKGROUND", },
	},
	["Serenity: Square"] = {
		["icon"] 	= { w=32, h=32, dl="BACKGROUND" },
		["overlay"] = { w=37, h=37, tex="Interface\\AddOns\\cyCircled\\textures\\Square", },
		["equip"] 	= { w=46, h=46, tex="Interface\\AddOns\\cyCircled\\textures\\Square", },
		["cooldown"]= { w=36, h=36, fl=0, s=.9, },
		["flash"]	= { w=30, h=30, },
		["hotkey"]	= { x=-1, y=8, dl="OVERLAY", },
		["count"]	= { x=8, y=-6, dl="OVERLAY", },
		["bagicon"]	= { w=26, h=25, x=6, y=-6, },
		["autocast"]= { w=30, h=30, fl=0, s=1, },
		["autocastable"]= { w=57, h=62, x=0.5, y=-0.5, },
		
		["NormalTexture"] 		= { w=1, h=1, x=4, y=-4, r="CENTER", rp="TOPLEFT", },
		["HighlightTexture"] 	= { w=37, h=37, tex="Interface\\AddOns\\cyCircled\\textures\\SquareHighlight", bm="BLEND", },
		["PushedTexture"] 		= { w=38, h=37, tex="Interface\\Minimap\\UI-Minimap-ZoomButton-Highlight", bm="ADD", },
		["CheckedTexture"]		= { w=38, h=37, tex="Interface\\Minimap\\UI-Minimap-ZoomButton-Highlight", bm="ADD", },
	},
	["Serenity: Square Gloss"] = {
		["icon"] 	= { w=32, h=32, dl="BACKGROUND" },
		["overlay"] = { w=37, h=37, tex="Interface\\AddOns\\cyCircled\\textures\\SquareGloss", },
		["equip"] 	= { w=46, h=46, tex="Interface\\AddOns\\cyCircled\\textures\\Square", },
		["cooldown"]= { w=36, h=36, fl=0, s=.9, },
		["flash"]	= { w=30, h=30, },
		["hotkey"]	= { x=-1, y=8, dl="OVERLAY", },
		["count"]	= { x=8, y=-6, dl="OVERLAY", },
		["bagicon"]	= { w=26, h=25, x=6, y=-6, },
		["autocast"]= { w=30, h=30, fl=0, s=1, },
		["autocastable"]= { w=57, h=62, x=0.5, y=-0.5, },
		
		["NormalTexture"] 		= { w=1, h=1, x=4, y=-4, r="CENTER", rp="TOPLEFT", },
		["HighlightTexture"] 	= { w=37, h=37, tex="Interface\\AddOns\\cyCircled\\textures\\SquareHighlight", bm="BLEND", },
		["PushedTexture"] 		= { w=38, h=37, tex="Interface\\Minimap\\UI-Minimap-ZoomButton-Highlight", bm="ADD", },
		["CheckedTexture"]		= { w=38, h=37, tex="Interface\\Minimap\\UI-Minimap-ZoomButton-Highlight", bm="ADD", },
	},
	["Sprocket"] = {
		["icon"] 	= { w=26, h=25, dl="BACKGROUND" },
		["overlay"] = { w=43, h=43, tex="Interface\\AddOns\\cyCircled\\textures\\Sprocket",  },
		["equip"] 	= { w=46, h=46, tex="Interface\\AddOns\\cyCircled\\textures\\Sprocket", },
		["flash"]	= { w=30, h=30, tex="Interface\\AddOns\\cyCircled\\textures\\overlayred" },
		["cooldown"]= { w=36, h=36, fl=0, s=.7, },
		["hotkey"]	= { x=2, y=11, dl="OVERLAY", },
		["count"]	= { x=10, y=-8, dl="OVERLAY", },
		["bagicon"]	= { w=26, h=25, x=6, y=-6, },
		["autocast"]= { w=30, h=30, fl=0, s=.76, },
		["autocastable"]= { w=57, h=62, x=0.5, y=-0.5, },
		
		["NormalTexture"] 		= { w=1, h=1, x=4, y=-4, r="CENTER", rp="TOPLEFT", },
		["HighlightTexture"] 	= { w=43, h=43, tex="Interface\\AddOns\\cyCircled\\textures\\Sprocket", bm="BLEND", },
		["PushedTexture"] 		= { w=38, h=37, tex="Interface\\Minimap\\UI-Minimap-ZoomButton-Highlight", bm="ADD", },
		["CheckedTexture"]		= { w=38, h=37, tex="Interface\\Minimap\\UI-Minimap-ZoomButton-Highlight", bm="ADD", },
	},
	["Sprocket: Black"] = {
		["icon"] 	= { w=26, h=25, dl="BACKGROUND" },
		["overlay"] = { w=43, h=43, tex="Interface\\AddOns\\cyCircled\\textures\\SprocketBlack", bm="BLEND", },
		["equip"] 	= { w=46, h=46, tex="Interface\\AddOns\\cyCircled\\textures\\SprocketBlack", },
		["flash"]	= { w=30, h=30, tex="Interface\\AddOns\\cyCircled\\textures\\overlayred" },
		["cooldown"]= { w=36, h=36, fl=0, s=.7, },
		["hotkey"]	= { x=2, y=11, dl="OVERLAY", },
		["count"]	= { x=10, y=-8, dl="OVERLAY", },
		["bagicon"]	= { w=26, h=25, x=6, y=-6, },
		["autocast"]= { w=30, h=30, fl=0, s=.76, },
		["autocastable"]= { w=57, h=62, x=0.5, y=-0.5, },
		
		["NormalTexture"] 		= { w=1, h=1, x=4, y=-4, r="CENTER", rp="TOPLEFT", },
		["HighlightTexture"] 	= { w=43, h=43, tex="Interface\\AddOns\\cyCircled\\textures\\SprocketBlack", bm="BLEND", },
		["PushedTexture"] 		= { w=38, h=37, tex="Interface\\Minimap\\UI-Minimap-ZoomButton-Highlight", bm="ADD", },
		["CheckedTexture"]		= { w=38, h=37, tex="Interface\\Minimap\\UI-Minimap-ZoomButton-Highlight", bm="ADD", },
	},
	["Sprocket: Spark"] = {
		["icon"] 	= { w=26, h=25, dl="BACKGROUND" },
		["overlay"] = { w=43, h=43, tex="Interface\\AddOns\\cyCircled\\textures\\SprocketSpark", },
		["equip"] 	= { w=46, h=46, tex="Interface\\AddOns\\cyCircled\\textures\\SprocketSpark", },
		["flash"]	= { w=30, h=30, tex="Interface\\AddOns\\cyCircled\\textures\\overlayred" },
		["cooldown"]= { w=36, h=36, fl=0, s=.7, },
		["hotkey"]	= { x=2, y=11, dl="OVERLAY", },
		["count"]	= { x=10, y=-8, dl="OVERLAY", },
		["bagicon"]	= { w=26, h=25, },
		["autocast"]= { w=30, h=30, fl=0, s=.76, },
		["autocastable"]= { w=57, h=62, x=0.5, y=-0.5, },
		
		["NormalTexture"] 		= { w=1, h=1, x=4, y=-4, r="CENTER", rp="TOPLEFT", },
		["HighlightTexture"] 	= { w=43, h=43, tex="Interface\\AddOns\\cyCircled\\textures\\SprocketSpark", bm="BLEND", },
		["PushedTexture"] 		= { w=38, h=37, tex="Interface\\Minimap\\UI-Minimap-ZoomButton-Highlight", bm="ADD", },
		["CheckedTexture"]		= { w=38, h=37, tex="Interface\\Minimap\\UI-Minimap-ZoomButton-Highlight", bm="ADD", },
	},
	["Hex"] = {
		["icon"] 	= { w=26, h=25, dl="BACKGROUND" },
		["overlay"] = { w=43, h=43, tex="Interface\\AddOns\\cyCircled\\textures\\Hex0", },
		["equip"] 	= { w=46, h=46, tex="Interface\\AddOns\\cyCircled\\textures\\Hex0", },
		["flash"]	= { w=30, h=30, tex="Interface\\AddOns\\cyCircled\\textures\\overlayred", a=.6, },
		["cooldown"]= { w=36, h=36, fl=0, s=.7, },
		["hotkey"]	= { x=2, y=11, dl="OVERLAY", },
		["count"]	= { x=10, y=-8, dl="OVERLAY", },
		["bagicon"]	= { w=26, h=25, x=6, y=-6, },
		["autocast"]= { w=30, h=30, fl=0, s=.9, },
		["autocastable"]= { w=61, h=62, x=0.5 },
		
		["NormalTexture"] 		= { w=1, h=1, x=4, y=-4, r="CENTER", rp="TOPLEFT", }, -- this texture needs to be hidden, but setalpha is not possible as it's overritten
		["HighlightTexture"] 	= { w=43, h=43, tex="Interface\\AddOns\\cyCircled\\textures\\Hex0", bm="BLEND", },
		["PushedTexture"] 		= { w=46, h=46, tex="Interface\\AddOns\\cyCircled\\textures\\Hex1", bm="BLEND", dl="BACKGROUND", },
		["CheckedTexture"]		= { w=46, h=46, tex="Interface\\AddOns\\cyCircled\\textures\\Hex1", bm="BLEND", dl="BACKGROUND", },
	},
	["Hex: 90"] = {
		["icon"] 	= { w=27, h=27, dl="BACKGROUND" },
		["overlay"] = { w=43, h=43, tex="Interface\\AddOns\\cyCircled\\textures\\90Hex0", },
		["equip"] 	= { w=46, h=46, tex="Interface\\AddOns\\cyCircled\\textures\\90Hex0", },
		["flash"]	= { w=30, h=30, tex="Interface\\AddOns\\cyCircled\\textures\\overlayred", a=.6, },
		["cooldown"]= { w=36, h=36, fl=0, s=.7, },
		["hotkey"]	= { x=2, y=8, dl="OVERLAY", },
		["count"]	= { x=10, y=-8, dl="OVERLAY", },
		["bagicon"]	= { w=26, h=25, x=6, y=-6, },
		["autocast"]= { w=31, h=31, s=0.9, fl=0, },
		["autocastable"]= { w=62, h=61, y=-0.5 },
		
		["NormalTexture"] 		= { w=1, h=1, x=4, y=-4, r="CENTER", rp="TOPLEFT", }, -- this texture needs to be hidden, but setalpha is not possible as it's overritten
		["HighlightTexture"] 	= { w=43, h=43, tex="Interface\\AddOns\\cyCircled\\textures\\90Hex0", bm="BLEND", },
		["PushedTexture"] 		= { w=46, h=46, tex="Interface\\AddOns\\cyCircled\\textures\\90Hex1", bm="BLEND", dl="BACKGROUND", },
		["CheckedTexture"]		= { w=46, h=46, tex="Interface\\AddOns\\cyCircled\\textures\\90Hex1", bm="BLEND", dl="BACKGROUND", },
	},
	["LiteStep"] = {
		["icon"] 	= { w=32, h=32, dl="BACKGROUND" },
		["overlay"] = { w=37, h=37, tex="Interface\\AddOns\\cyCircled\\textures\\LiteStepBase", },
		["equip"] 	= { w=46, h=46, tex="Interface\\AddOns\\cyCircled\\textures\\LiteStepBase", },
		["cooldown"]= { w=36, h=36, fl=0, s=.9, },
		["flash"]	= { w=37, h=37, dl="OVERLAY", tex="Interface\\AddOns\\cyCircled\\textures\\LiteStepFlash", bm="ADD", },
		["hotkey"]	= { x=-1, y=8, dl="OVERLAY", },
		["count"]	= { x=8, y=-6, dl="OVERLAY", },
		["bagicon"]	= { w=26, h=25, x=6, y=-6, },
		["autocast"]= { w=30, h=30, fl=0, s=1, },
		["autocastable"]= { w=62, h=62, },
		
		["NormalTexture"] 		= { w=1, h=1, x=4, y=-4, r="CENTER", rp="TOPLEFT", },
		["HighlightTexture"] 	= { w=37, h=37, tex="Interface\\AddOns\\cyCircled\\textures\\LiteStepHighlight", bm="BLEND", },
		["PushedTexture"] 		= { w=38, h=37, tex="Interface\\Minimap\\UI-Minimap-ZoomButton-Highlight", bm="ADD", },
		["CheckedTexture"]		= { w=38, h=37, tex="Interface\\Minimap\\UI-Minimap-ZoomButton-Highlight", bm="ADD", },
	},
	["LiteStep: XLT"] = {
		["icon"] 	= { w=32, h=32, dl="BACKGROUND" },
		["overlay"] = { w=37, h=37, tex="Interface\\AddOns\\cyCircled\\textures\\LiteStepLTBase", },
		["equip"] 	= { w=46, h=46, tex="Interface\\AddOns\\cyCircled\\textures\\LiteStepLTBase", },
		["cooldown"]= { w=36, h=36, fl=0, s=.9, },
		["flash"]	= { w=37, h=37, dl="OVERLAY", tex="Interface\\AddOns\\cyCircled\\textures\\LiteStepLTBase", bm="BLEND", },
		["hotkey"]	= { x=-1, y=8, dl="OVERLAY", },
		["count"]	= { x=8, y=-6, dl="OVERLAY", },
		["bagicon"]	= { w=26, h=25, x=6, y=-6, },
		["autocast"]= { w=30, h=30, fl=0, s=1, },
		["autocastable"]= { w=62, h=62, },
		
		["NormalTexture"] 		= { w=1, h=1, x=4, y=-4, r="CENTER", rp="TOPLEFT", },
		["HighlightTexture"] 	= { w=37, h=37, tex="Interface\\AddOns\\cyCircled\\textures\\LiteStepLTBase", bm="BLEND"},
		["PushedTexture"] 		= { w=38, h=37, tex="Interface\\Minimap\\UI-Minimap-ZoomButton-Highlight", bm="ADD", },
		["CheckedTexture"]		= { w=38, h=37, tex="Interface\\Minimap\\UI-Minimap-ZoomButton-Highlight", bm="ADD", },
	},
}
