--[[
	Usage:
	1. copy this file to "cyCircled\plugins"
	2. Edit file "cycircled.toc", add this line into plugins list: "plugins\zBar2.lua"
]]

local addonName = "zBar2"

cyCircled_zBar2 = cyCircled:NewModule(addonName)

local bars = { ["zExButtons"] = "Extra Bars", }

function cyCircled_zBar2:GetElements()
	return bars
end

function cyCircled_zBar2:AddonLoaded(addon)
	if not zBar2.lite then
		bars["zMainBar"] = "Main Bar"
		bars["zMultiR1"] = "MultiBar Right"
		bars["zMultiR2"] = "MultiBar Left"
		bars["zMultiBR"] = "MultiBar BottomRight"
		bars["zMultiBL"] = "MultiBar BottomLeft"
		bars["zPetBar"] = "Pet Bar"
		bars["zStanceBar"] = "Stance Bar"
		bars["zPossessBar"] = "Possess Bar"
	end

	-- register
	self.db = cyCircled:AcquireDBNamespace(addonName)
	cyCircled:RegisterDefaults(addonName, "profile", self:GetElements())
	
	-- setup elements
	self.elements = {}
	
	for name in pairs(self:GetElements()) do
		self:SetBar(name)
	end
end

function cyCircled_zBar2:SetBar(name)
	self.elements[name] = {
		args = { button = { width = 36, height = 36, }, },
		elements = {},
	}
	
	if name == "zExButtons" then
		for i = 1, NUM_ZEXBAR_BUTTONS do
			table.insert(self.elements[name].elements, "zExButton"..i)
		end
		return
	elseif name == "zPossessBar" then
		for i = 1, 2 do
			table.insert(self.elements[name].elements, "zPossessButton"..i)
		end
		return
	end
	
	local num = 12
	if name == "zPetBar" then
		num = NUM_PET_ACTION_SLOTS
	elseif name == "zStanceBar" then
		num = NUM_SHAPESHIFT_SLOTS
	end
	
	for j=1, num do
		table.insert(self.elements[name].elements, zBar2.buttons[name..j])
		if name == "zPetBar" or name == "zStanceBar" then
			_G[zBar2.buttons[name..j]]:GetNormalTexture():SetAlpha(0)
		end
	end
end