--[[
	Usage:
	1. copy this file to "cyCircled\plugins"
	2. Edit file "cycircled.toc", add this line into plugins list: "plugins\zBar.lua"
]]

local addonName = "zBar"

cyCircled_zBar = cyCircled:NewModule(addonName)

function cyCircled_zBar:GetElements()
	return {
		["zBar1"] = true,
		["zBar2"] = true,
		["zBar3"] = true,
		["zBar4"] = true,
		["zBar9"] = true,
		["MultiBarLeft"] = true,
		["MultiBarRight"] = true,
		["MultiBarBottomRight"] = true,
		["MultiBarBottomLeft"] = true,
		["Action"] = true,
		["BonusAction"] = true,
		["PetAction"] = true,
		["Shapeshift"] = true,
	}
end

function cyCircled_zBar:AddonLoaded(addon)
	-- register
	self.db = cyCircled:AcquireDBNamespace(addonName)
	cyCircled:RegisterDefaults(addonName, "profile", self:GetElements())
	
	-- disable auto adjust grid size
	zBar_AutoAdjustGridSize = nil
	
	-- setup elements
	self.elements = {}
	
	for name in pairs(self:GetElements()) do
		self:SetBar(name)
	end
end

function cyCircled_zBar:SetBar(name)
	self.elements[name] = {
		args = {
			button = { width = 36, height = 36, },
			parentname = true,
		},
		elements = {},
	}
	
	local num = 12
	if name == "PetAction" or name == "Shapeshift" then
		num = 10
	end
	
	for j=1, num, 1 do
		table.insert(self.elements[name].elements, name.."Button"..j)
	end
end