local addonName = "Yata"

cyCircled_Yata = cyCircled:NewModule(addonName)

function cyCircled_Yata:AddonLoaded(addon)
	self.db = cyCircled:AcquireDBNamespace(addonName);
	cyCircled:RegisterDefaults(addonName, "profile", {
		["Main"] = true,
		["Popup"] = true,
	})
	self:SetupElements();
end

function cyCircled_Yata:GetElements()
	return {
		["Main"] = true,
		["Popup"] = true,
	}
end

function cyCircled_Yata:SetupElements()
	self.elements = {
		["Main"] =  {
			args = {
				ct = false,
			},
			elements = {},
		},
		["Popup"] = { 
			args = {
				ct = false,
			},
			elements = {},
		},
	}
	if(self.db) then 
		local elements = {"Earth","Fire","Water","Air"};
		for i=1,4 do
			local count = Yata:ReturnCountByElement(elements[i]);
			local order = Yata:ReturnOrderByElement(elements[i]);
			if(count > 0) then
				table.insert(self.elements["Main"].elements, string.format("YATABUTTON%i",order));
				for j=1, count-1 do
					table.insert(self.elements["Popup"].elements, string.format("YATABUTTON%i",order*10+j));
				end
			end
		end
	end
end
