local addonName = "TrapBar"

cyCircled_TrapBar = cyCircled:NewModule(addonName)

function cyCircled_TrapBar:AddonLoaded()
	self.db = cyCircled:AcquireDBNamespace(addonName)
	cyCircled:RegisterDefaults(addonName, "profile", {
		["Traps"] = true,
	})
	
	self:SetupElements()
	self:OnEnable()
end

function cyCircled_TrapBar:GetElements()
	return {
		["Traps"] = GetLocale() == "koKR" and "추적 버튼" or true,
	}
end

function cyCircled_TrapBar:SetupElements()
	self.elements = {
		["Traps"] = { 
			args = {
				button = { width = 35, height = 35, },
				ft = false,
				count = false,
				eborder = false,
				hotkey = false,
--				cooldown = false,
				autocast = false,
				nt = false,
				ht = false,
				pt = false,
				ct = false,
			},
			elements = {}, 
		},
	}
	
	for i=1, 6, 1 do
		table.insert(self.elements["Traps"].elements, format("TrapBarButton%d", i))
	end
end