local addonName = "TrackingBar"

cyCircled_TrackingBar = cyCircled:NewModule(addonName)

function cyCircled_TrackingBar:AddonLoaded()
	self.db = cyCircled:AcquireDBNamespace(addonName)
	cyCircled:RegisterDefaults(addonName, "profile", {
		["Tracking"] = true,
	})
	
	self:SetupElements()
	self:OnEnable()
end

function cyCircled_TrackingBar:GetElements()
	return {
		["Tracking"] = GetLocale() == "koKR" and "추적 버튼" or true,
	}
end

function cyCircled_TrackingBar:SetupElements()
	self.elements = {
		["Tracking"] = { 
			args = {
				button = { width = 35, height = 35, },
				ft = false,
				count = false,
				eborder = false,
				hotkey = false,
--				cooldown = false,
				autocast = false,
				nt = false,
				ht = false,
				pt = false,
				ct = false,
			},
			elements = {}, 
		},
	}
	
	for i=1, 13, 1 do
		table.insert(self.elements["Tracking"].elements, format("TrackingBarButton%d", i))
	end
end