local addonName = "TrackBar"

cyCircled_TrackBar = cyCircled:NewModule(addonName)

function cyCircled_TrackBar:AddonLoaded()
	self.db = cyCircled:AcquireDBNamespace(addonName)
	cyCircled:RegisterDefaults(addonName, "profile", {
		["Tracking"] = true,
	})
	
	self:SetupElements()
end

function cyCircled_TrackBar:GetElements()
	return {
		["Tracking"] = true,
	}
end

function cyCircled_TrackBar:SetupElements()
	self.elements = {
		["Tracking"] = { 
			args = {
				button = { width = 28, height = 28, },
				hotkey = false,
				count = false,
				eborder = false,
				nt = false,
				ht = false,
				pt = false,
				ct = false,
	  	                icon = false,
			},
			elements = {
				"TrackBar",
			}, 
		},
	}
	
	for i=1, 13, 1 do
		table.insert(self.elements["Tracking"].elements, format("TrackBarButton%d", i))
	end
end