local addonName = "ShamanBuffBars"

cyCircled_ShamanBuffBars = cyCircled:NewModule(addonName)

function cyCircled_ShamanBuffBars:AddonLoaded()
	self.db = cyCircled:AcquireDBNamespace(addonName)
	cyCircled:RegisterDefaults(addonName, "profile", {
		["Weapon Bar"] = true,
		["Shield Bar"] = true,
	})
	
	self:SetupElements()
	self:OnEnable()
end

function cyCircled_ShamanBuffBars:GetElements()
	return {
		["Weapon Bar"] = true,
		["Shield Bar"] = true,
	}
end

function cyCircled_ShamanBuffBars:SetupElements()
	self.elements = {
		["Weapon Bar"] = { 
			args = {
				button = { width = 35, height = 35, },
				ft = false,
				count = false,
				eborder = false,
				hotkey = false,
--				cooldown = false,
				autocast = false,
				nt = false,
				ht = false,
				pt = false,
				ct = false,
			},
			elements = {
				"WeaponButton1",
				"WeaponButton2",
				"WeaponButton3",
				"WeaponButton4",
			}, 
		},
		["Shield Bar"] = { 
			args = {
				button = { width = 35, height = 35, },
				ft = false,
				count = false,
				eborder = false,
				hotkey = false,
--				cooldown = false,
				autocast = false,
				nt = false,
				ht = false,
				pt = false,
				ct = false,
			},
			elements = {
				"ShieldButton1",
				"ShieldButton2",
				"ShieldButton3",
			}, 
		},
	}
	
	for i=1, 4, 1 do
		table.insert(self.elements["Weapon Bar"].elements, format("WeaponButton%d", i))
	end
	for i=1, 3, 1 do
		table.insert(self.elements["Shield Bar"].elements, format("ShieldButton%d", i))
	end
end