local addonName = "PetBar"

cyCircled_PetBar = cyCircled:NewModule(addonName)

function cyCircled_PetBar:AddonLoaded()
	self.db = cyCircled:AcquireDBNamespace(addonName)
	cyCircled:RegisterDefaults(addonName, "profile", {
		["PetB"] = true,
	})
	
	self:SetupElements()
	self:OnEnable()
end

function cyCircled_PetBar:GetElements()
	return {
		["PetB"] = GetLocale() == "koKR" and "추적 버튼" or true,
	}
end

function cyCircled_PetBar:SetupElements()
	self.elements = {
		["PetB"] = { 
			args = {
				button = { width = 35, height = 35, },
				ft = false,
				count = false,
				eborder = false,
				hotkey = false,
--				cooldown = false,
				autocast = false,
				nt = false,
				ht = false,
				pt = false,
				ct = false,
			},
			elements = {}, 
		},
	}
	
	for i=1, 9, 1 do
		table.insert(self.elements["PetB"].elements, format("PetBarButton%d", i))
	end
end