﻿local addonName = "PT3Bar"

cyCircled_PT3Bar = cyCircled:NewModule(addonName)

function cyCircled_PT3Bar:AddonLoaded()
	self.db = cyCircled:AcquireDBNamespace(addonName)
	cyCircled:RegisterDefaults(addonName, "profile", {
		["Main"] = true,
		["Popup"] = true,
	})
	self:SetupElements()
end

function cyCircled_PT3Bar:GetElements()
	return {
		["Main"] = true,
		["Popup"] = true,
	}
end

function cyCircled_PT3Bar:SetupElements()
	local size = PT3Bar1:GetWidth()
	self.elements = {
		["Main"] = {
			args = {
				button = { width = size, height = size, },
				hotkey = false,
			},
			elements = {},
		},
		["Popup"] = {
			args = {
				button = { width = size, height = size, },
				hotkey = false,
			},
			elements = {},
		},
	}

	for i = 1,20 do
		table.insert(self.elements["Main"].elements, "PT3Bar"..i)
		for k = 1, 20 do
			table.insert(self.elements["Popup"].elements, "PT3Bar"..i.."Popup"..k)
		end
	end
end
