local addonName = "Nurfed"
	
	cyCircled_Nurfed = cyCircled:NewModule(addonName)
	
	function cyCircled_Nurfed:AddonLoaded()
		self.db = cyCircled:AcquireDBNamespace(addonName)
		cyCircled:RegisterDefaults(addonName, "profile", {
			["Nurfed"] = true,
			["Nurfed_Shapeshift"] = true,
			["Nurfed_Pet"] = true,
		})
		
		self:SetupElements()
		self:OnEnable()
	end
	
	function cyCircled_Nurfed:GetElements()
		return {
			["Nurfed"] = true,
			["Nurfed_Shapeshift"] = true,
			["Nurfed_Pet"] = true,
		}
	end
	
	function cyCircled_Nurfed:SetupElements()
		self.elements = {
			["Nurfed"] = { 
				args = {
					button = { width = 36, height = 36, },
				},
				elements = {}, 
			},
			["Nurfed_Shapeshift"] = { 
				args = {
					button = { width = 36, height = 36, },
					eborder = false,
				},
				elements = {}, 
			},
			["Nurfed_Pet"] = { 
				args = {
					button = { width = 36, height = 36, },
					eborder = false,
				},
				elements = {}, 
			},
		}	
		for i=1, 120, 1 do
			table.insert(self.elements["Nurfed"].elements, format("Nurfed_Button%d", i))
		end
		
		for i=1, 10 do
			table.insert(self.elements["Nurfed_Shapeshift"].elements, format("ShapeshiftButton%d", i))
			table.insert(self.elements["Nurfed_Pet"].elements, format("PetActionButton%d", i))
		end
	end