local addonName = "Numen"

cyCircled_Numen = cyCircled:NewModule(addonName)

function cyCircled_Numen:AddonLoaded(addon)
	self.db = cyCircled:AcquireDBNamespace(addonName);
	cyCircled:RegisterDefaults(addonName, "profile", {
		["Main"] = true,
		["Popup"] = true,
	})
	self:SetupElements();
end

function cyCircled_Numen:GetElements()
	return {
		["Main"] = true,
		["Popup"] = true,
	}
end

function cyCircled_Numen:SetupElements()
	self.elements = {
		["Main"] =  {
			args = {
				button = {
					width = 32,
					height = 32,
				},
			},
			elements = {},
		},
		["Popup"] = {
			args = {
				button = {
					width = 32,
					height = 32,
				},
			},
			elements = {},
		},
	}
	if(self.db) then
		table.insert(self.elements["Main"].elements, "NumenButtonCall");
		table.insert(self.elements["Main"].elements, "NumenButtonEarth");
		table.insert(self.elements["Main"].elements, "NumenButtonFire");
		table.insert(self.elements["Main"].elements, "NumenButtonWater");
		table.insert(self.elements["Main"].elements, "NumenButtonAir");
		table.insert(self.elements["Main"].elements, "NumenButtonWeapon");
		table.insert(self.elements["Main"].elements, "NumenButtonShield");

		table.insert(self.elements["Popup"].elements, "NumenPopButtonTotemicCall");

		table.insert(self.elements["Popup"].elements, "NumenPopButtonTremorTotem");
		table.insert(self.elements["Popup"].elements, "NumenPopButtonStoneclawTotem");
		table.insert(self.elements["Popup"].elements, "NumenPopButtonStrengthofEarthTotem");
		table.insert(self.elements["Popup"].elements, "NumenPopButtonStoneskinTotem");
		table.insert(self.elements["Popup"].elements, "NumenPopButtonEarthElementalTotem");
		table.insert(self.elements["Popup"].elements, "NumenPopButtonEarthbindTotem");

		table.insert(self.elements["Popup"].elements, "NumenPopButtonFireNovaTotem");
		table.insert(self.elements["Popup"].elements, "NumenPopButtonTotemofWrath");
		table.insert(self.elements["Popup"].elements, "NumenPopButtonSearingTotem");
		table.insert(self.elements["Popup"].elements, "NumenPopButtonMagmaTotem");
		table.insert(self.elements["Popup"].elements, "NumenPopButtonFlametongueTotem");
		table.insert(self.elements["Popup"].elements, "NumenPopButtonFrostResistanceTotem");
		table.insert(self.elements["Popup"].elements, "NumenPopButtonFireElementalTotem");

		table.insert(self.elements["Popup"].elements, "NumenPopButtonManaSpringTotem");
		table.insert(self.elements["Popup"].elements, "NumenPopButtonHealingStreamTotem");
		table.insert(self.elements["Popup"].elements, "NumenPopButtonPoisonCleansingTotem");
		table.insert(self.elements["Popup"].elements, "NumenPopButtonDiseaseCleansingTotem");
		table.insert(self.elements["Popup"].elements, "NumenPopButtonManaTideTotem");
		table.insert(self.elements["Popup"].elements, "NumenPopButtonFireResistanceTotem");

		table.insert(self.elements["Popup"].elements, "NumenPopButtonWrathofAirTotem");
		table.insert(self.elements["Popup"].elements, "NumenPopButtonGroundingTotem");
		table.insert(self.elements["Popup"].elements, "NumenPopButtonGraceofAirTotem");
		table.insert(self.elements["Popup"].elements, "NumenPopButtonWindfuryTotem");
		table.insert(self.elements["Popup"].elements, "NumenPopButtonWindwallTotem");
		table.insert(self.elements["Popup"].elements, "NumenPopButtonNatureResistanceTotem");
		table.insert(self.elements["Popup"].elements, "NumenPopButtonTranquilAirTotem");
		table.insert(self.elements["Popup"].elements, "NumenPopButtonSentryTotem");

		table.insert(self.elements["Popup"].elements, "NumenPopButtonRockbiterWeapon");
		table.insert(self.elements["Popup"].elements, "NumenPopButtonFlametongueWeapon");
		table.insert(self.elements["Popup"].elements, "NumenPopButtonFrostbrandWeapon");
		table.insert(self.elements["Popup"].elements, "NumenPopButtonWindfuryWeapon");

		table.insert(self.elements["Popup"].elements, "NumenPopButtonWaterShield");
		table.insert(self.elements["Popup"].elements, "NumenPopButtonLightningShield");
		table.insert(self.elements["Popup"].elements, "NumenPopButtonEarthShield");

	end
end
