local addonName = "InfiniBar-2.0"

cyCircled_InfiniBar2 = cyCircled:NewModule(addonName)

function cyCircled_InfiniBar2:AddonLoaded(addon)
	self.db = cyCircled:AcquireDBNamespace(addonName)
	cyCircled:RegisterDefaults(addonName, "profile", {})
	
	self:SetupElements()

	InfiniBar2.UpdateCyCircled = function(self)
		cyCircled_InfiniBar2:SetupElements()
		cyCircled_InfiniBar2:ApplySkin()
		cyCircled_InfiniBar2:ApplyColors()
	end
end

local groupList = {}

local function IB2_UpdateGroupList()
	for k in pairs(groupList) do groupList[k] = nil end
	local barList = InfiniBar2.barList
	for i = 1, #barList do local bar = barList[i]
		groupList[bar.bardata.name] = true
	end
end

function cyCircled_InfiniBar2:GetElements()
	IB2_UpdateGroupList()
	return groupList
end

function cyCircled_InfiniBar2:SetupElements()
	self.elements = {}
	local barList = InfiniBar2.barList
	for i = 1, #barList do local bar = barList[i]
		local group = {
			args = {
				button = { width = 36, height = 36, },
				eborder = false,
			},
			elements = {},
		}
		local btnList = bar.btnList
		for j = 1, #btnList do local btn = btnList[j]
			group.elements[#group.elements + 1] = btn.btnname
		end
		self.elements[bar.bardata.name] = group
	end
end
