--[[
	Geist Plugin, by Xerophyte. Gratuitous edit of Steve's FlexBar plugin.
]]

local addonName = "Geist"

cyCircled_Geist = cyCircled:NewModule(addonName)

function cyCircled_Geist:AddonLoaded()
	self.db = cyCircled:AcquireDBNamespace(addonName)
	cyCircled:RegisterDefaults(addonName, "profile", {
		["Main"] = true,
	})
	
	self:SetupElements()
end

function cyCircled_Geist:GetElements()
	return {
		["Main"] = true,
	}
end

function cyCircled_Geist:SetupElements()
	self.elements = {
		["Main"] = { 
			args = {
				button = { width = 35, height = 35, },
				hotkey = false,
			},
			elements = {}, 
		},
	}
	
	for i=1, 25, 1 do
		table.insert(self.elements["Main"].elements, format("GeistButton%d", i))
	end
end
