local AddonName = "FlexBar2";

cyCircled_FlexBar2 = cyCircled:NewModule(AddonName)

function cyCircled_FlexBar2:AddonLoaded(addon)
	self.db = cyCircled:AcquireDBNamespace(AddonName)
	local GroupList = self:GetElements();
	cyCircled:RegisterDefaults(AddonName, "profile", GroupList)
	self:SetupElements(GroupList)
end

function cyCircled_FlexBar2:GetElements()
	local GroupList = {Ungrouped = "Ungrouped buttons", ["third party"] = "Third party buttons"};
	for GroupName in pairs(FlexBar2.Groups) do
		GroupList[GroupName] = GroupName;
	end
	return GroupList;
end

function cyCircled_FlexBar2:SetupElements(GroupList)
	self.elements = {}
	for GroupName in pairs(GroupList) do
		self.elements[GroupName] =
		{
			args = 
			{
				button = 
				{ 
					width = 40,
					height = 40, 
				},
				eborder = false,
			},
			elements = {},
		}
	end
	self.elements["third party"] =
		{
			args = 
			{
				button = 
				{ 
					width = 40,
					height = 40, 
				},
				eborder = false,
			},
			elements = {},
		}

	for ButtonName, ButtonObject in pairs(FlexBar2.Buttons) do
		local GroupName = "Ungrouped";
		if(ButtonObject.Group and ButtonObject.Group.Name) then
			GroupName = ButtonObject.Group.Name;
		end
		table.insert(self.elements[GroupName].elements, "FB2_BTN_" .. (ButtonObject.uid or ButtonObject.Name));
	end
	for ButtonName, ButtonObject in pairs(FlexBar2.UnnamedButtons) do
		table.insert(self.elements["third party"].elements, "FB2_BTN_" .. (ButtonObject.uid or ButtonObject.Name));
	end

end

-- Create a mini flexbar2 module to skin buttons when they're activated
function cyCircled_FlexBar2:OnInitialize()
	if(IsAddOnLoaded("FlexBar2")) then
		local Module = FlexBar2:NewModule("cyCircled");
		Module.ButtonMixin = {};
		function Module.ButtonMixin:Activate()
			if(Rock("LibRockEvent-1.0"):IsFullyInitialized()) then
				-- Regenerate button list
				cyCircled_FlexBar2:SetupElements(cyCircled_FlexBar2:GetElements());
				-- Reapply skins
				cyCircled_FlexBar2:ApplySkin();
				cyCircled_FlexBar2:ApplyColors();
			end
		end
	end
end
