local addonName = "Buffalo"

cyCircled_Buffalo = cyCircled:NewModule(addonName)

function cyCircled_Buffalo:AddonLoaded(addon)
	self.db = cyCircled:AcquireDBNamespace(addonName)
	cyCircled:RegisterDefaults(addonName, "profile", {
		["Buffs"] = true,
		["Debuffs"] = true,
		["WepBuffs"] = true,
	})
	
	self:SetupElements()
end

function cyCircled_Buffalo:ApplyCustom()
	
end

function cyCircled_Buffalo:GetElements()
	return {
		["Buffs"] = true,
		["Debuffs"] = true,
		["WepBuffs"] = true,
	}
end

function cyCircled_Buffalo:SetupElements()
	self.elements = {
		["Buffs"] = { 
			args = {
				button = { width = 34, height = 34, },
				ht = false,
				pt = false,
				ct = false,
				eborder = false,
			},
			elements = {},
		},
		["Debuffs"] = {
			args = {
				button = { width = 34, height = 34, },
				ht = false,
				pt = false,
				ct = false,
				eborder = false,
			},
			elements = {},
		},
		["WepBuffs"] = {
			args = {
				button = { width = 34, height = 34, },
				ht = false,
				pt = false,
				ct = false,
				eborder = false,
			},
			elements = {},
		},
	}
	
	for i=0, 31, 1 do
		table.insert(self.elements["Buffs"].elements, format("BuffaloButton%d", i))
	end
	
	for i=0, 15, 1 do
		table.insert(self.elements["Debuffs"].elements, format("DebuffaloButton%d", i))
	end
	
	for i=0, 1, 1 do
		table.insert(self.elements["WepBuffs"].elements, format("WeaponBuffaloButton%d", i))
	end
end
