local addonName = "Bartender3"

cyCircled_Bartender3 = cyCircled:NewModule(addonName)

local _G = getfenv(0)

function cyCircled_Bartender3:AddonLoaded(addon)
	self.db = cyCircled:AcquireDBNamespace(addonName)
	
	-- setup default config and element table (10 bars)
	local bid, bname = 0, ""
	self.defaultCfg = {}
	self.elements = {}
	for i=1, 10 do
		self.defaultCfg["Bar"..i] = true
		
		-- bars
		self.elements["Bar"..i] = { 
			elements = {},
			args = {
				button = { width = 35, height = 35, },
				parentname = false,
			},
		}
		
		-- buttons (12 buttons per bar)
		bid = (i-1)*12
		for j=(bid+1), (bid+12) do
			bname = format("BT3Button%d", j)
			if _G[bname] then bname = _G[bname]:GetName() end
			table.insert(self.elements["Bar"..i].elements, bname)
		end
	end
	self.defaultCfg["BarSTANCE"] = true
	self.elements["BarSTANCE"] = { 
			elements = {},
			args = {
				button = { width = 35, height = 35, },
				parentname = false,
			},
		}
	for i=1, 10 do
		table.insert(self.elements["BarSTANCE"].elements, format("ShapeshiftButton%d", i))
	end
	self.defaultCfg["BarPET"] = true
	self.elements["BarPET"] = { 
			elements = {},
			args = {
				button = { width = 35, height = 35, },
				parentname = false,
			},
		}
	for i=1, 10 do
		table.insert(self.elements["BarPET"].elements, format("PetActionButton%d", i))
	end
	-- bags
	self.defaultCfg["BarBAGS"] = true
	self.elements["BarBAGS"] = { 
			elements = {},
			alias = { icon = "IconTexture" },
			args = {
				button = { width = 35, height = 35 },
				hotkey = false,
				count = false,
				eborder = false,
				ft = false,
				cooldown = false,
				parentname = false,
			},
		}
	table.insert(self.elements["BarBAGS"].elements, "CharacterBag3Slot")
	table.insert(self.elements["BarBAGS"].elements, "CharacterBag2Slot")
	table.insert(self.elements["BarBAGS"].elements, "CharacterBag1Slot")
	table.insert(self.elements["BarBAGS"].elements, "CharacterBag0Slot")
	table.insert(self.elements["BarBAGS"].elements, "MainMenuBarBackpackButton")
	
	cyCircled:RegisterDefaults(addonName, "profile", self.defaultCfg)
	
	-- equipped item hack
	self:SecureHook(Bartender3.Class.Button.prototype, "UpdateButton", "UpdateEquip")
end

function cyCircled_Bartender3:UpdateEquip(button, ...)
	cyCircled:UpdateEquipState(button:PagedID(), "BT3Button"..button.id)
end

function cyCircled_Bartender3:GetElements()
	return {
		["Bar1"] = true,
		["Bar2"] = true,
		["Bar3"] = true,
		["Bar4"] = true,
		["Bar5"] = true,
		["Bar6"] = true,
		["Bar7"] = true,
		["Bar8"] = true,
		["Bar9"] = true,
		["Bar10"] = true,
		["BarSTANCE"] = "Stance Bar",
		["BarPET"] = "Pet Bar",
		["BarBAGS"] = "Bag Bar",
	}
end
