﻿local addonName = "AutoBar"

cyCircled_AutoBar = cyCircled:NewModule(addonName)

function cyCircled_AutoBar:AddonLoaded()
	self.elements = {
		["Main"] = {
			args = {
				button = { width = 35, height = 35, },
				hotkey = false,
				ct = false,
			},
			elements = {},
		},
	}
	self.db = cyCircled:AcquireDBNamespace(addonName)
	if (not AutoBar.styles) then
		return
	end
	local cyCircledStyle = "cyCircled"	-- AutoBar's Style Index for cyCircled

	if (not AutoBar.Class) then
		cyCircledStyle = 4				-- Old Style Index
	end

	cyCircled:RegisterDefaults(addonName, "profile", {
		["Main"] = true,
	})

	AutoBar.styles[cyCircledStyle].callbackSelf = self
	AutoBar.styles[cyCircledStyle].callbackFunc = cyCircled_AutoBar.RefreshStyle
	AutoBar:SetStyle(cyCircledStyle)
end

-- RefreshStyle is called back via the callbackFunc hook set above for AutoBar
-- It is only called for displayed buttons when necessary
-- This avoids the needless skinning of all 288 buttons everytime something changes
function cyCircled_AutoBar:RefreshStyle(button)
	if not button then return end

	local id = button:GetName()
	self.elements.Main.elements[1] = id
	cyCircled:ApplySkin(self.elements.Main)
	cyCircled:ApplyColors(self.elements.Main)
end

function cyCircled_AutoBar:ApplySkin()
	if (AutoBar) then
		if (not AutoBar.styles) then
			return
		elseif (AutoBar.Class) then
			if (AutoBar.delay["UpdateStyles"]) then
				AutoBar.delay["UpdateStyles"]:Start()
			end
		else
			AutoBar.delayLayoutUpdate:Start()
		end
	end
end


function cyCircled_AutoBar:GetElements()
   return {
      ["Main"] = true,
   }
end


