local L = AceLibrary("AceLocale-2.2"):new("cyCircled")

cyCircled.options = {
	type = "group",
	args = {
		headerelements = {
			type = "header", name = "|cFF77BBFF"..L["Elements"].."|r", desc = L["elementsDesc"], order = 1
		},
		space1 = { type = "header", order = 999 },
		headerconfig = { type = "header", name = "|cFF77BBFF"..L["Config"].."|r", order = 1000 },
		skin = {
			name = L["Skin"], desc = L["skinDesc"], type = "text", order = 1001,
			get = function() return cyCircled.db.profile.skin end,
			set = function(v)
				cyCircled.db.profile.skin = v
				cyCircled:ChangeSkin()
			end,
			validate = {},
		},
		colors = {
			name = L["Colors"], desc = L["ringcolorDesc"], type = "group", order = 1002,
			args = {
				normal = {
					name = L["Normal"], desc = L["normalcolorDesc"], type = "color", order = 1,
					get = function()
						return cyCircled.db.profile.colors.normal.r, cyCircled.db.profile.colors.normal.g, cyCircled.db.profile.colors.normal.b
					end,
					set = function(r, g, b)
						cyCircled.db.profile.colors.normal.r, cyCircled.db.profile.colors.normal.g, cyCircled.db.profile.colors.normal.b = r, g, b
						cyCircled:ChangeColors()
					end,
				},
				hover = {
					name = L["Hover"], desc = L["hovercolorDesc"], type = "color", order = 2,
					get = function()
						return cyCircled.db.profile.colors.hover.r, cyCircled.db.profile.colors.hover.g, cyCircled.db.profile.colors.hover.b
					end,
					set = function(r, g, b)
						cyCircled.db.profile.colors.hover.r, cyCircled.db.profile.colors.hover.g, cyCircled.db.profile.colors.hover.b = r, g, b
						cyCircled:ChangeColors()
					end,
				},
				equipped = {
					name = L["Equipped"], desc = L["equipcolorDesc"], type = "color", order = 3,
					get = function()
						return cyCircled.db.profile.colors.equipped.r, cyCircled.db.profile.colors.equipped.g, cyCircled.db.profile.colors.equipped.b
					end,
					set = function(r, g, b)
						cyCircled.db.profile.colors.equipped.r, cyCircled.db.profile.colors.equipped.g, cyCircled.db.profile.colors.equipped.b = r, g, b
						cyCircled:ChangeColors()
					end,
				},
			},
		},
	},
}

--[[ See new functions in core.lua under the "Skin Packs" header. - Storm -

for k,v in pairs(cyCircled.skins) do
	table.insert(cyCircled.options.args.skin.validate, k)
	table.sort(cyCircled.options.args.skin.validate)
end

--]]

cyCircled:RegisterChatCommand({"/cycircled"}, cyCircled.options, "CYCIRCLED")
cyCircled.OnMenuRequest = cyCircled.options
