

--[=[
 TradeSkill Functions

    CloseTradeSkill()   - Closes an open trade skill window.
    CollapseTradeSkillSubClass(index)   - Collapses the specified subclass header row.
    DoTradeSkill(index[, repeatTimes])   - Performs the tradeskill a specified # of times.
    ExpandTradeSkillSubClass(index)   - Expands the specified subclass header row.
    GetFirstTradeSkill()   - Returns the index of the first non-header trade skill entry.
    GetNumTradeSkills()   - Get the number of trade skill entries (including headers).
    GetTradeSkillCooldown(index)   - Returns the number of seconds left for a skill to cooldown.
    GetTradeSkillDescription(index)   - Returns the description text of the indicated trade skill.
    GetTradeSkillIcon(index)   - Returns the texture name of a tradeskill's icon.
    GetTradeSkillInfo(index)   - Retrieves information about a specific trade skill.
    GetTradeSkillInvSlotFilter(slotIndex)   - Returns 1 if items corresponding to slotIndex are currently visible, otherwise nil.
    GetTradeSkillInvSlots()   - Returns a list of the available inventory slot types.
    GetTradeSkillItemLink(index)   - Returns the itemLink for a trade skill item.
    GetTradeSkillItemStats(index)   - Returns information about the item produced.
    GetTradeSkillLine()   - Returns information about the selected skill line.
    GetTradeSkillNumMade(index)   - Gets the number of items made in a single use of a skill.
    GetTradeSkillNumReagents(tradeSkillRecipeId)   - Returns the number of different reagents required.
    GetTradeSkillReagentInfo(tradeSkillRecipeId, reagentId)   - Returns data on the reagent, including a count of the player's inventory.
    GetTradeSkillReagentItemLink(index, reagentId)   - Returns the itemLink for one of the reagents needed to craft the given item
    GetTradeSkillRecipeLink(index)   - Returns the EnchantLink for a trade skill.
    GetTradeSkillSelectionIndex()   - Returns the Id of the currently selected trade skill, 0 if none selected.
    GetTradeSkillSubClassFilter(filterIndex)   - Returns 1 if items corresponding to filterIndex are currently visible, otherwise nil.
    GetTradeSkillSubClasses()   - Returns a list of the valid subclasses.
    GetTradeSkillTools(index)   - Returns information about the tools needed for a tradeskill.
    GetTradeskillRepeatCount()   - Returns the number of times the current item is being crafted.
    IsTradeskillTrainer()   - Returns 1 if trainer is for a tradeskill.
    IsTrainerServiceTradeSkill()   - ?.
    SelectTradeSkill(index)   - Select a specific trade skill in the list.
    SetTradeSkillInvSlotFilter(slotIndex, onOff[, exclusive] )   - Set the inventory slot type filter.
    SetTradeSkillSubClassFilter(slotIndex, onOff[,exclusive] ) &nbsp; - Set the subclass filter.
    ]=]
    
    
APVERSION = "1.2"
--APdebug = true



function APinitialize()

   APprint("|c00aaffffvariables loaded.  Initializing.")
   APprint("|c00aaffffvariables loaded.  Initializing.")

   local playerName = UnitName("player");
   local serverName = GetCVar("realmName");
   if (playerName == nil or playerName == UNKNOWNOBJECT or playerName == UNKNOWNBEING) then
      return;
   end
   
   
   
   if (APsavedtable) then              
       if(APsavedtable[serverName]) then
            
          AP_tcopy(APpoisonswanted,APsavedtable[serverName])
          APflashwanted = APsavedtable[serverName].APflashwanted
          
       end
   end
   
   -- restore positioning data
   if not (APfirsttime) then
      APfirsttime = true
      if (APsavedposition) then
        print("loading Positiondata.")
	    print(APsavedposition.point)
	    print(APsavedposition.relativePoint)
	    print(APsavedposition.xOfs)
	    print(APsavedposition.yOfs)
	    


    	 if(APsavedposition.point and APsavedposition.relativePoint and APsavedposition.xOfs and APsavedposition.yOfs) then
    	    APframe:ClearAllPoints()
    	    APframe:SetPoint(APsavedposition.point,UIParent,APsavedposition.relativePoint,APsavedposition.xOfs,APsavedposition.yOfs)
    	 end
      end
   end
  
  
  APcreateinterface()
   
end



-- ONLOAD, duh
function AP_OnLoad()

   -- Register for events
   --  this:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
   this:RegisterEvent("VARIABLES_LOADED")
   this:RegisterEvent("TRADE_SKILL_UPDATE")
   this:RegisterEvent("MERCHANT_SHOW")
   this:RegisterEvent("MERCHANT_CLOSED")
   this:RegisterEvent("TRADE_SKILL_SHOW")

   DEFAULT_CHAT_FRAME:AddMessage("Autopoison Loaded.  /autopoison")

   -- create our APash commands
   SLASH_AP1 = "/AP";
   --SLASH_AP2 = "/ap";
   SLASH_AP2 = "/autopoison";
   SLASH_AP2 = "/AUTOPOISON";

   SlashCmdList["AP"] = APmain;


   
    APpoisons = {}
    APpoisons[1] = "Instant Poison"
    APpoisons[2] = "Deadly Poison"
    APpoisons[3] = "Crippling Poison"
    APpoisons[4] = "Mind-numbing Poison"
    APpoisons[5] = "Wound Poison"
    APpoisons[6] = "Anesthetic Poison"


    APpoisonswanted = {}
    APpoisonswanted[1] = 20
    APpoisonswanted[2] = 20
    APpoisonswanted[3] = 20
    APpoisonswanted[4] = 20
    APpoisonswanted[5] = 20
    APpoisonswanted[6] = 0

    APflashwanted = 60

    --find highest rank
    APranks = {}
    APranks[1] = ""
    APranks[2] = " II"
    APranks[3] = " III"
    APranks[4] = " IV"
    APranks[5] = " V"
    APranks[6] = " VI"
    APranks[7] = " VII"
    APranks[8] = " VIII"
    APranks[9] = " IX"
    APranks[10] = " X"

    APbestpoisons = {}       --number indexed
    APbestpoisonsindex = {}  --string indexed
    APpoisonsowned = {}      --number
    APpoisonstomake = {}      --number
    APreagentswanted={}      --string
    APreagentsowned={}       --string
    APreagentstobuy={}       --string

    tinsert(UISpecialFrames,APframe:GetName());
   

    APupdate()
   
    APprint("|c00449955 end onload ")
    APframe:Hide()
end 
---------------------------------------------------------------------------




function APmain(input)

   APprint("someone did a /AP")

   --try to open the poisons frame
   APopenpoisonwindow()

   APgettables()  --update it all
   
   
   APprint("si Merchant open?  "..GetMerchantNumItems())
    --autopoison

    --steps required



    --get level?.  Easy.

    --Get poisons available at this level/trained.
    --start with a preset list of the 7 poisons.
    --go through the tradeskill list to find the highest rank.

    --determine reagents needed for each poison

    --when they open a vendor
    --determine if the vendor sells the items
    --total up the price of 1 poison

    --look up the presets of how many we want to buy
    --count each poison we already have
    --subtract that to get what we need

    --count each reagent we already have
    --subtract that from the reagents needed
    --buy the items needed.  Always start with vials.

    --show the 'make poison' interface

    --when they click each button, the poison is made

    APframe:Show()

    
    
    APupdate()
end


------------>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
----------<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
function AP_OnEvent(event)

   --local timestaAP, event, srcGUID, srcName, srcFlags, dstGUID, dstName, dstFlags = CombatLogGetCurrentEntry()  --for documentation purposes
   if (event == "VARIABLES_LOADED") then
     
      APinitialize()

   elseif (event == "TRADE_SKILL_UPDATE") then
      if(APispoisonwindowopen()) then
        APprint("Update called from |c0000ff44 ONevent TRADE_SKILL_UPDATE.")
        APupdate()
      end
   elseif (event == "TRADE_SKILL_SHOW") then

      APprint("SHOW called from |c0000ff44 ONevent TRADE_SKILL_SHOW  calling /apmain.  ")
      
      --make sure it was actually the poison window 
      if(APispoisonwindowopen()) then
        APmain()
      end
   elseif (event == "MERCHANT_SHOW") then
    APprint("SHOW called from |c0000ff44 ONevent MERCHANT_SHOW.  ")   
      --sells flash powder?
      
       if(APsellsflashpowder()) then
         APbuybutton:Enable()
         APgetreagentsinfo()
         APframe:Show()
         APupdate()
      else
         APbuybutton:Disable()
      end
   elseif (event == "MERCHANT_CLOSED") then
       APprint("UPDATE CALLED FROM Merchant Closed?")
         --buy button
       APbuybutton:Disable()
       APupdate()
   elseif (event == "BAG_UPDATE") then
      this:UnregisterEvent("BAG_UPDATE")

        APprint("|c00eeff44Bag UPDATE event.")
        --we bought a bunch of poisons
        APgetreagentstobuy()  --update
        APprint("|c00eeff44Enabling buy button.")
        APbuybutton:Enable()
        if(AP_tcount(APreagentstobuy) > 0) then
           --if theres still reagents to buy, that means the original buy failed.
           DEFAULT_CHAT_FRAME:AddMessage("AutoPoison:  Not all reagents were bought.  Check your money or your bag space.")
        end
     
   end
end


--***********************************************************************************************************************
function APupdate()
  --this is where we adjust anything that would change during execution
  
   APprint("|c0000eeeeUpdate called")



   --if our scanning succeeded (needs a hardware event)

   if (table.maxn(APbestpoisons) < 1) then
      APprint("Bestpoisons not found.  Returning false from update.")
      return false
    else
       -- APprint("Bestpoisons found!  Checking all tables")
   end

   --this is for when they click make poisons, we change the numbers on the button for them
   APgetpoisonsowned()  --recheck numbers
   APgetpoisonstomake()
  
   -- enable each make button
   for poison = 1,table.maxn(APpoisons) do
       local button,APreagenttable,maxmakeable,makeable
       maxmakeable = APpoisonstomake[poison]
       --APprint("Maxmakeable for poison  "..poison.. " = "..maxmakeable)
       button = getglobal("APpoisonbutton"..poison)
       button:Disable()
        --if we have the reagents
        APreagenttable = APgetreagents(poison)
        if(APreagenttable) then
            for key,value in pairs(APreagenttable) do
                makeable = (APreagentsowned[key] / APreagenttable[key])
                --if what we can make is less than what we want, adjust the text accordingly
                maxmakeable=math.min(makeable,maxmakeable)
                --APprint("makeable for poison  "..poison.. " = "..makeable)
            end
        
            --if we need this poison
           if(maxmakeable > 0) then
                button:Enable()
           end
           button:SetText("|c00ffffff"..APbestpoisons[poison].." x "..maxmakeable)
        else
          APprint("No reagents found in update for poison "..APpoisons[poison])
          APprint("tradeskill window probalby wasnt open")
          if(APdebug) then
            return false
          end
       end    
       
   end
   
end
--*********************************************************************************************************************


function APgettables()

--this is like my force update everything function
  APgetbestpoisons()  --this will not be possible till after a hardware event
  if(table.maxn(APbestpoisons) > 0) then
      APgetpoisonsowned()
      APgetpoisonstomake()
      APgetreagentstobuy()
  end    
end



function AP_OnUpdate(elapsed)
--this is the blizzard update, called every millisecond
 
end


function APgetbestpoisons()
    APprint("|c0000eeeeget best poisons called")
    
    if(APispoisonwindowopen()) then
        APbestpoisons = {}
        APbestpoisonsindex = {}
        APprint("num skills="..GetNumTradeSkills())
        local rank, poison
        for poison=1,table.maxn(APpoisons) do
                rank = 1
                while (APfindrank(poison,rank)) do
                   rank=rank+1
                end
        end
    
        APprint("Best poisons # "..table.maxn(APbestpoisons))
    else    
        APprint("Best poisons Called with no trade open?!:")
    end
end


function APfindrank(poison, rank)
    local skillName, skillType, numAvailable, isExpanded,index

    for index=1,GetNumTradeSkills() do
        skillName, skillType, numAvailable, isExpanded = GetTradeSkillInfo(index)
        --APprint("name="..skillName.."  type="..skillType.."  num="..numAvailable)
        local tomatch = APpoisons[poison]..APranks[rank]
        --APprint("to match="..tomatch.."'  name="..skillName)
        if (skillName == tomatch) then
            --APprint("Match found: ")
           --found poison
           APbestpoisons[poison] = skillName
           APbestpoisonsindex[poison] = index
           return true
        end
    end

    --APprint("NO Match found: ")
    return false
end



function APgetpoisonsowned()
  --APprint("|cc00ff00fCalling get posons owned")
  local index

  APpoisonsowned = {}
  for index = 1, table.maxn(APpoisons)  do
      APpoisonsowned[index] = APgetitemcount(APbestpoisons[index])
  end
      
 
end

function APgetpoisonstomake()
 -- APprint("|c0000eeee get poisons to make called")

  APpoisonstomake = {}
  for index = 1, table.maxn(APpoisons)  do
     if (APpoisonsowned[index]) then
       --it is possible to get a +something to make, but not be able to make that poison, so be careful
        APpoisonstomake[index] = APpoisonswanted[index] - APpoisonsowned[index]
        --don't allow negetive numbers
        if(APpoisonstomake[index] < 0) then
           APpoisonstomake[index] = 0
        end
     else
         APprint ("|c00ff0000warning!  nil poisons owned of "..index.."Error in getpoisonstobuy!")
         APpoisonstomake[index] = 0
     end
     --APprint(APpoisons[index].." Wanted="..APpoisonswanted[index].."- owned="..APpoisonsowned[index])
  end
end


function APgetreagentstobuy()
    APprint("|c0000eeee get reagents tobuy called")
    
    if(table.maxn(APbestpoisons) > 0) then
        local amounttobuy
        --reset wanted and tobuy lists
        APreagentswanted = {}
        APreagentstobuy = {}

        --calculate total wanted
        for poison = 1,table.maxn(APpoisons) do

            local APreagenttable = {}
            APreagenttable = APgetreagents(poison)
            if(APreagenttable) then
                APprint("poison # "..poison.."  "..APbestpoisons[poison])
                APaddreagenttowanted(APreagenttable,APpoisonstomake[poison])
            end

         end


        --subtract owned from what we need
        for key,value in pairs(APreagentswanted) do
            amounttobuy = value - APreagentsowned[key]
            if(amounttobuy > 0) then
               APreagentstobuy[key] = amounttobuy
            end
        end

        --add in flash powder
        --inventory flash powder
        APflashtobuy = APflashwanted - APgetitemcount("Flash Powder")

        if(APflashtobuy > 0) then
            APreagentstobuy["Flash Powder"] = APflashtobuy
        end


        APprint("Printing reagents  to buy table")
        APprint(APreagentstobuy)
        APprint("reagentswanted # "..AP_tcount(APreagentswanted))
        APprint("Reagentowned # "..AP_tcount(APreagentsowned))
        APprint("Reagentstobuy # "..AP_tcount(APreagentstobuy))
   else
      APprint("Get ratents to buy failed.  bestpoisons not found!")

   end
end


function APaddreagenttowanted(APreagenttable,multiplier)
    for key,value in pairs(APreagenttable) do
   --if first time seeing this reagent
        if not (APreagentswanted[key]) then
           APreagentswanted[key] = 0
        end
        --add up totals
        --APprint(" Adding "..key.." "..APreagentswanted[key].." + "..multiplier.." * "..value)
        APreagentswanted[key] = APreagentswanted[key] + (value * multiplier)
    end    
end




function APbuyreagents()
    APprint("|c0000eeeebuy "..AP_tcount(APreagentstobuy).." reagents called")
    if(AP_tcount(APreagentstobuy) > 0) then
        --disable button so some moron doesnt spam buy reagents
        APprint("|c000044eebuy disablying buy button....")
        APbuybutton:Disable()

        local buybatch,quantity,index,total
        total = 0
        
        --bug catcher.  why bug here, no idea
        if not (APreagentsinfo) then
           APgetreagentsinfo()
        end
        for name,amounttobuy in pairs(APreagentstobuy) do

           --eliminate this server query.  too slow.  do it earlier and store everything in tables
           --local name, texture, price, quantity, numAvailable, isUsable, extendedCost = GetMerchantItemInfo(index)
           --APprint("index="..index.." name="..name.." price="..price.." quanity="..quantity.." avialbalbe="..numAvailable.." usable="..isUsable)


           if (APreagentsinfo[name]) then
           --merchant doesnt have this reagent
           
               total=total+amounttobuy
      
               quantity = APreagentsinfo[name].quantity
               index = APreagentsinfo[name].index
    
    
                if(quantity == 1) then
                   --get 20 at a time
    
                    for x =1,math.floor(amounttobuy/20) do
                        BuyMerchantItem(index,20)
                        APprint("buying "..name.." x 20 "..x)
                    end
                    --buy th eleftovers (thank you, modulo)
                    buybatch = amounttobuy%20
                    if(buybatch > 0) then
                        BuyMerchantItem(index,buybatch)
                        APprint("buying "..name.." x "..(buybatch))
                    end
                else
                    for x =1,math.ceil(amounttobuy/quantity) do  --somethings can be bought in bulk - some cannot
                        BuyMerchantItem(index)
                        APprint("buying "..name.." x "..x)
                    end
                end
                    APprint("x/20="..(amounttobuy/20).."   amounttobuy%20 = "..(amounttobuy%20).."  reagentstobuy="..APreagentstobuy[name].."/  quantity="..quantity)
            end

        end

        DEFAULT_CHAT_FRAME:AddMessage("AutoPoison:  Buying "..total.." reagents.  Please give it a moment.")
        APframe:RegisterEvent("BAG_UPDATE")  --update after our bags changed
    end
    
end

function APmakepoison(poison)
    APopenpoisonwindow()

    APprint(APpoisons[poison].."  doing index "..APbestpoisonsindex[poison].." "..APpoisonstomake[poison].." times.")
    if(APpoisonstomake[poison] > 0) then
        DoTradeSkill(APbestpoisonsindex[poison],APpoisonstomake[poison])
    end
end


function APgetreagentsinfo()

    APreagentsinfo = {}
    local name, texture, price, quantity, numAvailable, isUsable, extendedCost
    for index = 1,GetMerchantNumItems() do
    
        name, texture, price, quantity, numAvailable, isUsable, extendedCost = GetMerchantItemInfo(index)
       --all we care about is index and quantity 
       APreagentsinfo[name] = {}
       APreagentsinfo[name].quantity = quantity
       APreagentsinfo[name].index = index
       
    end


end


function APsavevariables()
     local serverName = GetCVar("realmName");
     if not (APsavedtable) then
        APsavedtable={}
     end
     if not (APsavedtable[serverName]) then
        APsavedtable[serverName] = {}
     end
     
     AP_tcopy(APsavedtable[serverName],APpoisonswanted)
     APsavedtable[serverName].APflashwanted = APflashwanted
    
     local point, relativeTo, relativePoint, xOfs, yOfs = APframe:GetPoint(1)
     if not (APsavedposition) then
        APsavedposition={}
     end
     APsavedposition.point=point
     APsavedposition.relativePoint=relativePoint
     APsavedposition.xOfs=xOfs
     APsavedposition.yOfs=yOfs


end








function APcreateinterface()


    APBUTTONHEIGHT = 26
    APBUTTONWIDTH = 200

   --mainframe
   --APframe = CreateFrame("frame",nil,UIparent)
   APframe:SetPoint("left",100,0)
   APframe:SetHeight(320)
   APframe:SetWidth(275)
   APframe:Show()
   APframe:SetBackdrop({
				 bgFile = "Interface/Tooltips/UI-Tooltip-Background",
				 edgeFile = "Interface/Tooltips/UI-Tooltip-Border",
				 tile = true, tileSize = 32, edgeSize = 32,
				 insets = { left = 9, right = 9, top = 9, bottom = 9}
			      })
   APframe:SetBackdropColor(0,0,0,2)
   APframe:SetFrameStrata("HIGH")
   APframe:SetMovable(true)
   APframe:EnableMouse(true)
   APframe:SetScript("OnMouseDown",function()
					     APframe:StartMoving()
					  end)
   APframe:SetScript("OnMouseUp",function()
					   APframe:StopMovingOrSizing()
					   APsavevariables()
					end)
   
   --title
   APtitle = CreateFrame("button",nil,APframe)
   APtitle:SetHeight(APBUTTONHEIGHT)
   APtitle:SetWidth(APBUTTONWIDTH)
   APtitle:SetPoint("bottom",APframe,"top")
   APtitle:SetTextFontObject(GameFontNormal)
   APtitle:SetText("AutoPoison " ..APVERSION)

					
	--buy button				
   APbuybutton = CreateFrame("button",nil,APframe,"UIPanelButtonTemplate")
   APbuybutton:SetWidth(APBUTTONWIDTH + 20)
   APbuybutton:SetHeight(APBUTTONHEIGHT + 10)
   APbuybutton:SetPoint("Top",0,-20)
   APbuybutton:SetText("Buy Reagents")
   APbuybutton:SetScript("OnClick",    function()
   
      APprint("|c00ffff33 Buy button pressed.")
      --its not just a simple matter of buying stuff on click
      -- cant figure out what to buy without opening the tradeskill
      -- and tradeskill cant be opened without a keypress (Protected function)
      
      APmain()
      
      APprint("|c0000ff33 buyreagents() called from Buy button pressed.")
	  APbuyreagents()
	  APprint("|c0000ff33 update called from Buy button pressed.")
      APupdate()						 
   end)
   APbuybutton:SetScript("OnEnter",    function()
      local buymessage = "Figure out what poisons you need, figure out the reagents, and buy the appropriate amount."
      APshowtooltip(this,buymessage)
   end)
   APbuybutton:SetScript("OnLeave",    function()
      APhidetooltip()
   end)

   --close button                          
   APclose = CreateFrame("button",nil,APframe,"UIPanelButtonTemplate")
   APclose:SetWidth(16)
   APclose:SetHeight(20)
   APclose:SetPoint("TopRight",0,0)
   APclose:SetText("x")
   APclose:SetScript("OnClick",    function()
		APframe:Hide()					 
   end)
   

   --all the make poison button						      
   local priorbutton,button,editbox						      
   priorbutton = APbuybutton
   for poison = 1,table.maxn(APpoisons) do
       
   
       --the 'make poison' buttons
                  
       button = CreateFrame("button","APpoisonbutton"..poison,APframe,"UIPanelButtonTemplate")
       button:SetWidth(APBUTTONWIDTH)
       button:SetHeight(APBUTTONHEIGHT)
       if poison == 1 then
        button:SetPoint("Top",priorbutton,"bottom",-15,-30) -- -15 for half of the editbox width
       else
        button:SetPoint("Top",priorbutton,"bottom",0,-5)
       end
       button:SetText("Make "..APpoisons[poison])
       button:Disable()
       button:SetScript("OnClick",function()
          APmakepoison(poison)							 
       end)
       
       
       --the desired totals editboxes
       
       editbox = CreateFrame("editbox","APeditbox"..poison,APframe,"InputBoxTemplate")
       editbox.row = poison
       editbox:SetHeight(APBUTTONHEIGHT)
       editbox:SetWidth(26)
       editbox:SetPoint("left",button,"right",8,0)
       editbox:SetAutoFocus(false)
       editbox:SetText(APpoisonswanted[poison])
       editbox:SetFont("GameFontNormalSmall",10)
       editbox:SetTextColor(.2,1,.4,1)
       editbox:SetNumeric(true)
       editbox:SetMaxLetters(3)
       editbox:SetScript("OnTabPressed",function()
          local nexteditbox = getglobal("APeditbox"..this.row + 1)
          if(nexteditbox) then
            nexteditbox:SetFocus()
          else
            APflasheditbox:SetFocus()  
          end  
       end)
       editbox:SetScript("OnTextChanged",function()
          --APprint("Saving "..this:GetText().." to "..this.row)
          if(this:GetText() == "") then
             this:SetText(0)
          else
             this:SetText(tonumber(this:GetText()))
          end
          APpoisonswanted[this.row] = tonumber(this:GetText())
          APsavevariables()
       end)
                                                                  					
       priorbutton = button					   
   end
   
   
      --desired totals label/button
   APdesired = CreateFrame("button",nil,APframe)
   APdesired:SetHeight(30)
   APdesired:SetWidth(50)
   APdesired:SetPoint("bottom",APeditbox1,"top")
   APdesired:SetTextFontObject(GameFontNormalSmall)
   APdesired:SetText("Desired\nTotal:")
   
       --flash power label/button
   APflash = CreateFrame("button",nil,APframe)
   APflash:SetHeight(APBUTTONHEIGHT)
   APflash:SetWidth(APBUTTONWIDTH)
   APflash:SetPoint("top",priorbutton,"bottom",0,-5)
   APflash:SetTextFontObject(GameFontNormal)
   APflash:SetText("Flash Powder:")
   
   --the desired flash total editboxes
   
   editbox = CreateFrame("editbox","APflasheditbox",APframe,"InputBoxTemplate")
   editbox:SetHeight(APBUTTONHEIGHT)
   editbox:SetWidth(26)
   editbox:SetPoint("left",APflash,"right",8,0)
   editbox:SetAutoFocus(false)
   editbox:SetFont("GameFontNormalSmall",10)
   editbox:SetTextColor(.2,1,.4,1)
   editbox:SetNumeric(true)
   editbox:SetMaxLetters(3)
   editbox:SetText(APflashwanted)
   editbox:SetScript("OnTabPressed",function()
      
        APeditbox1:SetFocus()  
     
   end)
   editbox:SetScript("OnTextChanged",function()
      --APprint("Saving "..this:GetText().." to "..this.row)
      APflashwanted = tonumber(this:GetText())
      APsavevariables()
   end)

  
   
end


