local L = AceLibrary("AceLocale-2.2"):new("ag_UnitFrames")

aUF.Layouts.Raid = {
		Name = "Raid",
		Tip = "Raid",
		ResizeBars = true,
		BackgroundBarColor = false,
		AlphaBar = false,
		RaidColorName == true,
		ComboGFX = true,
		Border = "Classic",
		
		ThemeData = {
			all = {
				FrameHeight = 30,
				FrameWidth = 120,

				HitIndicator = {
					Point = "CENTER",
					RelativePoint = "CENTER",
					x = 1,
					y = 1,
				},

				Combo1 = 	{ 		Point = "BOTTOMRIGHT",
									RelativePoint = "BOTTOMRIGHT",
									x = 1,
									y = -1,
									Height = 10,
									HeightAdd = 0,
									Width = 10,
								},
				ComboText = 	{ 	Font = L["Fonts\\FRIZQT__.TTF"],
									FontSize = 9.5,
									Hidden = true,
								},

				HealthBar_BG = 	{ 	Point = "TOPLEFT",
									RelativePoint = "TOPLEFT",
									x = 9,
									y = -16,
									Visibility = {"HealthBar_BG","HealthBar","BarHealthText","HealthText",},
									Height = 6,
									Width = 82,
									WidthFactor = 1,
								},

				ManaBar_BG = 	{	Point = "TOPLEFT",
									RelativePoint = "TOPLEFT",
									x = 9,
									y = -24,
									Visibility = {"ManaBar_BG","ManaBar","BarManaText","ManaText","ClassText",},
									Height = 6,
									Width = 82,
									HeightAdd = 7,
									WidthFactor = 1,
								},

				XPBar_BG = 		{	Point = "TOPRIGHT",
									RelativePoint = "TOPRIGHT",
									x = -9,
									y = -9,
									Visibility = {"XPBar_BG","XPBar","XPBar_Rest"},
									Width = 52,
									Height = 4,
									Hide = "ClassText",
									WidthFactor = 1,
								},

				CastBar_BG =	{	Hidden = true,
									Visibility = {"CastBar_BG","CastBar","CastText", "BarCastText" },
								},

				NameBackground=	{	Point = "TOPLEFT",
									RelativePoint = "TOPLEFT",
									x=6,
									y=-2,
									Height = 15,
									Width = 108,
								},
					Happiness =	{	Point = "TOPLEFT",
									RelativePoint = "TOPLEFT",
									x=6,
									y=-2,
									Height = 15,
									Width = 108,
									Visibility = {"Happiness",},
								},

				NameLabel = 	{ 	Type = "string",
									Font = L["Fonts\\FRIZQT__.TTF"],
									FontSize = 9,
									Width = 80,
									Point = "TOPLEFT",
									RelativePoint = "TOPLEFT",
									x =7,
									y =-9,
									Height = 1,
								},

				ClassText =	 	{ 	Type = "string",
									Font = L["Fonts\\FRIZQT__.TTF"],
									FontSize = 8,
									Justify = "RIGHT",
									Width = 60,
									Point = "TOPRIGHT",
									RelativePoint = "TOPRIGHT",
									x =-7,
									y =-9,
									Height = 1,
								},

				HealthText = 	{ 	Type = "string",
									Font = L["Fonts\\FRIZQT__.TTF"],
									FontSize = 8,
									Point = "TOPRIGHT",
									RelativePoint = "TOPRIGHT",
									x = -7,
									y = -18,
									Width = 60,
									Height = 1,
								},

				ManaText = 		{ 	Type = "string",
									Font = L["Fonts\\FRIZQT__.TTF"],
									FontSize = 8,
									Point = "TOPRIGHT",
									RelativePoint = "TOPRIGHT",
									x = -7,
									y = -26,
									Width = 60,
									Height = 1,
								},

				PVPIcon = 		{ 	Point = "TOPLEFT",
									RelativePoint = "TOPLEFT",
									x = 48,
									y = -4,
								},

				InCombatIcon =		{	Hidden = true,
								},

				RestingIcon =		{	Hidden = true,
								},

				RaidTargetIcon =	{	Point = "CENTER",
									RelativePoint = "TOP",
									x = 0,
									y = -3,
								},

				LeaderIcon = 	{ 	Point = "TOPLEFT",
									RelativePoint = "TOPLEFT",
									x = 60,
									y = -4,
								},

				MasterIcon = 	{ 	Point = "TOPLEFT",
									RelativePoint = "TOPLEFT",
									x = 70,
									y = -4,
								},
				StatusText =	{	Font = L["Fonts\\FRIZQT__.TTF"],
									FontSize = 9.5,
									Point = "CENTER",
									RelativeTo = "HealthBar_BG",
									RelativePoint = "CENTER",
									x = 0,
									y = -2,
									Hidden = false,
								},
				Portrait = 		{	Hidden = true,
									Visibility = {"Portrait","PortraitModel"}
								},
			},
			player = {
				ClassText =	 	{ 	Hidden = true,
								},
			},
			pet = {
				ClassText =	 	{ 	Hidden = true,
								},
			},
			target = {
				ClassText =	 	{ 	Justify = "RIGHT",
									Width = 60,
									Point = "TOPRIGHT",
									RelativePoint = "TOPRIGHT",
									x = -9,
									y = -9,
								},
				NameLabel = 	{ 	Width = 60,
								},
			},
			targettarget = {
				ClassText =	 	{ 	Hidden = true,
								},
				NameLabel = 	{ 	Width = 102,
								},
			},
		},
	}
