local L = AceLibrary("AceLocale-2.2"):new("ag_UnitFrames")

aUF.Layouts.Compact = {
		Name = "Compact",
		Tip = "Compact Tip",
		ResizeBars = true,
		BackgroundBarColor = false,
		AlphaBar = false,
		RaidColorName == false,
		ComboGFX = true,
		ResizableBar = true,
		Portrait = true,
		Border = "Classic",
		
		ThemeData = {
			all = {
				FrameHeight = 28,
				FrameWidth = 170,

				HitIndicator = {
					Point = "CENTER",
					RelativePoint = "CENTER",
					x = 1,
					y = 1,
				},

				Combo1 = 	{ 		Point = "BOTTOMRIGHT",
									RelativePoint = "BOTTOMRIGHT",
									x = 1,
									y = -1,
									Height = 10,
									HeightAdd = 0,
									Width = 10,
								},

				Portrait = 		{	Point = "TOPLEFT",
									RelativePoint = "TOPLEFT",
									x = 5,
									y = -5,
									Height = 27,
									Width = 27,
									Visibility = {"Portrait","PortraitModel"},
								},

				HealthBar_BG = 	{ 	Point = "TOPLEFT",
									RelativePoint = "TOPRIGHT",
									x = 4,
									y = -10,
									RelativeTo = "Portrait",

									Point2 = "TOPLEFT",
									RelativePoint2 = "TOPLEFT",
									x2 = 9,
									y2 = -15,
									RelativeTo2 = "frame",

									Visibility = {"HealthBar_BG","HealthBar","BarHealthText","HealthText",},
									Height = 6,
									Width2 = 82,
									Width = 55,
									WidthFactor = 1,
								},

				ManaBar_BG = 	{	Point = "TOPLEFT",
									RelativePoint = "BOTTOMLEFT",
									RelativeTo = "HealthBar_BG",
									x = 0,
									y = -1,

									Visibility = {"ManaBar_BG","ManaBar","BarManaText","ManaText","ClassText",},
									Height = 6,
									Width = 82,
									HeightAdd = 7,

									WidthP = 55,
									WidthFactor = 1,
								},

				XPBar_BG = 		{	Point = "TOPRIGHT",
									RelativePoint = "TOPRIGHT",
									x = -9,
									y = -9,
									Visibility = {"XPBar_BG","XPBar","XPBar_Rest"},
									Width = 22,
									Height = 4,
									Hide = "ClassText",
									WidthFactor = 1,
								},

				CastBar_BG =	{	Hidden = true,
									Visibility = {"CastBar_BG","CastBar","CastText", "BarCastText" },
								},

				NameBackground=	{	Point = "TOPLEFT",
									RelativePoint = "TOPLEFT",
									x=6,
									y=-2,
									Height = 15,
									Width = 158,
								},
					Happiness =	{	Point = "TOPLEFT",
									RelativePoint = "TOPLEFT",
									x=6,
									y=-2,
									Height = 15,
									Width = 82,
									Visibility = {"Happiness",},
								},

				NameLabel = 	{ 	Type = "string",
									Font = L["Fonts\\FRIZQT__.TTF"],
									FontSize = 9,
									Width = 84,

									Point = "TOPLEFT",
									RelativePoint = "TOPRIGHT",
									x = 3,
									y = -4,
									RelativeTo = "Portrait",

									Point2 = "TOPLEFT",
									RelativePoint2 = "TOPLEFT",
									x2 =7,
									y2 =-9,
									RelativeTo2 = "frame",

									Height = 1,
								},

				ClassText =	 	{ 	Type = "string",
									Font = L["Fonts\\FRIZQT__.TTF"],
									FontSize = 8,
									Justify = "RIGHT",
									Width = 80,
									Point = "TOPRIGHT",
									RelativePoint = "TOPRIGHT",
									x =-7,
									y =-9,
									Height = 1,
								},

				HealthText = 	{ 	Type = "string",
									Font = L["Fonts\\FRIZQT__.TTF"],
									FontSize = 8,
									Point = "TOPRIGHT",
									RelativePoint = "TOPRIGHT",
									x = -7,
									y = -17,
									Width = 60,
									Height = 1,
									Justify = "RIGHT",
								},

				ManaText = 		{ 	Type = "string",
									Font = L["Fonts\\FRIZQT__.TTF"],
									FontSize = 8,
									Point = "TOPRIGHT",
									RelativePoint = "TOPRIGHT",
									x = -7,
									y = -24,
									Width = 60,
									Height = 1,
									Justify = "RIGHT",
								},

				PVPIcon = 		{ 	Point = "TOPRIGHT",
									RelativePoint = "TOPRIGHT",
									x = 14,
									y= 2,
								},

				InCombatIcon =		{	Hidden = true,
								},

				RestingIcon =		{	Hidden = true,
								},

				RaidTargetIcon =	{	Point = "CENTER",
									RelativePoint = "TOP",
									x = 0,
									y = -3,
								},

				LeaderIcon = 	{ 	Point = "TOPLEFT",
									RelativePoint = "TOPLEFT",
									x = -2,
									y= 2,
								},

				MasterIcon = 	{ 	Point = "TOPLEFT",
									RelativePoint = "TOPLEFT",
									x = -5,
									y= 2,
								},
			},
		},
	}
