local L = AceLibrary("AceLocale-2.2"):new("ag_UnitFrames")

aUF.Layouts.ABF = {
	Name = "ABF",
	Tip = "ABF Tip",
	ResizeBars = false,
	BackgroundBarColor = true,
	AlphaBar = true,
	RaidColorName = false,
	PetClassName = true,
	ComboGFX = true,
	HappinessBar = true,
	Portrait = true,
	Border = "Hidden",

	Auras = {
		Topleft = {
			Point = "TOPRIGHT",
			RelativePoint = "TOPLEFT",
			x = -3,
			y = -3,
			GrowDirection = "left",
			Scale = 0.80,
			Alpha = 1,
		},
		Left = {
			Point = "RIGHT",
			RelativePoint = "LEFT",
			x = 0,
			y = 0,
			GrowDirection = "left",
			Scale = 0.80,
			Alpha = 1,
		},
		Bottomleft = {
			Point = "BOTTOMRIGHT",
			RelativePoint = "BOTTOMLEFT",
			x = -3,
			y = 3,
			GrowDirection = "left",
			Scale = 0.80,
			Alpha = 1,
		},
		Topright = {
			Point = "TOPLEFT",
			RelativePoint = "TOPRIGHT",
			x = 3,
			y = -3,
			GrowDirection = "right",
			Scale = 0.80,
			Alpha = 1,
		},
		Right = {
			Point = "LEFT",
			RelativePoint = "RIGHT",
			x = 0,
			y = 0,
			GrowDirection = "right",
			Scale = 0.80,
			Alpha = 1,
		},
		Bottomright = {
			Point = "BOTTOMLEFT",
			RelativePoint = "BOTTOMRIGHT",
			x = 3,
			y = 3,
			GrowDirection = "right", 
			Scale = 0.80,
			Alpha = 1,
		},  
		Above = {
			Point = "BOTTOMLEFT",
			RelativePoint = "TOPLEFT",
			x = 3,
			y = -0,
			GrowDirection = "right",
			Scale = "auto",
			AdjustAuto = 7,
			Alpha = 1,
		},
		Below = {
			Point = "TOPLEFT",
			RelativePoint = "BOTTOMLEFT",
			x = 3,
			y = 0,
			GrowDirection = "right",
			Scale = "auto",
			AdjustAuto = 7,
			Alpha = 1,
		},
		Inside = {
			Point = "TOPRIGHT",
			RelativePoint = "TOPRIGHT",
			x = -6,
			y = -6,
			GrowDirection = "left",
			Scale = 0.7,
			Alpha = 0.75,
		}
	},
	ThemeData = {
		all = {
			FrameHeight = 27,
			FrameWidth = 165,

			HitIndicator = {
				Point = "CENTER",
				RelativePoint = "CENTER",
				x = 1,
				y = 1,
			},
			Combo1 = {
				Point = "BOTTOMRIGHT",
				RelativePoint = "BOTTOMRIGHT",
				x = 1,
				y = -1,
				Height = 10,
				HeightAdd = 0,
				Width = 10,
			},

			HealthBar_BG = 	{
				Point = "TOPLEFT",
				RelativePoint = "TOPRIGHT",
				x = 1,
				y = 0,
				RelativeTo = "Portrait",

				Point2 = "TOPLEFT",
				RelativePoint2 = "TOPLEFT",
				x2 = 5,
				y2 = -5,
				RelativeTo2 = "frame",

				Visibility = {"HealthBar_BG","HealthBar","BarHealthText","HealthText",},
				Height = 17,
				HeightAdd = 0,
				Width2 = 90,
				Width = 58,
				WidthFactor = 1,
			},

			ManaBar_BG = {
				Point = "TOPLEFT",
				RelativePoint = "BOTTOMLEFT",
				RelativeTo = "HealthBar_BG",
				x = 0,
				y = -1,
				HeightAdd = 14,
				Visibility = {"ManaBar_BG","ManaBar","BarManaText","ManaText","ClassText","Portrait"},
				Height = 13,
				Width = 90,
				WidthP = 58,
				WidthFactor = 1,
			},

			XPBar_BG = {
				RelativeTo = "Portrait",
				Point = "TOPLEFT",
				RelativePoint = "BOTTOMLEFT",
				x = 0,
				y = -1,

				RelativeTo2 = "ManaBar_BG",
				Point2 = "TOPLEFT",
				RelativePoint2 = "BOTTOMLEFT",
				x2 = 0,
				y2 = -1,

				Point3 = "TOPLEFT",
				RelativePoint3 = "BOTTOMLEFT",
				RelativeTo3 = "HealthBar_BG",
				x3 = 0,
				y3 = -1,

				HeightAdd = 6,
				Visibility = {"XPBar_BG","XPBar"},
				Width = 90,
				Height = 5,
				WidthFactor = 1,
			},

			CastBar_BG = {
				Hidden = false,

				RelativeTo = "XPBar_BG",
				Point = "TOPLEFT",
				RelativePoint = "BOTTOMLEFT",
				x = 0,
				y = -1,

				RelativeTo2 = "Portrait",
				Point2 = "TOPLEFT",
				RelativePoint2 = "BOTTOMLEFT",
				x2 = 0,
				y2 = -1,

				RelativeTo3 = "ManaBar_BG",
				Point3 = "TOPLEFT",
				RelativePoint3 = "BOTTOMLEFT",
				x3 = 0,
				y3 = -1,

				RelativeTo4 = "HealthBar_BG",
				Point4 = "TOPLEFT",
				RelativePoint4 = "BOTTOMLEFT",
				x4 = 0,
				y4 = -1,

				HeightAdd = 11,
				Visibility = {"CastBar_BG","CastBar","CastText", "BarCastText" },
				Width = 90,
				WidthP = 90,
				Height = 10,

				WidthFactor = 1,
			},

			NameBackground= {
				Hidden = true,
			},

			Happiness = {
				Point = "TOPLEFT",
				RelativeTo = "HealthBar_BG",
				RelativePoint = "TOPLEFT",
				x=0,
				y=0,
				Height = 15,
				Width = 90,
				Visibility = {"Happiness",},
			},

			NameLabel = {
				Type = "string",
				Font = L["Interface\\AddOns\\ag_UnitFrames\\fonts\\barframes.ttf"],
				FontSize = 10,
				Point = "LEFT",
				RelativeTo = "HealthBar",
				RelativePoint = "LEFT",
				x = 1.5,
				y =0,

				EndPoint = "RIGHT",
				EndRelativeTo = "HealthText",
				EndRelativePoint = "LEFT",
				Endx=2,
				Endy=0,
				Height = 1,
			},

			ClassText = {
				Type = "string",
				Font = L["Interface\\AddOns\\ag_UnitFrames\\fonts\\barframes.ttf"],
				FontSize = 9,
				Justify = "LEFT",
				Point = "LEFT",
				RelativeTo = "ManaBar",
				RelativePoint = "LEFT",
				x = 1.5,
				y = 0.5,

				EndPoint = "RIGHT",
				EndRelativeTo = "ManaText",
				EndRelativePoint = "LEFT",
				Endx=2,
				Endy=0,
				Height = 1,
			},

			HealthText = {
				Type = "string",
				Font = L["Interface\\AddOns\\ag_UnitFrames\\fonts\\barframes.ttf"],
				FontSize = 10,
				Point = "RIGHT",
				RelativeTo = "HealthBar",
				RelativePoint = "RIGHT",
				x=-1.5,
				y=0,
				Justify = "RIGHT",
				Height = 1,
				Width = 0,
--				WidthP = 22.5,
--				WidthFactor = 0.55,
			},

			ManaText = {
				Type = "string",
				Font = L["Interface\\AddOns\\ag_UnitFrames\\fonts\\barframes.ttf"],
				FontSize = 9,
				Point = "RIGHT",
				RelativeTo = "ManaBar",
				RelativePoint = "RIGHT",
				x= -1.5,
				y= 0.5,
				Justify = "RIGHT",
				Height = 1,
				Width = 0,
--				WidthP = 22.5,
--				WidthFactor = 0.55,
			},

			CastText = {
				RelativeTo = "CastBar_BG",
				Point = "RIGHT",
				RelativePoint = "RIGHT",
				x = -0.5,
				y = 0.5,

				Width = 60,
				Height = 1,

				Font = L["Interface\\AddOns\\ag_UnitFrames\\fonts\\barframes.ttf"],
				FontSize = 8,
			},

			BarCastText = {
				RelativeTo = "CastBar_BG",
				Point = "LEFT",
				RelativePoint = "LEFT",
				x = 0.5,
				y = 0.5,

				Width = 60,
				Height = 1,

				Font = L["Interface\\AddOns\\ag_UnitFrames\\fonts\\barframes.ttf"],
				FontSize = 8,
				Justify = "LEFT",

				EndPoint = "RIGHT",
				EndRelativeTo = "CastText",
				EndRelativePoint = "LEFT",
				Endx=0,
				Endy=0,
			},

			PVPIcon = {
				Point = "TOPRIGHT",
				RelativePoint = "TOPRIGHT",
				x = 14,
				y= 2,
			},

			InCombatIcon = {
				Point = "BOTTOMLEFT",
				RelativePoint = "BOTTOMLEFT",
				x = -4,
				y= -3,
			},

			RaidTargetIcon = {
				Point = "CENTER",
				RelativePoint = "TOP",
				x = 0,
				y = -3,
			},

			LeaderIcon = {
				Point = "TOPLEFT",
				RelativePoint = "TOPLEFT",
				x = -2,
				y= 2,
			},

			MasterIcon = {
				Point = "TOPLEFT",
				RelativePoint = "TOPLEFT",
				x = -5,
				y= 2,
			},

			Portrait = {
				Point = "TOPLEFT",
				RelativePoint = "TOPLEFT",
				x = 5,
				y = -5,
				Height = 31,
				Width = 31,
				Visibility = {"Portrait","PortraitModel"},
			},
		},
		target = {
			Portrait = {
				Point = "TOPRIGHT",
				RelativePoint = "TOPRIGHT",
				x = -5,
				y = -5,
				Height = 31,
				Width = 31,
				Visibility = {"Portrait","PortraitModel"},
			},
			HealthBar_BG = {
				Point = "TOPRIGHT",
				RelativePoint = "TOPLEFT",
				x = -1,
				y = 0,
				RelativeTo = "Portrait",

				Point2 = "TOPLEFT",
				RelativePoint2 = "TOPLEFT",
				x2 = 5,
				y2 = -5,
				RelativeTo2 = "frame",

				Visibility = {"HealthBar_BG","HealthBar","BarHealthText","HealthText",},
				Height = 17,
				HeightAdd = 0,
				Width2 = 90,
				Width = 58,
				WidthFactor = 1,
			},

			CastBar_BG = {
				Hidden = false,

				RelativeTo = "Portrait",
				Point = "TOPRIGHT",
				RelativePoint = "BOTTOMRIGHT",
				x = 0,
				y = -1,

				RelativeTo2 = "ManaBar_BG",
				Point2 = "TOPLEFT",
				RelativePoint2 = "BOTTOMLEFT",
				x2 = 0,
				y2 = -1,

				RelativeTo3 = "HealthBar_BG",
				Point3 = "TOPLEFT",
				RelativePoint3 = "BOTTOMLEFT",
				x3 = 0,
				y3 = -1,

				Visibility = {"CastBar_BG","CastBar","CastText", "BarCastText" },
				Width = 90,
				WidthP = 90,
				Height = 10,

				WidthFactor = 1,
			},
		},
		raid = {
			FrameWidth = 125,
		},
	}
}

