local L = AceLibrary("AceLocale-2.2"):new("ag_UnitFrames")

aUF.UnitInformation = {
	["name"] = { func = function(u)
		local type = u:gsub("%d", "")
		if aUF.db.profile.units[type].RaidColorName and UnitIsPlayer(u) then
			local _,x=UnitClass(u)
			return string.format("%s%s%s",aUF:GetRaidColors(x) or "",UnitName(u) or "","|cFFFFFFFF")
		else
			return UnitName(u) or ""
		end
	end, event = "UNIT_NAME_UPDATE"},
	["namehostile"] = { func = function(u)
		local type = u:gsub("%d", "")
		if aUF.db.profile.units[type].RaidColorName and UnitIsPlayer(u) then
			local _,x=UnitClass(u)
			return string.format("%s%s%s",aUF:GetRaidColors(x) or "",UnitName(u) or "","|cFFFFFFFF")
		else
			local color = aUF:UtilFactionColors(u)
			return string.format("%s%s%s",aUF:GiveHex(color.r,color.g,color.b),UnitName(u) or "","|cFFFFFFFF")
		end
	end, event = "UNIT_NAME_UPDATE"},
	["status"] = function (u)
		if UnitIsDead(u) then
			return L["Dead"]
		elseif UnitIsGhost(u) then
			return L["Ghost"]
		elseif (not UnitIsConnected(u)) then
			return L["Offline"]
		elseif (UnitAffectingCombat(u)) then
			return L["Combat"]
		elseif (u == "player" and IsResting()) then
			return L["Resting"]
		else
			return ""
		end
	end,
	["statuscolor"] = function (u)
		if UnitIsDead(u) then
			return "|cffff0000"
		elseif UnitIsGhost(u) then
			return "|cff9d9d9d"
		elseif (not UnitIsConnected(u)) then
			return "|cffff8000"
		elseif (UnitAffectingCombat(u)) then
			return "|cffFF0000"
		elseif (u== "player" and IsResting()) then
			return aUF:GiveHex(UnitReactionColor[4].r, UnitReactionColor[4].g, UnitReactionColor[4].b)
		else
			return ""
		end
	end,
	["happycolor"] = function (u) local x=GetPetHappiness() return ( (x==2) and "|cffFFFF00" or (x==1) and "|cffFF0000" or "" ) end,

	["aghp"]            = { func = function(u) return aUF:Tag_aghp(u) or "" end, event = "UNIT_HEALTH" },
	["agpercenthp"]     = { func = function(u) return aUF:Tag_aghp(u,1) or "" end, event = "UNIT_HEALTH" },
	["agmissinghp"]     = { func = function(u) return aUF:Tag_aghp(u,2) or "" end, event = "UNIT_HEALTH" },
	["agsmarthp"]       = { func = function(u) return aUF:Tag_aghp(u,3) or "" end, event = "UNIT_HEALTH" },
	["agcurrenthp"]     = { func = function(u) return aUF:Tag_aghp(u,4) or "" end, event = "UNIT_HEALTH" },

	["agmana"]          = { func = function(u) return aUF:Tag_agmana(u) or "" end, event = {"UNIT_MANA","UNIT_RAGE","UNIT_FOCUS","UNIT_ENERGY","UNIT_DISPLAYPOWER"} },
	["agpercentmana"]   = { func = function(u) return aUF:Tag_agmana(u,1) or "" end, event = {"UNIT_MANA","UNIT_RAGE","UNIT_FOCUS","UNIT_ENERGY","UNIT_DISPLAYPOWER"} },
	["agmissingmana"]   = { func = function(u) return aUF:Tag_agmana(u,2) or "" end, event = {"UNIT_MANA","UNIT_RAGE","UNIT_FOCUS","UNIT_ENERGY","UNIT_DISPLAYPOWER"} },
	["agsmartmana"]     = { func = function(u) return aUF:Tag_agmana(u,3) or "" end, event = {"UNIT_MANA","UNIT_RAGE","UNIT_FOCUS","UNIT_ENERGY","UNIT_DISPLAYPOWER"} },

	["agclass"] = function (u) if UnitIsPlayer(u) then return (UnitClass(u) or L["Unknown"]) else return (UnitCreatureFamily(u) or UnitCreatureType(u) or "") end end,
	["agrace"] = function (u) if u:find("target") then return UnitRace(u) or "" else return "" end end,

	["curhp"] = {func = function (u)
		local currValue,maxValue = UnitHealth(u), UnitHealthMax(u)
		if not UnitIsFriend("player", u) then
			if MobHealth3 then
				local curr, max, MHfound = MobHealth3:GetUnitHealth(u, currValue,maxValue)
				if MHfound then
					return curr
				end
			elseif MobHealth_GetTargetCurHP then
				local curr = MobHealth_GetTargetCurHP()
				if curr then
					return curr
				end
			end
		end
		return currValue or 0
	end, event = "UNIT_HEALTH" },
	["maxhp"] = {func = function (u)
		local currValue,maxValue = UnitHealth(u), UnitHealthMax(u)
		if not UnitIsFriend("player", u) then
			if MobHealth3 then
				local curr, max, MHfound = MobHealth3:GetUnitHealth(u, currValue,maxValue)
				if MHfound then
					return max
				end
			elseif MobHealth_GetTargetMaxHP then
				local max = MobHealth_GetTargetMaxHP()
				if max then
					return max
				end
			end
		end
		return maxValue or 1
	end, event = "UNIT_HEALTH" },
	["percenthp"] = { func = function (u) local hpmax = UnitHealthMax(u) return (hpmax ~= 0) and floor((UnitHealth(u) / hpmax) * 100) or 0 end, event = "UNIT_HEALTH" },
	["missinghp"] = { func = function (u)
		local currValue,maxValue = UnitHealth(u), UnitHealthMax(u)
		if not UnitIsFriend("player", u) then
			if MobHealth3 then
				local curr, max, MHfound = MobHealth3:GetUnitHealth(u, currValue,maxValue)
				if MHfound then
					return max - curr
				end
			elseif MobHealth_GetTargetCurHP and MobHealth_GetTargetMaxHP then
				local curr = MobHealth_GetTargetCurHP()
				local max = MobHealth_GetTargetMaxHP()
				if curr and max then
					return max - curr
				end
			end
		end
		return maxValue and currValue and maxValue-currValue or 0
	end, event = "UNIT_HEALTH"},

	["curmana"]     = { func = function (u) return UnitMana(u) or 1 end, event = {"UNIT_MANA","UNIT_RAGE","UNIT_FOCUS","UNIT_ENERGY","UNIT_DISPLAYPOWER"}},
	["maxmana"]     = { func = function (u) return UnitManaMax(u) or 0 end, event = {"UNIT_MANA","UNIT_RAGE","UNIT_FOCUS","UNIT_ENERGY","UNIT_DISPLAYPOWER"}},
	["percentmana"] = { func = function (u) local mpmax = UnitManaMax(u) return (mpmax ~= 0) and floor((UnitMana(u) / mpmax) * 100) or 0 end, event = {"UNIT_MANA","UNIT_RAGE","UNIT_FOCUS","UNIT_ENERGY","UNIT_DISPLAYPOWER"}},
	["missingmana"] = { func = function (u) return UnitManaMax(u) - UnitMana(u) or 0 end, event = {"UNIT_MANA","UNIT_RAGE","UNIT_FOCUS","UNIT_ENERGY","UNIT_DISPLAYPOWER"}},

	["typemana"] = function (u) local p=UnitPowerType(u) return ( (p==1) and L["Rage"] or (p==2) and L["Focus"] or (p==3) and L["Energy"] or L["Mana"] ) end,
	["level"] = {func = function (u) local x = UnitLevel(u) return ((x>0) and x or "??") end, event = "UNIT_LEVEL"},
	["class"] = function (u) return (UnitClass(u) or L["Unknown"]) end,
	["creature"] = function (u) return (UnitCreatureFamily(u) or UnitCreatureType(u) or L["Unknown"]) end,
	["smartclass"] = function (u) if UnitIsPlayer(u) then return aUF.UnitInformation["class"](u) else return aUF.UnitInformation["creature"](u) end end,
	["combos"] = { func = function (u) return (GetComboPoints() or 0) end, event = "PLAYER_COMBO_POINTS"},
	["combos2"] = { func = function (u) return string.rep("@", GetComboPoints()) end, event = "PLAYER_COMBO_POINTS"},
	["classification"] = function (u)
		if UnitClassification(u) == "rare" then
			return L["Rare"]
		elseif UnitClassification(u) == "rareelite" then
			return L["Rare-Elite"]
		elseif UnitClassification(u) == "elite" then
			return L["Elite"]
		elseif UnitClassification(u) == "worldboss" then
			return L["Boss"]
		else
			return ""
		end
	end,
	["faction"] = function (u) return (UnitFactionGroup(u) or "") end,
	["connect"] = function (u) return ( (UnitIsConnected(u)) and "" or L["Offline"] ) end,
	["race"] = function (u) return ( UnitRace(u) or "") end,
	["pvp"] = function (u) return ( UnitIsPVP(u) and "PvP" or "" ) end,
	["plus"] = function (u) return ( UnitIsPlusMob(u) and "+" or "" ) end,
	["sex"] = function (u) local x = UnitSex(u) return ( (x==0) and L["Male"] or (x==1) and L["Female"] or "" ) end,
	["rested"] = function (u) return (GetRestState()==1 and L["Rested"] or "") end,
	["leader"] = function (u) return (UnitIsPartyLeader(u) and L["(L)"] or "") end,
	["leaderlong"] = function (u) return (UnitIsPartyLeader(u) and L["(Leader)"] or "") end,

	["happynum"] = function (u) return (GetPetHappiness() or 0) end,
	["happytext"] = function (u) return ( getglobal("PET_HAPPINESS"..(GetPetHappiness() or 0)) or "" ) end,
	["happyicon"] = function (u) local x=GetPetHappiness() return ( (x==3) and ":)" or (x==2) and ":|" or (x==1) and ":(" or "" ) end,

	["curxp"] = function (u) return (UnitXP(u) or "") end,
	["maxxp"] = function (u) return (UnitXPMax(u) or "") end,
	["percentxp"] = function (u) local x=UnitXPMax(u) if (x>0) then return floor( UnitXP(u)/x*100+0.5) else return 0 end end,
	["missingxp"] = function (u) return (UnitXPMax(u) - UnitXP(u)) end,
	["restedxp"] = function (u) return (GetXPExhaustion() or "") end,

	["tappedbyme"] = function (u) if UnitIsTappedByPlayer("target") then return "*" else return "" end end,
	["istapped"] = function (u) if UnitIsTapped(u) and (not UnitIsTappedByPlayer("target")) then return L["Tapped"] else return "" end end,
	["pvpranknum"] = function (u) if (UnitPVPRank(u) >= 1) then return ((UnitPVPRank(u)-4) or "") else return "" end end,
	["pvprank"] = function (u) if (UnitPVPRank(u) >= 1) then return (GetPVPRankInfo(UnitPVPRank(u), u) or "" ) else return "" end end,
	["fkey"] = function (u)
		local _,_,fkey = u:find("^party(%d)$")
		if u == "player" then
			fkey = 0
		end
		if not fkey then
			return ""
		else
			return "F"..(fkey+1)
		end
	end,
	["white"] = function (u) return "|cFFFFFFFF" end,
	["aggro"] = function (u)
		local x = (UnitReaction("player",u) or 5)
		return aUF:GiveHex(UnitReactionColor[x].r, UnitReactionColor[x].g, UnitReactionColor[x].b)
	end,
	["difficulty"] = function (u)
		if UnitCanAttack("player",u) then
			local x = (UnitLevel(u)>0) and UnitLevel(u) or 99
			local color = GetDifficultyColor(x)
			return aUF:GiveHex(color.r,color.g,color.b)
		else
			return ""
		end
	end,
	["colormp"] = function (u) local x = ManaBarColor[UnitPowerType(u)] return aUF:GiveHex(x.r, x.g, x.b) end,
	["inmelee"] = function (u) if PlayerFrame.inCombat then return "|cffFF0000" else return "" end end,
	["incombat"] = function (u) if UnitAffectingCombat(u) then return "|cffFF0000" else return "" end end,
	["raidcolor"] = function (u) local _,x=UnitClass(u) if x and UnitIsPlayer(u) then return (aUF:GetRaidColors(x) or "") else return "" end end,
	["raidgroup"] = { func = function (u) for i=1, GetNumRaidMembers() do local name, rank, subgroup = GetRaidRosterInfo(i) if (name == UnitName(u)) then return "(" .. subgroup .. ")"  end end return "" end, event = "RAID_ROSTER_UPDATE"},

	["guild"] = function (u) return (GetGuildInfo(u)) or "" end,
	["guildrank"] = function (u) local _, r = GetGuildInfo(u); return r or "" end,
	["guild_"] = function (u) local g = GetGuildInfo(u); if g then return "<" .. g .. ">" else return "" end end,
}
