local SM = AceLibrary("LibSharedMedia-2.0")

function aUF:SetupVariables()
	-- Which auras can the player see?
	self.CanDispel = {
		PRIEST = {
			Magic = true,
			Disease = true,
		},
		SHAMAN = {
			Poison = true,
			Disease = true,
		},
		PALADIN = {
			Magic = true,
			Poison = true,
			Disease = true,
		},
		MAGE = {
			Curse = true,
		},
		DRUID = {
			Curse = true,
			Poison = true,
		}
	}

	-- Various constants like colors, textures...

	self.RepColor = {
		[1] = {r = 226/255, g = 45/255, b = 75/255},
		[2] = {r = 226/255, g = 45/255, b = 75/255},
		[3] = {r = 0.75, g = 0.27, b = 0},
		[4] = {r = 1, g = 1, b = 34/255},
		[5] = {r = 0.2, g = 0.8, b = 0.15},
		[6] = {r = 0.2, g = 0.8, b = 0.15},
		[7] = {r = 0.2, g = 0.8, b = 0.15},
		[8] = {r = 0.2, g = 0.8, b = 0.15},
	}

	self.HealthColor = {
		r = 0.11,
		g = 0.84,
		b = 0.3,
	}

	self.ManaColor = {
		[0] = { r = 48/255, g = 113/255, b = 191/255}, 		-- Mana
		[1] = { r = 226/255, g = 45/255, b = 75/255}, 		-- Rage
		[2] = { r = 255/255, g = 210/255, b = 0}, 			-- Focus
		[3] = { r = 255/255, g = 220/255, b = 25/255},		-- Energy
		[4] = { r = 0.00, g = 1.00, b = 1.00} 				-- Happiness
	}
	
	self.TapDeadColor = {
		r = 0.5,
		g = 0.5,
		b = 0.3,
	}

	self.Borders = {
		Classic = {texture = "Interface\\Tooltips\\UI-Tooltip-Border",size = 16,insets = 5},
		Nurfed  = {texture = "Interface\\DialogFrame\\UI-DialogBox-Border",size = 16,insets = 5},
		Hidden  = {texture = "",size = 0,insets = 3},
	}

	local bars = {
		Otravi   = "Interface\\AddOns\\ag_UnitFrames\\images\\bars\\AceBarFrames.tga",
		Classic  = "Interface\\TargetingFrame\\UI-StatusBar",
		Smooth   = "Interface\\AddOns\\ag_UnitFrames\\images\\bars\\smooth.tga",
		Gloss    = "Interface\\AddOns\\ag_UnitFrames\\images\\bars\\Gloss.tga",
		BantoBar = "Interface\\AddOns\\ag_UnitFrames\\images\\bars\\BantoBar.tga",
		Steel    = "Interface\\AddOns\\ag_UnitFrames\\images\\bars\\Steel.tga",
		Round    = "Interface\\AddOns\\ag_UnitFrames\\images\\bars\\Round.tga",
	}

	for n,t in pairs(bars) do
		SM:Register("statusbar", n, t)
	end
end

