local L = AceLibrary("AceLocale-2.2"):new("ag_UnitFrames")
local media = AceLibrary("LibSharedMedia-2.0")
local dewdrop = AceLibrary("Dewdrop-2.0")

local aUF = aUF

local function getOption(key)
	return aUF.db.profile[key]
end

local function setOption(key, value)
	aUF.db.profile[key] = value
end

local function getColor(key)
	if type(key) == "string" then
		return aUF.db.profile[key].r, aUF.db.profile[key].g, aUF.db.profile[key].b, aUF.db.profile[key].a
	else
		return aUF.db.profile.ManaColor[key].r, aUF.db.profile.ManaColor[key].g, aUF.db.profile.ManaColor[key].b, aUF.db.profile.ManaColor[key].a
	end
end

local function setColor(key, r, g, b, a)
	if type(key) == "string" then
		aUF.db.profile[key] = { r = r, g = g, b = b, a = a }
	else
		aUF.db.profile.ManaColor[key] = { r = r, g = g, b = b, a = a }
	end
	if key == "PartyFrameColors" or key == "TargetFrameColors" or key == "FrameBorderColors" then
		aUF:CallUnitMethods("BorderBackground")
		aUF:CallUnitMethods("BorderBackground",nil,nil,nil,"subgroups")
	else
		aUF:CallUnitMethods("StatusBarsColor")
	end
end

-- Dewdrop stuff

function aUF:CreateMenu()
	local unitTable = {}
	unitTable.UnitHeader = {
		name = L["unitsettings"],
		type = "header",
		order = 1,
	}

	local agDewdropMenu = {
		type= "group",
		args = {
			Spacing1 = {
				name = " ",
				type = "header",
				order = 19,
			},
			options = {
				name = L["options"],
				type = "group",
				desc = L["optionsDesc"],
				order = 20,
				args = {
					FrameColors = {
						type= "group",
						name = L["framecolors"],
						desc = L["framecolorsdesc"],
						args = {
							partybg = {
								name = L["partybg"],
								type = "color",
								desc = L["partybgdesc"],
								hasAlpha = true,
								get = getColor,
								set = setColor,
								passValue = "PartyFrameColors",
								order = 1,
							},
							targetbg = {
								name = L["targetbg"],
								type = "color",
								desc = L["targetbgdesc"],
								hasAlpha = true,
								get = getColor,
								set = setColor,
								passValue = "TargetFrameColors",
								order = 2,
							},
							border = {
								name = L["bordercolor"],
								type = "color",
								desc = L["bordercolordesc"],
								hasAlpha = true,
								get = getColor,
								set = setColor,
								passValue = "FrameBorderColors",
								order = 3,
							},
						},
						order = 51,
					},
					BarColors = {
						type= "group",
						order = 52,
						name = L["barcolors"],
						desc = L["barcolorsDesc"],
						args = {
							Health = {
								name = L["health"],
								type = "color",
								desc = L["healthDesc"],
								get = getColor,
								set = setColor,
								passValue = "HealthColor",
								order = 1,
							},
							Mana = {
								name = L["mana"],
								type = "color",
								desc = L["manaDesc"],
								get = getColor,
								set = setColor,
								passValue = 0,
								order = 2,
							},
							Rage = {
								name = L["rage"],
								type = "color",
								desc = L["rageDesc"],
								get = getColor,
								set = setColor,
								passValue = 1,
								order = 3,
							},
							Energy = {
								name = L["energy"],
								type = "color",
								desc = L["energyDesc"],
								get = getColor,
								set = setColor,
								passValue = 3,
								order = 4,
							},
							PetFocus = {
								name = L["petfocus"],
								type = "color",
								desc = L["petfocusDesc"],
								get = getColor,
								set = setColor,
								passValue = 2,
								order = 5,
							},
							Casting = {
								type = "color",
								name = L["Casting bar"],
								desc = L["Set the color for the casting bar progress."],
								get = getColor,
								set = setColor,
								passValue = "CastbarColor",
								order = 6,
							},
						},
					},
					BarStyle = {
						name = L["barstyle"],
						type = "text",
						desc = L["BarStyleDesc"],
						get = getOption,
						set = function(key, value)
							self.db.profile.BarStyle = value
							self:CallUnitMethods("BarTexture")
						end,
						passValue = "BarStyle",
						validate = media:List("statusbar"),
						order = 53,
					},
					Spacing1 = {
						name = " ",
						type = "header",
						order = 54,
					},
					ShowPvPIcon = {
						name = L["pvpicon"],
						type = "toggle",
						desc = L["ShowPVPIconDesc"],
						get = getOption,
						set = function(key, value)
							self.db.profile.ShowPvPIcon = value
							self:CallUnitMethods("UpdatePvP",true)
						end,
						passValue = "ShowPvPIcon",
						order = 55,
					},
					ShowGroupIcons = {
						name = L["groupicon"],
						type = "toggle",
						desc = L["ShowGroupIconsDesc"],
						get = getOption,
						set = function(key, value)
							self.db.profile.ShowGroupIcons = value
							self:CallUnitMethods("LabelsCheckLeader")
						end,
						passValue = "ShowGroupIcons",
						order = 56,
					},
					HighlightSelected = {
						name = L["highlightselected"],
						type = "toggle",
						desc = L["HighlightSelectedDesc"],
						get = getOption,
						set = setOption,
						passValue = "HighlightSelected",
						order = 57,
					},
					SmoothBarColoring = {
						name = L["smoothbarcoloring"],
						type = "toggle",
						desc = L["SmoothBarColoringDesc"],
						get = getOption,
						set = function(key, value)
							self.db.profile.SmoothHealthBars = value
							self:CallUnitMethods("StatusBarsColor")
						end,
						passValue = "SmoothHealthBars",
						order = 58,
					},
				},
			},
			Locked = {
				name = L["lock"],
				type = "toggle",
				desc = L["LockedDesc"],
				get = getOption,
				set = function(key, value)
					self.db.profile.Locked = value
					self:UpdateDisplay()
				end,
				passValue = "Locked",
				order = 59,
			},
		}
	}

	-- Needed to create the AceOptions table
	local wowClasses = {"player","pet","party","partypet","target","targettarget","targettargettarget","raid","focus","focustarget"}

	for order,unit in ipairs(wowClasses) do
		agDewdropMenu.args[unit] = aUF:CreateDewdrop(unit,(order + 1),true)
	end

	return agDewdropMenu
end

do
	local function getUnitOption(pair)
		return aUF.db.profile.units[pair[1]][pair[2]]
	end

	local function setUnitOption(pair, value)
		aUF.db.profile.units[pair[1]][pair[2]] = value
	end

	local function setUnitStringOption(pair, value)
		aUF.db.profile.units[pair[1]][pair[2]] = value
		aUF:CallUnitMethods("GetStringEvents",true,pair[1],"type")
		aUF:CallUnitMethods("GetStringEvents",nil,pair[1],"type")
		aUF:CallUnitMethods("UpdateTextStrings",nil,pair[1],"type")
	end

	local function validateWatchdog(option)
		for s,data,e in option:gmatch("()(%b[])()") do
			local tag = data:sub(2, -2)
			local func = aUF:GetTagFunction(tag)
			if not func then
				return false
			end
		end
		return true
	end

	local function getUnitStringWidth(pair)
		local db = aUF.db.profile.units[pair[1]][pair[2]]
		if db then
			return db
		else
			return 0
		end
	end

	local function setUnitStringWidth(pair, value)
		aUF.db.profile.units[pair[1]][pair[2]] = value
		aUF:CallUnitMethods("SetWidth",nil,pair[1],"type")
	end

	local function setUnitFrameStyle(pair, value)
		aUF.db.profile.units[pair[1]].FrameStyle = value
		aUF:CallUnitMethods("ApplyTheme",true,pair[1],"type")
		aUF:CallUnitMethods("BorderBackground",nil,pair[1],"type")
		aUF:CallUnitMethods("UpdateAll",nil,pair[1],"type")
		for k,v in pairs(aUF.subgroups) do
			v:UpdateWidth()
		end
	end

	local function setUnitBorderStyle(pair, value)
		aUF.db.profile.units[pair[1]].BorderStyle = value
		aUF:CallUnitMethods("BorderBackground",nil,pair[1],"type")
	end

	local function setUnitWidth(pair, value)
		aUF.db.profile.units[pair[1]].Width = value
		aUF:CallUnitMethods("SetWidth",nil,pair[1],"type")
		for k,v in pairs(aUF.subgroups) do
			v:UpdateWidth()
		end
	end

	local function setUnitScale(pair, value)
		aUF.db.profile.units[pair[1]].Scale = value
		aUF:CallUnitMethods("LoadScale",nil,pair[1],"type")
		aUF:CallUnitMethods("LoadPosition",nil,pair[1],"type")
		for k,v in pairs(aUF.subgroups) do
			v:UpdateScale()
			v:LoadPosition()
		end
	end

	local function setUnitStatusBarOption(pair, value)
		aUF.db.profile.units[pair[1]][pair[2]] = value
		aUF:CallUnitMethods("StatusBarsColor",nil,pair[1],"type")
	end

	local function getUnitRaidColorNameOption(pair, value)
		aUF.db.profile.units[pair[1]].RaidColorName = value
		aUF:CallUnitMethods("UpdateTextStrings",nil,pair[1],"type")
	end

	local function setUnitRTIOption(pair, value)
		aUF.db.profile.units[pair[1]].ShowRaidTargetIcon = value
		aUF:CallUnitMethods("UpdateRaidTargetIcon",true,pair[1],"type")
	end

	local function setUnitCastBar(pair, value)
		aUF.db.profile.units[pair[1]].CastBar = value
		aUF:CallUnitMethods("ApplyTheme",nil,pair[1],"type")
		aUF:CallUnitMethods("UpdateAll",nil,pair[1],"type")
		if pair[1] == "player" then
			aUF.db.profile.BlizzCastbar = not value
			aUF:UpdateBlizzVisibility()
		end
	end

	local function setUnitThemeOption(pair, value)
		aUF.db.profile.units[pair[1]][pair[2]] = value
		aUF:CallUnitMethods("ApplyTheme",nil,pair[1],"type")
		aUF:CallUnitMethods("UpdateAll",nil,pair[1],"type")
	end

	local function setUnitHideFrame(pair, value)
		aUF.db.profile.units[pair[1]].HideFrame = value
		if value then
			aUF:CallUnitMethods("SetUnitWatch",true,pair[1],"type")
		else
			if pair[1] == "raid" then
				for k,v in pairs(aUF.db.profile.subgroups) do
					if v.Exists == true and not aUF.subgroups[k] then
						aUF:CreateSubgroup(k,"raid","Vanilla",aUF.db.profile.subgroups[k])
					end
				end
			end		
			aUF:CallUnitMethods("SetUnitWatch",false,pair[1],"type")
		end
		for k,v in pairs(aUF.subgroups) do
			v:SetVisibility()
		end
	end

	local function setUnitAuraPosition(pair, value)
		aUF.db.profile.units[pair[1]].AuraPos = value
		aUF:CallUnitMethods("UpdateAuras",true,pair[1],"type")
		aUF:CallUnitMethods("AuraPosition",true,pair[1],"type")
	end

	local function setUnitAuraOption(pair, value)
		aUF.db.profile.units[pair[1]][pair[2]] = value
		aUF:CallUnitMethods("SetAuraCount",nil,pair[1],"type")
		aUF:CallUnitMethods("AuraPosition",nil,pair[1],"type")
		aUF:CallUnitMethods("UpdateAuras",nil,pair[1],"type")
	end

	local function setUnitAuraDebuffColor(pair, value)
		aUF.db.profile.units[pair[1]].AuraDebuffC = value
		aUF:CallUnitMethods("UpdateAuras",true,pair[1],"type")
	end

	local function getUnitAuraFilter(class)
		return aUF.db.profile.units[class].AuraFilter == 1
	end

	local function setUnitAuraFilter(class, value)
		aUF.db.profile.units[class].AuraFilter = value and 1 or 0
		aUF:CallUnitMethods("UpdateAuras",true,class,"type")
	end

	local function setVisibilityOption(option, value)
		aUF.db.profile[option] = value
		for k,v in pairs(aUF.subgroups) do
			v:SetVisibility()
		end
	end

	local strings = {"HealthText","ManaText","NameLabel","ClassText"}
	local wStrings = {["HealthText"] = true,["ManaText"] = true}
	local validateOne = {"Absolute", "Difference", "Percent", "Smart","Custom", "Hide"}
	local validateTwo = {"Default","Custom", "Hide"}

	function aUF:CreateDewdrop(class,order,mainmenu)
		local prettyname = (L:HasTranslation(class) and L[class]) or class
		local stringArgs = {}

		for k,v in pairs(strings) do
			local validate
			if v == "HealthText" or v == "ManaText" then
				validate = validateOne
			else
				validate = validateTwo
			end
			stringArgs[v] = {
				name = string.format(L["%s Text"], L[v] or v),
				type = "group",
				desc = L["UnitDesc"],
				order = k,
				args = {
					StatusTextStyle = {
						name = L["Style"],
						type = "text",
						desc = L["StatusTextDesc"],
						get = getUnitOption,
						set = setUnitStringOption,
						passValue = { class, v .. "Style" },
						validate = validate,
						order = 1,
					},
					HealthCustom = {
						name = L["Custom"],
						type = "text",
						desc = L["StatusTextDesc"],
						get = getUnitOption,
						set = setUnitStringOption,
						passValue = { class, v .. "Format" },
						validate = validateWatchdog,
						usage = "",
						order = 2,
					}, 
					--[[ Width = {
						name = L["widthstring"],
						type = "range",
						desc = L["widthstringDesc"],
						min = 0,
						max = 400,
						step = 1,
						get = getUnitStringWidth,
						set = setUnitStringWidth,
						order = 3,
						passValue = { class, v .. "Width" },
						hidden = function() return not wStrings[v] end,
					}, ]]
				}
			}
		end

		local table = {
			name = prettyname,
			type = "group",
			desc = string.format(L["%s Settings"], prettyname),
			order = order,
			args = {
				UnitHeader = {
					name = string.format(L["layoutsettings"], prettyname),
					type = "header",
					order = 1,
				},
				FrameStyle = {
					name = L["framestyle"],
					type = "text",
					desc = L["FrameStyleDesc"],
					validate = aUF.indexLayouts,
					usage = "",
					get = getUnitOption,
					set = setUnitFrameStyle,
					passValue = { class, "FrameStyle" },
					order = 2,
				},
				BorderStyle = {
					name = L["borders"],
					type = "text",
					desc = L["BordersDesc"],
					validate = {"Classic", "Nurfed", "Hidden"},
					usage = "",
					get = getUnitOption,
					set = setUnitBorderStyle,
					passValue = { class, "BorderStyle" },
					order = 3,
				},
				Width = {
					name = L["widthadjust"],
					type = "range",
					desc = L["widthadjustDesc"],
					min = 50,
					max = 400,
					step = 1,
					get = getUnitOption,
					set = setUnitWidth,
					passValue = { class, "Width" },
					order = 5,
				},
				StatusTextStyle = {
					name = L["Status Text"],
					type = "group",
					desc = L["UnitDesc"],
					order = 5,
					args = stringArgs,
				},
				Scale = {
					name = L["scale"],
					type = "range",
					desc = L["ScaleDesc"],
					min = 0.5,
					max = 2,
					step = 0.05,
					isPercent = true,
					get = getUnitOption,
					set = setUnitScale,
					passValue = { class, "Scale" },
					order = 7,
				},
				ShowCombat = {
					name = L["showcombat"],
					type = "toggle",
					desc = L["ShowCombatDesc"],
					get = getUnitOption,
					set = setUnitOption,
					passValue = { class, "ShowCombat" },
					order = 23,
					hidden = function()
						if not (class == "player" or class == "pet" or class == "party"
							or class == "target" or class == "focus" or class == "raid"
							or class == "partypet" or class == "raidpet") then
							return true
						end
					end,
				},
				ShowInCombatIcon = {
					name = L["showincombat"],
					type = "toggle",
					desc = L["ShowInCombatDesc"],
					get = getUnitOption,
					set = setUnitOption,
					passValue = { class, "ShowInCombatIcon" },
					order = 24,
				},
				ShowRaidTargetIcon = {
					name = L["showraidicon"],
					type = "toggle",
					desc = L["ShowRaidIconDesc"],
					get = getUnitOption,
					set = setUnitRTIOption,
					passValue = { class, "ShowRaidTargetIcon" },
					order = 25,
				},
				LongStatusbars = {
					name = L["longbars"],
					type = "toggle",
					desc = L["LongBarsDesc"],
					get = getUnitOption,
					set = setUnitThemeOption,
					passValue = { class, "LongStatusbars" },
					order = 26,
				},
				EnableCast = {
					name = L["castbar"],
					type = "toggle",
					desc = L["castbarDesc"],
					get = getUnitOption,
					set = setUnitCastBar,
					passValue = { class, "CastBar" },
					order = 28,
				},
				HealthDeficit = {
					name = L["healthdeficit"],
					type = "toggle",
					desc = L["healthdeficitDesc"],
					get = getUnitOption,
					set = setUnitThemeOption,
					passValue = { class, "HealthDeficit" },
					order = 28.5,
				},
				HideMana = {
					name = L["hidemana"],
					type = "toggle",
					desc = L["HideManaDesc"],
					get = getUnitOption,
					set = setUnitThemeOption,
					passValue = { class, "HideMana" },
					order = 29,
				},
				ShowPortrait = {
					name = L["showportrait"],
					type = "toggle",
					desc = L["ShowPortraitDesc"],
					get = getUnitOption,
					set = setUnitThemeOption,
					passValue = { class, "Portrait" },
					order = 30,
				},
				HideFrame = {
					name = L["hideframe"],
					type = "toggle",
					desc = L["HideFrameDesc"],
					get = getUnitOption,
					set = setUnitHideFrame,
					passValue = { class, "HideFrame" },
					order = 33,
				},
				Spacing1 = {
					name = " ",
					type = "header",
					order = 35,
				},
				AuraHeader = {
					name = L["aurasettings"],
					type = "header",
					order = 39,
				},
				AuraPos = {
					name = L["aurapos"],
					type = "text",
					desc = L["AuraPosDesc"],
					get = getUnitOption,
					set = setUnitAuraPosition,
					validate = {"Topright", "Right", "Bottomright", "Topleft", "Left", "Bottomleft", "Above", "Below","Inside","Hidden"},
					passValue = { class, "AuraPos" },
					order = 41,
				},
				AuraRows = {
					name = L["aurarowsadjust"],
					type = "range",
					desc = L["aurarowsadjustDesc"],
					min = 1,
					max = 4,
					step = 1,
					get = getUnitOption,
					set = setUnitAuraOption,
					passValue = { class, "AuraRows" },
					order = 42,
				},
				AuraCols = {
					name = L["auracolsadjust"],
					type = "range",
					desc = L["auracolsadjustDesc"],
					min = 8,
					max = 24,
					step = 1,
					get = getUnitOption,
					set = setUnitAuraOption,
					passValue = { class, "AuraColumns" },
					order = 43,
				},
				DebuffColoring = {
					name = L["debuffcoloring"],
					type = "toggle",
					desc = L["DebuffColoringDesc"],
					get = getUnitOption,
					set = setUnitAuraDebuffColor,
					passValue = { class, "AuraDebuffC" },
					order = 44,
				},
				AuraFilter = {
					name = L["aurafilter"],
					type = "toggle",
					desc = L["AuraFilterDesc"],
					get = getUnitAuraFilter,
					set = setUnitAuraFilter,
					order = 45,
					passValue = class,
				},
				AuraPreferBuff = {
					name = L["Prioritize buffs"],
					type = "toggle",
					desc = L["Prioritize buffs above debuffs"],
					get = getUnitOption,
					set = setUnitOption,
					passValue = { class, "AuraPreferBuff" },
					order = 46
				},
				AuraCooldown = {
					name = L["Enable aura cooldown"],
					type = "toggle",
					desc = L["Shows a cooldown dial on auras."],
					get = getUnitOption,
					set = setUnitAuraOption,
					passValue = { class, "AuraCooldown" },
					order = 46
				},
				EndSpacing = {
					name = " ",
					type = "header",
					order = 1000,
					hidden = function() if (mainmenu) then return true end end
				},
			}
		}

		if class == "player" or class == "pet" then
			table.args.ShowXP = {
				name = L["showxp"],
				type = "toggle",
				desc = L["ShowXPDesc"],
				get = getUnitOption,
				set = setUnitThemeOption,
				order = 26,
				passValue = { class, "ShowXP" },
			}
		end

		if not class:find("pet$") then
			table.args.ClassColorBars = {
				name = L["classcolorbar"],
				type = "toggle",
				desc = L["ClassColorBarsDesc"],
				get = getUnitOption,
				set = setUnitStatusBarOption,
				order = 20,
				passValue = { class, "ClassColorBars" },
			}
			table.args.RaidColorName = {
				name = L["raidcolorname"],
				type = "toggle",
				desc = L["RaidColorNameDesc"],
				get = getUnitOption,
				set = getUnitRaidColorNameOption,
				order = 21,
				passValue = { class, "RaidColorName" },
			}
		end

		if class == "target" or class == "targettarget" or class == "targettargettarget" then
			table.args.TargetShowHostile = {
				name = L["targetshowhostile"],
				type = "toggle",
				desc = L["TargetHostileDesc"],
				get = getUnitOption,
				set = setUnitStatusBarOption,
				passValue = { class, "TargetShowHostile" },
				order = 22,
			}
		end

		if class == "party" then
			table.args.RaidHideParty = {
				name = L["raidhideparty"],
				type = "toggle",
				desc = L["RaidHidePartyDesc"],
				get = getOption,
				set = setVisibilityOption,
				passValue = "RaidHideParty",
				order = 32,
			}
		end

		if class == "pet" then
			table.args.PetGrouping = {
				name = L["petgrouping"],
				type = "text",
				desc = L["PetGroupingDesc"],
				get = function()
					return self.db.profile.PetGrouping
				end,
				set = function(option)
					self.db.profile.PetGrouping = option
					self:CallUnitMethods("UpdateAll")
				end,
				validate = {["withplayer"] = L["withplayer"], ["nogroup"] = L["nogroup"]},
				order = 6,
			}
		end

		if class == "raid" then
			table.args.SpacingRaid = {
				name = " ",
				type = "header",
				order = 100,
			}
			table.args.CreateGroup = {
				name = L["create"],
				type = "execute",
				desc = L["createDesc"],
				func = function()
					local k = self:CreateNewGroup()
					self.mainMenu.args.raid.args.Groups.args[k] = aUF:GroupCreateMenu(k)
				end,
				order = 105,
			}
			table.args.RaidSet = {
				name = L["Current Raidset"],
				type = "text",
				desc = L["Current RaidsetDesc"],
				get = getOption,
				set = setVisibilityOption,
				passValue = "CurrentRaidSet",
				order = 101,
				validate = {"1","2","3","4","5","6","7","8","9","10"},
			}
			local groups = aUF:CreateDewdropGrouplist()
			table.args.Groups = groups
		end

		if class == "party" or "partypet" then
			if class == "party" then
				table.args.PartyGrouping = aUF:GroupCreateMenu("party")
			elseif class == "partypet" then
				table.args.PartyGrouping = aUF:GroupCreateMenu("partypet")
			end
			if table.args.PartyGrouping then
				table.args.PartyGrouping.name = L["groupsettings"]
				table.args.PartyGrouping.desc = L["groupsettingsDesc"]
				table.args.PartyGrouping.order = 4
			end
		end

		if not mainmenu then
			table.args.UnitHeader.name = string.format(L["frame"], (L:HasTranslation(class) and L[class]) or class)
		end

		return table
	end
end

do
	local function getGroupOption(pair)
		return aUF.subgroups[pair[1]].database[pair[2]]
	end

	local function setGroupOption(pair, value)
		aUF.subgroups[pair[1]].database[pair[2]] = value
		aUF.subgroups[pair[1]]:UpdateGroupFilter()
		aUF.subgroups[pair[1]]:UpdateTitle()
	end

	local function setGroupGrowOption(pair, value)
		aUF.subgroups[pair[1]].database[pair[2]] = value
		aUF.subgroups[pair[1]]:UpdateGrowth()
	end

	local function setGroupAnchorOption(pair, value)
		aUF.subgroups[pair[1]].database[pair[2]] = value
		aUF.subgroups[pair[1]]:UpdateTitle()
	end

	local function setGroupName(pair, value)
		if value == "" then
			aUF.subgroups[pair[1]].database.Name = nil
		else
			aUF.subgroups[pair[1]].database.Name = value
		end
		aUF.subgroups[pair[1]]:UpdateTitle()
		aUF.mainMenu = aUF:CreateMenu()
		dewdrop:Refresh(3)
		dewdrop:Refresh(4)
	end
	
	local function getRaidSetOption(pair)
		local entry = pair[1]
		local var = pair[2]
		if (aUF.subgroups[entry].database.RaidSets and aUF.subgroups[entry].database.RaidSets[var]) or (not (aUF.subgroups[entry].database.RaidSets)) or (aUF.subgroups[entry].database.RaidSets and aUF.subgroups[entry].database.RaidSets[var] == nil) then
			return true
		else
			return false
		end
	end

	local function setRaidSetOption(pair, value)
		if not aUF.subgroups[pair[1]].database.RaidSets then
			aUF.subgroups[pair[1]].database.RaidSets = {}
		end
		aUF.subgroups[pair[1]].database.RaidSets[pair[2]] = value
		aUF.subgroups[pair[1]]:SetVisibility()
		aUF.subgroups[pair[1]]:UpdateTitle()
	end

	local growValidate = {["BOTTOM"] = L["up"], ["TOP"] = L["down"], ["RIGHT"] = L["left"], ["LEFT"] = L["right"]}
	local groupByValidate = {["NAME"] = L["Name"], ["INDEX"] = L["Index"],["GROUP"] = L["Subgroup"], ["CLASS"] = L["Class"]}

	function aUF:GroupCreateMenu(entry, order)
		if not entry then return end
		local entry = entry
		local menu = {
			name = (self.subgroups[entry] and
			self.subgroups[entry].database and
			self.subgroups[entry].database.Name) or entry,
			type = "group",
			desc = " ",
			hidden = function() if not (self.subgroups[entry]) or (self.subgroups[entry].database.Exists ~= true) then return true end end,		
			args = {
				UnitHeader = {
					name = paranthesisName or entry,
					type = "header",
					order = 1,
					hidden = function() if entry == "party" then return true end end
				},
				Name = {
					name = L["setname"],
					type = "text",
					desc = L["setnameDesc"],
					get = getGroupOption,
					usage = "<group name>",
					set = setGroupName,
					passValue = { entry, "Name" },
					order = 6,
					hidden = function() return party end
				},
				GroupFilter = {
					name = L["groupfilter"],
					type = "text",
					desc = L["groupfilterDesc"],
					get = getGroupOption,
					usage = "",
					set = setGroupOption,
					passValue = { entry, "groupFilter" },
					order = 7,
				},
				nameList = {
					name = L["playernames"],
					type = "text",
					desc = L["playernamesDesc"],
					get = getGroupOption,
					usage = "",
					set = setGroupOption,
					passValue = { entry, "nameList" },
					order = 8,
				},
				groupBy = {
					name = L["sortmethod"],
					type = "text",
					desc = L["sortmethodDesc"],
					get = getGroupOption,
					usage = "",
					set = setGroupOption,
					passValue = { entry, "groupBy" },
					validate = groupByValidate,
					order = 9,
				},
				Space = {
					name = " ",
					type = "header",
					order = 10,
				},
				Grow = {
					name = L["groupgrow"],
					type = "text",
					desc = L["groupgrowDesc"],
					get = getGroupOption,
					set = setGroupGrowOption,
					validate = growValidate,
					passValue = { entry, "Grow" },
					order = 20,
				},
				Padding = {
					name = L["padding"],
					type = "range",
					desc = L["paddingDesc"],
					min = 0,
					max = 100,
					step = 1,
					isPercent = false,
					get = getGroupOption,
					set = setGroupGrowOption,
					passValue = { entry, "Padding" },
					order = 22,
				},
				Space2 = {
					name = " ",
					type = "header",
					order = 24,
				},
				AnchorOffset = {
					name = L["anchordist"],
					type = "range",
					desc = L["anchordistDesc"],
					min = 0,
					max = 50,
					step = 1,
					isPercent = false,
					get = getGroupOption,
					set = setGroupGrowOption,
					passValue = { entry, "AnchorOffset" },
					order = 26,
				},
				ShowAnchor = {
					name = L["groupshowanchor"],
					type = "toggle",
					desc = L["groupshowanchorDesc"],
					get = getGroupOption,
					set = setGroupAnchorOption,
					passValue = { entry, "ShowAnchor" },
					order = 28,
				},
				Space3 = {
					name = " ",
					type = "header",
					order = 35,
					hidden = function() if self.subgroups[entry].type ~= "raid" then return true end end
				},
				Space4 = {
					name = " ",
					type = "header",
					order = 50,
					hidden = function() if self.subgroups[entry].type ~= "raid" then return true end end
				},
				Delete = {
					name = L["delete"],
					type = "execute",
					desc = L["deleteDesc"],
					func = function()
						self.subgroups[entry]:Delete()
						dewdrop:Refresh(3)
						dewdrop:Close(4)
					end,
					order = 51,
					hidden = function() if self.subgroups[entry].type ~= "raid" then return true end end
				},
			},
		}
		
		local RaidSets = {}
		for m = 1,10 do
			local var = tostring(m)
			RaidSets[var] = {
				name = string.format(L["Raidset %d"],var),
				type = "toggle",
				desc = string.format(L["RaidsetDesc %d"],var),
				get = getRaidSetOption,
				set = setRaidSetOption,
				passValue = { entry, var },
				order = m,
			}
		end
		menu.args.RaidSet = {
			name = L["Select Raidsets"],
			type = "group",
			desc = L["RaidSetDesc"],
			order = 36,
			args = RaidSets,
			hidden = function() if self.subgroups[entry].type ~= "raid" then return true end end
		}
		return menu
	end
end

function aUF:CreateDewdropGrouplist()
	local groupTable = {}
	for k,v in pairs(self.db.profile.subgroups) do
		if self.db.profile.subgroups[k].Exists == true then
			if k ~= "party" and k ~= "partypet" then
				groupTable[k] = aUF:GroupCreateMenu(k)
			end
		end
	end
	local menu = {
		name = L["groups"],
		type = "group",
		desc = L["groupsDesc"],
		args = groupTable,
		order = 102,
	}
	return menu
end

