local tag = "aquafusion arena points";
local version = "1.4.6.24";

--onEvent Routines----------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------------------
--[[
	Team Rating Arena Point Formulae

	X = Team Rating, Y = Arena Points

	If X<=1500:Y = 0.22 * X + 14
		OLD: Y = 0.38 * X - 194

	X > 1500 Y = 1511.26/(1+1639.28*exp(-0.00412*X))
	The penalties are 76% for 2v2 and 88% for 3v3
		OLD: If X>1500 Y = 1426.79/(1+918.836*Power(2.71828, -0.00386405*X))
		OLD: The penalties are 70% for 2v2 and 80% for 3v3
--]]

function afap_onload()
	--register events
		afap_overlay:RegisterEvent("PLAYER_ENTERING_WORLD");
		afap_overlay:RegisterEvent("ARENA_TEAM_UPDATE");
		afap_overlay:RegisterEvent("ARENA_TEAM_ROSTER_UPDATE");
--		afap_overlay:RegisterEvent("PLAYER_PVP_KILLS_CHANGED");
--		afap_overlay:RegisterEvent("PLAYER_PVP_RANK_CHANGED");
--		afap_overlay:RegisterEvent("HONOR_CURRENCY_UPDATE");

	--hide the default arena icon, label, points,a nd tooltip since we have our own to use ;)
		PVPFrameArenaPoints:Hide();
		PVPFrameArenaIcon:Hide();
		PVPFrameArenaLabel:Hide();
		PVPFrameArena:Hide();

--		PVPFrameHonorPoints:Hide();
--		PVPFrameHonorIcon:Hide();
--		PVPFrameHonorLabel:Hide();
--		PVPFrameHonor:Hide();

		afap_CalcButton:Hide();

		local factionGroup = UnitFactionGroup("player");
		if ( factionGroup ) then
			afap_overlay_HonorIcon:SetTexture("Interface\\TargetingFrame\\UI-PVP-"..factionGroup);
		end

	--give an initial update to our data
		afap_updateinfo();

		afap_CalcButton_normal:SetTexture("Interface\\AddOns\\af_arenapoints\\gui\\calculator");
		afap_CalcButton_pushed:SetTexture("Interface\\AddOns\\af_arenapoints\\gui\\calculator-push");
		afap_CalcButton_highlight:SetTexture(nil);

		afap_calculator:SetBackdropColor(0,0,0);

	--let the user know the addon loaded successfully
		DEFAULT_CHAT_FRAME:AddMessage("|cffffdd00[" .. tag .. "]:|r v" .. version .. " loaded.");
end

function afap_onevent(event)
	afap_updateinfo();
end

function afap_updateinfo()
	--honor
		--collect some data
--			hk, cp = GetPVPSessionStats();
--			points = GetHonorCurrency();
--			total = cp + points;

		--show the data

--			afap_overlay_HonorPoints:SetText("|cffffffffHONOR:  |r|cffffcc00"..points.."|r  +  |cff00ff00"..cp.."|r|cffffffff  =  |r|cff00ccff"..total.."|r");

	--arena
		--lets figure out how many points each of our three teams are getting us this week.
			arenaPoints1, size1, arenaValid1 = afap_getTeamPoints(1);
			arenaPoints2, size2, arenaValid2 = afap_getTeamPoints(2);
			arenaPoints3, size3, arenaValid3 = afap_getTeamPoints(3);

		--arrange the output of the explanation in order of 2v2 - 5v5
			--2v2 team
				if (size1 == 2) then
					v2Points = arenaPoints1;
					v2Valid = arenaValid1;
				elseif (size2 == 2) then
					v2Points = arenaPoints2;
					v2Valid = arenaValid2;
				elseif (size3 == 2) then
					v2Points = arenaPoints3;
					v2Valid = arenaValid3;
				else
					v2Valid = 0;
					v2Points = 0;
				end

			--3v3 team
				if (size1 == 3) then
					v3Points = arenaPoints1;
					v3Valid = arenaValid1;
				elseif (size2 == 3) then
					v3Points = arenaPoints2;
					v3Valid = arenaValid2;
				elseif (size3 == 3) then
					v3Points = arenaPoints3;
					v3Valid = arenaValid3;
				else
					v3Valid = 0;
					v3Points = 0;
				end

			--5v5 team
				if (size1 == 5) then
					v5Points = arenaPoints1;
					v5Valid = arenaValid1;
				elseif (size2 == 5) then
					v5Points = arenaPoints2;
					v5Valid = arenaValid2;
				elseif (size3 == 5) then
					v5Points = arenaPoints3;
					v5Valid = arenaValid3;
				else
					v5Valid = 0;
					v5Points = 0;
				end

		--now time to figure out which one earned us the most points, shall we?
			--which point is the highest?
			
			thePoints = 0;
			
			if (v5Valid == 0) then
				v5PointsText = ("|cffff0000"..v5Points.."|r");
			else
				if (v5Points <= v2Points and v2Valid == 1) then
					v5PointsText = ("|cffffffff"..v5Points.."|r");	
				elseif (v5Points <= v3Points and v3Valid == 1) then
					v5PointsText = ("|cffffffff"..v5Points.."|r");
				else
					thePoints = v5Points;
					v5PointsText = ("|cff00ff00"..v5Points.."|r");
				end
			end

			if (v3Valid == 0) then
				v3PointsText = ("|cffff0000"..v3Points.."|r");
			else
				if (v3Points <= v2Points and v2Valid == 1) then
					v3PointsText = ("|cffffffff"..v3Points.."|r");	
				elseif (v3Points <= v5Points and v5Valid == 1) then
					v3PointsText = ("|cffffffff"..v3Points.."|r");
				else
					thePoints = v3Points;
					v3PointsText = ("|cff00ff00"..v3Points.."|r");
				end
			end
			
			if (v2Valid == 0) then
				v2PointsText = ("|cffff0000"..v2Points.."|r");
			else
				if (v2Points <= v5Points and v5Valid == 1) then
					v2PointsText = ("|cffffffff"..v2Points.."|r");	
				elseif (v2Points <= v3Points and v3Valid == 1) then
					v2PointsText = ("|cffffffff"..v2Points.."|r");
				else
					thePoints = v2Points;
					v2PointsText = ("|cff00ff00"..v2Points.."|r");
				end
			end		

		--and if we add that to what we already own, we get the following total at the end of the week...
			arenaPointsTotal = thePoints + GetArenaCurrency();
	
		--so, how about we slap all of that on the pvp/honor page?
			--first the numbers that matter
				afap_overlay_AllPoints:SetText("|cffffffffARENA:|r  |cffffcc00"..GetArenaCurrency().."|r|cffffffff  +  |r|cff00ff00"..thePoints.."|r|cffffffff  =  |r|cff00ccff"..arenaPointsTotal.."|r");
			--and then a breakdown of where the numbers are coming from
				afap_overlay_Explain:SetText("|cff7777772v2:|r  "..v2PointsText.."|cff777777      3v3:|r  "..v3PointsText.."|cff777777      5v5:|r  "..v5PointsText);
					
		--And now that it's all filled in, lets align it!
			afap_setPlacement();
end

function afap_getTeamPoints(id)
	
	--extract the information
		teamName, teamSize, teamRating, weekPlayed, weekWins, seasonPlayed, seasonWins, playerPlayed, teamRank = GetArenaTeam(id);

	--did the team play at least 30% of the matches this week AND play at least 10 games?
		playedPercent = (playerPlayed / weekPlayed) * 100;
		if (weekPlayed < 10 or playedPercent < 30) then
			--nope, no points this week!
				arenaValid = 0;
		else	
				arenaValid = 1;
		end

		--player did in fact meet requirements to get points, let's figure out which algorithm is going to be used, shall we?
			if (teamRating < 1500) then
				teamPoints = (0.22 * teamRating) + 14;
			else
				teamPoints = 1511.26 / (1 + 1639.28 * 2.71828^(-0.00412 * teamRating));
			end

		--time to figure in that nasty team size penalty!
			if (teamSize == 2) then
				teamPoints = teamPoints * 0.76;
			elseif (teamSize == 3) then
				teamPoints = teamPoints * 0.88;
			end

		--and in the case of a negative number, lets floor the points to zero :)
			if (teamPoints < 0 ) then
				teamPoints = 0;
			end

	--phew, now we can send those points on over for the rest of this script to work with!
		return round(teamPoints,0), teamSize, arenaValid;
end

function afap_setPlacement()
	--get the width of the containing frame and our 3 lines
		frameWidth = PVPFrame:GetWidth();

--		honorwidth = afap_overlay_HonorPoints:GetWidth() + afap_overlay_HonorIcon:GetWidth();

		line1width = (afap_overlay_AllPoints:GetWidth() + afap_overlay_Icon:GetWidth());
		line2width = afap_overlay_Explain:GetWidth();


--		honorcenterPoint = ((frameWidth - honorwidth) / 2) - 7;
		centerPoint = ((frameWidth - line1width) / 2) - 10;

	--now lets move stuff!
		--where should the first line go?
			afap_overlay_Icon:SetPoint("topleft", "PVPFrame", "topleft", centerPoint, -133);
--			afap_overlay_HonorIcon:SetPoint("topleft", "PVPFrame", "topleft", honorcenterPoint, -40);

		--and we should nudge line 2 over so that it centers under line 1 including the icon
			afap_overlay_Explain:SetPoint("top", "afap_overlay_AllPoints", "bottom", -((afap_overlay_Icon:GetWidth()/2) + 1), -11)
end

function round(num, idp)
	local mult = 10^(idp or 0);
	return floor(num * mult + 0.5) / mult;
end

function afap_CalcButtonClick()
	--[[
		PlaySound("igCharacterInfoTab");
		if (afap_calculator:IsVisible()) then
			afap_calculator:Hide();
		else
			afap_calculator:Show();
		end
	--]]
end