﻿-- Author      : Apoco
-- Create Date : 3/14/2008 12:39:25 PM

local AXRS = LibStub("AceAddon-3.0"):GetAddon("aXRaidStatus")
AXRSConfig = AXRS:NewModule("aXRaidStatusConfig")

local L = LibStub("AceLocale-3.0"):GetLocale("aXRS", true)
local BC = LibStub("LibBabble-Class-3.0"):GetLookupTable()
local media = LibStub("LibSharedMedia-3.0", true)
local _healthName, _aliveName, _manaName, _zoneName, _offlineName = nil, nil, nil, nil, nil

local addon = AXRS
local configaddon = AXRSConfig

local function getOption(info)
	local key = info[#info]
	local db = addon.db.profile.settings[key]
	if string.find(key, "color") and key ~= "autocolortext" and key ~= "colorgradient" then
		return db.r, db.g, db.b, db.a
	end
	return db
end

local function setOption(info, value)
	local key = info[#info]
	addon.db.profile.settings[key] = value or nil
	if key == "docked" then
		addon:CreateDummyRaid()
	elseif key == "updatetime" then
		configaddon:ChangeUpdateRate()
	elseif key == "hidetitle" then
		addon:SetWidth()
		addon:UpdateAllPos()
		addon.db.profile.settings.titlecolor.a = 1
		if value then
			addon.db.profile.settings.titlecolor.a = 0
		end
		addon:UpdateTitleColor()
	elseif key == "scale" then
		addon:UpdateScale()
	elseif key == "width" or key == "barheight" then
		addon:SetWidth()
	end
end

local options
options = {
	type = "group",
	name = "aX RaidStatus",
	childGroups = "tree",
	args = {
		general = {
			type = "group",
			name = L["General"],
			desc = L["General_D"],
			childGroups = "tree",
			get = getOption,
			set = setOption,
			order = 1,
			args = {
				loaddpslst = {
					name = "",
					type = "header",
					order = -1,
					hidden = function()
						configaddon:UpdateDPSOptions()
						return true
					end,
				},
				generaltitle = {
					type = "header",
					name = L["General"],
					order = 1,
				},
				updatetime = {
					name = L["UpdateRate"], 
					type = "range",
					desc = L["UpdateRate_D"],
					min = 0.1, 
					max = 10,
					step = 0.1,
					order = 10,
				},
				forceupdate = {
					name = L["ForceUpdate"],
					type = "execute",
					desc = L["ForceUpdate_D"],
					func = function()
						addon:UpdateLocalLists(true)
						addon:AddAllBarsToQueue()
					end,
					disabled = function()
						if not UnitInRaid("player") then
							return true
						end
						return false
					end,
					order = 11,
				},
				groups = {
					name = L["Group"],
					type = "range",
					desc = L["Group_D"],
					min = 2,
					max = 8,
					step = 1,
					order = 12,
				},
				resetbutton = {
					name = L["Reset_DB"],
					type = "execute",
					desc = L["Reset_DB_D"],
					confirm = true,
					confirmText = L["Reset_DB_C"],
					func = function() configaddon:RestoreDefaultSettings() end,
					order = 13,
				},					
				docked = {
					name = L["Docked"],
					type = "toggle",
					desc = L["Docked_D"],
					disabled = function() return not IsAddOnLoaded("Dock") end,
					order = 20,
				},
				dummyraid = {
					name = L["DummyRaid"],
					type = "execute",
					desc = L["DummyRaid_D"],
					func = function()
						if not axrsdummyraid then
							axrsdummyraid = true
							addon:CreateDummyRaid()
						elseif axrsdummyraid then
							axrsdummyraid = false
							addon:LeaveRaid()
						end
					end,
					disabled = function()
						if addon.db.profile.settings.docked or axrsinraid then
							return true
						end
						return UnitInRaid("player")
					end,
					order = 21,
				},
				talentdetection = {
					name = L["TalentDetection"],
					type = "toggle",
					desc = L["TalentDetection_D"],
					order = 30,
				},
				tooltipupdate = {
					name = L["TooltipUpdate"],
					type = "toggle",
					desc = L["TooltipUpdate_D"],
					order = 40,
				},
				hidetitle = {
					name = L["HideTitle"],
					type = "toggle",
					desc = L["HideTitle_D"],
					order = 41,
				},
				lock = {
					name = L["Lock"], 
					type = "toggle",
					desc = L["Lock_D"],
					order = 50,
				},
				debug = {
					name = L["Debug"],
					type = "toggle",
					desc = L["Debug_D"],
					confirm = function()
						if addon.db.profile.settings.debug then
							return false
						elseif not addon.db.profile.settings.debug then
							return true
						end
					end,
					confirmText = L["Debug_C"],
					order = -1,
				},
			},
		},
		lists = {
			name = L["Lists"],
			type = "group",
			desc = L["Lists_D"],
			childGroups = "tab",
			order = 2,
			disabled = function() return not UnitInRaid("player") end,
			args = {
				header = {
					type = "header",
					name = L["Lists"],
					order = 0,
				},
				warn = {
					type = "description",
					name = L["Lists_W"]..
					"\r"..L["DPS"]..": "..BC["Hunter"]..", "..BC["Mage"]..", "..BC["Warlock"]..", "..BC["Rogue"]..
					"\r"..L["Healers"]..": "..BC["Priest"]..", "..BC["Shaman"]..", "..BC["Paladin"]..", "..BC["Druid"]..
					"\r"..L["Tank"]..": "..BC["Warrior"],
					order = 1,
				},
				dps = {
					name = L["DPS"],
					type = "group",
					desc = L["DPS_D"],
					order = 2,
					args = {
						hidden = {
							name = "",
							type = "header",
							order = -1,
							hidden = function()
								configaddon:UpdateHealOptions()
								configaddon:UpdateTankOptions()
								return true
							end,
						},
						input = {
							type = "input",
							name = L["Name"],
							desc = L["Name_D"],
							get = function() 
								return _dpslstName
							end,
							set = function(_, val)
								_dpslstName = val or nil
							end,
							validate = function(key, val)
								if addon.db.profile.dpslst[val] then
									_dpslstName = nil
									return L["Error"].." "..L["Error_Exists"]
								elseif val == nil or strlen(val) < 1 then
									_dpslstName = nil
									return L["Error"].." "..L["Error_Name"]
								elseif string.find(val, " ") then
									_dpslstName = nil
									return L["Error"].." "..L["Error_Space"]
								end
								return true
							end,
							order = 1,
						},
						confirm = {
							type = "execute",
							name = L["Add"],
							desc = L["Add_D"],
							func = function() 
								configaddon:AddDPSToGlobalList(_dpslstName)
								_dpslstName = nil 
							end,
							disabled = function()
								return _dpslstName == nil or strlen(_dpslstName) < 1 or addon.db.profile.dpslst[_dpslstName] or string.find(_dpslstName, " ")
							end,
							order = 2,
						},
						list = {
							type = "header",
							name = L["Current"],
							order = 10,
							hidden = function()
								configaddon:UpdateDPSOptions()
								return not next(addon.db.profile.dpslst)
							end,
						},
					},
				},
				heal = {
					name = L["Healing"],
					type = "group",
					desc = L["Healing_D"],
					order = 3,
					args = {
						input = {
							type = "input",
							name = L["Name"],
							desc = L["Name_D"],
							get = function() 
								return _heallstName
							end,
							set = function(_, val)
								_heallstName = val or nil
							end,
							validate = function(key, val)
								if addon.db.profile.heallst[val] then
									_heallstName = nil
									return L["Error"].." "..L["Error_Exists"]
								elseif val == nil or strlen(val) < 1 then
									_heallstName = nil
									return L["Error"].." "..L["Error_Name"]
								elseif string.find(val, " ") then
									_heallstName = nil
									return L["Error"].." "..L["Error_Space"]
								end
								return true
							end,
							order = 1,
						},
						confirm = {
							type = "execute",
							name = L["Add"],
							desc = L["Add_D"],
							func = function() 
								configaddon:AddHealToGlobalList(_heallstName)
								_heallstName = nil 
							end,
							disabled = function()
								return _heallstName == nil or strlen(_heallstName) < 1 or addon.db.profile.heallst[_heallstName] or string.find(_heallstName, " ")
							end,
							order = 2,
						},
						list = {
							type = "header",
							name = L["Current"],
							order = 10,
							hidden = function()
								configaddon:UpdateHealOptions()
								return not next(addon.db.profile.heallst)
							end,
						},
					},
				},
				tank = {
					name = L["Tank"],
					type = "group",
					desc = L["Tank_D"],
					order = 3,
					args = {
						input = {
							type = "input",
							name = L["Name"],
							desc = L["Name_D"],
							get = function() 
								return _tanklstName
							end,
							set = function(_, val)
								_tanklstName = val or nil
							end,
							validate = function(key, val)
								if addon.db.profile.tanklst[val] then
									_tanklstName = nil
									return L["Error"].." "..L["Error_Exists"]
								elseif val == nil or strlen(val) < 1 then
									_tanklstName = nil
									return L["Error"].." "..L["Error_Name"]
								elseif string.find(val, " ") then
									_tanklstName = nil
									return L["Error"].." "..L["Error_Space"]
								end
								return true
							end,
							order = 1,
						},
						confirm = {
							type = "execute",
							name = L["Add"],
							desc = L["Add_D"],
							func = function() 
								configaddon:AddTankToGlobalList(_tanklstName)
								_tanklstName = nil 
							end,
							disabled = function()
								return _tanklstName == nil or strlen(_tanklstName) < 1 or addon.db.profile.tanklst[_tanklstName] or string.find(_tanklstName, " ")
							end,
							order = 2,
						},
						list = {
							type = "header",
							name = L["Current"],
							order = 10,
							hidden = function()
								configaddon:UpdateTankOptions()
								return not next(addon.db.profile.tanklst)
							end,
						},
					},
				},	
			},
		},
		barsettings = {
			name = L["BarSettings"],
			type = "group",
			desc = L["BarSettings_D"],
			childGroups = "tab",
			order = 3,
			disabled = function() 
				if axrsdummyraid or addon.db.profile.settings.docked then
					return false
				end
				return not UnitInRaid("player")
			end,
			args = {
				header = {
					type = "header",
					name = L["BarSettings"],
					order = 1,
				},
				loadtextures = {
					name = "",
					type = "header",
					order = -1,
					hidden = function()
						configaddon:UpdateTextureSettings()
						return true
					end,
				},
				general = {
					name = L["GeneralBar"],
					type = "group",
					desc = L["GeneralBar_D"],
					childGroups = "tree",
					order = 4,
					get = getOption,
					set = setOption,
					args = {
						header = {
							type = "header",
							name = L["General"],
							order = 1,
						},
						scale = {
							name = L["Scale"],
							type = "range",
							desc = L["Scale_D"],
							min = 0.5,
							max = 1.5,
							step = 0.05,
							order = 2,
						},
						width = {
							name = L["Width"], 
							type = "range",
							desc = L["Width_D"],
							min = 70,
							max = 200,
							step = 5,
							order = 3,
						},
						barheight = {
							name = L["BarHeight"], 
							type = "range",
							desc = L["BarHeight_D"],
							min = 10,
							max = 20,
							step = 0.1,
							order = 4,
						},
					},
				},
				color = {
					name = L["Color"], 
					type = "group",
					desc = L["Color_D"],
					childGroups = "tree",
					order = 5,
					args = {
						header = {
							type = "header",
							name = L["ColorSettings"],
							order = 1,
						},
						general = {
							name = L["Color_General"], 
							type = "group",
							desc = L["Color_General_D"],
							inline = true,
							get = getOption,
							set = setOption,
							args = {
								titlecolor = {
									name = L["TColor"], 
									type = "color",
									desc = L["TColor_D"],
									set = function(...) addon:UpdateTitleColor(...) end,
									hasAlpha = true,
									disabled = function() return addon.db.profile.settings.hidetitle end,
									order = 2,
								},
								bordercolor = {
									name = L["BOColor"], 
									type = "color",
									desc = L["BOColor_D"],
									set = function(...) addon:UpdateBorderColor(...) end,
									hasAlpha = true,
									order = 3,
								},
								autocolortext = {
									name = L["ACT"],
									type = "toggle",
									desc = L["ACT_D"],
									order = 4,
								},
							},
							order = 2,
						},
						backgroundcolor = {
							name = L["Background"], 
							type = "group",
							desc = L["Background_D"],
							inline = true,
							get = getOption,
							set = setOption,
							args = {
								colorgradient = {
									name = L["Gradient"], 
									type = "toggle",
									desc = L["Gradient_D"],
									set = function(_, val) addon:SetColorGradient(val) end,
									order = 1,
								},
								backgroundcolor = {
									name = L["BGColor"], 
									type = "color",
									desc = L["BGColor_D"],
									set = function(...) addon:UpdateBackgroundColor(...) end,
									hasAlpha = true,
									order = 2,
								},
								colorgradientstart = {
									name = L["GradientStart"],
									type = "color",
									desc = L["GradientStart_D"],
									set = function(info, r, g, b, a)
										addon.db.profile.settings[info[#info]] = {
											["r"] = r, ["g"] = g, ["b"] = b, ["a"] = a,
										}
										addon:UpdateBackgroundGradient()
									end,
									hasAlpha = true,
									disabled = function() return not addon.db.profile.settings.colorgradient end,
									order = 3,
									width = "full",
								},
								colorgradientstop = {
									name = L["GradientStop"], 
									type = "color",
									desc = L["GradientStop_D"],
									set = function(info, r, g, b, a)
										addon.db.profile.settings[info[#info]] = {
											["r"] = r, ["g"] = g, ["b"] = b, ["a"] = a,
										}
										addon:UpdateBackgroundGradient()
									end,
									hasAlpha = true,
									disabled = function() return not addon.db.profile.settings.colorgradient end,
									order = 4,
									width = "full",
								},
							},
							order = 3,
						},
					},
				},
				texturetab = {
					type = "group",
					name = L["Textures"],
					desc = L["Textures_D"],
					args = {
						textures = {
							name = L["Textures1"], 
							type = "select",
							style = "dropdown",
							desc = L["Textures_D"],
							get = function() return addon.db.profile.settings.texture.name end,
							set = function(_, value)
								addon.db.profile.settings.texture.name = value
								addon.db.profile.settings.texture.path = media:Fetch('statusbar', value)
								addon:SetBarTexture(value)
							end,			
							values = function()
								local rlst = { }
								for i,v in ipairs(media:List('statusbar')) do
									if i <= 30 then
										rlst[v] = v
									end
								end
								return rlst
							end,
							order = 5,
						},
						texturespart2 = {
							name = L["Textures30"], 
							type = "select",
							style = "dropdown",
							desc = L["Textures_D"],
							get = function() return addon.db.profile.settings.texture.name end,
							set = function(_, value)
								addon.db.profile.settings.texture.name = value
								addon.db.profile.settings.texture.path = media:Fetch('statusbar', value)
								addon:SetBarTexture(value)
							end,			
							values = function()
								local rlst = { }
								for i,v in ipairs(media:List('statusbar')) do
									if i > 30 then
										rlst[v] = v
									end
								end
								return rlst
							end,
							order = 6,
						},
					},
				},
				new = {
					name = L["NewBar"], 
					type = "group",
					desc = L["NewBar_D"],
					childGroups = "tab",
					order = -1,
					args = {
						newbarheader = {
							type = "header",
							name = L["BarSettings"],
							order = 1,
						},
						raid = {
							name = L["Raid"], 
							type = "group",
							desc = L["Raid_D"],
							order = 1,
							args = {
								header = {
									type = "header",
									name = L["Raid_Header"],
									order = 0,
								},
								aliveName = {
									type = "input",
									name = L["Alive_Name"],
									desc = L["Alive_Name_D"],
									get = function() return _aliveName end,
									set = function(key, val) 
										_aliveName = val or nil 
									end,
									order = 1,
								},
								aliveBar = {
									type = "execute",
									name = L["Create"],
									desc = L["Create_D"],
									width = "half",
									func = function() 
										addon:CreateNewBar("statusbar", "raid", "alive", _aliveName)
										_aliveName = nil 
									end,
									disabled = function() return _aliveName == nil or strlen(_aliveName) < 1 end,
									order = 2,
								},
								healthName = {
									type = "input",
									name = L["Health_Name"],
									desc = L["Health_Name_D"],
									get = function() return _healthName end,
									set = function(key, val) 
										_healthName = val or nil 
									end,
									order = 3,
								},
								healthBar = {
									type = "execute",
									name = L["Create"],
									desc = L["Create_D"],
									width = "half",
									func = function() 
										addon:CreateNewBar("statusbar", "raid", "health", _healthName)
										_healthName = nil 
									end,
									disabled = function() return _healthName == nil or strlen(_healthName) < 1 end,
									order = 4,
								},
								manaName = {
									type = "input",
									name = L["Mana_Name"],
									desc = L["Mana_Name_D"],
									get = function() return _manaName end,
									set = function(key, val) 
										_manaName = val or nil 
									end,
									order = 5,
								},
								manaBar = {
									type = "execute",
									name = L["Create"],
									desc = L["Create_D"],
									width = "half",
									func = function() 
										addon:CreateNewBar("statusbar", "raid", "mana", _manaName)
										_manaName = nil 
									end,
									disabled = function() return _manaName == nil or strlen(_manaName) < 1 end,
									order = 6,
								},
								zoneName = {
									type = "input",
									name = L["Zone_Name"],
									desc = L["Zone_Name_D"],
									get = function() return _zoneName end,
									set = function(key, val) 
										_zoneName = val or nil 
									end,
									order = 7,
								},
								zoneBar = {
									type = "execute",
									name = L["Create"],
									desc = L["Create_D"],
									width = "half",
									func = function() 
										addon:CreateNewBar("statusbar", "raid", "zone", _zoneName)
										_zoneName = nil 
									end,
									disabled = function() return _zoneName == nil or strlen(_zoneName) < 1 end,
									order = 8,
								},
								offlineName = {
									type = "input",
									name = L["Offline_Name"],
									desc = L["Offline_Name_D"],
									get = function()  return _offlineName end,
									set = function(_, val) 
										_offlineName = val or nil 
									end,
									order = 9,
								},
								offlineBar = {
									type = "execute",
									name = L["Create"],
									desc = L["Create_D"],
									width = "half",
									func = function() 
										addon:CreateNewBar("statusbar", "raid", "offline", _offlineName)
										_offlineName = nil 
									end,
									disabled = function() return _offlineName == nil or strlen(_offlineName) < 1 end,
									order = 10,
								},
								pvpName = {
									type = "input",
									name = L["PVP_Name"],
									desc = L["PVP_Name_D"],
									get = function() return _pvpName end,
									set = function(_, val) 
										_pvpName = val or nil 
									end,
									order = 11,
								},
								pvpBar = {
									type = "execute",
									name = L["Create"],
									desc = L["Create_D"],
									width = "half",
									func = function() 
										addon:CreateNewBar("statusbar", "raid", "pvp", _pvpName)
										_pvpName = nil 
									end,
									disabled = function() return _pvpName == nil or strlen(_pvpName) < 1 end,
									order = 12,
								},
								spacer = {
									type = "execute",
									name = L["Spacer"],
									desc = L["Spacer_D"],
									width = "full",
									func = function() addon:CreateNewBar("spacer", nil, "blank") end,
									order = -1,
								},
							},
						},
						dps = {
							name = L["DPS"], 
							type = "group",
							desc = L["DPS_DB"],
							childGroups = "tab",
							order = 2,
							args = {
								header = {
									type = "header",
									name = L["DPS_H"],
									order = 0,
								},
								aliveName = {
									type = "input",
									name = L["Alive_Name"],
									desc = L["Alive_Name_D"],
									get = function() return _aliveName end,
									set = function(key, val) 
										_aliveName = val or nil 
									end,
									order = 1,
								},
								aliveBar = {
									type = "execute",
									name = L["Create"],
									desc = L["Create_D"],
									width = "half",
									func = function() 
										addon:CreateNewBar("statusbar", "dps", "alive", _aliveName)
										_aliveName = nil 
									end,
									disabled = function() return _aliveName == nil or strlen(_aliveName) < 1 end,
									order = 2,
								},
								healthName = {
									type = "input",
									name = L["Health_Name"],
									desc = L["Health_Name_D"],
									get = function()  return _healthName end,
									set = function(key, val) 
										_healthName = val or nil 
									end,
									order = 3,
								},
								healthBar = {
									type = "execute",
									name = L["Create"],
									desc = L["Create_D"],
									width = "half",
									func = function() 
										addon:CreateNewBar("statusbar", "dps", "health", _healthName)
										_healthName = nil 
									end,
									disabled = function()
										return _healthName == nil or strlen(_healthName) < 1
									end,
									order = 4,
								},
								manaName = {
									type = "input",
									name = L["Mana_Name"],
									desc = L["Mana_Name_D"],
									get = function() return _manaName end,
									set = function(key, val) 
										_manaName = val or nil 
									end,
									order = 5,
								},
								manaBar = {
									type = "execute",
									name = L["Create"],
									desc = L["Create_D"],
									width = "half",
									func = function() 
										addon:CreateNewBar("statusbar", "dps", "mana", _manaName)
										_manaName = nil 
									end,
									disabled = function() return _manaName == nil or strlen(_manaName) < 1 end,
									order = 6,
								},
								spacer = {
									type = "execute",
									name = L["Spacer"],
									desc = L["Spacer_D"],
									width = "full",
									func = function() addon:CreateNewBar("spacer", nil, "blank") end,
									order = -1,
								},
							},
						},
						healer = {
							name = L["Healer"], 
							type = "group",
							desc = L["Healer_D"],
							childGroups = "tab",
							order = 3,
							args = {
								header = {
									type = "header",
									name = L["Healer_H"],
									order = 0,
								},
								aliveName = {
									type = "input",
									name = L["Alive_Name"],
									desc = L["Alive_Name_D"],
									get = function() return _aliveName end,
									set = function(key, val) 
										_aliveName = val or nil 
									end,
									order = 1,
								},
								aliveBar = {
									type = "execute",
									name = L["Create"],
									desc = L["Create_D"],
									width = "half",
									func = function() 
										addon:CreateNewBar("statusbar", "heal", "alive", _aliveName)
										_aliveName = nil 
									end,
									disabled = function() return _aliveName == nil or strlen(_aliveName) < 1 end,
									order = 2,
								},
								healthName = {
									type = "input",
									name = L["Health_Name"],
									desc = L["Health_Name_D"],
									get = function() 
										return _healthName
									end,
									set = function(key, val) 
										_healthName = val or nil 
									end,
									order = 3,
								},
								healthBar = {
									type = "execute",
									name = L["Create"],
									desc = L["Create_D"],
									width = "half",
									func = function() 
										addon:CreateNewBar("statusbar", "heal", "health", _healthName)
										_healthName = nil 
									end,
									disabled = function() return _healthName == nil or strlen(_healthName) < 1 end,
									order = 4,
								},
								manaName = {
									type = "input",
									name = L["Mana_Name"],
									desc = L["Mana_Name_D"],
									get = function() return _manaName end,
									set = function(key, val) 
										_manaName = val or nil 
									end,
									order = 5,
								},
								manaBar = {
									type = "execute",
									name = L["Create"],
									desc = L["Create_D"],
									width = "half",
									func = function() 
										addon:CreateNewBar("statusbar", "heal", "mana", _manaName)
										_manaName = nil 
									end,
									disabled = function() return _manaName == nil or strlen(_manaName) < 1 end,
									order = 6,
								},
								spacer = {
									type = "execute",
									name = L["Spacer"],
									desc = L["Spacer_D"],
									width = "full",
									func = function() addon:CreateNewBar("spacer", nil, "blank") end,
									order = -1,
								},
							},
						},
						tank = {
							name = L["Tank"],
							type = "group",
							desc = L["Tank_DB"],
							childGroups = "tab",
							order = 4,
							args = {
								header = {
									type = "header",
									name = L["Tank_H"],
									order = 0,
								},
								aliveName = {
									type = "input",
									name = L["Alive_Name"],
									desc = L["Alive_Name_D"],
									get = function() 
										return _aliveName
									end,
									set = function(key, val)
										_aliveName = val or nil
									end,
									order = 1,
								},
								aliveBar = {
									type = "execute",
									name = L["Create"],
									desc = L["Create_D"],
									width = "half",
									func = function() 
										addon:CreateNewBar("statusbar", "tank", "alive", _aliveName)
										_aliveName = nil 
									end,
									disabled = function()
										return _aliveName == nil or strlen(_aliveName) < 1
									end,
									order = 2,
								},
								healthName = {
									type = "input",
									name = L["Health_Name"],
									desc = L["Health_Name_D"],
									get = function() 
										return _healthName
									end,
									set = function(key, val) 
										_healthName = val or nil 
									end,
									order = 3,
								},
								healthBar = {
									type = "execute",
									name = L["Create"],
									desc = L["Create_D"],
									width = "half",
									func = function() 
										addon:CreateNewBar("statusbar", "tank", "health", _healthName)
										_healthName = nil 
									end,
									disabled = function()
										return _healthName == nil or strlen(_healthName) < 1
									end,
									order = 4,
								},
								spacer = {
									type = "execute",
									name = L["Spacer"],
									desc = L["Spacer_D"],
									width = "full",
									func = function()
										addon:CreateNewBar("spacer", nil, "blank")
									end,
									order = -1,
								},
							},
						},
					},
				},
			},
		},
		fubar = {	-- jacked from Omen
			type = "group",
			name = L["FuBar Options"],
			desc = L["FuBar Options"],
			order = -1,
			disabled = function() return addon.IsFuBarMinimapAttached == nil end,
			args = {
				attachMinimap = {
					type = "toggle",
					name = L["Attach to Minimap"],
					desc = L["Attach to Minimap"],
					get = function(info)
						return addon:IsFuBarMinimapAttached()
					end,
					set = function(info, v)
						addon:ToggleFuBarMinimapAttached()
						addon.db.profile["FuBar.AttachMinimap"] = addon:IsFuBarMinimapAttached()
					end
				},
				hideIcon = {
					type = "toggle",
					name = L["Hide Minimap/FuBar Icon"],
					desc = L["Hide Minimap/FuBar Icon"],
					get = function(info) 
						return addon.db.profile["FuBar.HideMinimapButton"] 
					end,
					set = function(info, v)
						addon.db.profile["FuBar.HideMinimapButton"] = v
						if v then
							addon:Hide()
						else
							addon:Show()
						end
					end
				},
				showIcon = {
					type = "toggle",
					name = L["Show Icon"],
					desc = L["Show Icon"],
					get = function(info) return addon:IsFuBarIconShown() end,
					set = function(info, v) addon:ToggleFuBarIconShown() end
				},
				showText = {
					type = "toggle",
					name = L["Show Text"],
					desc = L["Show Text"],
					get = function(info) return addon:IsFuBarTextShown() end,
					set = function(info, v) addon:ToggleFuBarTextShown() end
				},
				position = {
					type = "select",
					name = L["Position"],
					desc = L["Position"],
					values = {LEFT = L["Left"], CENTER = L["Center"], RIGHT = L["Right"]},
					get = function() 
						return addon:GetPanel() and addon:GetPanel():GetPluginSide(addon) 
					end,
					set = function(info, val)
						if addon:GetPanel() then
							addon:GetPanel():SetPluginSide(addon, val)
						end
					end
				}
			}
		},
	}
}

function configaddon:OnInitialize()
	self.db = AXRS.db
	options.args.profile = LibStub("AceDBOptions-3.0"):GetOptionsTable(AXRS.db)
	LibStub("AceConfig-3.0"):RegisterOptionsTable("aX RaidStatus", options) 
end

		---- Global List ----
		---------------------
function configaddon:AddDPSToGlobalList(name, silent)
	self:RemoveTankFromGlobalList(name, silent)
	self:RemoveHealFromGlobalList(name, silent)
	self.db.profile.dpslst[name] = true
	if not silent then
		addon:print(L["RaidStatus"].." > "..string.format(L["Added_DPS"], name))
	end
	self:UpdateDPSOptions()
end

function configaddon:AddTankToGlobalList(name, silent)
	self:RemoveDPSFromGlobalList(name, silent)
	self:RemoveHealFromGlobalList(name, silent)
	self.db.profile.tanklst[name] = true
	if not silent then
		addon:print(L["RaidStatus"].." > "..string.format(L["Added_Tank"], name))
	end
	self:UpdateTankOptions()
end

function configaddon:AddHealToGlobalList(name, silent)
	self:RemoveDPSFromGlobalList(name, silent)
	self:RemoveTankFromGlobalList(name, silent)
	self.db.profile.heallst[name] = true
	if not silent then
		addon:print(L["RaidStatus"].." > "..string.format(L["Added_Healer"], name))
	end
	self:UpdateHealOptions()
end

function configaddon:RemoveDPSFromGlobalList(name, silent)
	if name == BC["Hunter"] or name == BC["Mage"] or name == BC["Warlock"] or name == BC["Rogue"] then return end
	
	if self.db.profile.dpslst[name] then
		if not silent then
			addon:print(L["RaidStatus"].." > "..L["Removing"].." "..string.format(L["From_DPS"], name))
		end
		self.db.profile.dpslst[name] = nil
		options.args.lists.args.dps.args[name] = nil
		addon:RemoveFromLocalList("dps", name)
		self:UpdateDPSOptions()
	end
end

function configaddon:RemoveHealFromGlobalList(name, silent)
	if name == BC["Priest"] or name == BC["Shaman"] or name == BC["Druid"] or name == BC["Paladin"] then return end
	
	if self.db.profile.heallst[name] then
		if not silent then
			addon:print(L["RaidStatus"].." > "..L["Removing"].." "..string.format(L["From_Healing"], name))
		end
		self.db.profile.heallst[name] = nil
		options.args.lists.args.heal.args[name] = nil
		addon:RemoveFromLocalList("heal", name)
		self:UpdateHealOptions()
	end
end

function configaddon:RemoveTankFromGlobalList(name, silent)
	if name == BC["Warrior"] then return end
	
	if self.db.profile.tanklst[name] then
		if not silent then
			addon:print(L["RaidStatus"].." > "..L["Removing"].." "..string.format(L["From_Tanking"], name))
		end
		self.db.profile.tanklst[name] = nil
		options.args.lists.args.tank.args[name] = nil
		addon:RemoveFromLocalList("tank", name)
		self:UpdateTankOptions()
	end
end

function configaddon:UpdateDPSOptions()
	local opt = options.args.lists.args.dps.args
	local db = self.db.profile.dpslst
	for k in pairs(db) do
		if not opt[k] and k ~= BC["Rogue"] and k ~= BC["Hunter"] and k ~= BC["Mage"] and k ~= BC["Warlock"] then
			opt[k] = {
				type = "execute",
				name = k,
				desc = L["Remove_DPS"],
				func = function()
					configaddon:RemoveDPSFromGlobalList(k)
				end,
--				passValue = k,
				order = 100,
			}
		end
	end
end

function configaddon:UpdateTankOptions()
	local opt = options.args.lists.args.tank.args
	local db = self.db.profile.tanklst
	for k in pairs(db) do
		if not opt[k] and k ~= BC["Warrior"] then
			opt[k] = {
				type = "execute",
				name = k,
				desc = L["Remove_Tanking"],
				func = function()
					configaddon:RemoveTankFromGlobalList(k)
				end,
--				passValue = k,
				order = 100,
			}
		end
	end
end

function configaddon:UpdateHealOptions()
	local opt = options.args.lists.args.heal.args
	local db = self.db.profile.heallst
	for k in pairs(db) do
		if not opt[k] and k ~= BC["Priest"] and k ~= BC["Shaman"] and k ~= BC["Druid"] and k ~= BC["Paladin"] then
			opt[k] = {
				type = "execute",
				name = k,
				desc = L["Remove_Healing"],
				func = function()
					configaddon:RemoveHealFromGlobalList(k)
				end,
				passValue = k,
				order = 100,
			}
		end
	end
end

function configaddon:UpdateTextureSettings()
	local opt = options.args.barsettings.args.texturetab.args

	local rlst = { }
	for i,v in ipairs(media:List('statusbar')) do
		rlst[v] = v
	end
	local db = rlst

	if not opt["texturegroup"] then
		opt["texturegroup"] = {
			type = "group",
			name = L["Textures"],
			inline = true,
			args = { },
		}
	end

	for k in pairs(db) do
		if not opt.texturegroup.args[k] then
			opt.texturegroup.args[k] = {
				type = "description",
				name = function()
					local name = k
					if k == addon.db.profile.settings.texture.name then
						name = name.."|cff00FF00("..L["CurrentTexture"]..")|r"
					end
					return name
				end,
				image = function()
					return media:Fetch("statusbar", k), 125, 12
				end,
			}
		end
	end
end

function configaddon:ChangeUpdateRate()
	addon:CancelAllTimers(addon)
	addon:ScheduleRepeatingTimer(addon.UpdateAllBars, addon.db.profile.settings.updatetime, addon)
	addon:ScheduleRepeatingTimer(addon.AlwaysUpdateQueue, addon.db.profile.settings.updatetime, addon)
end

function configaddon:RestoreDefaultSettings()
	self.db:ResetDB()
	if UnitName("player") == "Apoco" then
		if IsAddOnLoaded("!Swatter") then
			Swatter.Error:Hide()
			SwatterData.errors = {}
			Swatter.errorOrder = {}
		end
	end
	ReloadUI()
end