﻿-- Author      : Apoco
-- Create Date : 3/14/2008 12:39:25 PM
-- Credits: Big Credits goes to Nevcairiel author of Bartender for Ace3 metatable support

local AXRS = LibStub("AceAddon-3.0"):GetAddon("aXRaidStatus")
local BC = LibStub("LibBabble-Class-3.0"):GetLookupTable()
local media = LibStub("LibSharedMedia-3.0", true)
local L = LibStub("AceLocale-3.0"):GetLocale("aXRS", true)
-- need new updates for these libs
local dewdrop = LibStub("Dewdrop-2.0")

AXRS.Bars = { }
AXRS.Bars.prototype = setmetatable({}, {__index = AXRS.Bars})

function AXRS.Bars.prototype:new(...)
	local newInstance = setmetatable({}, {__index = AXRS.Bars.prototype})
	newInstance:init(...)
	return newInstance
end

function AXRS.Bars.prototype:init(pos, data, texture)
	self.pos = pos
	self.data = data
	self.texture = texture

	if not self.data.barcolor then
		self.data.barcolor = {}
		self.data.barcolor.r = 1
		self.data.barcolor.g = 1
		self.data.barcolor.b = 1
		self.data.barcolor.a = 1
	end
	if not self.data.textcolor then
		self.data.textcolor = {}
		self.data.textcolor.r = 1
		self.data.textcolor.g = 1
		self.data.textcolor.b = 1
		self.data.textcolor.a = 1
	end

	self:CreateBar()
	if self.data.status ~= "blank" then
		self:UpdateBar()
	end
end

function AXRS.Bars.prototype:CreateBar()
	local texture = media:Fetch("statusbar", AXRS.db.profile.settings.texture.name)
	self.statusbar = CreateFrame("StatusBar", nil, AXRS.frame, "TextStatusBar")
	self.statusbar:Hide()
	self.statusbar:SetWidth(self.width or 115)
	self.statusbar:SetHeight(AXRS.db.profile.settings.barheight)
	local height = -((self.pos-1) * (AXRS.db.profile.settings.barheight+1)) - 20

	if AXRS.db.profile.settings.hidetitle then
		height = -((self.pos-1) * (AXRS.db.profile.settings.barheight+1)) - 10
	end

	if self.data.status == "blank" then
		if not self.data.blankcolor then
			self.data.blankcolor = {}
			self.data.blankcolor.r = 1
			self.data.blankcolor.g = 1
			self.data.blankcolor.b = 1
			self.data.blankcolor.a = 1
		end
		self.line = CreateFrame("Frame", nil, self.statusbar)
		self.line:SetBackdrop{
			bgFile = "Interface\\AddOns\\aX_RaidStatus\\images\\WhiteLine.tga",
			edgeFile = nil,
			tile = nil,  
			tileSize = 0, 
			edgeSize = 0,
			insets = {left=0, right=0, top=0, bottom=0}
		}
		
		local color = self.data.blankcolor
		self.line:SetBackdropColor(color.r, color.g, color.b, color.a)
		self.line:SetWidth(115)
		self.line:SetHeight(1)
		self.line:SetPoint("LEFT", 0, 0)
		self.line:Show()
		
		self.statusbar:SetPoint("TOP", AXRS.frame, "TOP", 0, height)
	else
		self.statusbar:SetStatusBarTexture(texture)
		self.statusbar:SetMinMaxValues(0, 100)
		self.statusbar:SetValue(math.random(100))

		if self.data.backgroundBar then
			self.statusbar2 = CreateFrame("StatusBar", nil, AXRS.frame, "TextStatusBar")
			self.statusbar2:Hide()
			self.statusbar2:SetWidth(self.width or 115)
			self.statusbar2:SetHeight(15)
			self.statusbar2:SetStatusBarTexture(texture)
			self.statusbar2:SetScript("OnShow",function()
				this:SetMinMaxValues(0, 100)
				this:SetValue(100)
			end)
			self.statusbar2:SetPoint("TOP", AXRS.frame, "TOP", 0, height)
			self.statusbar:SetPoint("TOP", self.statusbar2, "TOP", 0, 0)
		else
			self.statusbar:SetPoint("TOP", AXRS.frame, "TOP", 0, height)
		end
		
		self.textleft = self.statusbar:CreateFontString("$parentTextLeft","ARTWORK","GameFontNormalSmall")
		local path = self.textleft:GetFont()
		self.textleft:SetFont(path, 11)
		if (strlen(self.data.name) > 14) then
			local name = strsub(self.data.name, 1, 13).."..."
			self.textleft:SetText(name)
		else
		   self.textleft:SetText(self.data.name)
		end
		self.textleft:SetPoint("LEFT", 0, 0)
		self.textleft:SetTextColor(1,1,1)
		self.textleft:Show()
		
		self.textright = self.statusbar:CreateFontString("$parentTextRight","ARTWORK","GameFontNormalSmall")
		local path = self.textright:GetFont()
		self.textright:SetFont(path, 11)
		self.textright:SetText("%")
		self.textright:SetPoint("RIGHT", 0, 0)
		self.textright:SetTextColor(1,1,1)
		self.textright:Show()
	end

	dewdrop:Register(self.statusbar, 'children', function(level, value) self:CreateDDMenu(level, value) end)

	self.statusbar:Show()
	if self.statusbar2 then
		self.statusbar2:Show()
	end
	if self.data.type ~= "spacer" then
		self.statusbar:SetScript("OnEnter", function(...)
			self.tooltip = true
			GameTooltip:ClearAllPoints()
			self:TooltipInfo()
		end)
		self.statusbar:SetScript("OnLeave", function()
			self.tooltip = false
			GameTooltip:Hide()
			GameTooltip:ClearAllPoints()
		end)
	end
end

function AXRS.Bars.prototype:TooltipInfo()
	local point, relativePoint = AXRS:GetTooltipPoints()
	local t = { }
	local textright, textleft
	local dead, offline, cur, max, same, other = 0, 0, 0, 0, 0, 0

	for name in pairs(AXRS:GetRealTable(self.data.unit)) do
		table.insert(t, name)
	end
	table.sort(t, function(a, b) return a < b end)
	GameTooltip:ClearAllPoints()
	GameTooltip:SetOwner(self.statusbar, "ANCHOR_NONE", 0, 0)
	GameTooltip:SetPoint(point, self.statusbar, relativePoint)
	
	if self.data.status == "health" then
		GameTooltip:AddLine(L["Status_Health"])
		for _, name in ipairs(t) do
			local hp = floor(UnitHealth(name) / UnitHealthMax(name) * 100)
			local color = AXRS:GetColor(hp)
			textright = color..""..hp.."%|r"
			
			if UnitIsDeadOrGhost(name) then
				textright = "|cffff0000"..DEAD.."|r"
			elseif not UnitIsConnected(name) then
				textright = "|cff554455"..L["Offline"].."|r"
			else
				if UnitIsAFK(name) then
					textright = textright.."|cffFFEE55("..L["AFK"]..")|r"
				end
				cur = cur + UnitHealth(name)
				max = max + UnitHealthMax(name)
			end
			textleft = "|cff"..AXRS:GetHexColor(select(2, UnitClass(name)))..""..UnitName(name).."|r"
			GameTooltip:AddDoubleLine(textleft, textright)
		end
		GameTooltip:AddDoubleLine("-----", "-----")
		local hp = floor(cur / max * 100)
		local color = AXRS:GetColor(hp)
		textright = color..""..hp.."%|r"
		GameTooltip:AddDoubleLine(L["Overall:"], textright)
	
	elseif self.data.status == "mana" then
		GameTooltip:AddLine(L["Status_Mana"])
		for _, name in ipairs(t) do
			if UnitPowerType(name) == 0 and (UnitClass(name) ~= BC["Warrior"] and UnitClass(name) ~= BC["Rogue"]) then
				local mp = floor(UnitMana(name) / UnitManaMax(name) * 100)
				local color = AXRS:GetColor(mp)
				textright = color..""..mp.."%|r"

				if not UnitIsConnected(name) then
					textright = "|cff554455"..L["Offline"].."|r"
				else
					if UnitIsAFK(name) then
						textright = textright.."|cffFFEE55("..L["AFK"]..")|r"
					end
					cur = cur + UnitMana(name)
					max = max + UnitManaMax(name)
				end

				textleft = "|cff"..AXRS:GetHexColor(select(2, UnitClass(name)))..""..UnitName(name).."|r"
				GameTooltip:AddDoubleLine(textleft, textright)
			end
		end
		GameTooltip:AddDoubleLine("-----", "-----")
		local mp = floor(cur / max * 100)
		local color = AXRS:GetColor(mp)
		textright = color..""..mp.."%|r"
		GameTooltip:AddDoubleLine(L["Overall:"], textright)
	
	elseif self.data.status == "zone" then
		GameTooltip:AddLine(L["Status_Zone"])
		local myzone = GetRealZoneText()
		for _, name in ipairs(t) do
			for i=1, GetNumRaidMembers() do
				local rname, _, _, _, _, _, zone, _, _, _, _ = GetRaidRosterInfo(i)
				rname = UnitName(rname)
				if name == rname then
					if zone == myzone then
						same = same + 1
						textright = "|cff00ff00"..L["Same"].."|r"
					else
						other = other + 1
						textright = "|cffff0000"..zone.."|r"
					end
					if not UnitIsConnected(rname) then
						textright = "|cff554455"..L["Offline"].."|r"
					end
					if UnitIsAFK(name) then
						textright = textright.."|cffFFEE55("..L["AFK"]..")|r"
					end

					textleft = "|cff"..AXRS:GetHexColor(select(2, UnitClass(name)))..""..UnitName(name).."|r"
					GameTooltip:AddDoubleLine(textleft, textright)
				end
			end
		end
		GameTooltip:AddDoubleLine("-----", "-----")
		GameTooltip:AddDoubleLine(L["Same"], L["Other"])
		GameTooltip:AddDoubleLine(same, other)
	
	elseif self.data.status == "alive" then
		GameTooltip:AddLine(L["Status_Alive"])
		for _, name in ipairs(t) do
			textright = "|cff00ff00"..L["Alive"].."|r"
			if UnitIsDeadOrGhost(name) then
				dead = dead + 1
				textright = "|cffff0000"..DEAD.."|r"
			elseif not UnitIsConnected(name) then
				textright = "|cff554455"..L["Offline"].."|r"
				offline = offline + 1
			end
			if UnitIsAFK(name) then
				textright = textright.."|cffFFEE55("..L["AFK"]..")|r"
			end
			textleft = "|cff"..AXRS:GetHexColor(select(2, UnitClass(name)))..""..UnitName(name).."|r"
			GameTooltip:AddDoubleLine(textleft, textright)
		end
		GameTooltip:AddDoubleLine("-----", "-----")
		GameTooltip:AddDoubleLine(DEAD, L["Offline"])
		GameTooltip:AddDoubleLine(dead, offline)
	
	elseif self.data.status == "pvp" then
		GameTooltip:AddLine(L["Status_PVP"])
		for _, name in ipairs(t) do
			textright = "|cff00ff00"..L["PVP"].."|r"
			if not UnitIsPVP(name) then
				textright = "|cffff0000"..L["Unflagged"].."|r"
				cur = cur + 1
			end
			max = max + 1
			if UnitIsAFK(name) then
				textright = textright.."|cffFFEE55("..L["AFK"]..")|r"
			end
			textleft = "|cff"..AXRS:GetHexColor(select(2, UnitClass(name)))..""..UnitName(name).."|r"
			GameTooltip:AddDoubleLine(textleft, textright)
		end
		GameTooltip:AddDoubleLine("-----", "------")
		GameTooltip:AddDoubleLine(L["Flagged"], L["Unflagged"])
		max = max - cur
		GameTooltip:AddDoubleLine(cur, max)
	
	elseif self.data.status == "offline" then
		GameTooltip:AddLine(L["Status_Offline"])
		for _, name in ipairs(t) do
			textright = "|cff00ff00"..L["Online"].."|r"
			if not UnitIsConnected(name) then
				textright = "|cffff0000"..L["Offline"].."|r"
				cur = cur + 1
			end
			max = max + 1
			if UnitIsAFK(name) then
				textright = textright.."|cffFFEE55("..L["AFK"]..")|r"
			end
			textleft = "|cff"..AXRS:GetHexColor(select(2, UnitClass(name)))..""..UnitName(name).."|r"
			GameTooltip:AddDoubleLine(textleft, textright)
		end
		GameTooltip:AddDoubleLine("-----", "------")
		GameTooltip:AddDoubleLine(L["Online"], L["Offline"])
		online = max - cur
		GameTooltip:AddDoubleLine(online, cur)
	end
	GameTooltip:Show()
end

function AXRS.Bars.prototype:UpdateBar()
	local percent, aliveCount, pvpCount, raidCount, curZone, offlineCount = 0, 0, 0, 0, 0, 0
	
	if axrsinraid then
		if self.data.status == "health" then 
			percent = self:GetLife()

		elseif self.data.status == "mana" then
			percent = self:GetMana()
			
		elseif self.data.status == "alive" then
			percent, aliveCount, raidCount = self:GetAlive()
		
		elseif self.data.status == "zone" then
			percent, curZone, raidCount = self:GetZone()
			
		elseif self.data.status == "offline" then
			percent, offlineCount, raidCount = self:GetOffline()
		
		elseif self.data.status == "pvp" then
			percent, pvpCount, raidCount = self:GetPVP()
		end
	elseif not axrsinraid then
		percent, aliveCount, raidCount, curZone, offlineCount, pvpCount = math.random(100), math.random(15), math.random(16,25), math.random(15), math.random(15), math.random(15)
	end
		

	if self.data.useBarColor then
		if self.statusbar then
			self.statusbar:SetStatusBarColor(self.data.barcolor.r, self.data.barcolor.g, self.data.barcolor.b, self.data.barcolor.a)
		end
		if self.statusbar2 then
			self.statusbar2:SetStatusBarColor(self.data.barcolor.r, self.data.barcolor.g, self.data.barcolor.b, 0.2)
		end

	elseif self.data.status == "life" then
		self:SetSmoothBarColor(percent)
	
	elseif self.data.status == "mana" then
		if self.statusbar then
			self.statusbar:SetStatusBarColor(48/255, 113/255, 191/255, 1)
		end
		if self.statusbar2 then
			self.statusbar2:SetStatusBarColor(48/255, 113/255, 191/255, 0.3)
		end
		
	elseif self.data.status == "alive" then
		self:SetSmoothBarColor(percent)
		
	elseif self.data.status == "offline" then
		if self.statusbar then
			self.statusbar:SetStatusBarColor(1, 0, 0, 1)
		end
		if self.statusbar2 then
			self.statusbar2:SetStatusBarColor(1, 0, 0, 0.3)
		end
		
	elseif self.data.status == "pvp" then
		if self.statusbar then
			self.statusbar:SetStatusBarColor(1, 1, 0, 1)
		end
		if self.statusbar2 then
			self.statusbar2:SetStatusBarColor(1, 1, 0, 0.3)
		end
	end

	if self.textleft then 
		self.textleft:SetTextColor(1, 1, 1, 1)
		if self.data.useTextColor then
			self.textleft:SetTextColor(self.data.textcolor.r, self.data.textcolor.g, self.data.textcolor.b, self.data.textcolor.a)
		end
	end

	if self.textright then
		self.textright:SetTextColor(1, 1, 1, 1)

		if AXRS.db.profile.settings.autocolortext then
			if percent > 80 then
				self.textright:SetTextColor(0, 1, 0)
	
			elseif percent <= 80 and percent > 60 then
				self.textright:SetTextColor(1, .5, 0)
	
			elseif percent <= 60 and percent > 20 then
				self.textright:SetTextColor(1, 1, 0)
	
			elseif percent <= 20 then
				self.textright:SetTextColor(1, 0, 0)
			end
		end
	
		if self.data.status == "alive" then
			self.textright:SetText(aliveCount.."/"..raidCount)

		elseif self.data.status == "offline" then
			self.textright:SetText(offlineCount.."/"..raidCount)
		
		elseif self.data.status == "zone" then
			self.textright:SetText(curZone.."/"..raidCount)
	
		elseif self.data.status == "pvp" then
			self.textright:SetText(pvpCount.."/"..raidCount)
		else
			self.textright:SetText(percent.."%")
		end
	end

	if self.statusbar then
		self.statusbar:SetValue(percent)
	end
	if AXRS.db.profile.settings.tooltipupdate and self.data.type ~= "spacer" and self.tooltip then
		self:TooltipInfo()
	end
end

function AXRS.Bars.prototype:GetZone()
	if not UnitAffectingCombat("player") then
		local same, other, num = 0, 0, 0
		local type = AXRS:GetRealTable(self.data.unit)
		for i=1, GetNumRaidMembers() do
			local name, _, subgroup, _, _, _, zone, _, _, _, _ = GetRaidRosterInfo(i)
			if type[name] then
				if zone == GetRealZoneText() then
					same = same + 1
				end
				num = num + 1
			end
		end
		local perc = ((same / num) * 100)
		if perc >= 0 then
			return perc, same, num	
		end
	end
	return 0, 0, 0
end

function AXRS.Bars.prototype:GetLife()
	local cur, max = 0, 0
	for name in pairs(AXRS:GetRealTable(self.data.unit)) do
		local class = UnitClass(name)
		if not UnitIsDeadOrGhost(name) and UnitIsConnected(name) then
			cur = cur + UnitHealth(name)
		end
		max = max + UnitHealthMax(name)
	end
	local perc = floor((cur / max) * 100)
	if perc >= 0 then
		return perc
	end
	return 0
end

function AXRS.Bars.prototype:GetMana()
	local cur, max = 0, 0
	for name in pairs(AXRS:GetRealTable(self.data.unit)) do
		local class = UnitClass(name)
		if class ~= BC["Rogue"] and class ~= BC["Warrior"] and UnitPowerType(name) == 0 then
			if not UnitIsDeadOrGhost(name) and UnitIsConnected(name) then
				cur = cur + UnitMana(name)
			end
			max = max + UnitManaMax(name)
		end
	end
	local perc = floor((cur / max) * 100)
	if perc >= 0 then
		return perc
	end
	return 0
end

function AXRS.Bars.prototype:GetAlive()
	local cur, max = 0, 0
	for name in pairs(AXRS:GetRealTable(self.data.unit)) do
		if UnitIsDeadOrGhost(name) then
			cur = cur + 1
		end
		max = max + 1
	end
	local alive = max - cur
	local perc = floor((alive / max) * 100)
	if perc >= 0 then
		return perc, alive, max
	end
	return 0, 0, 0
end

function AXRS.Bars.prototype:GetOffline()
	if not UnitAffectingCombat("player") then
		local cur, max = 0, 0
		for name in pairs(AXRS:GetRealTable(self.data.unit)) do
			if not UnitIsConnected(name) then
				cur = cur + 1
			end
			max = max + 1
		end
		local perc = floor((cur / max) * 100)
		if perc >= 0 then
			return perc, cur, max
		end
	end
	return 0, 0, 0
end

function AXRS.Bars.prototype:GetPVP()
	local cur, max = 0, 0
	for name in pairs(AXRS:GetRealTable(self.data.unit)) do
		if UnitIsPVP(name) then
			cur = cur + 1
		end
		max = max + 1
	end
	local perc = floor((cur / max) * 100)
	if perc >= 0 then
		return perc, cur, max
	end
	return 0, 0, 0
end

function AXRS.Bars.prototype:SetSmoothBarColor(percentage)
	if percentage > 1 then 
		percentage = percentage / 100
	end

	local red = 2 * (1 - percentage)
	local green = 1

	if percentage < 0.5 then
		red = 1
		green = 2 * percentage
	end

	if red >= 0 and green >= 0 and red <= 1 and green <= 1 then
		if self.statusbar then
			self.statusbar:SetStatusBarColor(red, green, 0, 1)
		end
		if self.data.backgroundBar then
		  self.statusbar2:SetStatusBarColor(red, green, 0, 0.3)
		end
	end
end

function AXRS.Bars.prototype:CreateDDMenu(level, value)
	if level == 1 then
		dewdrop:AddLine( 'text', self.data.name, 'isTitle', true )
		dewdrop:AddLine(
			'text', L["Name"],
			'hasArrow', true,
			'hasEditBox', true,
			'editBoxText', self.data.name,
			'editBoxFunc', function(text)
				self.data.name = text
				if (strlen(self.data.name) > 14) then
					local name = strsub(self.data.name, 1, 13).."..."
					self.textleft:SetText(name)
				else
					self.textleft:SetText(self.data.name)
				end
			end,
			'tooltipTitle', L["Name"],
			'tooltipText', L["Name_DTT"]
		)
		if self.data.status == "blank" then
			dewdrop:AddLine(
				'text', L["Color"],
				'hasColorSwatch', true,
				'hasOpacity', true,
				'colorFunc', function(r, g, b, a)
					self:SetBlankColor(r, g, b, a)
				end,
				'r', self.data.blankcolor.r,
				'g', self.data.blankcolor.g,
				'b', self.data.blankcolor.b,
				'hasOpacity', true,
				'opacity', self.data.blankcolor.a
			)
		else
			dewdrop:AddLine( 'text', L["Unit"],
							 'hasArrow', true,
							 'value', "unit",
							 'tooltipTitle', L["Unit"],
							 'tooltipText', L["Unit_D"]
							)
			dewdrop:AddLine( 'text', L["Status"],
							 'hasArrow', true,
							 'value', "status",
							 'tooltipTitle', L["Status"],
							 'tooltipText', L["Status_D"]
							)
			dewdrop:AddLine( 'text', L["Color"],
							 'hasArrow', true,
							 'value', "color",
							 'tooltipTitle', L["Color"],
							 'tooltipText', L["Color_D"]
							)
			dewdrop:AddLine()
			dewdrop:AddLine( 'text', L["BackgroundBar"],
							 'checked', self.data.backgroundBar,
							 'func', function() 
								self.data.backgroundBar = not self.data.backgroundBar
								self:RemoveBar()
								self:CreateBar()
								self:UpdateBar()
							 end,
							 'tooltipTitle', L["BackgroundBar"],
							 'tooltipText', L["BackgroundBar_D"]
						  )
		end
		dewdrop:AddLine()
		dewdrop:AddLine( 'text', L["Bar_Up"],
						 'func', function()
							AXRS:BarUp(self)
						 end,
						 'tooltipTitle', L["Bar_Up"],
						 'tooltipText', L["Bar_Up_D"]
					  )
		dewdrop:AddLine( 'text', L["Bar_Down"],
						 'func', function()
							AXRS:BarDown(self)
						 end,
						 'tooltipTitle', L["Bar_Down"],
						 'tooltipText', L["Bar_Down_D"]
					  )
		dewdrop:AddLine()
		dewdrop:AddLine( 'text', L["Delete_Bar"],
						 'func', function()
							self:DeleteBar()
							dewdrop:Close()
						 end,
						 'tooltipTitle', L["Delete_Bar"],
						 'tooltipText', L["Delete_Bar_D"]
					  )
	elseif level == 2 then
		if value == "unit" then
			local isChecked
			isChecked = self:IsUnit("raid")
			dewdrop:AddLine( 'text', L["Raid"],
							 'checked', isChecked,
							 'func', function() self:AddRemoveUnit("raid") end)
			isChecked = self:IsUnit("dps")
			dewdrop:AddLine( 'text', L["DPS"],
							 'checked', isChecked,
							 'func', function() self:AddRemoveUnit("dps") end)
			isChecked = self:IsUnit("heal")
			dewdrop:AddLine( 'text', L["Healer"],
							 'checked', isChecked,
							 'func', function() self:AddRemoveUnit("heal") end)
			isChecked = self:IsUnit("Tank")
			dewdrop:AddLine( 'text', L["Tank"],
							 'checked', isChecked,
							 'func', function() self:AddRemoveUnit("tank") end)
		elseif value == "status" then
			local isChecked
			isChecked = self:IsStatus("health")
			dewdrop:AddLine( 'text', L["Health"],
							 'checked', isChecked,
							 'func', function() self:AddRemoveStatus("health") end)
			if not self:IsUnit("tank") then
				isChecked = self:IsStatus("mana")
				dewdrop:AddLine( 'text', L["Mana"],
								 'checked', isChecked,
								 'func', function() self:AddRemoveStatus("mana") end)
			end
			isChecked = self:IsStatus("alive")
			dewdrop:AddLine( 'text', L["Alive"],
							 'checked', isChecked,
							 'func', function() self:AddRemoveStatus("alive") end)
			isChecked = self:IsStatus("zone")
			dewdrop:AddLine( 'text', L["Zone"],
							 'checked', isChecked,
							 'func', function() self:AddRemoveStatus("zone") end)
			isChecked = self:IsStatus("pvp")
			dewdrop:AddLine( 'text', L["PVP"],
							 'checked', isChecked,
							 'func', function() self:AddRemoveStatus("pvp") end)
			isChecked = self:IsStatus("offline")
			dewdrop:AddLine( 'text', L["Offline"],
							 'checked', isChecked,
							 'func', function() self:AddRemoveStatus("offline") end)
	   elseif value == "color" then
		   dewdrop:AddLine( 'text', L["Custom_Bar_Color"],
							 'checked', self.data.useBarColor,
							 'func', function() 
								self.data.useBarColor = not self.data.useBarColor
								dewdrop:Refresh(2)
								self:UpdateBar()
							  end)
			if self.data.useBarColor then 
				dewdrop:AddLine(
					'text', L["Bar_Color"],
					'hasColorSwatch', true,
					'hasOpacity', true,
					'colorFunc', function(r, g, b, a)
						self:SetBarColor(r, g, b, a)
					end,
					'r', self.data.barcolor.r,
					'g', self.data.barcolor.g,
					'b', self.data.barcolor.b,
					'hasOpacity', true,
					'opacity', self.data.barcolor.a
				)
			end
			dewdrop:AddLine( 'text', L["Custom_Text_Color"],
							 'checked', self.data.useTextColor,
							 'func', function() 
								self.data.useTextColor = not self.data.useTextColor
								dewdrop:Refresh(2)
								self:UpdateBar()
							  end)
			if self.data.useTextColor then
				dewdrop:AddLine(
					'text', L["Text_Color"],
					'hasColorSwatch', true,
					'hasOpacity', true,
					'colorFunc', function(r, g, b, a)
						self:SetTextColor(r, g, b, a)
					end,
					'r', self.data.textcolor.r,
					'g', self.data.textcolor.g,
					'b', self.data.textcolor.b,
					'hasOpacity', true,
					'opacity', self.data.textcolor.a
				)
			end
	   end
	end
end

function AXRS.Bars.prototype:RemoveBar()
	local registered = dewdrop:IsRegistered(self.statusbar)
	if registered then 
		dewdrop:Unregister(self.statusbar) 
	end
	self.statusbar:Hide()
	if self.statusbar2 then
		self.statusbar2:Hide()
		self.statusbar2 = nil
	end

	if self.tooltip then
		self.tooltip:Remove()
		self.tooltip = nil
	end

	if self.line then
		self.line:Hide()
		self.line = nil
	end

	if self.textleft then
		self.textleft:Hide()
		self.textright:Hide()
		self.textleft = nil
		self.textright = nil
	end

	self.statusbar = nil
end

function AXRS.Bars.prototype:IsUnit(unit)
	if not self.data.unit or not unit then return false; end
	
	if self.data.unit:lower() == unit:lower() then
		return true
	end
	return false
end

function AXRS.Bars.prototype:IsStatus(status)
	if not status then return false end
	
	if self.data.status:lower() == status:lower() then
		return true
	end
	return false
end

function AXRS.Bars.prototype:AddRemoveUnit(unit)
	if self:IsUnit(unit) then
		self:RemoveUnit(unit)
	else
		self:AddUnit(unit)
	end
	self:RecreateBar()
end

function AXRS.Bars.prototype:AddRemoveStatus(status)
	if self:IsStatus(status) then
		self:RemoveStatus(status)
	else
		self:AddStatus(status)
	end
	self:RecreateBar()
end

function AXRS.Bars.prototype:RemoveUnit(unit)
	if self.data.unit:lower() == unit:lower() then
		self.data.unit = nil
	end
end

function AXRS.Bars.prototype:AddUnit(unit)
	self.data.unit = unit
end

function AXRS.Bars.prototype:RemoveStatus(status)
	if self.data.status:lower() == status:lower() then
		self.data.status = nil
	end
end

function AXRS.Bars.prototype:AddStatus(status)
	self.data.status = status
end

function AXRS.Bars.prototype:RecreateBar()
	self:RemoveBar()
	self:CreateBar()
	if self.data.status ~= "blank" then
		self:UpdateBar()
	end
end

function AXRS.Bars.prototype:DeleteBar()
	self:RemoveBar()
	AXRS:DeleteBar(self)
end

function AXRS.Bars.prototype:GetPosition()
	return self.pos
end

function AXRS.Bars.prototype:GetType()
	return self.data.status
end

function AXRS.Bars.prototype:SetHeight()
	self.statusbar:SetHeight(AXRS.db.profile.settings.barheight)
	if self.statusbar2 then
		self.statusbar2:SetHeight(AXRS.db.profile.settings.barheight)
	end
	self:SetPosition()
end

function AXRS.Bars.prototype:SetPosition(pos)
	if pos then
		self.pos = pos
	end
	local height = -((self.pos-1) * (AXRS.db.profile.settings.barheight + 1)) - 20
	
	if AXRS.db.profile.settings.hidetitle then
		height = -((self.pos-1) * (AXRS.db.profile.settings.barheight + 1)) - 10
	end

	if self.statusbar2 then
		self.statusbar2:SetPoint("TOP", AXRS.frame, "TOP", 0, height)
		if self.statusbar then
			self.statusbar:SetPoint("TOP", self.statusbar2, "TOP", 0, 0)
		end
	else
		if self.statusbar then
			self.statusbar:SetPoint("TOP", AXRS.frame, "TOP", 0, height)
		end
	end
end

function AXRS.Bars.prototype:SetBarColor(r, g, b, a)
	self.data.barcolor.r = r
	self.data.barcolor.g = g
	self.data.barcolor.b = b
	self.data.barcolor.a = a

	if self.data.useBarColor then
		self:UpdateBar()
	end
end

function AXRS.Bars.prototype:SetTextColor(r, g, b, a)
	self.data.textcolor.r = r
	self.data.textcolor.g = g
	self.data.textcolor.b = b
	self.data.textcolor.a = a

	if self.data.useTextColor then
		self:UpdateBar()
	end
end

function AXRS.Bars.prototype:SetBarTexture(value)
	if self.data.status ~= "blank" then
		if self.statusbar then
			self.statusbar:SetStatusBarTexture(value)
		end
		if self.statusbar2 then
			self.statusbar2:SetStatusBarTexture(value)
		end
	end
end

function AXRS.Bars.prototype:SetBlankColor(r, g, b, a)
	self.data.blankcolor.r = r
	self.data.blankcolor.g = g
	self.data.blankcolor.b = b
	self.data.blankcolor.a = a

	local color = self.data.blankcolor
	self.line:SetBackdropColor(color.r, color.g, color.b, color.a)
end

function AXRS.Bars.prototype:SetWidth(width)
	self.width = width
	if self.statusbar then
		self.statusbar:SetWidth(width)
	end
	if self.statusbar2 then
		self.statusbar2:SetWidth(width)
	end
	if self.data.status == "blank" then
		self.line:SetWidth(width)
	end
end