﻿-- Author      : Apoco
-- Create Date : 3/7/2008 5:51:36 PM
-- Credits for Aceing and Fubar Code goes to Rabbit, author of NRT.
-- Credits for Ace3 transport to author of kgPanels.
-- Extra Credits goes to Tivoli for putting up with me. <3

AXRS = LibStub("AceAddon-3.0"):NewAddon("aXRaidStatus", 
	"AceEvent-3.0",
	"AceConsole-3.0",
	"AceTimer-3.0",
	"LibFuBarPlugin-Mod-3.0"
)
axrsinraid, axrsdummyraid = false, false
------------ locals
local addon = AXRS
local L = LibStub("AceLocale-3.0"):GetLocale("aXRS", true)
local BC = LibStub("LibBabble-Class-3.0"):GetLookupTable()
local TalentQuery = LibStub:GetLibrary("LibTalentQuery-1.0")
local media = LibStub("LibSharedMedia-3.0", true)
local inraid, scannedraid, scannedmsg, updateBars = false, false, false, nil
local dpslst = { }
local tanklst = { }
local healllst = { }
local raidlst = { }
local bars = { }
local scannedLst = { }
local talentQueLst = { }

local talentIgnoreLst = {
	[BC["Hunter"]] = true,
	[BC["Mage"]] = true,
	[BC["Warlock"]] = true,
	[BC["Rogue"]] = true,
}
local dpstrees = {
	[L["Arms"]] = true,				-- Warrior
	[L["Fury"]] = true,				-- Warrior
	[L["Enhancement"]] = true,		-- Shaman
	[L["Elemental"]] = true,		-- Shaman
	[L["Shadow"]] = true,			-- Priest
	[L["Retribution"]] = true,		-- Paladin
	[L["Balance"]] = true,			-- Boomkin Druid
}

local healtrees = { 
	[L["Holy"]] = true,				-- priest/paladin
	[L["Discipline"]] = true,		-- priest
	[L["Restoration"]] = true,		-- druid/shaman
}

local tanktrees = {
	[L["Protection"]] = true,		-- Warrior/Paladin
	[L["Feral Combat"]] = true,		-- Druid
}

local new, del
do
	local cache = setmetatable({},{__mode='k'})
	function new(...)
		local t = next(cache)
		if t then
			cache[t] = nil
			for i = 1, select("#", ...) do
				t[i] = select(i, ...)
			end
			return t
		else
			return {...}
		end
	end
	function del(t)
		if type(t) == "table" then
			for k in pairs(t) do t[k] = nil end
			cache[t] = true
		end
		return nil
	end
end

---- Database Shit ------------------------------------------------
-------------------------------------------------------------------
local dbDefaults = {
	global = { },
	profile = {
		settings = {
			firstlaunch = true,
			debug = false,
			autoupdate = true,
			groups = 5,
			updatetime = 1,
			barheight = 15,
			tooltipupdate = true,
			scale = 1,
			docked = false,
			lock = false,
			width = 130,
			talentdetection = false,
			autocolortext = false,
			texture = {
				name = "Blizzard",
				path = "Interface\TargetingFrame\UI-StatusBar",
			},
			pos = false,
			titlecolor = {
				r = 1,
				g = 1,
				b = 1,
				a = 1,
			},
			bordercolor = {
				r = .1,
				g = .1,
				b = .8,
				a = 1,
			},
			backgroundcolor = {
				r = 0,
				g = 0,
				b = 0,
				a = 1,
			},
			colorgradient = true,
			colorgradientstart = {
				r = .2,
				g = .2,
				b = .8,
				a = 1,
			},
			colorgradientstop = {
				r = .4,
				g = .2,
				b = 1,
				a = 1,
			},
		},
		dpslst = {
			[BC["Hunter"]] = true,
			[BC["Mage"]] = true,
			[BC["Warlock"]] = true,
			[BC["Rogue"]] = true,
		},
		heallst = {
			[BC["Priest"]] = true,
			[BC["Shaman"]] = true,
			[BC["Paladin"]] = true,
			[BC["Druid"]] = true,
		},
		tanklst = {
			[BC["Warrior"]] = true,
		},
		bartable = { },
	},
}

---- Core Functions -----------------------------------------------
-------------------------------------------------------------------
function addon:OnInitialize()
	self.db = LibStub("AceDB-3.0"):New("aXRSDB")
	self.db:RegisterDefaults(dbDefaults)

	self:RegisterChatCommand("aXRS", "CommandLine", true, true)
	
	self.title = "|cffff0000Raid Status|r"
	self:SetFuBarOption("iconPath", "Interface\\Icons\\Inv_Misc_SummerFest_BrazierOrange")
	self:SetFuBarOption("independentProfile", true)
	self:SetFuBarOption("cannotDetachTooltip", true)
	self:SetFuBarOption("hideWithoutStandby", true)
	self.OpenMenu = self.OpenMenuLocal
	if self.db.profile.settings.firstlaunch then
		self.db.profile.barTable = {
				{	["useBarColor"] = true,
					["type"] = "statusbar",
					["name"] = "Raid Alive",
					["backgroundBar"] = true,
					["status"] = "alive",
					["barcolor"] = {
						["a"] = 1,
						["r"] = 1,
						["g"] = 0.6470588235294118,
						["b"] = 0.4784313725490196,
					},
					["textcolor"] = {
						["a"] = 1,
						["r"] = 1,
						["g"] = 1,
						["b"] = 1,
					},
					["unit"] = "raid",
				}, -- [1]
				{	["useBarColor"] = true,
					["type"] = "statusbar",
					["name"] = "Raid HP",
					["backgroundBar"] = true,
					["status"] = "health",
					["barcolor"] = {
						["a"] = 1,
						["r"] = 0,
						["g"] = 1,
						["b"] = 0.3568627450980392,
					},
					["textcolor"] = {
						["a"] = 1,
						["r"] = 1,
						["g"] = 1,
						["b"] = 1,
					},
					["unit"] = "raid",
				}, -- [2]
				{	["type"] = "statusbar",
					["name"] = "Raid MP",
					["backgroundBar"] = true,
					["status"] = "mana",
					["barcolor"] = {
						["a"] = 1,
						["r"] = 1,
						["g"] = 1,
						["b"] = 1,
					},
					["textcolor"] = {
						["a"] = 1,
						["r"] = 1,
						["g"] = 1,
						["b"] = 1,
					},
					["unit"] = "raid",
				}, -- [3]
				{	["type"] = "spacer",
					["name"] = "spacer4",
					["status"] = "blank",
					["barcolor"] = {
						["a"] = 1,
						["r"] = 1,
						["g"] = 1,
						["b"] = 1,
					},
					["textcolor"] = {
						["a"] = 1,
						["r"] = 1,
						["g"] = 1,
						["b"] = 1,
					},
					["blankcolor"] = {
						["a"] = 1,
						["r"] = 1,
						["g"] = 1,
						["b"] = 1,
					},
				}, -- [4]
				{	["type"] = "statusbar",
					["name"] = "DPS Alive",
					["useBarColor"] = true,
					["status"] = "alive",
					["barcolor"] = {
						["a"] = 1,
						["r"] = 1,
						["g"] = 0.5882352941176471,
						["b"] = 0,
					},
					["textcolor"] = {
						["a"] = 1,
						["r"] = 1,
						["g"] = 1,
						["b"] = 1,
					},
					["unit"] = "dps",
				}, -- [5]
				{	["useBarColor"] = true,
					["type"] = "statusbar",
					["name"] = "DPS HP",
					["backgroundBar"] = true,
					["status"] = "health",
					["barcolor"] = {
						["a"] = 1,
						["r"] = 0.4313725490196079,
						["g"] = 1,
						["b"] = 0.4862745098039216,
					},
					["textcolor"] = {
						["a"] = 1,
						["r"] = 1,
						["g"] = 1,
						["b"] = 1,
					},
					["unit"] = "dps",
				}, -- [6]
				{	["type"] = "statusbar",
					["name"] = "DPS MP",
					["status"] = "mana",
					["barcolor"] = {
						["a"] = 1,
						["r"] = 1,
						["g"] = 1,
						["b"] = 1,
					},
					["textcolor"] = {
						["a"] = 1,
						["r"] = 1,
						["g"] = 1,
						["b"] = 1,
					},
					["unit"] = "dps",
				}, -- [7]
				{	["type"] = "spacer",
					["name"] = "spacer8",
					["status"] = "blank",
					["barcolor"] = {
						["a"] = 1,
						["r"] = 1,
						["g"] = 1,
						["b"] = 1,
					},
					["textcolor"] = {
						["a"] = 1,
						["r"] = 1,
						["g"] = 1,
						["b"] = 1,
					},
					["blankcolor"] = {
						["a"] = 1,
						["r"] = 1,
						["g"] = 1,
						["b"] = 1,
					},
				}, -- [8]
				{	["type"] = "statusbar",
					["name"] = "Heal Alive",
					["useBarColor"] = true,
					["status"] = "alive",
					["barcolor"] = {
						["a"] = 1,
						["r"] = 1,
						["g"] = 0.4549019607843137,
						["b"] = 0.3215686274509804,
					},
					["textcolor"] = {
						["a"] = 1,
						["r"] = 1,
						["g"] = 1,
						["b"] = 1,
					},
					["unit"] = "heal",
				}, -- [9]
				{	["type"] = "statusbar",
					["name"] = "Heal MP",
					["status"] = "mana",
					["barcolor"] = {
						["a"] = 1,
						["r"] = 1,
						["g"] = 1,
						["b"] = 1,
					},
					["textcolor"] = {
						["a"] = 1,
						["r"] = 1,
						["g"] = 1,
						["b"] = 1,
					},
					["unit"] = "heal",
				}, -- [10]
				{	["type"] = "spacer",
					["name"] = "spacer11",
					["status"] = "blank",
					["barcolor"] = {
						["a"] = 1,
						["r"] = 1,
						["g"] = 1,
						["b"] = 1,
					},
					["textcolor"] = {
						["a"] = 1,
						["r"] = 1,
						["g"] = 1,
						["b"] = 1,
					},
					["blankcolor"] = {
						["a"] = 1,
						["r"] = 1,
						["g"] = 1,
						["b"] = 1,
					},
				}, -- [11]
				{	["type"] = "statusbar",
					["name"] = "Tank Alive",
					["status"] = "alive",
					["barcolor"] = {
						["a"] = 1,
						["r"] = 1,
						["g"] = 1,
						["b"] = 1,
					},
					["textcolor"] = {
						["a"] = 1,
						["r"] = 1,
						["g"] = 1,
						["b"] = 1,
					},
					["unit"] = "tank",
				}, -- [12]
			}
		self.db.profile.settings.firstlaunch = false
	end
	bars = new()
	updateBars = new()
end

function addon:OnEnable(first)
	self:RegisterEvent("RAID_ROSTER_UPDATE")
	self:RegisterEvent("PLAYER_LOGIN")
end	

function addon:OnDisable()
	self:UnregisterAllEvents()
end

function addon:SetupFrames()
	if not self.tooltip then
		self.tooltip = CreateFrame("GameTooltip", "aXRSTooltip", UIParent, "GameTooltipTemplate")
	end

	self.frame = CreateFrame("Frame", "aXRSFrame", UIParent)
	self.frame:EnableMouse(true)
	self.frame:SetFrameStrata("MEDIUM")
	self.frame:SetMovable(true)
	self.frame:SetWidth(130)
	self.frame:SetHeight(100)

	self.axrsfs = self.frame:CreateFontString("$parentTitle", "ARTWORK", "GameFontNormal")
	self.axrsfs:SetText(L["RaidStatus"])
	self.axrsfs:SetPoint("TOP",0,-5)
	local tc = self.db.profile.settings.titlecolor
	self.axrsfs:SetTextColor(tc.r, tc.g, tc.b, tc.a)
	self.axrsfs:Show()

	self.frame:SetBackdrop( { 
		bgFile = "Interface\\Tooltips\\UI-Tooltip-Background", 
		edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border",
		tile = true,
		tileSize = 16,
		edgeSize = 16, 
		insets = { left = 5, right = 5, top = 5, bottom = 5 }
	})
	local boc = self.db.profile.settings.bordercolor
	self.frame:SetBackdropBorderColor(boc.r,boc.g,boc.b,boc.a)
	local bc = self.db.profile.settings.backgroundcolor
	self.frame:SetBackdropColor(bc.r,bc.g,bc.b,bc.a)
	
	local gradient = self.frame:CreateTexture(nil, "BORDER")
	gradient:SetTexture("Interface\\ChatFrame\\ChatFrameBackground")
	gradient:SetPoint("TOPLEFT", self.frame, "TOPLEFT", 4, -4)
	gradient:SetPoint("BOTTOMRIGHT", self.frame, "BOTTOMRIGHT", -4, 4)
	gradient:SetBlendMode("ADD")
	
	local cgstart = self.db.profile.settings.colorgradientstart
	local cgstop = self.db.profile.settings.colorgradientstop
	gradient:SetGradientAlpha("VERTICAL", cgstart.r, cgstart.g, cgstart.b, cgstart.a, cgstop.r, cgstop.g, cgstop.b, cgstop.a)
	if not self.db.profile.settings.colorgradient then
		gradient:Hide()
	end
	self.framegradient = gradient
	
	self.frame:ClearAllPoints()
	self.frame:SetPoint("CENTER", UIParent, "CENTER", 0, 0)

	self.frame:SetScript("OnMouseDown",function()
		if arg1 == "LeftButton" then
			if not self.db.profile.settings["lock"] then
				this:StartMoving()
			end
		end
	end)
	self.frame:SetScript("OnMouseUp",function()
		if arg1 == "LeftButton" then
			this:StopMovingOrSizing()
			self:SavePosition()
		end
	end)
	self.frame:SetScript("OnHide",function() this:StopMovingOrSizing() end)
	self.frame:SetScript("OnShow",function() 
		for _,v in ipairs(bars) do
			if v:GetType() ~= "blank" then
				v:UpdateBar()
			end
		end
	end)

	self.frame:SetClampedToScreen(true)

	self:LoadPosition()
	self:UpdateScale()

	self:SetupBars()
	self:SetWidth()
	self:dprint("aXRS~SetupFrames", "aXRS Frame created!")
end

function addon:UpdateAllPos()
	for _,v in ipairs(bars) do
		v:SetPosition()
	end
end

function addon:SetWidth()
	local width = self.db.profile.settings.width
	
	local barcount = #bars
	local barheight = self.db.profile.settings.barheight + 1

	if self.frame then 
		height = 30 + (barcount * barheight)
		if self.db.profile.settings.hidetitle then
			height = (35 - self.db.profile.settings.barheight) + (barcount * barheight)
			local checkheight = self.db.profile.settings.barheight - 16.5
			if checkheight >= 0 then
				height = height + (checkheight + 1)
			elseif checkheight <= -2 then
				height = height + (checkheight - 1)
			end
		end
		self.frame:SetHeight(height)
		self.frame:SetWidth(width + 15)
	end
	if type(bars) == "table" then
		for _,v in ipairs(bars) do
			v:SetWidth(width)
			v:SetHeight()
		end
	end
end

function addon:UpdateScale()
	if self.frame then
		self.frame:SetScale(self.db.profile.settings.scale)
		self:LoadPosition()
	end
end

function addon:SavePosition()
	local scale = self.frame:GetEffectiveScale()
	local worldscale = UIParent:GetEffectiveScale()
	
	local x,y = self.frame:GetLeft()*scale,self.frame:GetTop()*scale - (UIParent:GetTop())*worldscale

	if not self.db.profile.settings.pos then
		self.db.profile.settings.pos = {}
	end
	
	self.db.profile.settings.pos.x = x
	self.db.profile.settings.pos.y = y
end

function addon:LoadPosition()
	if self.db.profile.settings.docked and IsAddOnLoaded("Dock") then
		if Dock:IsFrameDocked(self.frame) then return end
	end
	if self.db.profile.settings.pos then
		local x = self.db.profile.settings.pos.x
		local y = self.db.profile.settings.pos.y
		local scale = self.frame:GetEffectiveScale()
		
		self.frame:SetPoint("TOPLEFT", UIParent,"TOPLEFT", x/scale, y/scale)
	else
		self.frame:SetPoint("CENTER", UIParent, "CENTER")
	end
end

function addon:SetColorGradient(value)
	self.db.profile.settings.colorgradient = value
	if value then
		self.framegradient:Show()
	else
		self.framegradient:Hide()
	end
end

function addon:SetBarTexture(name)
	local texture = media:Fetch("statusbar", name)
	for _,v in ipairs(bars)do
		v:SetBarTexture(texture)
	end
end

function addon:UpdateBackgroundColor(key, r, g, b, a)
	local bc = self.db.profile.settings.backgroundcolor
	bc.r, bc.g, bc.b, bc.a = r, g, b, a
	self.frame:SetBackdropColor(r, g, b, a)
end

function addon:UpdateTitleColor(key, r, g, b, a)
	local tc = self.db.profile.settings.titlecolor
	if not key and not r and not g and not b and not a then
		self.axrsfs:SetTextColor(tc.r, tc.g, tc.b, tc.a)
		return
	end
	tc.r, tc.g, tc.b, tc.a = r, g, b, a
	self.axrsfs:SetTextColor(r, g, b, a)
end

function addon:UpdateBorderColor(key, r, g, b, a)
	local boc = self.db.profile.settings.bordercolor
	boc.r, boc.g, boc.b, boc.a = r, g, b, a
	self.frame:SetBackdropBorderColor(r, g, b, a)
end

function addon:UpdateBackgroundGradient()
	local cgstart = self.db.profile.settings.colorgradientstart
	local cgstop = self.db.profile.settings.colorgradientstop
	self.framegradient:SetGradientAlpha("VERTICAL", cgstart.r, cgstart.g, cgstart.b, cgstart.a, cgstop.r, cgstop.g, cgstop.b, cgstop.a)
end

function addon:AddAllBarsToQueue()
	for _,v in ipairs(bars) do
		self:AddToQueue(v)
	end
	self:UpdateAllBars()
end

function addon:UpdateAllBars()
	if type(updateBars) == "table" then
		for _,v in pairs(updateBars) do
			v:UpdateBar()
		end
	end
	updateBars = del(updateBars)
	updateBars = new()
end

function addon:AddToQueue(bar)
	local function AlreadyQueued(bar)
		if updateBars[bar] then
			return true
		end
		return false
	end
	
	if not AlreadyQueued(bar) then 
		updateBars[bar] = bar
	end
end

function addon:AlwaysUpdateQueue()
	for _,v in ipairs(bars) do
		if ((v.data.status == "zone" or v.data.status == "offline") and not UnitAffectingCombat("player")) or v.data.status == "alive" or v.data.status == "pvp" then
			self:AddToQueue(v)
		end
	end
end

function addon:GetClassColor(class)
	class = string.upper(class)
	if RAID_CLASS_COLORS and RAID_CLASS_COLORS[class] then
		return RAID_CLASS_COLORS[class].r, RAID_CLASS_COLORS[class].g, RAID_CLASS_COLORS[class].b
	end
	return 0.63, 0.63, 0.63
end

function addon:GetHexColor(class)
	local r, g, b = self:GetClassColor(class)
	return string.format("%02x%02x%02x", r * 255, g * 255, b * 255)
end

function addon:DeleteBar(bar)
	for k,v in ipairs(bars) do
		if v == bar then
			table.remove(bars, k)
			table.remove(self.db.profile.barTable, k)
		end
	end

	for k,v in ipairs(bars) do
		v:SetPosition(k)
	end
	self:SetWidth()
end

function addon:GetColor(num)
	if num >= 80 then
		return "|cff00ff00"
	elseif num < 80 and num > 20 then
		return "|cffffC469"
	elseif num <= 20 then
		return "|cffff0000"
	end
	return ""
end

function addon:LeaveRaid()
	TalentQuery.UnregisterCallback(self, "TalentQuery_Ready")
	self:CancelAllTimers(self)
	if self.frame then
		self.frame:Hide()
	end
	
	for k,v in ipairs(bars) do
		v:RemoveBar()
	end

	bars = del(bars)
	buffs = del(bars)
	
	bars = new()
	buffs = new()

	self.frame = nil
	self.axrsfs = nil
end

function addon:GetUpdateUnit(name)
	if dpslst[name] then return "dps"
	elseif heallst[name] then return "heal"
	elseif tanklst[name] then return "tank"
	end
end
---- Event Shit ---------------------------------------------------
-------------------------------------------------------------------
function addon:UNIT_HEALTH(...)
	local unit = self:GetUpdateUnit(UnitName(arg1))
	for _,v in ipairs(bars) do
		if v.data.status == "health" and (v.data.unit == "raid" or v.data.unit == unit) then
			self:AddToQueue(v)
		end
	end
end

function addon:UNIT_MANA(...)
	local unit = self:GetUpdateUnit(UnitName(arg1))
	for _,v in ipairs(bars) do
		if v.data.status == "mana" and (v.data.unit == "raid" or v.data.unit == unit) then
			self:AddToQueue(v)
		end
	end
end

function addon:RAID_ROSTER_UPDATE(...)
	if UnitInRaid("player") and not UnitInBattleground("player") then
		self:UpdateLocalLists()
		if not axrsinraid then
			TalentQuery.RegisterCallback(self, "TalentQuery_Ready")
			axrsinraid = true
			self:OnTextUpdate()
			if not self.frame then 
				self:SetupFrames() 
			end
			if not self.frame:IsShown() and not self.db.profile.settings.docked then
				self.frame:Show()
			end
			self:ScheduleRepeatingTimer(self.UpdateAllBars, self.db.profile.settings.updatetime, self)
			self:ScheduleRepeatingTimer(self.AlwaysUpdateQueue, self.db.profile.settings.updatetime, self)
			self:RegisterEvent("UNIT_HEALTH")
			self:RegisterEvent("UNIT_MANA")
			
			for _,v in ipairs(bars) do
				if v:GetType() ~= "blank" then
					v:UpdateBar()
				end
			end
		end
		
		return
 	end
 	self:LeaveRaid()
	self:UnregisterEvent("UNIT_HEALTH")
	self:UnregisterEvent("UNIT_MANA")
	axrsinraid = false
	self:OnTextUpdate()
end

function addon:PLAYER_LOGIN()
	self:RAID_ROSTER_UPDATE()
	if self.db.profile.settings.docked then
		self:CreateDummyRaid()
	end
	self:OnTextUpdate()
end	

---- Misc Shit ----------------------------------------------------
-------------------------------------------------------------------
function addon:CreateDummyRaid()
	if not axrsdummyraid and not self.db.profile.settings.docked then return end
	if not self.frame then 
		self:SetupFrames() 
	end
	if not self.frame:IsShown() then
		self.frame:Show()
	end
end

function addon:GetRealTable(unit)
	if unit == "dps" then return dpslst or { }
	elseif unit == "heal" then return heallst or { }
	elseif unit == "tank" then return tanklst or { }
	else return raidlst or { }
	end
end

function addon:CommandLine(input)
	local cmd,ly = self:GetArgs(input,2,1)
	if cmd == "config" then
		self:OpenMenuLocal()
		return
		
	elseif cmd == "talentscan" then
		if UnitInRaid("player") and not UnitAffectingCombat("player") then
			addon:TalentScanStart()
			return
		else
			self:print(L["Error"].." "..L["Error_NoScan"])
		end
		return
	end
	
	self:print(L["Usage"])
end

function addon:OpenMenuLocal()
	if IsAddOnLoaded("aX_RaidStatusConfig") then
		LibStub("AceConfigDialog-3.0"):Open("aX RaidStatus")
	else
		local loaded, reason = LoadAddOn("aX_RaidStatusConfig")
		if loaded then
			LibStub("AceConfigDialog-3.0"):Open("aX RaidStatus")
		else
			self:print(reason)
		end
	end
end

function addon:CreateNewBar(type, unit, status, name)
	local pos = #self.db.profile.barTable + 1
	if not name then
		local cname
		if type ~= "spacer" then
			cname = unit.." "..status
		elseif type == "spacer" then	
			cname = "spacer"..pos
		end
		name = cname
	end

	local tempTable = {}
	tempTable.name = name		-- name
	tempTable.type = type		-- statusbar/blankbar
	tempTable.unit = unit		-- raid/dps/heals/etc
	tempTable.status = status	-- hp/mp/etc

	local bar = AXRS.Bars.prototype:new(pos, tempTable, self.db.profile.settings["texture"].path)
	table.insert(self.db.profile.barTable, pos, tempTable)
	table.insert(bars, bar)

	self:SetWidth()
end

function addon:BarUp(bar)
	local pos = bar:GetPosition()
	local bt = self.db.profile.barTable

	if bar:GetPosition() == 1 then return end

	bars[pos], bars[pos-1] = bars[pos-1], bars[pos]
	bt[pos], bt[pos-1] = bt[pos-1], bt[pos]

	bars[pos]:SetPosition(pos)
	bars[pos-1]:SetPosition(pos-1)
end

function addon:BarDown(bar)
	local pos = bar:GetPosition()
	local bt = self.db.profile.barTable

	if bar:GetPosition() == #bars then return end

	bars[pos], bars[pos+1] = bars[pos+1], bars[pos]
	bt[pos], bt[pos+1] = bt[pos+1], bt[pos]

	bars[pos]:SetPosition(pos)
	bars[pos+1]:SetPosition(pos+1)
end

function addon:SetupBars()
	local bt = self.db.profile.barTable
	local texture = media:Fetch("statusbar", self.db.profile.settings.texture)

	for i,v in ipairs(bt) do
		local d = bt[i]
		local bar = AXRS.Bars.prototype:new(i, d, texture)
		table.insert(bars, bar)
	end
end

function addon:GetTooltipPoints()
	local curX, curY = AXRS:GetScaledCursorPosition()
	local point, relativePoint
	if curY < GetScreenHeight() / 2 then
		point, relativePoint = "BOTTOM", "TOP"
	else
		point, relativePoint = "TOP", "BOTTOM"
	end
	if curX < GetScreenWidth() / 2 then
		point, relativePoint = point .. "LEFT", relativePoint .. "RIGHT"
	else
		point, relativePoint = point .. "RIGHT", relativePoint .. "LEFT"
	end
	return point, relativePoint
end

function addon:GetScaledCursorPosition()
	local x, y = GetCursorPosition()
	local scale = UIParent:GetEffectiveScale()
	return x / scale, y / scale
end

function addon:TalentScanCheckType(name)
	if dpstrees[name] then return "dps"
	elseif healtrees[name] then	return "heal"
	elseif tanktrees[name] then return "tank"
	end
	return "unknown"
end

function addon:TalentQuery_Ready(e, name, realm)
	if not talentQueLst[name] then return end
	local namerealm = realm and realm ~= "" and name.."-"..realm or name
	local isnotplayer = (name ~= UnitName("player"))
	local class = UnitClass(namerealm)

	for tab=1, GetNumTalentTabs(isnotplayer) do
		local treename, _, pointsspent = GetTalentTabInfo(tab, isnotplayer)
		if pointsspent > 30 then
			local type = self:TalentScanCheckType(treename)
			if type then
				if type == "dps" and not self.db.profile.dpslst[class] then
					self:print(string.format(L["Found_DPS"], namerealm))
					AXRSConfig:AddDPSToGlobalList(namerealm, true)

				elseif type == "heal" and not self.db.profile.heallst[class] then
					self:print(string.format(L["Found_Healer"], namerealm))
					AXRSConfig:AddHealerToGlobalList(namerealm, true)
					
				elseif type == "tank" and not self.db.profile.tanklst[class] then
					self:print(string.format(L["Found_Tank"], namerealm))
					AXRSConfig:AddTankToGlobalList(namerealm, true)
				else
					self:print(string.format(L["Error_Found_Unknown"], namerealm))
				end
				scannedLst[namerealm] = type
				talentQueLst[namerealm] = nil
				return
			end
		end
		if tab == 3 and pointsspent < 30 then
			self:print(string.format(L["Error_Found_Hybrid"], namerealm))
			scannedLst[namerealm] = true
			talentQueLst[namerealm] = nil
		end
	end
end

function addon:TalentDetection(name)
	talentQueLst[name] = true
	if UnitIsUnit(name, "player") then
		self:TalentQuery_Ready(_, name)
	else
		TalentQuery:Query(name)
	end
end

function addon:UpdateLocalLists(force)
	if (UnitAffectingCombat("player") and not force) or not UnitInRaid("player") then return end
	self:dprint("aXRS-UpdateNum", "Started")
	dpslst = { }
	tanklst = { }
	heallst = { }
	raidlst = { }
	for i=1, GetNumRaidMembers() do
		local name, _, subgroup, _, class, _, _, _, _, _, _ = GetRaidRosterInfo(i)
		if not name or not subgroup or not class then break end
		
		if subgroup <= self.db.profile.settings.groups then
			name = UnitName(name)
				
			if self.db.profile.settings.talentdetection then
				if not self.db.profile.tanklst[name] and not self.db.profile.heallst[name] and not self.db.profile.dpslst[name]
				and class ~= BC["Hunter"] and class ~= BC["Mage"] 
				and class ~= BC["Warlock"] and class ~= BC["Rogue"] and not scannedLst[name] and not talentQueLst[name] then
					if IsAddOnLoaded("aX_RaidStatusConfig") then
						self:TalentDetection(name)
					else
						local loaded, reason = LoadAddOn("aX_RaidStatusConfig")
						if loaded then
							self:TalentDetection(name)
						else
							self:print(L["Error"].." "..L["Error_TalentScan"].." "..reason)
							self.db.profile.settings.talentdetection = false
						end
					end
				end
			end
			
			raidlst[name] = true
			for i in pairs(self.db.profile.dpslst) do
				if i == class or i == name then
					if not self.db.profile.tanklst[name] and not self.db.profile.heallst[name] then
						if not dpslst[name] then
							dpslst[name] = true
						end
						break
					end
				end
			end
			for i in pairs(self.db.profile.heallst) do
				if i == class or i == name then
					if not self.db.profile.dpslst[name] and not self.db.profile.tanklst[name] then
						if not heallst[name] then
							heallst[name] = true
						end
						break
					end
				end
			end
			for i in pairs(self.db.profile.tanklst) do
				if i == class or i == name then
					if not self.db.profile.heallst[name] and not self.db.profile.dpslst[name] then
						if not tanklst[name] then
							tanklst[name] = true
						end
						break
					end
				end
			end
		end
	end
end

function addon:UpdateDPSlst()
	local opt = options.args.dpslst.args
	local db = self.db.profile.dpslst
	for k in pairs(db) do
		if not opt[k] and k ~= BC["Rogue"] and k ~= BC["Hunter"] and k ~= BC["Mage"] and k ~= BC["Warlock"] then
			opt[k] = {
				type = "execute",
				name = k,
				desc = L["Remove_DPS"],
				func = function(v)
					AXRSConfig:RemoveDPSFromGlobalList(v)
				end,
				passValue = k,
				order = 10,
			}
		end
	end
end

function addon:UpdateTanklst()
	local opt = options.args.tanklst.args
	local db = self.db.profile.tanklst
	for k in pairs(db) do
		if not opt[k] and k ~= BC["Warrior"] then
			opt[k] = {
				type = "execute",
				name = k,
				desc = L["Remove_Tank"],
				func = function(v)
					AXRSConfig:RemoveTankFromGlobalList(v)
				end,
				passValue = k,
				order = 10,
			}
		end
	end
end

function addon:UpdateHeallst()
	local opt = options.args.heallst.args
	local db = self.db.profile.heallst
	for k in pairs(db) do
		if not opt[k] and k ~= BC["Priest"] and k ~= BC["Shaman"] and k ~= BC["Druid"] and k ~= BC["Paladin"] then
			opt[k] = {
				type = "execute",
				name = k,
				desc = L["Remove_Heal"],
				func = function(v)
					AXRSConfig:RemoveHealFromGlobalList(v)
				end,
				passValue = k,
				order = 10,
			}
		end
	end
end

function addon:RemoveFromLocalList(type, name)
	if type == "tank" then
		tanklst[name] = nil

	elseif type == "dps" then
		dpslst[name] = nil
		
	elseif type == "heal" then
		heallst[name] = nil
	end
end

function addon:OnTextUpdate()
	if axrsinraid then
		self:SetFuBarText("|cff00ff00Raid Status|r")
	else
		self:SetFuBarText("|cffff0000Raid Status|r")
	end
end
----- Print Functions ------------------------------------------------|
function addon:print(msg, out, r, g, b)
	out = _G["ChatFrame"..(out or 1)]
	out:AddMessage(msg, (r or 1), (g or 1), (b or 1))
end

function addon:dprint(mod, msg, out, r, g, b)
	if self.db.profile.settings["debug"] then
		out = _G["ChatFrame"..(out or 1)]
		out:AddMessage("|cffff5555aX~DEBUG:|r |cff33ff33Mod:|r |cff88ff88"..mod.."|r  |msg: "..msg, (r or 1), (g or 1), (b or 1))			--|
	end
end