local L = AceLibrary("AceLocale-2.2"):new("aUFRangeCheck")
local BS = AceLibrary("Babble-Spell-2.2")
local opacity

local playerClass = nil
local spellTable = {
	["PRIEST"] = BS["Flash Heal"],
	["DRUID"] = BS["Healing Touch"],
	["PALADIN"] = BS["Holy Light"],
	["SHAMAN"] = BS["Healing Wave"],
}

aUF_RangeCheck = AceLibrary("AceAddon-2.0"):new("AceDB-2.0", "AceEvent-2.0", "AceConsole-2.0")

function aUF_RangeCheck:OnInitialize()
	self:RegisterDB("aUFRangeCheckDB")
	self:RegisterDefaults("profile", {
		interval = 1.0,
		opacity = 0.6,
		units = {
			raid = true,
			raidpet = true,
			party = true,
			partypet = true,
		},
	})
	self:RegisterChatCommand({ "/agufrc" }, {
		type = "group",
		args = {
			interval = {
				name = L["Scan time"], type = "range", order = 1,
				desc = L["scantimeDesc"],
				min = 0.5, max = 3.0, step = 0.1,
				get = function() return self.db.profile.interval end,
				set = function(v)
					self.db.profile.interval = v
					self:UpdateScanTime()
				end,
			},
			opacity = {
				name = L["Opacity"], type = "range", order = 2,
				desc = L["opacityDesc"],
				min = 0.1, max = 1.0, step = 0.1,
				get = function() return self.db.profile.opacity end,
				set = function(v)
					self.db.profile.opacity = v
					opacity = v
				end,
			},
			units = {
				name = L["Units"], desc = L["unitsDesc"], type = "group", order = 3,
				args = {
					raid = {
						name = L["Raid"], desc = L["raidDesc"], type = "toggle", order = 1,
						get = function() return self.db.profile.units.raid end,
						set = function(v) self.db.profile.units.raid = v end,
					},
					raidpet = {
						name = L["Raid pets"], desc = L["raidpetDesc"], type = "toggle", order = 2,
						get = function() return self.db.profile.units.raidpet end,
						set = function(v) self.db.profile.units.raidpet = v end,
					},
					party = {
						name = L["Party"], desc = L["partyDesc"], type = "toggle", order = 3,
						get = function() return self.db.profile.units.party end,
						set = function(v) self.db.profile.units.party = v end,
					},
					partypet = {
						name = L["Party pets"], desc = L["partypetDesc"], type = "toggle", order = 4,
						get = function() return self.db.profile.units.partypet end,
						set = function(v) self.db.profile.units.partypet = v end,
					},
				},
			}
		}
	})
	
	self.inraid = false
end

function aUF_RangeCheck:OnEnable()
	_, playerClass = UnitClass("player")
	if not spellTable[playerClass] then return end

	aUF_RangeCheck:RegisterEvent("RAID_ROSTER_UPDATE")
	opacity = self.db.profile.opacity

	if UnitInRaid("player") == 1 then
		self:ScheduleEvent(self.RAID_ROSTER_UPDATE, 0.2, self)
	end
end

function aUF_RangeCheck:OnDisable()
	self:Stop()
end

function aUF_RangeCheck:RAID_ROSTER_UPDATE()
	if GetNumRaidMembers() == 0 then
		self.inraid = false
		self:Stop()
	else
		if not self.inraid then
			self.inraid = true
			self:ScheduleRepeatingEvent("aUFRangeCheck", aUF_RangeCheck.RangeCheck, self.db.profile.interval, self)
		end
	end
end

function aUF_RangeCheck:Stop()
	self:CancelScheduledEvent("aUFRangeCheck")
	
	for unit in pairs(aUF.units) do
		aUF.units[unit].frame:SetAlpha(1.0)
	end
end

function aUF_RangeCheck:UpdateScanTime()
	if self.inraid then
		if self:IsEventScheduled("aUFRangeCheck") then
			self:CancelScheduledEvent("aUFRangeCheck")
		end
		self:ScheduleRepeatingEvent("aUFRangeCheck", aUF_RangeCheck.RangeCheck, self.db.profile.interval, self)
	end
end

function aUF_RangeCheck:RangeCheck()
	if not spellTable[playerClass] then return end

	for unitid, unit in pairs(aUF.units) do
		if unit and unit.unit and unit.type and self.db.profile.units[unit.type] and unit.unit ~= "player" then
			local inRange = IsSpellInRange(spellTable[playerClass], unit.unit)
			if inRange and inRange == 1 then
				aUF.units[unitid].frame:SetAlpha(1.0)
			else
				aUF.units[unitid].frame:SetAlpha(opacity)
			end
		end
	end
end

