﻿aUF.Layouts.MoonWitch = {
	Name = "MoonWitch",
	Tip = "MoonWitch Layout Tip",
	ResizeBars = true,
	BackgroundBarColor = true,
	AlphaBar = true,
	RaidColorName = false,
	PetClassName = true,
	ComboGFX = true,
	HappinessBar = true,
	Portrait = true,
	Border = "Hidden",

	Auras = {
		Left = {
			Point = "RIGHT",
			RelativePoint = "LEFT",
			x = 0,
			y = 0,
			GrowDirection = "left",
			Scale = 0.80,
			Alpha = 1,
		},
		Right = {
			Point = "LEFT",
			RelativePoint = "RIGHT",
			x = 0,
			y = 0,
			GrowDirection = "right",
			Scale = 0.80,
			Alpha = 1,
		},
		Above = {
			Point = "BOTTOMLEFT",
			RelativePoint = "TOPLEFT",
			x = 3,
			y = -0,
			GrowDirection = "right",
			Scale = "auto",
			AdjustAuto = 7,
			Alpha = 1,
		},
		Below = {
			Point = "TOPLEFT",
			RelativePoint = "BOTTOMLEFT",
			x = 3,
			y = 0,
			GrowDirection = "right",
			Scale = "auto",
			AdjustAuto = 7,
			Alpha = 1,
		},
		Inside = {
			Point = "TOPRIGHT",
			RelativePoint = "TOPRIGHT",
			x = -6,
			y = -6,
			GrowDirection = "left",
			Scale = 0.7,
			Alpha = 0.75,
		}
	},
	ThemeData = {
		all = {
			FrameHeight = 30,
			FrameWidth = 200,

			HitIndicator = {
				Point = "CENTER",
				RelativePoint = "CENTER",
				x = 1,
				y = 1,
			},
			Combo1 = {
				Point = "BOTTOMRIGHT",
				RelativePoint = "BOTTOMRIGHT",
				x = 1,
				y = -1,
				Height = 10,
				HeightAdd = 0,
				Width = 10,
			},

			HealthBar_BG = 	{
				Point = "TOPLEFT",
				RelativePoint = "TOPLEFT",
				RelativeTo = "frame",
				x = 5,
				y = -5,
				
				Visibility = {"HealthBar_BG","HealthBar","HealthText",},
				Height = 20,
				Width = 90,
				WidthFactor = 1,
			},
			
			ManaBar_BG = {
				Point = "TOPLEFT",
				RelativePoint = "BOTTOMLEFT",
				RelativeTo = "Portrait",
				x = 0,
				y = 0,
				
				Point2 = "TOPLEFT",
				RelativePoint2 = "BOTTOMLEFT",
				RelativeTo2 = "HealthBar_BG",
				x2 = 0,
				y2 = 0,
				
				HeightAdd = 20,
				Visibility = {"ManaBar_BG","ManaBar","ManaText","ClassText"},
				Height = 20,
				Width = 90,
				WidthFactor = 1,
			},

			XPBar_BG = {
				RelativeTo = "ManaBar_BG",
				Point = "TOPLEFT",
				RelativePoint = "BOTTOMLEFT",
				x = 0,
				y = -1,
				
				RelativeTo2 = "Portrait",
				Point2 = "TOPLEFT",
				RelativePoint2 = "BOTTOMLEFT",
				x2 = 0,
				y2 = -1,
				
				RelativeTo3 = "HealthBar_BG",
				Point3 = "TOPLEFT",
				RelativePoint3 = "BOTTOMLEFT",
				x3 = 0,
				y3 = 0,

				HeightAdd = 5,
				Visibility = {"XPBar_BG","XPBar"},
				Width = 90,
				Height = 5,
				WidthFactor = 1,
			},

			CastBar_BG = {
				RelativeTo = "XPBar_BG",
				Point = "TOPLEFT",
				RelativePoint = "BOTTOMLEFT",
				x = 0,
				y = -1,

				RelativeTo2 = "ManaBar_BG",
				Point2 = "TOPLEFT",
				RelativePoint2 = "BOTTOMLEFT",
				x2 = 0,
				y2 = -1,

				RelativeTo3 = "Portrait",
				Point3 = "TOPLEFT",
				RelativePoint3 = "BOTTOMLEFT",
				x3 = 0,
				y3 = -1,

				RelativeTo4 = "HealthBar_BG",
				Point4 = "TOPLEFT",
				RelativePoint4 = "BOTTOMLEFT",
				x4 = 0,
				y4 = -1,

				HeightAdd = 10,
				Visibility = {"CastBar_BG","CastBar","CastText", "BarCastText" },
				Width = 90,
				Height = 10,

				WidthFactor = 1,
			},

			NameLabel = {
				Type = "string",
				FontSize = 10,
				Point = "LEFT",
				RelativeTo = "HealthBar_BG",
				RelativePoint = "LEFT",
				x = 1.5,
				y =0,

				EndPoint = "RIGHT",
				EndRelativeTo = "HealthText",
				EndRelativePoint = "LEFT",
				Endx=2,
				Endy=0,
				Height = 10,
			},

			ClassText = {
				Type = "string",
				FontSize = 9,
				Justify = "LEFT",
				Point = "LEFT",
				RelativeTo = "ManaBar_BG",
				RelativePoint = "LEFT",
				x = 1.5,
				y = 0.5,

				EndPoint = "RIGHT",
				EndRelativeTo = "ManaText",
				EndRelativePoint = "LEFT",
				Endx=2,
				Endy=0,
				Height = 9,
			},

			HealthText = {
				Type = "string",
				FontSize = 10,
				Point = "RIGHT",
				RelativeTo = "HealthBar_BG",
				RelativePoint = "RIGHT",
				x=-1.5,
				y=0,
				Justify = "RIGHT",
				Height = 10,
			},

			ManaText = {
				Type = "string",
				FontSize = 9,
				Point = "RIGHT",
				RelativeTo = "ManaBar_BG",
				RelativePoint = "RIGHT",
				x= -1.5,
				y= 0.5,
				Justify = "RIGHT",
				Height = 9,
			},

			CastText = {
				RelativeTo = "CastBar_BG",
				Point = "RIGHT",
				RelativePoint = "RIGHT",
				x = -0.5,
				y = 0.5,
				
				FontSize = 8,
				Width = 60,
				Height = 8,
			},

			BarCastText = {
				RelativeTo = "CastBar_BG",
				Point = "LEFT",
				RelativePoint = "LEFT",
				x = 0.5,
				y = 0.5,

				Width = 60,
				Height = 8,

				FontSize = 8,
				Justify = "LEFT",

				EndPoint = "RIGHT",
				EndRelativeTo = "CastText",
				EndRelativePoint = "LEFT",
				Endx=0,
				Endy=0,
			},

			PVPIcon = {
				Point = "TOPLEFT",
				RelativePoint = "TOPLEFT",
				x = 0,
				y= 0,
			},

			InCombatIcon = {
				Point = "BOTTOMLEFT",
				RelativePoint = "BOTTOMLEFT",
				x = -4,
				y= -3,
			},

			RaidTargetIcon = {
				Point = "CENTER",
				RelativePoint = "TOP",
				x = 0,
				y = -3,
			},

			LeaderIcon = {
				Point = "TOPLEFT",
				RelativePoint = "TOPLEFT",
				x = -2,
				y= 2,
			},

			MasterIcon = {
				Point = "TOPLEFT",
				RelativePoint = "TOPLEFT",
				x = -5,
				y= 2,
			},

			Portrait = {
				Point = "TOPLEFT",
				RelativePoint = "BOTTOMLEFT",
				RelativeTo = "HealthBar_BG",
				x = 0,
				y = 0,
				Height = 30,
				Width = 190,
				HeightAdd = 30,
				Visibility = {"Portrait","PortraitModel"},
			},
		},
		
		--[[target = {
			FrameHeight = 25,
			FrameWidth = 100,
			
			HitIndicator = {
				Point = "CENTER",
				RelativePoint = "CENTER",
				x = 1,
				y = 1,
			},
			
			Combo1 = {
				Point = "BOTTOMRIGHT",
				RelativePoint = "BOTTOMRIGHT",
				x = 1,
				y = -1,
				Height = 10,
				HeightAdd = 0,
				Width = 10,
			},

			HealthBar_BG = 	{
				Point = "TOPLEFT",
				RelativePoint = "TOPLEFT",
				RelativeTo = "frame",
				Width = 90,
				x = 5,
				y = -5,
				
				Visibility = {"HealthBar_BG","HealthBar","HealthText",},
				Height = 15,
				WidthFactor = 1,
			},

			ManaBar_BG = {
				Point = "TOPLEFT",
				RelativePoint = "BOTTOMLEFT",
				RelativeTo = "Portrait",
				x = 0,
				y = 0,
				
				Point2 = "TOPLEFT",
				RelativePoint2 = "BOTTOMLEFT",
				RelativeTo2 = "HealthBar_BG",
				x2 = 0,
				y2 = 0,
				
				HeightAdd = 5,
				Visibility = {"ManaBar_BG","ManaBar","ManaText","ClassText"},
				Height = 5,
				Width = 90,
				WidthFactor = 1,
			},

			XPBar_BG = {
				Hidden = true,
			},

			CastBar_BG = {
				Hidden = false,

				RelativeTo = "ManaBar_BG",
				Point = "TOPLEFT",
				RelativePoint = "BOTTOMLEFT",
				x = 0,
				y = -1,

				RelativeTo2 = "HealthBar_BG",
				Point2 = "TOPLEFT",
				RelativePoint2 = "BOTTOMLEFT",
				x2 = 0,
				y2 = -1,

				HeightAdd = 5,
				Visibility = {"CastBar_BG","CastBar","CastText", "BarCastText" },
				Width = 90,
				Height = 5,

				WidthFactor = 1,
			},

			NameLabel = {
				Type = "string",
				FontSize = 10,
				Point = "LEFT",
				RelativeTo = "HealthBar_BG",
				RelativePoint = "LEFT",
				x = 1.5,
				y =0,

				EndPoint = "RIGHT",
				EndRelativeTo = "HealthText",
				EndRelativePoint = "LEFT",
				Endx=2,
				Endy=0,
				Height = 10,
			},

			ClassText = {
				Type = "string",
				FontSize = 5,
				Justify = "LEFT",
				Point = "LEFT",
				RelativeTo = "ManaBar_BG",
				RelativePoint = "LEFT",
				x = 1.5,
				y = 0.5,

				EndPoint = "RIGHT",
				EndRelativeTo = "ManaText",
				EndRelativePoint = "LEFT",
				Endx=2,
				Endy=0,
				Height = 5,
			},

			HealthText = {
				Type = "string",
				FontSize = 10,
				Point = "RIGHT",
				RelativeTo = "HealthBar_BG",
				RelativePoint = "RIGHT",
				x=-1.5,
				y=0,
				Justify = "RIGHT",
				Height = 10,
				Width = 0,
			},

			ManaText = {
				Type = "string",
				FontSize = 5,
				Point = "RIGHT",
				RelativeTo = "ManaBar_BG",
				RelativePoint = "RIGHT",
				x= -1.5,
				y= 0.5,
				Justify = "RIGHT",
				Height = 5,
				Width = 0,
			},

			CastText = {
				RelativeTo = "CastBar_BG",
				Point = "RIGHT",
				RelativePoint = "RIGHT",
				x = -0.5,
				y = 0.5,
				
				FontSize = 5,
				Width = 60,
				Height = 5,
			},

			BarCastText = {
				RelativeTo = "CastBar_BG",
				Point = "LEFT",
				RelativePoint = "LEFT",
				x = 0.5,
				y = 0.5,

				Width = 60,
				Height = 5,

				FontSize = 5,
				Justify = "LEFT",

				EndPoint = "RIGHT",
				EndRelativeTo = "CastText",
				EndRelativePoint = "LEFT",
				Endx=0,
				Endy=0,
			},

			PVPIcon = {
				Point = "TOPLEFT",
				RelativePoint = "TOPLEFT",
				x = 0,
				y= 0,
			},

			InCombatIcon = {
				Point = "BOTTOMLEFT",
				RelativePoint = "BOTTOMLEFT",
				x = -4,
				y= -3,
			},

			RaidTargetIcon = {
				Point = "CENTER",
				RelativePoint = "TOP",
				x = 0,
				y = -3,
			},

			LeaderIcon = {
				Point = "TOPLEFT",
				RelativePoint = "TOPLEFT",
				x = -2,
				y= 2,
			},

			MasterIcon = {
				Point = "TOPLEFT",
				RelativePoint = "TOPLEFT",
				x = -5,
				y= 2,
			},

			Portrait = {
				Point = "TOPLEFT",
				RelativePoint = "BOTTOMLEFT",
				RelativeTo = "HealthBar_BG",
				x = 0,
				y = 0,
				Height = 20,
				Width = 90,
				HeightAdd = 20,
				Visibility = {"Portrait","PortraitModel"},
			},
		},]]
	},
}