aUF.fader = {}
aUF.fader.frames = {}

local frames = aUF.fader.frames

function aUF.fader.Fade(id, frame, duration)
	--MC_Print("Fading " .. tostring(id))
	frames[id] = { frame = frame, start = GetTime(), duration = duration }
	
	frame:Show()
	frame:SetAlpha(1)
end

function aUF.fader.OnUpdate()
	local alpha, now = 1, GetTime()
	
	for k,v in pairs(frames) do
		-- alpha = 1 - ((elapsed) / duration)
		a = 1 - ((now - v.start) / v.duration)
		
		if (a <= 0) then
			v.frame:SetAlpha(0)
			v.frame:Hide()
			
			frames[k] = nil
		else
			v.frame:SetAlpha(a)
		end
	end
end

function aUF.fader.UpdatePower(unitframe)
	unitframe.manavalue = unitframe.ManaBar:GetValue()
end

function aUF.fader.UpdateHealth(unitframe)
	unitframe.healthvalue = unitframe.HealthBar:GetValue()
	--aUF.fader.Fade(unitframe.frame:GetName() .. "hp", unitframe.HealthHighlight, 1)
end


function aUF.fader.PostUpdateHealth(unitframe)
	if (unitframe.HealthBar:GetValue() < unitframe.healthvalue) then
		aUF.fader.Fade(unitframe.frame:GetName() .. "hp", unitframe.HealthHighlight, 0.5)
		unitframe.HealthHighlight:SetStatusBarColor(1, 0.2, 0.2)
		unitframe.HealthHighlight:SetValue(unitframe.healthvalue)
	end
end

function aUF.fader.PostUpdatePower(unitframe)
	if (not unitframe.database.HideMana and unitframe.ManaBar:GetValue() < unitframe.manavalue) then
		aUF.fader.Fade(unitframe.frame:GetName() .. "mp", unitframe.ManaHighlight, 0.5)
		local r,g,b = unitframe.ManaBar:GetStatusBarColor();
		unitframe.ManaHighlight:SetStatusBarColor(r+0.2, g+0.2, b+0.2)
		unitframe.ManaBar:SetStatusBarColor(r, g, b, 1)
		unitframe.ManaHighlight:SetValue(unitframe.manavalue)
	end
end

function aUF.fader.CreateFrame(unitframe)
	unitframe.HealthHighlight = CreateFrame("StatusBar", "Health_Highlight", unitframe.frame);
	unitframe.ManaHighlight = CreateFrame("StatusBar", "Mana_Highlight", unitframe.frame);
	
	unitframe.HealthHighlight:SetStatusBarColor(1, 0, 0, 1)
	unitframe.ManaHighlight:SetStatusBarColor(0, 1, 1, 1)

	unitframe.HealthHighlight:SetFrameStrata("LOW")
	unitframe.ManaHighlight:SetFrameStrata("LOW")

	unitframe.HealthHighlight:SetMinMaxValues(0,100)
	unitframe.ManaHighlight:SetMinMaxValues(0,100)
	
	unitframe.HealthHighlight:Hide()
	unitframe.ManaHighlight:Hide()

	unitframe.HealthHighlight:SetFrameLevel(1)
	unitframe.ManaHighlight:SetFrameLevel(1)
end

function aUF.fader.ApplyTheme(unitframe)
	unitframe.HealthHighlight:SetAllPoints(unitframe.HealthBar_BG)
	unitframe.ManaHighlight:SetAllPoints(unitframe.ManaBar_BG)
end

function aUF.fader.BarTexture(unitframe)
	--local barstyle = aUF.db.profile.BarStyle
	unitframe.HealthHighlight:SetStatusBarTexture(unitframe.HealthBar:GetStatusBarTexture():GetTexture())
	unitframe.ManaHighlight:SetStatusBarTexture(unitframe.ManaBar:GetStatusBarTexture():GetTexture())
end

local function posthook(frame, key, func)
	local f = frame[key]
	
	frame[key] = function(self, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10)
		--ChatFrame3:AddMessage("Calling " .. key);
		a1, a2, a3, a4, a5, a6, a7, a8, a9, a10 = f(self, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10)
		func(self, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10)
		return a1, a2, a3, a4, a5, a6, a7, a8, a9, a10
	end
end

local function prehook(frame, key, func)
	local f = frame[key]
	
	frame[key] = function(self, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10)
		--ChatFrame3:AddMessage("Calling " .. key);
		func(self, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10)
		return f(self, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10)
	end
end

prehook(aUF.classes.aUFunit.prototype, "UpdatePower", aUF.fader.UpdatePower)
prehook(aUF.classes.aUFunit.prototype, "UpdateHealth", aUF.fader.UpdateHealth)
posthook(aUF.classes.aUFunit.prototype, "UpdatePower", aUF.fader.PostUpdatePower)
posthook(aUF.classes.aUFunit.prototype, "UpdateHealth", aUF.fader.PostUpdateHealth)
posthook(aUF.classes.aUFunit.prototype, "SetupFrame", aUF.fader.CreateFrame)
posthook(aUF.classes.aUFunit.prototype, "ApplyTheme", aUF.fader.ApplyTheme)
posthook(aUF.classes.aUFunit.prototype, "BarTexture", aUF.fader.BarTexture)

aUF.fader.frame = CreateFrame("Frame", "aUFFaderFrame", UIParent)
aUF.fader.frame:SetScript("OnUpdate", aUF.fader.OnUpdate)
