local aUFBanzai = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceHook-2.1")
local banzai = AceLibrary("LibBanzai-2.0")

local _G = getfenv(0)
local enabled = nil

local ignoredUnits = {
	["target"] = true,
	["targettarget"] = true,
	["targettargettarget"] = true,
}

function aUFBanzai:SafeHook(object, method, handler) if not self:IsHooked(object, method) then self:Hook(object, method, handler) end end
function aUFBanzai:SafeUnhook(object, method) if self:IsHooked(object, method) then self:Unhook(object, method) end end
function aUFBanzai:OnEnable() self:Enable() end

local function callback(aggro, name)
	for k, v in pairs(aUF.unitid) do
		if not ignoredUnits[k] and UnitIsUnit(name, k) then
			for obj, used in pairs(aUF.unitid[k]) do
				if used then
					if aggro == 1 then
						aUFBanzai:StyleUnit(obj)
					else
						aUFBanzai:ResetUnit(obj)
					end
				end
			end
		end
	end
end

function aUFBanzai:Enable()
	if enabled then return end
	banzai:RegisterCallback(callback)
	enabled = true
end

function aUFBanzai:Disable()
	if enabled then
		banzai:UnregisterCallback(callback)
		self:UnhookAll()
	end
	enabled = nil
end

function aUFBanzai:StyleUnit(unit)
	self:SafeHook(unit, "StatusBarsColor", "Noop")
	self:SafeHook(unit, "StatusBarsOnValueChanged", "Noop")
	unit.HealthBar:SetStatusBarColor(1, 0, 0)
end

function aUFBanzai:ResetUnit(unit)
	self:SafeUnhook(unit, "StatusBarsColor")
	self:SafeUnhook(unit, "StatusBarsOnValueChanged")
	unit:StatusBarsColor()
end

function aUFBanzai:Noop() return nil end

