local function cl(x,y) return "|cffffaaaa"..x..","..y.."|r" end
local function cq(q) return "|cffaaaaff`"..q.."'|r" end
ZygorGuidesViewer_AllianceGuide = {
	{ sectiontitle = "Human (1-13)",
	  defaultfor = "Human",
	  nextsection = 6,
	  steps = {
		{
			"Go to "..cl(48,43),
			"	a. Talk to Deputy Willem",
			"		i. Accept "..cq("A Threat Within"),
			completion={{questaccepted="A Threat Within"}},
			mapzone="Elwynn Forest",
			level=1,
			mapnote=42909110,
		}, {
			"Go northeast to "..cl(49,42),
			"	a. Talk to Marshal McBride",
			"		i. Turn in "..cq("A Threat Within"),
			"		ii. Accept "..cq("Kobold Camp Cleanup"),
			completion={{questturnedin="A Threat Within"},{questaccepted="Kobold Camp Cleanup"}},
			mapzone="Elwynn Forest",
			level=1,
			mapnote=41609050,
		}, {
			"Go southwest to "..cl(48,43),
			"	a. Talk to Deputy Willem",
			"		i. Accept "..cq("Eagan Peltskinner"),
			completion={{questaccepted="Eagan Peltskinner"}},
			mapzone="Elwynn Forest",
			level=1,
			mapnote=42909110,
		}, {
			"Go northeast to "..cl(49,40),
			"	a. Talk to Eagan Peltskinner",
			"		i. Turn in "..cq("Eagan Peltskinner"),
			"		ii. Accept "..cq("Wolves Across the Border"),
			completion={{questturnedin="Eagan Peltskinner"},{questaccepted="Wolves Across the Border"}},
			mapzone="Elwynn Forest",
			level=1,
			mapnote=40208910,
		}, {
			"Grind to level 2",
			completion={{level=2}},
			mapzone="Elwynn Forest",
			level=1,
		}, {
			"Go west to "..cl(47,40),
			"	a. Kill wolves",
			"	b. Get 8 Tough Wolf Meat",
			completion={{questgoal={"*","Tough Wolf Meat",8}}},
			mapzone="Elwynn Forest",
			level=2,
			mapnote=39708710,
		}, {
			"Go north to "..cl(48,37),
			"	a. Kill 10 Kobold Vermin",
			completion={{questgoal={"*","Kobold Vermin slain",10}}},
			mapzone="Elwynn Forest",
			level=2,
			mapnote=37108500,
		}, {
			"Grind to level 3",
			completion={{level=3}},
			mapzone="Elwynn Forest",
			level=2,
		}, {
			"Go southeast to "..cl(49,40),
			"	a. Talk to Eagan Peltskinner",
			"		i. Turn in "..cq("Wolves Across the Border"),
			completion={{questturnedin="Wolves Across the Border"}},
			mapzone="Elwynn Forest",
			level=3,
			mapnote=40208910,
		}, {
			"Go south to "..cl(49,42),
			"	a. Talk to Marshal McBride",
			"		i. Turn in "..cq("Kobold Camp Cleanup"),
			"		ii. Accept "..cq("Investigate Echo Ridge"),
			completion={{questturnedin="Kobold Camp Cleanup"},{questaccepted="Investigate Echo Ridge"}},
			mapzone="Elwynn Forest",
			level=3,
			mapnote=41609050,
		}, {
			"Go southwest to "..cl(48,43),
			"	a. Talk to Deputy Willem",
			"		i. Accept "..cq("Brotherhood of Thieves"),
			completion={{questaccepted="Brotherhood of Thieves"}},
			mapzone="Elwynn Forest",
			level=3,
			mapnote=42909110,
		}, {
			"Go northeast to "..cl(52,39),
			"	a. Kill 10 Kobold Workers",
			completion={{questgoal={"*","Kobold Workers slain",10}}},
			mapzone="Elwynn Forest",
			level=3,
			mapnote=38609020,
		}, {
			"Grind to level 4",
			completion={{level=4}},
			mapzone="Elwynn Forest",
			level=4,
		}, {
			"Go southeast to "..cl(54,41),
			"	a. Kill Defias mobs",
			"	b. Get 12 Red Burlap Bandanas",
			completion={{questgoal={"*","Red Burlap Bandana",12}}},
			mapzone="Elwynn Forest",
			level=4,
			mapnote=41009530,
		}, {
			"Go southwest to "..cl(48,43),
			"	a. Talk to Deputy Willem",
			"		i. Turn in "..cq("Brotherhood of Thieves"),
			"		ii. Accept "..cq("Milly Osworth"),
			"		iii. Accept "..cq("Bounty on Garrick Padfoot"),
			completion={{questturnedin="Brotherhood of Thieves"},{questaccepted="Milly Osworth"},{questaccepted="Bounty on Garrick Padfoot"}},
			mapzone="Elwynn Forest",
			level=4,
			mapnote=42909110,
		}, {
			"Go northeast to "..cl(49,42),
			"	a. Talk to Marshal McBride",
			"		i. Turn in "..cq("Investigate Echo Ridge"),
			"		ii. Accept "..cq("Skirmish at Echo Ridge"),
			completion={{questturnedin="Investigate Echo Ridge"},{questaccepted="Skirmish at Echo Ridge"}},
			mapzone="Elwynn Forest",
			level=4,
			mapnote=41609050,
		}, {
			"Go northeast to "..cl(51,39),
			"	a. Talk to Milly Osworth",
			"		i. Turn in "..cq("Milly Osworth"),
			"		ii. Accept "..cq("Milly's Harvest"),
			completion={{questturnedin="Milly Osworth"},{questaccepted="Milly's Harvest"}},
			mapzone="Elwynn Forest",
			level=4,
			mapnote=39309000,
		}, {
			"Go southeast to "..cl(54,48),
			"	a. Milly's Harvest look like barrels of grapes",
			"	b. Click Milly's Harvest barrels around the vineyard",
			"	c. Get 8 Milly's Harvest",
			completion={{questgoal={"*","Milly's Harvest",8}}},
			mapzone="Elwynn Forest",
			level=4,
			mapnote=47310090,
		}, {
			"Grind to level 5",
			completion={{level=5}},
			mapzone="Elwynn Forest",
			level=4,
		}, {
			"Go east to "..cl(54,48),
			"	a. Kill Garrick Padfoot",
			"	b. Get Garrick's Head",
			completion={{questgoal={"*","Garrick's Head",1}}},
			mapzone="Elwynn Forest",
			level=5,
			mapnote=48310580,
		}, {
			"Go northwest to "..cl(51,39),
			"	a. Talk to Milly Osworth",
			"		i. Turn in "..cq("Milly's Harvest"),
			"		ii. Accept "..cq("Grape Manifest"),
			completion={{questturnedin="Milly's Harvest"},{questaccepted="Grape Manifest"}},
			mapzone="Elwynn Forest",
			level=5,
			mapnote=39309000,
		}, {
			"Go southwest to "..cl(48,43),
			"	a. Talk to Deputy Willem",
			"		i. Turn in "..cq("Bounty on Garrick Padfoot"),
			completion={{questturnedin="Bounty on Garrick Padfoot"}},
			mapzone="Elwynn Forest",
			level=5,
			mapnote=42909110,
		}, {
			"Go into the church and up the spiral staircase to the very top",
			mapzone="Elwynn Forest",
			level=5,
		}, {
			"Go to "..cl(49,42),
			"	a. Talk to Brother Neals",
			"		i. Turn in "..cq("Grape Manifest"),
			completion={{questturnedin="Grape Manifest"}},
			mapzone="Elwynn Forest",
			level=5,
			mapnote=41609110,
		}, {
			"Go north to "..cl(48,32),
			"	a. Kill 12 Kobold Laborers inside the mine",
			completion={{questgoal={"*","Kobold Laborer slain",8}}},
			mapzone="Elwynn Forest",
			level=5,
			mapnote=32007970,
		}, {
			"Grind to level 6",
			completion={{level=6}},
			mapzone="Elwynn Forest",
			level=5,
		}, {
			"Hearth to Northshire Valley",
			completion={{location={mapzone="Elwynn Forest",x=48.1,y=43.7, dist=1}}},
			mapzone="Elwynn Forest",
			level=6,
		}, {
			"Go northeast to "..cl(49,42),
			"	a. Talk to Marshal McBride",
			"		i. Turn in "..cq("Skirmish at Echo Ridge"),
			"		ii. Accept "..cq("Report to Goldshire"),
			completion={{questturnedin="Skirmish at Echo Ridge"},{questaccepted="Report to Goldshire"}},
			mapzone="Elwynn Forest",
			level=6,
			mapnote=41609050,
		}, {
			"Go southwest to "..cl(46,48),
			"	a. Talk to Falkhaan Isenstrider",
			"		i. Accept "..cq("Rest and Relaxation"),
			completion={{questaccepted="Rest and Relaxation"}},
			mapzone="Elwynn Forest",
			level=6,
			mapnote=47709330,
		}, {
			"Go southwest to Goldshire",
			completion={{location={mapzone="Elwynn Forest",x=42.4,y=65.8, dist=2}}},
			mapzone="Elwynn Forest",
			level=6,
		}, {
			"Go to "..cl(42,66),
			"	a. Talk to Marshal Dughan",
			"		i. Turn in "..cq("Report to Goldshire"),
			"		ii. Accept "..cq("The Fargodeep Mine"),
			completion={{questturnedin="Report to Goldshire"},{questaccepted="The Fargodeep Mine"}},
			mapzone="Elwynn Forest",
			level=6,
			mapnote=65910800,
		}, {
			"Go to "..cl(43,66),
			"	a. Talk to William Pestle",
			"		i. Accept "..cq("Kobold Candles"),
			completion={{questaccepted="Kobold Candles"}},
			mapzone="Elwynn Forest",
			level=6,
			mapnote=65710900,
		}, {
			"Go to "..cl(44,66),
			"	a. Talk to Innkeeper Farley",
			"		i. Turn in "..cq("Rest and Relaxation"),
			completion={{questturnedin="Rest and Relaxation"}},
			mapzone="Elwynn Forest",
			level=6,
			mapnote=65810960,
		}, {
			"Make Goldshire your home",
			completion={{home="Goldshire"}},
			mapzone="Elwynn Forest",
			level=6,
		}, {
			"Go southwest to "..cl(42,67),
			"	a. Talk to Remy 'Two Times'",
			"		i. Accept "..cq("Gold Dust Exchange"),
			completion={{questaccepted="Gold Dust Exchange"}},
			mapzone="Elwynn Forest",
			level=6,
			mapnote=67310940,
		}, {
			"Go southwest to "..cl(39,83),
			"	a. Kill kobolds inside and around the mine",
			"	b. Get 10 Gold Dust",
			"	c. Get 8 Kobold Candles",
			completion={{questgoal={"*","Gold Dust",10}},{questgoal={"*","Large Candle",8}}},
			mapzone="Elwynn Forest",
			level=6,
			mapnote=82312130,
		}, {
			"Go northeast inside the mine to "..cl(41,79),
			"	a. Explore the Fargodeep Mine",
			completion={{location={mapzone="Elwynn Forest",x=41.2,y=78.9, dist=0.5}}},
			mapzone="Elwynn Forest",
			level=6,
			mapnote=79112040,
		}, {
			"Grind to level 7",
			completion={{level=7}},
			mapzone="Elwynn Forest",
			level=6,
		}, {
			"Go northeast to Goldshire",
			completion={{location={mapzone="Elwynn Forest",x=42.4,y=65.8, dist=2}}},
			mapzone="Elwynn Forest",
			level=7,
		}, {
			"Go to "..cl(42,67),
			"	a. Talk to Remy 'Two Times'",
			"		i. Turn in "..cq("Gold Dust Exchange"),
			"		ii. Accept "..cq("A Fishy Peril"),
			completion={{questturnedin="Gold Dust Exchange"},{questaccepted="A Fishy Peril"}},
			mapzone="Elwynn Forest",
			level=7,
			mapnote=67310940,
		}, {
			"Go to "..cl(42,66),
			"	a. Talk to Marshal Dughan",
			"		i. Turn in "..cq("The Fargodeep Mine"),
			"		ii. Accept "..cq("The Jasperlode Mine"),
			"		iii. Turn in "..cq("A Fishy Peril"),
			"		iv. Accept "..cq("Further Concerns"),
			completion={{questturnedin="The Fargodeep Mine"},{questaccepted="The Jasperlode Mine"},{questturnedin="A Fishy Peril"},{questaccepted="Further Concerns"}},
			mapzone="Elwynn Forest",
			level=7,
			mapnote=65910800,
		}, {
			"Go to "..cl(43,66),
			"	a. Talk to William Pestle",
			"		i. Turn in "..cq("Kobold Candles"),
			"		ii. Accept "..cq("Shipment to Stormwind"),
			completion={{questturnedin="Kobold Candles"},{questaccepted="Shipment to Stormwind"}},
			mapzone="Elwynn Forest",
			level=7,
			mapnote=65710900,
		}, {
			"Go southwest to "..cl(34,84),
			"	a. Talk to 'Auntie' Bernice Stonefield",
			"		i. Accept "..cq("Lost Necklace"),
			completion={{questaccepted="Lost Necklace"}},
			mapzone="Elwynn Forest",
			level=7,
			mapnote=84211870,
		}, {
			"Go east to "..cl(43,86),
			"	a. Talk to Billy Maclure",
			"		i. Turn in "..cq("Lost Necklace"),
			"		ii. Accept "..cq("Pie for Billy"),
			completion={{questturnedin="Lost Necklace"},{questaccepted="Pie for Billy"}},
			mapzone="Elwynn Forest",
			level=7,
			mapnote=85712880,
		}, {
			"Go southwest to "..cl(41,87),
			"	a. Kill boars",
			"	b. Get 4 Chunks of Boar Meat",
			completion={{questgoal={"*","Chunk of Boar Meat",4}}},
			mapzone="Elwynn Forest",
			level=7,
			mapnote=86912860,
		}, {
			"Go south to "..cl(43,90),
			"	a. Talk to Maybell Maclure",
			"		i. Accept "..cq("Young Lovers"),
			completion={{questaccepted="Young Lovers"}},
			mapzone="Elwynn Forest",
			level=7,
			mapnote=89613280,
		}, {
			"Grind to level 8",
			completion={{level=8}},
			mapzone="Elwynn Forest",
			level=7,
		}, {
			"Go west to "..cl(34,84),
			"	a. Talk to 'Auntie' Bernice Stonefield",
			"		i. Turn in "..cq("Pie for Billy"),
			"		ii. Accept "..cq("Back to Billy"),
			completion={{questturnedin="Pie for Billy"},{questaccepted="Back to Billy"}},
			mapzone="Elwynn Forest",
			level=8,
			mapnote=84211870,
		}, {
			"Go southwest to "..cl(30,86),
			"	a. Talk to Tommy Joe Stonefield",
			"		i. Turn in "..cq("Young Lovers"),
			"		ii. Accept "..cq("Speak with Gramma"),
			completion={{questturnedin="Young Lovers"},{questaccepted="Speak with Gramma"}},
			mapzone="Elwynn Forest",
			level=8,
			mapnote=86011580,
		}, {
			"Go northeast to "..cl(35,84),
			"	a. Talk to Gramma Stonefield",
			"		i. Turn in "..cq("Speak with Gramma"),
			"		ii. Accept "..cq("Note to William"),
			completion={{questturnedin="Speak with Gramma"},{questaccepted="Note to William"}},
			mapzone="Elwynn Forest",
			level=8,
			mapnote=83911880,
		}, {
			"Go east to "..cl(43,86),
			"	a. Talk to Billy Maclure",
			"		i. Turn in "..cq("Back to Billy"),
			"		ii. Accept "..cq("Goldtooth"),
			completion={{questturnedin="Back to Billy"},{questaccepted="Goldtooth"}},
			mapzone="Elwynn Forest",
			level=8,
			mapnote=85712880,
		}, {
			"Go northwest into the Fargodeep Mine",
			"	a. Enter using the lower entrance",
			completion={{location={mapzone="Elwynn Forest",x=38.3,y=81.6, dist=0.5}}},
			mapzone="Elwynn Forest",
			level=8,
		}, {
			"Follow the path inside the cave to "..cl(42,78),
			"	a. Kill Goldtooth",
			"	b. Get Bernice's Necklace",
			completion={{questgoal={"*","Bernice's Necklace",1}}},
			mapzone="Elwynn Forest",
			level=8,
			mapnote=78312000,
		}, {
			"Hearth to Goldshire",
			completion={{location={mapzone="Elwynn Forest",x=42.4,y=65.8, dist=2}}},
			mapzone="Elwynn Forest",
			level=8,
		}, {
			"Go to "..cl(43,66),
			"	a. Talk to William Pestle",
			"		i. Turn in "..cq("Note to William"),
			"		ii. Accept "..cq("Collecting Kelp"),
			completion={{questturnedin="Note to William"},{questaccepted="Collecting Kelp"}},
			mapzone="Elwynn Forest",
			level=8,
			mapnote=65710900,
		}, {
			"Go east to "..cl(50,66),
			"	a. Kill murlocs",
			"	b. Get 4 Crystal Kelp Fronds",
			completion={{questgoal={"*","Crystal Kelp Frond",4}}},
			mapzone="Elwynn Forest",
			level=8,
			mapnote=66311600,
		}, {
			"Go west to Goldshire",
			completion={{location={mapzone="Elwynn Forest",x=42.4,y=65.8, dist=2}}},
			mapzone="Elwynn Forest",
			level=8,
		}, {
			"Go to "..cl(43,66),
			"	a. Talk to William Pestle",
			"		i. Turn in "..cq("Collecting Kelp"),
			"		ii. Accept "..cq("The Escape"),
			completion={{questturnedin="Collecting Kelp"},{questaccepted="The Escape"}},
			mapzone="Elwynn Forest",
			level=8,
			mapnote=65710900,
		}, {
			"Go south to "..cl(43,90),
			"	a. Talk to Maybell Maclure",
			"		i. Turn in "..cq("The Escape"),
			completion={{questturnedin="The Escape"}},
			mapzone="Elwynn Forest",
			level=8,
			mapnote=89613280,
		}, {
			"Grind to level 9",
			completion={{level=9}},
			mapzone="Elwynn Forest",
			level=8,
		}, {
			"Go northwest to "..cl(34,84),
			"	a. Talk to 'Auntie' Bernice Stonefield",
			"		i. Turn in "..cq("Goldtooth"),
			completion={{questturnedin="Goldtooth"}},
			mapzone="Elwynn Forest",
			level=9,
			mapnote=84211870,
		}, {
			"Go northwest to "..cl(74,72),
			"	a. Talk to Guard Thomas",
			"		i. Turn in "..cq("Further Concerns"),
			"		ii. Accept "..cq("Find the Lost Guards"),
			"		iii. Accept "..cq("Protect the Frontier"),
			completion={{questturnedin="Further Concerns"},{questaccepted="Find the Lost Guards"},{questaccepted="Protect the Frontier"}},
			mapzone="Elwynn Forest",
			level=9,
			mapnote=72214620,
		}, {
			"Go northeast to "..cl(79,69),
			"	a. Talk to Sara Timberlain",
			"		i. Accept "..cq("Red Linen Goods"),
			completion={{questaccepted="Red Linen Goods"}},
			mapzone="Elwynn Forest",
			level=9,
			mapnote=68814830,
		}, {
			"Go northeast to "..cl(81,66),
			"	a. Talk to Supervisor Raelen",
			"		i. Accept "..cq("A Bundle of Trouble"),
			completion={{questaccepted="A Bundle of Trouble"}},
			mapzone="Elwynn Forest",
			level=9,
			mapnote=66114750,
		}, {
			"Go north to "..cl(81,60),
			"	a. Click the small stacks of wood at the base of trees in this area",
			"	b. Get 8 Bundles of Wood",
			completion={{questgoal={"*","Bundle of Wood",8}}},
			mapzone="Elwynn Forest",
			level=9,
			mapnote=60614190,
		}, {
			"Go west to "..cl(73,60),
			"	a. Click the Half-Eaten body",
			"		i. Turn in "..cq("Find the Lost Guards"),
			"		ii. Accept "..cq("Discover Rolf's Fate"),
			completion={{questturnedin="Find the Lost Guards"},{questaccepted="Discover Rolf's Fate"}},
			mapzone="Elwynn Forest",
			level=9,
			mapnote=60313300,
		}, {
			"Go northeast to "..cl(80,55),
			"	a. Click Rolf's Corpse",
			"		i. Turn in "..cq("Discover Rolf's Fate"),
			"		ii. Accept "..cq("Report to Thomas"),
			completion={{questturnedin="Discover Rolf's Fate"},{questaccepted="Report to Thomas"}},
			mapzone="Elwynn Forest",
			level=9,
			mapnote=55513530,
		}, {
			"Go to "..cl(81,66),
			"	a. Talk to Supervisor Raelen",
			"		i. Turn in "..cq("A Bundle of Trouble"),
			completion={{questturnedin="A Bundle of Trouble"}},
			mapzone="Elwynn Forest",
			level=9,
			mapnote=66114750,
		}, {
			"Go southwest to "..cl(74,72),
			"	a. Talk to Guard Thomas",
			"		i. Turn in "..cq("Report to Thomas"),
			"		ii. Accept "..cq("Deliver Thomas' Report"),
			completion={{questturnedin="Report to Thomas"},{questaccepted="Deliver Thomas' Report"}},
			mapzone="Elwynn Forest",
			level=9,
			mapnote=72214620,
		}, {
			"Go southeast to "..cl(80,78),
			"	a. Kill 8 Prowlers",
			"	b. Kill 5 Young Forest Bears",
			completion={{questgoal={"*","Prowler slain",8}},{questgoal={"*","Young Forest Bear slain",5}}},
			mapzone="Elwynn Forest",
			level=9,
			mapnote=77815780,
		}, {
			"Go southeast to "..cl(89,80),
			"	a. Kill Defias mobs",
			"	b. Get 6 Red Linen Bandanas",
			"	c. Get a Westfall Deed",
			"	d. Click the Westfall Deed",
			"		i. Accept "..cq("Furlbrow's Deed"),
			completion={{questgoal={"*","Red Linen Bandana",6}},{questaccepted="Furlbrow's Deed"}},
			mapzone="Elwynn Forest",
			level=9,
			mapnote=80216870,
		}, {
			"Grind to level 10",
			completion={{level=10}},
			mapzone="Elwynn Forest",
			level=9,
		}, {
			"Go northwest to "..cl(79,64),
			"	a. Talk to Sara Timberlain",
			"		i. Turn in "..cq("Red Linen Goods"),
			completion={{questturnedin="Red Linen Goods"}},
			mapzone="Elwynn Forest",
			level=10,
			mapnote=68814830,
		}, {
			"Go southwest to "..cl(74,72),
			"	a. Talk to Guard Thomas",
			"		i. Turn in "..cq("Protect the Frontier"),
			completion={{questturnedin="Protect the Frontier"}},
			mapzone="Elwynn Forest",
			level=10,
			mapnote=72214620,
		}, {
			"Go northwest to "..cl(60,50),
			"	a. Go inside the mine",
			"	b. Explore the Jasperlode Mine",
			completion={{location={mapzone="Elwynn Forest",x=60.5,y=50.0, dist=0.3}}},
			mapzone="Elwynn Forest",
			level=10,
			mapnote=49711010,
		}, {
			"Hearth to Goldshire",
			completion={{location={mapzone="Elwynn Forest",x=42.4,y=65.8, dist=2}}},
			mapzone="Elwynn Forest",
			level=10,
		}, {
			"Go to "..cl(42,66),
			"	a. Talk to Marshal Dughan",
			"		i. Turn in "..cq("The Jasperlode Mine"),
			"		ii. Turn in "..cq("Deliver Thomas' Report"),
			"		iii. Accept "..cq("Westbrook Garrison Needs Help!"),
			"	b. Talk to Smith Argus",
			"		i. Accept "..cq("Elmore's Task"),
			completion={{questturnedin="The Jasperlode Mine"},{questturnedin="Deliver Thomas' Report"},{questaccepted="Westbrook Garrison Needs Help!"},{questaccepted="Elmore's Task"}},
			mapzone="Elwynn Forest",
			level=10,
			mapnote=65910800,
		}, {
			"Grind to level 11",
			completion={{level=11}},
			mapzone="Elwynn Forest",
			level=10,
		}, {
			"Go northwest to Stormwind City",
			completion={{location={mapzone="Stormwind City"}}},
			mapzone="Elwynn Forest",
			level=11,
		}, {
			"Go to "..cl(56,65),
			"	a. Talk to Morgan Pestle",
			"		i. Turn in "..cq("Shipment to Stormwind"),
			completion={{questturnedin="Shipment to Stormwind"}},
			mapzone="Stormwind City",
			level=11,
			mapnote=64612080,
		}, {
			"Make Stormwind City your home",
			completion={{home="Stormwind City"}},
			mapzone="Stormwind City",
			level=11,
		}, {
			"Go to "..cl(52,12),
			"	a. Talk to Grimand Elmore",
			"		i. Turn in "..cq("Elmore's Task"),
			"		ii. Accept "..cq("Stormpike's Delivery"),
			completion={{questturnedin="Elmore's Task"},{questaccepted="Stormpike's Delivery"}},
			mapzone="Stormwind City",
			level=11,
			mapnote=12106390,
		}, {
			"Go to "..cl(64,8),
			"	a. Go into the Tram Station",
			completion={{location={mapzone="Stormwind City",x=60.3,y=12.6, dist=0.3}}},
			mapzone="Stormwind City",
			level=11,
			mapnote=8407220,
		}, {
			"Ride the tram to Ironforge",
			completion={{location={mapzone="City of Ironforge"}}},
			mapzone="Stormwind City",
			level=11,
		}, {
			"Go to "..cl(55,48),
			"	a. Talk to Gryth Thurden",
			"		i. Get the Ironforge Flight Path",
			completion={{flightpath="Ironforge"}},
			mapzone="Ironforge",
			level=11,
			mapnote=47710320,
		}, {
			"Go southeast to Loch Modan",
			completion={{location={mapzone="Loch Modan",x=19.7,y=62.8, dist=0.3}}},
			mapzone="Dun Morogh",
			level=11,
		}, {
			"Go south to "..cl(22,73),
			"	a. Talk to Mountaineer Cobbleflint",
			"		i. Accept "..cq("In Defense of the King's Lands part 1"),
			completion={{questaccepted="In Defense of the King's Lands part 1"}},
			mapzone="Loch Modan",
			level=11,
			mapnote=73109520,
		}, {
			"Go inside the big round building",
			mapzone="Loch Modan",
			level=11,
		}, {
			"Go to "..cl(23,74),
			"	a. Talk to Captain Rugelfuss",
			"		i. Accept "..cq("The Trogg Threat"),
			completion={{questaccepted="The Trogg Threat"}},
			mapzone="Loch Modan",
			level=11,
			mapnote=73709690,
		}, {
			"Go east to "..cl(31,71),
			"	a. Kill 10 Stonesplinter Troggs",
			"	b. Kill 10 Stonesplinter Scouts",
			"	c. Kill troggs",
			"	d. Get 8 Trogg Stone Teeth",
			completion={{questgoal={"*","Stonesplinter Trogg slain",10}},{questgoal={"*","Stonesplinter Scout slain",10}},{questgoal={"*","Trogg Stone Tooth",8}}},
			mapzone="Loch Modan",
			level=11,
			mapnote=70710180,
		}, {
			"Go west to "..cl(22,73),
			"	a. Talk to Mountaineer Cobbleflint",
			"		i. Turn in "..cq("In Defense of the King's Lands part 1"),
			completion={{questturnedin="In Defense of the King's Lands part 1"}},
			mapzone="Loch Modan",
			level=11,
			mapnote=73109520,
		}, {
			"Go inside the big round building",
			mapzone="Loch Modan",
			level=11,
		}, {
			"Go to "..cl(23,74),
			"	a. Talk to Captain Rugelfuss",
			"		i. Turn in "..cq("The Trogg Threat"),
			completion={{questturnedin="The Trogg Threat"}},
			mapzone="Loch Modan",
			level=11,
			mapnote=73709690,
		}, {
			"Grind to level 12",
			completion={{level=12}},
			mapzone="Loch Modan",
			level=11,
		}, {
			"Go northeast to Thelsamar",
			completion={{location={mapzone="Loch Modan",x=35.1,y=46.9, dist=3}}},
			mapzone="Loch Modan",
			level=12,
		}, {
			"Go to "..cl(34,51),
			"	a. Talk to Thorgrum Borrelson",
			"		i. Get the Thelsamar Flight Path",
			completion={{flightpath="Thelsamar"}},
			mapzone="Loch Modan",
			level=12,
			mapnote=51008490,
		}, {
			"Go to "..cl(35,47),
			"	a. Talk to Mountaineer Kadrell",
			"		i. He wanders around town",
			"		ii. Accept "..cq("Rat Catching"),
			completion={{questaccepted="Rat Catching"}},
			mapzone="Loch Modan",
			level=12,
			mapnote=47108190,
		}, {
			"Go to "..cl(35,49),
			"	a. Talk to Vidra Hearthstove",
			"		i. Accept "..cq("Thelsamar Blood Sausages"),
			completion={{questaccepted="Thelsamar Blood Sausages"}},
			mapzone="Loch Modan",
			level=12,
			mapnote=49308410,
		}, {
			"Go southeast to "..cl(40,53),
			"	a. Kill bears",
			"	b. Get 3 Bear Meat",
			completion={{questgoal={"*","Bear Meat",3}}},
			mapzone="Loch Modan",
			level=12,
			mapnote=53209360,
		}, {
			"Go northeast to "..cl(37,39),
			"	a. Kill boars",
			"	b. Get 3 Boar Intestines",
			completion={{questgoal={"*","Boar Intestines",3}}},
			mapzone="Loch Modan",
			level=12,
			mapnote=38907630,
		}, {
			"Go west to "..cl(34,39),
			"	a. Kill spiders here and across the road",
			"	b. Get 3 Spider Ichor",
			completion={{questgoal={"*","Spider Ichor",3}}},
			mapzone="Loch Modan",
			level=12,
			mapnote=38707240,
		}, {
			"Go northwest to "..cl(24,34),
			"	a. Kill Tunnel Rats",
			"	b. Get 12 Tunnel Rat Ears",
			completion={{questgoal={"*","Tunnel Rat Ear",12}}},
			mapzone="Loch Modan",
			level=12,
			mapnote=33605810,
		}, {
			"Make sure you have the following:",
			"	a. 3 Bear Meat",
			"	b. 3 Boar Intestines",
			"	c. 3 Spider Ichor",
			completion={{questgoal={"*","Bear Meat",3}},{questgoal={"*","Boar Intestines",3}},{questgoal={"*","Spider Ichor",3}}},
			mapzone="Loch Modan",
			level=12,
		}, {
			"Go to Thelsamar",
			completion={{location={mapzone="Loch Modan",x=35.1,y=46.9, dist=3}}},
			mapzone="Loch Modan",
			level=12,
		}, {
			"Go to "..cl(35,47),
			"	a. Talk to Mountaineer Kadrell",
			"		i. He wanders around town",
			"		ii. Turn in "..cq("Rat Catching"),
			completion={{questturnedin="Rat Catching"}},
			mapzone="Loch Modan",
			level=12,
			mapnote=47108190,
		}, {
			"Go to "..cl(35,49),
			"	a. Talk to Vidra Hearthstove",
			"		ii. Turn in "..cq("Thelsamar Blood Sausages"),
			completion={{questturnedin="Thelsamar Blood Sausages"}},
			mapzone="Loch Modan",
			level=12,
			mapnote=49308410,
		}, {
			"Hearth to Stormwind City",
			completion={{location={mapzone="Stormwind City"}}},
			mapzone="Loch Modan",
			level=12,
		}, {
			"Go outside to Elwynn Forest",
			completion={{location={mapzone="Elwynn Forest"}}},
			mapzone="Stormwind City",
			level=12,
		}, {
			"Go southwest to "..cl(24,75),
			"	a. Talk to Deputy Rainer",
			"		i. Turn in "..cq("Westbrook Garrison Needs Help!"),
			"		ii. Accept "..cq("Riverpaw Gnoll Bounty"),
			"	b. Click the Wanted Poster",
			"		i. Accept "..cq("Wanted: 'Hogger'"),
			completion={{questturnedin="Westbrook Garrison Needs Help!"},{questaccepted="Riverpaw Gnoll Bounty"},{questaccepted="Wanted: 'Hogger'"}},
			mapzone="Elwynn Forest",
			level=12,
			mapnote=74809910,
		}, {
			"Go southeast to "..cl(27,86),
			"	a. Kill gnolls",
			"	b. Get 8 Painted Gnoll Armbands",
			"	c. Hogger wanders around this area",
			"	d. Kill Hogger",
			"	e. Get the Huge Gnoll Claw",
			completion={{questgoal={"*","Painted Gnoll Armband",8}},{questgoal={"*","Huge Gnoll Claw",1}}},
			mapzone="Elwynn Forest",
			level=12,
			mapnote=86311310,
		}, {
			"Grind to level 13",
			completion={{level=13}},
			mapzone="Elwynn Forest",
			level=12,
		}, {
			"Go northwest to "..cl(24,75),
			"	a. Talk to Deputy Rainer",
			"		i. Turn in "..cq("Riverpaw Gnoll Bounty"),
			completion={{questturnedin="Riverpaw Gnoll Bounty"}},
			mapzone="Elwynn Forest",
			level=13,
			mapnote=74809910,
		}, {
			"Go northeast to Goldshire",
			completion={{location={mapzone="Elwynn Forest",x=42.4,y=65.8, dist=2}}},
			mapzone="Elwynn Forest",
			level=13,
		}, {
			"Go to "..cl(42,66),
			"	a. Talk to Marshal Dughan",
			"		i. Turn in "..cq("Wanted: 'Hogger'"),
			completion={{questturnedin="Wanted: 'Hogger'"}},
			mapzone="Elwynn Forest",
			level=13,
			mapnote=65910800,
		}, {
			"Go southwest to Westfall",
			completion={{location={mapzone="Westfall"}}},
			mapzone="Elwynn Forest",
			level=13,
		}
	  },
	},
	{ sectiontitle = "Night Elf (1-13)",
	  defaultfor = "NightElf",
	  nextsection = 6,
	  steps = {
		{
			"Go to "..cl(59,44),
			"	a. Talk to Conservator Ilthalaine",
			"		i. Accept "..cq("The Balance of Nature part 1"),
			completion={{questaccepted="The Balance of Nature part 1"}},
			mapzone="Teldrassil",
			level=1,
			mapnote=44310300,
		}, {
			"Go south to "..cl(59,46),
			"	a. Kill 7 Young Nightsabers",
			"	b. Kill 4 Young Thistle Boars",
			completion={{questgoal={"*","Young Nightsaber slain",7}},{questgoal={"*","Young Thistle Boar slain",4}}},
			mapzone="Teldrassil",
			level=1,
			mapnote=45910440,
		}, {
			"Grind to level 2",
			completion={{level=2}},
			mapzone="Teldrassil",
			level=1,
		}, {
			"Go north to "..cl(59,44),
			"	a. Talk to Conservator Ilthalaine",
			"		i. Turn in "..cq("The Balance of Nature part 1"),
			"		ii. Accept "..cq("The Balance of Nature part 2"),
			completion={{questturnedin="The Balance of Nature part 1"},{questaccepted="The Balance of Nature part 2"}},
			mapzone="Teldrassil",
			level=2,
			mapnote=44310300,
		}, {
			"Go northeast to "..cl(60,42),
			"	a. Talk to Melithar Staghelm",
			"		i. Accept "..cq("The Woodland Protector part 1"),
			completion={{questaccepted="The Woodland Protector part 1"}},
			mapzone="Teldrassil",
			level=2,
			mapnote=42510240,
		}, {
			"Go east to "..cl(61,42),
			"	a. Talk to Dirania Silvershine",
			"		i. Accept "..cq("A Good Friend"),
			completion={{questaccepted="A Good Friend"}},
			mapzone="Teldrassil",
			level=2,
			mapnote=42010290,
		}, {
			"Go southwest to "..cl(58,45),
			"	a. Talk to Tarindrella",
			"		i. Turn in "..cq("The Woodland Protector part 1"),
			"		ii. Accept "..cq("The Woodland Protector part 2"),
			completion={{questturnedin="The Woodland Protector part 1"},{questaccepted="The Woodland Protector part 2"}},
			mapzone="Teldrassil",
			level=2,
			mapnote=45310290,
		}, {
			"Go west to "..cl(57,46),
			"	a. Kill Grells",
			"	b. Get 8 Fel Moss",
			completion={{questgoal={"*","Fel Moss",8}}},
			mapzone="Teldrassil",
			level=2,
			mapnote=45510200,
		}, {
			"Grind to level 3",
			completion={{level=3}},
			mapzone="Teldrassil",
			level=2,
		}, {
			"Go east to "..cl(58,45),
			"	a. Talk to Tarindrella",
			"		i. Turn in "..cq("The Woodland Protector part 2"),
			completion={{questturnedin="The Woodland Protector part 2"}},
			mapzone="Teldrassil",
			level=3,
			mapnote=45310290,
		}, {
			"Go northeast to "..cl(58,42),
			"	a. Talk to Gilshalan Windwalker",
			"		i. Accept "..cq("Webwood Venom"),
			completion={{questaccepted="Webwood Venom"}},
			mapzone="Teldrassil",
			level=3,
			mapnote=41709950,
		}, {
			"Go northeast to "..cl(59,37),
			"	a. Kill 7 Mangy Nightsabers",
			"	b. Kill 7 Thistle Boars",
			completion={{questgoal={"*","Mangy Nightsaber slain",7}},{questgoal={"*","Thistle Boar slain",7}}},
			mapzone="Teldrassil",
			level=3,
			mapnote=36809560,
		}, {
			"Grind to level 4",
			completion={{level=4}},
			level=3,
		}, {
			"Go north to "..cl(58,33),
			"	a. Kill Webwood Spiders",
			"	b. Get 10 Webwood Venom Sacs",
			completion={{questgoal={"*","Webwood Venom Sac",10}}},
			mapzone="Teldrassil",
			level=4,
			mapnote=32909120,
		}, {
			"Go west to "..cl(55,33),
			"	a. Talk to Iverron",
			"		i. Turn in "..cq("A Good Friend"),
			"		ii. Accept "..cq("A Friend in Need"),
			completion={{questturnedin="A Good Friend"},{questaccepted="A Friend in Need"}},
			mapzone="Teldrassil",
			level=4,
			mapnote=33008760,
		}, {
			"Go southeast to "..cl(58,42),
			"	a. Talk to Gilshalan Windwalker",
			"		i. Turn in "..cq("Webwood Venom"),
			"		ii. Accept "..cq("Webwood Egg"),
			completion={{questturnedin="Webwood Venom"},{questaccepted="Webwood Egg"}},
			mapzone="Teldrassil",
			level=4,
			mapnote=41709950,
		}, {
			"Go southeast to "..cl(59,44),
			"	a. Talk to Conservator Ilthalaine",
			"		i. Turn in "..cq("The Balance of Nature part 2"),
			completion={{questturnedin="The Balance of Nature part 2"}},
			mapzone="Teldrassil",
			level=4,
			mapnote=44310300,
		}, {
			"Grind to level 5",
			completion={{level=5}},
			mapzone="Teldrassil",
			level=4,
		}, {
			"Go northeast to "..cl(61,42),
			"	a. Talk to Dirania Silvershine",
			"		i. Turn in "..cq("A Friend in Need"),
			"		ii. Accept "..cq("Iverron's Antidote part 1"),
			completion={{questturnedin="A Friend in Need"},{questaccepted="Iverron's Antidote part 1"}},
			mapzone="Teldrassil",
			level=5,
			mapnote=42010290,
		}, {
			"Go southeast to "..cl(62,43),
			"	a. Click the big pink mushrooms at the base of the trees around this area",
			"	b. Get 7 Hyacinth Mushrooms",
			completion={{questgoal={"*","Hyacinth Mushroom",7}}},
			mapzone="Teldrassil",
			level=5,
			mapnote=43110540,
		}, {
			"Go northwest to "..cl(58,39),
			"	a. Click the tall flowers with orange petals around the ponds",
			"	b. Get 4 Moonpetal Lilies",
			completion={{questgoal={"*","Moonpetal Lily",4}}},
			mapzone="Teldrassil",
			level=5,
			mapnote=38509620,
		}, {
			"Go north to "..cl(57,32),
			"	a. Kill Webwood Spiders",
			"	b. Get a Webwood Ichor",
			completion={{questgoal={"*","Webwood Ichor",1}}},
			mapzone="Teldrassil",
			level=5,
			mapnote=32108880,
		}, {
			"Go into the cave",
			"	a. Follow the path in the middle, then go left",
			"	b. Go up to the ledge above",
			completion={{location={mapzone="Teldrassil",x=55.8,y=25.5, dist=0.5}}},
			mapzone="Teldrassil",
			level=5,
		}, {
			"Go to "..cl(57,26),
			"	a. Click a shaking white egg",
			"	b. Get a Webwood Egg",
			completion={{questgoal={"*","Webwood Egg",1}}},
			mapzone="Teldrassil",
			level=5,
			mapnote=26408310,
		}, {
			"Leave the cave",
			completion={{location={mapzone="Teldrassil",x=56.8,y=32.0, dist=0.5}}},
			mapzone="Teldrassil",
			level=5,
		}, {
			"Grind to level 6",
			completion={{level=6}},
			mapzone="Teldrassil",
			level=5,
		}, {
			"Go south to "..cl(58,42),
			"	a. Talk to Gilshalan Windwalker",
			"		i. Turn in "..cq("Webwood Egg"),
			"		ii. Accept "..cq("Tenaron's Summons"),
			completion={{questturnedin="Webwood Egg"},{questaccepted="Tenaron's Summons"}},
			mapzone="Teldrassil",
			level=6,
			mapnote=41709950,
		}, {
			"Follow the ramp to the top of the tree",
			completion={{location={mapzone="Teldrassil",x=59.4,y=39.0, dist=0.5}}},
			mapzone="Teldrassil",
			level=6,
		}, {
			"Go to "..cl(59,39),
			"	a. Talk to Tenaron Stormgrip",
			"		i. Turn in "..cq("Tenaron's Summons"),
			"		ii. Accept "..cq("Crown of the Earth part 1"),
			completion={{questturnedin="Tenaron's Summons"},{questaccepted="Crown of the Earth part 1"}},
			mapzone="Teldrassil",
			level=6,
			mapnote=39409850,
		}, {
			"Go southeast to "..cl(61,42),
			"	a. Talk to Dirania Silvershine",
			"		i. Turn in "..cq("Iverron's Antidote part 1"),
			"		ii. Accept "..cq("Iverron's Antidote part 2"),
			completion={{questturnedin="Iverron's Antidote part 1"},{questaccepted="Iverron's Antidote part 2"}},
			mapzone="Teldrassil",
			level=6,
			mapnote=42010290,
		}, {
			"Go northwest to "..cl(55,33),
			"	a. Talk to Iverron",
			"		i. Turn in "..cq("Iverron's Antidote part 2"),
			completion={{questturnedin="Iverron's Antidote part 2"}},
			mapzone="Teldrassil",
			level=6,
			mapnote=33008760,
		}, {
			"Go east to "..cl(60,33),
			"	a. Use your Crystal Phial in the moonwell water",
			"	b. Get a Filled Crystal Phial",
			completion={{questgoal={"*","Filled Crystal Phial",1}}},
			mapzone="Teldrassil",
			level=6,
			mapnote=33109300,
		}, {
			"Go south to "..cl(59,39),
			"	a. Talk to Tenaron Stormgrip",
			"		i. Go to the top of the big tree",
			"		ii. Turn in "..cq("Crown of the Earth part 1"),
			"		iii. Accept "..cq("Crown of the Earth part 2"),
			completion={{questturnedin="Crown of the Earth part 1"},{questaccepted="Crown of the Earth part 2"}},
			mapzone="Teldrassil",
			level=6,
			mapnote=39409850,
		}, {
			"Go southeast to "..cl(61,48),
			"	a. Talk to Porthannius",
			"		i. Accept "..cq("Dolanaar Delivery"),
			completion={{questaccepted="Dolanaar Delivery"}},
			mapzone="Teldrassil",
			level=6,
			mapnote=47610880,
		}, {
			"Go south to "..cl(60,56),
			"	a. Talk to Zenn Foulhoof",
			"		i. Accept "..cq("Zenn's Bidding"),
			completion={{questaccepted="Zenn's Bidding"}},
			mapzone="Teldrassil",
			level=6,
			mapnote=56311670,
		}, {
			"Go northeast to "..cl(64,54),
			"	a. Kill Strigid Owls",
			"	b. Get 3 Strigid Owl Feathers",
			completion={{questgoal={"*","Strigid Owl Feather",3}}},
			mapzone="Teldrassil",
			level=6,
			mapnote=54211800,
		}, {
			"Go southwest to "..cl(61,58),
			"	a. Kill Webwood Lurkers",
			"	b. Get 3 Webwood Spider Silk",
			"	c. Kill Nightsabers",
			"	d. Get 3 Nightsaber Fangs",
			completion={{questgoal={"*","Webwood Spider Silk",3}},{questgoal={"*","Nightsaber Fang",3}}},
			mapzone="Teldrassil",
			level=6,
			mapnote=58211880,
		}, {
			"Go north to "..cl(60,56),
			"	a. Talk to Zenn Foulhoof",
			"		i. Turn in "..cq("Zenn's Bidding"),
			completion={{questturnedin="Zenn's Bidding"}},
			mapzone="Teldrassil",
			level=6,
			mapnote=56311670,
		}, {
			"Go west to Dolanaar",
			completion={{location={mapzone="Teldrassil",x=56.1,y=58.2, dist=2}}},
			mapzone="Teldrassil",
			level=6,
		}, {
			"Go to "..cl(56,58),
			"	a. Talk to Syral Bladeleaf",
			"		i. Accept "..cq("Seek Redemption!"),
			"		ii. Accept "..cq("Denalan's Earth"),
			completion={{questaccepted="Seek Redemption!"},{questaccepted="Denalan's Earth"}},
			mapzone="Teldrassil",
			level=6,
			mapnote=57711380,
		}, {
			"Go to "..cl(56,57),
			"	a. Talk to Athridas Bearmantle",
			"		i. Accept "..cq("A Troubling Breeze"),
			completion={{questaccepted="A Troubling Breeze"}},
			mapzone="Teldrassil",
			level=6,
			mapnote=57311330,
		}, {
			"Go to the top of the tower",
			completion={{location={mapzone="Teldrassil",x=55.0,y=57.2, dist=0.3}}},
			mapzone="Teldrassil",
			level=6,
		}, {
			"Go to "..cl(56,57),
			"	a. Talk to Tallonkai Swiftroot",
			"		i. Accept "..cq("The Emerald Dreamcatcher"),
			"		ii. Accept "..cq("Twisted Hatred"),
			completion={{questaccepted="The Emerald Dreamcatcher"},{questaccepted="Twisted Hatred"}},
			mapzone="Teldrassil",
			level=6,
			mapnote=56911250,
		}, {
			"Go to "..cl(56,60),
			"	a. Talk to Innkeeper Keldamyr",
			"		i. Turn in "..cq("Dolanaar Delivery"),
			completion={{questturnedin="Dolanaar Delivery"}},
			mapzone="Teldrassil",
			level=6,
			mapnote=59811540,
		}, {
			"Make Dolanaar your home",
			completion={{home="Dolanaar"}},
			mapzone="Teldrassil",
			level=6,
		}, {
			"Go to "..cl(56,62),
			"	a. Talk to Corithras Moonrage",
			"		i. Turn in "..cq("Crown of the Earth part 2"),
			"		ii. Accept "..cq("Crown of the Earth part 3"),
			completion={{questturnedin="Crown of the Earth part 2"},{questaccepted="Crown of the Earth part 3"}},
			mapzone="Teldrassil",
			level=6,
			mapnote=61711780,
		}, {
			"Grind to level 7",
			completion={{level=7}},
			mapzone="Teldrassil",
			level=6,
		}, {
			"Go east to "..cl(63,58),
			"	a. Use your Jade Phial in the moonwell water",
			"	b. Get a Filled Jade Phial",
			completion={{questgoal={"*","Filled Jade Phial",1}}},
			mapzone="Teldrassil",
			level=7,
			mapnote=58112140,
		}, {
			"Go east to "..cl(66,59),
			"	a. Talk to Gaerolas Talvethren",
			"		i. Turn in "..cq("A Troubling Breeze"),
			"		ii. Accept "..cq("Gnarlpine Corruption"),
			completion={{questturnedin="A Troubling Breeze"},{questaccepted="Gnarlpine Corruption"}},
			mapzone="Teldrassil",
			level=7,
			mapnote=58512480,
		}, {
			"Go southeast to "..cl(68,60),
			"	a. Click Tallonkai's Dresser",
			"	b. Get the Emerald Dreamcatcher",
			completion={{questgoal={"*","Emerald Dreamcatcher",1}}},
			mapzone="Teldrassil",
			level=7,
			mapnote=59612760,
		}, {
			"Go southeast to "..cl(64,62),
			"	a. Click the big, brown, green smoking pine cones at the base of trees",
			"	b. Get 3 Fel Cones",
			completion={{questgoal={"*","Fel Cone",3}}},
			mapzone="Teldrassil",
			level=7,
			mapnote=62312590,
		}, {
			"Go west to Dolanaar",
			completion={{location={mapzone="Teldrassil",x=56.1,y=58.2, dist=3}}},
			mapzone="Teldrassil",
			level=7,
		}, {
			"Go to "..cl(56,57),
			"	a. Talk to Athridas Bearmantle",
			"		i. Turn in "..cq("Gnarlpine Corruption"),
			"		ii. Accept "..cq("The Relics of Wakening"),
			completion={{questturnedin="Gnarlpine Corruption"},{questaccepted="The Relics of Wakening"}},
			mapzone="Teldrassil",
			level=7,
			mapnote=57311330,
		}, {
			"Go to the top of the tower",
			completion={{location={mapzone="Teldrassil",x=55.0,y=57.2, dist=0.3}}},
			mapzone="Teldrassil",
			level=7,
		}, {
			"Go to "..cl(56,57),
			"	a. Talk to Tallonkai Swiftroot",
			"		i. Turn in "..cq("The Emerald Dreamcatcher"),
			"		ii. Accept "..cq("Ferocitas the Dream Eater"),
			completion={{questturnedin="The Emerald Dreamcatcher"},{questaccepted="Ferocitas the Dream Eater"}},
			mapzone="Teldrassil",
			level=7,
			mapnote=56911250,
		}, {
			"Go to "..cl(56,52),
			"	a. Talk to Corithras Moonrage",
			"		i. Turn in "..cq("Crown of the Earth part 3"),
			"		ii. Accept "..cq("Crown of the Earth part 4"),
			completion={{questturnedin="Crown of the Earth part 3"},{questaccepted="Crown of the Earth part 4"}},
			mapzone="Teldrassil",
			level=7,
			mapnote=61711780,
		}, {
			"Go east to "..cl(60,56),
			"	a. Talk to Zenn Foulhoof",
			"		i. Turn in "..cq("Seek Redemption!"),
			completion={{questturnedin="Seek Redemption!"}},
			mapzone="Teldrassil",
			level=7,
			mapnote=56311670,
		}, {
			"Grind to level 8",
			completion={{level=8}},
			mapzone="Teldrassil",
			level=7,
		}, {
			"Go south to "..cl(61,68),
			"	a. Talk to Denalan",
			"		i. Turn in "..cq("Denalan's Earth"),
			"		ii. Accept "..cq("Timberling Seeds"),
			"		iii. Accept "..cq("Timberling Sprouts"),
			completion={{questturnedin="Denalan's Earth"},{questaccepted="Timberling Seeds"},{questaccepted="Timberling Sprouts"}},
			mapzone="Teldrassil",
			level=8,
			mapnote=68512940,
		}, {
			"Go north to "..cl(61,67),
			"	a. Kill Timberlings",
			"	b. Get 8 Timberling Seeds",
			"	c. Click the brown and green bulbs on the ground",
			"	d. Get 12 Timberling Sprouts",
			completion={{questgoal={"*","Timberling Seed",8}},{questgoal={"*","Timberling Sprout",12}}},
			mapzone="Teldrassil",
			level=8,
			mapnote=66812800,
		}, {
			"Go south to "..cl(61,68),
			"	a. Talk to Denalan",
			"		i. Turn in "..cq("Timberling Seeds"),
			"		ii. Accept "..cq("Rellian Greenspyre"),
			"		iii. Turn in "..cq("Timberling Sprouts"),
			completion={{questturnedin="Timberling Seeds"},{questaccepted="Rellian Greenspyre"},{questturnedin="Timberling Sprouts"}},
			mapzone="Teldrassil",
			level=8,
			mapnote=68512940,
		}, {
			"Go northeast to "..cl(68,54),
			"	a. Kill 7 Gnarlpine Mystics",
			completion={{questgoal={"*","Gnarlpine Mystic slain",7}}},
			mapzone="Teldrassil",
			level=8,
			mapnote=53712200,
		}, {
			"Go east to "..cl(69,53),
			"	a. Kill Ferocitas the Dream Eater",
			"	b. Get the Gnarlpine Necklace",
			"	c. Click the Gnarlpine Necklace",
			"	d. Get Tallonkai's Jewel",
			completion={{questgoal={"*","Tallonkai's Jewel",1}}},
			mapzone="Teldrassil",
			level=8,
			mapnote=53312270,
		}, {
			"Grind to level 9",
			completion={{level=9}},
			mapzone="Teldrassil",
			level=8,
		}, {
			"Go west to Dolanaar",
			completion={{location={mapzone="Teldrassil",x=56.1,y=58.2, dist=3}}},
			mapzone="Teldrassil",
			level=9,
		}, {
			"Go to "..cl(56,57),
			"	a. Talk to Tallonkai Swiftroot",
			"		i. Go to the top of the tower",
			"		ii. Turn in "..cq("Ferocitas the Dream Eater"),
			completion={{questturnedin="Ferocitas the Dream Eater"}},
			mapzone="Teldrassil",
			level=9,
			mapnote=56911250,
		}, {
			"Go west to "..cl(52,56),
			"	a. Talk to Moon Priestess Amara",
			"		i. She walks the road from Dolanaar to Darnassus back and forth",
			"		ii. Accept "..cq("The Road to Darnassus"),
			completion={{questaccepted="The Road to Darnassus"}},
			mapzone="Teldrassil",
			level=9,
			mapnote=56510890,
		}, {
			"Go northwest to "..cl(47,54),
			"	a. Kill 6 Gnarlpine Ambushers",
			completion={{questgoal={"*","Gnarlpine Ambusher slain",6}}},
			mapzone="Teldrassil",
			level=9,
			mapnote=53510020,
		}, {
			"Go southwest into the cave at "..cl(44,59),
			completion={{location={mapzone="Teldrassil",x=44.4,y=57.8, dist=0.5}}},
			mapzone="Teldrassil",
			level=9,
		}, {
			"Go to "..cl(44,61),
			"	a. Click the Chest of the Black Feather",
			"	b. Get the Black Feather Quill",
			completion={{questgoal={"*","Black Feather Quill",1}}},
			mapzone="Teldrassil",
			level=9,
			mapnote=61210490,
		}, {
			"Go to "..cl(44,60),
			"	a. Click the Chest of Nesting",
			"	b. Get the Rune of Nesting",
			completion={{questgoal={"*","Rune of Nesting",1}}},
			mapzone="Teldrassil",
			level=9,
			mapnote=60710510,
		}, {
			"Go down to the middle layer of the cave",
			mapzone="Teldrassil",
			level=9,
		}, {
			"Go to "..cl(45,62),
			"	a. Talk to Oben Rageclaw",
			"		i. Accept "..cq("The Sleeping Druid"),
			completion={{questaccepted="The Sleeping Druid"}},
			mapzone="Teldrassil",
			level=9,
			mapnote=61610650,
		}, {
			"Go through the tunnel out of the room",
			mapzone="Teldrassil",
			level=9,
		}, {
			"Go to "..cl(46,59),
			"	a. Kill Gnarlpine Shamans",
			"	b. Get a Shaman Voodoo Charm",
			completion={{questgoal={"*","Shaman Voodoo Charm",1}}},
			mapzone="Teldrassil",
			level=9,
			mapnote=58710430,
		}, {
			"Go to "..cl(46,57),
			"	a. Click the Chest of the Raven Claw",
			"	b. Get the Raven Claw Talisman",
			completion={{questgoal={"*","Raven Claw Talisman",1}}},
			mapzone="Teldrassil",
			level=9,
			mapnote=57410310,
		}, {
			"Go to "..cl(45,62),
			"	a. Talk to Oben Rageclaw",
			"		i. Turn in "..cq("The Sleeping Druid"),
			"		ii. Accept "..cq("Druid of the Claw"),
			completion={{questturnedin="The Sleeping Druid"},{questaccepted="Druid of the Claw"}},
			mapzone="Teldrassil",
			level=9,
			mapnote=61610650,
		}, {
			"Go to "..cl(46,59),
			"	a. Kill Rageclaw",
			"	b. Use the Voodoo Charm on his corpse",
			mapzone="Teldrassil",
			level=9,
			mapnote=58710430,
		}, {
			"Go through the tunnel back to where Oben Rageclaw is",
			"	a. Follow the path down to the left",
			mapzone="Teldrassil",
			level=9,
		}, {
			"Go to "..cl(45,63),
			"	a. Click the Chest of the Sky",
			"	b. Get the Sapphire of Sky",
			completion={{questgoal={"*","Sapphire of Sky",1}}},
			mapzone="Teldrassil",
			level=9,
			mapnote=62510720,
		}, {
			"Go back up the path",
			mapzone="Teldrassil",
			level=9,
		}, {
			"Go to "..cl(45,62),
			"	a. Talk to Oben Rageclaw",
			"		i. Turn in "..cq("Druid of the Claw"),
			completion={{questturnedin="Druid of the Claw"}},
			mapzone="Teldrassil",
			level=9,
			mapnote=61610650,
		}, {
			"Grind to level 10",
			completion={{level=10}},
			mapzone="Teldrassil",
			level=9,
		}, {
			"Hearth to Dolanaar",
			completion={{location={mapzone="Teldrassil",x=55.7,y=59.8, dist=0.3}}},
			mapzone="Teldrassil",
			level=10,
		}, {
			"Go to "..cl(56,57),
			"	a. Talk to Athridas Bearmantle",
			"		i. Turn in "..cq("The Relics of Wakening"),
			"		ii. Accept "..cq("Ursal the Mauler"),
			completion={{questturnedin="The Relics of Wakening"},{questaccepted="Ursal the Mauler"}},
			mapzone="Teldrassil",
			level=10,
			mapnote=57311330,
		}, {
			"Go north to Fel Rock",
			completion={{location={mapzone="Teldrassil",x=54.7,y=52.8, dist=0.5}}},
			mapzone="Teldrassil",
			level=10,
		}, {
			"Go inside the cave",
			"	a. Follow the path to the right",
			mapzone="Teldrassil",
			level=10,
		}, {
			"Go to "..cl(53,50),
			"	a. Kill Lord Melenas",
			"	b. Get Melenas' Head",
			completion={{questgoal={"*","Melenas' Head",1}}},
			mapzone="Teldrassil",
			level=10,
			mapnote=50210300,
		}, {
			"Go south to Dolanaar",
			completion={{location={mapzone="Teldrassil",x=56.1,y=58.2, dist=3}}},
			mapzone="Teldrassil",
			level=10,
		}, {
			"Go to "..cl(56,57),
			"	a. Talk to Tallonkai Swiftroot",
			"		i. Go to the top of the tower",
			"		ii. Turn in "..cq("Twisted Hatred"),
			completion={{questturnedin="Twisted Hatred"}},
			mapzone="Teldrassil",
			level=10,
			mapnote=56911250,
		}, {
			"Go southwest to "..cl(42,67),
			"	a. Use your Tourmaline Phial in the moonwell water",
			"	b. Get a Filled Tourmaline Phial",
			completion={{questgoal={"*","Filled Tourmaline Phial",1}}},
			mapzone="Teldrassil",
			level=10,
			mapnote=67110950,
		}, {
			"Go southeast to "..cl(39,80),
			"	a. Kill Ursal the Mauler",
			completion={{questgoal={"*","Ursal the Mauler slain",1}}},
			mapzone="Teldrassil",
			level=10,
			mapnote=80111930,
		}, {
			"Go northeast to Dolanaar",
			completion={{location={mapzone="Teldrassil",x=56.1,y=58.2, dist=3}}},
			mapzone="Teldrassil",
			level=10,
		}, {
			"Go to "..cl(56,62),
			"	a. Talk to Corithras Moonrage",
			"		i. Turn in "..cq("Crown of the Earth part 4"),
			completion={{questturnedin="Crown of the Earth part 4"}},
			mapzone="Teldrassil",
			level=10,
			mapnote=61711780,
		}, {
			"Go to "..cl(56,57),
			"	a. Talk to Athridas Bearmantle",
			"		i. Turn in "..cq("Ursal the Mauler"),
			completion={{questturnedin="Ursal the Mauler"}},
			mapzone="Teldrassil",
			level=10,
			mapnote=57311330,
		}, {
			"Grind to level 11",
			completion={{level=11}},
			mapzone="Teldrassil",
			level=10,
		}, {
			"Go west to "..cl(52,57),
			"	a. Talk to Moon Priestess Amara",
			"		i. She walks the road from Dolanaar to Darnassus back and forth",
			"		ii. Turn in "..cq("The Road to Darnassus"),
			completion={{questturnedin="The Road to Darnassus"}},
			mapzone="Teldrassil",
			level=11,
			mapnote=56510890,
		}, {
			"Go west to Darnassus",
			completion={{location={mapzone="Darnassus"}}},
			mapzone="Teldrassil",
			level=11,
		}, {
			"Go to "..cl(71,45),
			"	a. Talk to Mydrannul",
			"		i. Accept "..cq("Nessa Shadowsong"),
			completion={{questaccepted="Nessa Shadowsong"}},
			mapzone="Darnassus",
			level=11,
			mapnote=45411610,
		}, {
			"Go to "..cl(38,22),
			"	a. Talk to Rellian Greenspyre",
			"		i. Turn in "..cq("Rellian Greenspyre"),
			completion={{questturnedin="Rellian Greenspyre"}},
			mapzone="Darnassus",
			level=11,
			mapnote=21605980,
		}, {
			"Go to "..cl(31,42),
			"	a. Go into the pink portal to Rut'theran Village",
			completion={{location={mapzone="Teldrassil",x=56.3,y=92.4, dist=6}}},
			mapzone="Darnassus",
			level=11,
		}, {
			"Go to "..cl(56,92),
			"	a. Talk to Nessa Shadowsong",
			"		i. Turn in "..cq("Nessa Shadowsong"),
			"		ii. Accept "..cq("The Bounty of Teldrassil"),
			completion={{questturnedin="Nessa Shadowsong"},{questaccepted="The Bounty of Teldrassil"}},
			mapzone="Teldrassil",
			level=11,
			mapnote=92414870,
		}, {
			"Go to "..cl(58,94),
			"	a. Talk to Vesprystus",
			"		i. Turn in "..cq("The Bounty of Teldrassil"),
			"		ii. Accept "..cq("Flight to Auberdine"),
			completion={{questturnedin="The Bounty of Teldrassil"},{questaccepted="Flight to Auberdine"}},
			mapzone="Teldrassil",
			level=11,
			mapnote=94015240,
		}, {
			"Fly to Auberdine",
			completion={{location={mapzone="Darkshore",x=36.4,y=45.6, dist=0.3}}},
			mapzone="Teldrassil",
			level=11,
		}, {
			"Go to "..cl(37,44),
			"	a. Talk to Laird",
			"		i. Turn in "..cq("Flight to Auberdine"),
			"		ii. Accept "..cq("Return to Nessa"),
			completion={{questturnedin="Flight to Auberdine"},{questaccepted="Return to Nessa"}},
			mapzone="Darkshore",
			level=11,
			mapnote=44308110,
		}, {
			"Fly to Rut'theran Village",
			completion={{location={mapzone="Teldrassil",x=56.3,y=92.4, dist=6}}},
			mapzone="Darkshore",
			level=11,
		}, {
			"Go to "..cl(56,92),
			"	a. Talk to Nessa Shadowsong",
			"		i. Turn in "..cq("Return to Nessa"),
			completion={{questturnedin="Return to Nessa"}},
			mapzone="Teldrassil",
			level=11,
			mapnote=92414870,
		}, {
			"Fly to Auberdine",
			completion={{location={mapzone="Darkshore",x=36.4,y=45.6, dist=0.3}}},
			mapzone="Teldrassil",
			level=11,
		}, {
			"Ride the boat to Menethil Harbor",
			completion={{location={mapzone="Wetlands",x=4.6,y=56.8, dist=9}}},
			mapzone="Darkshore",
			level=11,
		}, {
			"Go to "..cl(9,60),
			"	a. Talk to Shellei Brondir",
			"		i. Get the Menethil Harbor Flight Path",
			completion={{flightpath="Menethil Harbor"}},
			mapzone="Wetlands",
			level=11,
			mapnote=59706920,
		}, {
			"Follow the road southeast to Loch Modan",
			completion={{location={mapzone="Loch Modan",x=25.6,y=10.6, dist=1}}},
			mapzone="Wetlands",
			level=11,
		}, {
			"Go southeast to Thelsamar",
			completion={{location={mapzone="Loch Modan",x=35.1,y=46.9, dist=3}}},
			mapzone="Loch Modan",
			level=11,
		}, {
			"Go to "..cl(34,51),
			"	a. Talk to Thorgrum Borrelson",
			"		i. Get the Thelsamar Flight Path",
			completion={{flightpath="Thelsamar"}},
			mapzone="Loch Modan",
			level=11,
			mapnote=51008490,
		}, {
			"Go southwest to Dun Morogh",
			completion={{location={mapzone="Dun Morogh",x=86.2,y=51.3, dist=1}}},
			mapzone="Loch Modan",
			level=11,
		}, {
			"Go northwest to Ironforge",
			completion={{location={mapzone="City of Ironforge"}}},
			mapzone="Dun Morogh",
			level=11,
		}, {
			"Go to "..cl(56,48),
			"	a. Talk to Gryth Thurden",
			"		i. Get the Ironforge Flight Path",
			completion={{flightpath="Ironforge"}},
			mapzone="Ironforge",
			level=11,
			mapnote=47710320,
		}, {
			"Go to the Deeprun Tram",
			completion={{location={mapzone="Deeprun Tram"}}},
			mapzone="Ironforge",
			level=11,
		}, {
			"Ride the tram to Stormwind City",
			completion={{location={mapzone="Stormwind City"}}},
			mapzone="Ironforge",
			level=11,
		}, {
			"Go to "..cl(66,62),
			"	a. Talk to Dungar Longdrink",
			"		i. Get the Stormwind City Flight Path",
			completion={{flightpath="Stormwind City"}},
			mapzone="Stormwind City",
			level=11,
			mapnote=62112840,
		}, {
			"Go southeast to Goldshire",
			completion={{location={mapzone="Elwynn Forest",x=42.4,y=65.8, dist=2}}},
			mapzone="Elwynn Forest",
			level=11,

		}, {
			"Go to "..cl(42,66),
			"	a. Talk to Marshal Dughan",
			"		i. Accept "..cq("The Fargodeep Mine"),
			completion={{questaccepted="The Fargodeep Mine"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=65910800,
		}, {
			"Go to "..cl(43,66),
			"	a. Talk to William Pestle",
			"		i. Accept "..cq("Kobold Candles"),
			completion={{questaccepted="Kobold Candles"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=65710900,
		}, {
			"Make Goldshire your home",
			completion={{home="Goldshire"}},
			mapzone="Elwynn Forest",
			level=11,
		}, {
			"Go to "..cl(42,67),
			"	a. Talk to Remy 'Two Times'",
			"		i. Accept "..cq("Gold Dust Exchange"),
			completion={{questaccepted="Gold Dust Exchange"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=67310940,
		}, {
			"Go southwest to "..cl(39,82),
			"	a. Kill kobolds",
			"	b. Get 8 Kobold Candles",
			"	c. Get 10 Gold Dust",
			completion={{questgoal={"*","Large Candle",8}},{questgoal={"*","Gold Dust",10}}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=82312130,
		}, {
			"Go northwest to "..cl(41,79),
			"	a. Explore Fargodeep Mine",
			completion={{location={mapzone="Elwynn Forest",x=41.2,y=78.9, dist=0.5}}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=79112040,
		}, {
			"Go southwest to "..cl(35,84),
			"	a. Talk to 'Auntie' Bernice Stonefield",
			"		i. Accept "..cq("Lost Necklace"),
			completion={{questaccepted="Lost Necklace"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=84211870,
		}, {
			"Go east to "..cl(43,86),
			"	a. Talk to Billy Maclure",
			"		i. Turn in "..cq("Lost Necklace"),
			"		ii. Accept "..cq("Pie for Billy"),
			completion={{questturnedin="Lost Necklace"},{questaccepted="Pie for Billy"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=85712880,
		}, {
			"Go southwest to "..cl(42,87),
			"	a. Kill boars",
			"	b. Get 4 Chunks of Boar Meat",
			completion={{questgoal={"*","Chunk of Boar Meat",4}}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=86912860,
		}, {
			"Go southeast to "..cl(43,90),
			"	a. Talk to Maybell Maclure",
			"		i. Accept "..cq("Young Lovers"),
			completion={{questaccepted="Young Lovers"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=89613280,
		}, {
			"Go northwest to "..cl(35,84),
			"	a. Talk to 'Auntie' Bernice Stonefield",
			"		i. Turn in "..cq("Pie for Billy"),
			"		ii. Accept "..cq("Back to Billy"),
			completion={{questturnedin="Pie for Billy"},{questaccepted="Back to Billy"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=84211870,
		}, {
			"Go west to "..cl(30,86),
			"	a. Talk to Tommy Joe Stonefield",
			"		i. Turn in "..cq("Young Lovers"),
			"		ii. Accept "..cq("Speak with Gramma"),
			completion={{questturnedin="Young Lovers"},{questaccepted="Speak with Gramma"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=86011580,
		}, {
			"Go east "..cl(35,84),
			"	a. Talk to Gramma Stonefield",
			"		i. Turn in "..cq("Speak with Gramma"),
			"		ii. Accept "..cq("Note to William"),
			completion={{questturnedin="Speak with Gramma"},{questaccepted="Note to William"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=83911880,
		}, {
			"Go east to "..cl(43,86),
			"	a. Talk to Billy Maclure",
			"		i. Turn in "..cq("Back to Billy"),
			"		ii. Accept "..cq("Goldtooth"),
			completion={{questturnedin="Back to Billy"},{questaccepted="Goldtooth"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=85712880,
		}, {
			"Go northwest into the Fargodeep Mine",
			"	a. Enter using the lower entrance",
			completion={{location={mapzone="Elwynn Forest",x=38.3,y=81.6, dist=0.5}}},
			mapzone="Elwynn Forest",
			level=11,
		}, {
			"Follow the path inside the cave to "..cl(42,78),
			"	a. Kill Goldtooth",
			"	b. Get Bernice's Necklace",
			completion={{questgoal={"*","Bernice's Necklace",1}}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=78312000,
		}, {
			"Hearth to Goldshire",
			completion={{location={mapzone="Elwynn Forest",x=42.4,y=65.8, dist=2}}},
			mapzone="Elwynn Forest",
			level=11,
		}, {
			"Go to "..cl(42,67),
			"	a. Talk to Remy 'Two Times'",
			"		i. Turn in "..cq("Gold Dust Exchange"),
			"		ii. Accept "..cq("A Fishy Peril"),
			completion={{questturnedin="Gold Dust Exchange"},{questaccepted="A Fishy Peril"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=67310940,
		}, {			
			"Go to "..cl(42,66),
			"	a. Talk to Marshal Dughan",
			"		i. Turn in "..cq("The Fargodeep Mine"),
			"		ii. Turn in "..cq("A Fishy Peril"),
			"		iii. Accept "..cq("The Jasperlode Mine"),
			"		iv. Accept "..cq("Further Concerns"),
			completion={{questturnedin="The Fargodeep Mine"},{questturnedin="A Fishy Peril"},{questaccepted="The Jasperlode Mine"},{questaccepted="Further Concerns"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=65910800,
		}, {
			"Go to "..cl(43,66),
			"	a. Talk to William Pestle",
			"		i. Turn in "..cq("Kobold Candles"),
			"		ii. Turn in "..cq("Note to William"),
			"		iii. Accept "..cq("Collecting Kelp"),
			completion={{questturnedin="Kobold Candles"},{questturnedin="Note to William"},{questaccepted="Collecting Kelp"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=65710900,
		}, {
			"Go east to "..cl(50,66),
			"	a. Kill murlocs",
			"	b. Get 4 Crystal Kelp Fronds",
			completion={{questgoal={"*","Crystal Kelp Frond",4}}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=66311600,
		}, {
			"Go west to Goldshire",
			completion={{location={mapzone="Elwynn Forest",x=42.4,y=65.8, dist=2}}},
			mapzone="Elwynn Forest",
			level=11,
		}, {
			"Go to "..cl(43,66),
			"	a. Talk to William Pestle",
			"		i. Turn in "..cq("Collecting Kelp"),
			"		ii. Accept "..cq("The Escape"),
			completion={{questturnedin="Collecting Kelp"},{questaccepted="The Escape"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=65710900,
		}, {
			"Go south to "..cl(43,90),
			"	a. Talk to Maybell Maclure",
			"		i. Turn in "..cq("The Escape"),
			completion={{questturnedin="The Escape"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=89613280,
		}, {
			"Go northwest to "..cl(34,84),
			"	a. Talk to 'Auntie' Bernice Stonefield",
			"		i. Turn in "..cq("Goldtooth"),
			completion={{questturnedin="Goldtooth"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=84211870,
		}, {
			"Go northeast to "..cl(74,72),
			"	a. Talk to Guard Thomas",
			"		i. Turn in "..cq("Further Concerns"),
			"		ii. Accept "..cq("Find the Lost Guards"),
			"		iii. Accept "..cq("Protect the Frontier"),
			completion={{questturnedin="Further Concerns"},{questaccepted="Find the Lost Guards"},{questaccepted="Protect the Frontier"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=72214620,
		}, {
			"Go northeast to "..cl(80,69),
			"	a. Talk to Sara Timberlain",
			"		i. Accept "..cq("Red Linen Goods"),
			completion={{questaccepted="Red Linen Goods"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=68814830,
		}, {
			"Go northeast to "..cl(81,66),
			"	a. Talk to Supervisor Raelen",
			"		i. Accept "..cq("A Bundle of Trouble"),
			completion={{questaccepted="A Bundle of Trouble"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=66114750,
		}, {
			"Go north to "..cl(81,61),
			"	a. Get 8 Bundles of Wood",
			completion={{questgoal={"*","Bundle of Wood",8}}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=60614190,
		}, {
			"Go west to "..cl(73,60),
			"	a. Click the Half-Eaten Body",
			"		i. Turn in "..cq("Find the Lost Guards"),
			"		ii. Accept "..cq("Discover Rolf's Fate"),
			completion={{questturnedin="Find the Lost Guards"},{questaccepted="Discover Rolf's Fate"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=60313300,
		}, {
			"Go northeast to "..cl(80,56),
			"	a. Click Rolf's Corpse",
			"		i. Turn in "..cq("Discover Rolf's Fate"),
			"		ii. Accept "..cq("Report to Thomas"),
			completion={{questturnedin="Discover Rolf's Fate"},{questaccepted="Report to Thomas"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=55513530,
		}, {
			"Go south to "..cl(81,66),
			"	a. Talk to Supervisor Raelen",
			"		i. Turn in "..cq("A Bundle of Trouble"),
			completion={{questturnedin="A Bundle of Trouble"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=66114750,
		}, {
			"Go south to "..cl(80,78),
			"	a. Kill 8 Prowlers",
			"	b. Kill 5 Young Forest Bears",
			completion={{questgoal={"*","Prowler slain",8}},{questgoal={"*","Young Forest Bear slain",5}}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=77815780,
		}, {
			"Go east to "..cl(88,80),
			"	a. Kill Defias mobs",
			"	b. Get 6 Red Linen Bandanas",
			"	c. Get a Westfall Deed",
			"	d. Click the Westfall Deed",
			"		i. Accept "..cq("Furlbrow's Deed"),
			completion={{questgoal={"*","Red Linen Bandana",6}},{questaccepted="Furlbrow's Deed"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=80216870,
		}, {
			"Go northwest to "..cl(80,69),
			"	a. Talk to Sara Timberlain",
			"		i. Turn in "..cq("Red Linen Goods"),
			completion={{questturnedin="Red Linen Goods"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=68814830,
		}, {
			"Go southwest to "..cl(74,72),
			"	a. Talk to Guard Thomas",
			"		i. Turn in "..cq("Protect the Frontier"),
			"		ii. Turn in "..cq("Report to Thomas"),
			"		iii. Accept "..cq("Deliver Thomas' Report"),
			completion={{questturnedin="Protect the Frontier"},{questturnedin="Report to Thomas"},{questaccepted="Deliver Thomas' Report"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=72214620,
		}, {
			"Go northwest to "..cl(60,50),
			"	a. Explore Jasperlode Mine",
			completion={{location={mapzone="Elwynn Forest",x=60.5,y=50.0, dist=0.3}}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=49711010,
		}, {
			"Hearth to Goldshire",
			completion={{location={mapzone="Elwynn Forest",x=42.4,y=65.8, dist=2}}},
			mapzone="Elwynn Forest",
			level=11,
		}, {
			"Go to "..cl(42,67),
			"	a. Talk to Marshal Dughan",
			"		i. Turn in "..cq("Deliver Thomas' Report"),
			"		ii. Turn in "..cq("The Jasperlode Mine"),
			"		iii. Accept "..cq("Westbrook Garrison Needs Help!"),
			completion={{questturnedin="Deliver Thomas' Report"},{questturnedin="The Jasperlode Mine"},{questaccepted="Westbrook Garrison Needs Help!"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=65910800,
		}, {
			"Go southwest to "..cl(24,75),
			"	a. Talk to Deputy Rainer",
			"		i. Turn in "..cq("Westbrook Garrison Needs Help!"),
			"		ii. Accept "..cq("Riverpaw Gnoll Bounty"),
			"	b. Click the Wanted Poster",
			"		i. Accept "..cq("Wanted: 'Hogger'"),
			completion={{questturnedin="Westbrook Garrison Needs Help!"},{questaccepted="Riverpaw Gnoll Bounty"},{questaccepted="Wanted: 'Hogger'"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=74809910,
		}, {
			"Go southeast to "..cl(27,86),
			"	a. Kill Riverpaw gnolls",
			"	b. Get 8 Painted Gnoll Armbands",
			"	c. Kill Hogger",
			"	d. Get the Huge Gnoll Claw",
			completion={{questgoal={"*","Painted Gnoll Armband",8}},{questgoal={"*","Huge Gnoll Claw",1}}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=86311310,
		}, {
			"Go northeast to Goldshire",
			completion={{location={mapzone="Elwynn Forest",x=42.4,y=65.8, dist=2}}},
			mapzone="Elwynn Forest",
			level=11,
		}, {
			"Go to "..cl(42,67),
			"	a. Talk to Marshal Dughan",
			"		i. Turn in "..cq("Wanted: 'Hogger'"),
			completion={{questturnedin="Wanted: 'Hogger'"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=65910800,
		}, {
			"Go southwest to "..cl(24,75),
			"	a. Talk to Deputy Rainer",
			"		i. Turn in "..cq("Riverpaw Gnoll Bounty"),
			completion={{questturnedin="Riverpaw Gnoll Bounty"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=74809910,
		}, {
			"Grind to level 13",
			completion={{level=13}},
			mapzone="Elwynn Forest",
			level=12,
		}, {
			"Go west to Westfall",
			completion={{location={mapzone="Westfall"}}},
			mapzone="Elwynn Forest",
			level=13,
		}
	  },
	},
	{ sectiontitle = "Gnome (1-13)",
	  defaultfor = "Gnome",
	  nextsection = 6,
	  steps = {
		{
			"Go to "..cl(30,71),
			"	a. Talk to Sten Stoutarm",
			"		i. Accept "..cq("Dwarven Outfitters"),
			completion={{questaccepted="Dwarven Outfitters"}},
			mapzone="Dun Morogh",
			level=1,
			mapnote=71310110,
		}, {
			"Go south to "..cl(29,74),
			"	a. Kill wolves",
			"	b. Get 8 Tough Wolf Meat",
			completion={{questgoal={"*","Tough Wolf Meat",8}}},
			mapzone="Dun Morogh",
			level=1,
			mapnote=74010300,
		}, {
			"Grind to level 2",
			completion={{level=2}},
			mapzone="Dun Morogh",
			level=1,
		}, {
			"Go north to "..cl(30,71),
			"	a. Talk to Sten Stoutarm",
			"		i. Turn in "..cq("Dwarven Outfitters"),
			"		ii. Accept "..cq("Coldridge Valley Mail Delivery part 1"),
			"	b. Talk to Balir Frosthammer",
			"		i. Accept "..cq("A New Threat"),
			completion={{questturnedin="Dwarven Outfitters"},{questaccepted="Coldridge Valley Mail Delivery part 1"},{questaccepted="A New Threat"}},
			mapzone="Dun Morogh",
			level=2,
			mapnote=71310110,
		}, {
			"Go southeast to "..cl(31,75),
			"	a. Kill 6 Rockjaw Troggs",
			"	b. Kill 6 Burly Rockjaw Troggs",
			completion={{questgoal={"*","Rockjaw Trogg slain",6}},{questgoal={"*","Burly Rockjaw Trogg slain",6}}},
			mapzone="Dun Morogh",
			level=2,
			mapnote=75010600,
		}, {
			"Grind to level 3",
			completion={{level=3}},
			mapzone="Dun Morogh",
			level=2,
		}, {
			"Go northwest to "..cl(30,71),
			"	a. Talk to Balir Frosthammer",
			"		i. Turn in "..cq("A New Threat"),
			completion={{questturnedin="A New Threat"}},
			mapzone="Dun Morogh",
			level=3,
			mapnote=71310110,
		}, {
			"Go northwest to Anvilmar",
			completion={{location={mapzone="Dun Morogh",x=28.8,y=69.8, dist=0.3}}},
			mapzone="Dun Morogh",
			level=3,
		}, {
			"Go to "..cl(29,68),
			"	a. Talk to Felix Whindlebolt",
			"		i. Accept "..cq("A Refugee's Quandary"),
			completion={{questaccepted="A Refugee's Quandary"}},
			mapzone="Dun Morogh",
			level=3,
			mapnote=67709620,
		}, {
			"Go southwest to "..cl(23,71),
			"	a. Talk to Talin Keeneye",
			"		i. Turn in "..cq("Coldridge Valley Mail Delivery part 1"),
			"		ii. Accept "..cq("Coldridge Valley Mail Delivery part 2"),
			"		iii. Accept "..cq("The Boar Hunter"),
			completion={{questturnedin="Coldridge Valley Mail Delivery part 1"},{questaccepted="Coldridge Valley Mail Delivery part 2"},{questaccepted="The Boar Hunter"}},
			mapzone="Dun Morogh",
			level=3,
			mapnote=71409400,
		}, {
			"Go northwest to "..cl(22,70),
			"	a. Kill 12 Small Crag Boars",
			completion={{questgoal={"*","Small Crag Boar slain",12}}},
			mapzone="Dun Morogh",
			level=3,
			mapnote=70009200,
		}, {
			"Grind to level 4",
			completion={{level=4}},
			mapzone="Dun Morogh",
			level=3,
		}, {
			"Go southeast to "..cl(23,71),
			"	a. Talk to Talin Keeneye",
			"		i. Turn in "..cq("The Boar Hunter"),
			completion={{questturnedin="The Boar Hunter"}},
			mapzone="Dun Morogh",
			level=4,
			mapnote=71409400,
		}, {
			"Go southeast to "..cl(25,76),
			"	a. Talk to Grelin Whitebeard",
			"		i. Turn in "..cq("Coldridge Valley Mail Delivery part 2"),
			"		ii. Accept "..cq("The Troll Cave"),
			completion={{questturnedin="Coldridge Valley Mail Delivery part 2"},{questaccepted="The Troll Cave"}},
			mapzone="Dun Morogh",
			level=4,
			mapnote=76010100,
		}, {
			"Go southeast to "..cl(26,79),
			"	a. Get Felix's Bucket of Bolts",
			"	b. Kill 14 Frostmane Troll Whelps",
			completion={{questgoal={"*","Felix's Bucket of Bolts",1}},{questgoal={"*","Frostmane Troll Whelp slain",14}}},
			mapzone="Dun Morogh",
			level=4,
			mapnote=79310560,
		}, {
			"Grind to level 5",
			completion={{level=5}},
			mapzone="Dun Morogh",
			level=4,
		}, {
			"Go northwest to "..cl(25,76),
			"	a. Talk to Grelin Whitebeard",
			"		i. Turn in "..cq("The Troll Cave"),
			"		ii. Accept "..cq("The Stolen Journal"),
			completion={{questturnedin="The Troll Cave"},{questaccepted="The Stolen Journal"}},
			mapzone="Dun Morogh",
			level=5,
			mapnote=76010100,
		}, {
			"Go southeast to "..cl(31,80),
			"	a. Kill Grik'nir the Cold",
			"	b. Get Grelin Whitebeard's Journal",
			completion={{questgoal={"*","Grelin Whitebeard's Journal",1}}},
			mapzone="Dun Morogh",
			level=5,
			mapnote=80211070,
		}, {
			"Go west to "..cl(23,80),
			"	a. Get Felix's Chest",
			completion={{questgoal={"*","Felix's Chest",1}}},
			mapzone="Dun Morogh",
			level=5,
			mapnote=80010280,
		}, {
			"Go northwest to "..cl(21,76),
			"	a. Get Felix's Box",
			completion={{questgoal={"*","Felix's Box",1}}},
			mapzone="Dun Morogh",
			level=5,
			mapnote=76109700,
		}, {
			"Go east to "..cl(23,71),
			"	a. Talk to Grelin Whitebeard",
			"		i. Turn in "..cq("The Stolen Journal"),
			"		ii. Accept "..cq("Senir's Observations part 1"),
			"	b. Talk to Nori Pridedrift",
			"		i. Accept "..cq("Scalding Mornbrew Delivery"),
			completion={{questturnedin="The Stolen Journal"},{questaccepted="Senir's Observations part 1"},{questaccepted="Scalding Mornbrew Delivery"}},
			mapzone="Dun Morogh",
			level=5,
			mapnote=76010100,
		}, {
			"Grind to level 6",
			completion={{level=6}},
			mapzone="Dun Morogh",
			level=5,
		}, {
			"Go northeast to Anvilmar",
			completion={{location={mapzone="Dun Morogh",x=28.8,y=69.8, dist=0.3}}},
			mapzone="Dun Morogh",
			level=6,
		}, {
			"Go to "..cl(29,68),
			"	a. Talk to Felix Whindlebolt",
			"		i. Turn in "..cq("A Refugee's Quandary"),
			completion={{questturnedin="A Refugee's Quandary"}},
			mapzone="Dun Morogh",
			level=6,
			mapnote=67709620,
		}, {
			"Go to "..cl(29,66),
			"	a. Talk to Durnan Furcutter",
			"		i. Turn in "..cq("Scalding Mornbrew Delivery"),
			"		ii. Accept "..cq("Bring Back the Mug"),
			completion={{questturnedin="Scalding Mornbrew Delivery"},{questaccepted="Bring Back the Mug"}},
			mapzone="Dun Morogh",
			level=6,
			mapnote=66409520,
		}, {
			"Go southwest to "..cl(23,71),
			"	a. Talk to Nori Pridedrift",
			"		i. Turn in "..cq("Bring Back the Mug"),
			completion={{questturnedin="Bring Back the Mug"}},
			mapzone="Dun Morogh",
			level=6,
			mapnote=76010100,
		}, {
			"Go northeast to "..cl(34,72),
			"	a. Talk to Mountaineer Thalos",
			"		i. Turn in "..cq("Senir's Observations part 1"),
			"		ii. Accept "..cq("Senir's Observations part 2"),
			"	b. Talk to Hands Springsprocket",
			"		i. Accept "..cq("Supplies to Tannok"),
			completion={{questturnedin="Senir's Observations part 1"},{questaccepted="Senir's Observations part 2"},{questaccepted="Supplies to Tannok"}},
			mapzone="Dun Morogh",
			level=6,
			mapnote=71810530,
		}, {
			"Go through the tunnel to the other side",
			completion={{location={mapzone="Dun Morogh",x=35.6,y=65.8, dist=0.3}}},
			mapzone="Dun Morogh",
			level=6,
		}, {
			"Go northeast to Kharanos",
			completion={{location={mapzone="Dun Morogh",x=46.4,y=53.0, dist=2.5}}},
			mapzone="Dun Morogh",
			level=6,
		}, {
			"Go to "..cl(47,54),
			"	a. Talk to Senir Whitebeard",
			"		i. Turn in "..cq("Senir's Observations part 2"),
			completion={{questturnedin="Senir's Observations part 2"}},
			mapzone="Dun Morogh",
			level=6,
			mapnote=53810050,
		}, {
			"Go to "..cl(47,52),
			"	a. Talk to Ragnar Thunderbrew",
			"		i. Accept "..cq("Beer Basted Boar Ribs"),
			completion={{questaccepted="Beer Basted Boar Ribs"}},
			mapzone="Dun Morogh",
			level=6,
			mapnote=52409920,
		}, {
			"Also at "..cl(47,52),	
			"	a.Talk to Tannok Frosthammer",
			"		i. Turn in "..cq("Supplies to Tannok"),
			"	b. Talk to Innkeeper Belm",
			"		i. Buy a Rhapsody Malt",
			completion={{questturnedin="Supplies to Tannok"},{questgoal={"*","Rhapsody Malt",1}}},
			mapzone="Dun Morogh",
			level=6,
			mapnote=52309960,
		}, {
			"Make Kharanos your home",
			completion={{home="Kharanos"}},
			mapzone="Dun Morogh",
			level=6,
		}, {
			"Go to "..cl(46,52),
			"	a. Talk to Tharek Blackstone",
			"		i. Accept "..cq("Tools for Steelgrill"),
			completion={{questaccepted="Tools for Steelgrill"}},
			mapzone="Dun Morogh",
			level=6,
			mapnote=51709770,
		}, {
			"Go northeast to "..cl(50,49),
			"	a. Talk to Beldin Steelgrill",
			"		i. Turn in "..cq("Tools for Steelgrill"),
			completion={{questturnedin="Tools for Steelgrill"}},
			mapzone="Dun Morogh",
			level=6,
			mapnote=49109950,
		}, {
			"Also at "..cl(50,49),	
			"	a. Talk to Pilot Bellowfiz",
			"		i. Accept "..cq("Stocking Jetsteam"),
			"	b. Talk to Pilot Stonegear",
			"		i. Accept "..cq("The Grizzled Den"),
			completion={{questaccepted="Stocking Jetsteam"},{questaccepted="The Grizzled Den"}},
			mapzone="Dun Morogh",
			level=6,
			mapnote=48509810,
		}, {
			"Also at "..cl(50,49),	
			"	a. Talk to Loslor Rudge",
			"		i. Accept "..cq("Ammo for Rumbleshot"),
			completion={{questaccepted="Ammo for Rumbleshot"}},
			mapzone="Dun Morogh",
			level=6,
			mapnote=49409950,
		}, {
			"Go south to "..cl(50,51),
			"	a. Kill boars and bears",
			"	b. Get 4 Chunks of Boar Meat",
			"	c. Get 6 Crag Boar Ribs",
			"	d. Get 2 Thick Bear Furs",
			completion={{questgoal={"*","Chunk of Boar Meat",4}},{questgoal={"*","Crag Boar Rib",6}},{questgoal={"*","Thick Bear Fur",2}}},
			mapzone="Dun Morogh",
			level=6,
			mapnote=50810050,
		}, {
			"Go southwest to "..cl(44,57),
			"	a. Click the crate",
			"	b. Get Rumbleshot's Ammo",
			completion={{questgoal={"*","Rumbleshot's Ammo",1}}},
			mapzone="Dun Morogh",
			level=6,
			mapnote=57010110,
		}, {
			"Go northwest to "..cl(42,54),
			"	a. Kill wendigos",
			"	b. Get 8 Wendigo Manes",
			completion={{questgoal={"*","Wendigo Mane",8}}},
			mapzone="Dun Morogh",
			level=6,
			mapnote=54109650,
		}, {
			"Grind to level 7",
			completion={{level=7}},
			mapzone="Dun Morogh",
			level=6,
		}, {
			"Go south to "..cl(41,65),
			"	a. Talk to Hegnar Rumbleshot",
			"		i. Turn in "..cq("Ammo for Rumbleshot"),
			completion={{questturnedin="Ammo for Rumbleshot"}},
			mapzone="Dun Morogh",
			level=7,
			mapnote=65110580,
		}, {
			"Go northeast to Kharanos",
			completion={{location={mapzone="Dun Morogh",x=46.4,y=53.0, dist=2.5}}},
			mapzone="Dun Morogh",
			level=7,
		}, {
			"Go to "..cl(47,52),
			"	a. Talk to Ragnar Thunderbrew",
			"		i. Turn in "..cq("Beer Basted Boar Ribs"),
			completion={{questturnedin="Beer Basted Boar Ribs"}},
			mapzone="Dun Morogh",
			level=7,
			mapnote=52409920,
		}, {
			"Go northeast to Steelgrill's Depot",
			completion={{location={mapzone="Dun Morogh",x=49.8,y=49.1, dist=2}}},
			mapzone="Dun Morogh",
			level=7,
		}, {
			"Go to "..cl(50,49),
			"	a. Talk to Pilot Bellowfiz",
			"		i. Turn in "..cq("Stocking Jetsteam"),
			"		ii. Accept "..cq("Evershine"),
			"	b. Talk to Pilot Stonegear",
			"		i. Turn in "..cq("The Grizzled Den"),
			completion={{questturnedin="Stocking Jetsteam"},{questaccepted="Evershine"},{questturnedin="The Grizzled Den"}},
			mapzone="Dun Morogh",
			level=7,
			mapnote=48509810,
		}, {
			"Go west to "..cl(30,46),
			"	a. Talk to Rejold Barleybrew",
			"		i. Turn in "..cq("Evershine"),
			"		ii. Accept "..cq("A Favor for Evershine"),
			"		iii. Accept "..cq("The Perfect Stout"),
			"	b. Talk to Marleth Barleybrew",
			"		i. Accept "..cq("Bitter Rivals"),
			completion={{questturnedin="Evershine"},{questaccepted="A Favor for Evershine"},{questaccepted="The Perfect Stout"},{questaccepted="Bitter Rivals"}},
			mapzone="Dun Morogh",
			level=7,
			mapnote=45607580,
		}, {
			"Go southwest to "..cl(28,48),
			"	a. Kill 6 Ice Claw Bears",
			"	b. Kill 8 Elder Crag Boars",
			"	c. Kill 8 Snow Leopards",
			completion={{questgoal={"*","Ice Claw Bear slain",6}},{questgoal={"*","Elder Crag Boar slain",8}},{questgoal={"*","Snow Leopard slain",8}}},
			mapzone="Dun Morogh",
			level=7,
			mapnote=48307610,
		}, {
			"Grind to level 8",
			completion={{level=8}},
			mapzone="Dun Morogh",
			level=7,
		}, {
			"Go northeast to "..cl(30,46),
			"	a. Talk to Rejold Barleybrew",
			"		i. Turn in "..cq("A Favor for Evershine"),
			"		ii. Accept "..cq("Return to Bellowfiz"),
			completion={{questturnedin="A Favor for Evershine"},{questaccepted="Return to Bellowfiz"}},
			mapzone="Dun Morogh",
			level=8,
			mapnote=45607580,
		}, {
			"Go northeast to 38,42 ",
			"	a. The path up to 'The Perfect Stout' starts here",
			completion={{location={mapzone="Dun Morogh",x=37.9,y=42.1, dist=0.3}}},
			mapzone="Dun Morogh",
			level=8,
			mapnote=42108000,
		}, {
			"Go southwest to "..cl(41,44),
			"	a. Kill Frostmane Seers",
			"	b. Click the Shimmerweed Baskets",
			"	c. Get 6 Shimmerweed",
			completion={{questgoal={"*","Shimmerweed",6}}},
			mapzone="Dun Morogh",
			level=8,
			mapnote=44208550,
		}, {
			"Go southeast to Steelgrill's Depot",
			completion={{location={mapzone="Dun Morogh",x=49.8,y=49.1, dist=2}}},
			mapzone="Dun Morogh",
			level=8,
		}, {
			"Go to "..cl(50,49),
			"	a. Talk to Pilot Bellowfiz",
			"		i. Turn in "..cq("Return to Bellowfiz"),
			completion={{questturnedin="Return to Bellowfiz"}},
			mapzone="Dun Morogh",
			level=8,
			mapnote=48509810,
		}, {
			"Go southwest to Kharanos",
			completion={{location={mapzone="Dun Morogh",x=46.4,y=53.0, dist=2.5}}},
			mapzone="Dun Morogh",
			level=8,
		}, {
			"Go to "..cl(47,52),
			"	a. Talk to Innkeeper Belm",
			"		i. Buy a Thunder Ale",
			completion={{questgoal={"*","Thunder Ale",1}}},
			mapzone="Dun Morogh",
			level=8,
			mapnote=52309960,
		}, {
			"Also at "..cl(47,45),	
			"	a. Talk to Jarven Thunderbrew",
			"		i. Give him the Thunder Ale",
			"	b. Click the barrel next to him",
			"		i. Turn in "..cq("Bitter Rivals"),
			"		ii. Accept "..cq("Return to Marleth"),
			completion={{questturnedin="Bitter Rivals"},{questaccepted="Return to Marleth"}},
			mapzone="Dun Morogh",
			level=8,
			mapnote=52710030,
		}, {
			"Go to "..cl(47,54),
			"	a. Talk to Senir Whitebeard",
			"		i. Accept "..cq("Frostmane Hold"),
			completion={{questaccepted="Frostmane Hold"}},
			mapzone="Dun Morogh",
			level=8,
			mapnote=53810050,
		}, {
			"Go to "..cl(46,49),
			"	a. Talk to Razzle Sprysprocket",
			"		i. Accept "..cq("Operation Recombobulation"),
			completion={{questaccepted="Operation Recombobulation"}},
			mapzone="Dun Morogh",
			level=8,
			mapnote=49409520,
		}, {
			"Go northwest to "..cl(30,46),
			"	a. Talk to Rejold Barleybrew",
			"		i. Turn in "..cq("The Perfect Stout"),
			"	b. Talk to Marleth Barleybrew",
			"		i. Turn in "..cq("Return to Marleth"),
			completion={{questturnedin="The Perfect Stout"},{questturnedin="Return to Marleth"}},
			mapzone="Dun Morogh",
			level=8,
			mapnote=45607580,
		}, {
			"Grind to level 9",
			completion={{level=9}},
			mapzone="Dun Morogh",
			level=8,
		}, {
			"Go southwest to "..cl(25,51),
			"	a. Kill 5 Frostmane Headhunters",
			completion={{questgoal={"*","Frostmane Headhunter slain",5}}},
			mapzone="Dun Morogh",
			level=9,
			mapnote=51007600,
		}, {
			"Go west to "..cl(21,52),
			"	a. Explore Frostmane Hold",
			completion={{questgoal={"*","Fully explore Frostmane Hold",1}}},
			mapzone="Dun Morogh",
			level=9,
			mapnote=52307350,
		}, {
			"Go north to "..cl(26,43),
			"	a. Kill Leper Gnomes",
			"	b. Get 8 Restabilization Cogs",
			"	c. Get 8 Gyromechanic Gears",
			completion={{questgoal={"*","Restabilization Cog",8}},{questgoal={"*","Gyromechanic Gear",8}}},
			mapzone="Dun Morogh",
			level=9,
			mapnote=43206910,
		}, {
			"Go southeast to Kharanos",
			completion={{location={mapzone="Dun Morogh",x=46.4,y=53.0, dist=2.5}}},
			mapzone="Dun Morogh",
			level=9,
		}, {
			"Go to "..cl(46,49),
			"	a. Talk to Razzle Sprysprocket",
			"		i. Turn in "..cq("Operation Recombobulation"),
			completion={{questturnedin="Operation Recombobulation"}},
			mapzone="Dun Morogh",
			level=9,
			mapnote=49409520,
		}, {
			"Go to "..cl(47,54),
			"	a. Talk to Senir Whitebeard",
			"		i. Turn in "..cq("Frostmane Hold"),
			completion={{questturnedin="Frostmane Hold"}},
			mapzone="Dun Morogh",
			level=9,
			mapnote=53810050,
		}, {
			"Grind to level 11",
			completion={{level=11}},
			mapzone="Dun Morogh",
			level=10,
		}, {
			"Go to Ironforge",
			completion={{location={mapzone="City of Ironforge"}}},
			mapzone="Dun Morogh",
			level=11,
		}, {
			"Go to the Deeprun Tram",
			completion={{location={mapzone="Deeprun Tram"}}},
			mapzone="Dun Morogh",
			level=11,
		}, {
			"Ride the tram to Stormwind City",
			completion={{location={mapzone="Stormwind City"}}},
			mapzone="Dun Morogh",
			level=11,
		}, {
			"Go to "..cl(66,62),
			"	a. Talk to Dungar Longdrink",
			"		i. Get the Stormwind City Flight Path",
			completion={{flightpath="Stormwind City"}},
			mapzone="Stormwind City",
			level=11,
			mapnote=62112840,
		}, {
			"Go southeast to Goldshire",
			completion={{location={mapzone="Elwynn Forest",x=42.4,y=65.8, dist=2}}},
			mapzone="Elwynn Forest",
			level=11,

		}, {
			"Go to "..cl(42,66),
			"	a. Talk to Marshal Dughan",
			"		i. Accept "..cq("The Fargodeep Mine"),
			completion={{questaccepted="The Fargodeep Mine"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=65910800,
		}, {
			"Go to "..cl(43,66),
			"	a. Talk to William Pestle",
			"		i. Accept "..cq("Kobold Candles"),
			completion={{questaccepted="Kobold Candles"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=65710900,
		}, {
			"Make Goldshire your home",
			completion={{home="Goldshire"}},
			mapzone="Elwynn Forest",
			level=11,
		}, {
			"Go to "..cl(42,67),
			"	a. Talk to Remy 'Two Times'",
			"		i. Accept "..cq("Gold Dust Exchange"),
			completion={{questaccepted="Gold Dust Exchange"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=67310940,
		}, {
			"Go southwest to "..cl(39,82),
			"	a. Kill kobolds",
			"	b. Get 8 Kobold Candles",
			"	c. Get 10 Gold Dust",
			completion={{questgoal={"*","Large Candle",8}},{questgoal={"*","Gold Dust",10}}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=82312130,
		}, {
			"Go northwest to "..cl(41,79),
			"	a. Explore Fargodeep Mine",
			completion={{location={mapzone="Elwynn Forest",x=41.2,y=78.9, dist=0.5}}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=79112040,
		}, {
			"Go southwest to "..cl(35,84),
			"	a. Talk to 'Auntie' Bernice Stonefield",
			"		i. Accept "..cq("Lost Necklace"),
			completion={{questaccepted="Lost Necklace"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=84211870,
		}, {
			"Go east to "..cl(43,86),
			"	a. Talk to Billy Maclure",
			"		i. Turn in "..cq("Lost Necklace"),
			"		ii. Accept "..cq("Pie for Billy"),
			completion={{questturnedin="Lost Necklace"},{questaccepted="Pie for Billy"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=85712880,
		}, {
			"Go southwest to "..cl(42,87),
			"	a. Kill boars",
			"	b. Get 4 Chunks of Boar Meat",
			completion={{questgoal={"*","Chunk of Boar Meat",4}}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=86912860,
		}, {
			"Go southeast to "..cl(43,90),
			"	a. Talk to Maybell Maclure",
			"		i. Accept "..cq("Young Lovers"),
			completion={{questaccepted="Young Lovers"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=89613280,
		}, {
			"Go northwest to "..cl(35,84),
			"	a. Talk to 'Auntie' Bernice Stonefield",
			"		i. Turn in "..cq("Pie for Billy"),
			"		ii. Accept "..cq("Back to Billy"),
			completion={{questturnedin="Pie for Billy"},{questaccepted="Back to Billy"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=84211870,
		}, {
			"Go west to "..cl(30,86),
			"	a. Talk to Tommy Joe Stonefield",
			"		i. Turn in "..cq("Young Lovers"),
			"		ii. Accept "..cq("Speak with Gramma"),
			completion={{questturnedin="Young Lovers"},{questaccepted="Speak with Gramma"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=86011580,
		}, {
			"Go east "..cl(35,84),
			"	a. Talk to Gramma Stonefield",
			"		i. Turn in "..cq("Speak with Gramma"),
			"		ii. Accept "..cq("Note to William"),
			completion={{questturnedin="Speak with Gramma"},{questaccepted="Note to William"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=83911880,
		}, {
			"Go east to "..cl(43,86),
			"	a. Talk to Billy Maclure",
			"		i. Turn in "..cq("Back to Billy"),
			"		ii. Accept "..cq("Goldtooth"),
			completion={{questturnedin="Back to Billy"},{questaccepted="Goldtooth"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=85712880,
		}, {
			"Go northwest into the Fargodeep Mine",
			"	a. Enter using the lower entrance",
			completion={{location={mapzone="Elwynn Forest",x=38.3,y=81.6, dist=0.5}}},
			mapzone="Elwynn Forest",
			level=11,
		}, {
			"Follow the path inside the cave to "..cl(42,78),
			"	a. Kill Goldtooth",
			"	b. Get Bernice's Necklace",
			completion={{questgoal={"*","Bernice's Necklace",1}}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=78312000,
		}, {
			"Hearth to Goldshire",
			completion={{location={mapzone="Elwynn Forest",x=42.4,y=65.8, dist=2}}},
			mapzone="Elwynn Forest",
			level=11,
		}, {
			"Go to "..cl(42,67),
			"	a. Talk to Remy 'Two Times'",
			"		i. Turn in "..cq("Gold Dust Exchange"),
			"		ii. Accept "..cq("A Fishy Peril"),
			completion={{questturnedin="Gold Dust Exchange"},{questaccepted="A Fishy Peril"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=67310940,
		}, {			
			"Go to "..cl(42,66),
			"	a. Talk to Marshal Dughan",
			"		i. Turn in "..cq("The Fargodeep Mine"),
			"		ii. Turn in "..cq("A Fishy Peril"),
			"		iii. Accept "..cq("The Jasperlode Mine"),
			"		iv. Accept "..cq("Further Concerns"),
			completion={{questturnedin="The Fargodeep Mine"},{questturnedin="A Fishy Peril"},{questaccepted="The Jasperlode Mine"},{questaccepted="Further Concerns"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=65910800,
		}, {
			"Go to "..cl(43,66),
			"	a. Talk to William Pestle",
			"		i. Turn in "..cq("Kobold Candles"),
			"		ii. Turn in "..cq("Note to William"),
			"		iii. Accept "..cq("Collecting Kelp"),
			completion={{questturnedin="Kobold Candles"},{questturnedin="Note to William"},{questaccepted="Collecting Kelp"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=65710900,
		}, {
			"Go east to "..cl(50,66),
			"	a. Kill murlocs",
			"	b. Get 4 Crystal Kelp Fronds",
			completion={{questgoal={"*","Crystal Kelp Frond",4}}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=66311600,
		}, {
			"Go west to Goldshire",
			completion={{location={mapzone="Elwynn Forest",x=42.4,y=65.8, dist=2}}},
			mapzone="Elwynn Forest",
			level=11,
		}, {
			"Go to "..cl(43,66),
			"	a. Talk to William Pestle",
			"		i. Turn in "..cq("Collecting Kelp"),
			"		ii. Accept "..cq("The Escape"),
			completion={{questturnedin="Collecting Kelp"},{questaccepted="The Escape"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=65710900,
		}, {
			"Go south to "..cl(43,90),
			"	a. Talk to Maybell Maclure",
			"		i. Turn in "..cq("The Escape"),
			completion={{questturnedin="The Escape"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=89613280,
		}, {
			"Go northwest to "..cl(34,84),
			"	a. Talk to 'Auntie' Bernice Stonefield",
			"		i. Turn in "..cq("Goldtooth"),
			completion={{questturnedin="Goldtooth"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=84211870,
		}, {
			"Go northeast to "..cl(74,72),
			"	a. Talk to Guard Thomas",
			"		i. Turn in "..cq("Further Concerns"),
			"		ii. Accept "..cq("Find the Lost Guards"),
			"		iii. Accept "..cq("Protect the Frontier"),
			completion={{questturnedin="Further Concerns"},{questaccepted="Find the Lost Guards"},{questaccepted="Protect the Frontier"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=72214620,
		}, {
			"Go northeast to "..cl(80,69),
			"	a. Talk to Sara Timberlain",
			"		i. Accept "..cq("Red Linen Goods"),
			completion={{questaccepted="Red Linen Goods"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=68814830,
		}, {
			"Go northeast to "..cl(81,66),
			"	a. Talk to Supervisor Raelen",
			"		i. Accept "..cq("A Bundle of Trouble"),
			completion={{questaccepted="A Bundle of Trouble"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=66114750,
		}, {
			"Go north to "..cl(81,61),
			"	a. Get 8 Bundles of Wood",
			completion={{questgoal={"*","Bundle of Wood",8}}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=60614190,
		}, {
			"Go west to "..cl(73,60),
			"	a. Click the Half-Eaten Body",
			"		i. Turn in "..cq("Find the Lost Guards"),
			"		ii. Accept "..cq("Discover Rolf's Fate"),
			completion={{questturnedin="Find the Lost Guards"},{questaccepted="Discover Rolf's Fate"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=60313300,
		}, {
			"Go northeast to "..cl(80,56),
			"	a. Click Rolf's Corpse",
			"		i. Turn in "..cq("Discover Rolf's Fate"),
			"		ii. Accept "..cq("Report to Thomas"),
			completion={{questturnedin="Discover Rolf's Fate"},{questaccepted="Report to Thomas"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=55513530,
		}, {
			"Go south to "..cl(81,66),
			"	a. Talk to Supervisor Raelen",
			"		i. Turn in "..cq("A Bundle of Trouble"),
			completion={{questturnedin="A Bundle of Trouble"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=66114750,
		}, {
			"Go south to "..cl(80,78),
			"	a. Kill 8 Prowlers",
			"	b. Kill 5 Young Forest Bears",
			completion={{questgoal={"*","Prowler slain",8}},{questgoal={"*","Young Forest Bear slain",5}}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=77815780,
		}, {
			"Go east to "..cl(88,80),
			"	a. Kill Defias mobs",
			"	b. Get 6 Red Linen Bandanas",
			"	c. Get a Westfall Deed",
			"	d. Click the Westfall Deed",
			"		i. Accept "..cq("Furlbrow's Deed"),
			completion={{questgoal={"*","Red Linen Bandana",6}},{questaccepted="Furlbrow's Deed"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=80216870,
		}, {
			"Go northwest to "..cl(80,69),
			"	a. Talk to Sara Timberlain",
			"		i. Turn in "..cq("Red Linen Goods"),
			completion={{questturnedin="Red Linen Goods"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=68814830,
		}, {
			"Go southwest to "..cl(74,72),
			"	a. Talk to Guard Thomas",
			"		i. Turn in "..cq("Protect the Frontier"),
			"		ii. Turn in "..cq("Report to Thomas"),
			"		iii. Accept "..cq("Deliver Thomas' Report"),
			completion={{questturnedin="Protect the Frontier"},{questturnedin="Report to Thomas"},{questaccepted="Deliver Thomas' Report"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=72214620,
		}, {
			"Go northwest to "..cl(60,50),
			"	a. Explore Jasperlode Mine",
			completion={{location={mapzone="Elwynn Forest",x=60.5,y=50.0, dist=0.3}}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=49711010,
		}, {
			"Hearth to Goldshire",
			completion={{location={mapzone="Elwynn Forest",x=42.4,y=65.8, dist=2}}},
			mapzone="Elwynn Forest",
			level=11,
		}, {
			"Go to "..cl(42,67),
			"	a. Talk to Marshal Dughan",
			"		i. Turn in "..cq("Deliver Thomas' Report"),
			"		ii. Turn in "..cq("The Jasperlode Mine"),
			"		iii. Accept "..cq("Westbrook Garrison Needs Help!"),
			completion={{questturnedin="Deliver Thomas' Report"},{questturnedin="The Jasperlode Mine"},{questaccepted="Westbrook Garrison Needs Help!"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=65910800,
		}, {
			"Go southwest to "..cl(24,75),
			"	a. Talk to Deputy Rainer",
			"		i. Turn in "..cq("Westbrook Garrison Needs Help!"),
			"		ii. Accept "..cq("Riverpaw Gnoll Bounty"),
			"	b. Click the Wanted Poster",
			"		i. Accept "..cq("Wanted: 'Hogger'"),
			completion={{questturnedin="Westbrook Garrison Needs Help!"},{questaccepted="Riverpaw Gnoll Bounty"},{questaccepted="Wanted: 'Hogger'"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=74809910,
		}, {
			"Go southeast to "..cl(27,86),
			"	a. Kill Riverpaw gnolls",
			"	b. Get 8 Painted Gnoll Armbands",
			"	c. Kill Hogger",
			"	d. Get the Huge Gnoll Claw",
			completion={{questgoal={"*","Painted Gnoll Armband",8}},{questgoal={"*","Huge Gnoll Claw",1}}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=86311310,
		}, {
			"Go northeast to Goldshire",
			completion={{location={mapzone="Elwynn Forest",x=42.4,y=65.8, dist=2}}},
			mapzone="Elwynn Forest",
			level=11,
		}, {
			"Go to "..cl(42,67),
			"	a. Talk to Marshal Dughan",
			"		i. Turn in "..cq("Wanted: 'Hogger'"),
			completion={{questturnedin="Wanted: 'Hogger'"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=65910800,
		}, {
			"Go southwest to "..cl(24,75),
			"	a. Talk to Deputy Rainer",
			"		i. Turn in "..cq("Riverpaw Gnoll Bounty"),
			completion={{questturnedin="Riverpaw Gnoll Bounty"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=74809910,
		}, {
			"Grind to level 13",
			completion={{level=13}},
			mapzone="Elwynn Forest",
			level=12,
		}, {
			"Go west to Westfall",
			completion={{location={mapzone="Westfall"}}},
			mapzone="Elwynn Forest",
			level=13,
		}
	  },
	},
	{ sectiontitle = "Dwarf (1-13)",
	  defaultfor = "Dwarf",
	  nextsection = 6,
	  steps = {
		{
			"Go to "..cl(30,71),
			"	a. Talk to Sten Stoutarm",
			"		i. Accept "..cq("Dwarven Outfitters"),
			completion={{questaccepted="Dwarven Outfitters"}},
			mapzone="Dun Morogh",
			level=1,
			mapnote=71310110,
		}, {
			"Go south to "..cl(29,74),
			"	a. Kill wolves",
			"	b. Get 8 Tough Wolf Meat",
			completion={{questgoal={"*","Tough Wolf Meat",8}}},
			mapzone="Dun Morogh",
			level=1,
			mapnote=74010300,
		}, {
			"Grind to level 2",
			completion={{level=2}},
			mapzone="Dun Morogh",
			level=1,
		}, {
			"Go north to "..cl(30,71),
			"	a. Talk to Sten Stoutarm",
			"		i. Turn in "..cq("Dwarven Outfitters"),
			"		ii. Accept "..cq("Coldridge Valley Mail Delivery part 1"),
			"	b. Talk to Balir Frosthammer",
			"		i. Accept "..cq("A New Threat"),
			completion={{questturnedin="Dwarven Outfitters"},{questaccepted="Coldridge Valley Mail Delivery part 1"},{questaccepted="A New Threat"}},
			mapzone="Dun Morogh",
			level=2,
			mapnote=71310110,
		}, {
			"Go southeast to "..cl(31,75),
			"	a. Kill 6 Rockjaw Troggs",
			"	b. Kill 6 Burly Rockjaw Troggs",
			completion={{questgoal={"*","Rockjaw Trogg slain",6}},{questgoal={"*","Burly Rockjaw Trogg slain",6}}},
			mapzone="Dun Morogh",
			level=2,
			mapnote=75010600,
		}, {
			"Grind to level 3",
			completion={{level=3}},
			mapzone="Dun Morogh",
			level=2,
		}, {
			"Go northwest to "..cl(30,71),
			"	a. Talk to Balir Frosthammer",
			"		i. Turn in "..cq("A New Threat"),
			completion={{questturnedin="A New Threat"}},
			mapzone="Dun Morogh",
			level=3,
			mapnote=71310110,
		}, {
			"Go northwest to Anvilmar",
			completion={{location={mapzone="Dun Morogh",x=28.8,y=69.8, dist=0.3}}},
			mapzone="Dun Morogh",
			level=3,
		}, {
			"Go to "..cl(29,68),
			"	a. Talk to Felix Whindlebolt",
			"		i. Accept "..cq("A Refugee's Quandary"),
			completion={{questaccepted="A Refugee's Quandary"}},
			mapzone="Dun Morogh",
			level=3,
			mapnote=67709620,
		}, {
			"Go southwest to "..cl(23,71),
			"	a. Talk to Talin Keeneye",
			"		i. Turn in "..cq("Coldridge Valley Mail Delivery part 1"),
			"		ii. Accept "..cq("Coldridge Valley Mail Delivery part 2"),
			"		iii. Accept "..cq("The Boar Hunter"),
			completion={{questturnedin="Coldridge Valley Mail Delivery part 1"},{questaccepted="Coldridge Valley Mail Delivery part 2"},{questaccepted="The Boar Hunter"}},
			mapzone="Dun Morogh",
			level=3,
			mapnote=71409400,
		}, {
			"Go northwest to "..cl(22,70),
			"	a. Kill 12 Small Crag Boars",
			completion={{questgoal={"*","Small Crag Boar slain",12}}},
			mapzone="Dun Morogh",
			level=3,
			mapnote=70009200,
		}, {
			"Grind to level 4",
			completion={{level=4}},
			mapzone="Dun Morogh",
			level=3,
		}, {
			"Go southeast to "..cl(23,71),
			"	a. Talk to Talin Keeneye",
			"		i. Turn in "..cq("The Boar Hunter"),
			completion={{questturnedin="The Boar Hunter"}},
			mapzone="Dun Morogh",
			level=4,
			mapnote=71409400,
		}, {
			"Go southeast to "..cl(25,76),
			"	a. Talk to Grelin Whitebeard",
			"		i. Turn in "..cq("Coldridge Valley Mail Delivery part 2"),
			"		ii. Accept "..cq("The Troll Cave"),
			completion={{questturnedin="Coldridge Valley Mail Delivery part 2"},{questaccepted="The Troll Cave"}},
			mapzone="Dun Morogh",
			level=4,
			mapnote=76010100,
		}, {
			"Go southeast to "..cl(26,79),
			"	a. Get Felix's Bucket of Bolts",
			"	b. Kill 14 Frostmane Troll Whelps",
			completion={{questgoal={"*","Felix's Bucket of Bolts",1}},{questgoal={"*","Frostmane Troll Whelp slain",14}}},
			mapzone="Dun Morogh",
			level=4,
			mapnote=79310560,
		}, {
			"Grind to level 5",
			completion={{level=5}},
			mapzone="Dun Morogh",
			level=4,
		}, {
			"Go northwest to "..cl(25,76),
			"	a. Talk to Grelin Whitebeard",
			"		i. Turn in "..cq("The Troll Cave"),
			"		ii. Accept "..cq("The Stolen Journal"),
			completion={{questturnedin="The Troll Cave"},{questaccepted="The Stolen Journal"}},
			mapzone="Dun Morogh",
			level=5,
			mapnote=76010100,
		}, {
			"Go southeast to "..cl(31,80),
			"	a. Kill Grik'nir the Cold",
			"	b. Get Grelin Whitebeard's Journal",
			completion={{questgoal={"*","Grelin Whitebeard's Journal",1}}},
			mapzone="Dun Morogh",
			level=5,
			mapnote=80211070,
		}, {
			"Go west to "..cl(23,80),
			"	a. Get Felix's Chest",
			completion={{questgoal={"*","Felix's Chest",1}}},
			mapzone="Dun Morogh",
			level=5,
			mapnote=80010280,
		}, {
			"Go northwest to "..cl(21,76),
			"	a. Get Felix's Box",
			completion={{questgoal={"*","Felix's Box",1}}},
			mapzone="Dun Morogh",
			level=5,
			mapnote=76109700,
		}, {
			"Go east to "..cl(23,71),
			"	a. Talk to Grelin Whitebeard",
			"		i. Turn in "..cq("The Stolen Journal"),
			"		ii. Accept "..cq("Senir's Observations part 1"),
			"	b. Talk to Nori Pridedrift",
			"		i. Accept "..cq("Scalding Mornbrew Delivery"),
			completion={{questturnedin="The Stolen Journal"},{questaccepted="Senir's Observations part 1"},{questaccepted="Scalding Mornbrew Delivery"}},
			mapzone="Dun Morogh",
			level=5,
			mapnote=76010100,
		}, {
			"Grind to level 6",
			completion={{level=6}},
			mapzone="Dun Morogh",
			level=5,
		}, {
			"Go northeast to Anvilmar",
			completion={{location={mapzone="Dun Morogh",x=28.8,y=69.8, dist=0.3}}},
			mapzone="Dun Morogh",
			level=6,
		}, {
			"Go to "..cl(29,68),
			"	a. Talk to Felix Whindlebolt",
			"		i. Turn in "..cq("A Refugee's Quandary"),
			completion={{questturnedin="A Refugee's Quandary"}},
			mapzone="Dun Morogh",
			level=6,
			mapnote=67709620,
		}, {
			"Go to "..cl(29,66),
			"	a. Talk to Durnan Furcutter",
			"		i. Turn in "..cq("Scalding Mornbrew Delivery"),
			"		ii. Accept "..cq("Bring Back the Mug"),
			completion={{questturnedin="Scalding Mornbrew Delivery"},{questaccepted="Bring Back the Mug"}},
			mapzone="Dun Morogh",
			level=6,
			mapnote=66409520,
		}, {
			"Go southwest to "..cl(23,71),
			"	a. Talk to Nori Pridedrift",
			"		i. Turn in "..cq("Bring Back the Mug"),
			completion={{questturnedin="Bring Back the Mug"}},
			mapzone="Dun Morogh",
			level=6,
			mapnote=76010100,
		}, {
			"Go northeast to "..cl(34,72),
			"	a. Talk to Mountaineer Thalos",
			"		i. Turn in "..cq("Senir's Observations part 1"),
			"		ii. Accept "..cq("Senir's Observations part 2"),
			"	b. Talk to Hands Springsprocket",
			"		i. Accept "..cq("Supplies to Tannok"),
			completion={{questturnedin="Senir's Observations part 1"},{questaccepted="Senir's Observations part 2"},{questaccepted="Supplies to Tannok"}},
			mapzone="Dun Morogh",
			level=6,
			mapnote=71810530,
		}, {
			"Go through the tunnel to the other side",
			completion={{location={mapzone="Dun Morogh",x=35.6,y=65.8, dist=0.3}}},
			mapzone="Dun Morogh",
			level=6,
		}, {
			"Go northeast to Kharanos",
			completion={{location={mapzone="Dun Morogh",x=46.4,y=53.0, dist=2.5}}},
			mapzone="Dun Morogh",
			level=6,
		}, {
			"Go to "..cl(47,54),
			"	a. Talk to Senir Whitebeard",
			"		i. Turn in "..cq("Senir's Observations part 2"),
			completion={{questturnedin="Senir's Observations part 2"}},
			mapzone="Dun Morogh",
			level=6,
			mapnote=53810050,
		}, {
			"Go to "..cl(47,52),
			"	a. Talk to Ragnar Thunderbrew",
			"		i. Accept "..cq("Beer Basted Boar Ribs"),
			completion={{questaccepted="Beer Basted Boar Ribs"}},
			mapzone="Dun Morogh",
			level=6,
			mapnote=52409920,
		}, {
			"Also at "..cl(47,52),	
			"	a.Talk to Tannok Frosthammer",
			"		i. Turn in "..cq("Supplies to Tannok"),
			"	b. Talk to Innkeeper Belm",
			"		i. Buy a Rhapsody Malt",
			completion={{questturnedin="Supplies to Tannok"},{questgoal={"*","Rhapsody Malt",1}}},
			mapzone="Dun Morogh",
			level=6,
			mapnote=52309960,
		}, {
			"Make Kharanos your home",
			completion={{home="Kharanos"}},
			mapzone="Dun Morogh",
			level=6,
		}, {
			"Go to "..cl(46,52),
			"	a. Talk to Tharek Blackstone",
			"		i. Accept "..cq("Tools for Steelgrill"),
			completion={{questaccepted="Tools for Steelgrill"}},
			mapzone="Dun Morogh",
			level=6,
			mapnote=51709770,
		}, {
			"Go northeast to "..cl(50,49),
			"	a. Talk to Beldin Steelgrill",
			"		i. Turn in "..cq("Tools for Steelgrill"),
			completion={{questturnedin="Tools for Steelgrill"}},
			mapzone="Dun Morogh",
			level=6,
			mapnote=49109950,
		}, {
			"Also at "..cl(50,49),	
			"	a. Talk to Pilot Bellowfiz",
			"		i. Accept "..cq("Stocking Jetsteam"),
			"	b. Talk to Pilot Stonegear",
			"		i. Accept "..cq("The Grizzled Den"),
			completion={{questaccepted="Stocking Jetsteam"},{questaccepted="The Grizzled Den"}},
			mapzone="Dun Morogh",
			level=6,
			mapnote=48509810,
		}, {
			"Also at "..cl(50,49),	
			"	a. Talk to Loslor Rudge",
			"		i. Accept "..cq("Ammo for Rumbleshot"),
			completion={{questaccepted="Ammo for Rumbleshot"}},
			mapzone="Dun Morogh",
			level=6,
			mapnote=49409950,
		}, {
			"Go south to "..cl(50,51),
			"	a. Kill boars and bears",
			"	b. Get 4 Chunks of Boar Meat",
			"	c. Get 6 Crag Boar Ribs",
			"	d. Get 2 Thick Bear Furs",
			completion={{questgoal={"*","Chunk of Boar Meat",4}},{questgoal={"*","Crag Boar Rib",6}},{questgoal={"*","Thick Bear Fur",2}}},
			mapzone="Dun Morogh",
			level=6,
			mapnote=50810050,
		}, {
			"Go southwest to "..cl(44,57),
			"	a. Click the crate",
			"	b. Get Rumbleshot's Ammo",
			completion={{questgoal={"*","Rumbleshot's Ammo",1}}},
			mapzone="Dun Morogh",
			level=6,
			mapnote=57010110,
		}, {
			"Go northwest to "..cl(42,54),
			"	a. Kill wendigos",
			"	b. Get 8 Wendigo Manes",
			completion={{questgoal={"*","Wendigo Mane",8}}},
			mapzone="Dun Morogh",
			level=6,
			mapnote=54109650,
		}, {
			"Grind to level 7",
			completion={{level=7}},
			mapzone="Dun Morogh",
			level=6,
		}, {
			"Go south to "..cl(41,65),
			"	a. Talk to Hegnar Rumbleshot",
			"		i. Turn in "..cq("Ammo for Rumbleshot"),
			completion={{questturnedin="Ammo for Rumbleshot"}},
			mapzone="Dun Morogh",
			level=7,
			mapnote=65110580,
		}, {
			"Go northeast to Kharanos",
			completion={{location={mapzone="Dun Morogh",x=46.4,y=53.0, dist=2.5}}},
			mapzone="Dun Morogh",
			level=7,
		}, {
			"Go to "..cl(47,52),
			"	a. Talk to Ragnar Thunderbrew",
			"		i. Turn in "..cq("Beer Basted Boar Ribs"),
			completion={{questturnedin="Beer Basted Boar Ribs"}},
			mapzone="Dun Morogh",
			level=7,
			mapnote=52409920,
		}, {
			"Go northeast to Steelgrill's Depot",
			completion={{location={mapzone="Dun Morogh",x=49.8,y=49.1, dist=2}}},
			mapzone="Dun Morogh",
			level=7,
		}, {
			"Go to "..cl(50,49),
			"	a. Talk to Pilot Bellowfiz",
			"		i. Turn in "..cq("Stocking Jetsteam"),
			"		ii. Accept "..cq("Evershine"),
			"	b. Talk to Pilot Stonegear",
			"		i. Turn in "..cq("The Grizzled Den"),
			completion={{questturnedin="Stocking Jetsteam"},{questaccepted="Evershine"},{questturnedin="The Grizzled Den"}},
			mapzone="Dun Morogh",
			level=7,
			mapnote=48509810,
		}, {
			"Go west to "..cl(30,46),
			"	a. Talk to Rejold Barleybrew",
			"		i. Turn in "..cq("Evershine"),
			"		ii. Accept "..cq("A Favor for Evershine"),
			"		iii. Accept "..cq("The Perfect Stout"),
			"	b. Talk to Marleth Barleybrew",
			"		i. Accept "..cq("Bitter Rivals"),
			completion={{questturnedin="Evershine"},{questaccepted="A Favor for Evershine"},{questaccepted="The Perfect Stout"},{questaccepted="Bitter Rivals"}},
			mapzone="Dun Morogh",
			level=7,
			mapnote=45607580,
		}, {
			"Go southwest to "..cl(28,48),
			"	a. Kill 6 Ice Claw Bears",
			"	b. Kill 8 Elder Crag Boars",
			"	c. Kill 8 Snow Leopards",
			completion={{questgoal={"*","Ice Claw Bear slain",6}},{questgoal={"*","Elder Crag Boar slain",8}},{questgoal={"*","Snow Leopard slain",8}}},
			mapzone="Dun Morogh",
			level=7,
			mapnote=48307610,
		}, {
			"Grind to level 8",
			completion={{level=8}},
			mapzone="Dun Morogh",
			level=7,
		}, {
			"Go northeast to "..cl(30,46),
			"	a. Talk to Rejold Barleybrew",
			"		i. Turn in "..cq("A Favor for Evershine"),
			"		ii. Accept "..cq("Return to Bellowfiz"),
			completion={{questturnedin="A Favor for Evershine"},{questaccepted="Return to Bellowfiz"}},
			mapzone="Dun Morogh",
			level=8,
			mapnote=45607580,
		}, {
			"Go northeast to 38,42 ",
			"	a. The path up to 'The Perfect Stout' starts here",
			completion={{location={mapzone="Dun Morogh",x=37.9,y=42.1, dist=0.3}}},
			mapzone="Dun Morogh",
			level=8,
			mapnote=42108000,
		}, {
			"Go southwest to "..cl(41,44),
			"	a. Kill Frostmane Seers",
			"	b. Click the Shimmerweed Baskets",
			"	c. Get 6 Shimmerweed",
			completion={{questgoal={"*","Shimmerweed",6}}},
			mapzone="Dun Morogh",
			level=8,
			mapnote=44208550,
		}, {
			"Go southeast to Steelgrill's Depot",
			completion={{location={mapzone="Dun Morogh",x=49.8,y=49.1, dist=2}}},
			mapzone="Dun Morogh",
			level=8,
		}, {
			"Go to "..cl(50,49),
			"	a. Talk to Pilot Bellowfiz",
			"		i. Turn in "..cq("Return to Bellowfiz"),
			completion={{questturnedin="Return to Bellowfiz"}},
			mapzone="Dun Morogh",
			level=8,
			mapnote=48509810,
		}, {
			"Go southwest to Kharanos",
			completion={{location={mapzone="Dun Morogh",x=46.4,y=53.0, dist=2.5}}},
			mapzone="Dun Morogh",
			level=8,
		}, {
			"Go to "..cl(47,52),
			"	a. Talk to Innkeeper Belm",
			"		i. Buy a Thunder Ale",
			completion={{questgoal={"*","Thunder Ale",1}}},
			mapzone="Dun Morogh",
			level=8,
			mapnote=52309960,
		}, {
			"Also at "..cl(47,45),	
			"	a. Talk to Jarven Thunderbrew",
			"		i. Give him the Thunder Ale",
			"	b. Click the barrel next to him",
			"		i. Turn in "..cq("Bitter Rivals"),
			"		ii. Accept "..cq("Return to Marleth"),
			completion={{questturnedin="Bitter Rivals"},{questaccepted="Return to Marleth"}},
			mapzone="Dun Morogh",
			level=8,
			mapnote=52710030,
		}, {
			"Go to "..cl(47,54),
			"	a. Talk to Senir Whitebeard",
			"		i. Accept "..cq("Frostmane Hold"),
			completion={{questaccepted="Frostmane Hold"}},
			mapzone="Dun Morogh",
			level=8,
			mapnote=53810050,
		}, {
			"Go to "..cl(46,49),
			"	a. Talk to Razzle Sprysprocket",
			"		i. Accept "..cq("Operation Recombobulation"),
			completion={{questaccepted="Operation Recombobulation"}},
			mapzone="Dun Morogh",
			level=8,
			mapnote=49409520,
		}, {
			"Go northwest to "..cl(30,46),
			"	a. Talk to Rejold Barleybrew",
			"		i. Turn in "..cq("The Perfect Stout"),
			"	b. Talk to Marleth Barleybrew",
			"		i. Turn in "..cq("Return to Marleth"),
			completion={{questturnedin="The Perfect Stout"},{questturnedin="Return to Marleth"}},
			mapzone="Dun Morogh",
			level=8,
			mapnote=45607580,
		}, {
			"Grind to level 9",
			completion={{level=9}},
			mapzone="Dun Morogh",
			level=8,
		}, {
			"Go southwest to "..cl(25,51),
			"	a. Kill 5 Frostmane Headhunters",
			completion={{questgoal={"*","Frostmane Headhunter slain",5}}},
			mapzone="Dun Morogh",
			level=9,
			mapnote=51007600,
		}, {
			"Go west to "..cl(21,52),
			"	a. Explore Frostmane Hold",
			completion={{questgoal={"*","Fully explore Frostmane Hold",1}}},
			mapzone="Dun Morogh",
			level=9,
			mapnote=52307350,
		}, {
			"Go north to "..cl(26,43),
			"	a. Kill Leper Gnomes",
			"	b. Get 8 Restabilization Cogs",
			"	c. Get 8 Gyromechanic Gears",
			completion={{questgoal={"*","Restabilization Cog",8}},{questgoal={"*","Gyromechanic Gear",8}}},
			mapzone="Dun Morogh",
			level=9,
			mapnote=43206910,
		}, {
			"Go southeast to Kharanos",
			completion={{location={mapzone="Dun Morogh",x=46.4,y=53.0, dist=2.5}}},
			mapzone="Dun Morogh",
			level=9,
		}, {
			"Go to "..cl(46,49),
			"	a. Talk to Razzle Sprysprocket",
			"		i. Turn in "..cq("Operation Recombobulation"),
			completion={{questturnedin="Operation Recombobulation"}},
			mapzone="Dun Morogh",
			level=9,
			mapnote=49409520,
		}, {
			"Go to "..cl(47,54),
			"	a. Talk to Senir Whitebeard",
			"		i. Turn in "..cq("Frostmane Hold"),
			completion={{questturnedin="Frostmane Hold"}},
			mapzone="Dun Morogh",
			level=9,
			mapnote=53810050,
		}, {
			"Grind to level 11",
			completion={{level=11}},
			mapzone="Dun Morogh",
			level=10,
		}, {
			"Go to Ironforge",
			completion={{location={mapzone="City of Ironforge"}}},
			mapzone="Dun Morogh",
			level=11,
		}, {
			"Go to the Deeprun Tram",
			completion={{location={mapzone="Deeprun Tram"}}},
			mapzone="Dun Morogh",
			level=11,
		}, {
			"Ride the tram to Stormwind City",
			completion={{location={mapzone="Stormwind City"}}},
			mapzone="Dun Morogh",
			level=11,
		}, {
			"Go to "..cl(66,62),
			"	a. Talk to Dungar Longdrink",
			"		i. Get the Stormwind City Flight Path",
			completion={{flightpath="Stormwind City"}},
			mapzone="Stormwind City",
			level=11,
			mapnote=62112840,
		}, {
			"Go southeast to Goldshire",
			completion={{location={mapzone="Elwynn Forest",x=42.4,y=65.8, dist=2}}},
			mapzone="Elwynn Forest",
			level=11,

		}, {
			"Go to "..cl(42,66),
			"	a. Talk to Marshal Dughan",
			"		i. Accept "..cq("The Fargodeep Mine"),
			completion={{questaccepted="The Fargodeep Mine"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=65910800,
		}, {
			"Go to "..cl(43,66),
			"	a. Talk to William Pestle",
			"		i. Accept "..cq("Kobold Candles"),
			completion={{questaccepted="Kobold Candles"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=65710900,
		}, {
			"Make Goldshire your home",
			completion={{home="Goldshire"}},
			mapzone="Elwynn Forest",
			level=11,
		}, {
			"Go to "..cl(42,67),
			"	a. Talk to Remy 'Two Times'",
			"		i. Accept "..cq("Gold Dust Exchange"),
			completion={{questaccepted="Gold Dust Exchange"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=67310940,
		}, {
			"Go southwest to "..cl(39,82),
			"	a. Kill kobolds",
			"	b. Get 8 Kobold Candles",
			"	c. Get 10 Gold Dust",
			completion={{questgoal={"*","Large Candle",8}},{questgoal={"*","Gold Dust",10}}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=82312130,
		}, {
			"Go northwest to "..cl(41,79),
			"	a. Explore Fargodeep Mine",
			completion={{location={mapzone="Elwynn Forest",x=41.2,y=78.9, dist=0.5}}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=79112040,
		}, {
			"Go southwest to "..cl(35,84),
			"	a. Talk to 'Auntie' Bernice Stonefield",
			"		i. Accept "..cq("Lost Necklace"),
			completion={{questaccepted="Lost Necklace"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=84211870,
		}, {
			"Go east to "..cl(43,86),
			"	a. Talk to Billy Maclure",
			"		i. Turn in "..cq("Lost Necklace"),
			"		ii. Accept "..cq("Pie for Billy"),
			completion={{questturnedin="Lost Necklace"},{questaccepted="Pie for Billy"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=85712880,
		}, {
			"Go southwest to "..cl(42,87),
			"	a. Kill boars",
			"	b. Get 4 Chunks of Boar Meat",
			completion={{questgoal={"*","Chunk of Boar Meat",4}}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=86912860,
		}, {
			"Go southeast to "..cl(43,90),
			"	a. Talk to Maybell Maclure",
			"		i. Accept "..cq("Young Lovers"),
			completion={{questaccepted="Young Lovers"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=89613280,
		}, {
			"Go northwest to "..cl(35,84),
			"	a. Talk to 'Auntie' Bernice Stonefield",
			"		i. Turn in "..cq("Pie for Billy"),
			"		ii. Accept "..cq("Back to Billy"),
			completion={{questturnedin="Pie for Billy"},{questaccepted="Back to Billy"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=84211870,
		}, {
			"Go west to "..cl(30,86),
			"	a. Talk to Tommy Joe Stonefield",
			"		i. Turn in "..cq("Young Lovers"),
			"		ii. Accept "..cq("Speak with Gramma"),
			completion={{questturnedin="Young Lovers"},{questaccepted="Speak with Gramma"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=86011580,
		}, {
			"Go east "..cl(35,84),
			"	a. Talk to Gramma Stonefield",
			"		i. Turn in "..cq("Speak with Gramma"),
			"		ii. Accept "..cq("Note to William"),
			completion={{questturnedin="Speak with Gramma"},{questaccepted="Note to William"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=83911880,
		}, {
			"Go east to "..cl(43,86),
			"	a. Talk to Billy Maclure",
			"		i. Turn in "..cq("Back to Billy"),
			"		ii. Accept "..cq("Goldtooth"),
			completion={{questturnedin="Back to Billy"},{questaccepted="Goldtooth"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=85712880,
		}, {
			"Go northwest into the Fargodeep Mine",
			"	a. Enter using the lower entrance",
			completion={{location={mapzone="Elwynn Forest",x=38.3,y=81.6, dist=0.5}}},
			mapzone="Elwynn Forest",
			level=11,
		}, {
			"Follow the path inside the cave to "..cl(42,78),
			"	a. Kill Goldtooth",
			"	b. Get Bernice's Necklace",
			completion={{questgoal={"*","Bernice's Necklace",1}}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=78312000,
		}, {
			"Hearth to Goldshire",
			completion={{location={mapzone="Elwynn Forest",x=42.4,y=65.8, dist=2}}},
			mapzone="Elwynn Forest",
			level=11,
		}, {
			"Go to "..cl(42,67),
			"	a. Talk to Remy 'Two Times'",
			"		i. Turn in "..cq("Gold Dust Exchange"),
			"		ii. Accept "..cq("A Fishy Peril"),
			completion={{questturnedin="Gold Dust Exchange"},{questaccepted="A Fishy Peril"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=67310940,
		}, {			
			"Go to "..cl(42,66),
			"	a. Talk to Marshal Dughan",
			"		i. Turn in "..cq("The Fargodeep Mine"),
			"		ii. Turn in "..cq("A Fishy Peril"),
			"		iii. Accept "..cq("The Jasperlode Mine"),
			"		iv. Accept "..cq("Further Concerns"),
			completion={{questturnedin="The Fargodeep Mine"},{questturnedin="A Fishy Peril"},{questaccepted="The Jasperlode Mine"},{questaccepted="Further Concerns"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=65910800,
		}, {
			"Go to "..cl(43,66),
			"	a. Talk to William Pestle",
			"		i. Turn in "..cq("Kobold Candles"),
			"		ii. Turn in "..cq("Note to William"),
			"		iii. Accept "..cq("Collecting Kelp"),
			completion={{questturnedin="Kobold Candles"},{questturnedin="Note to William"},{questaccepted="Collecting Kelp"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=65710900,
		}, {
			"Go east to "..cl(50,66),
			"	a. Kill murlocs",
			"	b. Get 4 Crystal Kelp Fronds",
			completion={{questgoal={"*","Crystal Kelp Frond",4}}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=66311600,
		}, {
			"Go west to Goldshire",
			completion={{location={mapzone="Elwynn Forest",x=42.4,y=65.8, dist=2}}},
			mapzone="Elwynn Forest",
			level=11,
		}, {
			"Go to "..cl(43,66),
			"	a. Talk to William Pestle",
			"		i. Turn in "..cq("Collecting Kelp"),
			"		ii. Accept "..cq("The Escape"),
			completion={{questturnedin="Collecting Kelp"},{questaccepted="The Escape"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=65710900,
		}, {
			"Go south to "..cl(43,90),
			"	a. Talk to Maybell Maclure",
			"		i. Turn in "..cq("The Escape"),
			completion={{questturnedin="The Escape"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=89613280,
		}, {
			"Go northwest to "..cl(34,84),
			"	a. Talk to 'Auntie' Bernice Stonefield",
			"		i. Turn in "..cq("Goldtooth"),
			completion={{questturnedin="Goldtooth"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=84211870,
		}, {
			"Go northeast to "..cl(74,72),
			"	a. Talk to Guard Thomas",
			"		i. Turn in "..cq("Further Concerns"),
			"		ii. Accept "..cq("Find the Lost Guards"),
			"		iii. Accept "..cq("Protect the Frontier"),
			completion={{questturnedin="Further Concerns"},{questaccepted="Find the Lost Guards"},{questaccepted="Protect the Frontier"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=72214620,
		}, {
			"Go northeast to "..cl(80,69),
			"	a. Talk to Sara Timberlain",
			"		i. Accept "..cq("Red Linen Goods"),
			completion={{questaccepted="Red Linen Goods"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=68814830,
		}, {
			"Go northeast to "..cl(81,66),
			"	a. Talk to Supervisor Raelen",
			"		i. Accept "..cq("A Bundle of Trouble"),
			completion={{questaccepted="A Bundle of Trouble"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=66114750,
		}, {
			"Go north to "..cl(81,61),
			"	a. Get 8 Bundles of Wood",
			completion={{questgoal={"*","Bundle of Wood",8}}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=60614190,
		}, {
			"Go west to "..cl(73,60),
			"	a. Click the Half-Eaten Body",
			"		i. Turn in "..cq("Find the Lost Guards"),
			"		ii. Accept "..cq("Discover Rolf's Fate"),
			completion={{questturnedin="Find the Lost Guards"},{questaccepted="Discover Rolf's Fate"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=60313300,
		}, {
			"Go northeast to "..cl(80,56),
			"	a. Click Rolf's Corpse",
			"		i. Turn in "..cq("Discover Rolf's Fate"),
			"		ii. Accept "..cq("Report to Thomas"),
			completion={{questturnedin="Discover Rolf's Fate"},{questaccepted="Report to Thomas"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=55513530,
		}, {
			"Go south to "..cl(81,66),
			"	a. Talk to Supervisor Raelen",
			"		i. Turn in "..cq("A Bundle of Trouble"),
			completion={{questturnedin="A Bundle of Trouble"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=66114750,
		}, {
			"Go south to "..cl(80,78),
			"	a. Kill 8 Prowlers",
			"	b. Kill 5 Young Forest Bears",
			completion={{questgoal={"*","Prowler slain",8}},{questgoal={"*","Young Forest Bear slain",5}}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=77815780,
		}, {
			"Go east to "..cl(88,80),
			"	a. Kill Defias mobs",
			"	b. Get 6 Red Linen Bandanas",
			"	c. Get a Westfall Deed",
			"	d. Click the Westfall Deed",
			"		i. Accept "..cq("Furlbrow's Deed"),
			completion={{questgoal={"*","Red Linen Bandana",6}},{questaccepted="Furlbrow's Deed"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=80216870,
		}, {
			"Go northwest to "..cl(80,69),
			"	a. Talk to Sara Timberlain",
			"		i. Turn in "..cq("Red Linen Goods"),
			completion={{questturnedin="Red Linen Goods"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=68814830,
		}, {
			"Go southwest to "..cl(74,72),
			"	a. Talk to Guard Thomas",
			"		i. Turn in "..cq("Protect the Frontier"),
			"		ii. Turn in "..cq("Report to Thomas"),
			"		iii. Accept "..cq("Deliver Thomas' Report"),
			completion={{questturnedin="Protect the Frontier"},{questturnedin="Report to Thomas"},{questaccepted="Deliver Thomas' Report"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=72214620,
		}, {
			"Go northwest to "..cl(60,50),
			"	a. Explore Jasperlode Mine",
			completion={{location={mapzone="Elwynn Forest",x=60.5,y=50.0, dist=0.3}}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=49711010,
		}, {
			"Hearth to Goldshire",
			completion={{location={mapzone="Elwynn Forest",x=42.4,y=65.8, dist=2}}},
			mapzone="Elwynn Forest",
			level=11,
		}, {
			"Go to "..cl(42,67),
			"	a. Talk to Marshal Dughan",
			"		i. Turn in "..cq("Deliver Thomas' Report"),
			"		ii. Turn in "..cq("The Jasperlode Mine"),
			"		iii. Accept "..cq("Westbrook Garrison Needs Help!"),
			completion={{questturnedin="Deliver Thomas' Report"},{questturnedin="The Jasperlode Mine"},{questaccepted="Westbrook Garrison Needs Help!"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=65910800,
		}, {
			"Go southwest to "..cl(24,75),
			"	a. Talk to Deputy Rainer",
			"		i. Turn in "..cq("Westbrook Garrison Needs Help!"),
			"		ii. Accept "..cq("Riverpaw Gnoll Bounty"),
			"	b. Click the Wanted Poster",
			"		i. Accept "..cq("Wanted: 'Hogger'"),
			completion={{questturnedin="Westbrook Garrison Needs Help!"},{questaccepted="Riverpaw Gnoll Bounty"},{questaccepted="Wanted: 'Hogger'"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=74809910,
		}, {
			"Go southeast to "..cl(27,86),
			"	a. Kill Riverpaw gnolls",
			"	b. Get 8 Painted Gnoll Armbands",
			"	c. Kill Hogger",
			"	d. Get the Huge Gnoll Claw",
			completion={{questgoal={"*","Painted Gnoll Armband",8}},{questgoal={"*","Huge Gnoll Claw",1}}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=86311310,
		}, {
			"Go northeast to Goldshire",
			completion={{location={mapzone="Elwynn Forest",x=42.4,y=65.8, dist=2}}},
			mapzone="Elwynn Forest",
			level=11,
		}, {
			"Go to "..cl(42,67),
			"	a. Talk to Marshal Dughan",
			"		i. Turn in "..cq("Wanted: 'Hogger'"),
			completion={{questturnedin="Wanted: 'Hogger'"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=65910800,
		}, {
			"Go southwest to "..cl(24,75),
			"	a. Talk to Deputy Rainer",
			"		i. Turn in "..cq("Riverpaw Gnoll Bounty"),
			completion={{questturnedin="Riverpaw Gnoll Bounty"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=74809910,
		}, {
			"Grind to level 13",
			completion={{level=13}},
			mapzone="Elwynn Forest",
			level=12,
		}, {
			"Go west to Westfall",
			completion={{location={mapzone="Westfall"}}},
			mapzone="Elwynn Forest",
			level=13,
		}
	  },
	},
	{ sectiontitle = "Draenei (1-13)",
	  defaultfor = "Draenei",
	  nextsection = 6,
	  steps = {
		{
			"Go southwest to "..cl(83,44),
			"	a. Talk to Megelon",
			"		i. Accept "..cq("You Survived!"),
			completion={{questaccepted="You Survived!"}},
			mapzone="Azuremyst Isle",
			level=1,
			mapnote=43912690,
		}, {
			"Go southwest to "..cl(80,46),
			"	a. Talk to Proenitus",
			"		i. Turn in "..cq("You Survived!"),
			"		ii. Accept "..cq("Replenishing the Healing Crystals"),
			completion={{questturnedin="You Survived!"},{questaccepted="Replenishing the Healing Crystals"}},
			mapzone="Azuremyst Isle",
			level=1,
			mapnote=45912630,
		}, {
			"Go southwest to "..cl(79,47),
			"	a. Talk to Botanist Taerix",
			"		i. Accept "..cq("Volatile Mutations"),
			completion={{questaccepted="Volatile Mutations"}},
			mapzone="Azuremyst Isle",
			level=1,
			mapnote=46512560,
		}, {
			"Go north to "..cl(79,45),
			"	a. Kill 8 Volatile Mutations",
			"	b. Kill Vale Moths",
			"	c. Get 8 Vials of Moth Blood",
			completion={{questgoal={"*","Volatile Mutation slain",8}},{questgoal={"*","Vial of Moth Blood",8}}},
			mapzone="Azuremyst Isle",
			level=1,
			mapnote=45412400,
		}, {
			"Grind to level 3",
			completion={{level=3}},
			mapzone="Azuremyst Isle",
			level=2,
		}, {
			"Go south to "..cl(79,47),
			"	a. Talk to Botanist Taerix",
			"		i. Turn in "..cq("Volatile Mutations"),
			"		ii. Accept "..cq("What Must Be Done..."),
			"	b. Talk to Apprentice Vishael",
			"		i. Accept "..cq("Botanical Legwork"),
			completion={{questturnedin="Volatile Mutations"},{questaccepted="What Must Be Done..."},{questaccepted="Botanical Legwork"}},
			mapzone="Azuremyst Isle",
			level=3,
			mapnote=46512560,
		}, {
			"Go northeast to "..cl(80,46),
			"	a. Talk to Proenitus",
			"		i. Turn in "..cq("Replenishing the Healing Crystals"),
			"		ii. Accept "..cq("Urgent Delivery!"),
			completion={{questturnedin="Replenishing the Healing Crystals"},{questaccepted="Urgent Delivery!"}},
			mapzone="Azuremyst Isle",
			level=3,
			mapnote=45912630,
		}, {
			"Go south to "..cl(80,49),
			"	a. Talk to Zalduun",
			"		i. Turn in "..cq("Urgent Delivery!"),
			"		ii. Accept "..cq("Rescue the Survivors!"),
			completion={{questturnedin="Urgent Delivery!"},{questaccepted="Rescue the Survivors!"}},
			mapzone="Azuremyst Isle",
			level=3,
			mapnote=48812890,
		}, {
			"Go south to "..cl(80,51),
			"	a. Talk to Technician Zhanaa",
			"		i. Accept "..cq("Spare Parts"),
			"	b. Talk to Vindicator Aldar",
			"		i. Accept "..cq("Inoculation"),
			completion={{questaccepted="Spare Parts"},{questaccepted="Inoculation"}},
			mapzone="Azuremyst Isle",
			level=3,
			mapnote=51413090,
		}, {
			"Go north to "..cl(80,42),
			"	a. They are Draeneis that are laying on the ground in this area",
			"	b. Use your racial ability, Gift of the Naaru, on a Draenei Survivor",
			"	c. Save a Draenei Survivor",
			completion={{questgoal={"*","Draenei Survivors Saved",1}}},
			mapzone="Azuremyst Isle",
			level=3,
			mapnote=42412270,
		}, {
			"Go south to "..cl(80,49),
			"	a. Talk to Zalduun",
			"		i. Turn in "..cq("Rescue the Survivors!"),
			completion={{questturnedin="Rescue the Survivors!"}},
			mapzone="Azuremyst Isle",
			level=3,
			mapnote=48812890,
		}, {
			"Go southwest to "..cl(75,50),
			"	a. Kill Mutated Root Lashers",
			"	b. Get 10 Lasher Samples",
			"	c. Click the tall red Corrupted Flowers",
			"	d. Get 3 Corrupted Flowers",
			completion={{questgoal={"*","Lasher Sample",10}},{questgoal={"*","Corrupted Flower",3}}},
			mapzone="Azuremyst Isle",
			level=3,
			mapnote=50412530,
		}, {
			"Grind to level 4",
			completion={{level=4}},
			mapzone="Azuremyst Isle",
			level=3,
		}, {
			"Go northeast to "..cl(79,47),
			"	a. Talk to Botanist Taerix",
			"		i. Turn in "..cq("What Must Be Done..."),
			"		ii. Accept "..cq("Healing the Lake"),
			"	b. Talk to Apprentice Vishael",
			"		i. Turn in "..cq("Botanical Legwork"),
			completion={{questturnedin="What Must Be Done..."},{questaccepted="Healing the Lake"},{questturnedin="Botanical Legwork"}},
			mapzone="Azuremyst Isle",
			level=4,
			mapnote=46512560,
		}, {
			"Go south to "..cl(77,59),
			"	a. It's a huge purple crystal sitting in the lake",
			"	b. Click the Irradiated Power Crystal",
			"	c. Disperse the Neutralizing Agent",
			completion={{questgoal={"*","Disperse the Neutralizing Agent",1}}},
			mapzone="Azuremyst Isle",
			level=4,
			mapnote=58713600,
		}, {
			"Go southeast to "..cl(78,60),
			"	a. Use your Inoculating Crystal on Nestlewood Owlkins",
			"	b. Inoculate 6 Nestlewood Owlkins",
			completion={{questgoal={"*","Nestlewood Owlkin inoculated",6}}},
			mapzone="Azuremyst Isle",
			level=4,
			mapnote=60413880,
		}, {
			"Go southeast to "..cl(85,65),
			"	a. They look like purple crystal guns sitting on the ground",
			"	b. Go through the tunnel into the small clearing",
			"	c. Click the Emitter Spare Parts",
			"	d. Get 4 Emitter Spare Parts",
			completion={{questgoal={"*","Emitter Spare Part",4}}},
			mapzone="Azuremyst Isle",
			level=4,
			mapnote=65615030,
		}, {
			"Grind to level 5",
			completion={{level=5}},
			mapzone="Azuremyst Isle",
			level=4,
		}, {
			"Hearth to Ammen Vale",
			completion={{location={mapzone="Azuremyst Isle",x=84.3,y=43.0, dist=0.5}}},
			mapzone="Azuremyst Isle",
			level=5,
		}, {
			"Go southwest to "..cl(79,47),
			"	a. Talk to Botanist Taerix",
			"		i. Turn in "..cq("Healing the Lake"),
			completion={{questturnedin="Healing the Lake"}},
			mapzone="Azuremyst Isle",
			level=5,
			mapnote=46512560,
		}, {
			"Go south to "..cl(79,51),
			"	a. Talk to Technician Zhanaa",
			"		i. Turn in "..cq("Spare Parts"),
			"	b. Talk to Vindicator Aldar",
			"		i. Turn in "..cq("Inoculation"),
			"		ii. Accept "..cq("The Missing Scout"),
			completion={{questturnedin="Spare Parts"},{questturnedin="Inoculation"},{questaccepted="The Missing Scout"}},
			mapzone="Azuremyst Isle",
			level=5,
			mapnote=51413090,
		}, {
			"Go southwest to "..cl(72,61),
			"	a. Talk to Tolaan",
			"		i. Turn in "..cq("The Missing Scout"),
			"		ii. Accept "..cq("The Blood Elves"),
			completion={{questturnedin="The Missing Scout"},{questaccepted="The Blood Elves"}},
			mapzone="Azuremyst Isle",
			level=5,
			mapnote=60813280,
		}, {
			"Go southwest to "..cl(70,63),
			"	a. The path up to 'The Blood Elves' starts here",
			completion={{location={mapzone="Azuremyst Isle",x=69.7,y=62.5, dist=0.3}}},
			mapzone="Azuremyst Isle",
			level=5,
			mapnote=62513210,
		}, {
			"Go southwest to "..cl(69,64),
			"	a. Kill 10 Blood Elf Scouts",
			completion={{questgoal={"*","Blood Elf Scout slain",10}}},
			mapzone="Azuremyst Isle",
			level=5,
			mapnote=64213340,
		}, {
			"Grind to level 6",
			completion={{level=6}},
			mapzone="Azuremyst Isle",
			level=5,
		}, {
			"Go northeast to "..cl(72,61),
			"	a. Talk to Tolaan",
			"		i. Turn in "..cq("The Blood Elves"),
			"		ii. Accept "..cq("Blood Elf Spy"),
			completion={{questturnedin="The Blood Elves"},{questaccepted="Blood Elf Spy"}},
			mapzone="Azuremyst Isle",
			level=6,
			mapnote=60813280,
		}, {
			"Go southwest to "..cl(69,66),
			"	a. Kill Surveyor Candress",
			"	b. Get the Blood Elf Plans",
			"	c. Click the Blood Elf Plans",
			"		i. Accept "..cq("Blood Elf Plans"),
			completion={{questgoal={"*","Surveyor Candress slain",1}},{questaccepted="Blood Elf Plans"}},
			mapzone="Azuremyst Isle",
			level=6,
			mapnote=65713500,
		}, {
			"Go northeast to "..cl(79,51),
			"	a. Talk to Vindicator Aldar",
			"		i. Turn in "..cq("Blood Elf Spy"),
			"		ii. Turn in "..cq("Blood Elf Plans"),
			"		iii. Accept "..cq("The Emitter"),
			"	b. Talk to Technician Zhanaa",
			"		i. Turn in "..cq("The Emitter"),
			"		ii. Accept "..cq("Travel to Azure Watch"),
			completion={{questturnedin="Blood Elf Spy"},{questturnedin="Blood Elf Plans"},{questaccepted="The Emitter"},{questturnedin="The Emitter"},{questaccepted="Travel to Azure Watch"}},
			mapzone="Azuremyst Isle",
			level=6,
			mapnote=51413090,
		}, {
			"Go west through the mountains",			
			completion={{location={mapzone="Azuremyst Isle",x=67.6,y=53.7, dist=0.5}}},
			mapzone="Azuremyst Isle",
			level=6,
		}, {
			"Go to "..cl(65,54),
			"	a. Talk to Aeun",
			"		i. Accept "..cq("Word from Azure Watch"),
			completion={{questaccepted="Word from Azure Watch"}},
			mapzone="Azuremyst Isle",
			level=6,
			mapnote=54011850,
		}, {
			"Go west to "..cl(61,54),
			"	a. Talk to Diktynna",
			"		i. Accept "..cq("Red Snapper - Very Tasty!"),
			completion={{questaccepted="Red Snapper - Very Tasty!"}},
			mapzone="Azuremyst Isle",
			level=6,
			mapnote=54211530,
		}, {
			"Go northeast to "..cl(62,52),
			"	a. They look like little round schools of fish in the water",
			"	b. Use your Draenei Fishing Net next to the Schools of Red Snapper",
			"	c. Get 10 Red Snappers",
			completion={{questgoal={"*","Red Snapper",10}}},
			mapzone="Azuremyst Isle",
			level=6,
			mapnote=51611350,
		}, {
			"Go southwest to "..cl(61,54),
			"	a. Talk to Diktynna",
			"		i. Turn in "..cq("Red Snapper - Very Tasty!"),
			"		ii. Accept "..cq("Find Acteon!"),
			completion={{questturnedin="Red Snapper - Very Tasty!"},{questaccepted="Find Acteon!"}},
			mapzone="Azuremyst Isle",
			level=6,
			mapnote=54211530,
		}, {
			"Go west to Azure Watch",
			completion={{location={mapzone="Azuremyst Isle",x=49.2,y=50.8, dist=2}}},
			mapzone="Azuremyst Isle",
			level=6,
		}, {
			"Go to "..cl(50,52),
			"	a. Talk to Acteon",
			"		i. Turn in "..cq("Find Acteon!"),
			"		ii. Accept "..cq("The Great Moongraze Hunt part 1"),
			completion={{questturnedin="Find Acteon!"},{questaccepted="The Great Moongraze Hunt part 1"}},
			mapzone="Azuremyst Isle",
			level=6,
			mapnote=51910170,
		}, {
			"Go to "..cl(48,52),
			"	a. Talk to Anchorite Fateema",
			"		i. Accept "..cq("Medicinal Purpose"),
			completion={{questaccepted="Medicinal Purpose"}},
			mapzone="Azuremyst Isle",
			level=6,
			mapnote=51810020,
		}, {
			"Go to "..cl(49,50),
			"	a. Talk to Technician Dyvuun",
			"		i. Turn in "..cq("Travel to Azure Watch"),
			completion={{questturnedin="Travel to Azure Watch"}},
			mapzone="Azuremyst Isle",
			level=6,
			mapnote=50309900,
		}, {
			"Go to "..cl(48,59),
			"	a. Talk to Caregiver Chellan",
			"		i. Turn in "..cq("Word from Azure Watch"),
			completion={{questturnedin="Word from Azure Watch"}},
			mapzone="Azuremyst Isle",
			level=6,
			mapnote=49209750,
		}, {
			"Make Azure Watch your home",
			completion={{home="Azure Watch"}},
			mapzone="Azuremyst Isle",
			level=6,
		}, {
			"Go southeast to "..cl(50,57),
			"	a. Kill Moongraze Stag",
			"	b. Get 6 Moongraze Stag Tenderloins",
			"	c. Kill Root Trappers",
			"	d. Get 8 Root Trapper Vines",
			completion={{questgoal={"*","Moongraze Stag Tenderloin",6}},{questgoal={"*","Root Trapper Vine",8}}},
			mapzone="Azuremyst Isle",
			level=6,
			mapnote=56610690,
		}, {
			"Go southwest to Odesyus' Landing",
			completion={{location={mapzone="Azuremyst Isle",x=46.7,y=70.4, dist=2}}},
			mapzone="Azuremyst Isle",
			level=6,
		}, {
			"Go to "..cl(47,70),
			"	a. Talk to Admiral Odesyus",
			"		i. Accept "..cq("A Small Start"),
			completion={{questaccepted="A Small Start"}},
			mapzone="Azuremyst Isle",
			level=6,
			mapnote=70211720,
		}, {
			"Go to "..cl(47,71),
			"	a. Talk to 'Cookie' McWeaksauce",
			"		i. Accept "..cq("Cookie's Jumbo Gumbo"),
			completion={{questaccepted="Cookie's Jumbo Gumbo"}},
			mapzone="Azuremyst Isle",
			level=6,
			mapnote=70511720,
		}, {
			"Go south to "..cl(48,73),
			"	a. Kill Skittering Crawlers",
			"	b. Get 6 Skittering Crawler Meat",
			completion={{questgoal={"*","Skittering Crawler Meat",6}}},
			mapzone="Azuremyst Isle",
			level=6,
			mapnote=73012060,
		}, {
			"Go north to Odesyus' Landing",
			completion={{location={mapzone="Azuremyst Isle",x=46.7,y=70.4, dist=2}}},
			mapzone="Azuremyst Isle",
			level=6,
		}, {
			"Go to "..cl(47,71),
			"	a. Talk to 'Cookie' McWeaksauce",
			"		i. Turn in "..cq("Cookie's Jumbo Gumbo"),
			completion={{questturnedin="Cookie's Jumbo Gumbo"}},
			mapzone="Azuremyst Isle",
			level=6,
			mapnote=70511720,
		}, {
			"Go to "..cl(47,70),
			"	a. Talk to Priestess Kyleen Il'dinare",
			"		i. Accept "..cq("Reclaiming the Ruins"),
			completion={{questaccepted="Reclaiming the Ruins"}},
			mapzone="Azuremyst Isle",
			level=6,
			mapnote=70211720,
		}, {
			"Also at "..cl(47,70),	
			"	b. Talk to Archaeologist Adamant Ironheart",
			"		i. Accept "..cq("Precious and Fragile Things Need Special Handling"),
			completion={{questaccepted="Precious and Fragile Things Need Special Handling"}},
			mapzone="Azuremyst Isle",
			level=6,
			mapnote=70011720,
		}, {
			"Go east to "..cl(59,66),
			"	a. Click the Nautical Map under the green canopy",
			"	b. Get the Nautical Map",
			completion={{questgoal={"*","Nautical Map",1}}},
			mapzone="Azuremyst Isle",
			level=6,
			mapnote=66412500,
		}, {
			"Go southeast to "..cl(60,68),
			"	a. Click the Nautical Compass under the blue canopy with a green stripe on it",
			"	b. Get the Nautical Compass",
			completion={{questgoal={"*","Nautical Compass",1}}},
			mapzone="Azuremyst Isle",
			level=6,
			mapnote=67612720,
		}, {
			"Grind to level 8",
			completion={{level=8}},
			mapzone="Azuremyst Isle",
			level=7,
		}, {
			"Go west to Odesyus' Landing",
			completion={{location={mapzone="Azuremyst Isle",x=46.7,y=70.4, dist=2}}},
			mapzone="Azuremyst Isle",
			level=8,
		}, {
			"Go to "..cl(47,70),
			"	a. Talk to Admiral Odesyus",
			"		i. Turn in "..cq("A Small Start"),
			"		ii. Accept "..cq("I've Got a Plant"),
			completion={{questturnedin="A Small Start"},{questaccepted="I've Got a Plant"}},
			mapzone="Azuremyst Isle",
			level=8,
			mapnote=70211720,
		}, {
			"Go north to "..cl(46,66),
			"	a. They look like tall, skinny tree stumps around this area",
			"	b. Click a Hollowed Out Tree",
			"	c. Get a Hollowed Out Tree",
			"	d. Click the small piles of purple leaves",
			"	e. Get 5 Piles of Leaves",
			completion={{questgoal={"*","Hollowed Out Tree",1}},{questgoal={"*","Pile of Leaves",5}}},
			mapzone="Azuremyst Isle",
			level=8,
			mapnote=65711160,
		}, {
			"Go south to Odesyus' Landing",
			completion={{location={mapzone="Azuremyst Isle",x=46.7,y=70.4, dist=2}}},
			mapzone="Azuremyst Isle",
			level=8,
		}, {
			"Go to "..cl(47,70),
			"	a. Talk to Admiral Odesyus",
			"		i. Turn in "..cq("I've Got a Plant"),
			"		ii. Accept "..cq("Tree's Company"),
			completion={{questturnedin="I've Got a Plant"},{questaccepted="Tree's Company"}},
			mapzone="Azuremyst Isle",
			mapnote=70211720,
			level=8,
		}, {
			"Go southwest to "..cl(36,77),
			"	a. Click the white glowing orbs",
			"	b. Get 8 Ancient Relics",
			"	c. Kill 5 Wrathscale Myrmidons",
			"	d. Kill 5 Wrathscale Nagas",
			"	e. Kill 5 Wrathscale Sirens",
			"	f. Kill nagas",
			"	g. Get a Rune Covered Tablet",
			"	h. Click the Rune Covered Tablet",
			"		i. Accept "..cq("Rune Covered Tablet"),
			completion={{questgoal={"*","Ancient Relic",8}},{questgoal={"*","Wrathscale Myrmidon slain",5}},{questgoal={"*","Wrathscale Naga slain",5}},{questgoal={"*","Wrathscale Siren slain",5}},{questaccepted="Rune Covered Tablet"}},
			mapzone="Azuremyst Isle",
			level=8,
			mapnote=77011310,
		}, {
			"Go southwest to "..cl(18,84),
			"	a. Use your Tree Disguise Kit next to the Naga Flag on the beach",
			"	b. Watch the conversation",
			"	c. Uncover the Traitor",
			completion={{questgoal={"*","The Traitor Uncovered",1}}},
			mapzone="Azuremyst Isle",
			level=8,
			mapnote=84310280,
		}, {
			"Hearth to Azure Watch",
			completion={{location={mapzone="Azuremyst Isle",x=49.2,y=50.8, dist=2}}},
			mapzone="Azuremyst Isle",
			level=8,
		}, {
			"Go to "..cl(49,51),
			"	a. Talk to Dulvi",
			"		i. Accept "..cq("The Missing Fisherman"),
			completion={{questaccepted="The Missing Fisherman"}},
			mapzone="Azuremyst Isle",
			level=8,
			mapnote=51110010,
		}, {
			"Go to "..cl(48,52),
			"	a. Talk to Anchorite Fateema",
			"		i. Turn in "..cq("Medicinal Purpose"),
			"	b. Talk to Daedal",
			"		i. Accept "..cq("An Alternative Alternative"),
			completion={{questturnedin="Medicinal Purpose"},{questaccepted="An Alternative Alternative"}},
			mapzone="Azuremyst Isle",
			level=8,
			mapnote=51810020,
		}, {
			"Go to "..cl(50,52),
			"	a. Talk to Acteon",
			"		i. Turn in "..cq("The Great Moongraze Hunt part 1"),
			"		ii. Accept "..cq("The Great Moongraze Hunt part 2"),
			completion={{questturnedin="The Great Moongraze Hunt part 1"},{questaccepted="The Great Moongraze Hunt part 2"}},
			mapzone="Azuremyst Isle",
			level=8,
			mapnote=51910170,
		}, {
			"Go northeast to "..cl(51,46),
			"	a. Kill Moongraze Bucks",
			"	b. Get 6 Moongraze Buck Hides",
			"	c. Kill Infected Nightstalker Runts",
			"	d. Get a Faintly Glowing Crystal",
			"	e. Click the Faintly Glowing Crystal",
			"		i. Accept "..cq("Strange Findings"),
			completion={{questgoal={"*","Moongraze Buck Hide",6}},{questaccepted="Strange Findings"}},
			mapzone="Azuremyst Isle",
			level=8,
			mapnote=46209680,
		}, {
			"Go north to "..cl(50,37),
			"	a. They are tall flowers with big bulbs that puff smoke at the base of trees",
			"	b. Click the Azure Snapdragons",
			"	c. Get 5 Azure Snapdragon Bulbs",
			completion={{questgoal={"*","Azure Snapdragon Bulb",5}}},
			mapzone="Azuremyst Isle",
			level=8,
			mapnote=37108750,
		}, {
			"Go south to Azure Watch",
			completion={{location={mapzone="Azuremyst Isle",x=49.2,y=50.8, dist=2}}},
			mapzone="Azuremyst Isle",
			level=8,
		}, {
			"Go to "..cl(47,51),
			"	a. Talk to Exarch Menelaous",
			"		i. Turn in "..cq("Strange Findings"),
			"		ii. Accept "..cq("Nightstalker Clean Up, Isle 2..."),
			completion={{questturnedin="Strange Findings"},{questaccepted="Nightstalker Clean Up, Isle 2..."}},
			mapzone="Azuremyst Isle",
			level=8,
			mapnote=50609770,
		}, {
			"Go to "..cl(48,52),
			"	a. Talk to Daedal",
			"		i. Turn in "..cq("An Alternative Alternative"),
			completion={{questturnedin="An Alternative Alternative"}},
			mapzone="Azuremyst Isle",
			level=8,
			mapnote=51810020,
		}, {
			"Go to "..cl(50,52),
			"	a. Talk to Acteon",
			"		i. Turn in "..cq("The Great Moongraze Hunt part 2"),
			completion={{questturnedin="The Great Moongraze Hunt part 2"}},
			mapzone="Azuremyst Isle",
			level=8,
			mapnote=51910170,
		}, {
			"Go northwest to "..cl(46,44),
			"	a. Kill 8 Infected Nightstalker Runts",
			completion={{questgoal={"*","Infected Nightstalker Runt slain",8}}},
			mapzone="Azuremyst Isle",
			level=8,
			mapnote=43908960,
		}, {
			"Go southeast to Azure Watch",
			completion={{location={mapzone="Azuremyst Isle",x=49.2,y=50.8, dist=2}}},
			mapzone="Azuremyst Isle",
			level=8,
		}, {
			"Go to "..cl(47,51),
			"	a. Talk to Exarch Menelaous",
			"		i. Turn in "..cq("Nightstalker Clean Up, Isle 2..."),
			completion={{questturnedin="Nightstalker Clean Up, Isle 2..."}},
			mapzone="Azuremyst Isle",
			level=8,
			mapnote=50609770,
		}, {
			"Go southwest to Odesyus' Landing",
			completion={{location={mapzone="Azuremyst Isle",x=46.7,y=70.4, dist=2}}},
			mapzone="Azuremyst Isle",
			level=8,
		}, {
			"Go to "..cl(47,70),
			"	a. Talk to Admiral Odesyus",
			"		i. Turn in "..cq("Tree's Company"),
			"		ii. Accept "..cq("Show Gnomercy"),
			"	b. Talk to Priestess Kyleen Il'dinare",
			"		i. Turn in "..cq("Reclaiming the Ruins"),
			"		ii. Turn in "..cq("Rune Covered Tablet"),
			"		iii. Accept "..cq("Warlord Sriss'tiz"),
			completion={{questturnedin="Tree's Company"},{questaccepted="Show Gnomercy"},{questturnedin="Reclaiming the Ruins"},{questturnedin="Rune Covered Tablet"},{questaccepted="Warlord Sriss'tiz"}},
			mapzone="Azuremyst Isle",
			level=8,
			mapnote=70211720,
		}, {
			"Also at "..cl(47,70),
			"	a. Talk to Archaeologist Adamant Ironheart",
			"		i. Turn in "..cq("Precious and Fragile Things Need Special Handling"),
			completion={{questturnedin="Precious and Fragile Things Need Special Handling"}},
			mapzone="Azuremyst Isle",
			level=8,
			mapnote=70011720,
		}, {
			"Go southeast to "..cl(48,72),
			"	a. He walks along the beach in this area",
			"	b. Kill Engineer 'Spark' Overgrind",
			"	c. Get the Traitor's Communication",
			completion={{questgoal={"*","Traitor's Communication",1}}},
			mapzone="Azuremyst Isle",
			level=8,
			mapnote=72512070,
		}, {
			"Go northwest to Odesyus' Landing",
			completion={{location={mapzone="Azuremyst Isle",x=46.7,y=70.4, dist=2}}},
			mapzone="Azuremyst Isle",
			level=8,
		}, {
			"Go to "..cl(47,70),
			"	a. Talk to Admiral Odesyus",
			"		i. Turn in "..cq("Show Gnomercy"),
			"		ii. Accept "..cq("Deliver Them From Evil..."),
			completion={{questturnedin="Show Gnomercy"},{questaccepted="Deliver Them From Evil..."}},
			mapzone="Azuremyst Isle",
			level=8,
			mapnote=70211720,
		}, {
			"Go northeast to Azure Watch",
			completion={{location={mapzone="Azuremyst Isle",x=49.2,y=50.8, dist=2}}},
			mapzone="Azuremyst Isle",
			level=8,
		}, {
			"Go to "..cl(47,51),
			"	a. Talk to Exarch Menelaous",
			"		i. Turn in "..cq("Deliver Them From Evil..."),
			completion={{questturnedin="Deliver Them From Evil..."}},
			mapzone="Azuremyst Isle",
			level=8,
			mapnote=50609770,
		}, {
			"Go to "..cl(49,51),
			"	a. Talk to Cryptographer Aurren",
			"		i. Accept "..cq("Learning the Language"),
			"	b. Click the Stillpine Furbolg Language Primer in your bags",
			"	c. Click the Totem of Akida next to Cryptographer Aurren",
			"		i. Turn in "..cq("Learning the Language"),
			"		ii. Accept "..cq("Totem of Coo"),
			completion={{questaccepted="Learning the Language"},{questturnedin="Learning the Language"},{questaccepted="Totem of Coo"}},
			mapzone="Azuremyst Isle",
			level=8,
			mapnote=51110010,
		}, {
			"Follow the ghost furbolg as he runs up the hill northeast",
			mapzone="Azuremyst Isle",
			level=8,
		}, {
			"At "..cl(55,42),
			"	a. Click the Totem of Coo",
			"		i. Turn in "..cq("Totem of Coo"),
			"		ii. Accept "..cq("Totem of Tikti"),
			completion={{questturnedin="Totem of Coo"},{questaccepted="Totem of Tikti"}},
			mapzone="Azuremyst Isle",
			level=8,
			mapnote=41609680,
		}, {
			"Follow the ghost furbolg to the edge of the cliff",
			"	a. He will give you wings",
			"	b. Jump off the cliff and glide to the ground",
			mapzone="Azuremyst Isle",
			level=8,
		}, {
			"Go to "..cl(65,40),
			"	a. Click the Totem of Tikti",
			"		i. Turn in "..cq("Totem of Tikti"),
			"		ii. Accept "..cq("Totem of Yor"),
			completion={{questturnedin="Totem of Tikti"},{questaccepted="Totem of Yor"}},
			mapzone="Azuremyst Isle",
			level=8,
			mapnote=39810430,
		}, {
			"Follow the ghost furbolg to the river",
			"	a. He will give you a swim speed buff",
			"	b. Swim south",
			mapzone="Azuremyst Isle",
			level=8,
		}, {
			"Go to "..cl(63,68),
			"	a. Click the Totem of Yor underwater",
			"		i. Turn in "..cq("Totem of Yor"),
			"		ii. Accept "..cq("Totem of Vark"),
			completion={{questturnedin="Totem of Yor"},{questaccepted="Totem of Vark"}},
			mapzone="Azuremyst Isle",
			level=8,
			mapnote=67913090,
		}, {
			"Follow the ghost furbolg out of the water",
			"	a. He will turn you into a ghost panther",
			"	b. Follow him as he runs northwest",
			mapzone="Azuremyst Isle",
			level=8,
		}, {
			"Go to "..cl(28,62),
			"	a. Click the Totem of Vark",
			"		i. Turn in "..cq("Totem of Vark"),
			"		ii. Accept "..cq("The Prophecy of Akida"),
			completion={{questturnedin="Totem of Vark"},{questaccepted="The Prophecy of Akida"}},
			mapzone="Azuremyst Isle",
			level=8,
			mapnote=62409050,
		}, {
			"Go south to "..cl(29,66),
			"	a. Kill Bristlelimb furbolgs",
			"	b. Get 8 Bristlelimb Keys",
			"	c. Click the yellow cages",
			"	d. Free 8 Stillpine Captives",
			completion={{questgoal={"*","Stillpine Captive Freed",8}}},
			mapzone="Azuremyst Isle",
			level=8,
			mapnote=66409490,
		}, {
			"Grind to level 10",
			completion={{level=10}},
			mapzone="Azuremyst Isle",
			level=9,
		}, {
			"Go south to "..cl(27,77),
			"	a. The path down to 'Warlord Sriss'tiz' starts here",
			"	b. Go inside the cave",
			completion={{location={mapzone="Azuremyst Isle",x=27.0,y=76.7, dist=0.3}}},
			mapzone="Azuremyst Isle",
			level=10,
			mapnote=76710370,
		}, {
			"Follow the path to the bottom of the cave",
			mapzone="Azuremyst Isle",
			level=10,
		}, {
			"Go to "..cl(25,75),
			"	a. Kill Warlord Sriss'tiz",
			completion={{questgoal={"*","Warlord Sriss'tiz slain",1}}},
			mapzone="Azuremyst Isle",
			level=10,
			mapnote=74509910,
		}, {
			"Leave the cave",
			completion={{location={mapzone="Azuremyst Isle",x=27.0,y=76.7, dist=0.3}}},
			mapzone="Azuremyst Isle",
			level=10,
		}, {
			"Go southwest to "..cl(17,95),
			"	a. Talk to Cowlen",
			"		i. Turn in "..cq("The Missing Fisherman"),
			"		ii. Accept "..cq("All That Remains"),
			completion={{questturnedin="The Missing Fisherman"},{questaccepted="All That Remains"}},
			mapzone="Azuremyst Isle",
			level=10,
			mapnote=94511110,
		}, {
			"Go northwest to "..cl(15,92),
			"	a. Kill owl beasts",
			"	b. Get the Remains of Cowlen's Family",
			completion={{questgoal={"*","Remains of Cowlen's Family",1}}},
			mapzone="Azuremyst Isle",
			level=10,
			mapnote=92010680,
		}, {
			"Go southeast to "..cl(17,95),
			"	a. Talk to Cowlen",
			"		i. Turn in "..cq("All That Remains"),
			completion={{questturnedin="All That Remains"}},
			mapzone="Azuremyst Isle",
			level=10,
			mapnote=94511110,
		}, {
			"Hearth to Azure Watch",
			completion={{location={mapzone="Azuremyst Isle",x=49.2,y=50.8, dist=2}}},
			mapzone="Azuremyst Isle",
			level=10,
		}, {
			"Go to "..cl(49,51),
			"	a. Talk to Arugoo the Stillpine",
			"		i. Turn in "..cq("The Prophecy of Akida"),
			"		ii. Accept "..cq("Stillpine Hold"),
			completion={{questturnedin="The Prophecy of Akida"},{questaccepted="Stillpine Hold"}},
			mapzone="Azuremyst Isle",
			level=10,
			mapnote=51110010,
		}, {
			"Go southwest to Odesyus' Landing",
			completion={{location={mapzone="Azuremyst Isle",x=46.7,y=70.4, dist=2}}},
			mapzone="Azuremyst Isle",
			level=10,
		}, {
			"Go to "..cl(47,70),
			"	a. Talk to Priestess Kyleen Il'dinare",
			"		i. Turn in "..cq("Warlord Sriss'tiz"),
			completion={{questturnedin="Warlord Sriss'tiz"}},
			mapzone="Azuremyst Isle",
			level=10,
			mapnote=70211720,
		}, {
			"Go northeast to Azure Watch",
			completion={{location={mapzone="Azuremyst Isle",x=49.2,y=50.8, dist=2}}},
			mapzone="Azuremyst Isle",
			level=10,
		}, {
			"Go to "..cl(47,51),
			"	a. Talk to Exarch Menelaous",
			"		i. Accept "..cq("Coming of Age"),
			completion={{questaccepted="Coming of Age"}},
			mapzone="Azuremyst Isle",
			level=10,
			mapnote=50609770,
		}, {
			"Go northwest to Stillpine Hold",
			completion={{location={mapzone="Azuremyst Isle",x=45.5,y=21.9, dist=4}}},
			mapzone="Azuremyst Isle",
			level=10,
		}, {
			"Go to "..cl(47,21),
			"	a. Talk to High Chief Stillpine",
			"		i. Turn in "..cq("Stillpine Hold"),
			completion={{questturnedin="Stillpine Hold"}},
			mapzone="Azuremyst Isle",
			level=10,
			mapnote=20606730,
		}, {
			"Go to "..cl(45,24),
			"	a. Talk to Gurf",
			"		i. Accept "..cq("Murlocs... Why Here? Why Now?"),
			completion={{questaccepted="Murlocs... Why Here? Why Now?"}},
			mapzone="Azuremyst Isle",
			level=10,
			mapnote=23606830,
		}, {
			"Go southwest to "..cl(34,26),
			"	a. Kill murlocs and click the Stillpine Grain bags in the murloc huts",
			"	b. Get 5 Stillpine Grain",
			"	c. Murgurgala walks up and down he beach in this area",
			"	d. Kill Murgurgala",
			"	e. Get Gurf's Dignity",
			"	f. Click Gurf's Dignity",
			"		i. Accept "..cq("Gurf's Dignity"),
			completion={{questgoal={"*","Stillpine Grain",5}},{questaccepted="Gurf's Dignity"}},
			mapzone="Azuremyst Isle",
			level=10,
			mapnote=25705950,
		}, {
			"Grind to level 11",
			completion={{level=11}},
			mapzone="Azuremyst Isle",
			level=10,
		}, {
			"Go northeast to Stillpine Hold",
			completion={{location={mapzone="Azuremyst Isle",x=45.5,y=21.9, dist=4}}},
			mapzone="Azuremyst Isle",
			level=11,
		}, {
			"Go to "..cl(45,24),
			"	a. Talk to Gurf",
			"		i. Turn in "..cq("Murlocs... Why Here? Why Now?"),
			"		ii. Turn in "..cq("Gurf's Dignity"),
			completion={{questturnedin="Murlocs... Why Here? Why Now?"},{questturnedin="Gurf's Dignity"}},
			mapzone="Azuremyst Isle",
			level=11,
			mapnote=23606830,
		}, {
			"Go southwest to "..cl(35,43),
			"	a. Talk to Torallius the Pack Handler",
			"		i. Turn in "..cq("Coming of Age"),
			completion={{questturnedin="Coming of Age"}},
			mapzone="Azuremyst Isle",
			level=11,
			mapnote=43407850,
		}, {
			"Go southwest to "..cl(22,54),
			"	a. Ride the boat to Auberdine",
			completion={{location={mapzone="Darkshore",x=32.8,y=42.0, dist=9}}},
			mapzone="Darkshore",
			level=11,
		}, {
			"Go to "..cl(36,46),
			"	a. Talk to Caylais Moonfeather",
			"		i. Get the Auberdine Flight Path",
			completion={{flightpath="Auberdine"}},
			mapzone="Darkshore",
			level=11,
			mapnote=45608190,
		}, {
			"Ride the boat to Menethil Harbor",
			completion={{location={mapzone="Wetlands",x=4.6,y=56.8, dist=9}}},
			mapzone="Darkshore",
			level=11,
		}, {
			"Go to 9,60",
			"	a. Talk to Shellei Brondir",
			"		i. Get the Menethil Harbor Flight Path",
			completion={{flightpath="Menethil Harbor"}},
			mapzone="Wetlands",
			level=11,
			mapnote=59706920,
		}, {
			"Follow the road southeast to Loch Modan",
			completion={{location={mapzone="Loch Modan",x=25.6,y=10.6, dist=1}}},
			mapzone="Wetlands",
			level=11,
		}, {
			"Go southeast to Thelsamar",
			completion={{location={mapzone="Loch Modan",x=35.1,y=46.9, dist=3}}},
			mapzone="Loch Modan",
			level=11,
		}, {
			"Go to "..cl(34,51),
			"	a. Talk to Thorgrum Borrelson",
			"		i. Get the Thelsamar Flight Path",
			completion={{flightpath="Thelsamar"}},
			mapzone="Loch Modan",
			level=11,
			mapnote=51008490,
		}, {
			"Go southwest to Dun Morogh",
			completion={{location={mapzone="Dun Morogh",x=86.2,y=51.3, dist=1}}},
			mapzone="Loch Modan",
			level=11,
		}, {
			"Go northwest to Ironforge",
			completion={{location={mapzone="City of Ironforge"}}},
			mapzone="Dun Morogh",
			level=11,
		}, {
			"Go to "..cl(56,48),
			"	a. Talk to Gryth Thurden",
			"		i. Get the Ironforge Flight Path",
			completion={{flightpath="Ironforge"}},
			mapzone="Ironforge",
			level=11,
			mapnote=47710320,
		}, {
			"Go to the Deeprun Tram",
			completion={{location={mapzone="Deeprun Tram"}}},
			mapzone="Ironforge",
			level=11,
		}, {
			"Ride the tram to Stormwind City",
			completion={{location={mapzone="Stormwind City"}}},
			mapzone="Ironforge",
			level=11,
		}, {
			"Go to "..cl(66,62),
			"	a. Talk to Dungar Longdrink",
			"		i. Get the Stormwind City Flight Path",
			completion={{flightpath="Stormwind City"}},
			mapzone="Stormwind City",
			level=11,
			mapnote=62112840,
		}, {
			"Go southeast to Goldshire",
			completion={{location={mapzone="Elwynn Forest",x=42.4,y=65.8, dist=2}}},
			mapzone="Elwynn Forest",
			level=11,

		}, {
			"Go to "..cl(42,66),
			"	a. Talk to Marshal Dughan",
			"		i. Accept "..cq("The Fargodeep Mine"),
			completion={{questaccepted="The Fargodeep Mine"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=65910800,
		}, {
			"Go to "..cl(43,66),
			"	a. Talk to William Pestle",
			"		i. Accept "..cq("Kobold Candles"),
			completion={{questaccepted="Kobold Candles"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=65710900,
		}, {
			"Make Goldshire your home",
			completion={{home="Goldshire"}},
			mapzone="Elwynn Forest",
			level=11,
		}, {
			"Go to "..cl(42,67),
			"	a. Talk to Remy 'Two Times'",
			"		i. Accept "..cq("Gold Dust Exchange"),
			completion={{questaccepted="Gold Dust Exchange"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=67310940,
		}, {
			"Go southwest to "..cl(39,82),
			"	a. Kill kobolds",
			"	b. Get 8 Kobold Candles",
			"	c. Get 10 Gold Dust",
			completion={{questgoal={"*","Large Candle",8}},{questgoal={"*","Gold Dust",10}}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=82312130,
		}, {
			"Go northwest to "..cl(41,79),
			"	a. Explore Fargodeep Mine",
			completion={{location={mapzone="Elwynn Forest",x=41.2,y=78.9, dist=0.5}}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=79112040,
		}, {
			"Go southwest to "..cl(35,84),
			"	a. Talk to 'Auntie' Bernice Stonefield",
			"		i. Accept "..cq("Lost Necklace"),
			completion={{questaccepted="Lost Necklace"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=84211870,
		}, {
			"Go east to "..cl(43,86),
			"	a. Talk to Billy Maclure",
			"		i. Turn in "..cq("Lost Necklace"),
			"		ii. Accept "..cq("Pie for Billy"),
			completion={{questturnedin="Lost Necklace"},{questaccepted="Pie for Billy"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=85712880,
		}, {
			"Go southwest to "..cl(42,87),
			"	a. Kill boars",
			"	b. Get 4 Chunks of Boar Meat",
			completion={{questgoal={"*","Chunk of Boar Meat",4}}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=86912860,
		}, {
			"Go southeast to "..cl(43,90),
			"	a. Talk to Maybell Maclure",
			"		i. Accept "..cq("Young Lovers"),
			completion={{questaccepted="Young Lovers"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=89613280,
		}, {
			"Go northwest to "..cl(35,84),
			"	a. Talk to 'Auntie' Bernice Stonefield",
			"		i. Turn in "..cq("Pie for Billy"),
			"		ii. Accept "..cq("Back to Billy"),
			completion={{questturnedin="Pie for Billy"},{questaccepted="Back to Billy"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=84211870,
		}, {
			"Go west to "..cl(30,86),
			"	a. Talk to Tommy Joe Stonefield",
			"		i. Turn in "..cq("Young Lovers"),
			"		ii. Accept "..cq("Speak with Gramma"),
			completion={{questturnedin="Young Lovers"},{questaccepted="Speak with Gramma"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=86011580,
		}, {
			"Go east "..cl(35,84),
			"	a. Talk to Gramma Stonefield",
			"		i. Turn in "..cq("Speak with Gramma"),
			"		ii. Accept "..cq("Note to William"),
			completion={{questturnedin="Speak with Gramma"},{questaccepted="Note to William"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=83911880,
		}, {
			"Go east to "..cl(43,86),
			"	a. Talk to Billy Maclure",
			"		i. Turn in "..cq("Back to Billy"),
			"		ii. Accept "..cq("Goldtooth"),
			completion={{questturnedin="Back to Billy"},{questaccepted="Goldtooth"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=85712880,
		}, {
			"Go northwest into the Fargodeep Mine",
			"	a. Enter using the lower entrance",
			completion={{location={mapzone="Elwynn Forest",x=38.3,y=81.6, dist=0.5}}},
			mapzone="Elwynn Forest",
			level=11,
		}, {
			"Follow the path inside the cave to "..cl(42,78),
			"	a. Kill Goldtooth",
			"	b. Get Bernice's Necklace",
			completion={{questgoal={"*","Bernice's Necklace",1}}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=78312000,
		}, {
			"Hearth to Goldshire",
			completion={{location={mapzone="Elwynn Forest",x=42.4,y=65.8, dist=2}}},
			mapzone="Elwynn Forest",
			level=11,
		}, {
			"Go to "..cl(42,67),
			"	a. Talk to Remy 'Two Times'",
			"		i. Turn in "..cq("Gold Dust Exchange"),
			"		ii. Accept "..cq("A Fishy Peril"),
			completion={{questturnedin="Gold Dust Exchange"},{questaccepted="A Fishy Peril"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=67310940,
		}, {			
			"Go to "..cl(42,66),
			"	a. Talk to Marshal Dughan",
			"		i. Turn in "..cq("The Fargodeep Mine"),
			"		ii. Turn in "..cq("A Fishy Peril"),
			"		iii. Accept "..cq("The Jasperlode Mine"),
			"		iv. Accept "..cq("Further Concerns"),
			completion={{questturnedin="The Fargodeep Mine"},{questturnedin="A Fishy Peril"},{questaccepted="The Jasperlode Mine"},{questaccepted="Further Concerns"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=65910800,
		}, {
			"Go to "..cl(43,66),
			"	a. Talk to William Pestle",
			"		i. Turn in "..cq("Kobold Candles"),
			"		ii. Turn in "..cq("Note to William"),
			"		iii. Accept "..cq("Collecting Kelp"),
			completion={{questturnedin="Kobold Candles"},{questturnedin="Note to William"},{questaccepted="Collecting Kelp"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=65710900,
		}, {
			"Go east to "..cl(50,66),
			"	a. Kill murlocs",
			"	b. Get 4 Crystal Kelp Fronds",
			completion={{questgoal={"*","Crystal Kelp Frond",4}}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=66311600,
		}, {
			"Go west to Goldshire",
			completion={{location={mapzone="Elwynn Forest",x=42.4,y=65.8, dist=2}}},
			mapzone="Elwynn Forest",
			level=11,
		}, {
			"Go to "..cl(43,66),
			"	a. Talk to William Pestle",
			"		i. Turn in "..cq("Collecting Kelp"),
			"		ii. Accept "..cq("The Escape"),
			completion={{questturnedin="Collecting Kelp"},{questaccepted="The Escape"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=65710900,
		}, {
			"Go south to "..cl(43,90),
			"	a. Talk to Maybell Maclure",
			"		i. Turn in "..cq("The Escape"),
			completion={{questturnedin="The Escape"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=89613280,
		}, {
			"Go northwest to "..cl(34,84),
			"	a. Talk to 'Auntie' Bernice Stonefield",
			"		i. Turn in "..cq("Goldtooth"),
			completion={{questturnedin="Goldtooth"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=84211870,
		}, {
			"Go northeast to "..cl(74,72),
			"	a. Talk to Guard Thomas",
			"		i. Turn in "..cq("Further Concerns"),
			"		ii. Accept "..cq("Find the Lost Guards"),
			"		iii. Accept "..cq("Protect the Frontier"),
			completion={{questturnedin="Further Concerns"},{questaccepted="Find the Lost Guards"},{questaccepted="Protect the Frontier"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=72214620,
		}, {
			"Go northeast to "..cl(80,69),
			"	a. Talk to Sara Timberlain",
			"		i. Accept "..cq("Red Linen Goods"),
			completion={{questaccepted="Red Linen Goods"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=68814830,
		}, {
			"Go northeast to "..cl(81,66),
			"	a. Talk to Supervisor Raelen",
			"		i. Accept "..cq("A Bundle of Trouble"),
			completion={{questaccepted="A Bundle of Trouble"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=66114750,
		}, {
			"Go north to "..cl(81,61),
			"	a. Get 8 Bundles of Wood",
			completion={{questgoal={"*","Bundle of Wood",8}}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=60614190,
		}, {
			"Go west to "..cl(73,60),
			"	a. Click the Half-Eaten Body",
			"		i. Turn in "..cq("Find the Lost Guards"),
			"		ii. Accept "..cq("Discover Rolf's Fate"),
			completion={{questturnedin="Find the Lost Guards"},{questaccepted="Discover Rolf's Fate"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=60313300,
		}, {
			"Go northeast to "..cl(80,56),
			"	a. Click Rolf's Corpse",
			"		i. Turn in "..cq("Discover Rolf's Fate"),
			"		ii. Accept "..cq("Report to Thomas"),
			completion={{questturnedin="Discover Rolf's Fate"},{questaccepted="Report to Thomas"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=55513530,
		}, {
			"Go south to "..cl(81,66),
			"	a. Talk to Supervisor Raelen",
			"		i. Turn in "..cq("A Bundle of Trouble"),
			completion={{questturnedin="A Bundle of Trouble"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=66114750,
		}, {
			"Go south to "..cl(80,78),
			"	a. Kill 8 Prowlers",
			"	b. Kill 5 Young Forest Bears",
			completion={{questgoal={"*","Prowler slain",8}},{questgoal={"*","Young Forest Bear slain",5}}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=77815780,
		}, {
			"Go east to "..cl(88,80),
			"	a. Kill Defias mobs",
			"	b. Get 6 Red Linen Bandanas",
			"	c. Get a Westfall Deed",
			"	d. Click the Westfall Deed",
			"		i. Accept "..cq("Furlbrow's Deed"),
			completion={{questgoal={"*","Red Linen Bandana",6}},{questaccepted="Furlbrow's Deed"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=80216870,
		}, {
			"Go northwest to "..cl(80,69),
			"	a. Talk to Sara Timberlain",
			"		i. Turn in "..cq("Red Linen Goods"),
			completion={{questturnedin="Red Linen Goods"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=68814830,
		}, {
			"Go southwest to "..cl(74,72),
			"	a. Talk to Guard Thomas",
			"		i. Turn in "..cq("Protect the Frontier"),
			"		ii. Turn in "..cq("Report to Thomas"),
			"		iii. Accept "..cq("Deliver Thomas' Report"),
			completion={{questturnedin="Protect the Frontier"},{questturnedin="Report to Thomas"},{questaccepted="Deliver Thomas' Report"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=72214620,
		}, {
			"Go northwest to "..cl(60,50),
			"	a. Explore Jasperlode Mine",
			completion={{location={mapzone="Elwynn Forest",x=60.5,y=50.0, dist=0.3}}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=49711010,
		}, {
			"Hearth to Goldshire",
			completion={{location={mapzone="Elwynn Forest",x=42.4,y=65.8, dist=2}}},
			mapzone="Elwynn Forest",
			level=11,
		}, {
			"Go to "..cl(42,67),
			"	a. Talk to Marshal Dughan",
			"		i. Turn in "..cq("Deliver Thomas' Report"),
			"		ii. Turn in "..cq("The Jasperlode Mine"),
			"		iii. Accept "..cq("Westbrook Garrison Needs Help!"),
			completion={{questturnedin="Deliver Thomas' Report"},{questturnedin="The Jasperlode Mine"},{questaccepted="Westbrook Garrison Needs Help!"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=65910800,
		}, {
			"Go southwest to "..cl(24,75),
			"	a. Talk to Deputy Rainer",
			"		i. Turn in "..cq("Westbrook Garrison Needs Help!"),
			"		ii. Accept "..cq("Riverpaw Gnoll Bounty"),
			"	b. Click the Wanted Poster",
			"		i. Accept "..cq("Wanted: 'Hogger'"),
			completion={{questturnedin="Westbrook Garrison Needs Help!"},{questaccepted="Riverpaw Gnoll Bounty"},{questaccepted="Wanted: 'Hogger'"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=74809910,
		}, {
			"Go southeast to "..cl(27,86),
			"	a. Kill Riverpaw gnolls",
			"	b. Get 8 Painted Gnoll Armbands",
			"	c. Kill Hogger",
			"	d. Get the Huge Gnoll Claw",
			completion={{questgoal={"*","Painted Gnoll Armband",8}},{questgoal={"*","Huge Gnoll Claw",1}}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=86311310,
		}, {
			"Go northeast to Goldshire",
			completion={{location={mapzone="Elwynn Forest",x=42.4,y=65.8, dist=2}}},
			mapzone="Elwynn Forest",
			level=11,
		}, {
			"Go to "..cl(42,67),
			"	a. Talk to Marshal Dughan",
			"		i. Turn in "..cq("Wanted: 'Hogger'"),
			completion={{questturnedin="Wanted: 'Hogger'"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=65910800,
		}, {
			"Go southwest to "..cl(24,75),
			"	a. Talk to Deputy Rainer",
			"		i. Turn in "..cq("Riverpaw Gnoll Bounty"),
			completion={{questturnedin="Riverpaw Gnoll Bounty"}},
			mapzone="Elwynn Forest",
			level=11,
			mapnote=74809910,
		}, {
			"Grind to level 13",
			completion={{level=13}},
			mapzone="Elwynn Forest",
			level=12,
		}, {
			"Go west to Westfall",
			completion={{location={mapzone="Westfall"}}},
			mapzone="Elwynn Forest",
			level=13,
		}
	  },
	},
	{ sectiontitle = "Main Guide (13-20)",
	  steps = {
		{
			"Go southwest to "..cl(60,19),
			"	a. Talk to Farmer Furlbrow",
			"		i. Turn in "..cq("Furlbrow's Deed"),
			"		ii. Accept "..cq("The Forgotten Heirloom"),
			"		iii. Accept "..cq("Report to Gryan Stoutmantle"),
			"	b. Talk to Verna Furlbrow",
			"		i. Accept "..cq("Westfall Stew part 1"),
			"		ii. Accept "..cq("Poor Old Blanchy"),
			completion={{questturnedin="Furlbrow's Deed"},{questaccepted="The Forgotten Heirloom"},{questaccepted="Report to Gryan Stoutmantle"},{questaccepted="Westfall Stew part 1"},{questaccepted="Poor Old Blanchy"}},
			mapzone="Westfall",
			level=13,
			mapnote=19407940,
		}, {
			"Go southwest to "..cl(56,31),
			"	a. Talk to Farmer Saldean",
			"		i. Accept "..cq("The Killing Fields"),
			completion={{questaccepted="The Killing Fields"}},
			mapzone="Westfall",
			level=13,
			mapnote=31208720,
		}, {
			"Also at "..cl(56,31),
			"	a. Talk to Salma Saldean",
			"		i. Turn in "..cq("Westfall Stew part 1"),
			"		ii. Accept "..cq("Westfall Stew part 2"),
			"		iii. Accept "..cq("Goretusk Liver Pie"),
			completion={{questturnedin="Westfall Stew part 1"},{questaccepted="Westfall Stew part 2"},{questaccepted="Goretusk Liver Pie"}},
			mapzone="Westfall",
			level=13,
			mapnote=30508690,
		}, {
			"Go south to "..cl(57,53),
			"	a. Talk to Thor",
			"		i. Get the Sentinel Hill Flight Path",
			completion={{flightpath="Sentinel Hill"}},
			mapzone="Westfall",
			level=13,
			mapnote=52610920,
		}, {
			"Go to "..cl(54,53),
			"	a. Talk to Scout Galiaan",
			"		i. Accept "..cq("Red Leather Bandanas"),
			completion={{questaccepted="Red Leather Bandanas"}},
			mapzone="Westfall",
			level=13,
			mapnote=53010700,
		}, {
			"Make Sentinel Hill your home",
			completion={{home="Sentinel Hill"}},
			mapzone="Westfall",
			level=13,
		}, {
			"Go to "..cl(56,48),
			"	a. Talk to Gryan Stoutmantle",
			"		i. Turn in "..cq("Report to Gryan Stoutmantle"),
			"		ii. Accept "..cq("The People's Militia part 1"),
			"	b. Talk to Captain Danuvin",
			"		i. Accept "..cq("Patrolling Westfall"),
			completion={{questturnedin="Report to Gryan Stoutmantle"},{questaccepted="The People's Militia part 1"},{questaccepted="Patrolling Westfall"}},
			mapzone="Westfall",
			level=13,
			mapnote=47510380,
		}, {
			"Go west to "..cl(49,47),
			"	a. Kill 15 Defias Trappers",
			"	b. Kill 15 Defias Smugglers",
			"	c. Get 15 Red Leather Bandanas",
			completion={{questgoal={"*","Defias Trapper slain",15}},{questgoal={"*","Defias Smuggler slain",15}},{questgoal={"*","Red Leather Bandana",15}}},
			mapzone="Westfall",
			level=13,
			mapnote=46809540,
		}, {
			"Grind to level 14",
			completion={{level=14}},
			mapzone="Westfall",
			level=13,
		}, {
			"Go east to Sentinel Hill",
			completion={{location={mapzone="Westfall",x=53.4,y=50.8, dist=3}}},
			mapzone="Westfall",
			level=14,
		}, {
			"Go to "..cl(56,48),
			"	a. Talk to Gryan Stoutmantle",
			"		i. Turn in "..cq("The People's Militia part 1"),
			"		ii. Accept "..cq("The People's Militia part 2"),
			completion={{questturnedin="The People's Militia part 1"},{questaccepted="The People's Militia part 2"}},
			mapzone="Westfall",
			level=14,
			mapnote=47510380,
		}, {
			"Go to "..cl(54,53),
			"	a. Talk to Scout Galiaan",
			"		i. Turn in "..cq("Red Leather Bandanas"),
			completion={{questturnedin="Red Leather Bandanas"}},
			mapzone="Westfall",
			level=14,
			mapnote=53010700,
		}, {
			"Go north to "..cl(54,43),
			"	a. Kill boars and vultures",
			"	b. Get 8 Goretusk Livers",
			"	c. Get 3 Goretusk Snouts",
			"	d. Get 3 Stringy Vulture Meat",
			completion={{questgoal={"*","Goretusk Liver",8}},{questgoal={"*","Goretusk Snout",3}},{questgoal={"*","Stringy Vulture Meat",3}}},
			mapzone="Westfall",
			level=14,
			mapnote=42509630,
		}, {
			"Go north to "..cl(57,19),
			"	a. Click the Sack of Oats (if it's not there, wait a few minutes, it will reappear)",
			"	b. Get a Handful of Oats",
			"	c. Get the other 7 Handfuls of Oats as you see them around Westfall",
			mapzone="Westfall",
			level=14,
			mapnote=19307640,
		}, {
			"Go north to "..cl(57,15),
			"	a. Kill gnolls",
			"	b. Get 8 Gnoll Paws",
			completion={{questgoal={"*","Gnoll Paw",8}}},
			mapzone="Westfall",
			level=14,
			mapnote=15107210,
		}, {
			"Grind to level 15",
			completion={{level=15}},
			mapzone="Westfall",
			level=14,
		}, {
			"Go southwest to "..cl(31,45),
			"	a. Kill 15 Defias Looters",
			"	b. Kill 15 Defias Pillagers",
			completion={{questgoal={"*","Defias Looter slain",15}},{questgoal={"*","Defias Pillager slain",15}}},
			mapzone="Westfall",
			level=15,
			mapnote=44507590,
		}, {
			"Go east to Sentinel Hill",
			completion={{location={mapzone="Westfall",x=53.4,y=50.8, dist=3}}},
			mapzone="Westfall",
			level=15,
		}, {
			"Go to "..cl(56,48),
			"	a. Talk to Gryan Stoutmantle",
			"		i. Turn in "..cq("The People's Militia part 2"),
			"		ii. Accept "..cq("The People's Militia part 3"),
			"		iii. Accept "..cq("The Defias Brotherhood part 1"),
			"	b. Talk to Captain Danuvin",
			"		i. Turn in "..cq("Patrolling Westfall"),
			completion={{questturnedin="The People's Militia part 2"},{questaccepted="The People's Militia part 3"},{questaccepted="The Defias Brotherhood part 1"},{questturnedin="Patrolling Westfall"}},
			mapzone="Westfall",
			level=15,
			mapnote=47510380,
		}, {
			"Go northwest to "..cl(51,22),
			"	a. Kill 20 Harvest Watchers",
			"	b. Get 3 Okra",
			"	c. Get 5 Flasks of Oil",
			completion={{questgoal={"*","Harvest Watcher slain",20}},{questgoal={"*","Okra",3}}},
			mapzone="Westfall",
			level=15,
			mapnote=21807290,
		}, {
			"Go northwest to "..cl(49,19),
			"	a. Click Furlbrow's Wardrobe",
			"	b. Get Furlbrow's Pocket Watch",
			completion={{questgoal={"*","Furlbrow's Pocket Watch",1}}},
			mapzone="Westfall",
			level=15,
			mapnote=19206860,
		}, {
			"Go northeast to "..cl(57,10),
			"	a. Kill murlocs",
			"	b. Get 3 Murloc Eyes",
			completion={{questgoal={"*","Murloc Eye",3}}},
			mapzone="Westfall",
			level=15,
			mapnote=9706630,
		}, {
			"Make sure you have 8 Handfuls of Oats",
			completion={{questgoal={"*","Handful of Oats",8}}},
			mapzone="Westfall",
			level=15,
		}, {
			"Go east to "..cl(60,19),
			"	a. Talk to Farmer Furlbrow",
			"		i. Turn in "..cq("The Forgotten Heirloom"),
			"	b. Talk to Verna Furlbrow",
			"		i. Turn in "..cq("Poor Old Blanchy"),
			completion={{questturnedin="The Forgotten Heirloom"},{questturnedin="Poor Old Blanchy"}},
			mapzone="Westfall",
			level=15,
			mapnote=19407940,
		}, {
			"Go southwest to Saldean's Farm",
			completion={{location={mapzone="Westfall",x=56.0,y=31.3, dist=2}}},
			mapzone="Westfall",
			level=15,
		}, {
			"Go to "..cl(56,31),
			"	a. Talk to Farmer Saldean",
			"		i. Turn in "..cq("The Killing Fields"),
			completion={{questturnedin="The Killing Fields"}},
			mapzone="Westfall",
			level=15,
			mapnote=31208720,
		}, {
			"Also at"..cl(56,31),	
			"	a. Talk to Salma Saldean",
			"		i. Turn in "..cq("Westfall Stew part 2"),
			"		ii. Turn in "..cq("Goretusk Liver Pie"),
			completion={{questturnedin="Westfall Stew part 2"},{questturnedin="Goretusk Liver Pie"}},
			mapzone="Westfall",
			level=15,
			mapnote=30508690,
		}, {
			"Go south to "..cl(53,72),
			"	a. Kill 15 Defias Highwaymen",
			"	b. Kill 5 Defias Pathstalkers",
			"	c. Kill 5 Defias Knuckledusters",
			completion={{questgoal={"*","Defias Pathstalker slain",5}},{questgoal={"*","Defias Knuckleduster slain",5}},{questgoal={"*","Defias Highwayman slain",15}},},
			mapzone="Westfall",
			level=15,
			mapnote=72312490,
		}, {
			"Go north to Sentinel Hill",
			completion={{location={mapzone="Westfall",x=53.4,y=50.8, dist=3}}},
			mapzone="Westfall",
			level=15,
		}, {
			"Go to "..cl(56,48),
			"	a. Talk to Gryan Stoutmantle",
			"		i. Turn in "..cq("The People's Militia part 3"),
			completion={{questturnedin="The People's Militia part 3"}},
			mapzone="Westfall",
			level=15,
			mapnote=47510380,

		}, {
			"Grind to level 17",
			completion={{level=17}},
			mapzone="Westfall",
			level=16,
		}, {
			"Fly to Ironforge",
			completion={{location={mapzone="City of Ironforge"}}},
			mapzone="Westfall",
			level=17,
		}, {
			"Go east to Loch Modan",
			completion={{location={mapzone="Loch Modan",x=19.7,y=62.8, dist=0.3}}},
			mapzone="Dun Morogh",
			level=17,
		}, {
			"Go northeast to "..cl(34,51),
			"	a. Talk to Thorgrum Borrelson",
			"		i. Get the Thelsamar Flight Path",
			completion={{flightpath="Thelsamar"}},
			mapzone="Loch Modan",
			level=17,
			mapnote=51008490,
		}, {
			"Make Thelsamar your home",
			completion={{home="Thelsamar"}},
			mapzone="Loch Modan",
			level=17,
		}, {
			"Go to "..cl(35,47),
			"	a. Talk to Mountaineer Kadrell",
			"		i. Accept "..cq("Mountaineer Stormpike's Task"),
			completion={{questaccepted="Mountaineer Stormpike's Task"}},
			mapzone="Loch Modan",
			level=17,
			mapnote=47108190,
		}, {
			"Go northwest to "..cl(25,18),
			"	a. Talk to Mountaineer Stormpike",
			"		i. Turn in "..cq("Mountaineer Stormpike's Task"),
			"		ii. Accept "..cq("Filthy Paws"),
			"		iii. Accept "..cq("Stormpike's Order"),
			completion={{questturnedin="Mountaineer Stormpike's Task"},{questaccepted="Filthy Paws"},{questaccepted="Stormpike's Order"}},
			mapzone="Loch Modan",
			level=17,
			mapnote=18404320,
		}, {
			"Go east to "..cl(35,19),
			"	a. Click Miners' League Crates inside the cave",
			"	b. Get 4 Miners' Gear",
			completion={{questgoal={"*","Miners' Gear",4}}},
			mapzone="Loch Modan",
			level=17,
			mapnote=18505390,
		}, {
			"Go west to "..cl(25,18),
			"	a. Talk to Mountaineer Stormpike",
			"		i. Turn in "..cq("Filthy Paws"),
			completion={{questturnedin="Filthy Paws"}},
			mapzone="Loch Modan",
			level=17,
			mapnote=18404320,
		}, {
			"Go southeast to Thelsamar",
			completion={{location={mapzone="Loch Modan",x=35.1,y=46.9, dist=3}}},
			mapzone="Loch Modan",
			level=17,
		}, {
			"Go to "..cl(37,47),
			"	a. Talk to Jern Hornhelm",
			"		i. Accept "..cq("Ironband's Excavation"),
			completion={{questaccepted="Ironband's Excavation"}},
			mapzone="Loch Modan",
			level=17,
			mapnote=47408460,
		}, {
			"Go southeast to "..cl(65,67),
			"	a. Talk to Magmar Fellhew",
			"		i. Turn in "..cq("Ironband's Excavation"),
			"		ii. Accept "..cq("Gathering Idols"),
			completion={{questturnedin="Ironband's Excavation"},{questaccepted="Gathering Idols"}},
			mapzone="Loch Modan",
			level=17,
			mapnote=66713160,
		}, {
			"Go northeast "..cl(66,66),
			"	a. Talk to Prospector Ironband",
			"		i. Accept "..cq("Excavation Progress Report"),
			completion={{questaccepted="Excavation Progress Report"}},
			mapzone="Loch Modan",
			level=17,
			mapnote=65613150,
		}, {
			"Go northeast to "..cl(68,63),
			"	a. Kill troggs",
			"	b. Get 8 Carved Stone Idols",
			completion={{questgoal={"*","Carved Stone Idol",8}}},
			mapzone="Loch Modan",
			level=17,
			mapnote=63213130,
		}, {
			"Go southwest to "..cl(65,67),
			"	a. Talk to Magmar Fellhew",
			"		i. Turn in "..cq("Gathering Idols"),
			completion={{questturnedin="Gathering Idols"}},
			mapzone="Loch Modan",
			level=17,
			mapnote=66713160,
		}, {
			"Go east to "..cl(83,65),
			"	a. Talk to Daryl the Youngling",
			"		i. Accept "..cq("A Hunter's Boast"),
			completion={{questaccepted="A Hunter's Boast"}},
			mapzone="Loch Modan",
			level=17,
			mapnote=65514900,
		}, {
			"Go north to "..cl(82,62),
			"	a. Talk to Marek Ironheart",
			"		i. Accept "..cq("Crocolisk Hunting"),
			completion={{questaccepted="Crocolisk Hunting"}},
			mapzone="Loch Modan",
			level=17,
			mapnote=61714350,
		}, {
			"Go northwest to "..cl(77,58),
			"	a. Kill 6 Mountain Buzzards",
			completion={{questgoal={"*","Mountain Buzzard slain",6}}},
			mapzone="Loch Modan",
			level=17,
			mapnote=58313570,
		}, {
			"Go southeast to "..cl(83,65),
			"	a. Talk to Daryl the Youngling",
			"		i. Turn in "..cq("A Hunter's Boast"),
			"		ii. Accept "..cq("A Hunter's Challenge"),
			completion={{questturnedin="A Hunter's Boast"},{questaccepted="A Hunter's Challenge"}},
			mapzone="Loch Modan",
			level=17,
			mapnote=65514900,
		}, {
			"Go northwest to "..cl(75,46),
			"	a. Kill 5 Elder Mountain Boars",
			completion={{questgoal={"*","Elder Mountain Boar slain",5}}},
			mapzone="Loch Modan",
			level=17,
			mapnote=45812120,
		}, {
			"Go southeast to "..cl(83,65),
			"	a. Talk to Daryl the Youngling",
			"		i. Turn in "..cq("A Hunter's Challenge"),
			completion={{questturnedin="A Hunter's Challenge"}},
			mapzone="Loch Modan",
			level=17,
			mapnote=65514900,
		}, {
			"Go northwest to "..cl(64,48),
			"	a. Talk to Bingles Blastenheimer",
			"		i. Accept "..cq("Bingles' Missing Supplies"),
			completion={{questaccepted="Bingles' Missing Supplies"}},
			mapzone="Loch Modan",
			level=17,
			mapnote=47911150,
		}, {
			"Go southwest to "..cl(55,54),
			"	a. Kill crocolisks",
			"	b. Get 5 Crocolisk Meat",
			"	c. Get 6 Crocolisk Skins",
			completion={{questgoal={"*","Crocolisk Meat",5}},{questgoal={"*","Crocolisk Skin",6}}},
			mapzone="Loch Modan",
			level=17,
			mapnote=54010920,
		}, {
			"Go northwest to "..cl(49,30),
			"	a. Click Bingles's Toolbucket",
			"	b. Get Bingles' Wrench",
			completion={{questgoal={"*","Bingles' Wrench",1}}},
			mapzone="Loch Modan",
			level=17,
			mapnote=30107880,
		}, {
			"Go northeast to "..cl(54,27),
			"	a. Click Bingles' Blastencapper",
			"	b. Get Bingles' Blastencapper",
			completion={{questgoal={"*","Bingles' Blastencapper",1}}},
			mapzone="Loch Modan",
			level=17,
			mapnote=26608080,
		}, {
			"Go northwest to "..cl(52,24),
			"	a. Click Bingles's Toolbucket",
			"	b. Get Bingles' Hammer",
			completion={{questgoal={"*","Bingles' Hammer",1}}},
			mapzone="Loch Modan",
			level=17,
			mapnote=24107590,
		}, {
			"Go northwest to "..cl(48,21),
			"	a. Click Bingles' Toolbucket",
			"	b. Get Bingles' Screwdriver",
			completion={{questgoal={"*","Bingles' Screwdriver",1}}},
			mapzone="Loch Modan",
			level=17,
			mapnote=21106920,
		}, {
			"Go northwest to "..cl(46,14),
			"	a. Talk to Chief Engineer Hinderweir VII",
			"		i. Accept "..cq("A Dark Threat Looms part 1"),
			completion={{questaccepted="A Dark Threat Looms part 1"}},
			mapzone="Loch Modan",
			level=17,
			mapnote=13605960,
		}, {
			"Go east to "..cl(56,13),
			"	a. Click the Suspicious Barrel",
			"		i. Turn in "..cq("A Dark Threat Looms part 1"),
			"		ii. Accept "..cq("A Dark Threat Looms part 2"),
			completion={{questturnedin="A Dark Threat Looms part 1"},{questaccepted="A Dark Threat Looms part 2"}},
			mapzone="Loch Modan",
			level=17,
			mapnote=13306930,
		}, {
			"Go west to "..cl(46,14),
			"	a. Talk to Chief Engineer Hinderweir VII",
			"		i. Turn in "..cq("A Dark Threat Looms part 2"),
			completion={{questturnedin="A Dark Threat Looms part 2"}},
			mapzone="Loch Modan",
			level=17,
			mapnote=13605960,
		}, {
			"Go southeast to "..cl(64,48),
			"	a. Talk to Bingles Blastenheimer",
			"		i. Turn in "..cq("Bingles' Missing Supplies"),
			completion={{questturnedin="Bingles' Missing Supplies"}},
			mapzone="Loch Modan",
			level=17,
			mapnote=47911150,
		}, {
			"Go east to "..cl(82,62),
			"	a. Talk to Marek Ironheart",
			"		i. Turn in "..cq("Crocolisk Hunting"),
			completion={{questturnedin="Crocolisk Hunting"}},
			mapzone="Loch Modan",
			level=17,
			mapnote=61714350,
		}, {
			"Go to "..cl(82,64),
			"	a. Talk tot Vyrin Swiftwind",
			"		i. Accept "..cq("Vyrin's Revenge part 1"),
			completion={{questaccepted="Vyrin's Revenge part 1"}},
			mapzone="Loch Modan",
			level=17,
			mapnote=64214590,
		}, {
			"Go west to "..cl(43,64),
			"	a. Kill Ol' Sooty",
			"	b. Get Ol' Sooty's Head",
			completion={{questgoal={"*","Ol' Sooty's Head",1}}},
			mapzone="Loch Modan",
			level=17,
			mapnote=64010700,
		}, {
			"Go east to "..cl(84,65),
			"	a. Talk to Daryl the Youngling",
			"		i. Turn in "..cq("Vyrin's Revenge part 1"),
			"		ii. Accept "..cq("Vyrin's Revenge part 2"),
			completion={{questturnedin="Vyrin's Revenge part 1"},{questaccepted="Vyrin's Revenge part 2"}},
			mapzone="Loch Modan",
			level=17,
			mapnote=65514900,
		}, {
			"Go to "..cl(82,64),
			"	a. Talk to Vyrin Swiftwind",
			"		i. Turn in "..cq("Vyrin's Revenge part 2"),
			completion={{questturnedin="Vyrin's Revenge part 2"}},
			mapzone="Loch Modan",
			level=17,
			mapnote=64214590,
		}, {
			"Hearth to Thelsamar",
			completion={{location={mapzone="Loch Modan",x=35.1,y=46.9, dist=3}}},
			mapzone="Loch Modan",
			level=17,
		}, {
			"Go southwest to "..cl(37,47),
			"	a. Talk to Jern Hornhelm",
			"		i. Turn in "..cq("Excavation Progress Report"),
			"		ii. Accept "..cq("Report to Ironforge"),
			completion={{questturnedin="Excavation Progress Report"},{questaccepted="Report to Ironforge"}},
			mapzone="Loch Modan",
			level=17,
			mapnote=47408460,
		}, {
			"Grind to level 18",
			completion={{level=18}},
			mapzone="Loch Modan",
			level=17,
		}, {
			"Fly to Ironforge",
			completion={{location={mapzone="City of Ironforge"}}},
			mapzone="Loch Modan",
			level=18,
		}, {
			"Go to "..cl(75,12),
			"	a. Talk to Prospector Stormpike",
			"		i. Turn in "..cq("Report to Ironforge"),
			completion={{questturnedin="Report to Ironforge"}},
			mapzone="Ironforge",
			level=18,
			mapnote=11708640,
		}, {
			"Fly to Stormwind City",
			completion={{location={mapzone="Stormwind City"}}},
			mapzone="Ironforge",
			level=18,
		}, {
			"Go to "..cl(58,17),
			"	a. Talk to Furen Longbeard",
			"		i. Turn in "..cq("Stormpike's Order"),
			completion={{questturnedin="Stormpike's Order"}},
			mapzone="Stormwind City",
			level=18,
			mapnote=16607470,
		}, {
			"Go east to Redridge Mountains",
			completion={{location={mapzone="Redridge Mountains"}}},
			mapzone="Elwynn Forest",
			level=18,
		}, {
			"Go east to "..cl(15,72),
			"	a. Talk to Guard Parker",
			"		i. Accept "..cq("Encroaching Gnolls"),
			completion={{questaccepted="Encroaching Gnolls"}},
			mapzone="Redridge Mountains",
			level=18,
			mapnote=71508680,
		}, {
			"Go northeast to "..cl(31,60),
			"	a. Talk to Deputy Feldon",
			"		i. Turn in "..cq("Encroaching Gnolls"),
			"		ii. Accept "..cq("Assessing the Threat"),
			completion={{questturnedin="Encroaching Gnolls"},{questaccepted="Assessing the Threat"}},
			mapzone="Redridge Mountains",
			level=18,
			mapnote=60009070,
		}, {
			"Go to "..cl(31,59),
			"	a. Talk to Ariena Stormfeather",
			"		i. Get the Lakeshire Flight Path",
			completion={{flightpath="Lakeshire"}},
			mapzone="Redridge Mountains",
			level=18,
			mapnote=59409000,
		}, {
			"Go to "..cl(34,49),
			"	a. Talk to Marshal Marris",
			"		i. Accept "..cq("Blackrock Menace"),
			completion={{questaccepted="Blackrock Menace"}},
			mapzone="Redridge Mountains",
			level=18,
			mapnote=49008250,
		}, {
			"Go to "..cl(32,49),
			"	a. Talk to Foreman Oslow",
			"		i. Accept "..cq("The Lost Tools"),
			completion={{questaccepted="The Lost Tools"}},
			mapzone="Redridge Mountains",
			level=18,
			mapnote=48608070,
		}, {
			"Go to "..cl(31,47),
			"	a. Talk to Verner Osgood",
			"		i. Accept "..cq("The Price of Shoes"),
			completion={{questaccepted="The Price of Shoes"}},
			mapzone="Redridge Mountains",
			level=18,
			mapnote=47307830,
		}, {
			"Go to "..cl(29,54),
			"	a. Talk to Shawn",
			"		i. Accept "..cq("Hilary's Necklace"),
			completion={{questaccepted="Hilary's Necklace"}},
			mapzone="Redridge Mountains",
			level=18,
			mapnote=53608290,
		}, {
			"Go south to "..cl(29,55),
			"	a. Click the Glinting Mound",
			"	b. Get Hilary's Necklace",
			completion={{questgoal={"*","Hilary's Necklace",1}}},
			mapzone="Redridge Mountains",
			level=18,
			mapnote=55108420,
		}, {
			"Go east to "..cl(42,55),
			"	a. Click the Sunken Chest",
			"	b. Get Oslow's Toolbox",
			completion={{questgoal={"*","Oslow's Toolbox",1}}},
			mapzone="Redridge Mountains",
			level=18,
			mapnote=54609610,
		}, {
			"Go northwest to "..cl(32,49),
			"	a. Talk to Foreman Oslow",
			"		i. Turn in "..cq("The Lost Tools"),
			"		ii. Accept "..cq("The Everstill Bridge"),
			completion={{questturnedin="The Lost Tools"},{questaccepted="The Everstill Bridge"}},
			mapzone="Redridge Mountains",
			level=18,
			mapnote=48608070,
		}, {
			"Go to "..cl(29,54),
			"	a. Talk to Hilary",
			"		i. Turn in "..cq("Hilary's Necklace"),
			completion={{questturnedin="Hilary's Necklace"}},
			mapzone="Redridge Mountains",
			level=18,
			mapnote=53608290,
		}, {
			"Go to "..cl(30,44),
			"	a. Talk to Bailiff Conacher",
			"		i. Accept "..cq("Solomon's Law"),
			completion={{questaccepted="Solomon's Law"}},
			mapzone="Redridge Mountains",
			level=18,
			mapnote=44407440,
		}, {
			"Go to "..cl(28,47),
			"	a. Talk to Dockmaster Baren",
			"		i. Accept "..cq("Selling Fish"),
			completion={{questaccepted="Selling Fish"}},
			mapzone="Redridge Mountains",
			level=18,
			mapnote=47407510,
		}, {
			"Go to "..cl(27,44),
			"	a. Talk to Darcy",
			"		i. Accept "..cq("A Free Lunch"),
			completion={{questaccepted="A Free Lunch"}},
			mapzone="Redridge Mountains",
			level=18,
			mapnote=44307090,
		}, {
			"Make Lakeshire your home",
			completion={{home="Lakeshire"}},
			mapzone="Redridge Mountains",
			level=18,
		}, {
			"Go to "..cl(27,45),
			"	a. Talk to Wiley the Black",
			"		i. Turn in "..cq("The Defias Brotherhood part 1"),
			"		ii. Accept "..cq("The Defias Brotherhood part 2"),
			completion={{questturnedin="The Defias Brotherhood part 1"},{questaccepted="The Defias Brotherhood part 2"}},
			mapzone="Redridge Mountains",
			level=18,
			mapnote=45307180,
		}, {
			"Go to "..cl(23,44),
			"	a. Talk to Chef Breanna",
			"		i. Accept "..cq("Redridge Goulash"),
			completion={{questaccepted="Redridge Goulash"}},
			mapzone="Redridge Mountains",
			level=18,
			mapnote=43806650,
		}, {
			"Go to "..cl(22,46),
			"	a. Talk to Martie Jainrose",
			"		i. Accept "..cq("An Unwelcome Guest"),
			completion={{questaccepted="An Unwelcome Guest"}},
			mapzone="Redridge Mountains",
			level=18,
			mapnote=46306820,
		}, {
			"Go southwest to "..cl(15,72),
			"	a. Talk to Guard Parker",
			"		i. Turn in "..cq("A Free Lunch"),
			"		ii. Accept "..cq("Visit the Herbalist"),
			completion={{questturnedin="A Free Lunch"},{questaccepted="Visit the Herbalist"}},
			mapzone="Redridge Mountains",
			level=18,
			mapnote=71508680,
		}, {
			"Fly to Sentinel Hill",
			completion={{location={mapzone="Westfall",x=53.4,y=50.8, dist=3}}},
			mapzone="Redridge Mountains",
			level=18,
		}, {
			"Go to "..cl(56,48),
			"	a. Talk to Gryan Stoutmantle",
			"		i. Turn in "..cq("The Defias Brotherhood part 2"),
			"		ii. Accept "..cq("The Defias Brotherhood part 3"),
			completion={{questturnedin="The Defias Brotherhood part 2"},{questaccepted="The Defias Brotherhood part 3"}},
			mapzone="Westfall",
			level=18,
			mapnote=47510380,
		}, {
			"Fly to Stormwind City",
			completion={{location={mapzone="Stormwind City"}}},
			mapzone="Westfall",
			level=18,
		}, {
			"Go to "..cl(76,60),
			"	a. Talk to Master Mathias Shaw",
			"		i. Turn in "..cq("The Defias Brotherhood part 3"),
			"		ii. Accept "..cq("The Defias Brotherhood part 4"),
			completion={{questturnedin="The Defias Brotherhood part 3"},{questaccepted="The Defias Brotherhood part 4"}},
			mapzone="Stormwind City",
			level=18,
			mapnote=59813580,
		}, {
			"Fly to Sentinel Hill",
			completion={{location={mapzone="Westfall",x=53.4,y=50.8, dist=3}}},
			mapzone="Stormwind City",
			level=18,
		}, {
			"Go to "..cl(56,48),
			"	a. Talk to Gryan Stoutmantle",
			"		i. Turn in "..cq("The Defias Brotherhood part 4"),
			"		ii. Accept "..cq("The Defias Brotherhood part 5"),
			completion={{questturnedin="The Defias Brotherhood part 4"},{questaccepted="The Defias Brotherhood part 5"}},
			mapzone="Westfall",
			level=18,
			mapnote=47510380,
		}, {
			"Fly to Stormwind City",
			completion={{location={mapzone="Stormwind City"}}},
			mapzone="Westfall",
			level=18,
		}, {
			"Go southeast to Goldshire",
			completion={{location={mapzone="Elwynn Forest",x=42.4,y=65.8, dist=2}}},
			mapzone="Elwynn Forest",
			level=18,
		}, {
			"Go to "..cl(42,66),
			"	a. Talk to Smith Argus",
			"		i. Turn in "..cq("The Price of Shoes"),
			"		ii. Accept "..cq("Return to Verner"),
			completion={{questturnedin="The Price of Shoes"},{questaccepted="Return to Verner"}},
			mapzone="Elwynn Forest",
			level=18,
			mapnote=65510720,
		}, {
			"Hearth to Lakeshire",
			completion={{location={mapzone="Redridge Mountains",x=26.9,y=44.8, dist=5}}},
			mapzone="Elwynn Forest",
			level=18,
		}, {
			"Go to "..cl(22,46),
			"	a. Talk to Martie Jainrose",
			"		i. Turn in "..cq("Visit the Herbalist"),
			"		ii. Accept "..cq("Delivering Daffodils"),
			completion={{questturnedin="Visit the Herbalist"},{questaccepted="Delivering Daffodils"}},
			mapzone="Redridge Mountains",
			level=18,
			mapnote=46306820,
		}, {
			"Go to "..cl(27,44),
			"	a. Talk to Darcy",
			"		i. Turn in "..cq("Delivering Daffodils"),
			completion={{questturnedin="Delivering Daffodils"}},
			mapzone="Redridge Mountains",
			level=18,
			mapnote=44307090,
		}, {
			"Go to "..cl(31,47),
			"	a. Talk to Verner Osgood",
			"		i. Turn in "..cq("Return to Verner"),
			"		ii. Accept "..cq("Underbelly Scales"),
			"		iii. Accept "..cq("A Baying of Gnolls"),
			completion={{questturnedin="Return to Verner"},{questaccepted="Underbelly Scales"},{questaccepted="A Baying of Gnolls"}},
			mapzone="Redridge Mountains",
			level=18,
			mapnote=47307830,
		}, {
			"Go southeast to "..cl(34,67),
			"	a. Kill Black Dragon Whelps",
			"	b. Get 6 Underbelly Whelp Scales",
			"	c. Kill Great Goretusks",
			"	d. Get 5 Great Goretusk Snouts",
			completion={{questgoal={"*","Underbelly Whelp Scale",6}},{questgoal={"*","Great Goretusk Snout",5}}},
			mapzone="Redridge Mountains",
			level=18,
			mapnote=67410160,
		}, {
			"Go to southwest to "..cl(19,73),
			"	a. Kill Tarantulas",
			"	b. Get 5 Crisp Spider Meat",
			completion={{questgoal={"*","Crisp Spider Meat",5}}},
			mapzone="Redridge Mountains",
			level=18,
			mapnote=73209250,
		}, {
			"Go southeast to "..cl(27,80),
			"	a. Kill 10 Redridge Mongrels",
			"	b. Kill 6 Redridge Poachers",
			completion={{questgoal={"*","Redridge Mongrel slain",10}},{questgoal={"*","Redridge Poacher slain",6}}},
			mapzone="Redridge Mountains",
			level=18,
			mapnote=80210700,
		}, {
			"Go northwest to Lakeshire",
			completion={{location={mapzone="Redridge Mountains",x=26.9,y=44.8, dist=5}}},
			mapzone="Redridge Mountains",
			level=18,
		}, {
			"Go to "..cl(31,60),
			"	a. Talk to Deputy Feldon",
			"		i. Turn in "..cq("Assessing the Threat"),
			completion={{questturnedin="Assessing the Threat"}},
			mapzone="Redridge Mountains",
			level=18,
			mapnote=60009070,
		}, {
			"Go to "..cl(31,47),
			"	a. Talk to Verner Osgood",
			"		i. Turn in "..cq("Underbelly Scales"),
			completion={{questturnedin="Underbelly Scales"}},
			mapzone="Redridge Mountains",
			level=18,
			mapnote=47307830,
		}, {
			"Go southeast to "..cl(48,73),
			"	a. Kill murlocs",
			"	b. Get 10 Spotted Sunfish",
			"	c. Get 8 Murloc Fins for a later quest",
			completion={{questgoal={"*","Spotted Sunfish",10}}},
			mapzone="Redridge Mountains",
			level=18,
			mapnote=73312150,
		}, {
			"Go east to "..cl(56,75),
			"	a. Kill Dire Condors",
			"	b. Get 5 Tough Condor Meat",
			completion={{questgoal={"*","Tough Condor Meat",5}}},
			mapzone="Redridge Mountains",
			level=18,
			mapnote=74713020,
		}, {
			"Go southeast to "..cl(71,79),
			"	a. Kill orcs",
			"	b. Get 10 Battleworn Axes",
			completion={{questgoal={"*","Battleworn Axe",10}}},
			mapzone="Redridge Mountains",
			level=18,
			mapnote=78814940,
		}, {
			"Grind to level 20",
			completion={{level=20}},
			mapzone="Redridge Mountains",
			level=19,
		}
	  },
	},
	{ sectiontitle = "Levels (20-25)",
	  steps = {
		{
			"Hearth to Lakeshire",
			completion={{location={mapzone="Redridge Mountains",x=26.9,y=44.8, dist=5}}},
			mapzone="Redridge Mountains",
			level=20,
		}, {
			"Go to "..cl(23,44),
			"	a. Talk to Chef Breanna",
			"		i. Turn in "..cq("Redridge Goulash"),
			completion={{questturnedin="Redridge Goulash"}},
			mapzone="Redridge Mountains",
			level=20,
			mapnote=43806650,
		}, {
			"Go to "..cl(28,47),
			"	a. Talk to Dockmaster Baren",
			"		i. Turn in "..cq("Selling Fish"),
			"		ii. Accept "..cq("Murloc Poachers"),
			"		iii. Turn in "..cq("Murloc Poachers"),
			completion={{questturnedin="Selling Fish"},{questaccepted="Murloc Poachers"},{questturnedin="Murloc Poachers"}},
			mapzone="Redridge Mountains",
			level=20,
			mapnote=47407510,
		}, {
			"Go to "..cl(34,49),
			"	a. Talk to Marshal Marris",
			"		i. Turn in "..cq("Blackrock Menace"),
			completion={{questturnedin="Blackrock Menace"}},
			mapzone="Redridge Mountains",
			level=20,
			mapnote=49008250,
		}, {
			"Go north to "..cl(29,37),
			"	a. Kill gnolls",
			"	b. Get 5 Iron Pikes",
			"	c. Get 5 Iron Rivets",
			"	d. Kill 10 Redridge Brutes",
			"	e. Kill 8 Redridge Mystics",
			completion={{questgoal={"*","Iron Pike",5}},{questgoal={"*","Iron Rivet",5}},{questgoal={"*","Redridge Brute slain",10}},{questgoal={"*","Redridge Mystic slain",8}}},
			mapzone="Redridge Mountains",
			level=20,
			mapnote=37406640,
		}, {
			"Go southeast to Lakeshire",
			completion={{location={mapzone="Redridge Mountains",x=26.9,y=44.8, dist=5}}},
			mapzone="Redridge Mountains",
			level=20,
		}, {
			"Go to "..cl(32,49),
			"	a. Talk to Foreman Oslow",
			"		i. Turn in "..cq("The Everstill Bridge"),
			completion={{questturnedin="The Everstill Bridge"}},
			mapzone="Redridge Mountains",
			level=20,
			mapnote=48608070,
		}, {
			"Go to "..cl(31,47),
			"	a. Talk to Verner Osgood",
			"		i. Turn in "..cq("A Baying of Gnolls"),
			completion={{questturnedin="A Baying of Gnolls"}},
			mapzone="Redridge Mountains",
			level=20,
			mapnote=47307830,
		}, {
			"Fly to Sentinel Hill",
			completion={{location={mapzone="Westfall",x=53.4,y=50.8, dist=3}}},
			mapzone="Redridge Mountains",
			level=20,
		}, {
			"Make Sentinel Hill your home",
			completion={{home="Sentinel Hill"}},
			mapzone="Westfall",
			level=20,
		}, {
			"Go southwest to "..cl(44,69),
			"	a. Kill the Defias Messenger",
			"	b. Get A Mysterious Message",
			completion={{questgoal={"*","A Mysterious Message",1}}},
			mapzone="Westfall",
			level=20,
			mapnote=69311350,
		}, {
			"Go southwest to "..cl(30,86),
			"	a. Talk to Captain Grayson",
			"		i. Accept "..cq("Keeper of the Flame"),
			"		ii. Turn in "..cq("Keeper of the Flame"),
			"		iii. Accept "..cq("The Coastal Menace"),
			completion={{questaccepted="Keeper of the Flame"},{questturnedin="Keeper of the Flame"},{questaccepted="The Coastal Menace"}},
			mapzone="Westfall",
			level=20,
			mapnote=86011600,
		}, {
			"Go north to "..cl(30,80),
			"	a. Kill Old Murk-Eye",
			"	b. Get the Scale of Murk-Eye",
			completion={{questgoal={"*","Scale of Old Murk-Eye",1}}},
			mapzone="Westfall",
			level=20,
			mapnote=79910960,
		}, {
			"Go south to "..cl(30,86),
			"	a. Talk to Captain Grayson",
			"		i. Turn in "..cq("The Coastal Menace"),
			completion={{questturnedin="The Coastal Menace"}},
			mapzone="Westfall",
			level=20,
			mapnote=86011600,
		}, {
			"Grind to level 21",
			completion={{level=21}},
			mapzone="Westfall",
			level=20,
		}, {
			"Hearth to Sentinel Hill",
			completion={{location={mapzone="Westfall",x=53.4,y=50.8, dist=3}}},
			mapzone="Westfall",
			level=21,
		}, {
			"Go to "..cl(56,48),
			"	a. Talk to Gryan Stoutmantle",
			"		i. Turn in "..cq("The Defias Brotherhood part 5"),
			"	b. Talk to the Defias Traitor",
			"		i. Accept "..cq("The Defias Brotherhood part 6"),
			"		ii. Escort the Defias Traitor to Moonbrook",
			completion={{questturnedin="The Defias Brotherhood part 5"},{questaccepted="The Defias Brotherhood part 6"}},
			mapzone="Westfall",
			level=21,
			mapnote=47510380,
		}, {
			"Go northeast to Sentinel Hill",
			completion={{location={mapzone="Westfall",x=53.4,y=50.8, dist=3}}},
			mapzone="Westfall",
			level=21,
		}, {
			"Go to "..cl(56,48),
			"	a. Talk to Gryan Stoutmantle",
			"		i. Turn in "..cq("The Defias Brotherhood part 6"),
			completion={{questturnedin="The Defias Brotherhood part 6"}},
			mapzone="Westfall",
			level=21,
			mapnote=47510380,
		}, {
			"Fly to Thelsamar",
			completion={{location={mapzone="Loch Modan",x=35.1,y=46.9, dist=3}}},
			mapzone="Loch Modan",
			level=21,
		}, {
			"Go north to the Wetlands",
			completion={{location={mapzone="Wetlands"}}},
			mapzone="Loch Modan",
			level=21,
		}, {
			"Go northwest to Menethil Harbor",
			completion={{location={mapzone="Wetlands",x=10.1,y=56.7, dist=9}}},
			mapzone="Wetlands",
			level=21,
		}, {
			"Go to "..cl(10,60),
			"	a. Talk to Shellei Brondir",
			"		i. Get the Menethil Harbor Flight Path",
			completion={{flightpath="Menethil Harbor"}},
			mapzone="Wetlands",
			level=21,
			mapnote=59706920,
		}, {
			"Ride the boat to Auberdine",
			completion={{location={mapzone="Darkshore",x=32.8,y=42.0, dist=9}}},
			mapzone="Wetlands",
			level=21,
		}, {
			"Go to "..cl(34,42),
			"	a. Talk to Fiora Longears",
			"		i. Accept "..cq("Journey to Astranaar"),
			completion={{questaccepted="Journey to Astranaar"}},
			mapzone="Darkshore",
			level=21,
			mapnote=42307570,
		}, {
			"Go to "..cl(36,44),
			"	a. Talk to Cerellean Whiteclaw",
			"		i. Accept "..cq("For Love Eternal"),
			completion={{questaccepted="For Love Eternal"}},
			mapzone="Darkshore",
			level=21,
			mapnote=43707940,
		}, {
			"Go to "..cl(36,45),
			"	a. Talk to Gubber Blump",
			"		i. Accept "..cq("Fruit of the Sea"),
			completion={{questaccepted="Fruit of the Sea"}},
			mapzone="Darkshore",
			level=21,
			mapnote=44908100,
		}, {
			"Go to "..cl(36,46),
			"	a. Talk to Caylais Moonfeather",
			"		i. Get the Auberdine Flight Path",
			completion={{flightpath="Auberdine"}},
			mapzone="Darkshore",
			level=21,
			mapnote=45608190,
		}, {
			"Make Auberdine your home",
			completion={{home="Auberdine"}},
			mapzone="Darkshore",
			level=21,
		}, {
			"Go to "..cl(37,44),
			"	a. Click the Wanted Poster",
			"		i. Accept "..cq("WANTED: Murkdeep!"),
			completion={{questaccepted="WANTED: Murkdeep!"}},
			mapzone="Darkshore",
			level=21,
			mapnote=44208140,
		}, {
			"Also at"..cl(37,44),	
			"	a. Talk to Barithras Moonshade",
			"		i. Accept "..cq("Cave Mushrooms"),
			completion={{questaccepted="Cave Mushrooms"}},
			mapzone="Darkshore",
			level=21,
			mapnote=43608090,
		}, {
			"Go to "..cl(39,44),
			"	a. Talk to Sentinel Elissa Starbreeze",
			"		i. Accept "..cq("The Tower of Althalaxx part 1"),
			completion={{questaccepted="The Tower of Althalaxx part 1"}},
			mapzone="Darkshore",
			level=21,
			mapnote=43608260,
		}, {
			"Go northeast to "..cl(55,34),
			"	a. Click the mushrooms in the cave",
			"	b. Get 5 Scaber Stalks",
			"	c. Get 1 Death Cap",
			completion={{questgoal={"*","Scaber Stalk",5}},{questgoal={"*","Death Cap",1}}},
			mapzone="Darkshore",
			level=21,
			mapnote=33608870,
		}, {
			"Go north to "..cl(55,25),
			"	a. Talk to Balthule Shadowstrike",
			"		i. Turn in "..cq("The Tower of Althalaxx part 1"),
			"		ii. Accept "..cq("The Tower of Althalaxx part 2"),
			completion={{questturnedin="The Tower of Althalaxx part 1"},{questaccepted="The Tower of Althalaxx part 2"}},
			mapzone="Darkshore",
			level=21,
			mapnote=24907990,
		}, {
			"Go south to "..cl(55,26),
			"	a. Kill Dark Strand Fanatics",
			"	b. Get 4 Worn Parchments",
			completion={{questgoal={"*","Worn Parchment",4}}},
			mapzone="Darkshore",
			level=21,
			mapnote=26408160,
		}, {
			"Go north to "..cl(55,25),
			"	a. Talk to Balthule Shadowstrike",
			"		i. Turn in "..cq("The Tower of Althalaxx part 2"),
			"		ii. Accept "..cq("The Tower of Althalaxx part 3"),
			completion={{questturnedin="The Tower of Althalaxx part 2"},{questaccepted="The Tower of Althalaxx part 3"}},
			mapzone="Darkshore",
			level=21,
			mapnote=24907990,
		}, {
			"Go southwest to Auberdine",
			completion={{location={mapzone="Darkshore",x=38.1,y=43.1, dist=9}}},
			mapzone="Darkshore",
			level=21,
		}, {
			"Go to "..cl(37,44),
			"	a. Talk to Barithras Moonshade",
			"		i. Turn in "..cq("Cave Mushrooms"),
			"		ii. Accept "..cq("Onu"),
			completion={{questturnedin="Cave Mushrooms"},{questaccepted="Onu"}},
			mapzone="Darkshore",
			level=21,
			mapnote=43608090,
		}, {
			"Go southeast to "..cl(43,60),
			"	a. Kill Anaya Dawnrunner",
			"	b. Get Anaya's Pendant",
			completion={{questgoal={"*","Anaya's Pendant",1}}},
			mapzone="Darkshore",
			level=21,
			mapnote=59710300,
		}, {
			"Go southwest to "..cl(36,77),
			"	a. Kill Murkdeep",
			completion={{questgoal={"*","Murkdeep slain",1}}},
			mapzone="Darkshore",
			level=21,
			mapnote=76711300,
		}, {
			"Go south to "..cl(35,80),
			"	a. Kill Reef Crawlers",
			"	b. Get 6 Fine Crab Chunks",
			completion={{questgoal={"*","Fine Crab Chunks",6}}},
			mapzone="Darkshore",
			level=21,
			mapnote=80011490,
		}, {
			"Go east to "..cl(44,76),
			"	a. Talk to Onu",
			"		i. Turn in "..cq("Onu"),
			"		ii. Accept "..cq("The Master's Glaive"),
			completion={{questturnedin="Onu"},{questaccepted="The Master's Glaive"}},
			mapzone="Darkshore",
			level=21,
			mapnote=76311980,
		}, {
			"Go southwest to "..cl(39,86),
			"	a. Clear the mobs around the table",
			"	b. Jump on the table with the remains on it",
			"	c. Click your Phial of Scrying in your bags",
			"	d. Create the Scrying Bowl",
			"	e. Click the Scrying Bowl",
			"		i. Turn in "..cq("The Master's Glaive"),
			"		ii. Accept "..cq("The Twilight Camp"),
			"	f. Click the Twilight Tome",
			"		i. Turn in "..cq("The Twilight Camp"),
			"		ii. Accept "..cq("Return to Onu"),
			completion={{questturnedin="The Master's Glaive"},{questaccepted="The Twilight Camp"},{questturnedin="The Twilight Camp"},{questaccepted="Return to Onu"}},
			mapzone="Darkshore",
			level=21,
			mapnote=86212470,
		}, {
			"Go to "..cl(39,87),
			"	a. Talk to Therylune",
			"		i. Accept "..cq("Therylune's Escape"),
			"	b. Escort Therylune to safety",
			completion={{questaccepted="Therylune's Escape"}},
			mapzone="Darkshore",
			level=21,
			mapnote=87412610,
		}, {
			"Go northeast to "..cl(44,76),
			"	a. Talk to Onu",
			"		i. Turn in "..cq("Return to Onu"),
			"		ii. Accept "..cq("Mathystra Relics"),
			completion={{questturnedin="Return to Onu"},{questaccepted="Mathystra Relics"}},
			mapzone="Darkshore",
			level=21,
			mapnote=76311980,
		}, {
			"Also at "..cl(44,76),	
			"	a. Talk to Kerlonian Evershade",
			"		i. Accept "..cq("The Sleeper Has Awakened"),
			"	b. Click Kerlonian's Chest",
			"	c. Get the Horn of Awakening",
			completion={{questaccepted="The Sleeper Has Awakened"}},
			mapzone="Darkshore",
			level=21,
			mapnote=76412080,
		}, {
			"Escort Kerlonian Evershade south to Ashenvale, then south to Maestra's Post",
			"	a. Do NOT follow the road. Walk in the forest as much as you can. This will allow you to avoid the ambushes along the way.",
			"	b. Click your Horn of Awakening when he falls asleep to wake him up",
			completion={{location={mapzone="Ashenvale",x=26.6,y=37.4, dist=6}}},
			mapzone="Darkshore",
			level=21,
		}, {
			"Go to "..cl(27,36),
			"	a. Talk to Liladris Moonriver",
			"		i. Turn in "..cq("The Sleeper Has Awakened"),
			completion={{questturnedin="The Sleeper Has Awakened"}},
			mapzone="Ashenvale",
			level=21,
			mapnote=35606290,
		}, {
			"Go to "..cl(26,39),
			"	a. Talk to Delgren the Purifier",
			"		i. Turn in "..cq("The Tower of Althalaxx part 3"),
			"		ii. Accept "..cq("The Tower of Althalaxx part 4"),
			completion={{questturnedin="The Tower of Althalaxx part 3"},{questaccepted="The Tower of Althalaxx part 4"}},
			mapzone="Ashenvale",
			level=21,
			mapnote=38606480,
		}, {
			"Go to "..cl(26,39),
			"	a. Talk to Orendil Broadleaf",
			"		i. Accept "..cq("Bathran's Hair"),
			completion={{questaccepted="Bathran's Hair"}},
			mapzone="Ashenvale",
			level=21,
			mapnote=38606500,
		}, {
			"Grind to level 22",
			completion={{level=22}},
			mapzone="Ashenvale",
			level=21,
		}, {
			"Go southwest to "..cl(23,52),
			"	a. Talk to Therysil",
			"		i. Turn in "..cq("Therylune's Escape"),
			completion={{questturnedin="Therylune's Escape"}},
			mapzone="Ashenvale",
			level=22,
			mapnote=51907460,
		}, {
			"Go east to Astranaar",
			completion={{location={mapzone="Ashenvale",x=35.5,y=50.2, dist=5}}},
			mapzone="Ashenvale",
			level=22,
		}, {
			"Go to "..cl(34,48),
			"	a. Talk to Daelyshia",
			"		i. Get the Astranaar Flight Path",
			completion={{flightpath="Astranaar"}},
			mapzone="Ashenvale",
			level=22,
			mapnote=48008240,
		}, {
			"Go to "..cl(35,49),
			"	a. Talk to Shindrell Swiftfire",
			"		i. Turn in "..cq("Journey to Astranaar"),
			"		ii. Accept "..cq("The Zoram Strand"),
			completion={{questturnedin="Journey to Astranaar"},{questaccepted="The Zoram Strand"}},
			mapzone="Ashenvale",
			level=22,
			mapnote=48808350,
		}, {
			"Go to "..cl(35,50),
			"	a. Talk to Sentinel Thenysil",
			"		i. Accept "..cq("On Guard in Stonetalon part 1"),
			completion={{questaccepted="On Guard in Stonetalon part 1"}},
			mapzone="Ashenvale",
			level=22,
			mapnote=49808470,
		}, {
			"Go to "..cl(36,49),
			"	a. Talk to Faldreas Goeth'Shael",
			"		i. Accept "..cq("Journey to Stonetalon Peak"),
			completion={{questaccepted="Journey to Stonetalon Peak"}},
			mapzone="Ashenvale",
			level=22,
			mapnote=49108490,
		}, {
			"Go to "..cl(37,50),
			"	a. Talk to Raene Wolfrunner",
			"		i. Accept "..cq("Raene's Cleansing part 1"),
			"		ii. Accept "..cq("Culling the Threat"),
			completion={{questaccepted="Raene's Cleansing part 1"},{questaccepted="Culling the Threat"}},
			mapzone="Ashenvale",
			level=22,
			mapnote=49608620,
		}, {
			"Fly to Auberdine",
			completion={{location={mapzone="Darkshore",x=38.1,y=43.1, dist=9}}},
			mapzone="Ashenvale",
			level=22,
		}, {
			"Go to "..cl(36,45),
			"	a. Talk to Gubber Blump",
			"		i. Turn in "..cq("Fruit of the Sea"),
			completion={{questturnedin="Fruit of the Sea"}},
			mapzone="Darkshore",
			level=22,
			mapnote=44908100,
		}, {
			"Go to "..cl(36,44),
			"	a. Talk to Cerellean Whiteclaw",
			"		i. Turn in "..cq("For Love Eternal"),
			completion={{questturnedin="For Love Eternal"}},
			mapzone="Darkshore",
			level=22,
			mapnote=43707940,
		}, {
			"Go to "..cl(38,43),
			"	a. Talk to Sentinel Glynda Nal'Shea",
			"		i. Turn in "..cq("WANTED: Murkdeep!"),
			completion={{questturnedin="WANTED: Murkdeep!"}},
			mapzone="Darkshore",
			level=22,
			mapnote=43408110,
		}, {
			"Go northeast to "..cl(57,24),
			"	a. Click the Mathystra Relics on the ground",
			"	b. Get 6 Mathystra Relics",
			completion={{questgoal={"*","Mathystra Relic",6}}},
			mapzone="Darkshore",
			level=22,
			mapnote=23508070,
		}, {
			"Hearth to Auberdine",
			completion={{location={mapzone="Darkshore",x=38.1,y=43.1, dist=9}}},
			mapzone="Darkshore",
			level=22,
		}, {
			"Go south to "..cl(44,76),
			"	a. Talk to Onu",
			"		i. Turn in "..cq("Mathystra Relics"),
			completion={{questturnedin="Mathystra Relics"}},
			mapzone="Darkshore",
			level=22,
			mapnote=76311980,
		}, {
			"Go south to Ashenvale",
			completion={{location={mapzone="Ashenvale"}}},
			mapzone="Darkshore",
			level=22,
		}, {
			"Go to "..cl(30,24),
			"	a. Click the Plant Bundles on the ground",
			"	b. Get 5 Bathran's Hair",
			completion={{questgoal={"*","Bathran's Hair",5}}},
			mapzone="Ashenvale",
			level=22,
			mapnote=24005360,
		}, {
			"Go southeast to "..cl(33,29),
			"	a. Kill Dark Strand mobs",
			"	b. Get a Glowing Soul Gem",
			completion={{questgoal={"*","Glowing Soul Gem",1}}},
			mapzone="Ashenvale",
			level=22,
			mapnote=28706140,
		}, {
			"Go south to Maestra's Post",
			completion={{location={mapzone="Ashenvale",x=26.6,y=37.4, dist=6}}},
			mapzone="Ashenvale",
			level=22,
		}, {
			"Go to "..cl(26,39),
			"	a. Talk to Delgren the Purifier",
			"		i. Turn in "..cq("The Tower of Althalaxx part 4"),
			completion={{questturnedin="The Tower of Althalaxx part 4"}},
			mapzone="Ashenvale",
			level=22,
			mapnote=38606480,
		}, {
			"Also at "..cl(26,39),	
			"	a. Talk to Orendil Broadleaf",
			"		i. Turn in "..cq("Bathran's Hair"),
			"		ii. Accept "..cq("Orendil's Cure"),
			completion={{questturnedin="Bathran's Hair"},{questaccepted="Orendil's Cure"}},
			mapzone="Ashenvale",
			level=22,
			mapnote=38606500,
		}, {
			"Grind to level 23",
			completion={{level=23}},
			mapzone="Ashenvale",
			level=22,
		}, {
			"Go southeast to Astranaar",
			completion={{location={mapzone="Ashenvale",x=35.5,y=50.2, dist=5}}},
			mapzone="Ashenvale",
			level=23,
		}, {
			"Make Astranaar your home",
			completion={{home="Astranaar"}},
			mapzone="Ashenvale",
			level=23,
		}, {
			"Go to "..cl(37,52),
			"	a. Talk to Pelturas Whitemoon",
			"		i. Turn in "..cq("Orendil's Cure"),
			"		ii. Accept "..cq("Elune's Tear"),
			completion={{questturnedin="Orendil's Cure"},{questaccepted="Elune's Tear"}},
			mapzone="Ashenvale",
			level=23,
			mapnote=51808920,
		}, {
			"Go northwest to "..cl(20,42),
			"	a. Click Teronis' Corpse",
			"		i. Turn in "..cq("Raene's Cleansing part 1"),
			"		ii. Accept "..cq("Raene's Cleansing part 1"),
			"	b. Kill murlocs",
			"	c. Get a Glowing Gem",
			completion={{questturnedin="Raene's Cleansing part 1"},{questaccepted="Raene's Cleansing part 1"},{questgoal={"*","Glowing Gem",1}}},
			mapzone="Ashenvale",
			level=23,
			mapnote=42306260,
		}, {
			"Go northwest to "..cl(15,31),
			"	a. Talk to Talen",
			"		i. Accept "..cq("The Ancient Statuette"),
			completion={{questaccepted="The Ancient Statuette"}},
			mapzone="Ashenvale",
			level=23,
			mapnote=31304610,
		}, {
			"Go north to "..cl(14,27),
			"	a. Kill nagas",
			"	b. Get 20 Wrathtail Heads",
			completion={{questgoal={"*","Wrathtail Head",20}}},
			mapzone="Ashenvale",
			level=23,
			mapnote=26804100,
		}, {
			"Go north "..cl(14,21),
			"	a. Click the Ancient Statuette on the ground",
			"	b. Get the Ancient Statuette",
			completion={{questgoal={"*","Ancient Statuette",1}}},
			mapzone="Ashenvale",
			level=23,
			mapnote=20603480,
		}, {
			"Go south to "..cl(15,31),
			"	a. Talk to Talen",
			"		i. Turn in "..cq("The Ancient Statuette"),
			"		ii. Accept "..cq("Ruuzel"),
			completion={{questturnedin="The Ancient Statuette"},{questaccepted="Ruuzel"}},
			mapzone="Ashenvale",
			level=23,
			mapnote=31304610,
		}, {
			"Go northwest to "..cl(7,13),
			"	a. Kill Ruuzel",
			"	b. Get the Ring of Zoram",
			completion={{questgoal={"*","Ring of Zoram",1}}},
			mapzone="Ashenvale",
			level=23,
			mapnote=12602000,
		}, {
			"Go southeast to "..cl(15,31),
			"	a. Talk to Talen",
			"		i. Turn in "..cq("Ruuzel"),
			completion={{questturnedin="Ruuzel"}},
			mapzone="Ashenvale",
			level=23,
			mapnote=31304610,
		}, {
			"Hearth to Astranaar",
			completion={{location={mapzone="Ashenvale",x=35.5,y=50.2, dist=5}}},
			mapzone="Ashenvale",
			level=23,
		}, {
			"Go to "..cl(37,50),
			"	a. Raene Wolfrunner",
			"		i. Turn in "..cq("Raene's Cleansing part 2"),
			"		ii. Accept "..cq("Raene's Cleansing part 3"),
			"		iii. Accept "..cq("An Aggressive Defense"),
			completion={{questturnedin="Raene's Cleansing part 2"},{questaccepted="Raene's Cleansing part 3"},{questaccepted="An Aggressive Defense"}},
			mapzone="Ashenvale",
			level=23,
			mapnote=49608620,
		}, {
			"Go to "..cl(35,49),
			"	a. Talk to Shindrell Swiftfire",
			"		i. Turn in "..cq("The Zoram Strand"),
			"		ii. Accept "..cq("Pridewings of Stonetalon"),
			completion={{questturnedin="The Zoram Strand"},{questaccepted="Pridewings of Stonetalon"}},
			mapzone="Ashenvale",
			level=23,
			mapnote=48808350,
		}, {
			"Go north to "..cl(37,34),
			"	a. Kill Dal Bloodclaw",
			"	b. Get Dal Bloodclaw's Skull",
			completion={{questgoal={"*","Dal Bloodclaw's Skull",1}}},
			mapzone="Ashenvale",
			level=23,
			mapnote=33907130,
		}, {
			"Go south to Astranaar",
			completion={{location={mapzone="Ashenvale",x=35.5,y=50.2, dist=5}}},
			mapzone="Ashenvale",
			level=23,
		}, {
			"Go to "..cl(37,50),
			"	a. Talk to Raene Wolfrunner",
			"		i. Turn in "..cq("Culling the Threat"),
			completion={{questturnedin="Culling the Threat"}},
			mapzone="Ashenvale",
			level=23,
			mapnote=49608620,
		}, {
			"Grind to level 24",
			completion={{level=24}},
			mapzone="Ashenvale",
			level=23,
		}, {
			"Go northeast to "..cl(54,46),
			"	a. Talk to Shael'dryn",
			"		i. Turn in "..cq("Raene's Cleansing part 3"),
			"		ii. Accept "..cq("Raene's Cleansing part 4"),
			completion={{questturnedin="Raene's Cleansing part 3"},{questaccepted="Raene's Cleansing part 4"}},
			mapzone="Ashenvale",
			level=24,
			mapnote=46309980,
		}, {
			"Go south to "..cl(51,60),
			"	a. Kill 1 Foulweald Den Watcher",
			"	b. Kill 2 Foulweald Ursas",
			"	c. Kill 10 Foulweald Totemic",
			"	d. Kill 12 Foulweald Warriors",
			completion={{questgoal={"*","Foulweald Den Watcher slain",1}},{questgoal={"*","Foulweald Ursa slain",2}},{questgoal={"*","Foulweald Totemic slain",10}},{questgoal={"*","Foulweald Warrior slain",12}}},
			mapzone="Ashenvale",
			level=24,
			mapnote=60211110,
		}, {
			"Go northwest to "..cl(44,55),
			"	a. The path to 'Elune's Tear' starts here",
			completion={{location={mapzone="Ashenvale",x=44.0,y=55.0, dist=0.5}}},
			mapzone="Ashenvale",
			level=24,
			mapnote=55009900,
		}, {
			"Go north to "..cl(46,46),
			"	a. Click an Elune's Tear on the ground",
			"	b. Get Elune's Tear",
			completion={{questgoal={"*","Elune's Tear",1}}},
			mapzone="Ashenvale",
			level=24,
			mapnote=46009220,
		}, {
			"Hearth to Astranaar",
			completion={{location={mapzone="Ashenvale",x=35.5,y=50.2, dist=5}}},
			mapzone="Ashenvale",
			level=24,
		}, {
			"Go to "..cl(37,50),
			"	a. Talk to Raene Wolfrunner",
			"		i. Turn in "..cq("An Aggressive Defense"),
			completion={{questturnedin="An Aggressive Defense"}},
			mapzone="Ashenvale",
			level=24,
			mapnote=49608620,
		}, {
			"Go to "..cl(35,49),
			"	a. Talk to Shindrell Swiftfire",
			"		i. Accept "..cq("Kayneth Stillwind"),
			completion={{questaccepted="Kayneth Stillwind"}},
			mapzone="Ashenvale",
			level=24,
			mapnote=48808350,
		}, {
			"Go to "..cl(35,50),
			"	a. Talk to Vindicator Palanaar",
			"		i. Accept "..cq("A Helping Hand"),
			completion={{questaccepted="A Helping Hand"}},
			mapzone="Ashenvale",
			level=24,
			mapnote=49808470,
		}, {
			"Go to "..cl(37,52),
			"	a. Talk to Pelturas Whitemoon",
			"		i. Turn in "..cq("Elune's Tear"),
			"		ii. Accept "..cq("The Ruins of Stardust"),
			completion={{questturnedin="Elune's Tear"},{questaccepted="The Ruins of Stardust"}},
			mapzone="Ashenvale",
			level=24,
			mapnote=51808920,
		}, {
			"Go south to "..cl(38,55),
			"	a. The path to the Ruins of Stardust starts here",
			completion={{location={mapzone="Ashenvale",x=37.4,y=55.2, dist=0.5}}},
			mapzone="Ashenvale",
			level=24,
			mapnote=55109260,
		}, {
			"Go southwest to "..cl(34,67),
			"	a. Click the Stardust Covered Bushes",
			"	b. Get 5 Handfuls of Stardust",
			completion={{questgoal={"*","Handful of Stardust",5}}},
			mapzone="Ashenvale",
			level=24,
			mapnote=66510020,
		}, {
			"Go north to Astranaar",
			completion={{location={mapzone="Ashenvale",x=35.5,y=50.2, dist=5}}},
			mapzone="Ashenvale",
			level=24,
		}, {
			"Go to "..cl(37,52),
			"	a. Talk to Pelturas Whitemoon",
			"		i. Turn in "..cq("The Ruins of Stardust"),
			"		ii. Accept "..cq("Fallen Sky Lake"),
			completion={{questturnedin="The Ruins of Stardust"},{questaccepted="Fallen Sky Lake"}},
			mapzone="Ashenvale",
			level=24,
			mapnote=51808920,
		}, {
			"Go southeast to "..cl(50,67),
			"	a. Talk to Sentinel Velene Starstrike",
			"		i. Accept "..cq("Elemental Bracers"),
			completion={{questaccepted="Elemental Bracers"}},
			mapzone="Ashenvale",
			level=24,
			mapnote=67211700,
		}, {
			"Go south to "..cl(49,69),
			"	a. Kill elementals",
			"	b. Get 5 Intact Elemental Bracers",
			"	c. Use your Divining Scroll on the bracers",
			"	d. Get a Divined Scroll",
			completion={{questgoal={"*","Divined Scroll",1}}},
			mapzone="Ashenvale",
			level=24,
			mapnote=69311870,
		}, {
			"Go north to "..cl(50,67),
			"	a. Talk to Sentinel Velene Starstrike",
			"		i. Turn in "..cq("Elemental Bracers"),
			completion={{questturnedin="Elemental Bracers"}},
			mapzone="Ashenvale",
			level=24,
			mapnote=67211700,
		}, {
			"Go southwest to Talondeep path",
			"	a. Go through the tunnel to Stonetalon Mountains",
			completion={{location={mapzone="Stonetalon Mountains",x=78.2,y=42.9, dist=0.5}}},
			mapzone="Ashenvale",
			level=24,
			mapnote=71111340,
		}, {
			"Go southwest to "..cl(59,63),
			"	a. Talk to Ziz Fizziks",
			"		i. Accept "..cq("Super Reaper 6000"),
			completion={{questaccepted="Super Reaper 6000"}},
			mapzone="Stonetalon Mountains",
			level=24,
			mapnote=62612160,
		}, {
			"Go south to "..cl(60,67),
			"	a. Talk to Kaela Shadowspear",
			"		i. Turn in "..cq("On Guard in Stonetalon part 1"),
			"		ii. Accept "..cq("On Guard in Stonetalon part 2"),
			"	b. Talk to Gaxim Rustfizzle",
			"		i. Turn in "..cq("On Guard in Stonetalon part 2"),
			"		ii. Accept "..cq("A Gnome's Respite"),
			completion={{questturnedin="On Guard in Stonetalon part 1"},{questaccepted="On Guard in Stonetalon part 2"},{questturnedin="On Guard in Stonetalon part 2"},{questaccepted="A Gnome's Respite"}},
			mapzone="Stonetalon Mountains",
			level=24,
			mapnote=67012670,
		}, {
			"Go northeast "..cl(63,57),
			"	a. Kill 10 Venture Co. Loggers",
			"	b. Kill 10 Venture Co. Deforesters",
			completion={{questgoal={"*","Venture Co. Logger slain",10}},{questgoal={"*","Venture Co. Deforester slain",10}}},
			mapzone="Stonetalon Mountains",
			level=24,
			mapnote=55511720,
		}, {
			"Go north to "..cl(63,54),
			"	a. Kill Venture Co. Operators",
			"	b. Get the Super Reaper 6000 Blueprints",
			completion={{questgoal={"*","Super Reaper 6000 Blueprints",1}}},
			mapzone="Stonetalon Mountains",
			level=24,
			mapnote=53811660,
		}, {
			"Go southwest to "..cl(59,63),
			"	a. Talk to Ziz Fizziks",
			"		i. Turn in "..cq("Super Reaper 6000"),
			completion={{questturnedin="Super Reaper 6000"}},
			mapzone="Stonetalon Mountains",
			level=24,
			mapnote=62612160,
		}, {
			"Grind to level 25",
			completion={{level=25}},
			mapzone="Stonetalon Mountains",
			level=24,
		}
	  },
	},
	{ sectiontitle = "Levels (25-30)",
	  steps = {
		{
			"Go south to "..cl(60,67),
			"	a. Talk to Gaxim Rustfizzle",
			"		i. Turn in "..cq("A Gnome's Respite"),
			"		ii. Accept "..cq("An Old Colleague"),
			"		iii. Accept "..cq("A Scroll from Mauren"),
			"		iv. Accept "..cq("Castpipe's Task"),
			completion={{questturnedin="A Gnome's Respite"},{questaccepted="An Old Colleague"},{questaccepted="A Scroll from Mauren"},{questaccepted="Castpipe's Task"}},
			mapzone="Stonetalon Mountains",
			level=25,
			mapnote=67012670,
		}, {
			"Go northwest to "..cl(52,46),
			"	a. Kill Pridewing Wyverns",
			"	b. Get 12 Pridewing Venom Sacs",
			completion={{questgoal={"*","Pridewing Venom Sac",12}}},
			mapzone="Stonetalon Mountains",
			level=25,
			mapnote=46009750,
		}, {
			"Go northwest to Stonetalon Peak",
			completion={{location={mapzone="Stonetalon Mountains",x=36.5,y=7.3, dist=6}}},
			mapzone="Stonetalon Mountains",
			level=25,
		}, {
			"Go to 37,8",
			"	a. Talk to Keeper Albagorm",
			"		i. Turn in "..cq("Journey to Stonetalon Peak"),
			completion={{questturnedin="Journey to Stonetalon Peak"}},
			mapzone="Stonetalon Mountains",
			level=25,
			mapnote=8104520,
		}, {
			"Go to "..cl(36,7),
			"	a. Talk to Teloren",
			"		i. Get the Stonetalon Peak Flight Path",
			completion={{flightpath="Stonetalon Peak"}},
			mapzone="Stonetalon Mountains",
			level=25,
			mapnote=7204360,
		}, {
			"Fly to Astranaar",
			completion={{location={mapzone="Ashenvale",x=35.5,y=50.2, dist=5}}},
			mapzone="Stonetalon Peak",
			level=25,
		}, {
			"Go to "..cl(35,49),
			"	a. Talk to Shindrell Swiftfire",
			"		i. Turn in "..cq("Pridewings of Stonetalon"),
			completion={{questturnedin="Pridewings of Stonetalon"}},
			mapzone="Ashenvale",
			level=25,
			mapnote=48808350,
		}, {
			"Fly to Auberdine",
			completion={{location={mapzone="Darkshore",x=38.1,y=43.1, dist=9}}},
			mapzone="Ashenvale",
			level=25,
		}, {
			"Ride the boat to Menethil Harbor",
			completion={{location={mapzone="Wetlands",x=4.6,y=56.8, dist=9}}},
			mapzone="Darkshore",
			level=25,
		}, {
			"Go to "..cl(8,59),
			"	a. Talk to Karl Boran",
			"		i. Accept "..cq("Claws from the Deep"),
			completion={{questaccepted="Claws from the Deep"}},
			mapzone="Wetlands",
			level=25,
			mapnote=58606690,
		}, {
			"Go to "..cl(11,60),
			"	a. Talk to First Mate Fitzsimmons",
			"		i. Accept "..cq("The Third Fleet"),
			"		ii. Accept "..cq("The Greenwarden"),
			completion={{questaccepted="The Third Fleet"},{questaccepted="The Greenwarden"}},
			mapzone="Wetlands",
			level=25,
			mapnote=59607050,
		}, {
			"Go to "..cl(11,61),
			"	a. Talk to Innkeeper Helbrek",
			"		i. Buy a Flagon of Mead",
			completion={{questgoal={"*","Flagon of Mead",1}}},
			mapzone="Wetlands",
			level=25,
			mapnote=60807160,
		}, {
			"Make Menethil Harbor your home",
			completion={{home="Menethil Harbor"}},
			mapzone="Wetlands",
			level=25,
		}, {
			"Go to "..cl(11,60),
			"	a. Talk to First Mate Fitzsimmons",
			"		i. Turn in "..cq("The Third Fleet"),
			completion={{questturnedin="The Third Fleet"}},
			mapzone="Wetlands",
			level=25,
			mapnote=59607050,
		}, {
			"Go to "..cl(12,58),
			"	a. Talk to Sida",
			"		i. Accept "..cq("Digging Through the Ooze"),
			completion={{questaccepted="Digging Through the Ooze"}},
			mapzone="Wetlands",
			level=25,
			mapnote=58006980,
		}, {
			"Go to "..cl(10,57),
			"	a. Talk to Captain Stoutfist",
			"		i. Accept "..cq("War Banners"),
			completion={{questaccepted="War Banners"}},
			mapzone="Wetlands",
			level=25,
			mapnote=57506740,
		}, {
			"Go to "..cl(9,56),
			"	a. Talk to James Halloran",
			"		i. Accept "..cq("Young Crocolisk Skins"),
			completion={{questaccepted="Young Crocolisk Skins"}},
			mapzone="Wetlands",
			level=25,
			mapnote=55706420,
		}, {
			"Go to "..cl(12,52),
			"	a. Talk to Tarrel Rockweaver",
			"		i. Accept "..cq("In Search of The Excavation Team part 1"),
			completion={{questaccepted="In Search of The Excavation Team part 1"}},
			mapzone="Wetlands",
			level=25,
			mapnote=52206370,
		}, {
			"Go northeast to "..cl(14,42),
			"	a. Kill 12 Bluegill Murlocs",
			completion={{questgoal={"*","Bluegill Murloc slain",12}}},
			mapzone="Wetlands",
			level=25,
			mapnote=41905570,
		}, {
			"Go east to "..cl(15,41),
			"	a. Kill Gobbler",
			"	b. Get Gobbler's Head",
			completion={{questgoal={"*","Gobbler's Head",1}}},
			mapzone="Wetlands",
			level=25,
			mapnote=40705570,
		}, {
			"Go southeast to "..cl(38,51),
			"	a. Talk to Ormer Ironbraid",
			"		i. Accept "..cq("Ormer's Revenge part 1"),
			completion={{questaccepted="Ormer's Revenge part 1"}},
			mapzone="Wetlands",
			level=25,
			mapnote=51108920,
		}, {
			"Go to southeast to "..cl(39,52),
			"	a. Talk to Merrin Rockweaver",
			"		i. Turn in "..cq("In Search of The Excavation Team part 1"),
			"		ii. Accept "..cq("In Search of The Excavation Team part 2"),
			"	b. Talk to Prospector Whelgar",
			"		i. Accept "..cq("Uncovering the Past"),
			completion={{questturnedin="In Search of The Excavation Team part 1"},{questaccepted="In Search of The Excavation Team part 2"},{questaccepted="Uncovering the Past"}},
			mapzone="Wetlands",
			level=25,
			mapnote=52309110,
		}, {
			"Go northwest to "..cl(29,45),
			"	a. Kill 10 Mottled Raptors",
			"	b. Kill 10 Mottled Screechers",
			completion={{questgoal={"*","Mottled Raptor slain",10}},{questgoal={"*","Mottled Screecher slain",10}}},
			mapzone="Wetlands",
			level=25,
			mapnote=44807390,
		}, {
			"Go southeast to "..cl(38,51),
			"	a. Talk to Ormer Ironbraid",
			"		i. Turn in "..cq("Ormer's Revenge part 1"),
			"		ii. Accept "..cq("Ormer's Revenge part 2"),
			completion={{questturnedin="Ormer's Revenge part 1"},{questaccepted="Ormer's Revenge part 2"}},
			mapzone="Wetlands",
			level=25,
			mapnote=51108920,
		}, {
			"Go northwest to "..cl(35,45),
			"	a. Kill 10 Mottled Scytheclaws",
			"	b. Kill 10 Mottled Razormaws",
			"	c. Get the 4 Relics.  They can spawn up the hill next to Sarltooth also",
			"		i. Ados Fragment.  Looks like a big stone box",
			"		ii. Modr Fragment.  Looks like a skinny red vase with a yellow face on it",
			"		iii. Golm Fragment.  Looks like a fat yellow vase with black silhouettes on it",
			"		iv. Neru Fragment  .Looks like a mound of dirt",
			completion={{questgoal={"*","Mottled Scytheclaw slain",10}},{questgoal={"*","Mottled Razormaw slain",10}},{questgoal={"*","Ados Fragment",1}},{questgoal={"*","Modr Fragment",1}},{questgoal={"*","Golm Fragment",1}},{questgoal={"*","Neru Fragment",1}}},
			mapzone="Wetlands",
			level=25,
			mapnote=45408020,
		}, {
			"Go to southeast to "..cl(38,51),
			"	a. Talk to Ormer Ironbraid",
			"		i. Turn in "..cq("Ormer's Revenge part 2"),
			"		ii. Accept "..cq("Ormer's Revenge part 3"),
			completion={{questturnedin="Ormer's Revenge part 2"},{questaccepted="Ormer's Revenge part 3"}},
			mapzone="Wetlands",
			level=25,
			mapnote=51108920,
		}, {
			"Go southeast to "..cl(39,52),
			"	a. Talk to Prospector Whelgar",
			"		i. Turn in "..cq("Uncovering the Past"),
			completion={{questturnedin="Uncovering the Past"}},
			mapzone="Wetlands",
			level=25,
			mapnote=52309110,
		}, {
			"Grind to level 26",
			completion={{level=26}},
			mapzone="Wetlands",
			level=25,
		}, {
			"Go west to "..cl(33,51),
			"	a. Kill Sarltooth",
			"	b. Get Sarltooth's Talon",
			completion={{questgoal={"*","Sarltooth's Talon",1}}},
			mapzone="Wetlands",
			level=26,
			mapnote=51408460,
		}, {
			"Go east to "..cl(38,51),
			"	a. Talk to Ormer Ironbraid",
			"		i. Turn in "..cq("Ormer's Revenge part 3"),
			completion={{questturnedin="Ormer's Revenge part 3"}},
			mapzone="Wetlands",
			level=26,
			mapnote=51108920,
		}, {
			"Go northeast to "..cl(43,41),
			"	a. Kill Dragonmaw orcs",
			"	b. Get 8 Dragonmaw War Banners",
			completion={{questgoal={"*","Dragonmaw War Banner",8}}},
			mapzone="Wetlands",
			level=26,
			mapnote=41208410,
		}, {
			"Go northeast to "..cl(50,39),
			"	a. Talk to Einar Stonegrip",
			"		i. Accept "..cq("Daily Delivery"),
			completion={{questaccepted="Daily Delivery"}},
			mapzone="Wetlands",
			level=26,
			mapnote=39408930,
		}, {
			"Go east to "..cl(52,40),
			"	a. Kill Young Wetlands Crocolisks",
			"	b. Get 4 Young Crocolisk Skins",
			completion={{questgoal={"*","Young Crocolisk Skin",4}}},
			mapzone="Wetlands",
			level=26,
			mapnote=40309270,
		}, {
			"Go east to "..cl(56,41),
			"	a. Talk to Rethiel the Greenwarden",
			"		i. Turn in "..cq("The Greenwarden"),
			"		ii. Accept "..cq("Tramping Paws"),
			completion={{questturnedin="The Greenwarden"},{questaccepted="Tramping Paws"}},
			mapzone="Wetlands",
			level=26,
			mapnote=40509680,
		}, {
			"Go southeast to "..cl(64,62),
			"	a. Kill 15 Mosshide Gnolls",
			"	b. Kill 10 Mosshide Mongrels",
			completion={{questgoal={"*","Mosshide Gnoll slain",15}},{questgoal={"*","Mosshide Mongrel slain",10}}},
			mapzone="Wetlands",
			level=26,
			mapnote=61812570,
		}, {
			"Go northwest to "..cl(56,41),
			"	a. Talk to Rethiel the Greenwarden",
			"		i. Turn in "..cq("Tramping Paws"),
			"		ii. Accept "..cq("Fire Taboo"),
			completion={{questturnedin="Tramping Paws"},{questaccepted="Fire Taboo"}},
			mapzone="Wetlands",
			level=26,
			mapnote=40509680,
		}, {
			"Go northwest to "..cl(46,35),
			"	a. Kill Mosshide gnolls",
			"	b. Get 9 Crude Flints",
			completion={{questgoal={"*","Crude Flint",9}}},
			mapzone="Wetlands",
			level=26,
			mapnote=35308170,
		}, {
			"Go southeast to "..cl(56,41),
			"	a. Talk to Rethiel the Greenwarden",
			"		i. Turn in "..cq("Fire Taboo"),
			"		ii. Accept "..cq("Blisters on The Land"),
			completion={{questturnedin="Fire Taboo"},{questaccepted="Blisters on The Land"}},
			mapzone="Wetlands",
			level=26,
			mapnote=40509680,
		}, {
			"Hearth to Menethil Harbor",
			completion={{location={mapzone="Wetlands",x=10.1,y=56.7, dist=9}}},
			mapzone="Wetlands",
			level=26,
		}, {
			"Go to "..cl(8,59),
			"	a. Talk to Karl Boran",
			"		i. Turn in "..cq("Claws from the Deep"),
			"		ii. Accept "..cq("Reclaiming Goods"),
			completion={{questturnedin="Claws from the Deep"},{questaccepted="Reclaiming Goods"}},
			mapzone="Wetlands",
			level=26,
			mapnote=58606690,
		}, {
			"Go to "..cl(9,56),
			"	a. Talk to James Halloran",
			"		i. Turn in "..cq("Young Crocolisk Skins"),
			"		ii. Turn in "..cq("Daily Delivery"),
			"		iii. Accept "..cq("Apprentice's Duties"),
			completion={{questturnedin="Young Crocolisk Skins"},{questturnedin="Daily Delivery"},{questaccepted="Apprentice's Duties"}},
			mapzone="Wetlands",
			level=26,
			mapnote=55706420,
		}, {
			"Go to "..cl(10,57),
			"	a. Talk to Captain Stoutfist",
			"		i. Turn in "..cq("War Banners"),
			"		ii. Accept "..cq("Nek'rosh's Gambit"),
			completion={{questturnedin="War Banners"},{questaccepted="Nek'rosh's Gambit"}},
			mapzone="Wetlands",
			level=26,
			mapnote=57506740,
		}, {
			"Go to "..cl(12,52),
			"	a. Talk to Tarrel Rockweaver",
			"		i. Turn in "..cq("In Search of The Excavation Team part 2"),
			completion={{questturnedin="In Search of The Excavation Team part 2"}},
			mapzone="Wetlands",
			level=26,
			mapnote=52206370,
		}, {
			"Grind to level 27",
			completion={{level=27}},
			mapzone="Wetlands",
			level=26,
		}, {
			"Go northeast to "..cl(14,41),
			"	a. Click the Damaged Crate",
			"		i. Turn in "..cq("Reclaiming Goods"),
			"		ii. Accept "..cq("The Search Continues"),
			completion={{questturnedin="Reclaiming Goods"},{questaccepted="The Search Continues"}},
			mapzone="Wetlands",
			level=27,
			mapnote=41405490,
		}, {
			"Go north to "..cl(14,38),
			"	a. Click the Sealed Barrel",
			"		i. Turn in "..cq("The Search Continues"),
			"		ii. Accept "..cq("Search More Hovels"),
			completion={{questturnedin="The Search Continues"},{questaccepted="Search More Hovels"}},
			mapzone="Wetlands",
			level=27,
			mapnote=38205180,
		}, {
			"Go north to "..cl(14,35),
			"	a. Click the Half-buried Barrel",
			"		i. Turn in "..cq("Search More Hovels"),
			"		ii. Accept "..cq("Return the Statuette"),
			completion={{questturnedin="Search More Hovels"},{questaccepted="Return the Statuette"}},
			mapzone="Wetlands",
			level=27,
			mapnote=34804870,
		}, {
			"Go east to "..cl(19,27),
			"	a. Kill 8 Fen Creepers",
			"	b. Kill Giant Wetlands Crocolisks",
			"	c. Get 6 Giant Crocolisk Skins",
			completion={{questgoal={"*","Fen Creeper slain",8}},{questgoal={"*","Giant Crocolisk Skin",6}}},
			mapzone="Wetlands",
			level=27,
			mapnote=27304580,
		}, {
			"Go east to "..cl(44,26),
			"	a. Kill oozes",
			"	b. Get Sida's Bag",
			completion={{questgoal={"*","Sida's Bag",1}}},
			mapzone="Wetlands",
			level=27,
			mapnote=25506980,
		}, {
			"Go southeast to "..cl(56,40),
			"	a. Talk to Rethiel the Greenwarden",
			"		i. Turn in "..cq("Blisters on The Land"),
			completion={{questturnedin="Blisters on The Land"}},
			mapzone="Wetlands",
			level=27,
			mapnote=40509680,
		}, {
			"Hearth to Menethil Harbor",
			completion={{location={mapzone="Wetlands",x=10.1,y=56.7, dist=9}}},
			mapzone="Wetlands",
			level=27,
		}, {
			"Go to "..cl(12,58),
			"	a. Talk to Sida",
			"		i. Turn in "..cq("Digging Through the Ooze"),
			completion={{questturnedin="Digging Through the Ooze"}},
			mapzone="Wetlands",
			level=27,
			mapnote=58006980,
		}, {
			"Go to "..cl(9,56),
			"	a. Talk to James Halloran",
			"		i. Turn in "..cq("Apprentice's Duties"),
			completion={{questturnedin="Apprentice's Duties"}},
			mapzone="Wetlands",
			level=27,
			mapnote=55706420,
		}, {
			"Go to "..cl(8,59),
			"	a. Talk to Karl Boran",
			"		i. Turn in "..cq("Return the Statuette"),
			completion={{questturnedin="Return the Statuette"}},
			mapzone="Wetlands",
			level=27,
			mapnote=58606690,
		}, {
			"Fly to Ironforge",
			completion={{location={mapzone="City of Ironforge"}}},
			mapzone="Wetlands",
			level=27,
		}, {
			"Go to "..cl(72,52),
			"	a. Talk to Lomar Gearstrip",
			"		i. Turn in "..cq("An Old Colleague"),
			completion={{questturnedin="An Old Colleague"}},
			mapzone="Ironforge",
			level=27,
			mapnote=51912400,
		}, {
			"Go to "..cl(70,48),
			"	a. Talk to Master Mechanic Castpipe",
			"		i. Turn in "..cq("Castpipe's Task"),
			completion={{questturnedin="Castpipe's Task"}},
			mapzone="Ironforge",
			level=27,
			mapnote=48011800,
		}, {
			"Fly to Stormwind",
			completion={{location={mapzone="Stormwind City"}}},
			mapzone="Ironforge",
			level=27,
		}, {
			"Buy a Bronze Tube from the Auction House",
			mapzone="Stormwind City",
			level=27,
		}, {
			"Go to "..cl(43,80),
			"	a. Talk to Collin Mauren",
			"		i. Turn in "..cq("A Scroll from Mauren"),
			completion={{questturnedin="A Scroll from Mauren"}},
			mapzone="Stormwind City",
			level=27,
			mapnote=80412350,
		}, {
			"Fly to Lakeshire",
			completion={{location={mapzone="Redridge Mountains",x=26.9,y=44.8, dist=5}}},
			mapzone="Stormwind City",
			level=27,
		}, {
			"Go to "..cl(32,58),
			"	a. Talk to Guard Howe",
			"		i. Accept "..cq("Blackrock Bounty"),
			completion={{questaccepted="Blackrock Bounty"}},
			mapzone="Redridge Mountains",
			level=27,
			mapnote=57908940,
		}, {
			"Go northwest to "..cl(16,50),
			"	a. Kill Bellygrub",
			"	b. Get Bellygrub's Tusk",
			completion={{questgoal={"*","Bellygrub's Tusk",1}}},
			mapzone="Redridge Mountains",
			level=27,
			mapnote=49506540,
		}, {
			"Go northeast to "..cl(22,46),
			"	a. Talk to Martie Jainrose",
			"		i. Turn in "..cq("An Unwelcome Guest"),
			completion={{questturnedin="An Unwelcome Guest"}},
			mapzone="Redridge Mountains",
			level=27,
			mapnote=46306820,
		}, {
			"Go to "..cl(27,47),
			"	a. Click the Wanted Poster",
			"		i. Accept "..cq("Wanted: Lieutenant Fangore"),
			completion={{questaccepted="Wanted: Lieutenant Fangore"}},
			mapzone="Redridge Mountains",
			level=27,
			mapnote=46507330,
		}, {
			"Make Lakeshire your home",
			completion={{home="Lakeshire"}},
			mapzone="Redridge Mountains",
			level=27,
		}, {
			"Go north to "..cl(33,7),
			"	a. Kill 15 Blackrock Champions",
			completion={{questgoal={"*","Blackrock Champion slain",15}}},
			mapzone="Redridge Mountains",
			level=27,
			mapnote=6803970,
		}, {
			"You may need help with the next step",
			mapzone="Redridge Mountains",
			level=27,
		}, {
			"Go southwest to "..cl(28,13),
			"	a. Talk to Corporal Keeshan",
			"		i. Accept "..cq("Missing In Action"),
			"		ii. Escort Corporal Keeshan to Lakeshire",
			completion={{questaccepted="Missing In Action"}},
			mapzone="Redridge Mountains",
			level=27,
			mapnote=12604100,
		}, {
			"At "..cl(34,49),
			"	a. Talk to Marshal Marris",
			"		i. Turn in "..cq("Missing In Action"),
			"		ii. Accept "..cq("Shadow Magic"),
			completion={{questturnedin="Missing In Action"},{questaccepted="Shadow Magic"}},
			mapzone="Redridge Mountains",
			level=27,
			mapnote=49008250,
		}, {
			"Go to "..cl(32,58),
			"	a. Talk to Guard Howe",
			"		i. Turn in "..cq("Blackrock Bounty"),
			completion={{questturnedin="Blackrock Bounty"}},
			mapzone="Redridge Mountains",
			level=27,
			mapnote=57908940,
		}, {
			"Go east to "..cl(67,52),
			"	a. Kill Blackrock Shadowcasters",
			"	b. Get 3 Midnight Orbs",
			completion={{questgoal={"*","Midnight Orb",3}}},
			mapzone="Redridge Mountains",
			level=27,
			mapnote=52011900,
		}, {
			"Grind to level 28",
			completion={{level=28}},
			mapzone="Redridge Mountains",
			level=27,
		}, {
			"Go northeast to "..cl(72,42),
			"	a. Kill Shadowhide gnolls",
			"	b. Get 10 Shadowhide Pendants",
			completion={{questgoal={"*","Shadowhide Pendant",10}}},
			mapzone="Redridge Mountains",
			level=28,
			mapnote=41611330,
		}, {
			"Go northeast to "..cl(80,38),
			"	a. Kill Lieutenant Fangore",
			"	b. Get Fangore's Paw",
			completion={{questgoal={"*","Fangore's Paw",1}}},
			mapzone="Redridge Mountains",
			level=28,
			mapnote=37711760,
		}, {
			"Hearth to Lakeshire",
			completion={{location={mapzone="Redridge Mountains",x=26.9,y=44.8, dist=5}}},
			mapzone="Redridge Mountains",
			level=28,
		}, {
			"Go to "..cl(30,44),
			"	a. Talk to Bailiff Conacher",
			"		i. Turn in "..cq("Solomon's Law"),
			"	b. Talk to Magistrate Solomon",
			"		i. Turn in "..cq("Wanted: Lieutenant Fangore"),
			completion={{questturnedin="Solomon's Law"},{questturnedin="Wanted: Lieutenant Fangore"}},
			mapzone="Redridge Mountains",
			level=28,
			mapnote=44407440,
		}, {
			"Go to "..cl(34,49),
			"	a. Talk to Marshal Marris",
			"		i. Turn in "..cq("Shadow Magic"),
			completion={{questturnedin="Shadow Magic"}},
			mapzone="Redridge Mountains",
			level=28,
			mapnote=49008250,
		}, {
			"Go southwest to Duskwood",
			completion={{location={mapzone="Duskwood"}}},
			mapzone="Redridge Mountains",
			level=28,
		}, {
			"Go southwest to Darkshire",
			completion={{location={mapzone="Duskwood",x=74.7,y=46.9, dist=7}}},
			mapzone="Duskwood",
			level=28,
		}, {
			"Go to "..cl(76,45),
			"	a. Talk to Madame Eva",
			"		i. Accept "..cq("The Totem of Infliction"),
			"		ii. Accept "..cq("The Legend of Stalvan part 1"),
			completion={{questaccepted="The Totem of Infliction"},{questaccepted="The Legend of Stalvan part 1"}},
			mapzone="Duskwood",
			level=28,
			mapnote=45312110,
		}, {
			"Go to "..cl(78,44),
			"	a. Talk to Felicia Maline",
			"		i. Get the Darkshire Flight Path",
			completion={{flightpath="Darkshire"}},
			mapzone="Duskwood",
			level=28,
			mapnote=44312180,
		}, {
			"Go to "..cl(80,48),
			"	a. Talk to Viktori Prism'Antras",
			"		i. Accept "..cq("Look To The Stars part 1"),
			"		ii. Turn in "..cq("Look To The Stars part 1"),
			"		iii. Accept "..cq("Look To The Stars part 2"),
			completion={{questaccepted="Look To The Stars part 1"},{questturnedin="Look To The Stars part 1"},{questaccepted="Look To The Stars part 2"}},
			mapzone="Duskwood",
			level=28,
			mapnote=48112790,
		}, {
			"Go to "..cl(76,48),
			"	a. Talk to Calor",
			"		i. Accept "..cq("Worgen in the Woods part 1"),
			completion={{questaccepted="Worgen in the Woods part 1"}},
			mapzone="Duskwood",
			level=28,
			mapnote=47612330,
		}, {
			"Go to "..cl(75,49),
			"	a. Talk to Elaine Carevin",
			"		i. Accept "..cq("Deliveries to Sven"),
			"		ii. Accept "..cq("The Hermit"),
			"		iii. Accept "..cq("Raven Hill"),
			completion={{questaccepted="Deliveries to Sven"},{questaccepted="The Hermit"},{questaccepted="Raven Hill"}},
			mapzone="Duskwood",
			level=28,
			mapnote=48712400,
		}, {
			"Go to "..cl(74,47),
			"	a. Talk to Commander Althea Ebonlocke",
			"		i. Accept "..cq("The Night Watch part 1"),
			completion={{questaccepted="The Night Watch part 1"}},
			mapzone="Duskwood",
			level=28,
			mapnote=46812030,
		}, {
			"Go to "..cl(73,47),
			"	a. Talk to Clerk Daltry",
			"		i. Turn in "..cq("The Legend of Stalvan part 1"),
			completion={{questturnedin="The Legend of Stalvan part 1"}},
			mapzone="Duskwood",
			level=28,
			mapnote=46811930,
		}, {
			"Make Darkshire your home",
			completion={{home="Darkshire"}},
			mapzone="Duskwood",
			level=28,
		}, {
			"Go west to "..cl(70,45),
			"	a. The path over to Worgen in the Woods starts here",
			"	b. Run up the hill behind the town hall building",
			completion={{location={mapzone="Duskwood",x=70.8,y=45.6, dist=0.5}}},
			mapzone="Duskwood",
			level=28,
			mapnote=45011500,
		}, {
			"Go west to "..cl(66,47),
			"	a. Kill 6 Nightbane Shadow Weavers",
			completion={{questgoal={"*","Nightbane Shadow Weaver slain",6}}},
			mapzone="Duskwood",
			level=28,
			mapnote=47011300,
		}, {
			"Go east to Darkshire",
			completion={{location={mapzone="Duskwood",x=74.7,y=46.9, dist=7}}},
			mapzone="Duskwood",
			level=28,
		}, {
			"Go to "..cl(76,48),
			"	a. Talk to Calor",
			"		i. Turn in "..cq("Worgen in the Woods part 1"),
			"		ii. Accept "..cq("Worgen in the Woods part 2"),
			completion={{questturnedin="Worgen in the Woods part 1"},{questaccepted="Worgen in the Woods part 2"}},
			mapzone="Duskwood",
			level=28,
			mapnote=47612330,
		}, {
			"Go west to "..cl(66,47),
			"	a. Kill 12 Nightbane Dark Runners",
			completion={{questgoal={"*","Nightbane Dark Runner slain",12}}},
			mapzone="Duskwood",
			level=28,
			mapnote=47011300,
		}, {
			"Go east to Darkshire",
			completion={{location={mapzone="Duskwood",x=74.7,y=46.9, dist=7}}},
			mapzone="Duskwood",
			level=28,
		}, {
			"Go to "..cl(76,48),
			"	a. Talk to Calor",
			"		i. Turn in "..cq("Worgen in the Woods part 2"),
			"		ii. Accept "..cq("Worgen in the Woods part 3"),
			completion={{questturnedin="Worgen in the Woods part 2"},{questaccepted="Worgen in the Woods part 3"}},
			mapzone="Duskwood",
			level=28,
			mapnote=47612330,
		}, {
			"Go southeast to "..cl(82,59),
			"	a. Talk to Blind Mary",
			"		i. Turn in "..cq("Look To The Stars part 2"),
			"		ii. Accept "..cq("Look To The Stars part 3"),
			completion={{questturnedin="Look To The Stars part 2"},{questaccepted="Look To The Stars part 3"}},
			mapzone="Duskwood",
			level=28,
			mapnote=59214110,
		}, {
			"Go southwest to "..cl(79,70),
			"	a. Kill 8 Skeletal Warriors",
			"	b. Kill 6 Skeletal Mages",
			"	c. Kill skeletons",
			"	d. Get 10 Skeleton Fingers",
			completion={{questgoal={"*","Skeletal Warrior slain",8}},{questgoal={"*","Skeletal Mage slain",6}},{questgoal={"*","Skeleton Finger",10}}},
			mapzone="Duskwood",
			level=28,
			mapnote=70314960,
		}, {
			"Go southeast to "..cl(81,72),
			"	a. Kill the Insane Ghoul",
			"	b. Get Mary's Looking Glass",
			completion={{questgoal={"*","Mary's Looking Glass",1}}},
			mapzone="Duskwood",
			level=28,
			mapnote=71615250,
		}, {
			"Go west to "..cl(73,70),
			"	a. Kill 8 Nightbane Vile Fangs",
			"	b. Kill 8 Nightbane Tainted Ones",
			completion={{questgoal={"*","Nightbane Vile Fang slain",8}},{questgoal={"*","Nightbane Tainted One slain",8}}},
			mapzone="Duskwood",
			level=28,
			mapnote=69714240,
		}, {
			"Hearth to Darkshire",
			completion={{location={mapzone="Duskwood",x=74.7,y=46.9, dist=7}}},
			mapzone="Duskwood",
			level=28,
		}, {
			"Go to "..cl(74,47),
			"	a. Talk to Commander Althea Ebonlocke",
			"		i. Turn in "..cq("The Night Watch part 1"),
			"		ii. Accept "..cq("The Night Watch part 2"),
			completion={{questturnedin="The Night Watch part 1"},{questaccepted="The Night Watch part 2"}},
			mapzone="Duskwood",
			level=28,
			mapnote=46812030,
		}, {
			"Go to "..cl(76,48),
			"	a. Talk to Calor",
			"		i. Turn in "..cq("Worgen in the Woods part 3"),
			"		ii. Accept "..cq("Worgen in the Woods part 4"),
			completion={{questturnedin="Worgen in the Woods part 3"},{questaccepted="Worgen in the Woods part 4"}},
			mapzone="Duskwood",
			level=28,
			mapnote=47612330,
		}, {
			"Go to "..cl(75,49),
			"	a. Talk to Jonathan Carevin",
			"		i. Turn in "..cq("Worgen in the Woods part 4"),
			completion={{questturnedin="Worgen in the Woods part 4"}},
			mapzone="Duskwood",
			level=28,
			mapnote=48712400,
		}, {
			"Go to "..cl(80,48),
			"	a. Talk to Viktori Prism'Antras",
			"		i. Turn in "..cq("Look To The Stars part 3"),
			"		ii. Accept "..cq("Look To The Stars part 4"),
			completion={{questturnedin="Look To The Stars part 3"},{questaccepted="Look To The Stars part 4"}},
			mapzone="Duskwood",
			level=28,
			mapnote=48112790,
		}, {
			"Grind to level 29",
			completion={{level=29}},
			mapzone="Duskwood",
			level=28,
		}, {
			"Go southwest to "..cl(36,81),
			"	a. Kill Zzarc'Vul",
			"	b. Get the Ogre's Monocle",
			completion={{questgoal={"*","Ogre's Monocle",1}}},
			mapzone="Duskwood",
			level=29,
			mapnote=80611670,
		}, {
			"Go northwest to "..cl(18,57),
			"	a. Talk to Jitters",
			"		i. Turn in "..cq("Raven Hill"),
			completion={{questturnedin="Raven Hill"}},
			mapzone="Duskwood",
			level=29,
			mapnote=56607480,
		}, {
			"Go north to "..cl(18,47),
			"	a. Kill 15 Skeletal Fiends",
			"	b. Kill 15 Skeletal Horrors",
			completion={{questgoal={"*","Skeletal Fiend slain",15}},{questgoal={"*","Skeletal Horror slain",15}}},
			mapzone="Duskwood",
			level=29,
			mapnote=47206480,
		}, {
			"Go east to "..cl(27,46),
			"	a. Kill Black Widow Hatchings",
			"	b. Get 5 Vials of Spider Venom",
			completion={{questgoal={"*","Vial of Spider Venom",5}}},
			mapzone="Duskwood",
			level=29,
			mapnote=45907310,
		}, {
			"Go to northwest to "..cl(23,39),
			"	a. Kill ghouls",
			"	b. Get 10 Ghoul Fangs",
			completion={{questgoal={"*","Ghoul Fang",10}}},
			mapzone="Duskwood",
			level=29,
			mapnote=39106260,
		}, {
			"Go northeast to "..cl(28,32),
			"	a. Talk to Abercrombie",
			"		i. Turn in "..cq("The Hermit"),
			"		ii. Accept "..cq("Supplies from Darkshire"),
			completion={{questturnedin="The Hermit"},{questaccepted="Supplies from Darkshire"}},
			mapzone="Duskwood",
			level=29,
			mapnote=31505950,
		}, {
			"Go northwest to "..cl(18,29),
			"	a. Click the Weathered Grave",
			"		i. Accept "..cq("The Weathered Grave"),
			completion={{questaccepted="The Weathered Grave"}},
			mapzone="Duskwood",
			level=29,
			mapnote=29004670,
		}, {
			"Go southwest to "..cl(8,34),
			"	a. Talk to Sven Yorgen",
			"		i. Turn in "..cq("Deliveries to Sven"),
			"		ii. Accept "..cq("Sven's Revenge"),
			completion={{questturnedin="Deliveries to Sven"},{questaccepted="Sven's Revenge"}},
			mapzone="Duskwood",
			level=29,
			mapnote=34204200,
		}, {
			"Hearth to Darkshire",
			completion={{location={mapzone="Duskwood",x=74.7,y=46.9, dist=7}}},
			mapzone="Duskwood",
			level=29,
		}, {
			"Go to "..cl(74,47),
			"	a. Talk to Commander Althea Ebonlocke",
			"		i. Turn in "..cq("The Night Watch part 2"),
			"		ii. Accept "..cq("The Night Watch part 3"),
			completion={{questturnedin="The Night Watch part 2"},{questaccepted="The Night Watch part 3"}},
			mapzone="Duskwood",
			level=29,
			mapnote=46812030,
		}, {
			"Go to "..cl(73,48),
			"	a. Talk to Sirra Von'Indi",
			"		i. Turn in "..cq("The Weathered Grave"),
			"		ii. Accept "..cq("Morgan Ladimore"),
			completion={{questturnedin="The Weathered Grave"},{questaccepted="Morgan Ladimore"}},
			mapzone="Duskwood",
			level=29,
			mapnote=47712030,
		}, {
			"Go to "..cl(74,47),
			"	a. Talk to Commander Althea Ebonlocke",
			"		i. Turn in "..cq("Morgan Ladimore"),
			completion={{questturnedin="Morgan Ladimore"}},
			mapzone="Duskwood",
			level=29,
			mapnote=46812030,
		}, {
			"Go to "..cl(76,45),
			"	a. Talk to Madame Eva",
			"		i. Turn in "..cq("The Totem of Infliction"),
			"		ii. Turn in "..cq("Supplies from Darkshire"),
			"		iii. Accept "..cq("Ghost Hair Thread"),
			completion={{questturnedin="The Totem of Infliction"},{questturnedin="Supplies from Darkshire"},{questaccepted="Ghost Hair Thread"}},
			mapzone="Duskwood",
			level=29,
			mapnote=45312110,
		}, {
			"Go to "..cl(80,48),
			"	a. Talk to Viktori Prism'Antras",
			"		i. Turn in "..cq("Look To The Stars part 4"),
			completion={{questturnedin="Look To The Stars part 4"}},
			mapzone="Duskwood",
			level=29,
			mapnote=48112790,
		}, {
			"Go to southeast to "..cl(82,59),
			"	a. Talk to Blind Mary",
			"		i. Turn in "..cq("Ghost Hair Thread"),
			"		ii. Accept "..cq("Return the Comb"),
			completion={{questturnedin="Ghost Hair Thread"},{questaccepted="Return the Comb"}},
			mapzone="Duskwood",
			level=29,
			mapnote=59214110,
		}, {
			"Go northwest to "..cl(76,45),
			"	a. Talk to Madame Eva",
			"		i. Turn in "..cq("Return the Comb"),
			"		ii. Accept "..cq("Deliver the Thread"),
			completion={{questturnedin="Return the Comb"},{questaccepted="Deliver the Thread"}},
			mapzone="Duskwood",
			level=29,
			mapnote=45312110,
		}, {
			"Go southwest to "..cl(50,78),
			"	a. Click the Mound of Loose Dirst",
			"		i. Turn in "..cq("Sven's Revenge"),
			"		ii. Accept "..cq("Sven's Camp"),
			completion={{questturnedin="Sven's Revenge"},{questaccepted="Sven's Camp"}},
			mapzone="Duskwood",
			level=29,
			mapnote=77712760,
		}, {
			"Go northwest to "..cl(28,32),
			"	a. Talk to Abercrombie",
			"		i. Turn in "..cq("Deliver the Thread"),
			"		ii. Accept "..cq("Zombie Juice"),
			completion={{questturnedin="Deliver the Thread"},{questaccepted="Zombie Juice"}},
			mapzone="Duskwood",
			level=29,
			mapnote=31505950,
		}, {
			"Go southwest to "..cl(24,33),
			"	a. Kill 20 Plague Spreaders",
			completion={{questgoal={"*","Plague Spreader slain",20}}},
			mapzone="Duskwood",
			level=29,
			mapnote=32705680,
		}, {
			"Go west to "..cl(8,34),
			"	a. Talk to Sven Yorgen",
			"		i. Turn in "..cq("Sven's Camp"),
			"		ii. Accept "..cq("The Shadowy Figure"),
			completion={{questturnedin="Sven's Camp"},{questaccepted="The Shadowy Figure"}},
			mapzone="Duskwood",
			level=29,
			mapnote=34204200,
		}, {
			"Grind to level 30",
			completion={{level=30}},
			mapzone="Duskwood",
			level=29,
		}
	  },
	},	  
	{ sectiontitle = "Levels (30-35)",
	  steps = {
		{
			"Hearth to Darkshire",
			completion={{location={mapzone="Duskwood",x=74.7,y=46.9, dist=7}}},
			mapzone="Duskwood",
			level=30,
		}, {
			"Go to "..cl(74,45),
			"	a. Talk to Tavernkeep Smitts",
			"		i. Turn in "..cq("Zombie Juice"),
			completion={{questturnedin="Zombie Juice"}},
			mapzone="Duskwood",
			level=30,
			mapnote=44711880,
		}, {
			"Go to "..cl(74,47),
			"	a. Talk to Commander Althea Ebonlocke",
			"		i. Turn in "..cq("The Night Watch part 3"),
			completion={{questturnedin="The Night Watch part 3"}},
			mapzone="Duskwood",
			level=30,
			mapnote=46812030,
		}, {
			"Go to "..cl(76,45),
			"	a. Talk to Madame Eva",
			"		i. Turn in "..cq("The Shadowy Figure"),
			"		ii. Accept "..cq("The Shadowy Search Continues"),
			completion={{questturnedin="The Shadowy Figure"},{questaccepted="The Shadowy Search Continues"}},
			mapzone="Duskwood",
			level=30,
			mapnote=45312110,
		}, {
			"Go to "..cl(73,47),
			"	a. Talk to Clerk Daltry",
			"		i. Turn in "..cq("The Shadowy Search Continues"),
			"		ii. Accept "..cq("Inquire at the Inn"),
			completion={{questturnedin="The Shadowy Search Continues"},{questaccepted="Inquire at the Inn"}},
			mapzone="Duskwood",
			level=30,
			mapnote=46811930,
		}, {
			"Go to "..cl(74,45),
			"	a. Talk to Tavernkeep Smitts",
			"		i. Turn in "..cq("Inquire at the Inn"),
			completion={{questturnedin="Inquire at the Inn"}},
			mapzone="Duskwood",
			level=30,
			mapnote=44711880,
		}, {
			"Fly to Menethil Harbor",
			completion={{location={mapzone="Wetlands",x=10.1,y=56.7, dist=9}}},
			mapzone="Duskwood",
			level=30,
		}, {
			"Ride the boat to Auberdine",
			completion={{location={mapzone="Darkshore",x=32.8,y=42.0, dist=9}}},
			mapzone="Wetlands",
			level=30,
		}, {
			"Fly to Astranaar",
			completion={{location={mapzone="Ashenvale",x=35.5,y=50.2, dist=5}}},
			mapzone="Darkshore",
			level=30,
		}, {
			"Make Astranaar your home",
			completion={{home="Astranaar"}},
			mapzone="Ashenvale",
			level=30,
		}, {
			"Go northeast to "..cl(55,33),
			"	a. Kill tree elementals",
			"	b. Get the Wooden Key",
			completion={{questgoal={"*","Wooden Key",1}}},
			mapzone="Ashenvale",
			level=30,
			mapnote=33108820,
		}, {
			"Go south to "..cl(54,35),
			"	a. Open the small chest",
			"	b. Get the Iron Shaft",
			completion={{questgoal={"*","Iron Shaft",1}}},
			mapzone="Ashenvale",
			level=30,
			mapnote=35408980,
		}, {
			"Go south to "..cl(54,46),
			"	a. Talk to Shael'dryn",
			"		i. Turn in "..cq("Raene's Cleansing part 4"),
			"		ii. Accept "..cq("Raene's Cleansing part 5"),
			completion={{questturnedin="Raene's Cleansing part 4"},{questaccepted="Raene's Cleansing part 5"}},
			mapzone="Ashenvale",
			level=30,
			mapnote=46309980,
		}, {
			"Go east to Forest Song",
			completion={{location={mapzone="Ashenvale",x=85.5,y=45.2, dist=6}}},
			mapzone="Ashenvale",
			level=30,
		}, {
			"Go to "..cl(86,46),
			"	a. Talk to Gnarl",
			"		i. Accept "..cq("Reclaiming Felfire Hill"),
			completion={{questaccepted="Reclaiming Felfire Hill"}},
			mapzone="Ashenvale",
			level=30,
			mapnote=46513290,
		}, {
			"Go to "..cl(87,45),
			"	a. Talk to Architect Nemos",
			"		i. Accept "..cq("A Shameful Waste"),
			completion={{questturnedin="A Helping Hand"},{questaccepted="A Shameful Waste"}},
			mapzone="Ashenvale",
			level=30,
			mapnote=44813160,
		}, {
			"Go to "..cl(87,43),
			"	a. Talk to Illiyana",
			"		i. Accept "..cq("Vile Satyr! Dryads in Danger!"),
			completion={{questaccepted="Vile Satyr! Dryads in Danger!"}},
			mapzone="Ashenvale",
			level=30,
			mapnote=43513060,
		}, {
			"Go to "..cl(87,44),
			"	a. Talk to Vindicator Vedaar",
			"		i. Accept "..cq("Destroy the Legion"),
			completion={{questaccepted="Destroy the Legion"}},
			mapzone="Ashenvale",
			level=30,
			mapnote=43613010,
		}, {
			"Go to "..cl(86,44),
			"	a. Talk to Sentinel Melyria Frostshadow",
			"		i. Accept "..cq("The Howling Vale"),
			"	b. Talk to Sentinel Luciel Starwhisper",
			"		i. Accept "..cq("Report from the Northern Front"),
			"		ii. Accept "..cq("Agents of Destruction"),
			completion={{questaccepted="The Howling Vale"},{questaccepted="Report from the Northern Front"},{questaccepted="Agents of Destruction"}},
			mapzone="Ashenvale",
			level=30,
			mapnote=44113010,
		}, {
			"Go to "..cl(85,45),
			"	a. Talk to Kayneth Stillwind",
			"		i. Turn in "..cq("Kayneth Stillwind"),
			"		ii. Accept "..cq("Forsaken Diseases"),
			"		iii. Accept "..cq("The Lost Chalice"),
			completion={{questturnedin="Kayneth Stillwind"},{questaccepted="Forsaken Diseases"},{questaccepted="The Lost Chalice"}},
			mapzone="Ashenvale",
			level=30,
			mapnote=44712990,
		}, {
			"Go to "..cl(85,43),
			"	a. Talk to Suralais Farwind",
			"		i. Get the Forest Song Flight Path",
			completion={{flightpath="Forest Song"}},
			mapzone="Ashenvale",
			level=30,
			mapnote=43912860,
		}, {
			"Go west to "..cl(78,45),
			"	a. Talk to Anilia",
			"		i. Turn in "..cq("Vile Satyr! Dryads in Danger!"),
			"		ii. Accept "..cq("The Branch of Cenarius"),
			completion={{questturnedin="Vile Satyr! Dryads in Danger!"},{questaccepted="The Branch of Cenarius"}},
			mapzone="Ashenvale",
			level=30,
			mapnote=44812310,
		}, {
			"Go north to "..cl(78,43),
			"	a. Kill Geltharis",
			"	b. Get the Branch of Cenarius",
			completion={{questgoal={"*","Branch of Cenarius",1}}},
			mapzone="Ashenvale",
			level=30,
			mapnote=42612060,
		}, {
			"Go south to "..cl(80,49),
			"	a. Click the Tainted Wood bundles",
			"	b. Get 5 Satyrnaar Fel Wood",
			completion={{questgoal={"*","Satyrnaar Fel Wood",5}}},
			mapzone="Ashenvale",
			level=30,
			mapnote=49112940,
		}, {
			"Go east to "..cl(81,49),
			"	a. Click the Chalice of Elune",
			"	b. Get the Chalice of Elune",
			completion={{questgoal={"*","Chalice of Elune",1}}},
			mapzone="Ashenvale",
			level=30,
			mapnote=49113040,
		}, {
			"Go southeast to "..cl(86,53),
			"	a. Click the Lumber Piles",
			"	b. Get 15 Warsong Lumber",
			"	c. Kill 2 Warsong Shredders",
			"	d. Kill 5 Horde Deforesters",
			"	e. Kill 10 Horde Scouts",
			completion={{questgoal={"*","Warsong Lumber",15}},{questgoal={"*","Warsong Shredder slain",2}},{questgoal={"*","Horde Deforester slain",5}},{questgoal={"*","Horde Scout slain",10}}},
			mapzone="Ashenvale",
			level=30,
			mapnote=52913930,
		}, {
			"Go southeast to "..cl(89,60),
			"	a. Kill Overseer Gorthak",
			completion={{questgoal={"*","Overseer Gorthak slain",1}}},
			mapzone="Ashenvale",
			level=30,
			mapnote=59514830,
		}, {
			"Go southwest to "..cl(84,68),
			"	a. Kill 6 Mannoroc Lashers",
			"	b. Kill 6 Roaming Felguards",
			"	c. Kill 6 Searing Infernals",
			"	d. Click the Fertile Dirt Mounds",
			"	e. Plant 8 Tree Seedlings",
			completion={{questgoal={"*","Tree Seedling Planted",8}},{questgoal={"*","Mannoroc Lasher slain",6}},{questgoal={"*","Roaming Felguard slain",6}},{questgoal={"*","Searing Infernal slain",6}}},
			mapzone="Ashenvale",
			level=30,
			mapnote=67715150,
		}, {
			"Go southwest to "..cl(75,72),
			"	a. Click the Bottle of Disease on the table",
			"	b. Get a Bottle of Disease",
			completion={{questgoal={"*","Bottle of Disease",1}}},
			mapzone="Ashenvale",
			level=30,
			mapnote=72314760,
		}, {
			"Go southwest to "..cl(74,74),
			"	a. Kill Rotting Slimes until a Rusty Chest appears",
			"	b. Click the Rusty Chest",
			"	c. Get the Iron Pommel",
			completion={{questgoal={"*","Iron Pommel",1}}},
			mapzone="Ashenvale",
			level=30,
			mapnote=73614770,
		}, {
			"Go southwest to "..cl(67,82),
			"	a. Kill the Shadethicket Oracle",
			"	b. Get the Fallen Moonstone",
			completion={{questgoal={"*","Fallen Moonstone",1}}},
			mapzone="Ashenvale",
			level=30,
			mapnote=82214890,
		}, {
			"Go southwest to "..cl(62,84),
			"	a. Talk to Sentinel Farsong",
			"		i. Turn in "..cq("Report from the Northern Front"),
			completion={{questturnedin="Report from the Northern Front"}},
			mapzone="Ashenvale",
			level=30,
			mapnote=83914580,
		}, {
			"Go northwest to "..cl(53,33),
			"	a. The path up to 'The Howling Vale' starts here",
			completion={{location={mapzone="Ashenvale",x=53.4,y=33.2, dist=0.5}}},
			mapzone="Ashenvale",
			level=30,
			mapnote=33108650,
		}, {
			"Go southwest to "..cl(51,39),
			"	a. Click the Tome of Mel'Thandris",
			"	b. View the Tome of Mel'Thandris",
			completion={{questgoal={"*","View the Tome of Mel'Thandris",1}}},
			mapzone="Ashenvale",
			level=30,
			mapnote=39108960,
		}, {
			"Grind to level 31",
			completion={{level=31}},
			mapzone="Ashenvale",
			level=30,
		}, {
			"Go east to Forest Song",
			completion={{location={mapzone="Ashenvale",x=85.5,y=45.2, dist=6}}},
			mapzone="Ashenvale",
			level=31,
		}, {
			"Go to "..cl(86,46),
			"	a. Talk to Gnarl",
			"		i. Turn in "..cq("A Shameful Waste"),
			"		ii. Turn in "..cq("Reclaiming Felfire Hill"),
			completion={{questturnedin="A Shameful Waste"},{questturnedin="Reclaiming Felfire Hill"}},
			mapzone="Ashenvale",
			level=31,
			mapnote=46513290,
		}, {
			"Go to "..cl(87,43),
			"	a. Talk to Illiyana",
			"		i. Turn in "..cq("The Branch of Cenarius"),
			"		ii. Accept "..cq("Satyr Slaying!"),
			completion={{questturnedin="The Branch of Cenarius"},{questaccepted="Satyr Slaying!"}},
			mapzone="Ashenvale",
			level=31,
			mapnote=43513060,
		}, {
			"Go to "..cl(87,44),
			"	a. Talk to Vindicator Vedaar",
			"		i. Turn in "..cq("Destroy the Legion"),
			completion={{questturnedin="Destroy the Legion"}},
			mapzone="Ashenvale",
			level=31,
			mapnote=43613010,
		}, {
			"Go to "..cl(86,44),
			"	a. Talk to Sentinel Melyria Frostshadow",
			"		i. Turn in "..cq("The Howling Vale"),
			"		ii. Accept "..cq("Velinde Starsong"),
			"	b. Talk to Sentinel Luciel Starwhisper",
			"		i. Turn in "..cq("Agents of Destruction"),
			completion={{questturnedin="The Howling Vale"},{questaccepted="Velinde Starsong"},{questturnedin="Agents of Destruction"}},
			mapzone="Ashenvale",
			level=31,
			mapnote=44113010,
		}, {
			"Go to "..cl(85,44),
			"	a. Talk to Kayneth Stillwind",
			"		i. Turn in "..cq("Forsaken Diseases"),
			"		ii. Turn in "..cq("The Lost Chalice"),
			completion={{questturnedin="Forsaken Diseases"},{questturnedin="The Lost Chalice"}},
			mapzone="Ashenvale",
			level=31,
			mapnote=44712990,
		}, {
			"Go west to "..cl(79,46),
			"	a. Kill Satyrs",
			"	b. Get 16 Satyr Horns",
			completion={{questgoal={"*","Satyr Horns",16}}},
			mapzone="Ashenvale",
			level=31,
			mapnote=46212520,
		}, {
			"Go east to Forest Song",
			completion={{location={mapzone="Ashenvale",x=85.5,y=45.2, dist=6}}},
			mapzone="Ashenvale",
			level=31,
		}, {
			"Go to "..cl(87,43),
			"	a. Talk to Illiyana",
			"		i. Turn in "..cq("Satyr Slaying!"),
			completion={{questturnedin="Satyr Slaying!"}},
			mapzone="Ashenvale",
			level=31,
			mapnote=43513060,
		}, {
			"Go east to Azshara",
			completion={{location={mapzone="Azshara"}}},
			mapzone="Ashenvale",
			level=31,
		}, {
			"Go southeast to "..cl(12,78),
			"	a. Talk to Jarrodenus",
			"		i. Get the Talrendis Point Flight Path",
			completion={{flightpath="Talrendis Point"}},
			mapzone="Azshara",
			level=31,
			mapnote=77608950,
		}, {
			"Fly to Astranaar",
			completion={{location={mapzone="Ashenvale",x=35.5,y=50.2, dist=5}}},
			mapzone="Azshara",
			level=31,
		}, {
			"Go to "..cl(37,52),
			"	a. Talk to Pelturas Whitemoon",
			"		i. Turn in "..cq("Fallen Sky Lake"),
			completion={{questturnedin="Fallen Sky Lake"}},
			mapzone="Ashenvale",
			level=31,
			mapnote=51808920,
		}, {
			"Go northeast to "..cl(54,46),
			"	a. Talk to Shael'dryn",
			"		i. Turn in "..cq("Raene's Cleansing part 5"),
			"		ii. Accept "..cq("Raene's Cleansing part 6"),
			completion={{questturnedin="Raene's Cleansing part 5"},{questaccepted="Raene's Cleansing part 6"}},
			mapzone="Ashenvale",
			level=31,
			mapnote=46309980,
		}, {
			"Go southeast to "..cl(56,51),
			"	a. The path up to 'Raene's Cleansing part 6' starts here",
			completion={{location={mapzone="Ashenvale",x=56.0,y=51.4, dist=0.5}}},
			mapzone="Ashenvale",
			level=31,
			mapnote=51410750,
		}, {
			"Go north to "..cl(56,49),
			"	a. Click the Hidden Shrine",
			"		i. Turn in "..cq("Raene's Cleansing part 6"),
			"		ii. Accept "..cq("Raene's Cleansing part 7"),
			completion={{questturnedin="Raene's Cleansing part 6"},{questaccepted="Raene's Cleansing part 7"}},
			mapzone="Ashenvale",
			level=31,
			mapnote=49210560,
		}, {
			"Go northwest to "..cl(54,46),
			"	a. Talk to Shael'dryn",
			"		i. Turn in "..cq("Raene's Cleansing part 7"),
			"		ii. Accept "..cq("Raene's Cleansing part 8"),
			completion={{questturnedin="Raene's Cleansing part 7"},{questaccepted="Raene's Cleansing part 8"}},
			mapzone="Ashenvale",
			level=31,
			mapnote=46309980,
		}, {
			"Hearth to Astranaar",
			completion={{location={mapzone="Ashenvale",x=35.5,y=50.2, dist=5}}},
			mapzone="Ashenvale",
			level=31,
		}, {
			"Go to "..cl(37,50),
			"	a. Talk to Raene Wolfrunner",
			"		i. Turn in 'Raene's Cleansing' part 8",
			completion={{questturnedin="Raene's Cleansing part 8"}},
			mapzone="Ashenvale",
			level=31,
			mapnote=49608620,
		}, {
			"Fly to Auberdine",
			completion={{location={mapzone="Darkshore",x=38.1,y=43.1, dist=9}}},
			mapzone="Ashenvale",
			level=31,
		}, {
			"Ride the boat to Rut'theran Village",
			completion={{location={mapzone="Teldrassil",x=56.3,y=92.4, dist=6}}},
			mapzone="Darkshore",
			level=31,
		}, {
			"Go to "..cl(58,94),
			"	a. Talk to Vesprystus",
			"		i. Get the Rut'theran Village Flight Path",
			completion={{flightpath="Rut'theran Village"}},
			mapzone="Teldrassil",
			level=31,
			mapnote=94015240,
		}, {
			"Go through the big pink portal to Darnassus",
			completion={{location={mapzone="Darnassus"}}},
			mapzone="Teldrassil",
			level=31,
		}, {
			"Go to "..cl(62,39),
			"	a. Talk to Thyn'tel Bladeweaver",
			"		i. Turn in "..cq("Velinde Starsong"),
			"		ii. Accept "..cq("Velinde's Effects"),
			completion={{questturnedin="Velinde Starsong"},{questaccepted="Velinde's Effects"}},
			mapzone="Darnassus",
			level=31,
			mapnote=39210100,
		}, {
			"Go to "..cl(62,38),
			"	a. Click Velinde's Locker",
			"	b. Get Velinde's Journal",
			completion={{questgoal={"*","Velinde's Journal",1}}},
			mapzone="Darnassus",
			level=31,
			mapnote=83314560,
		}, {
			"Go to "..cl(62,39),
			"	a. Talk to Thyn'tel Bladeweaver",
			"		i. Turn in "..cq("Velinde's Effects"),
			completion={{questturnedin="Velinde's Effects"}},
			mapzone="Darnassus",
			level=31,
			mapnote=39210100,
		}, {
			"Go to Rut'theran Village",
			completion={{location={mapzone="Teldrassil",x=56.3,y=92.4, dist=6}}},
			mapzone="Darnassus",
			level=31,
		}, {
			"Fly to Auberdine",
			completion={{location={mapzone="Darkshore",x=38.1,y=43.1, dist=9}}},
			mapzone="Teldrassil",
			level=31,
		}, {
			"Ride the boat to Menethil Harbor",
			completion={{location={mapzone="Wetlands",x=4.6,y=56.8, dist=9}}},
			mapzone="Darkshore",
			level=31,
		}, {
			"Make Menethil Harbor your home",
			completion={{home="Menethil Harbor"}},
			mapzone="Wetlands",
			level=31,
		}, {
			"Go east to "..cl(47,47),
			"	a. Click the Dragonmaw Catapult",
			"		i. Turn in "..cq("Nek'rosh's Gambit"),
			"		ii. Accept "..cq("Defeat Nek'rosh"),
			completion={{questturnedin="Nek'rosh's Gambit"},{questaccepted="Defeat Nek'rosh"}},
			mapzone="Wetlands",
			level=31,
			mapnote=46909440,
		}, {
			"Grind to level 32",
			completion={{level=32}},
			mapzone="Wetlands",
			level=31,
		}, {
			"Go southeast to "..cl(53,57),
			"	a. Kill Chieftain Nek'rosh",
			"	b. Get Nek'rosh's Head",
			completion={{questgoal={"*","Nek'rosh's Head",1}}},
			mapzone="Wetlands",
			level=32,
			mapnote=54710820,
		}, {
			"Hearth to Menethil Harbor",
			completion={{location={mapzone="Wetlands",x=10.1,y=56.7, dist=9}}},
			mapzone="Wetlands",
			level=32,
		}, {
			"Go to "..cl(11,56),
			"	a. Talk to Harlo Barnaby",
			"		i. Accept "..cq("Fall of Dun Modr"),
			completion={{questaccepted="Fall of Dun Modr"}},
			mapzone="Wetlands",
			level=32,
			mapnote=55906670,
		}, {
			"Go to "..cl(10,58),
			"	a. Talk to Captain Stoutfist",
			"		i. Turn in "..cq("Defeat Nek'rosh"),
			completion={{questturnedin="Defeat Nek'rosh"}},
			mapzone="Wetlands",
			level=32,
			mapnote=57506740,
		}, {
			"Go northeast to "..cl(50,18),
			"	a. Talk to Longbraid the Grim",
			"		i. Turn in "..cq("Fall of Dun Modr"),
			"	b. Talk to Rhag Garmason",
			"		i. Accept "..cq("The Thandol Span part 1"),
			completion={{questturnedin="Fall of Dun Modr"},{questaccepted="The Thandol Span part 1"}},
			mapzone="Wetlands",
			level=32,
			mapnote=18306810,
		}, {
			"Go north to 51,8",
			"	a. Click Ebenezer Rustlocke's Corpse",
			"		i. Turn in "..cq("The Thandol Span part 1"),
			"		ii. Accept "..cq("The Thandol Span part 2"),
			completion={{questturnedin="The Thandol Span part 1"},{questaccepted="The Thandol Span part 2"}},
			mapzone="Wetlands",
			level=32,
			mapnote=8005930,
		}, {
			"Go south to "..cl(50,18),
			"	a. Talk to Rhag Garmason",
			"		i. Turn in "..cq("The Thandol Span part 2"),
			"		ii. Accept "..cq("The Thandol Span part 3"),
			completion={{questturnedin="The Thandol Span part 2"},{questaccepted="The Thandol Span part 3"}},
			mapzone="Wetlands",
			level=32,
			mapnote=18306810,
		}, {
			"Go north to the Arathi Highlands",
			completion={{location={mapzone="Arathi Highlands"}}},
			mapzone="Wetlands",
			level=32,
		}, {
			"Go east to "..cl(49,88),
			"	a. Click the Cache of Explosives",
			"	b. Destroy the Cache of Explosives",
			completion={{questgoal={"*","Cache of Explosives Destroyed",1}}},
			mapzone="Arathi Highlands",
			level=32,
			mapnote=88113690,
		}, {
			"Go south to the Wetlands",
			completion={{location={mapzone="Wetlands"}}},
			mapzone="Arathi Highlands",
			level=32,
		}, {
			"Go south to "..cl(50,18),
			"	a. Talk to Rhag Garmason",
			"		i. Turn in "..cq("The Thandol Span part 3"),
			"		ii. Accept "..cq("Plea To The Alliance"),
			completion={{questturnedin="The Thandol Span part 3"},{questaccepted="Plea To The Alliance"}},
			mapzone="Wetlands",
			level=32,
			mapnote=18306810,
		}, {
			"Go north to the Arathi Highlands",
			completion={{location={mapzone="Arathi Highlands"}}},
			mapzone="Wetlands",
			level=32,
		}, {
			"Go north to "..cl(46,48),
			"	a. Talk to Captain Nials",
			"		i. Turn in "..cq("Plea To The Alliance"),
			"		ii. Accept "..cq("Northfold Manor"),
			completion={{questturnedin="Plea To The Alliance"},{questaccepted="Northfold Manor"}},
			mapzone="Arathi Highlands",
			level=32,
			mapnote=47609340,
		}, {
			"Go to "..cl(46,46),
			"	a. Talk to Cedrik Prose",
			"		i. Get the Refuge Point Flight Path",
			completion={{flightpath="Refuge Point"}},
			mapzone="Arathi Highlands",
			level=32,
			mapnote=46109190,
		}, {
			"Go northwest to the Hillsbrad Foothills",
			completion={{location={mapzone="Hillsbrad Foothills"}}},
			mapzone="Arathi Highlands",
			level=32,
		}, {
			"Go west to "..cl(49,52),
			"	a. Talk to Darla Harris",
			"		i. Get the Southshore Flight Path",
			completion={{flightpath="Southshore"}},
			mapzone="Hillsbrad Foothills",
			level=32,
			mapnote=52310160,
		}, {
			"Go to "..cl(49,59),
			"	a. Talk to Marshal Redpath",
			"		i. Accept "..cq("Crushridge Bounty"),
			completion={{questaccepted="Crushridge Bounty"}},
			mapzone="Hillsbrad Foothills",
			level=32,
			mapnote=58710820,
		}, {
			"Go to "..cl(48,59),
			"	a. Talk to Magistrate Henry Maleb",
			"		i. Accept "..cq("Syndicate Assassins"),
			completion={{questaccepted="Syndicate Assassins"}},
			mapzone="Hillsbrad Foothills",
			level=32,
			mapnote=59110720,
		}, {
			"Go to "..cl(50,59),
			"	a. Talk to Phin Odelic",
			"		i. Accept "..cq("Hints of a New Plague? part 1"),
			completion={{questaccepted="Hints of a New Plague? part 1"}},
			mapzone="Hillsbrad Foothills",
			level=32,
			mapnote=59010930,
		}, {
			"Go to "..cl(51,59),
			"	a. Talk to Huraan",
			"		i. Accept "..cq("Missing Crystals"),
			completion={{questaccepted="Missing Crystals"}},
			mapzone="Hillsbrad Foothills",
			level=32,
			mapnote=58710970,
		}, {
			"Go to "..cl(51,58),
			"	a. Talk to Lieutenant Farren Orinelle",
			"		i. Accept "..cq("Down the Coast"),
			completion={{questaccepted="Down the Coast"}},
			mapzone="Hillsbrad Foothills",
			level=32,
			mapnote=58410990,
		}, {
			"Make Southshore your home",
			completion={{home="Southshore"}},
			mapzone="Hillsbrad Foothills",
			level=32,
		}, {
			"Go to "..cl(52,56),
			"	a. Talk to Darren Malvew",
			"		i. Accept "..cq("Costly Menace"),
			completion={{questaccepted="Costly Menace"}},
			mapzone="Hillsbrad Foothills",
			level=32,
			mapnote=56010840,
		}, {
			"Go southwest to "..cl(46,64),
			"	a. Kill 10 Torn Fin Tidehunters",
			"	b. Kill 10 Torn Fin Oracles",
			completion={{questgoal={"*","Torn Fin Tidehunter slain",10}},{questgoal={"*","Torn Fin Oracle slain",10}}},
			mapzone="Hillsbrad Foothills",
			level=32,
			mapnote=64011040,
		}, {
			"Go northeast to "..cl(51,58),
			"	a. Talk to Lieutenant Farren Orinelle",
			"		i. Turn in "..cq("Down the Coast"),
			"		ii. Accept "..cq("Farren's Proof part 1"),
			completion={{questturnedin="Down the Coast"},{questaccepted="Farren's Proof part 1"}},
			mapzone="Hillsbrad Foothills",
			level=32,
			mapnote=58410990,
		}, {
			"Go southwest to "..cl(46,64),
			"	a. Kill murlocs",
			"	b. Get 10 Murloc Heads",
			completion={{questgoal={"*","Murloc Head",10}}},
			mapzone="Hillsbrad Foothills",
			level=32,
			mapnote=64011040,
		}, {
			"Go northeast to "..cl(51,58),
			"	a. Talk to Lieutenant Farren Orinelle",
			"		i. Turn in "..cq("Farren's Proof part 1"),
			"		ii. Accept "..cq("Farren's Proof part 2"),
			completion={{questturnedin="Farren's Proof part 1"},{questaccepted="Farren's Proof part 2"}},
			mapzone="Hillsbrad Foothills",
			level=32,
			mapnote=58410990,
		}, {
			"Go to "..cl(49,59),
			"	a. Talk to Marshal Redpath",
			"		i. Turn in "..cq("Farren's Proof part 2"),
			"		ii. Accept "..cq("Farren's Proof part 3"),
			completion={{questturnedin="Farren's Proof part 2"},{questaccepted="Farren's Proof part 3"}},
			mapzone="Hillsbrad Foothills",
			level=32,
			mapnote=58710820,
		}, {
			"Go to "..cl(51,58),
			"	a. Talk to Lieutenant Farren Orinelle",
			"		i. Turn in "..cq("Farren's Proof part 3"),
			"		ii. Accept "..cq("Stormwind Ho!"),
			completion={{questturnedin="Farren's Proof part 3"},{questaccepted="Stormwind Ho!"}},
			mapzone="Hillsbrad Foothills",
			level=32,
			mapnote=58410990,
		}, {
			"Go southeast to "..cl(56,65),
			"	a. Kill 10 Daggerspine Shorehunters",
			"	b. Kill 10 Daggerspine Sirens",
			completion={{questgoal={"*","Daggerspine Shorehunter slain",10}},{questgoal={"*","Daggerspine Siren slain",10}}},
			mapzone="Hillsbrad Foothills",
			level=32,
			mapnote=65012120,
		}, {
			"Go northwest to "..cl(51,58),
			"	a. Talk to Lieutenant Farren Orinelle",
			"		i. Turn in "..cq("Stormwind Ho!"),
			"		ii. Accept "..cq("Reassignment"),
			completion={{questturnedin="Stormwind Ho!"},{questaccepted="Reassignment"}},
			mapzone="Hillsbrad Foothills",
			level=32,
			mapnote=58410990,
		}, {
			"Go northeast to "..cl(56,35),
			"	a. Click the Unopened Crate",
			"	b. Get the Shipment of Rare Crystals",
			completion={{questgoal={"*","Shipment of Rare Crystals",1}}},
			mapzone="Hillsbrad Foothills",
			level=32,
			mapnote=35209080,
		}, {
			"Go north to the Alterac Mountains",
			completion={{location={mapzone="Alterac Mountains"}}},
			mapzone="Hillsbrad Foothills",
			level=32,
		}, {
			"Go northwest to "..cl(44,79),
			"	a. Kill 8 Mountain Lions",
			"	b. Kill 10 Hulking Mountain Lions",
			completion={{questgoal={"*","Mountain Lion slain",8}},{questgoal={"*","Hulking Mountain Lion slain",10}}},
			mapzone="Alterac Mountains",
			level=32,
			mapnote=78512280,
		}, {
			"Go northeast to "..cl(57,67),
			"	a. Kill 12 Syndicate Footpads",
			"	b. Kill 8 Syndicate Thieves",
			completion={{questgoal={"*","Syndicate Footpad slain",12}},{questgoal={"*","Syndicate Thief slain",8}}},
			mapzone="Alterac Mountains",
			level=32,
			mapnote=66712360,
		}, {
			"You may need help with the next step:",
			"	a. You can try to run in to the middle where the documents are on the table and try to click the documents and accept the 2 quests without fighting anyone.  I would recommend this as a last resort though.",
			mapzone="Alterac Mountains",
			level=32,
		}, {
			"Go southeast to "..cl(58,68),
			"	a. Click the Syndicate Documents",
			"		i. Accept "..cq("Foreboding Plans"),
			"		ii. Accept "..cq("Encrypted Letter"),
			completion={{questaccepted="Foreboding Plans"},{questaccepted="Encrypted Letter"}},
			mapzone="Alterac Mountains",
			level=32,
			mapnote=68012630,
		}, {
			"Grind to level 33",
			completion={{level=33}},
			mapzone="Alterac Mountains",
			level=32,
		}, {
			"Hearth to Southshore",
			completion={{location={mapzone="Hillsbrad Foothills",x=50.0,y=56.9, dist=8}}},
			mapzone="Alterac Mountains",
			level=33,
		}, {
			"Go southwest to "..cl(51,59),
			"	a. Talk to Huraan",
			"		i. Turn in "..cq("Missing Crystals"),
			completion={{questturnedin="Missing Crystals"}},
			mapzone="Hillsbrad Foothills",
			level=33,
			mapnote=58710970,
		}, {
			"Go to "..cl(51,57),
			"	a. Talk to Loremaster Dibbs",
			"		i. Turn in "..cq("Encrypted Letter"),
			"		ii. Accept "..cq("Letter to Stormpike"),
			completion={{questturnedin="Encrypted Letter"},{questaccepted="Letter to Stormpike"}},
			mapzone="Hillsbrad Foothills",
			level=33,
			mapnote=57110770,
		}, {
			"Go to "..cl(48,59),
			"	a. Talk to Magistrate Henry Maleb",
			"		i. Turn in "..cq("Syndicate Assassins"),
			"		ii. Turn in "..cq("Foreboding Plans"),
			"		iii. Accept "..cq("Noble Deaths"),
			completion={{questturnedin="Syndicate Assassins"},{questturnedin="Foreboding Plans"},{questaccepted="Noble Deaths"}},
			mapzone="Hillsbrad Foothills",
			level=33,
			mapnote=59110720,
		}, {
			"Go to "..cl(52,56),
			"	a. Talk to Darren Malvew",
			"		i. Turn in "..cq("Costly Menace"),
			completion={{questturnedin="Costly Menace"}},
			mapzone="Hillsbrad Foothills",
			level=33,
			mapnote=56010840,
		}, {
			"Fly to Refuge Point",
			completion={{location={mapzone="Arathi Highlands",x=45.6,y=46.7, dist=5}}},
			mapzone="Hillsbrad Foothills",
			level=33,
		}, {
			"Go northwest to "..cl(34,29),
			"	a. Kill 10 Syndicate Highwaymen",
			"	b. Kill 6 Syndicate Mercenaries",
			completion={{questgoal={"*","Syndicate Mercenary slain",6}},{questgoal={"*","Syndicate Highwayman slain",10}}},
			mapzone="Arathi Highlands",
			level=33,
			mapnote=29206340,
		}, {
			"Go southeast to Refuge Point",
			completion={{location={mapzone="Arathi Highlands",x=45.6,y=46.7, dist=5}}},
			mapzone="Arathi Highlands",
			level=33,
		}, {
			"Go to "..cl(46,48),
			"	a. Talk to Captain Nials",
			"		i. Turn in "..cq("Northfold Manor"),
			completion={{questturnedin="Northfold Manor"}},
			mapzone="Arathi Highlands",
			level=33,
			mapnote=47609340,
		}, {
			"Fly to Ironforge",
			completion={{location={mapzone="City of Ironforge"}}},
			mapzone="Arathi Highlands",
			level=33,
		}, {
			"Go to "..cl(73,94),
			"	a. Talk to Pilot Longbeard",
			"		i. Accept "..cq("The Brassbolts Brothers"),
			completion={{questaccepted="The Brassbolts Brothers"}},
			mapzone="Ironforge",
			level=33,
			mapnote=94016670,
		}, {
			"Go to "..cl(70,21),
			"	a. Talk to Roetten Stonehammer",
			"		i. Accept "..cq("Reclaimerss Business in Desolace"),
			completion={{questaccepted="Reclaimers' Business in Desolace"}},
			mapzone="Ironforge",
			level=33,
			mapnote=21209110,
		}, {
			"Go to "..cl(75,12),
			"	a. Talk to Prospector Stormpike",
			"		i. Turn in "..cq("Letter to Stormpike"),
			"		ii. Accept "..cq("Further Mysteries"),
			completion={{questturnedin="Letter to Stormpike"},{questaccepted="Further Mysteries"}},
			mapzone="Ironforge",
			level=33,
			mapnote=11708640,
		}, {
			"Fly to Stormwind",
			completion={{location={mapzone="Stormwind City"}}},
			mapzone="Ironforge",
			level=33,
		}, {
			"Buy 4 Lesser Bloodstone Ore from the Auction House",
			mapzone="Stormwind City",
			level=33,
		}, {
			"Go to "..cl(73,16),
			"	a. Talk to Major Samuelson",
			"		i. Turn in "..cq("Reassignment"),
			completion={{questturnedin="Reassignment"}},
			mapzone="Stormwind City",
			level=33,
			mapnote=15908850,
		}, {
			"Fly to Darkshire",
			completion={{location={mapzone="Duskwood",x=74.7,y=46.9, dist=7}}},
			mapzone="Stormwind City",
			level=33,
		}, {
			"Go southwest to Stranglethorn Vale",
			completion={{location={mapzone="Stranglethorn Vale"}}},
			mapzone="Duskwood",
			level=33,
		}, {
			"Go west to "..cl(38,4),
			"	a. Talk to Nizzle",
			"		i. Get the Rebel Camp Flight Path",
			completion={{flightpath="Rebel Camp"}},
			mapzone="Stranglethorn Vale",
			level=33,
			mapnote=4504270,
		}, {
			"Go to "..cl(38,3),
			"	a. Talk to Sergeant Yohwa",
			"		i. Accept "..cq("The Second Rebellion"),
			"		ii. Accept "..cq("Bad Medicine"),
			"	b. Talk to Corporal Kaleb",
			"		i. Accept "..cq("Krazek's Cookery"),
			completion={{questaccepted="The Second Rebellion"},{questaccepted="Bad Medicine"},{questaccepted="Krazek's Cookery"}},
			mapzone="Stranglethorn Vale",
			level=33,
			mapnote=3304130,
		}, {
			"Go southwest to "..cl(36,11),
			"	a. Talk to Barnil Stonepot",
			"		i. Accept "..cq("Welcome to the Jungle"),
			"	b. Talk to Hemet Nesingwary Jr.",
			"		i. Turn in "..cq("Welcome to the Jungle"),
			"		ii. Accept "..cq("Raptor Mastery part 1"),
			"	c. Talk to Ajeck Rouack",
			"		i. Accept "..cq("Tiger Mastery part 1"),
			"	d. Talk to Sir S. J. Erlgadin",
			"		i. Accept "..cq("Panther Mastery part 1"),
			completion={{questaccepted="Welcome to the Jungle"},{questturnedin="Welcome to the Jungle"},{questaccepted="Raptor Mastery part 1"},{questaccepted="Tiger Mastery part 1"},{questaccepted="Panther Mastery part 1"}},
			mapzone="Stranglethorn Vale",
			level=33,
			mapnote=10704650,
		}, {
			"Go east to "..cl(41,11),
			"	a. Kill 10 Young Panthers",
			completion={{questgoal={"*","Young Panther slain",10}}},
			mapzone="Stranglethorn Vale",
			level=33,
			mapnote=10905170,
		}, {
			"Go east to "..cl(44,11),
			"	a. Kill 15 Kurzen Jungle Fighters",
			"	b. Kill Kurzen Medicine Men",
			"	c. Kill Kurzen Jungle Fighters",
			"	d. Get 7 Jungle Remedies",
			completion={{questgoal={"*","Kurzen Jungle Fighter slain",15}},{questgoal={"*","Jungle Remedy",7}}},
			mapzone="Stranglethorn Vale",
			level=33,
			mapnote=11205520,
		}, {
			"Go north to "..cl(45,10),
			"	a. Click the Kurzen Supplies",
			"	b. Get a Venom Fern Extract",
			completion={{questgoal={"*","Venom Fern Extract",1}}},
			mapzone="Stranglethorn Vale",
			level=33,
			mapnote=9705420,
		}, {
			"Go northwest to "..cl(38,3),
			"	a. Talk to Sergeant Yohwa",
			"		i. Turn in "..cq("The Second Rebellion"),
			"		ii. Turn in "..cq("Bad Medicine"),
			completion={{questturnedin="The Second Rebellion"},{questturnedin="Bad Medicine"}},
			mapzone="Stranglethorn Vale",
			level=33,
			mapnote=3304130,
		}, {
			"Go southwest to "..cl(36,11),
			"	a. Talk to Sir S. J. Erlgadin",
			"		i. Turn in "..cq("Panther Mastery part 1"),
			"		ii. Accept "..cq("Panther Mastery part 2"),
			completion={{questturnedin="Panther Mastery part 1"},{questaccepted="Panther Mastery part 2"}},
			mapzone="Stranglethorn Vale",
			level=33,
			mapnote=10704650,
		}, {
			"Go west to "..cl(34,12),
			"	a. Kill 10 Young Stranglethorn Tigers",
			completion={{questgoal={"*","Young Stranglethorn Tiger slain",10}}},
			mapzone="Stranglethorn Vale",
			level=33,
			mapnote=11504510,
		}, {
			"Go east to "..cl(36,11),
			"	a. Talk to Ajeck Rouack",
			"		i. Turn in "..cq("Tiger Mastery part 1"),
			"		ii. Accept "..cq("Tiger Mastery part 2"),
			completion={{questturnedin="Tiger Mastery part 1"},{questaccepted="Tiger Mastery part 2"}},
			mapzone="Stranglethorn Vale",
			level=33,
			mapnote=10704650,
		}, {
			"Go west "..cl(31,10),
			"	a. Kill 10 Panthers",
			"	b. Kill 10 Stranglethorn Tigers",
			completion={{questgoal={"*","Panther slain",10}},{questgoal={"*","Stranglethorn Tiger slain",10}}},
			mapzone="Stranglethorn Vale",
			level=33,
			mapnote=10004100,
		}, {
			"Grind to level 34",
			completion={{level=34}},
			mapzone="Stranglethorn Vale",
			level=33,
		}, {
			"Go southwest to "..cl(27,16),
			"	a. Kill 10 Stranglethorn Raptors",
			completion={{questgoal={"*","Stranglethorn Raptor slain",10}}},
			mapzone="Stranglethorn Vale",
			level=34,
			mapnote=16304330,
		}, {
			"Go northeast to "..cl(36,11),
			"	a. Talk to Hemet Nesingwary Jr.",
			"		i. Turn in "..cq("Raptor Mastery part 1"),
			"		ii. Accept "..cq("Raptor Mastery part 2"),
			"	b. Talk to Ajeck Rouack",
			"		i. Turn in "..cq("Tiger Mastery part 2"),
			"		ii. Accept "..cq("Tiger Mastery part 3"),
			"	c. Talk to Sir S. J. Erlgadin",
			"		i. Turn in "..cq("Panther Mastery part 2"),
			"		ii. Accept "..cq("Panther Mastery part 3"),
			completion={{questturnedin="Raptor Mastery part 1"},{questaccepted="Raptor Mastery part 2"},{questturnedin="Tiger Mastery part 2"},{questaccepted="Tiger Mastery part 3"},{questturnedin="Panther Mastery part 2"},{questaccepted="Panther Mastery part 3"}},
			mapzone="Stranglethorn Vale",
			level=34,
			mapnote=10704650,
		}, {
			"Go south to Booty Bay",
			completion={{location={mapzone="Stranglethorn Vale",x=27.7,y=74.6, dist=6}}},
			mapzone="Stranglethorn Vale",
			level=34,
		}, {
			"Go to "..cl(27,77),
			"	a. Talk to Krazek",
			"		i. Turn in "..cq("Krazek's Cookery"),
			"		ii. Accept "..cq("Favor for Krazek"),
			"		iii. Turn in "..cq("Favor for Krazek"),
			"		iv. Accept "..cq("Return to Corporal Kaleb"),
			"		v. Accept "..cq("Investigate the Camp"),
			"		vi. Accept "..cq("Supplies to Private Thorsen"),
			completion={{questturnedin="Krazek's Cookery"},{questaccepted="Favor for Krazek"},{questturnedin="Favor for Krazek"},{questaccepted="Return to Corporal Kaleb"},{questaccepted="Investigate the Camp"},{questaccepted="Supplies to Private Thorsen"}},
			mapzone="Stranglethorn Vale",
			level=34,
			mapnote=77210410,
		}, {
			"Go to "..cl(28,78),
			"	a. Talk to Gyll",
			"		i. Get the Booty Bay Flight Path",
			completion={{flightpath="Booty Bay"}},
			mapzone="Stranglethorn Vale",
			level=34,
			mapnote=77810530,
		}, {
			"Ride the boat to Ratchet",
			completion={{location={mapzone="The Barrens",x=63.0,y=38.1, dist=2}}},
			mapzone="Stranglethorn Vale",
			level=34,
		}, {
			"Go to "..cl(63,37),
			"	a. Talk to Bragok",
			"		i. Get the Ratchet Flight Path",
			completion={{flightpath="Ratchet"}},
			mapzone="The Barrens",
			level=34,
			mapnote=37210030,
		}, {
			"Go southwest to Thousand Needles",
			completion={{location={mapzone="Thousand Needles"}}},
			mapzone="The Barrens",
			level=34,
		}, {
			"Go south to "..cl(31,24),
			"	a. Click Henrig Lonebrow's Journal",
			"	b. Click Henrig Lonebrow's Journal in your bags",
			"		i. Accept "..cq("Lonebrow's Journal"),
			completion={{questaccepted="Lonebrow's Journal"}},
			mapzone="Thousand Needles",
			level=34,
			mapnote=24305500,
		}, {
			"Go west to "..cl(8,18),
			"	a. Talk to Thyssiana",
			"		i. Get the Thalanaar Flight Path",
			completion={{flightpath="Thalanaar"}},
			mapzone="Thousand Needles",
			level=34,
			mapnote=17902570,
		}, {
			"Go south to "..cl(8,19),
			"	a. Talk to Falfindel Waywarder",
			"		i. Turn in "..cq("Lonebrow's Journal"),
			completion={{questturnedin="Lonebrow's Journal"}},
			mapzone="Thousand Needles",
			level=34,
			mapnote=19002710,
		}, {
			"Go southeast to the Shimmering Flats",
			"	a. Go southeast to the Mirage Raceway",
			completion={{location={mapzone="Thousand Needles",x=78.6,y=76.0, dist=6}}},
			mapzone="Thousand Needles",
			level=34,
		}, {
			"Go southeast to "..cl(78,77),
			"	a. Talk to Wizzle Brassbolts",
			"		i. Turn in "..cq("The Brassbolts Brothers"),
			"		ii. Accept "..cq("Hardened Shells"),
			"	b. Talk to Fizzle Brassbolts",
			"		i. Accept "..cq("Salt Flat Venom"),
			completion={{questturnedin="The Brassbolts Brothers"},{questaccepted="Hardened Shells"},{questaccepted="Salt Flat Venom"}},
			mapzone="Thousand Needles",
			level=34,
			mapnote=77115520,
		}, {
			"Also at "..cl(78,77),	
			"	a. Talk to Kravel Koalbeard",
			"		i. Accept "..cq("Hemet Nesingwary Jr."),
			"		ii. Accept "..cq("Rocket Car Parts"),
			"		iii. Accept "..cq("Wharfmaster Dizzywig"),
			completion={{questaccepted="Hemet Nesingwary Jr."},{questaccepted="Rocket Car Parts"},{questaccepted="Wharfmaster Dizzywig"}},
			mapzone="Thousand Needles",
			level=34,
			mapnote=77315510,
		}, {
			"Go northeast to "..cl(80,76),
			"	a. Talk to Pozzik",
			"		i. Accept "..cq("Load Lightening"),
			completion={{questaccepted="Load Lightening"}},
			mapzone="Thousand Needles",
			level=34,
			mapnote=75915610,
		}, {
			"Go southeast to "..cl(82,78),
			"	a. Talk to Trackmaster Zherin",
			"		i. Accept "..cq("A Bump in the Road"),
			completion={{questaccepted="A Bump in the Road"}},
			mapzone="Thousand Needles",
			level=34,
			mapnote=77915950,
		}, {
			"Get Rocket Car Parts as you walk around in the Shimmering Flats",
			mapzone="Thousand Needles",
			level=34,
		}, {
			"Go southwest to "..cl(79,85),
			"	a. Kill 10 Saltstone Crystalhides",
			"	b. Kill 6 Saltstone Gazers",
			completion={{questgoal={"*","Saltstone Crystalhide slain",10}},{questgoal={"*","Saltstone Gazer slain",6}}},
			mapzone="Thousand Needles",
			level=34,
			mapnote=85216430,
		}, {
			"Go northeast to "..cl(88,67),
			"	a. Kill vultures",
			"	b. Get 10 Hollow Vulture Bones",
			completion={{questgoal={"*","Hollow Vulture Bone",10}}},
			mapzone="Thousand Needles",
			level=34,
			mapnote=66715430,
		}, {
			"Go northwest to "..cl(83,55),
			"	a. Kill turtles",
			"	b. Get 9 Hardened Tortoise Shells",
			completion={{questgoal={"*","Hardened Tortoise Shell",9}}},
			mapzone="Thousand Needles",
			level=34,
			mapnote=55413860,
		}, {
			"Go west to "..cl(75,55),
			"	a. Kill 10 Saltstone Basilisks",
			"	b. Finish getting the 30 Rocket Car Parts you need",
			completion={{questgoal={"*","Saltstone Basilisk slain",10}},{questgoal={"*","Rocket Car Parts",30}}},
			mapzone="Thousand Needles",
			level=34,
			mapnote=55013040,
		}, {
			"Go southwest to "..cl(72,73),
			"	a. Kill scorpions",
			"	b. Get 6 Salty Scorpid Venom",
			completion={{questgoal={"*","Salty Scorpid Venom",6}}},
			mapzone="Thousand Needles",
			level=34,
			mapnote=72614500,
		}, {
			"Go southeast to the Mirage Raceway",
			completion={{location={mapzone="Thousand Needles",x=78.6,y=76.0, dist=6}}},
			mapzone="Thousand Needles",
			level=34,
		}, {
			"Go to "..cl(78,77),
			"	a. Talk to Kravel Koalbeard",
			"		i. Turn in "..cq("Rocket Car Parts"),
			completion={{questturnedin="Rocket Car Parts"}},
			mapzone="Thousand Needles",
			level=34,
			mapnote=77315510,
		}, {
			"Also at "..cl(78,77),	
			"	a. Talk to Wizzle Brassbolts",
			"		i. Turn in "..cq("Hardened Shells"),
			"	b. Talk to Fizzle Brassbolts",
			"		i. Turn in "..cq("Salt Flat Venom"),
			"		ii. Accept "..cq("Martek the Exiled"),
			completion={{questturnedin="Hardened Shells"},{questturnedin="Salt Flat Venom"},{questaccepted="Martek the Exiled"}},
			mapzone="Thousand Needles",
			level=34,
			mapnote=77115520,
		}, {
			"Go to "..cl(80,76),
			"	a. Talk to Pozzik",
			"		i. Turn in "..cq("Load Lightening"),
			"		ii. Accept "..cq("Goblin Sponsorship part 1"),
			completion={{questturnedin="Load Lightening"},{questaccepted="Goblin Sponsorship part 1"}},
			mapzone="Thousand Needles",
			level=34,
			mapnote=75915610,
		}, {
			"Go to "..cl(82,78),
			"	a. Talk to Trackmaster Zherin",
			"		i. Turn in "..cq("A Bump in the Road"),
			completion={{questturnedin="A Bump in the Road"}},
			mapzone="Thousand Needles",
			level=34,
			mapnote=77915950,
		}, {
			"Go southwest to Tanaris",
			completion={{location={mapzone="Tanaris"}}},
			mapzone="Thousand Needles",
			level=34,
		}, {
			"Go south to "..cl(51,29),
			"	a. Talk to Bera Stonehammer",
			"		i. Get the Gadgetzan Flight Path",
			completion={{flightpath="Gadgetzan"}},
			mapzone="Tanaris",
			level=34,
			mapnote=29308030,
		}, {
			"Hearth to Southshore",
			completion={{location={mapzone="Hillsbrad Foothills",x=50.0,y=56.9, dist=8}}},
			mapzone="Tanaris",
			level=34,
		}, {
			"Go to "..cl(48,59),
			"	a. Talk to Magistrate Henry Maleb",
			"		i. Turn in "..cq("Further Mysteries"),
			completion={{questturnedin="Further Mysteries"}},
			mapzone="Hillsbrad Foothills",
			level=34,
			mapnote=59110720,
		}, {
			"Fly to Menethil Harbor",
			completion={{location={mapzone="Wetlands",x=10.1,y=56.7, dist=9}}},
			mapzone="Hillsbrad Foothills",
			level=34,
		}, {
			"Ride the boat to Theramore",
			completion={{location={mapzone="Dustwallow Marsh",x=67.5,y=50.3, dist=9}}},
			mapzone="Wetlands",
			level=34,
		}, {
			"Go to "..cl(67,51),
			"	a. Talk to Baldruc",
			"		i. Get the Theramore Flight Path",
			completion={{flightpath="Theramore"}},
			mapzone="Dustwallow Marsh",
			level=34,
			mapnote=51311880,
		}, {
			"Fly to Stonetalon Peak",
			completion={{location={mapzone="Stonetalon Mountains",x=36.5,y=7.3, dist=6}}},
			mapzone="Dustwallow Marsh",
			level=34,
		}, {
			"Go south to Desolace",
			completion={{location={mapzone="Desolace"}}},
			mapzone="Stonetalon Mountains",
			level=34,
		}, {
			"Grind to level 35",
			completion={{level=35}},
			mapzone="Desolace",
			level=34,
		}
	  },
	},
	{ sectiontitle = "Levels (35-40)",
	  steps = {
		{
			"Go southeast to "..cl(68,16),
			"	a. The path up to Nijel's Point starts here",
			completion={{location={mapzone="Desolace",x=67.5,y=15.9, dist=0.5}}},
			mapzone="Desolace",
			level=35,
			mapnote=15808330,
		}, {
			"Go up to Nijel's Point",
			completion={{location={mapzone="Desolace",x=66.8,y=10.1, dist=4}}},
			mapzone="Desolace",
			level=35,
		}, {
			"Go to "..cl(66,12),
			"	a. Talk to Vahlarriel Demonslayer",
			"		i. Accept "..cq("Vahlarriel's Search part 1"),
			completion={{questaccepted="Vahlarriel's Search part 1"}},
			mapzone="Desolace",
			level=35,
			mapnote=11807820,
		}, {
			"Go to "..cl(66,10),
			"	a. Talk to Kreldig Ungor",
			"		i. Turn in "..cq("Reclaimers' Business in Desolace"),
			"		ii. Accept "..cq("Reagents for Reclaimers Inc. part 1"),
			"		iii. Accept "..cq("The Karnitol Shipwreck"),
			completion={{questturnedin="Reclaimers' Business in Desolace"},{questaccepted="Reagents for Reclaimers Inc. part 1"},{questaccepted="The Karnitol Shipwreck"}},
			mapzone="Desolace",
			level=35,
			mapnote=9607580,
		}, {
			"Go to "..cl(65,11),
			"	a. Talk to Baritanas Skyriver",
			"		i. Get the Nijel's Point Flight Path",
			completion={{flightpath="Nijel's Point"}},
			mapzone="Desolace",
			level=35,
			mapnote=10507520,
		}, {
			"Make Nijel's Point your home",
			completion={{home="Nijel's Point"}},
			mapzone="Desolace",
			level=35,
		}, {
			"Go southwest to "..cl(57,18),
			"	a. Click the Malem Chest",
			"		i. Turn in "..cq("Vahlarriel's Search part 1"),
			"		ii. Accept "..cq("Vahlarriel's Search part 2"),
			completion={{questturnedin="Vahlarriel's Search part 1"},{questaccepted="Vahlarriel's Search part 2"}},
			mapzone="Desolace",
			level=35,
			mapnote=17807430,
		}, {
			"Go northeast to Nijel's Point",
			completion={{location={mapzone="Desolace",x=66.8,y=10.1, dist=4}}},
			mapzone="Desolace",
			level=35,
		}, {
			"Go to "..cl(66,12),
			"	a. Talk to Vahlarriel Demonslayer",
			"		i. Turn in "..cq("Vahlarriel's Search part 2"),
			"		ii. Accept "..cq("Vahlarriel's Search part 3"),
			completion={{questturnedin="Vahlarriel's Search part 2"},{questaccepted="Vahlarriel's Search part 3"}},
			mapzone="Desolace",
			level=35,
			mapnote=11807820,
		}, {
			"Go southeast to "..cl(72,18),
			"	a. Kill Hatefury demons",
			"	b. Get 10 Hatefury Claws",
			"	c. Get 10 Hatefury Horns",
			completion={{questgoal={"*","Hatefury Claw",10}},{questgoal={"*","Hatefury Horn",10}}},
			mapzone="Desolace",
			level=35,
			mapnote=17808960,
		}, {
			"Go northwest to Nijel's Point",
			completion={{location={mapzone="Desolace",x=66.8,y=10.1, dist=4}}},
			mapzone="Desolace",
			level=35,
		}, {
			"Go to "..cl(66,10),
			"	a. Talk to Kreldig Ungor",
			"		i. Turn in "..cq("Reagents for Reclaimers Inc. part 1"),
			completion={{questturnedin="Reagents for Reclaimers Inc. part 1"}},
			mapzone="Desolace",
			level=35,
			mapnote=9607580,
		}, {
			"Go south to "..cl(62,39),
			"	a. Talk to Bibbly F'utzbuckle",
			"		i. Accept "..cq("Bone Collector"),
			completion={{questaccepted="Bone Collector"}},
			mapzone="Desolace",
			level=35,
			mapnote=39010130,
		}, {
			"Go northwest to "..cl(61,62),
			"	a. Talk to Smeed Scrabblescrew",
			"		i. Accept "..cq("Kodo Roundup"),
			completion={{questaccepted="Kodo Roundup"}},
			mapzone="Desolace",
			level=35,
			mapnote=61912280,
		}, {
			"Go west to "..cl(56,63),
			"	a. Use your Kodo Kombobulator on Ancient, Aged, or Dying Kodos",
			"	b. Lead them back to Smeed Scrabblescrew one at a time",
			"	c. Talk to each Kodo after you lead it back to Smeed Scrabblescrew",
			"	d. Lead 5 Tamed Kodos back to Smeed Scrabblescrew",
			completion={{questgoal={"*","Kodos Tamed",5}}},
			mapzone="Desolace",
			level=35,
			mapnote=62911870,
		}, {
			"Go south to "..cl(61,62),
			"	a. Talk to Smeed Scrabble",
			"		i. Turn in "..cq("Kodo Roundup"),
			completion={{questturnedin="Kodo Roundup"}},
			mapzone="Desolace",
			level=35,
			mapnote=61912280,
		}, {
			"Go west to "..cl(54,64),
			"	a. Click the Kodo Bones",
			"	b. Get 10 Kodo Bones",
			completion={{questgoal={"*","Kodo Bone",10}}},
			mapzone="Desolace",
			level=35,
			mapnote=63811820,
		}, {
			"Go northwest to "..cl(39,27),
			"	a. Talk to Azore Aldamort",
			"		i. Accept "..cq("Sceptre of Light"),
			completion={{questaccepted="Sceptre of Light"}},
			mapzone="Desolace",
			level=35,
			mapnote=27206610,
		}, {
			"Go southwest to "..cl(36,30),
			"	a. Click Karnitol's Chest",
			"		i. Turn in 'The Karnitol Shipwreck' part 1",
			"		ii. Accept 'The Karnitol Shipwreck' part 2",
			"	b. Click Rackmore's Log",
			"		i. Accept "..cq("Claim Rackmore's Treasure!"),
			completion={{questturnedin="The Karnitol Shipwreck part 1"},{questaccepted="The Karnitol Shipwreck part 2"},{questaccepted="Claim Rackmore's Treasure!"}},
			mapzone="Desolace",
			level=35,
			mapnote=30406650,
		}, {
			"Go west to "..cl(34,31),
			"	a. Kill Drysnaps",
			"	b. Get Rackmore's Silver Key",
			completion={{questgoal={"*","Rackmore's Silver Key",1}}},
			mapzone="Desolace",
			level=35,
			mapnote=31306570,
		}, {
			"Go north to "..cl(36,26),
			"	a. Kill nagas",
			"	b. Get Rackmore's Golden Key",
			completion={{questgoal={"*","Rackmore's Golden Key",1}}},
			mapzone="Desolace",
			level=35,
			mapnote=25606120,
		}, {
			"Go east to "..cl(55,30),
			"	a. Kill the Burning Blade Seer",
			"	b. Get the Sceptre of Light",
			completion={{questgoal={"*","Sceptre of Light",1}}},
			mapzone="Desolace",
			level=35,
			mapnote=30108530,
		}, {
			"Go north to "..cl(55,26),
			"	a. Talk to Dalinda Malem",
			"		i. Turn in "..cq("Vahlarriel's Search part 3"),
			"		ii. Accept "..cq("Search for Tyranis"),
			completion={{questturnedin="Vahlarriel's Search part 3"},{questaccepted="Search for Tyranis"}},
			mapzone="Desolace",
			level=35,
			mapnote=26108100,
		}, {
			"Go southwest to "..cl(53,29),
			"	a. Kill Tyranis Malem",
			"	b. Get Tyranis' Pendant",
			completion={{questgoal={"*","Tyranis' Pendant",1}}},
			mapzone="Desolace",
			level=35,
			mapnote=29108210,
		}, {
			"Go northeast to "..cl(55,26),
			"	a. Talk to Dalinda Malem",
			"		i. Turn in "..cq("Search for Tyranis"),
			"		ii. Accept "..cq("Return to Vahlarriel"),
			"	b. Escort Dalinda Malem to safety (only attack when she attacks first)",
			completion={{questturnedin="Search for Tyranis"},{questaccepted="Return to Vahlarriel"}},
			mapzone="Desolace",
			level=35,
			mapnote=26108100,
		}, {
			"Go southeast to "..cl(62,39),
			"	a. Talk to Bibbly F'utzbuckle",
			"		i. Turn in "..cq("Bone Collector"),
			completion={{questturnedin="Bone Collector"}},
			mapzone="Desolace",
			level=35,
			mapnote=39010130,
		}, {
			"Go northwest to "..cl(39,27),
			"	a. Talk to Azore Aldamort",
			"		i. Turn in "..cq("Sceptre of Light"),
			"		ii. Accept "..cq("Book of the Ancients"),
			completion={{questturnedin="Sceptre of Light"},{questaccepted="Book of the Ancients"}},
			mapzone="Desolace",
			level=35,
			mapnote=27206610,
		}, {
			"Go northwest to "..cl(30,9),
			"	a. Click Rackmore's Chest",
			"		i. Turn in "..cq("Claim Rackmore's Treasure!"),
			completion={{questturnedin="Claim Rackmore's Treasure!"}},
			mapzone="Desolace",
			level=35,
			mapnote=8703870,
		}, {
			"Go northwest to "..cl(28,7),
			"	a. Click the Serpent Statue",
			"	b. Kill Lord Kragaru who spawns after you click the Serpent Statue",
			"	c. Get the Book of the Ancients",
			completion={{questgoal={"*","Book of the Ancients",1}}},
			mapzone="Desolace",
			level=35,
			mapnote=6603480,
		}, {
			"Go southeast to "..cl(39,27),
			"	a. Talk to Azore Aldamort",
			"		i. Turn in "..cq("Book of the Ancients"),
			completion={{questturnedin="Book of the Ancients"}},
			mapzone="Desolace",
			level=35,
			mapnote=27206610,
		}, {
			"Hearth to Nijel's Point",
			completion={{location={mapzone="Desolace",x=66.8,y=10.1, dist=4}}},
			mapzone="Desolace",
			level=35,
		}, {
			"Go to "..cl(66,10),
			"	a. Talk to Kreldig Ungor",
			"		i. Turn in "..cq("The Karnitol Shipwreck part 2"),
			completion={{questturnedin="The Karnitol Shipwreck part 2"}},
			mapzone="Desolace",
			level=35,
			mapnote=9607580,
		}, {
			"Go to "..cl(66,12),
			"	a. Talk to Vahlarriel Demonslayer",
			"		i. Turn in "..cq("Return to Vahlarriel"),
			completion={{questturnedin="Return to Vahlarriel"}},
			mapzone="Desolace",
			level=35,
			mapnote=11807820,
		}, {
			"Grind to level 36",
			completion={{level=36}},
			mapzone="Desolace",
			level=35,
		}, {
			"Go southwest to Feralas",
			completion={{location={mapzone="Feralas"}}},
			mapzone="Desolace",
			level=36,
		}, {
			"Go south to "..cl(43,43),
			"	a. Ride the boat to Feathermoon Stronghold",
			completion={{location={mapzone="Feralas",x=43.5,y=42.7, dist=0.5}}},
			mapzone="Feralas",
			level=36,
			mapnote=42808630,
		}, {
			"Go to "..cl(30,43),
			"	a. Talk to Fyldren Moonfeather",
			"		i. Get the Feathermoon Stronghold Flight Path",
			completion={{flightpath="Feathermoon Stronghold"}},
			mapzone="Feralas",
			level=36,
			mapnote=43207340,
		}, {
			"Fly to Ratchet",
			completion={{location={mapzone="The Barrens",x=63.0,y=38.1, dist=2}}},
			mapzone="Feralas",
			level=36,
		}, {
			"Go to "..cl(63,36),
			"	a. Talk to Gazlowe",
			"		i. Turn in "..cq("Goblin Sponsorship part 1"),
			"		ii. Accept "..cq("Goblin Sponsorship part 2"),
			completion={{questturnedin="Goblin Sponsorship part 1"},{questaccepted="Goblin Sponsorship part 2"}},
			mapzone="The Barrens",
			level=36,
			mapnote=36209890,
		}, {
			"Go to "..cl(63,38),
			"	a. Talk to Wharfmaster Dizzywig",
			"		i. Turn in "..cq("Wharfmaster Dizzywig"),
			"		ii. Accept "..cq("Parts for Kravel"),
			completion={{questturnedin="Wharfmaster Dizzywig"},{questaccepted="Parts for Kravel"}},
			mapzone="The Barrens",
			level=36,
			mapnote=38510190,
		}, {
			"Ride the boat to Booty Bay",
			completion={{location={mapzone="Stranglethorn Vale",x=27.7,y=74.6, dist=6}}},
			mapzone="The Barrens",
			level=36,
		}, {
			"Go to "..cl(26,74),
			"	a. Talk to Wharfmaster Lozgil",
			"		i. Turn in "..cq("Goblin Sponsorship part 2"),
			"		ii. Accept "..cq("Goblin Sponsorship part 3"),
			completion={{questturnedin="Goblin Sponsorship part 2"},{questaccepted="Goblin Sponsorship part 3"}},
			mapzone="Stranglethorn Vale",
			level=36,
			mapnote=73609990,
		}, {
			"Make Booty Bay your home",
			completion={{home="Booty Bay"}},
			mapzone="Stranglethorn Vale",
			level=36,
		}, {
			"Go to "..cl(27,77),
			"	a. Talk to Crank Fizzlebub",
			"		i. Accept "..cq("Singing Blue Shards"),
			completion={{questaccepted="Singing Blue Shards"}},
			mapzone="Stranglethorn Vale",
			level=36,
			mapnote=77210430,
		}, {
			"Also at "..cl(27,77),	
			"	a. Talk to Kebok",
			"		i. Accept "..cq("Bloodscalp Ears"),
			"		ii. Accept "..cq("Hostile Takeover"),
			completion={{questaccepted="Bloodscalp Ears"},{questaccepted="Hostile Takeover"}},
			mapzone="Stranglethorn Vale",
			level=36,
			mapnote=77110410,
		}, {
			"Also at "..cl(27,77),	
			"	a. Talk to Krazek",
			"		i. Accept "..cq("The Haunted Isle"),
			completion={{questaccepted="The Haunted Isle"}},
			mapzone="Stranglethorn Vale",
			level=36,
			mapnote=77210410,		
		}, {
			"Also at "..cl(27,77),	
			"	a. Talk to Baron Revilgaz",
			"		i. Turn in "..cq("The Haunted Isle"),
			"		ii. Accept "..cq("The Stone of the Tides"),
			"		iii. Turn in "..cq("Goblin Sponsorship part 3"),
			"		iv. Accept "..cq("Goblin Sponsorship part 4"),
			completion={{questturnedin="The Haunted Isle"},{questaccepted="The Stone of the Tides"},{questturnedin="Goblin Sponsorship part 3"},{questaccepted="Goblin Sponsorship part 4"}},
			mapzone="Stranglethorn Vale",
			level=36,
			mapnote=77010420,
		}, {
			"Go to "..cl(28,78),
			"	a. Talk to Drizzlik",
			"		i. Accept "..cq("Supply and Demand"),
			completion={{questaccepted="Supply and Demand"}},
			mapzone="Stranglethorn Vale",
			level=36,
			mapnote=77610590,
		}, {
			"Go northeast to "..cl(39,35),
			"	a. Kill 10 Shadowmaw Panthers",
			completion={{questgoal={"*","Shadowmaw Panther slain",10}}},
			mapzone="Stranglethorn Vale",
			level=36,
			mapnote=34707410,
		}, {
			"Go northeast to "..cl(44,22),
			"	a. Kill Venture Co. Geologists",
			"	b. Get 8 Tumbled Crystals",
			completion={{questgoal={"*","Tumbled Crystal",8}}},
			mapzone="Stranglethorn Vale",
			level=36,
			mapnote=21606600,
		}, {
			"Go northwest to "..cl(43,18),
			"	a. Kill Foreman Cozzle",
			"	b. Get Cozzle's Key",
			completion={{questgoal={"*","Cozzle's Key",1}}},
			mapzone="Stranglethorn Vale",
			level=36,
			mapnote=18306100,
		}, {
			"Go southeast to "..cl(43,20),
			"	a. Click Cozzle's Footlocker",
			"	b. Get the Fuel Regulator Blueprints",
			completion={{questgoal={"*","Fuel Regulator Blueprints",1}}},
			mapzone="Stranglethorn Vale",
			level=36,
			mapnote=20306360,
		}, {
			"Go southwest to "..cl(37,24),
			"	a. Kill 10 Lashtail Raptors",
			completion={{questgoal={"*","Lashtail Raptor slain",10}}},
			mapzone="Stranglethorn Vale",
			level=36,
			mapnote=24406150,
		}, {
			"Go northwest to "..cl(33,19),
			"	a. Kill 10 Elder Stranglethorn Tigers",
			completion={{questgoal={"*","Elder Stranglethorn Tiger slain",10}}},
			mapzone="Stranglethorn Vale",
			level=36,
			mapnote=18805130,
		}, {
			"Go northeast to "..cl(41,13),
			"	a. Kill River Crocolisks",
			"	b. Get 2 Large River Crocolisk Skins",
			completion={{questgoal={"*","Large River Crocolisk Skin",2}}},
			mapzone="Stranglethorn Vale",
			level=36,
			mapnote=13305390,
		}, {
			"Go west to "..cl(36,11),
			"	a. Talk to Sir S. J. Erlgadin",
			"		i. Turn in "..cq("Panther Mastery part 3"),
			"		ii. Accept "..cq("Panther Mastery part 4"),
			"	b. Talk to Ajeck Rouack",
			"		i. Turn in "..cq("Tiger Mastery part 3"),
			"		ii. Accept "..cq("Tiger Mastery part 4"),
			"	c. Talk to Hemet Nesingwary Jr.",
			"		i. Turn in "..cq("Hemet Nesingwary Jr."),
			"		ii. Turn in "..cq("Raptor Mastery part 2"),
			"		iii. Accept "..cq("Raptor Mastery part 3"),
			"	d. See a message saying you Investigated the Camp",
			completion={{questturnedin="Panther Mastery part 3"},{questaccepted="Panther Mastery part 4"},{questturnedin="Tiger Mastery part 3"},{questaccepted="Tiger Mastery part 4"},{questturnedin="Hemet Nesingwary Jr."},{questturnedin="Raptor Mastery part 2"},{questaccepted="Raptor Mastery part 3"},{questgoal={"*","Locate the hunters' camp",1}}},
			mapzone="Stranglethorn Vale",
			level=36,
			mapnote=10704650,
		}, {
			"Go southwest to "..cl(32,17),
			"	a. Kill Sin'Dall",
			"	b. Get the Paw of Sin'Dall",
			completion={{questgoal={"*","Paw of Sin'Dall",1}}},
			mapzone="Stranglethorn Vale",
			level=36,
			mapnote=17304950,
		}, {
			"Go northeast to "..cl(36,11),
			"	a. Talk to Ajeck Rouack",
			"		i. Turn in "..cq("Tiger Mastery part 4"),
			completion={{questturnedin="Tiger Mastery part 4"}},
			mapzone="Stranglethorn Vale",
			level=36,
			mapnote=10704650,
		}, {
			"Go northeast to "..cl(39,5),
			"	a. Talk to Private Thorsen",
			"		i. Turn in "..cq("Supplies to Private Thorsen"),
			completion={{questturnedin="Supplies to Private Thorsen"}},
			mapzone="Stranglethorn Vale",
			level=36,
			mapnote=5104400,
		}, {
			"Go to "..cl(38,3),
			"	a. Talk to Sergeant Yohwa",
			"		i. Accept "..cq("Special Forces"),
			completion={{questaccepted="Special Forces"}},
			mapzone="Stranglethorn Vale",
			level=36,
			mapnote=3304130,
		}, {
			"Go southeast to "..cl(46,8),
			"	a. Kill 10 Kurzen Commandos",
			"	b. Kill 6 Kurzen Headshrinkers",
			completion={{questgoal={"*","Kurzen Commando slain",10}},{questgoal={"*","Kurzen Headshrinker slain",6}}},
			mapzone="Stranglethorn Vale",
			level=36,
			mapnote=8205390,
		}, {
			"Go northwest to "..cl(38,3),
			"	a. Talk to Lieutenant Doren",
			"		i. Turn in "..cq("Special Forces"),
			completion={{questturnedin="Special Forces"}},
			mapzone="Stranglethorn Vale",
			level=36,
			mapnote=3004100,
		}, {
			"Also at "..cl(38,3),	
			"	a. Talk to Corporal Kaleb",
			"		i. Turn in "..cq("Return to Corporal Kaleb"),
			completion={{questturnedin="Return to Corporal Kaleb"}},
			mapzone="Stranglethorn Vale",
			level=36,
			mapnote=3304130,
		}, {
			"Go southwest to "..cl(29,21),
			"	a. Kill Bloodscalp trolls",
			"	b. Get 15 Bloodscalp Ears",
			completion={{questgoal={"*","Bloodscalp Ear",15}}},
			mapzone="Stranglethorn Vale",
			level=36,
			mapnote=20704960,
		}, {
			"Grind to level 37",
			completion={{level=37}},
			mapzone="Stranglethorn Vale",
			level=36,
		}, {
			"Go northwest to "..cl(25,18),
			"	a. Kill basilisks",
			"	b. Get 10 Singing Crystal Shards",
			completion={{questgoal={"*","Singing Crystal Shard",10}}},
			mapzone="Stranglethorn Vale",
			level=37,
			mapnote=17704280,
		}, {
			"Go southwest to "..cl(22,22),
			"	a. Locate the Haunted Isle",
			completion={{questgoal={"*","Locate the haunted isle",1}}},
			mapzone="Stranglethorn Vale",
			level=37,
			mapnote=22004410,
		}, {
			"Hearth to Booty Bay",
			completion={{location={mapzone="Stranglethorn Vale",x=27.7,y=74.6, dist=6}}},
			mapzone="Stranglethorn Vale",
			level=37,
		}, {
			"Go to "..cl(27,77),
			"	a. Talk to Crank Fizzlebub",
			"		i. Turn in "..cq("Singing Blue Shards"),
			completion={{questturnedin="Singing Blue Shards"}},
			mapzone="Stranglethorn Vale",
			level=37,
			mapnote=77210430,
		}, {
			"Also at "..cl(27,77),	
			"	a. Talk to Kebok",
			"		i. Turn in "..cq("Bloodscalp Ears"),
			"		ii. Turn in "..cq("Hostile Takeover"),
			completion={{questturnedin="Bloodscalp Ears"},{questturnedin="Hostile Takeover"}},
			mapzone="Stranglethorn Vale",
			level=37,
			mapnote=77110410,
		}, {
			"Also at "..cl(27,77),	
			"	a. Talk to Krazek",
			"		i. Turn in "..cq("Investigate the Camp"),
			completion={{questturnedin="Investigate the Camp"}},
			mapzone="Stranglethorn Vale",
			level=37,
			mapnote=77210410,
		}, {
			"Also at "..cl(27,77),	
			"	a. Talk to Baron Revilgaz",
			"		i. Turn in "..cq("Goblin Sponsorship part 4"),
			"		ii. Accept "..cq("Goblin Sponsorship part 5"),
			"		iii. Turn in "..cq("The Stone of the Tides"),
			"		iv. Accept "..cq("Water Elementals"),
			completion={{questturnedin="Goblin Sponsorship part 4"},{questaccepted="Goblin Sponsorship part 5"},{questturnedin="The Stone of the Tides"},{questaccepted="Water Elementals"}},
			mapzone="Stranglethorn Vale",
			level=37,
			mapnote=77010420,
		}, {
			"Go to "..cl(28,78),
			"	a. Talk to Drizzlik",
			"		i. Turn in "..cq("Supply and Demand"),
			"		ii. Accept "..cq("Some Assembly Required"),
			completion={{questturnedin="Supply and Demand"},{questaccepted="Some Assembly Required"}},
			mapzone="Stranglethorn Vale",
			level=37,
			mapnote=77610590,
		}, {
			"Ride the boat to Ratchet",
			completion={{location={mapzone="The Barrens",x=63.0,y=38.1, dist=2}}},
			mapzone="Stranglethorn Vale",
			level=37,
		}, {
			"Fly to Gadgetzan",
			completion={{location={mapzone="Tanaris",x=51.7,y=27.8, dist=6}}},
			mapzone="The Barrens",
			level=37,
		}, {
			"Go north to Thousand Needles",
			completion={{location={mapzone="Thousand Needles"}}},
			mapzone="Tanaris",
			level=37,
		}, {
			"Go northeast to the Mirage Raceway",
			completion={{location={mapzone="Thousand Needles",x=78.6,y=76.0, dist=6}}},
			mapzone="Thousand Needles",
			level=37,
		}, {
			"Go to "..cl(78,77),
			"	a. Talk to Kravel Koalbeard",
			"		i. Turn in "..cq("Parts for Kravel"),
			"		ii. Accept "..cq("Delivery to the Gnomes"),
			completion={{questturnedin="Parts for Kravel"},{questaccepted="Delivery to the Gnomes"}},
			mapzone="Thousand Needles",
			level=37,
			mapnote=77315510,
		}, {
			"Also at "..cl(78,77),	
			"	a. Talk to Fizzle Brassbolts",
			"		i. Turn in "..cq("Delivery to the Gnomes"),
			completion={{questturnedin="Delivery to the Gnomes"}},
			mapzone="Thousand Needles",
			level=37,
			mapnote=77115520,
		}, {
			"Also at "..cl(78,77),	
			"	a. Talk to Kravel Koalbeard",
			"		i. Accept "..cq("The Rumormonger"),
			completion={{questaccepted="The Rumormonger"}},
			mapzone="Thousand Needles",
			level=37,
			mapnote=77315510,
		}, {
			"Go to "..cl(80,76),
			"	a. Talk to Pozzik",
			"		i. Turn in "..cq("Goblin Sponsorship part 5"),
			"		ii. Accept "..cq("The Eighteenth Pilot"),
			"	b. Talk to Razzeric",
			"		i. Turn in "..cq("The Eighteenth Pilot"),
			"		ii. Accept "..cq("Razzeric's Tweaking"),
			completion={{questturnedin="Goblin Sponsorship part 5"},{questaccepted="The Eighteenth Pilot"},{questturnedin="The Eighteenth Pilot"},{questaccepted="Razzeric's Tweaking"}},
			mapzone="Thousand Needles",
			level=37,
			mapnote=75915610,
		}, {
			"Go southwest to Tanaris",
			completion={{location={mapzone="Tanaris"}}},
			mapzone="Thousand Needles",
			level=37,
		}, {
			"Fly to Ratchet",
			completion={{location={mapzone="The Barrens",x=63.0,y=38.1, dist=2}}},
			mapzone="Tanaris",
			level=37,
		}, {
			"Ride the boat to Booty Bay",
			completion={{location={mapzone="Stranglethorn Vale",x=27.7,y=74.6, dist=6}}},
			mapzone="The Barrens",
			level=37,
		}, {
			"Fly to Southshore",
			completion={{location={mapzone="Hillsbrad Foothills",x=50.0,y=56.9, dist=8}}},
			mapzone="Stranglethorn Vale",
			level=37,
		}, {
			"Make Southshore your home",
			completion={{home="Southshore"}},
			mapzone="Hillsbrad Foothills",
			level=37,
		}, {
			"Go north to the Alterac Mountains",
			completion={{location={mapzone="Alterac Mountains"}}},
			mapzone="Hillsbrad Foothills",
			level=37,
		}, {
			"Go to "..cl(51,61),
			"	a. Kill ogres",
			"	b. Get 9 Dirty Knucklebones",
			completion={{questgoal={"*","Dirty Knucklebones",9}}},
			mapzone="Alterac Mountains",
			level=37,
			mapnote=60811050,
		}, {
			"Go northeast to "..cl(62,45),
			"	a. Kill Syndicate mobs",
			"	b. Get 7 Alterac Signet Rings",
			completion={{questgoal={"*","Alterac Signet Ring",7}}},
			mapzone="Alterac Mountains",
			level=37,
			mapnote=45410770,
		}, {
			"Hearth to Southshore",
			completion={{location={mapzone="Hillsbrad Foothills",x=50.0,y=56.9, dist=8}}},
			mapzone="Alterac Mountains",
			level=37,
		}, {
			"Go to "..cl(49,59),
			"	a. Talk to Marshal Redpath",
			"		i. Turn in "..cq("Crushridge Bounty"),
			completion={{questturnedin="Crushridge Bounty"}},
			mapzone="Hillsbrad Foothills",
			level=37,
			mapnote=58710820,
		}, {
			"Go to "..cl(48,59),
			"	a. Talk to Magistrate Henry Maleb",
			"		i. Turn in "..cq("Noble Deaths"),
			completion={{questturnedin="Noble Deaths"}},
			mapzone="Hillsbrad Foothills",
			level=37,
			mapnote=59110720,
		}, {
			"Fly to Refuge Point",
			completion={{location={mapzone="Arathi Highlands",x=45.6,y=46.7, dist=5}}},
			mapzone="Hillsbrad Foothills",
			level=37,
		}, {
			"Go to "..cl(46,48),
			"	a. Talk to Apprentice Kryten",
			"		i. Accept "..cq("Worth Its Weight in Gold"),
			completion={{questaccepted="Worth Its Weight in Gold"}},
			mapzone="Arathi Highlands",
			level=37,
			mapnote=47809400,
		}, {
			"Go northeast to "..cl(63,34),
			"	a. Click the Shards of Myzrael",
			"		i. Accept "..cq("The Princess Trapped"),
			completion={{questaccepted="The Princess Trapped"}},
			mapzone="Arathi Highlands",
			level=37,
			mapnote=33809630,
		}, {
			"Go southeast to "..cl(81,40),
			"	a. The path up to 'The Princess Trapped' starts here behind the tree",
			completion={{location={mapzone="Arathi Highlands",x=80.8,y=40.0, dist=0.5}}},
			mapzone="Arathi Highlands",
			level=37,
			mapnote=39912080,
		}, {
			"Go north east to "..cl(83,36),
			"	a. Kill kobolds",
			"	b. Get 12 Motes of Myzrael",
			completion={{questgoal={"*","Mote of Myzrael",12}}},
			mapzone="Arathi Highlands",
			level=37,
			mapnote=36011880,
		}, {
			"Go northeast to "..cl(84,31),
			"	a. Click the Iridescent Shards",
			"		i. Turn in "..cq("The Princess Trapped"),
			"		ii. Accept "..cq("Stones of Binding"),
			completion={{questturnedin="The Princess Trapped"},{questaccepted="Stones of Binding"}},
			mapzone="Arathi Highlands",
			level=37,
			mapnote=30911520,
		}, {
			"Grind to level 38",
			completion={{level=38}},
			mapzone="Arathi Highlands",
			level=37,
		}, {
			"Go west to "..cl(67,30),
			"	a. Click the Stone of East Binding",
			"	b. Get the Cresting Key",
			completion={{questgoal={"*","Cresting Key",1}}},
			mapzone="Arathi Highlands",
			level=38,
			mapnote=29709640,
		}, {
			"Go southeast to "..cl(72,63),
			"	a. Kill Witherbark trolls",
			"	b. Get 10 Witherbark Tusks",
			"	c. Kill Witherbark Witch Doctors",
			"	d. Get 4 Witherbark Medicine Pouches",
			completion={{questgoal={"*","Witherbark Tusk",10}},{questgoal={"*","Witherbark Medicine Pouch",4}}},
			mapzone="Arathi Highlands",
			level=38,
			mapnote=62913460,
		}, {
			"Go southwest to "..cl(68,75),
			"	a. Kill Witherbark Shadow Hunters inside the cave",
			"	b. Get a Shadow Hunter Knife",
			completion={{questgoal={"*","Shadow Hunter Knife",1}}},
			mapzone="Arathi Highlands",
			level=38,
			mapnote=75114340,
		}, {
			"Go northwest to "..cl(60,54),
			"	a. Talk to Quae",
			"		i. Turn in "..cq("Hints of a New Plague? part 1"),
			"		ii. Accept "..cq("Hints of a New Plague? part 2"),
			completion={{questturnedin="Hints of a New Plague? part 1"},{questaccepted="Hints of a New Plague? part 2"}},
			mapzone="Arathi Highlands",
			level=38,
			mapnote=53911410,
		}, {
			"The Forsaken Courier walks the road from the Go'Shek Farm to Tauren Mill in the Hillsbrad Foothills. If you see him while walking around, kill only the Forsaken Courier then run away. If you still have not found him after you're done questing, walk the road until you find him.",
			"	a. Get the Sealed Folder from the Forsaken Courier",
			completion={{questgoal={"*","Sealed Folder",1}}},
			mapzone="Arathi Highlands",
			level=38,
		}, {
			"Go northwest to "..cl(52,51),
			"	a. Click the Stone of Outer Binding",
			"	b. Get the Thundering Key",
			completion={{questgoal={"*","Thundering Key",1}}},
			mapzone="Arathi Highlands",
			level=38,
			mapnote=50710270,
		}, {
			"Go northwest to Refuge Point",
			completion={{location={mapzone="Arathi Highlands",x=45.6,y=46.7, dist=5}}},
			mapzone="Arathi Highlands",
			level=38,
		}, {
			"Go to "..cl(46,48),
			"	a. Talk to Apprentice Kryten",
			"		i. Turn in "..cq("Worth Its Weight in Gold"),
			completion={{questturnedin="Worth Its Weight in Gold"}},
			mapzone="Arathi Highlands",
			level=38,
			mapnote=47809400,
		}, {
			"Go to "..cl(47,47),
			"	a. Talk to Skuerto",
			"		i. Accept "..cq("Wand over Fist"),
			completion={{questaccepted="Wand over Fist"}},
			mapzone="Arathi Highlands",
			level=38,
			mapnote=47009360,
		}, {
			"Go southeast to "..cl(55,82),
			"	a. Kill Kor'gresh Coldrage",
			"	b. Get Trelane's Wand of Invocation",
			completion={{questgoal={"*","Trelane's Wand of Invocation",1}}},
			mapzone="Arathi Highlands",
			level=38,
			mapnote=81913670,
		}, {
			"Go northwest to Refuge Point",
			completion={{location={mapzone="Arathi Highlands",x=45.6,y=46.7, dist=5}}},
			mapzone="Arathi Highlands",
			level=38,
		}, {
			"Go to "..cl(47,47),
			"	a. Talk to Skuerto",
			"		i. Turn in "..cq("Wand over Fist"),
			completion={{questturnedin="Wand over Fist"}},
			mapzone="Arathi Highlands",
			level=38,
			mapnote=47009360,
		}, {
			"Go northwest to "..cl(26,30),
			"	a. Click the Stone of West Binding",
			"	b. Get the Burning Key",
			completion={{questgoal={"*","Burning Key",1}}},
			mapzone="Arathi Highlands",
			level=38,
			mapnote=30105560,
		}, {
			"Go southeast to "..cl(36,58),
			"	a. Click the Stone of Inner Binding",
			"	a. Turn in "..cq("Stones of Binding"),
			completion={{questturnedin="Stones of Binding"}},
			mapzone="Arathi Highlands",
			level=38,
			mapnote=58109410,
		}, {
			"Go southwest to "..cl(31,64),
			"	a. The path over to Faldir's Cove starts here",
			completion={{location={mapzone="Arathi Highlands",x=31.6,y=64.0, dist=0.5}}},
			mapzone="Arathi Highlands",
			level=38,
			mapnote=64109560,
		}, {
			"Go south to "..cl(32,83),
			"	a. Talk to Lolo the Lookout",
			"		i. Accept "..cq("Land Ho!"),
			completion={{questaccepted="Land Ho!"}},
			mapzone="Arathi Highlands",
			level=38,
			mapnote=82711450,
		}, {
			"Go northeast to "..cl(32,81),
			"	a. Talk to Shakes O'Breen",
			"		i. Turn in "..cq("Land Ho!"),
			completion={{questturnedin="Land Ho!"}},
			mapzone="Arathi Highlands",
			level=38,
			mapnote=81411370,
		}, {
			"Go east to "..cl(33,81),
			"	a. Talk to First Mate Nilzlix",
			"		i. Accept "..cq("Deep Sea Salvage"),
			completion={{questaccepted="Deep Sea Salvage"}},
			mapzone="Arathi Highlands",
			level=38,
			mapnote=81511420,
		}, {
			"Go east to "..cl(34,81),
			"	a. Talk to Captain Steelgut",
			"		i. Accept "..cq("Drowned Sorrows"),
			"	b. Talk to Professor Phizzlethorpe",
			"		i. Accept "..cq("Sunken Treasure part 1"),
			"		ii. Escort Professor Phizzlethorpe",
			"	c. Talk to Doctor Draxlegauge",
			"		i. Turn in "..cq("Sunken Treasure part 1"),
			"		ii. Accept "..cq("Sunken Treasure part 2"),
			completion={{questaccepted="Drowned Sorrows"},{questaccepted="Sunken Treasure part 1"},{questturnedin="Sunken Treasure part 1"},{questaccepted="Sunken Treasure part 2"}},
			mapzone="Arathi Highlands",
			level=38,
			mapnote=80611450,
		}, {
			"Go southwest to "..cl(25,85),
			"	a. Kill 10 Daggerspine Raiders",
			"	b. Kill 10 Daggerspine Sorceresses",
			completion={{questgoal={"*","Daggerspine Raider slain",10}},{questgoal={"*","Daggerspine Sorceress slain",10}}},
			mapzone="Arathi Highlands",
			level=38,
			mapnote=85211050,
		}, {
			"Go west to "..cl(24,85),
			"	a. Click the Maiden's Folly Log",
			"	b. Get the Maiden's Folly Log",
			completion={{questgoal={"*","Maiden's Folly Log",1}}},
			mapzone="Arathi Highlands",
			level=38,
			mapnote=85110860,
		}, {
			"Go northwest to "..cl(23,85),
			"	a. Click the Maiden's Folly Charts",
			"	b. Get the Maiden's Folly Charts",
			completion={{questgoal={"*","Maiden's Folly Charts",1}}},
			mapzone="Arathi Highlands",
			level=38,
			mapnote=84510760,
		}, {
			"Go southwest to "..cl(21,86),
			"	a. Click the Spirit of Silverpine Charts",
			"	b. Get the Spirit of Silverpine Charts",
			completion={{questgoal={"*","Spirit of Silverpine Charts",1}}},
			mapzone="Arathi Highlands",
			level=38,
			mapnote=85610610,
		}, {
			"Go north to "..cl(21,85),
			"	a. Click the Spirit of Silverpine Log",
			"	b. Get the Spirit of Silverpine Log",
			completion={{questgoal={"*","Spirit of Silverpine Log",1}}},
			mapzone="Arathi Highlands",
			level=38,
			mapnote=85110570,
		}, {
			"Go northeast to "..cl(22,84),
			"	a. Put on your Goggles of Gem Hunting",
			"	b. Click the Calcified Elven Gems",
			"	c. Get 10 Elven Gems",
			completion={{questgoal={"*","Elven Gem",10}}},
			mapzone="Arathi Highlands",
			level=38,
			mapnote=83710610,
		}, {
			"Go northeast to "..cl(33,81),
			"	a. Talk to First Mate Nilzlix",
			"		i. Turn in "..cq("Deep Sea Salvage"),
			completion={{questturnedin="Deep Sea Salvage"}},
			mapzone="Arathi Highlands",
			level=38,
			mapnote=81511420,
		}, {
			"Go northeast to "..cl(34,81),
			"	a. Talk to Doctor Draxlegauge",
			"		i. Turn in "..cq("Sunken Treasure part 2"),
			"		ii. Accept "..cq("Sunken Treasure part 3"),
			"	b. Talk to Captain Steelgut",
			"		i. Turn in "..cq("Drowned Sorrows"),
			completion={{questturnedin="Sunken Treasure part 2"},{questaccepted="Sunken Treasure part 3"},{questturnedin="Drowned Sorrows"}},
			mapzone="Arathi Highlands",
			level=38,
			mapnote=80611450,
		}, {
			"Go west "..cl(32,81),
			"	a. Talk Shakes O'Breen",
			"		i. Turn in "..cq("Sunken Treasure part 3"),
			"		ii. Accept "..cq("Sunken Treasure part 4"),
			completion={{questturnedin="Sunken Treasure part 3"},{questaccepted="Sunken Treasure part 4"}},
			mapzone="Arathi Highlands",
			level=38,
			mapnote=81411370,
		}, {
			"If you haven't killed the Forsaken Courier for 'Hints of a New Plague?' part 2, do it now",
			completion={{questgoal={"*","Sealed Folder",1}}},
			mapzone="Arathi Highlands",
			level=38,
		}, {
			"Go to Arathi Highlands if you are in Hillsbrad Foothills",
			completion={{location={mapzone="Arathi Highlands"}}},
			mapzone="Arathi Highlands",
			level=38,
		}, {
			"Go east to "..cl(60,54),
			"	a. Talk to Quae",
			"		i. Turn in "..cq("Hints of a New Plague? part 2"),
			"		ii. Accept "..cq("Hints of a New Plague? part 3"),
			"	b. Talk to Kinelory",
			"		i. Turn in "..cq("Hints of a New Plague? part 3"),
			"		ii. Accept "..cq("Hints of a New Plague? part 4"),
			"		iii. Escort Kinelory",
			"	c. Talk to Quae",
			"		i. Turn in "..cq("Hints of a New Plague? part 4"),
			"		ii. Accept "..cq("Hints of a New Plague? part 5"),
			completion={{questturnedin="Hints of a New Plague? part 2"},{questaccepted="Hints of a New Plague? part 3"},{questturnedin="Hints of a New Plague? part 3"},{questaccepted="Hints of a New Plague? part 4"},{questturnedin="Hints of a New Plague? part 4"},{questaccepted="Hints of a New Plague? part 5"}},
			mapzone="Arathi Highlands",
			level=38,
			mapnote=53911410,
		}, {
			"Grind to level 39",
			completion={{level=39}},
			mapzone="Arathi Highlands",
			level=38,
		}, {
			"Hearth to Southshore",
			completion={{location={mapzone="Hillsbrad Foothills",x=50.0,y=56.9, dist=8}}},
			mapzone="Arathi Highlands",
			level=39,
		}, {
			"Go to "..cl(50,59),
			"	a. Talk to Phin Odelic",
			"		i. Turn in "..cq("Hints of a New Plague? part 5"),
			completion={{questturnedin="Hints of a New Plague? part 5"}},
			mapzone="Hillsbrad Foothills",
			level=39,
			mapnote=59010930,
		}, {
			"Fly to Menethil Harbor",
			completion={{location={mapzone="Wetlands",x=10.1,y=56.7, dist=9}}},
			mapzone="Hillsbrad Foothills",
			level=39,
		}, {
			"Ride the boat to Theramore",
			completion={{location={mapzone="Dustwallow Marsh",x=67.5,y=50.3, dist=9}}},
			mapzone="Hillsbrad Foothills",
			level=39,
		}, {
			"Go to "..cl(68,52),
			"	a. Talk to Sergeant Amelyn",
			"		i. Accept "..cq("This Old Lighthouse"),
			completion={{questaccepted="This Old Lighthouse"}},
			mapzone="Dustwallow Marsh",
			level=39,
			mapnote=51611950,
		}, {
			"Go to "..cl(68,51),
			"	a. Talk to Calia Hastings",
			"		i. Accept "..cq("Traitors Among Us"),
			completion={{questaccepted="Traitors Among Us"}},
			mapzone="Dustwallow Marsh",
			level=39,
			mapnote=51111920,
		}, {
			"Talk to 5 Deserter Agitators around town",
			"	a. They look like guards",
			completion={{questgoal={"*","Deserter Agitator Exposed",5}}},
			mapzone="Dustwallow Marsh",
			level=39,
		}, {
			"Go to "..cl(65,57),
			"	a. Talk to Lieutenant Aden",
			"		i. Accept "..cq("Mission to Mudsprocket"),
			completion={{questaccepted="Mission to Mudsprocket"}},
			mapzone="Dustwallow Marsh",
			level=39,
			mapnote=47111220,
		}, {
			"Go to "..cl(66,46),
			"	a. Talk to Guard Byron",
			"		i. Accept "..cq("They Call Him Smiling Jim"),
			"		ii. Accept "..cq("Tabetha's Farm"),
			completion={{questaccepted="They Call Him Smiling Jim"},{questaccepted="Tabetha's Farm"}},
			mapzone="Dustwallow Marsh",
			level=39,
			mapnote=46111230,
		}, {
			"Make Theramore your home",
			completion={{home="Theramore"}},
			mapzone="Dustwallow Marsh",
			level=39,
		}, {
			"Go to "..cl(66,45),
			"	a. Talk to Morgan Stern",
			"		i. Accept "..cq("Mudrock Soup and Bugs"),
			completion={{questaccepted="Mudrock Soup and Bugs"}},
			mapzone="Dustwallow Marsh",
			level=39,
			mapnote=45511180,
		}, {
			"Go to "..cl(68,49),
			"	a. Talk to Captain Garran Vimes",
			"		i. Turn in "..cq("They Call Him Smiling Jim"),
			"		ii. Accept "..cq("Inspecting the Ruins"),
			completion={{questturnedin="They Call Him Smiling Jim"},{questaccepted="Inspecting the Ruins"}},
			mapzone="Dustwallow Marsh",
			level=39,
			mapnote=48611680,
		}, {
			"Go to "..cl(68,51),
			"	a. Talk to Calia Hastings",
			"		i. Turn in "..cq("Traitors Among Us"),
			"		ii. Accept "..cq("Propaganda War"),
			completion={{questturnedin="Traitors Among Us"},{questaccepted="Propaganda War"}},
			mapzone="Dustwallow Marsh",
			level=39,
			mapnote=51111920,
		}, {
			"Go to "..cl(68,59),
			"	a. Click the Deserter Propoganda boxes on the ship",
			"	b. Get the Deserter Propoganda",
			completion={{questgoal={"*","Deserter Propaganda",1}}},
			mapzone="Dustwallow Marsh",
			level=39,
			mapnote=58712660,
		}, {
			"Go to "..cl(68,51),
			"	a. Talk to Calia Hastings",
			"		i. Turn in "..cq("Propaganda War"),
			"		ii. Accept "..cq("Discrediting the Deserters"),
			completion={{questturnedin="Propaganda War"},{questaccepted="Discrediting the Deserters"}},
			mapzone="Dustwallow Marsh",
			level=39,
			mapnote=51111920,
		}, {
			"Talk to 6 Theramore Guards around town",
			"	a. Give them each a flier",
			completion={{questgoal={"*","Leaflets Distributed",6}}},
			mapzone="Dustwallow Marsh",
			level=39,
		}, {
			"Go to "..cl(68,51),
			"	a. Talk to Calia Hastings",
			"		i. Turn in "..cq("Discrediting the Deserters"),
			completion={{questturnedin="Discrediting the Deserters"}},
			mapzone="Dustwallow Marsh",
			level=39,
			mapnote=51111920,
		}, {
			"Go northeast to "..cl(72,47),
			"	a. Talk to Babs Fizzletorque",
			"		i. Turn in "..cq("This Old Lighthouse"),
			"		ii. Accept "..cq("Thresher Oil"),
			completion={{questturnedin="This Old Lighthouse"},{questaccepted="Thresher Oil"}},
			mapzone="Dustwallow Marsh",
			level=39,
			mapnote=47111910,
		}, {
			"Go south to "..cl(72,50),
			"	a. Kill Young Murk Threshers",
			"	b. Get 4 Thresher Oil",
			completion={{questgoal={"*","Thresher Oil",4}}},
			mapzone="Dustwallow Marsh",
			level=39,
			mapnote=50012200,
		}, {
			"Go north to "..cl(72,47),
			"	a. Talk to Babs Fizzletorque",
			"		i. Turn in "..cq("Thresher Oil"),
			"		ii. Accept "..cq("Dastardly Denizens of the Deep"),
			completion={{questturnedin="Thresher Oil"},{questaccepted="Dastardly Denizens of the Deep"}},
			mapzone="Dustwallow Marsh",
			level=39,
			mapnote=47111910,
		}, {
			"Go southwest to Theramore",
			completion={{location={mapzone="Dustwallow Marsh",x=67.5,y=50.3, dist=9}}},
			mapzone="Dustwallow Marsh",
			level=39,
		}, {
			"Go to "..cl(69,52),
			"	a. Talk to 'Dirty' Michael Crowe",
			"		i. Turn in "..cq("Dastardly Denizens of the Deep"),
			"		ii. Accept "..cq("Is it Real?"),
			completion={{questturnedin="Dastardly Denizens of the Deep"},{questaccepted="Is it Real?"}},
			mapzone="Dustwallow Marsh",
			level=39,
			mapnote=52112120,
		}, {
			"Go northwest to "..cl(60,41),
			"	a. Talk to Captain Wymor",
			"		i. Accept "..cq("Defias in Dustwallow?"),
			completion={{questaccepted="Defias in Dustwallow?"}},
			mapzone="Dustwallow Marsh",
			level=39,
			mapnote=41110090,
		}, {
			"Go east to "..cl(65,41),
			"	a. Kill turtles",
			"	b. Get 8 Forked Mudrock Tongues",
			completion={{questgoal={"*","Forked Mudrock Tongue",8}}},
			mapzone="Dustwallow Marsh",
			level=39,
			mapnote=41310600,
		}, {
			"Go north to "..cl(64,30),
			"	a. Kill Garn Mathers",
			"	b. Get the Defias Orders",
			completion={{questgoal={"*","Defias Orders",1}}},
			mapzone="Dustwallow Marsh",
			level=39,
			mapnote=30009400,
		}, {
			"Go southwest to "..cl(60,41),
			"	a. Talk to Captain Wymor",
			"		i. Turn in "..cq("Defias in Dustwallow?"),
			completion={{questturnedin="Defias in Dustwallow?"}},
			mapzone="Dustwallow Marsh",
			level=39,
			mapnote=41110090,
		}, {
			"Go northwest to "..cl(55,26),
			"	a. Talk to 'Swamp Eye' Jarl",
			"		i. Accept "..cq("Marsh Frog Legs"),
			"	b. Talk to Mordant Grimsby",
			"		i. Accept "..cq("What's Haunting Witch Hill?"),
			completion={{questaccepted="Marsh Frog Legs"},{questaccepted="What's Haunting Witch Hill?"}},
			mapzone="Dustwallow Marsh",
			level=39,
			mapnote=26308170,
		}, {
			"Also at "..cl(55,26),	
			"	a. Click the Loose Dirt",
			"		i. Accept "..cq("The Orc Report"),
			completion={{questaccepted="The Orc Report"}},
			mapzone="Dustwallow Marsh",
			level=39,
			mapnote=25908130,
		}, {
			"Kill Giant Marsh Frogs around 'Swamp Eye' Jarl's house",
			"	a. Get 10 Marsh Frog Legs",
			completion={{questgoal={"*","Marsh Frog Leg",10}}},
			mapzone="Dustwallow Marsh",
			level=39,
		}, {
			"Go to "..cl(55,26),
			"	a. Talk to 'Swamp Eye' Jarl",
			"		i. Turn in "..cq("Marsh Frog Legs"),
			"		ii. Accept "..cq("Jarl Needs Eyes"),
			completion={{questturnedin="Marsh Frog Legs"},{questaccepted="Jarl Needs Eyes"}},
			mapzone="Dustwallow Marsh",
			level=39,
			mapnote=26308170,
		}, {
			"Go south to "..cl(55,31),
			"	a. Kill Risen Husks",
			"	b. Kill Risen Spirits",
			"	c. Gather 10 Information",
			completion={{questgoal={"*","Information Gathered",10}}},
			mapzone="Dustwallow Marsh",
			level=39,
			mapnote=31008600,
		}, {
			"Go north to "..cl(55,26),
			"	a. Talk to Mordant Grimsby",
			"		i. Turn in "..cq("What's Haunting Witch Hill?"),
			"		ii. Accept "..cq("The Witch's Bane"),
			completion={{questturnedin="What's Haunting Witch Hill?"},{questaccepted="The Witch's Bane"}},
			mapzone="Dustwallow Marsh",
			level=39,
			mapnote=26308170,
		}, {
			"Go southeast to "..cl(56,27),
			"	a. Click Witchbane plants",
			"	b. Get 9 Witchbane",
			completion={{questgoal={"*","Witchbane",9}}},
			mapzone="Dustwallow Marsh",
			level=39,
			mapnote=27008300,
		}, {
			"Go northwest to "..cl(55,26),
			"	a. Talk to Mordant Grimsby",
			"		i. Turn in "..cq("The Witch's Bane"),
			"		ii. Accept "..cq("Cleansing Witch Hill"),
			completion={{questturnedin="The Witch's Bane"},{questaccepted="Cleansing Witch Hill"}},
			mapzone="Dustwallow Marsh",
			level=39,
			mapnote=26308170,
		}, {
			"Use the torch while standing at the end of the dock right outside",
			"	a. A flying demon will appear",
			"	b. Kill Zelfrax",
			"	c. Cleanse Witch Hill",
			completion={{questgoal={"*","Witch Hill Cleansed",1}}},
			mapzone="Dustwallow Marsh",
			level=39,
		}, {
			"Go to "..cl(55,26),
			"	a. Talk to Mordant Grimsby",
			"		i. Turn in "..cq("Cleansing Witch Hill"),
			completion={{questturnedin="Cleansing Witch Hill"}},
			mapzone="Dustwallow Marsh",
			level=39,
			mapnote=26308170,
		}, {
			"Go west to "..cl(47,23),
			"	a. Talk to Sergeant Lukas",
			"		i. Accept "..cq("Raptor Captor"),
			completion={{questaccepted="Raptor Captor"}},
			mapzone="Dustwallow Marsh",
			level=39,
			mapnote=23106980,
		}, {
			"Go north to "..cl(47,19),
			"	a. Fight Bloodfen Screechers and Bloodfen Raptors",
			"	b. Use your Sturdy Rope on the raptors when they are almost dead",
			"		i. You will see a message in your chat window letting you know when you can capture the raptor",
			"	c. Do not kill the raptors or you won't be able to capture them",
			"	d. Capture 6 Raptors",
			completion={{questgoal={"*","Raptors Captured",6}}},
			mapzone="Dustwallow Marsh",
			level=39,
			mapnote=19006600,
		}, {
			"Go north to "..cl(47,18),
			"	a. Talk to 'Stinky' Ignatz",
			"		i. Accept "..cq("Stinky's Escape"),
			"	b. Escort 'Stinky' Ignatz",
			completion={{questaccepted="Stinky's Escape"}},
			mapzone="Dustwallow Marsh",
			level=39,
			mapnote=17506440,
		}, {
			"Go south to "..cl(47,23),
			"	a. Talk to Sergeant Lukas",
			"		i. Turn in "..cq("Raptor Captor"),
			"		ii. Accept "..cq("Prisoners of the Grimtotems"),
			"		iii. Accept "..cq("Unleash the Raptors"),
			completion={{questturnedin="Raptor Captor"},{questaccepted="Prisoners of the Grimtotems"},{questaccepted="Unleash the Raptors"}},
			mapzone="Dustwallow Marsh",
			level=39,
			mapnote=23106980,
		}, {
			"Go northwest to "..cl(44,16),
			"	a. Kill Grimtotem mobs",
			"	b. Get Grimtotem Keys",
			"	c. Click the Blackhoof Cages",
			"	d. Free 5 Theramore Prisoners",
			completion={{questgoal={"*","Theramore Prisoners Freed",5}}},
			mapzone="Dustwallow Marsh",
			level=39,
			mapnote=16006000,
		}, {
			"Go northwest to "..cl(42,12),
			"	a. Use your Raptor Bait next to the windmill",
			"	b. Release the Raptors",
			completion={{questgoal={"*","Raptors Released",1}}},
			mapzone="Dustwallow Marsh",
			level=39,
			mapnote=12005400,
		}, {
			"Go southeast to "..cl(47,23),
			"	a. Talk to Sergeant Lukas",
			"		i. Turn in "..cq("Unleash the Raptors"),
			"		ii. Turn in "..cq("Prisoners of the Grimtotems"),
			completion={{questturnedin="Unleash the Raptors"},{questturnedin="Prisoners of the Grimtotems"}},
			mapzone="Dustwallow Marsh",
			level=39,
			mapnote=23106980,
		}, {
			"Grind to level 40",
			completion={{level=40}},
			mapzone="Dustwallow Marsh",
			level=39,
		}
	  },
	},
	{ sectiontitle = "Levels (40-45)",
	  steps = {
		{
			"Go west to "..cl(35,23),
			"	a. Kill Darkmist spiders",
			"	b. Get 20 Unpopped Darkmist Eyes",
			completion={{questgoal={"*","Unpopped Darkmist Eye",20}}},
			mapzone="Dustwallow Marsh",
			level=40,
			mapnote=23005810,
		}, {
			"Go southwest to "..cl(30,48),
			"	a. Talk to Inspector Tarem",
			"		i. Turn in "..cq("Inspecting the Ruins"),
			"	b. Click the Suspicious Hoofprints'",
			"		i. Accept "..cq("Suspicious Hoofprints"),
			completion={{questturnedin="Inspecting the Ruins"},{questaccepted="Suspicious Hoofprints"}},
			mapzone="Dustwallow Marsh",
			level=40,
			mapnote=47607730,
		}, {
			"Also at "..cl(30,48),	
			"	a. Click the Theramore Guard Badge",
			"		i. Accept "..cq("Lieutenant Paval Reethe part 1"),
			completion={{questaccepted="Lieutenant Paval Reethe part 1"}},
			mapzone="Dustwallow Marsh",
			level=40,
			mapnote=48307810,
		}, {	
			"Also at "..cl(30,48),	
			"	a. Click the Black Shield",
			"		i. Accept "..cq("The Black Shield part 1"),
			completion={{questaccepted="The Black Shield part 1"}},
			mapzone="Dustwallow Marsh",
			level=40,
			mapnote=48607820,
		}, {
			"Go southeast to Mudsprocket",
			completion={{location={mapzone="Dustwallow Marsh",x=42.0,y=73.3, dist=2}}},
			mapzone="Dustwallow Marsh",
			level=40,
		}, {
			"Go to "..cl(43,72),
			"	a. Talk to Dyslix Silvergrub",
			"		i. Get the Mudsprocket Flight Path",
			completion={{flightpath="Mudsprocket"}},
			mapzone="Dustwallow Marsh",
			level=40,
			mapnote=72411520,
		}, {
			"Go to "..cl(42,73),
			"	a. Talk to Drazzit Dripvalve",
			"		i. Turn in "..cq("Mission to Mudsprocket"),
			completion={{questturnedin="Mission to Mudsprocket"}},
			mapzone="Dustwallow Marsh",
			level=40,
			mapnote=72911520,
		}, {
			"Also at "..cl(42,73),
			"	a. Click the Wanted Poster",
			"		i. Accept "..cq("WANTED: Goreclaw the Ravenous"),
			completion={{questaccepted="WANTED: Goreclaw the Ravenous"}},
			mapzone="Dustwallow Marsh",
			level=40,
			mapnote=73111490,
		}, {
			"Go to "..cl(42,74),
			"	a. Talk to Brogg",
			"		i. Accept "..cq("Bloodfen Feathers"),
			completion={{questaccepted="Bloodfen Feathers"}},
			mapzone="Dustwallow Marsh",
			level=40,
			mapnote=74011590,
		}, {
			"Go to "..cl(42,73),
			"	a. Talk to Gizzix Grimegurgle",
			"		i. Accept "..cq("Catch a Dragon by the Tail"),
			completion={{questaccepted="Catch a Dragon by the Tail"}},
			mapzone="Dustwallow Marsh",
			level=40,
			mapnote=73011450,
		}, {
			"Go northeast to "..cl(46,57),
			"	a. Talk to Tabetha",
			"		i. Turn in "..cq("Tabetha's Farm"),
			"	b. Talk to Apprentice Morlann",
			"		i. Accept "..cq("The Zeppelin Crash"),
			completion={{questturnedin="Tabetha's Farm"},{questaccepted="The Zeppelin Crash"}},
			mapzone="Dustwallow Marsh",
			level=40,
			mapnote=57210330,
		}, {
			"Go east to "..cl(54,57),
			"	a. Talk to Moxie Steelgrille",
			"		i. Turn in "..cq("The Zeppelin Crash"),
			"		ii. Accept "..cq("Corrosion Prevention"),
			"		iii. Accept "..cq("Secure the Cargo!"),
			completion={{questturnedin="The Zeppelin Crash"},{questaccepted="Corrosion Prevention"},{questaccepted="Secure the Cargo!"}},
			mapzone="Dustwallow Marsh",
			level=40,
			mapnote=56911050,
		}, {
			"Go west to "..cl(53,56),
			"	a. Click the Zeppelin Cargo",
			"	b. Get 8 Zeppelin Cargo",
			"	c. Use your Ooze Buster on oozes",
			"		i. You have to be near a Power Core Fragment (the things that connect lightning to you)",
			"	d. Dissolve 10 Oozes",
			completion={{questgoal={"*","Zeppelin Cargo",8}},{questgoal={"*","Oozes Dissolved",10}}},
			mapzone="Dustwallow Marsh",
			level=40,
			mapnote=56010900,
		}, {
			"Go east to "..cl(54,57),
			"	a. Talk to Moxie Steelgrille",
			"		i. Turn in "..cq("Corrosion Prevention"),
			"		ii. Turn in "..cq("Secure the Cargo!"),
			"		iii. Accept "..cq("Delivery for Drazzit"),
			completion={{questturnedin="Corrosion Prevention"},{questturnedin="Secure the Cargo!"},{questaccepted="Delivery for Drazzit"}},
			mapzone="Dustwallow Marsh",
			level=40,
			mapnote=56911050,
		}, {
			"Go northeast to "..cl(54,56),
			"	a. Click the Gizmorium Shipping Crate",
			"	b. Get the Seaforium Booster",
			completion={{questgoal={"*","Seaforium Booster",1}}},
			mapzone="Dustwallow Marsh",
			level=40,
			mapnote=56511060,
		}, {
			"Go east to "..cl(55,58),
			"	a. The path down to Nat Pagle starts here",
			completion={{location={mapzone="Dustwallow Marsh",x=54.6,y=58.1, dist=0.5}}},
			mapzone="Dustwallow Marsh",
			level=40,
			mapnote=58111280,
		}, {
			"Go southeast to "..cl(59,60),
			"	a. Talk to Nat Pagle",
			"		i. Turn in "..cq("Is it Real?"),
			"		ii. Accept "..cq("Nat's Bargain"),
			completion={{questturnedin="Is it Real?"},{questaccepted="Nat's Bargain"}},
			mapzone="Dustwallow Marsh",
			level=40,
			mapnote=60011850,
		}, {
			"Go west to "..cl(56,62),
			"	a. Use Pagle's Fish Paste, Extra Strength",
			"	b. Kill the Lurking Shark",
			"	c. Test the Fish Paste",
			completion={{questgoal={"*","Fish Paste Tested",1}}},
			mapzone="Dustwallow Marsh",
			level=40,
			mapnote=62011820,
		}, {
			"Go east to "..cl(59,60),
			"	a. Talk to Nat Pagle",
			"		i. Turn in "..cq("Nat's Bargain"),
			"		ii. Accept "..cq("Oh, It's Real"),
			completion={{questturnedin="Nat's Bargain"},{questaccepted="Oh, It's Real"}},
			mapzone="Dustwallow Marsh",
			level=40,
			mapnote=60011850,
		}, {
			"Hearth to Theramore",
			completion={{location={mapzone="Dustwallow Marsh",x=67.5,y=50.3, dist=9}}},
			mapzone="Dustwallow Marsh",
			level=40,
		}, {
			"Go to "..cl(66,45),
			"	a. Talk to Morgan Stern",
			"		i. Turn in "..cq("Mudrock Soup and Bugs"),
			"		ii. Turn in "..cq("Stinky's Escape"),
			completion={{questturnedin="Mudrock Soup and Bugs"},{questturnedin="Stinky's Escape"}},
			mapzone="Dustwallow Marsh",
			level=40,
			mapnote=45511180,
		}, {
			"Go to "..cl(65,47),
			"	a. Talk to the Lieutenant Aden",
			"		i. Turn in "..cq("The Orc Report"),
			"		ii. Accept "..cq("Captain Vimes"),
			completion={{questturnedin="The Orc Report"},{questaccepted="Captain Vimes"}},
			mapzone="Dustwallow Marsh",
			level=40,
			mapnote=47111220,
		}, {
			"Go to "..cl(68,49),
			"	a. Talk to Captain Garran Vimes",
			"		i. Turn in "..cq("Captain Vimes"),
			"		ii. Turn in "..cq("Lieutenant Paval Reethe part 1"),
			"		iii. Accept "..cq("Lieutenant Paval Reethe part 2"),
			"		iv. Turn in "..cq("The Black Shield part 1"),
			"		v. Accept "..cq("The Black Shield part 2"),
			"		vi. Turn in "..cq("Suspicious Hoofprints"),
			completion={{questturnedin="Captain Vimes"},{questturnedin="Lieutenant Paval Reethe part 1"},{questaccepted="Lieutenant Paval Reethe part 2"},{questturnedin="The Black Shield part 1"},{questaccepted="The Black Shield part 2"},{questturnedin="Suspicious Hoofprints"}},
			mapzone="Dustwallow Marsh",
			level=40,
			mapnote=48611680,
		}, {
			"Go to "..cl(68,48),
			"	a. Talk to Adjutant Tesoran",
			"		i. Turn in "..cq("Lieutenant Paval Reethe part 2"),
			"		ii. Accept "..cq("Daelin's Men"),
			completion={{questturnedin="Lieutenant Paval Reethe part 2"},{questaccepted="Daelin's Men"}},
			mapzone="Dustwallow Marsh",
			level=40,
			mapnote=48111610,
		}, {
			"Go to "..cl(68,49),
			"	a. Talk to Captain Garran Vimes",
			"		i. Turn in "..cq("Daelin's Men"),
			"		ii. Accept "..cq("The Deserters part 1"),
			completion={{questturnedin="Daelin's Men"},{questaccepted="The Deserters part 1"}},
			mapzone="Dustwallow Marsh",
			level=40,
			mapnote=48611680,
		}, {
			"Go to "..cl(70,51),
			"	a. Talk to Major Mills",
			"		i. Turn in "..cq("Oh, It's Real"),
			"		ii. Accept "..cq("Take Down Tethyr!"),
			completion={{questturnedin="Oh, It's Real"},{questaccepted="Take Down Tethyr!"}},
			mapzone="Dustwallow Marsh",
			level=40,
			mapnote=51212090,
		}, {
			"A huge monster will spawn in the water",
			"	a. Run around on the dock clicking the big blue cannons until the big monster dies",
			completion={{questgoal={"*","Defend Theramore Docks from Tethyr",1}}},
			mapzone="Dustwallow Marsh",
			level=40,
		}, {
			"Go to "..cl(70,51),
			"	a. Talk to Major Mills",
			"		i. Turn in "..cq("Take Down Tethyr!"),
			completion={{questturnedin="Take Down Tethyr!"}},
			mapzone="Dustwallow Marsh",
			level=40,
		}, {
			"Go to "..cl(65,50),
			"	a. Talk to Caz Twosprocket",
			"		i. Turn in "..cq("The Black Shield part 2"),
			"		ii. Accept "..cq("The Black Shield part 3"),
			completion={{questturnedin="The Black Shield part 2"},{questaccepted="The Black Shield part 3"}},
			mapzone="Dustwallow Marsh",
			level=40,
			mapnote=50411520,
		}, {
			"Go to "..cl(68,49),
			"	a. Talk to Captain Garran Vimes",
			"		i. Turn in "..cq("The Black Shield part 3"),
			completion={{questturnedin="The Black Shield part 3"}},
			mapzone="Dustwallow Marsh",
			level=40,
			mapnote=48611680,
		}, {
			"Go northwest to "..cl(55,26),
			"	a. Talk to 'Swamp Eye' Jarl",
			"		i. Turn in "..cq("Jarl Needs Eyes"),
			completion={{questturnedin="Jarl Needs Eyes"}},
			mapzone="Dustwallow Marsh",
			level=40,
			mapnote=26308170,
		}, {
			"Go southeast to Theramore",
			completion={{location={mapzone="Dustwallow Marsh",x=67.5,y=50.3, dist=9}}},
			mapzone="Dustwallow Marsh",
			level=40,
		}, {
			"Fly to Mudsprocket",
			completion={{location={mapzone="Dustwallow Marsh",x=42.0,y=73.3, dist=2}}},
			mapzone="Dustwallow Marsh",
			level=40,
		}, {
			"Go to "..cl(42,73),
			"	a. Talk to Drazzit Dripvalve",
			"		i. Turn in "..cq("Delivery for Drazzit"),
			completion={{questturnedin="Delivery for Drazzit"}},
			mapzone="Dustwallow Marsh",
			level=40,
			mapnote=72911520,
		}, {
			"Go northwest to 36,54 ",
			"	a. Fight Balos Jacken until he surrenders",
			"	b. Talk to Balos Jacken",
			"		i. Turn in "..cq("The Deserters part 1"),
			"		ii. Accept "..cq("The Deserters part 2"),
			completion={{questturnedin="The Deserters part 1"},{questaccepted="The Deserters part 2"}},
			mapzone="Dustwallow Marsh",
			level=40,
			mapnote=54309040,
		}, {
			"Go south to "..cl(35,65),
			"	a. Kill raptors",
			"	b. Get 5 Bloodfen Feathers",
			completion={{questgoal={"*","Bloodfen Feather",5}}},
			mapzone="Dustwallow Marsh",
			level=40,
			mapnote=65010000,
		}, {
			"Go southwest to "..cl(32,66),
			"	a. Kill Goreclaw the Ravenous",
			completion={{questgoal={"*","Goreclaw the Ravenous slain",1}}},
			mapzone="Dustwallow Marsh",
			level=40,
			mapnote=65709770,
		}, {
			"Go southeast to Mudsprocket",
			completion={{location={mapzone="Dustwallow Marsh",x=42.0,y=73.3, dist=2}}},
			mapzone="Dustwallow Marsh",
			level=40,
		}, {
			"Go to "..cl(42,73),
			"	a. Talk to Drazzit Dripvalve",
			"		i. Turn in "..cq("WANTED: Goreclaw the Ravenous"),
			completion={{questturnedin="WANTED: Goreclaw the Ravenous"}},
			mapzone="Dustwallow Marsh",
			level=40,
			mapnote=72911520,
		}, {
			"Go to "..cl(42,74),
			"	a. Talk to Brogg",
			"		i. Turn in "..cq("Bloodfen Feathers"),
			"		ii. Accept "..cq("Banner of the Stonemaul"),
			"		iii. Accept "..cq("The Essence Enmity"),
			completion={{questturnedin="Bloodfen Feathers"},{questaccepted="Banner of the Stonemaul"},{questaccepted="The Essence Enmity"}},
			mapzone="Dustwallow Marsh",
			level=40,
			mapnote=74011590,
		}, {
			"Go northwest to "..cl(39,66),
			"	a. Kill Firemane mobs",
			"	b. Use Brogg's Totem on their corpses",
			"	c. Get 10 Black Dragonkin Essences",
			completion={{questgoal={"*","Black Dragonkin Essence",10}}},
			mapzone="Dustwallow Marsh",
			level=40,
			mapnote=66010500,
		}, {
			"Grind to level 41",
			completion={{level=41}},
			mapzone="Dustwallow Marsh",
			level=40,
		}, {
			"Go southwest to 38,69 inside the cave",
			"	a. Click the Stonemaul Banner",
			"	b. Get the Stonemaul Banner",
			completion={{questgoal={"*","Stonemaul Banner",1}}},
			mapzone="Dustwallow Marsh",
			level=41,
			mapnote=69410750,
		}, {
			"Go southeast to Mudsprocket",
			completion={{location={mapzone="Dustwallow Marsh",x=42.0,y=73.3, dist=2}}},
			mapzone="Dustwallow Marsh",
			level=41,
		}, {
			"Go to "..cl(42,74),
			"	a. Talk to Brogg",
			"		i. Turn in "..cq("Banner of the Stonemaul"),
			"		ii. Turn in "..cq("The Essence of Enmity"),
			"		iii. Accept "..cq("Spirits of Stonemaul Hold"),
			completion={{questturnedin="Banner of the Stonemaul"},{questturnedin="The Essence of Enmity"},{questaccepted="Spirits of Stonemaul Hold"}},
			mapzone="Dustwallow Marsh",
			level=41,
			mapnote=74011590,
		}, {
			"Go east to "..cl(46,74),
			"	a. Click the Wyrmtails",
			"	b. Get 8 Wyrmtails",
			completion={{questgoal={"*","Wyrmtail",8}}},
			mapzone="Dustwallow Marsh",
			level=41,
			mapnote=74012000,
		}, {
			"Go north to "..cl(46,69),
			"	a. Click the Ogre Remains",
			"	b. Kill the Ogre Spirits",
			"	c. Lay 10 Stonemaul Spirits to rest",
			completion={{questgoal={"*","Stonemaul Spirits laid to rest",10}}},
			mapzone="Dustwallow Marsh",
			level=41,
			mapnote=69011500,
		}, {
			"Go southwest to Mudsprocket",
			completion={{location={mapzone="Dustwallow Marsh",x=42.0,y=73.3, dist=2}}},
			mapzone="Dustwallow Marsh",
			level=41,
		}, {
			"Go to "..cl(42,73),
			"	a. Talk to Gizzix Grimegurgle",
			"		i. Turn in "..cq("Catch a Dragon by the Tail"),
			completion={{questturnedin="Catch a Dragon by the Tail"}},
			mapzone="Dustwallow Marsh",
			level=41,
			mapnote=73011450,
		}, {
			"Go to "..cl(42,74),
			"	a. Talk to Brogg",
			"		i. Turn in "..cq("Spirits of Stonemaul Hold"),
			"		ii. Accept "..cq("Challenge to the Black Flight"),
			completion={{questturnedin="Spirits of Stonemaul Hold"},{questaccepted="Challenge to the Black Flight"}},
			mapzone="Dustwallow Marsh",
			level=41,
			mapnote=74011590,
		}, {
			"Go east to "..cl(52,76),
			"	a. Use your Stonemaul Banner at the foot of the stone ramp",
			"		i. A dragon will appear",
			"	b. Kill Smolderwing",
			"	c. Avenge the Stonemaul Clan",
			completion={{questgoal={"*","Stonemaul Clan Avenged",1}}},
			mapzone="Dustwallow Marsh",
			level=41,
			mapnote=75812790,
		}, {
			"Go west to Mudsprocket",
			completion={{location={mapzone="Dustwallow Marsh",x=42.0,y=73.3, dist=2}}},
			mapzone="Dustwallow Marsh",
			level=41,
		}, {
			"Go to "..cl(42,74),
			"	a. Talk to Brogg",
			"		i. Turn in "..cq("Challenge to the Black Flight"),
			completion={{questturnedin="Challenge to the Black Flight"}},
			mapzone="Dustwallow Marsh",
			level=41,
			mapnote=74011590,
		}, {
			"Go northeast to "..cl(46,57),
			"	a. Talk to Apprentice Morlann",
			"		i. Accept "..cq("Direhorn Raiders"),
			"	b. Talk to Apprentice Garion",
			"		i. Accept "..cq("The Reagent Thief"),
			completion={{questaccepted="Direhorn Raiders"},{questaccepted="The Reagent Thief"}},
			mapzone="Dustwallow Marsh",
			level=41,
			mapnote=57210330,
		}, {
			"Go north to "..cl(45,54),
			"	a. Kill Darkfang Creepers",
			"	b. Kill Noxious Shredders",
			"	c. Get 6 Marsh Venom",
			completion={{questgoal={"*","Marsh Venom",6}}},
			mapzone="Dustwallow Marsh",
			level=41,
			mapnote=54009900,
		}, {
			"Go north to "..cl(47,50),
			"	a. Kill Grimtotem mobs",
			"	b. Kill 12 Direhorn Grimtotems",
			completion={{questgoal={"*","Direhorn Grimtotems killed",12}}},
			mapzone="Dustwallow Marsh",
			level=41,
			mapnote=50009700,
		}, {
			"Go north to "..cl(47,47),
			"	a. Kill Apothecary Cylla",
			"	b. Get the Sealed Letter",
			"	c. Click the Sealed Letter",
			"		i. Accept "..cq("The Apothecary's Letter"),
			completion={{questaccepted="The Apothecary's Letter"}},
			mapzone="Dustwallow Marsh",
			level=41,
			mapnote=46609380,
		}, {
			"Go south to "..cl(45,58),
			"	a. Talk to Andello Porter",
			"		i. Turn in "..cq("The Apothecary's Letter"),
			completion={{questturnedin="The Apothecary's Letter"}},
			mapzone="Dustwallow Marsh",
			level=41,
		}, {
			"Go to "..cl(46,57),
			"	a. Talk to Apprentice Garion",
			"		i. Turn in "..cq("The Reagent Thief"),
			"	b. Talk to Apprentice Morlann",
			"		i. Turn in "..cq("Direhorn Raiders"),
			completion={{questturnedin="The Reagent Thief"},{questturnedin="Direhorn Raiders"}},
			mapzone="Dustwallow Marsh",
			level=41,
			mapnote=57210330,
		}, {
			"Hearth to Theramore",
			completion={{location={mapzone="Dustwallow Marsh",x=67.5,y=50.3, dist=9}}},
			mapzone="Dustwallow Marsh",
			level=41,
		}, {
			"Go to "..cl(68,49),
			"	a. Talk to Captain Garran Vimes",
			"		i. Turn in "..cq("The Deserters part 2"),
			completion={{questturnedin="The Deserters part 2"}},
			mapzone="Dustwallow Marsh",
			level=41,
			mapnote=48611680,
		}, {
			"Fly to Gadgetzan",
			completion={{location={mapzone="Tanaris",x=51.7,y=27.8, dist=6}}},
			mapzone="Dustwallow Marsh",
			level=41,
		}, {
			"Go north to Thousand Needles",
			completion={{location={mapzone="Thousand Needles"}}},
			mapzone="Tanaris",
			level=41,
		}, {
			"Go northeast to "..cl(80,76),
			"	a. Talk to Razzeric",
			"		i. Turn in "..cq("Razzeric's Tweaking"),
			"		ii. Accept "..cq("Safety First part 1"),
			completion={{questturnedin="Razzeric's Tweaking"},{questaccepted="Safety First part 1"}},
			mapzone="Thousand Needles",
			level=41,
			mapnote=75915610,
		}, {
			"Go southwest to Tanaris",
			completion={{location={mapzone="Tanaris"}}},
			mapzone="Thousand Needles",
			level=41,
		}, {
			"Go to "..cl(51,27),
			"	a. Talk to Shreev",
			"		i. Turn in "..cq("Safety First part 1"),
			"		ii. Accept "..cq("Safety First part 2"),
			completion={{questturnedin="Safety First part 1"},{questaccepted="Safety First part 2"}},
			mapzone="Tanaris",
			level=41,
			mapnote=27207820,
		}, {
			"Go north to Thousand Needles",
			completion={{location={mapzone="Thousand Needles"}}},
			mapzone="Tanaris",
			level=41,
		}, {
			"Go northeast to "..cl(80,76),
			"	a. Talk to Razzeric",
			"		i. Turn in "..cq("Safety First part 2"),
			completion={{questturnedin="Safety First part 2"}},
			mapzone="Thousand Needles",
			level=41,
			mapnote=75915610,
		}, {
			"Go southwest to Tanaris",
			completion={{location={mapzone="Tanaris"}}},
			mapzone="Thousand Needles",
			level=41,
		}, {
			"Fly to Ratchet",
			completion={{location={mapzone="The Barrens",x=63.0,y=38.1, dist=2}}},
			mapzone="Tanaris",
			level=41,
		}, {
			"Ride the boat to Booty Bay",
			completion={{location={mapzone="Stranglethorn Vale",x=27.7,y=74.6, dist=6}}},
			mapzone="The Barrens",
			level=41,
		}, {
			"Go to "..cl(28,76),
			"	a. Talk to First Mate Crazz",
			"		i. Accept "..cq("The Bloodsail Buccaneers part 1"),
			completion={{questaccepted="The Bloodsail Buccaneers part 1"}},
			mapzone="Stranglethorn Vale",
			level=41,
			mapnote=76210430,
		}, {
			"Go to "..cl(28,77),
			"	a. Talk to 'Sea Wolf' MacKinley",
			"		i. Accept "..cq("Scaring Shaky"),
			completion={{questaccepted="Scaring Shaky"}},
			mapzone="Stranglethorn Vale",
			level=41,
			mapnote=77110490,
		}, {
			"Make Booty Bay your home",
			completion={{home="Booty Bay"}},
			mapzone="Stranglethorn Vale",
			level=41,
		}, {
			"Go to "..cl(27,77),
			"	a. Talk to Crank Fizzlebub",
			"		i. Accept "..cq("Venture Company Mining"),
			completion={{questaccepted="Venture Company Mining"}},
			mapzone="Stranglethorn Vale",
			level=41,
			mapnote=77210430,
		}, {
			"Also at "..cl(27,77),	
			"	a. Talk to Krazek",
			"		i. Turn in "..cq("The Rumormonger"),
			completion={{questturnedin="The Rumormonger"}},
			mapzone="Stranglethorn Vale",
			level=41,
			mapnote=77210410,
		}, {
			"Also at "..cl(27,77),
			"	a. Talk to Kebok",
			"		i. Accept "..cq("Skullsplitter Tusks"),
			completion={{questaccepted="Skullsplitter Tusks"}},
			mapzone="Stranglethorn Vale",
			level=41,
			mapnote=77110410,
		}, {	
			"Also at "..cl(27,77),
			"	a. Talk to Fleet Master Seahorn",
			"		i. Turn in "..cq("Sunken Treasure part 4"),
			completion={{questturnedin="Sunken Treasure part 4"}},
			mapzone="Stranglethorn Vale",
			level=41,
			mapnote=77010420,
		}, {
			"Go north to "..cl(33,40),
			"	a. Kill 10 Jungle Stalkers",
			completion={{questgoal={"*","Jungle Stalker slain",10}}},
			mapzone="Stranglethorn Vale",
			level=41,
			mapnote=40407300,
		}, {
			"Go east to "..cl(41,42),
			"	a. Kill goblins",
			"	b. Get 10 Singing Blue Crystals",
			completion={{questgoal={"*","Singing Blue Crystal",10}}},
			mapzone="Stranglethorn Vale",
			level=41,
			mapnote=42308370,
		}, {
			"Grind to level 42",
			completion={{level=42}},
			mapzone="Stranglethorn Vale",
			level=41,
		}, {
			"Go north to "..cl(43,37),
			"	a. Kill Skullsplitter trolls",
			"	b. Get 18 Skullsplitter Tusks",
			completion={{questgoal={"*","Skullsplitter Tusk",18}}},
			mapzone="Stranglethorn Vale",
			level=42,
			mapnote=36707920,
		}, {
			"Go northeast to "..cl(49,20),
			"	a. Kill Bhag'thera",
			"	b. Get the Fang of Bhag'thera",
			completion={{questgoal={"*","Fang of Bhag'thera",1}}},
			mapzone="Stranglethorn Vale",
			level=42,
			mapnote=20006880,
		}, {
			"Go southwest to "..cl(40,29),
			"	a. Kill Snapjaw Crocolisks",
			"	b. Get 5 Snapjaw Crocolisk Skins",
			completion={{questgoal={"*","Snapjaw Crocolisk Skin",5}}},
			mapzone="Stranglethorn Vale",
			level=42,
			mapnote=29006900,
		}, {
			"Go west to "..cl(22,25),
			"	a. Kill water elementals",
			"	b. Get 6 Water Elemental Bracers",
			completion={{questgoal={"*","Water Elemental Bracers",6}}},
			mapzone="Stranglethorn Vale",
			level=42,
			mapnote=25004670,
		}, {
			"Hearth to Booty Bay",
			completion={{location={mapzone="Stranglethorn Vale",x=27.7,y=74.6, dist=6}}},
			mapzone="Stranglethorn Vale",
			level=42,
		}, {
			"Go to "..cl(27,77),
			"	a. Talk to Crank Fizzlebub",
			"		i. Turn in "..cq("Venture Company Mining"),
			completion={{questturnedin="Venture Company Mining"}},
			mapzone="Stranglethorn Vale",
			level=42,
			mapnote=77210430,
		}, {
			"Also at "..cl(27,77),	
			"	a. Talk to Kebok",
			"		i. Turn in "..cq("Skullsplitter Tusks"),
			completion={{questturnedin="Skullsplitter Tusks"}},
			mapzone="Stranglethorn Vale",
			level=42,
			mapnote=77110410,
		}, {
			"Also at "..cl(27,77),
			"	a. Talk to Baron Revilgaz",
			"		i. Turn in "..cq("Water Elementals"),
			completion={{questturnedin="Water Elementals"}},
			mapzone="Stranglethorn Vale",
			level=42,
			mapnote=77010420,
		}, {
			"Go to "..cl(28,78),
			"	a. Talk to Drizzlik",
			"		i. Turn in "..cq("Some Assembly Required"),
			"		ii. Accept "..cq("Excelsior"),
			completion={{questturnedin="Some Assembly Required"},{questaccepted="Excelsior"}},
			mapzone="Stranglethorn Vale",
			level=42,
			mapnote=77610590,
		}, {
			"Go north to "..cl(27,70),
			"	a. Click the Bloodsail Correspondence",
			"		i. Turn in "..cq("The Bloodsail Buccaneers part 1"),
			"		ii. Accept "..cq("The Bloodsail Buccaneers part 2"),
			completion={{questturnedin="The Bloodsail Buccaneers part 1"},{questaccepted="The Bloodsail Buccaneers part 2"}},
			mapzone="Stranglethorn Vale",
			level=42,
			mapnote=69509680,
		}, {
			"Go northeast to "..cl(32,67),
			"	a. Kill gorillas",
			"	b. Get 5 Mistvale Giblets",
			completion={{questgoal={"*","Mistvale Giblets",5}}},
			mapzone="Stranglethorn Vale",
			level=42,
			mapnote=66809900,
		}, {
			"Go southwest to Booty Bay",
			completion={{location={mapzone="Stranglethorn Vale",x=27.7,y=74.6, dist=6}}},
			mapzone="Stranglethorn Vale",
			level=42,
		}, {
			"Go to "..cl(27,74),
			"	a. Talk to 'Shaky' Phillipe",
			"		i. Turn in "..cq("Scaring Shaky"),
			"		ii. Accept "..cq("Return to MacKinley"),
			completion={{questturnedin="Scaring Shaky"},{questaccepted="Return to MacKinley"}},
			mapzone="Stranglethorn Vale",
			level=42,
			mapnote=73610050,
		}, {
			"Go to "..cl(28,76),
			"	a. Talk to First Mate Crazz",
			"		i. Turn in "..cq("The Bloodsail Buccaneers part 2"),
			"		ii. Accept "..cq("The Bloodsail Buccaneers part 3"),
			completion={{questturnedin="The Bloodsail Buccaneers part 2"},{questaccepted="The Bloodsail Buccaneers part 3"}},
			mapzone="Stranglethorn Vale",
			level=42,
			mapnote=76210430,
		}, {
			"Go to "..cl(28,77),
			"	a. Talk to 'Sea Wolf' MacKinley",
			"		i. Turn in "..cq("Return to MacKinley"),
			"		ii. Accept "..cq("Voodoo Dues"),
			completion={{questturnedin="Return to MacKinley"},{questaccepted="Voodoo Dues"}},
			mapzone="Stranglethorn Vale",
			level=42,
			mapnote=77110490,
		}, {
			"Go to "..cl(27,77),
			"	a. Talk to Deeg",
			"		i. Accept "..cq("Up to Snuff"),
			completion={{questaccepted="Up to Snuff"}},
			mapzone="Stranglethorn Vale",
			level=42,
			mapnote=77310420,
		}, {
			"Also at "..cl(27,77),
			"	a. Talk to Fleet Master Seahorn",
			"		i. Turn in "..cq("The Bloodsail Buccaneers part 3"),
			"		ii. Accept "..cq("The Bloodsail Buccaneers part 4"),
			completion={{questturnedin="The Bloodsail Buccaneers part 3"},{questaccepted="The Bloodsail Buccaneers part 4"}},
			mapzone="Stranglethorn Vale",
			level=42,
			mapnote=77010420,
		}, {
			"Fly to the Rebel Camp",
			completion={{location={mapzone="Stranglethorn Vale",x=38.0,y=3.7, dist=2}}},
			mapzone="Stranglethorn Vale",
			level=42,
		}, {
			"Go southwest to "..cl(36,11),
			"	a. Talk to Sir S. J. Erlgadin",
			"		i. Turn in "..cq("Panther Mastery part 4"),
			"	b. Talk to Hemet Nesingwary Jr.",
			"		i. Turn in "..cq("Raptor Mastery part 3"),
			"		ii. Accept "..cq("Raptor Mastery part 4"),
			completion={{questturnedin="Panther Mastery part 4"},{questturnedin="Raptor Mastery part 3"},{questaccepted="Raptor Mastery part 4"}},
			mapzone="Stranglethorn Vale",
			level=42,
			mapnote=10704650,
		}, {
			"Go southwest to "..cl(25,19),
			"	a. Kill an Elder Saltwater Crocolisk",
			"	b. Get an Elder Crocolisk Skin",
			completion={{questgoal={"*","Elder Crocolisk Skin",1}}},
			mapzone="Stranglethorn Vale",
			level=42,
			mapnote=19004430,
		}, {
			"Hearth to Booty Bay",
			completion={{location={mapzone="Stranglethorn Vale",x=27.7,y=74.6, dist=6}}},
			mapzone="Stranglethorn Vale",
			level=42,
		}, {
			"Go to "..cl(28,78),
			"	a. Talk to Drizzlik",
			"		i. Turn in "..cq("Excelsior"),
			completion={{questturnedin="Excelsior"}},
			mapzone="Stranglethorn Vale",
			level=42,
			mapnote=77610590,
		}, {
			"Fly to Ironforge",
			completion={{location={mapzone="City of Ironforge"}}},
			mapzone="Stranglethorn Vale",
			level=42,
		}, {
			"Buy the following items from the Auction House:",
			"	a. 1 Healing Potion",
			"	b. 1 Lesser Invisibility Potion",
			"	c. 1 Gyrochronatom",
			"	d. 1 Frost Oil",
			mapzone="Ironforge",
			level=42,
		}, {
			"Fly to Thelsamar",
			completion={{location={mapzone="Loch Modan",x=35.1,y=46.9, dist=3}}},
			mapzone="Ironforge",
			level=42,
		}, {
			"Make Thelsamar your home",
			completion={{home="Thelsamar"}},
			mapzone="Loch Modan",
			level=42,
		}, {
			"Go southeast to "..cl(66,66),
			"	a. Talk to Prospector Ironband",
			"		i. Accept "..cq("Find Agmond"),
			completion={{questaccepted="Find Agmond"}},
			mapzone="Loch Modan",
			level=42,
			mapnote=65613150,
		}, {
			"Go southwest to the Badlands",
			completion={{location={mapzone="Badlands"}}},
			mapzone="Loch Modan",
			level=42,
		}, {
			"Go south to "..cl(54,43),
			"	a. Talk to Prospector Ryedol",
			"		i. Accept "..cq("A Dwarf and His Tools"),
			"	b. Talk to Sigrun Ironhew",
			"		i. Accept "..cq("Mirages"),
			completion={{questaccepted="A Dwarf and His Tools"},{questaccepted="Mirages"}},
			mapzone="Badlands",
			level=42,
			mapnote=43309690,
		}, {
			"Go southwest to "..cl(42,53),
			"	a. Talk to Martek the Exiled",
			"		i. Turn in "..cq("Martek the Exiled"),
			"		ii. Accept "..cq("Indurium"),
			completion={{questturnedin="Martek the Exiled"},{questaccepted="Indurium"}},
			mapzone="Badlands",
			level=42,
			mapnote=52709490,
		}, {
			"Go west to "..cl(26,45),
			"	a. Talk to Lotwil Veriatus",
			"		i. Accept "..cq("Study of the Elements: Rock part 1"),
			"		ii. Accept "..cq("Coolant Heads Prevail"),
			"		iii. Turn in "..cq("Coolant Heads Prevail"),
			"		iv. Accept "..cq("Gyro... What?"),
			"		v. Turn in "..cq("Gyro... What?"),
			"	b. Talk to Lucien Tosselwrench",
			"		i. Accept "..cq("Liquid Stone"),
			"		ii. Turn in "..cq("Liquid Stone"),
			completion={{questaccepted="Study of the Elements: Rock part 1"},{questaccepted="Coolant Heads Prevail"},{questturnedin="Coolant Heads Prevail"},{questaccepted="Gyro... What?"},{questturnedin="Gyro... What?"},{questaccepted="Liquid Stone"},{questturnedin="Liquid Stone"}},
			mapzone="Badlands",
			level=42,
			mapnote=44607050,
		}, {
			"Go west to "..cl(22,45),
			"	a. Kill Lesser Rock Elementals",
			"	b. Get 10 Small Stone Shards",
			completion={{questgoal={"*","Small Stone Shard",10}}},
			mapzone="Badlands",
			level=42,
			mapnote=44606650,
		}, {
			"Grind to level 43",
			completion={{level=43}},
			mapzone="Badlands",
			level=42,
		}, {
			"Go east to "..cl(26,45),
			"	a. Talk to Lotwil Veriatus",
			"		i. Turn in "..cq("Study of the Elements: Rock part 1"),
			"		ii. Accept "..cq("Study of the Elements: Rock part 2"),
			completion={{questturnedin="Study of the Elements: Rock part 1"},{questaccepted="Study of the Elements: Rock part 2"}},
			mapzone="Badlands",
			level=43,
			mapnote=44607050,
		}, {
			"Go northeast to "..cl(52,30),
			"	a. Kill Dark Iron dwarves",
			"	b. Get Ryedol's Lucky Pick",
			completion={{questgoal={"*","Ryedol's Lucky Pick",1}}},
			mapzone="Badlands",
			level=43,
			mapnote=30408270,
		}, {
			"Go south to "..cl(53,34),
			"	a. Click the Crumpled Map",
			"		i. Accept "..cq("A Sign of Hope"),
			completion={{questaccepted="A Sign of Hope"}},
			mapzone="Badlands",
			level=43,
			mapnote=33908690,
		}, {
			"Go northeast to "..cl(67,21),
			"	a. Click the Excavation Supply Crate",
			"	b. Get the Supply Crate",
			completion={{questgoal={"*","Supply Crate",1}}},
			mapzone="Badlands",
			level=43,
			mapnote=21508810,
		}, {
			"Go southwest to "..cl(54,43),
			"	a. Talk to Prospector Ryedol",
			"		i. Turn in "..cq("A Sign of Hope"),
			"		ii. Turn in "..cq("A Dwarf and His Tools"),
			"	b. Talk to Sigrun Ironhew",
			"		i. Turn in "..cq("Mirages"),
			"		ii. Accept "..cq("Scrounging"),
			completion={{questturnedin="A Sign of Hope"},{questturnedin="A Dwarf and His Tools"},{questturnedin="Mirages"},{questaccepted="Scrounging"}},
			mapzone="Badlands",
			level=43,
			mapnote=43309690,
		}, {
			"Go southwest to "..cl(51,62),
			"	a. Click the Battered Dwarven Skeleton",
			"		i. Turn in "..cq("Find Agmond"),
			"		ii. Accept "..cq("Murdaloc"),
			completion={{questturnedin="Find Agmond"},{questaccepted="Murdaloc"}},
			mapzone="Badlands",
			level=43,
			mapnote=62411330,
		}, {
			"Go south to "..cl(52,66),
			"	a. Kill 12 Stonevault Bonesnappers",
			"	b. Get 10 Indurium Flakes",
			"	c. Kill Murdaloc",
			completion={{questgoal={"*","Stonevault Bonesnapper slain",12}},{questgoal={"*","Indurium Flake",10}},{questgoal={"*","Murdaloc slain",1}}},
			mapzone="Badlands",
			level=43,
			mapnote=65611740,
		}, {
			"Go southwest to "..cl(46,77),
			"	a. The path up to "..cq("Study of the Elements: Rock part 2"),
			completion={{location={mapzone="Badlands",x=46.3,y=77.1, dist=0.5}}},
			mapzone="Badlands",
			level=43,
			mapnote=77212350,
		}, {
			"Go southwest to "..cl(45,81),
			"	a. Kill Rock Elementals",
			"	b. Get 3 Large Stone Slabs",
			completion={{questgoal={"*","Large Stone Slab",3}}},
			mapzone="Badlands",
			level=43,
			mapnote=80612540,
		}, {
			"Go west to "..cl(13,74),
			"	a. Kill ogres",
			"	b. Get 7 Scrap Metal",
			completion={{questgoal={"*","Scrap Metal",1}}},
			mapzone="Badlands",
			level=43,
			mapnote=78309180,
		}, {
			"Go northeast to "..cl(26,45),
			"	a. Talk to Lotwil Veriatus",
			"		i. Turn in "..cq("Study of the Elements: Rock part 2"),
			"		ii. Accept "..cq("Study of the Elements: Rock part 3"),
			completion={{questturnedin="Study of the Elements: Rock part 2"},{questaccepted="Study of the Elements: Rock part 3"}},
			mapzone="Badlands",
			level=43,
			mapnote=44607050,
		}, {
			"Go southwest to "..cl(9,79),
			"	a. The path up to 'Study of the Elements: Rock part 3' starts here",
			completion={{location={mapzone="Badlands",x=8.7,y=78.7, dist=0.5}}},
			mapzone="Badlands",
			level=43,
			mapnote=78608730,
		}, {
			"Go southwest to "..cl(4,82),
			"	a. Kill Greater Rock Elementals",
			"	b. Get 5 Bracers of Rock Binding",
			completion={{questgoal={"*","Bracers of Rock Binding",5}}},
			mapzone="Badlands",
			level=43,
			mapnote=81508570,
		}, {
			"Go northeast to "..cl(26,45),
			"	a. Talk to Lotwil Veriatus",
			"		i. Turn in "..cq("Study of the Elements: Rock part 3"),
			"		ii. Accept "..cq("This Is Going to Be Hard part 1"),
			"	b. Talk to Lucien Tosselwrench",
			"		i. Turn in "..cq("This Is Going to Be Hard part 1"),
			"		ii. Accept "..cq("This Is Going to Be Hard part 2"),
			"	c. Talk to Lotwil Veriatus",
			"		i. Turn in "..cq("This Is Going to Be Hard part 2"),
			"		ii. Accept "..cq("This Is Going to Be Hard part 3"),
			"	d. Kill the Fam'retor Guardian that spawns",
			"	e. Get Lotwil's Shackles of Elemental Binding",
			"	f. Talk to Lotwil Veriatus",
			"		i. Turn in "..cq("This Is Going to Be Hard part 3"),
			completion={{questturnedin="Study of the Elements: Rock part 3"},{questaccepted="This Is Going to Be Hard part 1"},{questturnedin="This Is Going to Be Hard part 1"},{questaccepted="This Is Going to Be Hard part 2"},{questturnedin="This Is Going to Be Hard part 2"},{questaccepted="This Is Going to Be Hard part 3"},{questturnedin="This Is Going to Be Hard part 3"}},
			mapzone="Badlands",
			level=43,
			mapnote=44607050,
		}, {
			"Go southeast to "..cl(42,53),
			"	a. Talk to Martek the Exiled",
			"		i. Turn in "..cq("Indurium"),
			"		ii. Accept "..cq("News for Fizzle"),
			completion={{questturnedin="Indurium"},{questaccepted="News for Fizzle"}},
			mapzone="Badlands",
			level=43,
			mapnote=52709490,
		}, {
			"Go northeast to "..cl(54,43),
			"	a. Talk to Sigrun Ironhew",
			"		i. Turn in "..cq("Scrounging"),
			completion={{questturnedin="Scrounging"}},
			mapzone="Badlands",
			level=43,
			mapnote=43309690,
		}, {
			"Go northwest to Loch Modan",
			completion={{location={mapzone="Loch Modan"}}},
			mapzone="Badlands",
			level=43,
		}, {
			"Go northeast to "..cl(66,66),
			"	a. Talk to Prospector Ironband",
			"		i. Turn in "..cq("Murdaloc"),
			completion={{questturnedin="Murdaloc"}},
			mapzone="Loch Modan",
			level=43,
			mapnote=65613150,
		}, {
			"Hearth to Thelsamar",
			completion={{location={mapzone="Loch Modan",x=35.1,y=46.9, dist=3}}},
			mapzone="Loch Modan",
			level=43,
		}, {
			"Fly to Darkshire",
			completion={{location={mapzone="Duskwood",x=74.7,y=46.9, dist=7}}},
			mapzone="Loch Modan",
			level=43,
		}, {
			"Go to "..cl(76,46),
			"	a. Talk to Watchmaster Sorigal",
			"		i. Accept "..cq("Supplies for Nethergarde"),
			completion={{questaccepted="Supplies for Nethergarde"}},
			mapzone="Duskwood",
			level=43,
			mapnote=46212200,
		}, {
			"Go east to Deadwind Pass",
			completion={{location={mapzone="Deadwind Pass"}}},
			mapzone="Duskwood",
			level=43,
		}, {
			"Go east to the Swamp of Sorrows",
			completion={{location={mapzone="Swamp of Sorrows"}}},
			mapzone="Deadwind Pass",
			level=43, 
		}, {
			"Go southeast to the Blasted Lands",
			completion={{location={mapzone="Blasted Lands"}}},
			mapzone="Swamp of Sorrows",
			level=43,
		}, {
			"Go east to Nethergarde Keep",
			completion={{location={mapzone="Blasted Lands",x=65.4,y=19.2, dist=9}}},
			mapzone="Blasted Lands",
			level=43,
		}, {
			"Go to "..cl(67,21),
			"	a. Talk to Quartermaster Lungertz",
			"		i. Turn in "..cq("Supplies for Nethergarde"),
			completion={{questturnedin="Supplies for Nethergarde"}},
			mapzone="Blasted Lands",
			level=43,
			mapnote=21408790,
		}, {
			"Go to "..cl(66,24),
			"	a. Talk to Alexandria Constantine",
			"		i. Get the Nethergarde Keep Flight Path",
			completion={{flightpath="Nethergarde Keep"}},
			mapzone="Blasted Lands",
			level=43,
			mapnote=24308980,
		}, {
			"Fly to Booty Bay",
			completion={{location={mapzone="Stranglethorn Vale",x=27.7,y=74.6, dist=6}}},
			mapzone="Blasted Lands",
			level=43,
		}, {
			"Go to "..cl(27,77),
			"	a. Talk to Krazek",
			"		i. Accept "..cq("Tran'rek"),
			completion={{questaccepted="Tran'rek"}},
			mapzone="Stranglethorn Vale",
			level=43,
			mapnote=77210410,
		}, {
			"Also at "..cl(27,77),	
			"	a. Talk to Crank Fizzlebub",
			"		i. Accept "..cq("Zanzil's Secret"),
			completion={{questaccepted="Zanzil's Secret"}},
			mapzone="Stranglethorn Vale",
			level=43,
			mapnote=77210430,
		}, {
			"Also at "..cl(27,77),	
			"	a. Talk to Whiskey Slim",
			"		i. Accept "..cq("Whiskey Slim's Lost Grog"),
			completion={{questaccepted="Whiskey Slim's Lost Grog"}},
			mapzone="Stranglethorn Vale",
			level=43,
			mapnote=77510460,
		}, {
			"Make Booty Bay your home",
			completion={{home="Booty Bay"}},
			mapzone="Stranglethorn Vale",
			level=43,
		}, {
			"Go to "..cl(27,76),
			"	a. Talk to Privateer Bloads",
			"		i. Accept "..cq("Akiris by the Bundle part 1"),
			completion={{questaccepted="Akiris by the Bundle part 1"}},
			mapzone="Stranglethorn Vale",
			level=43,
			mapnote=76410320,
		}, {
			"Go to "..cl(28,77),
			"	a. Talk to 'Sea Wolf' MacKinley",
			"		i. Accept "..cq("Stoley's Debt"),
			completion={{questaccepted="Stoley's Debt"}},
			mapzone="Stranglethorn Vale",
			level=43,
			mapnote=77110490,
		}, {
			"Go to "..cl(29,76),
			"	a. Talk to Dizzy One-Eye",
			"		i. Accept "..cq("Keep An Eye Out"),
			completion={{questaccepted="Keep An Eye Out"}},
			mapzone="Stranglethorn Vale",
			level=43,
			mapnote=75910450,
		}, {
			"Go east to "..cl(33,76),
			"	a. Kill Bloodsail pirates",
			"	b. Get Dizzy's Eye",
			"	c. Get 15 Snuff",
			completion={{questgoal={"*","Dizzy's Eye",1}},{questgoal={"*","Snuff",15}}},
			mapzone="Stranglethorn Vale",
			level=43,
			mapnote=76210900,
		}, {
			"Go southwest to "..cl(27,83),
			"	a. Kill 10 Bloodsail Swashbucklers",
			"	b. Click the Bloodsail Charts",
			"	c. Get the Bloodsail Charts",
			"	d. Click the Bloodsail Orders",
			"	e. Get the Bloodsail Orders",
			completion={{questgoal={"*","Bloodsail Swashbuckler slain",10}},{questgoal={"*","Bloodsail Charts",1}},{questgoal={"*","Bloodsail Orders",1}}},
			mapzone="Stranglethorn Vale",
			level=43,
			mapnote=82510950,
		}, {
			"Go north to Booty Bay",
			completion={{location={mapzone="Stranglethorn Vale",x=27.7,y=74.6, dist=6}}},
			mapzone="Stranglethorn Vale",
			level=43,
		}, {
			"Go to "..cl(27,77),
			"	a. Talk to Deeg",
			"		i. Turn in "..cq("Up to Snuff"),
			completion={{questturnedin="Up to Snuff"}},
			mapzone="Stranglethorn Vale",
			level=43,
			mapnote=77310420,
		}, {
			"Also at "..cl(27,77),
			"	a. Talk to Fleet Master Seahorn",
			"		i. Turn in "..cq("The Bloodsail Buccaneers part 4"),
			"		ii. Accept "..cq("The Bloodsail Buccaneers part 5"),
			completion={{questturnedin="The Bloodsail Buccaneers part 4"},{questaccepted="The Bloodsail Buccaneers part 5"}},
			mapzone="Stranglethorn Vale",
			level=43,
			mapnote=77010420,
		}, {
			"Go to "..cl(29,76),
			"	a. Talk to Dizzy One-Eye",
			"		i. Turn in "..cq("Keep An Eye Out"),
			completion={{questturnedin="Keep An Eye Out"}},
			mapzone="Stranglethorn Vale",
			level=43,
			mapnote=75910450,
		}, {
			"Grind to level 44",
			completion={{level=44}},
			mapzone="Stranglethorn Vale",
			level=43,
		}, {
			"Go northwest to "..cl(25,64),
			"	a. Kill nagas",
			"	b. Get 10 Akiris Reed",
			completion={{questgoal={"*","Akiris Reed",10}}},
			mapzone="Stranglethorn Vale",
			level=44,
			mapnote=63708840,
		}, {
			"Go northeast to "..cl(39,57),
			"	a. Kill Zanzil mobs",
			"	b. Get 12 Zanzil's Mixture",
			completion={{questgoal={"*","Zanzil's Mixture",12}}},
			mapzone="Stranglethorn Vale",
			level=44,
			mapnote=57109630,
		}, {
			"Go southeast to "..cl(40,58),
			"	a. Kill Chucky 'Ten Thumbs'",
			"	b. Get Chucky's Huge Ring",
			completion={{questgoal={"*","Chucky's Huge Ring",1}}},
			mapzone="Stranglethorn Vale",
			level=44,
			mapnote=58209820,
		}, {
			"Go northwest to "..cl(35,52),
			"	a. Kill Jon-Jon the Crow",
			"	b. Get Jon-Jon's Golden Spyglass",
			completion={{questgoal={"*","Jon-Jon's Golden Spyglass",1}}},
			mapzone="Stranglethorn Vale",
			level=44,
			mapnote=51908680,
		}, {
			"Go north to "..cl(35,51),
			"	a. Kill Maury 'Club Foot' Wilkins",
			"	b. Get Maury's Clubbed Foot",
			completion={{questgoal={"*","Maury's Clubbed Foot",1}}},
			mapzone="Stranglethorn Vale",
			level=44,
			mapnote=51108620,
		}, {
			"Go northwest to "..cl(32,43),
			"	a. Kill Tethis",
			"	b. Get the Talon of Tethis",
			completion={{questgoal={"*","Talon of Tethis",1}}},
			mapzone="Stranglethorn Vale",
			level=44,
			mapnote=43407550,
		}, {
			"Go north to "..cl(36,11),
			"	a. Talk to Hemet Nesingwary Jr.",
			"		i. Turn in "..cq("Raptor Mastery part 4"),
			"		ii. Accept "..cq("Big Game Hunter"),
			completion={{questturnedin="Raptor Mastery part 4"},{questaccepted="Big Game Hunter"}},
			mapzone="Stranglethorn Vale",
			level=44,
			mapnote=10704650,
		}, {
			"Hearth to Booty Bay",
			completion={{location={mapzone="Stranglethorn Vale",x=27.7,y=74.6, dist=6}}},
			mapzone="Stranglethorn Vale",
			level=44,
		}, {
			"Go to "..cl(27,77),
			"	a. Talk to Crank Fizzlebub",
			"		i. Turn in "..cq("Zanzil's Secret"),
			completion={{questturnedin="Zanzil's Secret"}},
			mapzone="Stranglethorn Vale",
			level=44,
			mapnote=77210430,
		}, {
			"Go to "..cl(28,77),
			"	a. Talk to 'Sea Wolf' MacKinley",
			"		i. Turn in "..cq("Voodoo Dues"),
			completion={{questturnedin="Voodoo Dues"}},
			mapzone="Stranglethorn Vale",
			level=44,
			mapnote=77110490,
		}, {
			"Go to "..cl(27,76),
			"	a. Talk to Privateer Bloads",
			"		i. Turn in "..cq("Akiris by the Bundle part 1"),
			"		ii. Accept "..cq("Akiris by the Bundle part 2"),
			completion={{questturnedin="Akiris by the Bundle part 1"},{questaccepted="Akiris by the Bundle part 2"}},
			mapzone="Stranglethorn Vale",
			level=44,
			mapnote=76410320,
		}, {
			"Ride the boat to Ratchet",
			completion={{location={mapzone="The Barrens",x=63.0,y=38.1, dist=2}}},
			mapzone="Stranglethorn Vale",
			level=44,
		}, {
			"Fly to Theramore",
			completion={{location={mapzone="Dustwallow Marsh",x=67.5,y=50.3, dist=9}}},
			mapzone="The Barrens",
			level=44,
		}, {
			"Go to "..cl(68,52),
			"	a. Talk to Privateer Groy",
			"		i. Turn in "..cq("Akiris by the Bundle part 2"),
			completion={{questturnedin="Akiris by the Bundle part 2"}},
			mapzone="Dustwallow Marsh",
			level=44,
			mapnote=51711940,
		}, {
			"Fly to Gadgetzan",
			completion={{location={mapzone="Tanaris",x=51.7,y=27.8, dist=6}}},
			mapzone="Dustwallow Marsh",
			level=44,
		}, {
			"Go to "..cl(53,29),
			"	a. Talk to Chief Engineer Bilgewhizzle",
			"		i. Accept "..cq("Wastewander Justice"),
			"	b. Talk to Spigot Operator Luglunket",
			"		i. Accept "..cq("Water Pouch Bounty"),
			completion={{questaccepted="Wastewander Justice"},{questaccepted="Water Pouch Bounty"}},
			mapzone="Tanaris",
			level=44,
			mapnote=28508100,
		}, {
			"Make Gadgetzan your home",
			completion={{home="Gadgetzan"}},
			mapzone="Tanaris",
			level=44,
		}, {
			"Go to "..cl(52,27),
			"	a. Click the Wanted Poster",
			"		i. Accept "..cq("WANTED: Andre Firebeard"),
			"		ii. Accept "..cq("WANTED: Caliph Scorpidsting"),
			completion={{questaccepted="WANTED: Andre Firebeard"},{questaccepted="WANTED: Caliph Scorpidsting"}},
			mapzone="Tanaris",
			level=44,
			mapnote=27007880,
		}, {	
			"Also at "..cl(52,27),
			"	a. Talk to Tran'rek",
			"		i. Turn in "..cq("Tran'rek"),
			completion={{questturnedin="Tran'rek"}},
			mapzone="Tanaris",
			level=44,
			mapnote=26807840,
		}, {
			"Go north to Thousand Needles",
			completion={{location={mapzone="Thousand Needles"}}},
			mapzone="Tanaris",
			level=44,
		}, {
			"Go northeast to the Mirage Raceway",
			completion={{location={mapzone="Thousand Needles",x=78.6,y=76.0, dist=6}}},
			mapzone="Thousand Needles",
			level=44,
		}, {
			"Go to "..cl(78,77),
			"	a. Talk to Fizzle Brassbolts",
			"		i. Turn in "..cq("News for Fizzle"),
			completion={{questturnedin="News for Fizzle"}},
			mapzone="Thousand Needles",
			level=44,
			mapnote=77115520,
		}, {
			"Go to "..cl(80,76),
			"	a. Talk to Pozzik",
			"		i. Accept "..cq("Keeping Pace"),
			completion={{questaccepted="Keeping Pace"}},
			mapzone="Thousand Needles",
			level=44,
			mapnote=75915610,
		}, {
			"Go to "..cl(80,77),
			"	a. Talk to Zamek",
			"	a. He will create a diversion to distract Rizzle Brassbolts",
			mapzone="Thousand Needles",
			level=44,
			mapnote=77015680,
		}, {
			"Go to "..cl(77,77),
			"	a. Click Rizzle's Unguarded Plans",
			"		i. Turn in "..cq("Keeping Pace"),
			"		ii. Accept "..cq("Rizzle's Schematics"),
			completion={{questturnedin="Keeping Pace"},{questaccepted="Rizzle's Schematics"}},
			mapzone="Thousand Needles",
			level=44,
			mapnote=77415460,
		}, {
			"Go to "..cl(80,76),
			"	a. Talk to Pozzik",
			"		i. Turn in "..cq("Rizzle's Schematics"),
			completion={{questturnedin="Rizzle's Schematics"}},
			mapzone="Thousand Needles",
			level=44,
			mapnote=75915610,
		}, {
			"Hearth to Gadgetzan",
			completion={{location={mapzone="Tanaris",x=51.7,y=27.8, dist=6}}},
			mapzone="Thousand Needles",
			level=44,
		}, {
			"Go northeast to "..cl(60,25),
			"	a. Kill Wastewander mobs",
			"	b. Get 5 Wastewander Water Pouches",
			"	c. Kill 10 Wastewander Bandits",
			"	d. Kill 10 Wastewander Thieves",
			completion={{questgoal={"*","Wastewander Water Pouch",5}},{questgoal={"*","Wastewander Bandit slain",10}},{questgoal={"*","Wastewander Thief slain",10}}},
			mapzone="Tanaris",
			level=44,
			mapnote=24708450,
		}, {
			"Go east to Steamwheedle Port",
			completion={{location={mapzone="Tanaris",x=66.7,y=23.1, dist=2}}},
			mapzone="Tanaris",
			level=44,
		}, {
			"Go to "..cl(67,24),
			"	a. Talk to Stoley",
			"		i. Turn in "..cq("Stoley's Debt"),
			"		ii. Accept "..cq("Stoley's Shipment"),
			"	b. Talk to Security Chief Bilgewhizzle",
			"		i. Accept "..cq("Southsea Shakedown"),
			completion={{questturnedin="Stoley's Debt"},{questaccepted="Stoley's Shipment"},{questaccepted="Southsea Shakedown"}},
			mapzone="Tanaris",
			level=44,
			mapnote=24009100,
		}, {
			"Go to "..cl(67,22),
			"	a. Talk to Haughty Modiste",
			"		i. Accept "..cq("Pirate Hats Ahoy!"),
			completion={{questaccepted="Pirate Hats Ahoy!"}},
			mapzone="Tanaris",
			level=44,
			mapnote=22308890,
		}, {
			"Also at "..cl(67,22),
			"	b. Talk to Yeh'kinya",
			"		i. Accept "..cq("Screecher Spirits"),
			completion={{questaccepted="Screecher Spirits"}},
			mapzone="Tanaris",
			level=44,
			mapnote=22408940,
		}, {
			"Go southeast to "..cl(65,35),
			"	a. Kill Caliph Scorpidsting",
			"	b. Get Caliph Scorpidsting's Head",
			completion={{questgoal={"*","Caliph Scorpidsting's Head",1}}},
			mapzone="Tanaris",
			level=44,
			mapnote=35310000,
		}, {
			"Go southeast to "..cl(70,43),
			"	a. Kill 10 Southsea Pirates",
			"	b. Kill 10 Southsea Freebooters",
			"	c. Kill Southsea Pirates",
			"	d. Get 20 Southsea Pirate Hats",
			completion={{questgoal={"*","Southsea Pirate slain",10}},{questgoal={"*","Southsea Freebooter slain",10}},{questgoal={"*","Southsea Pirate Hat",20}}},
			mapzone="Tanaris",
			level=44,
			mapnote=42711310,
		}, {
			"Go southeast to "..cl(73,47),
			"	a. Kill Andre Firebeard",
			"	b. Get Firebeard's Head",
			completion={{questgoal={"*","Firebeard's Head",1}}},
			mapzone="Tanaris",
			level=44,
			mapnote=47112050,
		}, {
			"Go west to "..cl(72,47),
			"	a. Click the Stolen Cargo",
			"	b. Get Stoley's Shipment",
			completion={{questgoal={"*","Stoley's Shipment",1}}},
			mapzone="Tanaris",
			level=44,
			mapnote=46811900,
		}, {
			"Go east to "..cl(74,46),
			"	a. Kill 10 Southsea Dock Workers",
			"	b. Kill 10 Southsea Swashbucklers",
			completion={{questgoal={"*","Southsea Dock Worker slain",10}},{questgoal={"*","Southsea Swashbuckler slain",10}}},
			mapzone="Tanaris",
			level=44,
			mapnote=46412070,
		}, {
			"Grind to level 45",
			completion={{level=45}},
			mapzone="Tanaris",
			level=44,
		}
	  },
	},
	{ sectiontitle = "Levels (45-50)",
	  steps = {
		{
			"Hearth to Gadgetzan",
			completion={{location={mapzone="Tanaris",x=51.7,y=27.8, dist=6}}},
			mapzone="Tanaris",
			level=45,
		}, {
			"Go to "..cl(53,29),
			"	a. Talk to Chief Engineer Bilgewhizzle",
			"		i. Turn in "..cq("Wastewander Justice"),
			"		ii. Accept "..cq("More Wastewander Justice"),
			"		iii. Turn in "..cq("WANTED: Caliph Scorpidsting"),
			"	b. Talk to Spigot Operator Luglunket",
			"		i. Turn in "..cq("Water Pouch Bounty"),
			completion={{questturnedin="Wastewander Justice"},{questaccepted="More Wastewander Justice"},{questturnedin="WANTED: Caliph Scorpidsting"},{questturnedin="Water Pouch Bounty"}},
			mapzone="Tanaris",
			level=45,
			mapnote=28508100,
		}, {
			"Go southeast to "..cl(64,38),
			"	a. Kill 8 Wastewander Rogues",
			"	b. Kill 6 Wastewander Assassins",
			"	c. Kill 10 Wastewander Shadow Mages",
			completion={{questgoal={"*","Wastewander Rogue slain",8}},{questgoal={"*","Wastewander Assassin slain",6}},{questgoal={"*","Wastewander Shadow Mage slain",10}}},
			mapzone="Tanaris",
			level=45,
			mapnote=38210250,
		}, {
			"Go north to Steamwheedle Port",
			completion={{location={mapzone="Tanaris",x=66.7,y=23.1, dist=2}}},
			mapzone="Tanaris",
			level=45,
		}, {
			"Go to "..cl(67,24),
			"	a. Talk to Stoley",
			"		i. Turn in "..cq("Stoley's Shipment"),
			"		ii. Accept "..cq("Deliver to MacKinley"),
			"	b. Talk to Security Chief Bilgewhizzle",
			"		i. Turn in "..cq("Southsea Shakedown"),
			"		ii. Turn in "..cq("WANTED: Andre Firebeard"),
			completion={{questturnedin="Stoley's Shipment"},{questaccepted="Deliver to MacKinley"},{questturnedin="Southsea Shakedown"},{questturnedin="WANTED: Andre Firebeard"}},
			mapzone="Tanaris",
			level=45,
			mapnote=24009100,
		}, {
			"Go to "..cl(67,22),
			"	a. Talk to Haughty Modiste",
			"		i. Turn in "..cq("Pirate Hats Ahoy!"),
			completion={{questturnedin="Pirate Hats Ahoy!"}},
			mapzone="Tanaris",
			level=45,
			mapnote=22308890,
		}, {
			"Hearth to Gadgetzan",
			completion={{location={mapzone="Tanaris",x=51.7,y=27.8, dist=6}}},
			mapzone="Tanaris",
			level=45,
		}, {
			"Go to "..cl(53,29),
			"	a. Talk to Chief Engineer Bilgewhizzle",
			"		i. Turn in "..cq("More Wastewander Justice"),
			completion={{questturnedin="More Wastewander Justice"}},
			mapzone="Tanaris",
			level=45,
			mapnote=28508100,
		}, {
			"Go to "..cl(52,27),
			"	a. Talk to Curgle Cranklehop",
			"		i. Accept "..cq("Handle With Care"),
			completion={{questaccepted="Handle With Care"}},
			mapzone="Tanaris",
			level=45,
			mapnote=26907930,
		}, {
			"Fly to Feathermoon Stronghold",
			completion={{location={mapzone="Feralas",x=31.0,y=44.0, dist=5}}},
			mapzone="Tanaris",
			level=45,
		}, {
			"Go to "..cl(31,43),
			"	a. Talk to Pratt McGrubben",
			"		i. Accept "..cq("The Mark of Quality"),
			completion={{questaccepted="The Mark of Quality"}},
			mapzone="Feralas",
			level=45,
			mapnote=42707330,
		}, {
			"Make Feathermoon Stronghold your home",
			completion={{home="Feathermoon Stronghold"}},
			mapzone="Feralas",
			level=45,
		}, {
			"Go to "..cl(30,46),
			"	a. Talk to Shandris Feathermoon",
			"		i. Accept "..cq("The Ruins of Solarsal"),
			"	b. Talk to Latronicus Moonspear",
			"		i. Accept "..cq("The Missing Courier part 1"),
			completion={{questaccepted="The Ruins of Solarsal"},{questaccepted="The Missing Courier part 1"}},
			mapzone="Feralas",
			level=45,
			mapnote=46207650,
		}, {
			"Go to "..cl(32,46),
			"	a. Talk to Troyas Moonbreeze",
			"		i. Accept "..cq("In Search of Knowledge"),
			"	b. Talk to Angelas Moonbreeze",
			"		i. Accept "..cq("The High Wilderness"),
			completion={{questaccepted="In Search of Knowledge"},{questaccepted="The High Wilderness"}},
			mapzone="Feralas",
			level=45,
			mapnote=45607740,
		}, {
			"Go to "..cl(32,45),
			"	a. Talk to Ginro Hearthkindle",
			"		i. Turn in "..cq("The Missing Courier part 1"),
			"		ii. Accept "..cq("The Missing Courier part 2"),
			completion={{questturnedin="The Missing Courier part 1"},{questaccepted="The Missing Courier part 2"}},
			mapzone="Feralas",
			level=45,
			mapnote=45107700,
		}, {
			"Go southwest to "..cl(26,52),
			"	a. Click the Solarsal Gazebo",
			"		i. Turn in "..cq("The Ruins of Solarsal"),
			"		ii. Accept "..cq("Return to Feathermoon Stronghold"),
			completion={{questturnedin="The Ruins of Solarsal"},{questaccepted="Return to Feathermoon Stronghold"}},
			mapzone="Feralas",
			level=45,
			mapnote=52307860,
		}, {
			"Go northeast to Feathermoon Stronghold",
			completion={{location={mapzone="Feralas",x=31.0,y=44.0, dist=5}}},
			mapzone="Feralas",
			level=45,
		}, {
			"Go to "..cl(30,46),
			"	a. Talk to Shandris Feathermoon",
			"		i. Turn in "..cq("Return to Feathermoon Stronghold"),
			"		ii. Accept "..cq("Against the Hatecrest part 1"),
			"	b. Talk to Latronicus Moonspear",
			"		i. Turn in "..cq("Against the Hatecrest part 1"),
			"		ii. Accept "..cq("Against the Hatecrest part 2"),
			completion={{questturnedin="Return to Feathermoon Stronghold"},{questaccepted="Against the Hatecrest part 1"},{questturnedin="Against the Hatecrest part 1"},{questaccepted="Against the Hatecrest part 2"}},
			mapzone="Feralas",
			level=45,
			mapnote=46207650,
		}, {
			"Go southwest to "..cl(27,52),
			"	a. Kill Hatecrest nagas",
			"	b. Get 10 Hatecrest Naga Scales",
			completion={{questgoal={"*","Hatecrest Naga Scale",10}}},
			mapzone="Feralas",
			level=45,
			mapnote=52207940,
		}, {
			"Go northeast to "..cl(30,46),
			"	a. Talk to Latronicus Moonspear",
			"		i. Turn in "..cq("Against the Hatecrest part 2"),
			"		ii. Accept "..cq("Against Lord Shalzaru"),
			completion={{questturnedin="Against the Hatecrest part 2"},{questaccepted="Against Lord Shalzaru"}},
			mapzone="Feralas",
			level=45,
			mapnote=46207650,
		}, {
			"Go southwest to "..cl(26,64),
			"	a. The path down to 'Against Lord Shalzaru' starts here",
			"	b. Follow the path into the cave",
			completion={{location={mapzone="Feralas",x=25.5,y=64.5, dist=0.5}}},
			mapzone="Feralas",
			level=45,
			mapnote=64408990,
		}, {
			"Go southeast to "..cl(29,71),
			"	a. Kill Lord Shalzaru",
			"	b. Get the Mysterious Relic",
			completion={{questgoal={"*","Mysterious Relic",1}}},
			mapzone="Feralas",
			level=45,
			mapnote=70709920,
		}, {
			"Hearth to Feathermoon Stronghold",
			completion={{location={mapzone="Feralas",x=31.0,y=44.0, dist=5}}},
			mapzone="Feralas",
			level=45,
		}, {
			"Go to "..cl(30,46),
			"	a. Talk to Latronicus Moonspear",
			"		i. Turn in "..cq("Against Lord Shalzaru"),
			"		ii. Accept "..cq("Delivering the Relic"),
			completion={{questturnedin="Against Lord Shalzaru"},{questaccepted="Delivering the Relic"}},
			mapzone="Feralas",
			level=45,
			mapnote=46207650,
		}, {
			"Go to "..cl(30,45),
			"	a. Talk to Vestia Moonspear",
			"		i. Turn in "..cq("Delivering the Relic"),
			completion={{questturnedin="Delivering the Relic"}},
			mapzone="Feralas",
			level=45,
			mapnote=45107520,
		}, {
			"Ride the boat to the main continent of Feralas",
			completion={{location={mapzone="Feralas",x=43.5,y=42.7, dist=1}}},
			mapzone="Feralas",
			level=45,
		}, {
			"Go southeast to "..cl(47,48),
			"	a. Kill 3 Rogue Vale Screechers",
			"	b. Use Yeh'kinya's Bramble on their corpses",
			"	c. Talk to their spirits that appear to collect their spirits",
			"	d. Collect 3 Screecher Spirits",
			completion={{questgoal={"*","Screecher Spirits Collected",3}}},
			mapzone="Feralas",
			level=45,
			mapnote=48209480,
		}, {
			"Go south to "..cl(46,65),
			"	a. Click the Wrecked Row Boat",
			"		i. Turn in "..cq("The Missing Courier part 2"),
			"		ii. Accept "..cq("Boat Wreckage"),
			completion={{questturnedin="The Missing Courier part 2"},{questaccepted="Boat Wreckage"}},
			mapzone="Feralas",
			level=45,
			mapnote=65011050,
		}, {
			"Go north to "..cl(43,43),
			"	a. Ride the boat to Feathermoon Stronghold",
			completion={{location={mapzone="Feralas",x=43.5,y=42.7, dist=0.5}}},
			mapzone="Feralas",
			level=45,
			mapnote=42808630,
		}, {
			"Go to "..cl(32,45),
			"	a. Talk to Ginro Hearthkindle",
			"		i. Turn in "..cq("Boat Wreckage"),
			"		ii. Accept "..cq("The Knife Revealed"),
			completion={{questturnedin="Boat Wreckage"},{questaccepted="The Knife Revealed"}},
			mapzone="Feralas",
			level=45,
			mapnote=45107700,
		}, {
			"Go to "..cl(32,44),
			"	a. Talk to Quintis Jonespyre",
			"		i. Turn in "..cq("The Knife Revealed"),
			"		ii. Accept "..cq("Psychometric Reading"),
			completion={{questturnedin="The Knife Revealed"},{questaccepted="Psychometric Reading"}},
			mapzone="Feralas",
			level=45,
			mapnote=43807620,
		}, {
			"Go to "..cl(32,45),
			"	a. Talk to Ginro Hearthkindle",
			"		i. Turn in "..cq("Psychometric Reading"),
			"		ii. Accept "..cq("The Woodpaw Gnolls"),
			completion={{questturnedin="Psychometric Reading"},{questaccepted="The Woodpaw Gnolls"}},
			mapzone="Feralas",
			level=45,
			mapnote=45107700,
		}, {
			"Ride the boat to the main continent of Feralas",
			completion={{location={mapzone="Feralas",x=43.5,y=42.7, dist=1}}},
			mapzone="Feralas",
			level=45,
		}, {
			"Go southeast to "..cl(56,55),
			"	a. Kill yetis",
			"	b. Get 10 Thick Yeti Hides",
			completion={{questgoal={"*","Thick Yeti Hide",10}}},
			mapzone="Feralas",
			level=45,
			mapnote=54811030,
		}, {
			"Grind to level 46",
			completion={{level=46}},
			mapzone="Feralas",
			level=45,
		}, {
			"Go southeast to "..cl(58,67),
			"	a. Kill 8 Gordunni Shamans",
			completion={{questgoal={"*","Gordunni Shaman slain",8}}},
			mapzone="Feralas",
			level=46,
			mapnote=66912480,
		}, {
			"Go northeast to "..cl(60,59),
			"	a. Kill 8 Gordunni Warlocks",
			"	b. Kill 8 Gordunni Brutes",
			completion={{questgoal={"*","Gordunni Warlock slain",8}},{questgoal={"*","Gordunni Brute slain",8}}},
			mapzone="Feralas",
			level=46,
			mapnote=58811920,
		}, {
			"Go northeast to "..cl(66,47),
			"	a. The path up to the Moonweavers starts here hidden behind the tree",
			completion={{location={mapzone="Feralas",x=65.6,y=46.9, dist=0.3}}},
			mapzone="Feralas",
			level=46,
			mapnote=46911250,
		}, {
			"Go north to "..cl(66,46),
			"	a. Talk to Kindal Moonweaver",
			"		i. Accept "..cq("Freedom for All Creatures"),
			completion={{questaccepted="Freedom for All Creatures"}},
			mapzone="Feralas",
			level=46,
			mapnote=45611150,
		}, {
			"Go southeast to "..cl(67,47),
			"	a. Click the Cage Door on the huge cage",
			"	b. Free the Sprite Darters",
			"	c. The Grimtotems will attack the Sprite Darters",
			"	d. Make sure 6 Sprite Darters survive",
			mapzone="Feralas",
			level=46,
			mapnote=46811350,
		}, {
			"Go northwest to "..cl(66,46),
			"	a. Talk to Kindal Moonweaver",
			"		i. Turn in "..cq("Freedom for All Creatures"),
			"	b. Talk to Jer'kai Moonweaver",
			"		i. Accept "..cq("Doling Justice part 1"),
			completion={{questturnedin="Freedom for All Creatures"},{questaccepted="Doling Justice part 1"}},
			mapzone="Feralas",
			level=46,
			mapnote=45611150,
		}, {
			"Go east to "..cl(68,46),
			"	a. Kill 12 Grimtotem Naturalists",
			"	b. Kill 10 Grimtotem Raiders",
			"	c. Kill 6 Grimtotem Shamans",
			completion={{questgoal={"*","Grimtotem Naturalist slain",12}},{questgoal={"*","Grimtotem Raider slain",10}},{questgoal={"*","Grimtotem Shaman slain",6}}},
			mapzone="Feralas",
			level=46,
			mapnote=46411390,
		}, {
			"Go northwest to "..cl(66,46),
			"	a. Talk to Jer'kai Moonweaver",
			"		i. Turn in "..cq("Doling Justice part 1"),
			"		ii. Accept "..cq("Doling Justice part 2"),
			completion={{questturnedin="Doling Justice part 1"},{questaccepted="Doling Justice part 2"}},
			mapzone="Feralas",
			level=46,
			mapnote=45611150,
		}, {
			"Go southeast to "..cl(73,56),
			"	a. Click the Large Leather Backpacks",
			"		i. Turn in "..cq("The Woodpaw Gnolls"),
			"		ii. Accept "..cq("The Writhing Deep"),
			"	b. Click the Undelivered Parcel in your bags",
			"		i. Accept "..cq("Thalanaar Delivery"),
			completion={{questturnedin="The Woodpaw Gnolls"},{questaccepted="The Writhing Deep"},{questaccepted="Thalanaar Delivery"}},
			mapzone="Feralas",
			level=46,
			mapnote=56312960,
		}, {
			"Go south to "..cl(74,63),
			"	a. The path down to 'The Writhing Deep' starts here",
			"	b. Follow the path all the way to the bottom",
			"	c. Enter the tunnel heading southwest",
			"	d. Turn right at the fork into the small circular room",
			completion={{location={mapzone="Feralas",x=73.8,y=63.0, dist=0.3}}},
			mapzone="Feralas",
			level=46,
			mapnote=62913670,
		}, {
			"Go west to "..cl(72,64),
			"	a. Click the Zukk'ash Pod",
			"		i. Turn in "..cq("The Writhing Deep"),
			"		ii. Accept "..cq("Freed from the Hive"),
			completion={{questturnedin="The Writhing Deep"},{questaccepted="Freed from the Hive"}},
			mapzone="Feralas",
			level=46,
			mapnote=63713580,
		}, {
			"Hearth to Feathermoon Stronghold",
			completion={{location={mapzone="Feralas",x=31.0,y=44.0, dist=5}}},
			mapzone="Feralas",
			level=46,
		}, {
			"Go to "..cl(31,43),
			"	a. Talk to Pratt McGrubben",
			"		i. Turn in "..cq("The Mark of Quality"),
			"		ii. Accept "..cq("Improved Quality"),
			completion={{questturnedin="The Mark of Quality"},{questaccepted="Improved Quality"}},
			mapzone="Feralas",
			level=46,
			mapnote=42707330,
		}, {
			"Go to "..cl(32,46),
			"	a. Talk to Angelas Moonbreeze",
			"		i. Turn in "..cq("The High Wilderness"),
			completion={{questturnedin="The High Wilderness"}},
			mapzone="Feralas",
			level=46,
			mapnote=45607740,
		}, {
			"Go to "..cl(32,45),
			"	a. Talk to Ginro Hearthkindle",
			"		i. Turn in "..cq("Freed from the Hive"),
			"		ii. Accept "..cq("A Hero's Welcome"),
			completion={{questturnedin="Freed from the Hive"},{questaccepted="A Hero's Welcome"}},
			mapzone="Feralas",
			level=46,
			mapnote=45107700,
		}, {
			"Go to "..cl(30,46),
			"	a. Talk to Shandris Feathermoon",
			"		i. Turn in "..cq("A Hero's Welcome"),
			"		ii. Accept "..cq("Rise of the Silithid"),
			completion={{questturnedin="A Hero's Welcome"},{questaccepted="Rise of the Silithid"}},
			mapzone="Feralas",
			level=46,
			mapnote=46207650,
		}, {
			"Fly to Thalanaar",
			"	a. On the border of Thousand Needles and Feralas, if you didn't remember",
			completion={{location={mapzone="Feralas",x=89.5,y=45.8, dist=0.3}}},
			mapzone="Feralas",
			level=46,
		}, {
			"Go to "..cl(90,47),
			"	a. Talk to Falfindel Waywarder",
			"		i. Turn in "..cq("Thalanaar Delivery"),
			completion={{questturnedin="Thalanaar Delivery"}},
			mapzone="Feralas",
			level=46,
			mapnote=46613620,
		}, {
			"Fly to Rut'theran Village",
			completion={{location={mapzone="Teldrassil",x=56.3,y=92.4, dist=6}}},
			mapzone="Feralas",
			level=46,
		}, {
			"Go to "..cl(55,92),
			"	a. Talk to Eralas Ambersky",
			"		i. Turn in "..cq("Handle With Care"),
			"		ii. Accept "..cq("Favored of Elune?"),
			completion={{questturnedin="Handle With Care"},{questaccepted="Favored of Elune?"}},
			mapzone="Teldrassil",
			level=46,
			mapnote=92014750,
		}, {
			"Also at "..cl(55,92),
			"	a. Talk to Daryn Lightwind",
			"		i. Turn in "..cq("In Search of Knowledge"),
			completion={{questturnedin="In Search of Knowledge"}},
			mapzone="Teldrassil",
			level=46,
			mapnote=92014750,
		}, {
			"Go to "..cl(55,91),
			"	a. Click the green book on the floor named Feralas: A History",
			"		i. Accept "..cq("Feralas: A History"),
			completion={{questaccepted="Feralas: A History"}},
			mapzone="Teldrassil",
			level=46,
			mapnote=91514670,
		}, {
			"Go to "..cl(55,92),
			"	a. Talk to Daryn Lightwind",
			"		i. Turn in "..cq("Feralas: A History"),
			"		ii. Accept "..cq("The Borrower"),
			completion={{questturnedin="Feralas: A History"},{questaccepted="The Borrower"}},
			mapzone="Teldrassil",
			level=46,
			mapnote=92214760,
		}, {
			"Go to Darnassus",
			completion={{location={mapzone="Darnassus"}}},
			mapzone="Teldrassil",
			level=46,
		}, {
			"Go to "..cl(42,86),
			"	a. Talk to Gracina Spiritmight",
			"		i. Turn in "..cq("Rise of the Silithid"),
			completion={{questturnedin="Rise of the Silithid"}},
			mapzone="Darnassus",
			level=46,
			mapnote=85612740,
		}, {
			"Go to "..cl(38,81),
			"	a. Talk to Tyrande Whisperwind",
			"		i. Turn in "..cq("Doling Justice part 2"),
			completion={{questturnedin="Doling Justice part 2"}},
			mapzone="Darnassus",
			level=46,
			mapnote=80911920,
		}, {
			"Go to Rut'theran Village",
			completion={{location={mapzone="Teldrassil",x=56.3,y=92.4, dist=6}}},
			mapzone="Darnassus",
			level=46,
		}, {
			"Fly to Gadgetzan",
			completion={{location={mapzone="Tanaris",x=51.7,y=27.8, dist=6}}},
			mapzone="Teldrassil",
			level=46,
		}, {
			"Go to "..cl(52,27),
			"	a. Talk to Curgle Cranklehop",
			"		i. Turn in "..cq("The Borrower"),
			"		ii. Accept "..cq("The Super Snapper FX"),
			completion={{questturnedin="The Borrower"},{questaccepted="The Super Snapper FX"}},
			mapzone="Tanaris",
			level=46,
			mapnote=26907930,
		}, {
			"Fly to Ratchet",
			completion={{location={mapzone="The Barrens",x=63.0,y=38.1, dist=2}}},
			mapzone="Tanaris",
			level=46,
		}, {
			"Ride the boat to Booty Bay",
			completion={{location={mapzone="Stranglethorn Vale",x=27.7,y=74.6, dist=6}}},
			mapzone="The Barrens",
			level=46,
		}, {
			"Go to "..cl(28,77),
			"	a. Talk to 'Sea Wolf' MacKinley",
			"		i. Turn in "..cq("Deliver to MacKinley"),
			completion={{questturnedin="Deliver to MacKinley"}},
			mapzone="Stranglethorn Vale",
			level=46,
			mapnote=77110490,
		}, {
			"Fly to Stormwind",
			completion={{location={mapzone="Stormwind City"}}},
			mapzone="Stranglethorn Vale",
			level=46,
		}, {
			"Buy 2 Elixirs of Fortitude from the Auction House",
			mapzone="Stormwind City",
			level=46,
		}, {
			"Fly to Southshore",
			completion={{location={mapzone="Hillsbrad Foothills",x=50.0,y=56.9, dist=8}}},
			mapzone="Stormwind City",
			level=46,
		}, {
			"Go northeast to the Hinterlands",
			completion={{location={mapzone="The Hinterlands"}}},
			mapzone="Hillsbrad Foothills",
			level=46,
		}, {
			"Go northeast to Aerie Peak",
			completion={{location={mapzone="The Hinterlands",x=13.4,y=46.5, dist=4}}},
			mapzone="The Hinterlands",
			level=46,
		}, {
			"Go to "..cl(11,46),
			"	a. Talk to Guthrum Thunderfist",
			"		i. Get the Aerie Peak Flight Path",
			completion={{flightpath="Aerie Peak"}},
			mapzone="The Hinterlands",
			level=46,
			mapnote=46205730,
		}, {
			"Go to "..cl(10,44),
			"	a. Talk to Gryphon Master Talonaxe",
			"		i. Accept "..cq("Witherbark Cages"),
			completion={{questaccepted="Witherbark Cages"}},
			mapzone="The Hinterlands",
			level=46,
			mapnote=44505430,
		}, {
			"Go to "..cl(15,45),
			"	a. Talk to Fraggar Thundermantle",
			"		i. Accept "..cq("Skulk Rock Clean-up"),
			"		ii. Accept "..cq("Troll Necklace Bounty"),
			completion={{questaccepted="Skulk Rock Clean-up"},{questaccepted="Troll Necklace Bounty"}},
			mapzone="The Hinterlands",
			level=46,
			mapnote=44605940,
		}, {
			"Go to "..cl(14,42),
			"	a. Talk to Innkeeper Thulfram",
			"		i. Make Aerie Peak your home",
			completion={{home="Aerie Peak"}},
			mapzone="The Hinterlands",
			level=46,
			mapnote=41705550,
		}, {
			"Go to "..cl(15,47),
			"	a. Talk to Ambassador Rualeth",
			"		i. Accept "..cq("Featherbeard's Endorsement"),
			"		ii. Accept "..cq("A Gesture of Goodwill"),
			"		iii. Accept "..cq("Preying on the Predators"),
			completion={{questaccepted="Featherbeard's Endorsement"},{questaccepted="A Gesture of Goodwill"},{questaccepted="Preying on the Predators"}},
			mapzone="The Hinterlands",
			level=46,
			mapnote=47206230,
		}, {
			"Go south to "..cl(13,55),
			"	a. Click Featherbeard's Journal",
			"		i. Turn in "..cq("Featherbeard's Endorsement"),
			"		ii. Accept "..cq("In Pursuit of Featherbeard"),
			completion={{questturnedin="Featherbeard's Endorsement"},{questaccepted="In Pursuit of Featherbeard"}},
			mapzone="The Hinterlands",
			level=46,
			mapnote=55206860,
		}, {
			"Go northeast to "..cl(20,53),
			"	a. Kill 10 Mangy Silvermanes",
			completion={{questgoal={"*","Mangy Silvermane slain",10}}},
			mapzone="The Hinterlands",
			level=46,
			mapnote=52707320,
		}, {
			"Grind to level 47",
			completion={{level=47}},
			mapzone="The Hinterlands",
			level=46,
		}, {
			"Go east to "..cl(23,55),
			"	a. Get 15 Wildkin Feathers",
			"	b. You can find them here and around Quel'Danil Lodge",
			completion={{questgoal={"*","Wildkin Feather",15}}},
			mapzone="The Hinterlands",
			level=47,
			mapnote=54807770,
		}, {
			"Go east to "..cl(25,55),
			"	a. Kill trolls",
			"	b. Get 5 Troll Tribal Necklaces",
			completion={{questgoal={"*","Troll Tribal Necklace",5}}},
			mapzone="The Hinterlands",
			level=47,
			mapnote=55408020,
		}, {
			"Go southwest to "..cl(23,59),
			"	a. Click the First Witherbark Cage",
			"	b. Click the Second Witherbark Cage",
			completion={{questgoal={"*","Check First Cage",1}},{questgoal={"*","Check Second Cage",1}}},
			mapzone="The Hinterlands",
			level=47,
			mapnote=58808200,
		}, {
			"Go southeast to "..cl(25,66),
			"	a. Kill Witch Doctor Mai'jin",
			"	b. Kill Tcha'kaz",
			completion={{questgoal={"*","Witch Doctor Mai'jin slain",1}},{questgoal={"*","Tcha'kaz slain",1}}},
			mapzone="The Hinterlands",
			level=47,
			mapnote=65609020,
		}, {
			"Go east to "..cl(27,66),
			"	a. Kill 5 Silvermane Wolves",
			completion={{questgoal={"*","Silvermane Wolf slain",5}}},
			mapzone="The Hinterlands",
			level=47,
			mapnote=66509360,
		}, {
			"Go northeast to "..cl(32,57),
			"	a. Click the Third Witherbark Cage",
			completion={{questgoal={"*","Check Third Cage",1}}},
			mapzone="The Hinterlands",
			level=47,
			mapnote=57308940,
		}, {
			"Go northeast to "..cl(48,42),
			"	a. Kill 10 Green Sludges",
			"	b. Kill 10 Jade Oozes",
			completion={{questgoal={"*","Green Sludge slain",10}},{questgoal={"*","Jade Ooze slain",10}}},
			mapzone="The Hinterlands",
			level=47,
			mapnote=41708990,
		}, {
			"Go southeast to "..cl(71,65),
			"	a. The path down to Gammerita starts here",
			completion={{location={mapzone="The Hinterlands",x=71.5,y=65.1, dist=0.3}}},
			mapzone="The Hinterlands",
			level=47,
			mapnote=65113660,
		}, {
			"Go east to "..cl(77,65),
			"	a. Use your Super Snapper FX on Gammerita",
			"	b. You do not need to fight her, just run away",
			completion={{questgoal={"*","Snapshot of Gammerita",1}}},
			mapzone="The Hinterlands",
			level=47,
			mapnote=64914180,
		}, {
			"Go northeast to "..cl(79,63),
			"	a. Click the bottles of Pupellyverbos Port",
			"	b. Get 12 Pupellyverbos Port",
			completion={{questgoal={"*","Pupellyverbos Port",12}}},
			mapzone="The Hinterlands",
			level=47,
			mapnote=63414220,
		}, {
			"Hearth to Aerie Peak",
			completion={{location={mapzone="The Hinterlands",x=13.4,y=46.5, dist=4}}},
			mapzone="The Hinterlands",
			level=47,
		}, {
			"Go to "..cl(15,45),
			"	a. Talk to Fraggar Thundermantle",
			"		i. Turn in "..cq("Skulk Rock Clean-up"),
			"		ii. Turn in "..cq("Troll Necklace Bounty"),
			completion={{questturnedin="Skulk Rock Clean-up"},{questturnedin="Troll Necklace Bounty"}},
			mapzone="The Hinterlands",
			level=47,
			mapnote=44605940,
		}, {
			"Go to "..cl(15,47),
			"	a. Talk to Ambassador Rualeth",
			"		i. Turn in "..cq("A Gesture of Goodwill"),
			"		ii. Turn in "..cq("Preying on the Predators"),
			completion={{questturnedin="A Gesture of Goodwill"},{questturnedin="Preying on the Predators"}},
			mapzone="The Hinterlands",
			level=47,
			mapnote=47206230,
		}, {
			"Go to "..cl(10,44),
			"	a. Talk to Gryphon Master Talonaxe",
			"		i. Turn in "..cq("Witherbark Cages"),
			"		ii. Accept "..cq("The Altar of Zul"),
			completion={{questturnedin="Witherbark Cages"},{questaccepted="The Altar of Zul"}},
			mapzone="The Hinterlands",
			level=47,
			mapnote=44505430,
		}, {
			"Go southeast to "..cl(37,71),
			"	a. Click Featherbeard's Remains",
			"		i. Turn in "..cq("In Pursuit of Featherbeard"),
			"		ii. Accept "..cq("Reclaiming the Eggs"),
			completion={{questturnedin="In Pursuit of Featherbeard"},{questaccepted="Reclaiming the Eggs"}},
			mapzone="The Hinterlands",
			level=47,
			mapnote=71510870,
		}, {
			"Go southwest to "..cl(34,73),
			"	a. Click the Gryphon Eggs",
			"	b. Get 5 Gryphon Eggs",
			completion={{questgoal={"*","Gryphon Egg",5}}},
			mapzone="The Hinterlands",
			level=47,
			mapnote=72910700,
		}, {
			"Go west to "..cl(48,68),
			"	a. Search the Altar of Zul",
			completion={{questgoal={"*","Search the Altar of Zul",1}}},
			mapzone="The Hinterlands",
			level=47,
			mapnote=67611590,
		}, {
			"Hearth to Aerie Peak",
			completion={{location={mapzone="The Hinterlands",x=13.4,y=46.5, dist=4}}},
			mapzone="The Hinterlands",
			level=47,
		}, {
			"Go to "..cl(15,47),
			"	a. Talk to Ambassador Rualeth",
			"		i. Turn in "..cq("Reclaiming the Eggs"),
			completion={{questturnedin="Reclaiming the Eggs"}},
			mapzone="The Hinterlands",
			level=47,
			mapnote=47206230,
		}, {
			"Go to "..cl(10,44),
			"	a. Talk to Gryphon Master Talonaxe",
			"		i. Turn in "..cq("The Altar of Zul"),
			"		ii. Accept "..cq("Thadius Grimshade"),
			completion={{questturnedin="The Altar of Zul"},{questaccepted="Thadius Grimshade"}},
			mapzone="The Hinterlands",
			level=47,
			mapnote=44505430,
		}, {
			"Fly to Menethil Harbor",
			completion={{location={mapzone="Wetlands",x=10.1,y=56.7, dist=9}}},
			mapzone="The Hinterlands",
			level=47,
		}, {
			"Ride the boat to Auberdine",
			completion={{location={mapzone="Darkshore",x=32.8,y=42.0, dist=9}}},
			mapzone="Wetland",
			level=47,
		}, {
			"Fly to Rut'theran Village",
			completion={{location={mapzone="Teldrassil",x=56.3,y=92.4, dist=6}}},
			mapzone="Darkshore",
			level=47,
		}, {
			"Go to "..cl(55,92),
			"	a. Talk to Erelas Ambersky",
			"		i. Turn in "..cq("Favored of Elune?"),
			completion={{questturnedin="Favored of Elune?"}},
			mapzone="Teldrassil",
			level=47,
			mapnote=92014750,
		}, {
			"Also at "..cl(55,92),
			"	a. Talk to Daryn Lightwind",
			"		i. Turn in "..cq("The Super Snapper FX"),
			"		ii. Accept "..cq("Return to Troyas"),
			completion={{questturnedin="The Super Snapper FX"},{questaccepted="Return to Troyas"}},
			mapzone="Teldrassil",
			level=47,
			mapnote=92214760,
		}, {
			"Fly to Feathermoon Stronghold",
			completion={{location={mapzone="Feralas",x=31.0,y=44.0, dist=5}}},
			mapzone="Teldrassil",
			level=47,
		}, {
			"Make Feathermoon Stronghold your home",
			completion={{home="Feathermoon Stronghold"}},
			mapzone="Feralas",
			level=47,
		}, {
			"Go to "..cl(32,46),
			"	a. Talk to Troyas Moonbreeze",
			"		i. Turn in "..cq("Return to Troyas"),
			"		ii. Accept "..cq("The Stave of Equinex"),
			"	b. Talk to Angelas Moonbreeze",
			"		i. Accept "..cq("The Sunken Temple"),
			completion={{questturnedin="Return to Troyas"},{questaccepted="The Stave of Equinex"},{questaccepted="The Sunken Temple"}},
			mapzone="Feralas",
			level=47,
			mapnote=45607740,
		}, {
			"Ride the boat to the main continent of Feralas",
			completion={{location={mapzone="Feralas",x=43.5,y=42.7, dist=1}}},
			mapzone="Feralas",
			level=47,
		}, {
			"Go to "..cl(45,43),
			"	a. Talk to Zorbin Fandazzle",
			"		i. Accept "..cq("Zapped Giants"),
			"		ii. Accept "..cq("Fuel for the Zapping"),
			completion={{questaccepted="Zapped Giants"},{questaccepted="Fuel for the Zapping"}},
			mapzone="Feralas",
			level=47,
			mapnote=43408820,
		}, {
			"Go south to "..cl(45,47),
			"	a. Use Zorbin's Ultra-Shrinker on giants",
			"	b. Kill the shrunken giants",
			"	c. Get 15 Miniaturization Residue",
			"	d. Kill water elementals",
			"	e. Get 10 Water Elemental Cores",
			completion={{questgoal={"*","Miniaturization Residue",15}},{questgoal={"*","Water Elemental Core",10}}},
			mapzone="Feralas",
			level=47,
			mapnote=47309210,
		}, {
			"Go north to "..cl(45,43),
			"	a. Talk to Zorbin Fandazzle",
			"		i. Turn in "..cq("Zapped Giants"),
			"		ii. Turn in "..cq("Fuel for the Zapping"),
			completion={{questturnedin="Zapped Giants"},{questturnedin="Fuel for the Zapping"}},
			mapzone="Feralas",
			level=47,
			mapnote=43408820,
		}, {
			"Grind to level 48",
			completion={{level=48}},
			mapzone="Feralas",
			level=47,
		}, {
			"Go northeast to "..cl(51,32),
			"	a. The path up to the yeti cave starts here",
			completion={{location={mapzone="Feralas",x=51.5,y=32.4, dist=0.3}}},
			mapzone="Feralas",
			level=48,
			mapnote=32508400,
		}, {
			"Go northeast to "..cl(52,32),
			"	a. Kill Rage Scar Yetis",
			"	b. Get 10 Rage Scar Yeti Hides",
			"	c. Kill yetis",
			"	d. Get a Pristine Yeti Hide",
			"	e. Click the Pristine Yeti Hide",
			"		i. Accept "..cq("Pristine Yeti Hide"),
			completion={{questgoal={"*","Rage Scar Yeti Hide",10}},{questaccepted="Pristine Yeti Hide"}},
			mapzone="Feralas",
			level=48,
			mapnote=31608380,
		}, {
			"Go northwest to "..cl(42,22),
			"	a. Talk to Rockbiter",
			"		i. Accept "..cq("The Giant Guardian"),
			completion={{questaccepted="The Giant Guardian"}},
			mapzone="Feralas",
			level=48,
			mapnote=22006440,
		}, {
			"Go northwest to "..cl(39,16),
			"	a. Click the Flame of Byltan",
			"	b. Get the Byltan Essence",
			mapzone="Feralas",
			level=48,
			mapnote=15805430,
		}, {
			"Go northeast to "..cl(40,11),
			"	a. The path up to the Flame of Samha starts here",
			"	b. Jump on the broken pillars to get up to the Flame of Samha",
			mapzone="Feralas",
			level=48,
			mapnote=11005130,
		}, {
			"Go to "..cl(41,13),
			"	a. Click the Flame of Samha",
			"	b. Get the Samha Essence",
			mapzone="Feralas",
			level=48,
			mapnote=12705320,
		}, {
			"Go north to 40,9",
			"	a. Click the Flame of Imbel",
			"	b. Get the Imbel Essence",
			mapzone="Feralas",
			level=48,
			mapnote=9404930,
		}, {
			"Go southwest to "..cl(38,12),
			"	a. Click the Flame of Lahassa",
			"	b. Get the Lahassa Essence",
			mapzone="Feralas",
			level=48,
			mapnote=12204990,
		}, {
			"Go southeast to "..cl(39,13),
			"	a. Use Troya's Staff next to the Equinex Monolith",
			"	b. Click the Equinex Monolith",
			"		i. Turn in "..cq("The Stave of Equinex"),
			"		ii. Accept "..cq("The Morrow Stone"),
			completion={{questturnedin="The Stave of Equinex"},{questaccepted="The Morrow Stone"}},
			mapzone="Feralas",
			level=48,
			mapnote=13205200,
		}, {
			"Go north to "..cl(38,10),
			"	a. Talk to Shay Leafrunner",
			"		i. Turn in "..cq("The Giant Guardian"),
			"		ii. Accept "..cq("Wandering Shay"),
			"	b. Click the small chest next to Shay Leafrunner",
			"	c. Get Shay's Bell",
			"	d. Escort Shay Leafrunner to Rockbiter ",
			"		i. When she runs off, use Shay's Bell to call her back",
			completion={{questturnedin="The Giant Guardian"},{questaccepted="Wandering Shay"}},
			mapzone="Feralas",
			level=48,
			mapnote=10304850,
		}, {
			"At "..cl(42,22),
			"	a. Talk to Rockbiter",
			"		i. Turn in "..cq("Wandering Shay"),
			completion={{questturnedin="Wandering Shay"}},
			mapzone="Feralas",
			level=48,
			mapnote=22006440,
		}, {
			"Go southeast to "..cl(66,46),
			"	a. Talk to Kindal Moonweaver",
			"		i. Accept "..cq("An Orphan Looking For a Home"),
			completion={{questaccepted="An Orphan Looking For a Home"}},
			mapzone="Feralas",
			level=48,
			mapnote=45611150,
		}, {
			"Hearth to Feathermoon Stronghold",
			completion={{location={mapzone="Feralas",x=31.0,y=44.0, dist=5}}},
			mapzone="Feralas",
			level=48,
		}, {
			"Go to "..cl(31,43),
			"	a. Talk to Pratt McGrubben",
			"		i. Turn in "..cq("Improved Quality"),
			"		ii. Turn in "..cq("Pristine Yeti Hide"),
			completion={{questturnedin="Improved Quality"},{questturnedin="Pristine Yeti Hide"}},
			mapzone="Feralas",
			level=48,
			mapnote=42707330,
		}, {
			"Go to "..cl(32,46),
			"	a. Talk to Troyas Moonbreeze",
			"		i. Turn in "..cq("The Morrow Stone"),
			completion={{questturnedin="The Morrow Stone"}},
			mapzone="Feralas",
			level=48,
			mapnote=45607740,
		}, {
			"Fly to Gadgetzan",
			completion={{location={mapzone="Tanaris",x=51.7,y=27.8, dist=6}}},
			mapzone="Feralas",
			level=48,
		}, {
			"Go to "..cl(52,29),
			"	a. Talk to Marin Noggenfogger",
			"		i. Accept "..cq("The Thirsty Goblin"),
			completion={{questaccepted="The Thirsty Goblin"}},
			mapzone="Tanaris",
			level=48,
			mapnote=28708050,
		}, {
			"Make Gadgetzan your home",
			completion={{home="Gadgetzan"}},
			mapzone="Tanaris",
			level=48,
		}, {
			"Go to "..cl(53,27),
			"	a. Talk to Andi Lynn",
			"		i. Accept "..cq("The Dunemaul Compound"),
			completion={{questaccepted="The Dunemaul Compound"}},
			mapzone="Tanaris",
			level=48,
			mapnote=27408020,
		}, {
			"Go to "..cl(52,27),
			"	a. Talk to Tran'rek",
			"		i. Accept "..cq("Thistleshrub Valley"),
			completion={{questaccepted="Thistleshrub Valley"}},
			mapzone="Tanaris",
			level=48,
			mapnote=26807840,
		}, {
			"Go to "..cl(50,27),
			"	a. Talk to Senior Surveyor Fizzledowser",
			"		i. Accept "..cq("Gadgetzan Water Survey"),
			completion={{questaccepted="Gadgetzan Water Survey"}},
			mapzone="Tanaris",
			level=48,
			mapnote=27507770,
		}, {
			"Go west to "..cl(39,29),
			"	a. Use your Untapped Dowsing Widget near the water",
			"	b. Get the Tapped Dowsing Widget",
			completion={{questgoal={"*","Tapped Dowsing Widget",1}}},
			mapzone="Tanaris",
			level=48,
			mapnote=29406800,
		}, {
			"Go east to Gadgetzan",
			completion={{location={mapzone="Tanaris",x=51.7,y=27.8, dist=6}}},
			mapzone="Tanaris",
			level=48,
		}, {
			"Go to "..cl(50,27),
			"	a. Talk to Senior Surveyor Fizzledowser",
			"		i. Turn in "..cq("Gadgetzan Water Survey"),
			"		ii. Accept "..cq("Noxious Lair Investigation"),
			completion={{questturnedin="Gadgetzan Water Survey"},{questaccepted="Noxious Lair Investigation"}},
			mapzone="Tanaris",
			level=48,
			mapnote=27507770,
		}, {
			"Go south to "..cl(53,46),
			"	a. Talk to Marvon Rivetseeker",
			"		i. Turn in "..cq("The Sunken Temple"),
			"		ii. Accept "..cq("The Stone Circle"),
			"		iii. Accept "..cq("Gahz'ridian"),
			completion={{questturnedin="The Sunken Temple"},{questaccepted="The Stone Circle"},{questaccepted="Gahz'ridian"}},
			mapzone="Tanaris",
			level=48,
			mapnote=45909860,
		}, {
			"Go southwest to "..cl(41,55),
			"	a. Kill 10 Dunemaul Brutes",
			"	b. Kill 10 Dunemaul Enforcers",
			completion={{questgoal={"*","Dunemaul Brute slain",10}},{questgoal={"*","Dunemaul Enforcer slain",10}}},
			mapzone="Tanaris",
			level=48,
			mapnote=55009580,
		}, {
			"Go south to "..cl(42,58),
			"	a. Kill Gor'marok the Ravager inside the cave",
			completion={{questgoal={"*","Gor'marok the Ravager slain",1}}},
			mapzone="Tanaris",
			level=48,
			mapnote=57809930,
		}, {
			"Go northwest to "..cl(35,51),
			"	a. Kill Centipaar insects",
			"	b. Get 5 Centipaar Insect Parts",
			completion={{questgoal={"*","Centipaar Insect Parts",5}}},
			mapzone="Tanaris",
			level=48,
			mapnote=51008580,
		}, {
			"Go southwest to "..cl(29,65),
			"	a. Kill 8 Gnarled Thistleshrubs",
			"	b. Kill 8 Thistleshrub Rootshapers",
			"	c. Kill Thistleshrub Dew Collectors",
			"	d. Get a Laden Dew Gland",
			completion={{questgoal={"*","Gnarled Thistleshrub slain",8}},{questgoal={"*","Thistleshrub Rootshaper slain",8}},{questgoal={"*","Laden Dew Gland",1}}},
			mapzone="Tanaris",
			level=48,
			mapnote=65309380,
		}, {
			"Go southeast to "..cl(39,73),
			"	a. Get 30 Gahz'ridian Ornaments",
			completion={{questgoal={"*","Gahz'ridian Ornament",30}}},
			mapzone="Tanaris",
			level=48,
			mapnote=72611110,
		}, {
			"Go northeast to "..cl(53,46),
			"	a. Talk to Marvon Rivetseeker",
			"		i. Turn in "..cq("Gahz'ridian"),
			completion={{questturnedin="Gahz'ridian"}},
			mapzone="Tanaris",
			level=48,
			mapnote=45909860,
		}, {
			"Go northeast to "..cl(67,24),
			"	a. Talk to Yorba Screwspigot",
			"		i. Accept "..cq("Yuka Screwspigot"),
			completion={{questaccepted="Yuka Screwspigot"}},
			mapzone="Tanaris",
			level=48,
			mapnote=24009100,
		}, {
			"Go to "..cl(67,22),
			"	a. Talk to Yeh'kinya",
			"		i. Turn in "..cq("Screecher Spirits"),
			completion={{questturnedin="Screecher Spirits"}},
			mapzone="Tanaris",
			level=48,
			mapnote=22408940,
		}, {
			"Grind to level 49",
			completion={{level=49}},
			mapzone="Tanaris",
			level=48,
		}, {
			"Hearth to Gadgetzan",
			completion={{location={mapzone="Tanaris",x=51.7,y=27.8, dist=6}}},
			mapzone="Tanaris",
			level=49,
		}, {
			"Go to "..cl(52,29),
			"	a. Talk to Marin Noggenfogger",
			"		i. Turn in "..cq("The Thirsty Goblin"),
			"		ii. Accept "..cq("In Good Taste"),
			completion={{questturnedin="The Thirsty Goblin"},{questaccepted="In Good Taste"}},
			mapzone="Tanaris",
			level=49,
			mapnote=28708050,
		}, {
			"Go to "..cl(53,27),
			"	a. Talk to Andi Lynn",
			"		i. Turn in "..cq("The Dunemaul Compound"),
			completion={{questturnedin="The Dunemaul Compound"}},
			mapzone="Tanaris",
			level=49,
			mapnote=27408020,
		}, {
			"Go to "..cl(52,27),
			"	a. Talk to Tran'rek",
			"		i. Turn in "..cq("Thistleshrub Valley"),
			completion={{questturnedin="Thistleshrub Valley"}},
			mapzone="Tanaris",
			level=49,
			mapnote=26807840,
		}, {
			"Go to "..cl(51,27),
			"	a. Talk to Sprinkle",
			"		i. Turn in "..cq("In Good Taste"),
			"		ii. Accept "..cq("Sprinkle's Secret Ingredient"),
			completion={{questturnedin="In Good Taste"},{questaccepted="Sprinkle's Secret Ingredient"}},
			mapzone="Tanaris",
			level=49,
			mapnote=26907800,
		}, {
			"Also at "..cl(51,27),
			"	a. Talk to Alchemist Pestlezugg",
			"		i. Turn in "..cq("Noxious Lair Investigation"),
			completion={{questturnedin="Noxious Lair Investigation"}},
			mapzone="Tanaris",
			level=49,
			mapnote=27007790,
		}, {
			"Go to "..cl(50,27),
			"	a. Talk to Senior Surveyor Fizzledowser",
			"		i. Accept "..cq("The Scrimshank Redemption"),
			completion={{questaccepted="The Scrimshank Redemption"}},
			mapzone="Tanaris",
			level=49,
			mapnote=27507770,
		}, {
			"Go southeast to "..cl(56,69),
			"	a. The path to Scrimshank's Surveying Gear starts here",
			"	b. Follow the spiral path down to the bottom",
			"	c. Enter the tunnel heading north",
			"	d. At the fork, take a right into the big oval room",
			"	e. Enter the tunnel on the other side of the room",
			"	f. At the fork, go right into the big squarish room",
			completion={{location={mapzone="Tanaris",x=55.9,y=70.2, dist=1}}},
			mapzone="Tanaris",
			level=49,
			mapnote=71212720,
		}, {
			"Go to "..cl(56,71),
			"	a. Get Scrimshank's Surveying Gear",
			completion={{questgoal={"*","Scrimshank's Surveying Gear",1}}},
			mapzone="Tanaris",
			level=49,
			mapnote=71212720,
		}, {
			"Go north to Gadgetzan",
			completion={{location={mapzone="Tanaris",x=51.7,y=27.8, dist=6}}},
			mapzone="Tanaris",
			level=49,
		}, {
			"Go to "..cl(50,27),
			"	a. Talk Senior Surveyor Fizzledowser",
			"		i. Turn in "..cq("The Scrimshank Redemption"),
			"		ii. Accept "..cq("Insect Part Analysis part 1"),
			completion={{questturnedin="The Scrimshank Redemption"},{questaccepted="Insect Part Analysis part 1"}},
			mapzone="Tanaris",
			level=49,
			mapnote=27507770,
		}, {
			"Go to "..cl(51,27),
			"	a. Talk to Alchemist Pestlezugg",
			"		i. Turn in "..cq("Insect Part Analysis part 1"),
			"		ii. Accept "..cq("Insect Part Analysis part 2"),
			completion={{questturnedin="Insect Part Analysis part 1"},{questaccepted="Insect Part Analysis part 2"}},
			mapzone="Tanaris",
			level=49,
			mapnote=27007790,
		}, {
			"Go to "..cl(50,27),
			"	a. Talk to Senior Surveyor Fizzledowser",
			"		i. Turn in "..cq("Insect Part Analysis part 2"),
			"		ii. Accept "..cq("Rise of the Silithid"),
			completion={{questturnedin="Insect Part Analysis part 2"},{questaccepted="Rise of the Silithid"}},
			mapzone="Tanaris",
			level=49,
			mapnote=27507770,
		}, {
			"Make sure you have your 2 Elixirs of Fortitude in your bags",
			mapzone="Tanaris",
			level=49,
		}, {
			"Go north to Thousand Needles",
			completion={{location={mapzone="Thousand Needles"}}},
			mapzone="Tanaris",
			level=49,
		}, {
			"Go northeast to the Mirage Raceway",
			completion={{location={mapzone="Thousand Needles",x=78.6,y=76.0, dist=6}}},
			mapzone="Thousand Needles",
			level=49,
		}, {
			"Go to "..cl(78,75),
			"	a. Talk to Quentin",
			"		i. Turn in "..cq("An Orphan Looking For a Home"),
			"		ii. Accept "..cq("A Short Incubation"),
			"		iii. Turn in "..cq("A Short Incubation"),
			"		iv. Accept "..cq("The Newest Member of the Family"),
			completion={{questturnedin="An Orphan Looking For a Home"},{questaccepted="A Short Incubation"},{questturnedin="A Short Incubation"},{questaccepted="The Newest Member of the Family"}},
			mapzone="Thousand Needles",
			level=49,
			mapnote=74715300,
		}, {
			"Go south to Tanaris",
			completion={{location={mapzone="Tanaris"}}},
			mapzone="Thousand Needles",
			level=49,
		}, {
			"Fly to Theramore",
			completion={{location={mapzone="Dustwallow Marsh",x=67.5,y=50.3, dist=9}}},
			mapzone="Tanaris",
			level=49,
		}, {
			"Ride the boat to Menethil Harbor",
			completion={{location={mapzone="Wetlands",x=4.6,y=56.8, dist=9}}},
			mapzone="Dustwallow Marsh",
			level=49,
		}, {
			"Fly to Ironforge",
			completion={{location={mapzone="City of Ironforge"}}},
			mapzone="Wetlands",
			level=49,
		}, {
			"Go to "..cl(78,12),
			"	a. Talk to Historian Karnik",
			"		i. Accept "..cq("Passing the Burden"),
			completion={{questaccepted="Passing the Burden"}},
			mapzone="Ironforge",
			level=49,
			mapnote=11808930,
		}, {
			"Go to 31,5",
			"	a. Talk to Tymor",
			"		i. Turn in "..cq("Passing the Burden"),
			"		ii. Accept "..cq("Arcane Runes"),
			"		iii. Accept "..cq("An Easy Pickup"),
			completion={{questturnedin="Passing the Burden"},{questaccepted="Arcane Runes"},{questaccepted="An Easy Pickup"}},
			mapzone="Ironforge",
			level=49,
			mapnote=4803580,
		}, {
			"Go to "..cl(71,95),
			"	a. Talk to Xiggs Fuselighter",
			"		i. Turn in "..cq("An Easy Pickup"),
			"		ii. Accept "..cq("Signal for Pickup"),
			"		iii. Turn in "..cq("Signal for Pickup"),
			completion={{questturnedin="An Easy Pickup"},{questaccepted="Signal for Pickup"},{questturnedin="Signal for Pickup"}},
			mapzone="Ironforge",
			level=49,
			mapnote=94616550,
		}, {
			"Fly to Aerie Peak",
			completion={{location={mapzone="The Hinterlands",x=13.4,y=46.5, dist=4}}},
			mapzone="Ironforge",
			level=49,
		}, {
			"Go to "..cl(14,44),
			"	a. Talk to Agnar Beastamer",
			"		i. Turn in "..cq("The Newest Member of the Family"),
			"		ii. Accept "..cq("Food for Baby"),
			completion={{questturnedin="The Newest Member of the Family"},{questaccepted="Food for Baby"}},
			mapzone="The Hinterlands",
			level=49,
			mapnote=43605780,
		}, {
			"Go southeast to "..cl(41,59),
			"	a. Click a Violet Tragan underwater",
			"	b. Get a Violet Tragan",
			completion={{questgoal={"*","Violet Tragan",1}}},
			mapzone="The Hinterlands",
			level=49,
			mapnote=59109980,
		}, {
			"Go east to "..cl(70,58),
			"	a. Kill Silvermane Stalkers",
			"	b. Get 5 Silvermane Stalker Flanks",
			completion={{questgoal={"*","Silvermane Stalker Flank",5}}},
			mapzone="The Hinterlands",
			level=49,
			mapnote=58012800,
		}, {
			"Go west to Aerie Peak",
			completion={{location={mapzone="The Hinterlands",x=13.4,y=46.5, dist=4}}},
			mapzone="The Hinterlands",
			level=49,
		}, {
			"Go to "..cl(14,44),
			"	a. Talk to Agnar Beastamer",
			"		i. Turn in "..cq("Food for Baby"),
			"		ii. Accept "..cq("Becoming a Parent"),
			"		iii. Turn in "..cq("Becoming a Parent"),
			completion={{questturnedin="Food for Baby"},{questaccepted="Becoming a Parent"},{questturnedin="Becoming a Parent"}},
			mapzone="The Hinterlands",
			level=49,
			mapnote=43605780,
		}, {
			"Fly to Booty Bay",
			completion={{location={mapzone="Stranglethorn Vale",x=27.7,y=74.6, dist=6}}},
			mapzone="The Hinterlands",
			level=49,
		}, {
			"Make Booty Bay your home",
			completion={{home="Booty Bay"}},
			mapzone="Stranglethorn Vale",
			level=49,
		}, {
			"Go to "..cl(27,77),
			"	a. Talk to Whiskey Slim",
			"		i. Turn in "..cq("Whiskey Slim's Lost Grog"),
			completion={{questturnedin="Whiskey Slim's Lost Grog"}},
			mapzone="Stranglethorn Vale",
			level=49,
			mapnote=77510460,
		}, {
			"Go to "..cl(28,77),
			"	a. Talk to Fin Fizracket",
			"		i. Accept "..cq("Stranglethorn Fever"),
			completion={{questaccepted="Stranglethorn Fever"}},
			mapzone="Stranglethorn Vale",
			level=49,
			mapnote=76710430,
		}, {
			"Go east to "..cl(33,78),
			"	a. It's a very small, blueish, bottle buried randomly in the sand near the water",
			"	b. Click a Half-Buried Bottle",
			"	c. Get the Carefully Folded Note",
			"	d. Click the Carefully Folded Note",
			"		i. Accept "..cq("Message in a Bottle part 1"),
			completion={{questaccepted="Message in a Bottle part 1"}},
			mapzone="Stranglethorn Vale",
			level=49,
			mapnote=77811090,
		}, {
			"Go northwest to "..cl(31,68),
			"	a. Kill gorillas",
			"	b. Get 1 Gorilla Fang",
			mapzone="Stranglethorn Vale",
			level=49,
			mapnote=68009920,
		}, {
			"Go northeast to "..cl(35,60),
			"	a. Talk to Witch Doctor Unbagwa",
			"	b. Give him 1 Gorilla Fang",
			"	c. 3 gorillas will attack you one at a time",
			"		i. Mokk the Savage is the final gorilla",
			"	d. Kill Mokk the Savage",
			"	e. Get the Heart of Mokk",
			completion={{questgoal={"*","Heart of Mokk",1}}},
			mapzone="Stranglethorn Vale",
			level=49,
			mapnote=60409570,
		}, {
			"Go north to "..cl(38,36),
			"	a. Kill King Bangalash",
			"	b. Get the Head of Bangalash",
			completion={{questgoal={"*","Head of Bangalash",1}}},
			mapzone="Stranglethorn Vale",
			level=49,
			mapnote=36107440,
		}, {
			"Go north to "..cl(36,11),
			"	a. Talk to Hemet Nesingwary Jr.",
			"		i. Turn in "..cq("Big Game Hunter"),
			completion={{questturnedin="Big Game Hunter"}},
			mapzone="Stranglethorn Vale",
			level=49,
			mapnote=10704650,
		}, {
			"Go northeast to the Rebel Camp",
			completion={{location={mapzone="Stranglethorn Vale",x=38.0,y=3.7, dist=2}}},
			mapzone="Stranglethorn Vale",
			level=49,
		}, {
			"Fly to Booty Bay",
			completion={{location={mapzone="Stranglethorn Vale",x=27.7,y=74.6, dist=6}}},
			mapzone="Stranglethorn Vale",
			level=49,
		}, {
			"Go to "..cl(28,77),
			"	a. Talk to Fin Fizracket",
			"		i. Turn in "..cq("Stranglethorn Fever"),
			completion={{questturnedin="Stranglethorn Fever"}},
			mapzone="Stranglethorn Vale",
			level=49,
			mapnote=76710430,
		}, {
			"Go southeast to "..cl(39,81),
			"	a. Talk to Princess Poobah",
			"		i. Turn in "..cq("Message in a Bottle part 1"),
			"		ii. Accept "..cq("Message in a Bottle part 2"),
			completion={{questturnedin="Message in a Bottle part 1"},{questaccepted="Message in a Bottle part 2"}},
			mapzone="Stranglethorn Vale",
			level=49,
			mapnote=80611910,
		}, {
			"Go southeast to "..cl(41,83),
			"	a. Kill King Mukla",
			"	b. Get the Shackle Key",
			completion={{questgoal={"*","Shackle Key",1}}},
			mapzone="Stranglethorn Vale",
			level=49,
			mapnote=83012400,
		}, {
			"Go northwest to "..cl(39,81),
			"	a. Talk to Princess Poobah",
			"		i. Turn in "..cq("Message in a Bottle part 2"),
			completion={{questturnedin="Message in a Bottle part 2"}},
			mapzone="Stranglethorn Vale",
			level=49,
			mapnote=80611910,
		}, {
			"While doing the next 3 thing, look for Cortello's Riddle on the ships",
			"	a. Accept 'Cortello's Riddle' part 1 from it",
			mapzone="Stranglethorn Vale",
			level=49,
		}, {
			"Go southwest to "..cl(33,88),
			"	a. Kill Captain Stillwater on the ship",
			completion={{questgoal={"*","Captain Stillwater slain",1}}},
			mapzone="Stranglethorn Vale",
			level=49,
			mapnote=88212110,
		}, {
			"Go southwest to "..cl(31,91),
			"	a. Kill Fleet Master Firallon on the ship",
			completion={{questgoal={"*","Fleet Master Firallon slain",1}}},
			mapzone="Stranglethorn Vale",
			level=49,
			mapnote=90612120,
		}, {
			"Go northwest to "..cl(29,88),
			"	a. Kill Captain Keelhaul on the ship",
			completion={{questgoal={"*","Captain Keelhaul slain",1}}},
			mapzone="Stranglethorn Vale",
			level=49,
			mapnote=88311750,
		}, {
			"Hearth to Booty Bay",
			completion={{location={mapzone="Stranglethorn Vale",x=27.7,y=74.6, dist=6}}},
			mapzone="Stranglethorn Vale",
			level=49,
		}, {
			"Go to "..cl(27,77),
			"	a. Talk to Fleet Master Seahorn",
			"		i. Turn in "..cq("The Bloodsail Buccaneers part 5"),
			completion={{questturnedin="The Bloodsail Buccaneers part 5"}},
			mapzone="Stranglethorn Vale",
			level=49,
			mapnote=77010420,
		}, {
			"Fly to Stormwind",
			completion={{location={mapzone="Stormwind City"}}},
			mapzone="Stranglethorn Vale",
			level=49,
		}, {
			"Buy a Mithril Casing from the Auction House",
			mapzone="Stormwind City",
			level=49,
		}, {
			"Fly to Darkshire",
			completion={{location={mapzone="Duskwood",x=74.7,y=46.9, dist=7}}},
			mapzone="Stormwind City",
			level=49,
		}, {
			"Go east to Deadwind Pass",
			completion={{location={mapzone="Deadwind Pass"}}},
			mapzone="Duskwood",
			level=49,
		}, {
			"Go east to the Swamp of Sorrows",
			completion={{location={mapzone="Swamp of Sorrows"}}},
			mapzone="Deadwind Pass",
			level=49,
		}, {
			"Go to "..cl(23,48),
			"	a. Click the Soggy Scroll under the bridge",
			"	b. Turn in "..cq("Cortello's Riddle part 1"),
			"	c. Accept "..cq("Cortello's Riddle part 2"),
			completion={{questturnedin="Cortello's Riddle part 1"},{questaccepted="Cortello's Riddle part 2"}},
			mapzone="Swamp of Sorrows",
			level=49,
			mapnote=48207110,
		}, {
			"Go southeast to the Blasted Lands",
			completion={{location={mapzone="Blasted Lands"}}},
			mapzone="Swamp of Sorrows",
			level=49,
		}, {
			"Go south to "..cl(51,14),
			"	a. Talk to Bloodmage Lynnore",
			"		i. Accept "..cq("The Basilisk's Bite"),
			"		ii. Accept "..cq("Vulture's Vigor"),
			"	b. Talk to Bloodmage Drazial",
			"		i. Accept "..cq("Snickerfang Jowls"),
			"		ii. Accept "..cq("A Boar's Vitality"),
			"		iii. Accept "..cq("The Decisive Striker"),
			completion={{questaccepted="The Basilisk's Bite"},{questaccepted="Vulture's Vigor"},{questaccepted="Snickerfang Jowls"},{questaccepted="A Boar's Vitality"},{questaccepted="The Decisive Striker"}},
			mapzone="Blasted Lands",
			level=49,
			mapnote=14206490,
		}, {
			"Grind to level 50",
			completion={{level=50}},
			mapzone="Blasted Lands",
			level=49,
		}
	  },
	},
	{ sectiontitle = "Levels (50-55)",
	  steps = {
		{
			"Follow this Grinding Circle in the next 6 steps until you have:",
			"	a. 6 Blasted Boar Lungs",
			"	b. 5 Snickerfang Jowls",
			"	c. 14 Vulture Gizzards",
			"	d. 11 Basilisk Brains",
			"	e. 6 Scorpok Pincers",
			mapzone="Blasted Lands",
			level=50,
		}, {
			"Go southwest to "..cl(49,18),
			"	a. This is Grind Point One",
			"	b. Kill boars, hyenas, vultures, basilisks, and scorpions",
			mapzone="Blasted Lands",
			level=50,
			mapnote=18006670,
		}, {
			"Go southwest to "..cl(45,26),
			"	a. This is Grind Point Two",
			"	b. Kill boars, hyenas, vultures, basilisks, and scorpions",
			mapzone="Blasted Lands",
			level=50,
			mapnote=26207110,
		}, {
			"Go south to "..cl(46,34),
			"	a. This is Grind Point Three",
			"	b. Kill boars, hyenas, vultures, basilisks, and scorpions",
			mapzone="Blasted Lands",
			level=50,
			mapnote=34308010,
		}, {
			"Go east to "..cl(56,37),
			"	a. This is Grind Point Four",
			"	b. Kill boars, hyenas, vultures, basilisks, and scorpions",
			mapzone="Blasted Lands",
			level=50,
			mapnote=36809300,
		}, {
			"Go north to "..cl(56,30),
			"	a. This is Grind Point Five",
			"	b. Kill boars, hyenas, vultures, basilisks, and scorpions",
			mapzone="Blasted Lands",
			level=50,
			mapnote=30508680,
		}, {
			"Go northeast to "..cl(63,28),
			"	a. This is Grind Point Six",
			"	b. Kill boars, hyenas, vultures, basilisks, and scorpions",
			mapzone="Blasted Lands",
			level=50,
			mapnote=27808910,
		}, {
			"Go to "..cl(51,14),
			"	a. Talk to Bloodmage Lynnore",
			"		i. Turn in "..cq("The Basilisk's Bite"),
			"		ii. Turn in "..cq("Vulture's Vigor"),
			"	b. Talk to Bloodmage Drazial",
			"		i. Turn in "..cq("Snickerfang Jowls"),
			"		ii. Turn in "..cq("A Boar's Vitality"),
			"		iii. Turn in "..cq("The Decisive Striker"),
			completion={{questturnedin="The Basilisk's Bite"},{questturnedin="Vulture's Vigor"},{questturnedin="Snickerfang Jowls"},{questturnedin="A Boar's Vitality"},{questturnedin="The Decisive Striker"}},
			mapzone="Blasted Lands",
			level=50,
			mapnote=14206490,
		}, {
			"Go to "..cl(52,36),
			"	a. Talk to Kum'isha the Collector",
			"	b. If you found an Imperfect Draenethyst Fragment while grinding:",
			"		i. Accept "..cq("Everything Counts In Large Amounts"),
			"	c. If you were ridiculously lucky and you found a Flawless Draenethyst Sphere:",
			"		i. Accept "..cq("To Server Kum'isha"),
			"		ii. Turn in "..cq("Everything Counts In Large Amounts"),
			"		iii. Turn in "..cq("To Serve Kum'isha"),
			completion={{questaccepted="Everything Counts In Large Amounts"},{questaccepted="To Serve Kum'isha"},{questturnedin="Everything Counts In Large Amounts"},{questturnedin="To Serve Kum'isha"}},
			mapzone="Blasted Lands",
			level=50,
			mapnote=35608740,
		}, {
			"Go northeast to Nethergarde Keep",
			completion={{location={mapzone="Blasted Lands",x=65.4,y=19.2, dist=9}}},
			mapzone="Blasted Lands",
			level=50,
		}, {
			"Fly to Booty Bay",
			completion={{location={mapzone="Stranglethorn Vale",x=27.7,y=74.6, dist=6}}},
			mapzone="Blasted Lands",
			level=50,
		}, {
			"Ride the boat to Ratchet",
			completion={{location={mapzone="The Barrens",x=63.0,y=38.1, dist=2}}},
			mapzone="Stranglethorn Vale",
			level=50,
		}, {
			"Go to "..cl(63,39),
			"	a. Click the little brown box outside the house on the ground",
			"	b. Get the Stone Circle",
			completion={{questgoal={"*","Stone Circle",1}}},
			mapzone="The Barrens",
			level=50,
			mapnote=38510100,
		}, {
			"Go to "..cl(62,39),
			"	a. Talk to Liz Rizzlefix",
			"		i. Accept "..cq("Volcanic Activity"),
			completion={{questaccepted="Volcanic Activity"}},
			mapzone="The Barrens",
			level=50,
			mapnote=38710110,
		}, {
			"Fly to Gadgetzan",
			completion={{location={mapzone="Tanaris",x=51.7,y=27.8, dist=6}}},
			mapzone="The Barrens",
			level=50,
		}, {
			"Go to "..cl(51,27),
			"	a. Talk Sprinkle",
			"		i. Turn in "..cq("Sprinkle's Secret Ingredient"),
			"		ii. Accept "..cq("Delivery for Marin"),
			completion={{questturnedin="Sprinkle's Secret Ingredient"},{questaccepted="Delivery for Marin"}},
			mapzone="Tanaris",
			level=50,
			mapnote=26907800,
		}, {
			"Go to "..cl(52,29),
			"	a. Talk to Marin Noggenfogger",
			"		i. Turn in "..cq("Delivery for Marin"),
			"		ii. Accept "..cq("Noggenfogger Elixir"),
			"		iii. Turn in "..cq("Noggenfogger Elixir"),
			completion={{questturnedin="Delivery for Marin"},{questaccepted="Noggenfogger Elixir"},{questturnedin="Noggenfogger Elixir"}},
			mapzone="Tanaris",
			level=50,
			mapnote=28708050,
		}, {
			"Go south to "..cl(53,46),
			"	a. Talk to Marvon Rivetseeker",
			"		i. Turn in "..cq("The Stone Circle"),
			completion={{questturnedin="The Stone Circle"}},
			mapzone="Tanaris",
			level=50,
			mapnote=45909860,
		}, {
			"Go north to Gadgetzan",
			completion={{location={mapzone="Tanaris",x=51.7,y=27.8, dist=6}}},
			mapzone="Tanaris",
			level=50,
		}, {
			"Fly to Ratchet",
			completion={{location={mapzone="The Barrens",x=63.0,y=38.1, dist=2}}},
			mapzone="Tanaris",
			level=50,
		}, {
			"Ride the boat to Booty Bay",
			completion={{location={mapzone="Stranglethorn Vale",x=27.7,y=74.6, dist=6}}},
			mapzone="The Barrens",
			level=50,
		}, {
			"Fly to Ironforge",
			completion={{location={mapzone="City of Ironforge"}}},
			mapzone="Stranglethorn Vale",
			level=50,
		}, {
			"Buy 15 Silk Cloth from the Auction House",
			mapzone="Ironforge",
			level=50,
		}, {
			"Go to "..cl(18,51),
			"	a. Talk to Innkeeper Firebrew",
			"		i. Accept "..cq("Assisting Arch Druid Staghelm"),
			completion={{questaccepted="Assisting Arch Druid Staghelm"}},
			mapzone="Ironforge",
			level=50,
			mapnote=51506970,
		}, {
			"Make Ironforge your home",
			completion={{home="Ironforge"}},
			mapzone="Ironforge",
			level=50,
		}, {
			"Fly to Thelsamar",
			completion={{location={mapzone="Loch Modan",x=35.1,y=46.9, dist=3}}},
			mapzone="Ironforge",
			level=50,
		}, {
			"Go southeast to the Badlands",
			completion={{location={mapzone="Badlands"}}},
			mapzone="Loch Modan",
			level=50,
		}, {
			"Go southwest to "..cl(5,61),
			"	a. The path over to Searing Gorge starts here",
			completion={{location={mapzone="Badlands",x=4.9,y=61.2, dist=0.3}}},
			mapzone="Badlands",
			level=50,
			mapnote=61206610,
		}, {
			"Follow the path over to Searing Gorge",
			completion={{location={mapzone="Searing Gorge"}}},
			mapzone="Badlands",
			level=50,
		}, {
			"Go west to Thorium Point",
			completion={{location={mapzone="Searing Gorge",x=35.9,y=27.7, dist=3}}},
			mapzone="Searing Gorge",
			level=50,
		}, {
			"Go to "..cl(38,27),
			"	a. Click the Wanted/Missing/Lost & Found Poster",
			"		i. Accept "..cq("JOB OPPORTUNITY: Culling the Competition"),
			"		ii. Accept "..cq("STOLEN: Smithing Tuyere and Lookout's Spyglass"),
			"		iii. Accept "..cq("WANTED: Overseer Maltorius"),
			completion={{questaccepted="JOB OPPORTUNITY: Culling the Competition"},{questaccepted="STOLEN: Smithing Tuyere and Lookout's Spyglass"},{questaccepted="WANTED: Overseer Maltorius"}},
			mapzone="Searing Gorge",
			level=50,
			mapnote=26506410,
		}, {
			"Go to "..cl(39,28),
			"	a. Talk to Hansel Heavyhands",
			"		i. Accept "..cq("Curse These Fat Fingers"),
			"		ii. Accept "..cq("Fiery Menace!"),
			"		iii. Accept "..cq("Incendosaurs? Whateverosaur is More Like It"),
			completion={{questaccepted="Curse These Fat Fingers"},{questaccepted="Fiery Menace!"},{questaccepted="Incendosaurs? Whateverosaur is More Like It"}},
			mapzone="Searing Gorge",
			level=50,
			mapnote=27806640,
		}, {
			"Go to "..cl(39,29),
			"	a. Talk to Master Smith Burninate",
			"		i. Accept "..cq("What the Flux?"),
			completion={{questaccepted="What the Flux?"}},
			mapzone="Searing Gorge",
			level=50,
			mapnote=28506730,
		}, {
			"Go to "..cl(38,31),
			"	a. Talk to Lanie Reed",
			"		i. Get the Thorium Point Flight Path",
			completion={{flightpath="Thorium Point"}},
			mapzone="Searing Gorge",
			level=50,
			mapnote=30906880,
		}, {
			"Go south to "..cl(39,39),
			"	a. Talk to Kalaran Windblade",
			"		i. Accept "..cq("Divine Retribution"),
			"		ii. Turn in "..cq("Divine Retribution"),
			"		iii. Accept "..cq("The Flawless Flame"),
			completion={{questaccepted="Divine Retribution"},{questturnedin="Divine Retribution"},{questaccepted="The Flawless Flame"}},
			mapzone="Searing Gorge",
			level=50,
			mapnote=38907790,
		}, {
			"Go south to "..cl(37,49),
			"	a. Kill Dark Iron Steamsmiths",
			"	b. Get the Smithing Tuyere",
			"	c. Kill Dark Iron dwarves",
			"	d. Get the Grimesilt Outhouse Key",
			"	e. Click the Grimesilt Outhouse Key",
			"		i. Accept "..cq("The Key to Freedom"),
			completion={{questgoal={"*","Smithing Tuyere",1}},{questaccepted="The Key to Freedom"}},
			mapzone="Searing Gorge",
			level=50,
			mapnote=49408620,
		}, {
			"Go west to "..cl(33,49),
			"	a. Kill 20 Heavy War Golems",
			completion={{questgoal={"*","Heavy War Golem slain",20}}},
			mapzone="Searing Gorge",
			level=50,
			mapnote=49208170,
		}, {
			"Go southeast to "..cl(33,52),
			"	a. Kill Dark Iron Lookouts",
			"	b. Get the Lookout's Spyglass",
			completion={{questgoal={"*","Lookout's Spyglass",1}}},
			mapzone="Searing Gorge",
			level=50,
			mapnote=51808490,
		}, {
			"Go south to "..cl(32,62),
			"	a. Kill 20 Greater Lava Spiders",
			completion={{questgoal={"*","Greater Lava Spider slain",20}}},
			mapzone="Searing Gorge",
			level=50,
			mapnote=62209420,
		}, {
			"Go south to "..cl(31,75),
			"	a. Kill Magma Elementals",
			"	b. Get 4 Golem Oils",
			"	c. Kill Inferno Elementals",
			"	d. Get 4 Hearts of Flame",
			completion={{questgoal={"*","Golem Oil",4}},{questgoal={"*","Heart of Flame",4}}},
			mapzone="Searing Gorge",
			level=50,
			mapnote=72810360,
		}, {
			"Go east to "..cl(65,76),
			"	a. The path up to Margol the Rager starts here",
			completion={{location={mapzone="Searing Gorge",x=65.2,y=76.3, dist=0.3}}},
			mapzone="Searing Gorge",
			level=50,
			mapnote=76214140,
		}, {
			"Go northeast to "..cl(71,73),
			"	a. Kill Margol the Rager",
			"	b. Get Margol's Horn",
			"	c. Click Margol's Horn",
			"		i. Accept "..cq("The Horn of the Beast"),
			completion={{questaccepted="The Horn of the Beast"}},
			mapzone="Searing Gorge",
			level=50,
			mapnote=73314400,
		}, {
			"Grind to level 51",
			completion={{level=51}},
			mapzone="Searing Gorge",
			level=50,
		}, {
			"Go northwest to "..cl(66,62),
			"	a. Click the Wooden Outhouse",
			"		i. Turn in "..cq("The Key to Freedom"),
			"		ii. Accept "..cq("Caught!"),
			completion={{questturnedin="The Key to Freedom"},{questaccepted="Caught!"}},
			mapzone="Searing Gorge",
			level=51,
			mapnote=62312780,
		}, {
			"Go northwest to "..cl(63,60),
			"	a. Kill 8 Dark Iron Geologists",
			completion={{questgoal={"*","Dark Iron Geologist slain",8}}},
			mapzone="Searing Gorge",
			level=51,
			mapnote=59712300,
		}, {
			"Go southeast to "..cl(66,62),
			"	a. Click the Wooden Outhouse",
			"		i. Turn in "..cq("Caught!"),
			"		ii. Accept "..cq("Ledger from Tranaris"),
			"	b. Click the book he slides under the door",
			"	c. Get the Goodsteel Ledger",
			completion={{questturnedin="Caught!"},{questaccepted="Ledger from Tranaris"},{questgoal={"*","Goodsteel Ledger",1}}},
			mapzone="Searing Gorge",
			level=51,
			mapnote=62312780,
		}, {
			"Go southwest to "..cl(62,72),
			"	a. Kill Glassweb Spiders",
			"	b. Get 20 Solid Crystal Leg Shafts",
			completion={{questgoal={"*","Solid Crystal Leg Shaft",20}}},
			mapzone="Searing Gorge",
			level=51,
			mapnote=72013370,
		}, {
			"Go north to "..cl(64,61),
			"	a. Talk to Dorius Stonetender",
			"		i. Accept "..cq("Suntara Stones part 1"),
			"	b. Escort him until he gets murdered at 75,19(it's part of the quest)",
			"	c. He drops a note when he dies",
			"	d. Click the Singed Letter",
			"		i. Turn in "..cq("Suntara Stones part 1"),
			"		ii. Accept "..cq("Suntara Stones part 2"),
			completion={{questaccepted="Suntara Stones part 1"},{questturnedin="Suntara Stones part 1"},{questaccepted="Suntara Stones part 2"}},
			mapzone="Searing Gorge",
			level=51,
			mapnote=61012490,
		}, {
			"Go southwest to "..cl(39,39),
			"	a. Talk to Kalaran Windblade",
			"		i. Turn in "..cq("The Flawless Flame"),
			"		ii. Accept "..cq("Forging the Shaft"),
			completion={{questturnedin="The Flawless Flame"},{questaccepted="Forging the Shaft"}},
			mapzone="Searing Gorge",
			level=51,
			mapnote=38907790,
		}, {
			"Go southeast to "..cl(42,47),
			"	a. Kill Dark Iron Steamsmiths",
			"	b. Get 8 Thorium Plated Daggers",
			completion={{questgoal={"*","Thorium Plated Dagger",8}}},
			mapzone="Searing Gorge",
			level=51,
			mapnote=47108950,
		}, {
			"Go northwest to "..cl(39,39),
			"	a. Talk to Kalaran Windblade",
			"		i. Turn in "..cq("Forging the Shaft"),
			"		ii. Accept "..cq("The Flame's Casing"),
			completion={{questturnedin="Forging the Shaft"},{questaccepted="The Flame's Casing"}},
			mapzone="Searing Gorge",
			level=51,
			mapnote=38907790,
		}, {
			"Go north to Thorium Point",
			completion={{location={mapzone="Searing Gorge",x=35.9,y=27.7, dist=3}}},
			mapzone="Searing Gorge",
			level=51,
		}, {
			"Go to "..cl(39,28),
			"	a. Talk Hansel Heavyhands",
			"		i. Turn in "..cq("Curse These Fat Fingers"),
			"		ii. Turn in "..cq("Fiery Menace!"),
			"	b. Talk to Taskmaster Scrange",
			"		i. Turn in "..cq("STOLEN: Smithing Tuyere and Lookout's Spyglass"),
			completion={{questturnedin="Curse These Fat Fingers"},{questturnedin="Fiery Menace!"},{questturnedin="STOLEN: Smithing Tuyere and Lookout's Spyglass"}},
			mapzone="Searing Gorge",
			level=51,
			mapnote=27806640,
		}, {
			"Hearth to Ironforge",
			completion={{location={mapzone="City of Ironforge"}}},
			mapzone="Searing Gorge",
			level=51,
		}, {
			"Go to 68,8",
			"	a. Talk to Curator Thorius",
			"		i. Turn in "..cq("Suntara Stones part 2"),
			"		ii. Accept "..cq("Dwarven Justice"),
			completion={{questturnedin="Suntara Stones part 2"},{questaccepted="Dwarven Justice"}},
			mapzone="Ironforge",
			level=51,
			mapnote=8307610,
		}, {
			"Fly to Thelsamar",
			completion={{location={mapzone="Loch Modan",x=35.1,y=46.9, dist=3}}},
			mapzone="Ironforge",
			level=51,
		}, {
			"Go southwest to "..cl(18,84),
			"	a. Talk to Mountaineer Pebblebitty",
			"		i. Turn in "..cq("The Horn of the Beast"),
			"		ii. Accept "..cq("Proof of Deed"),
			completion={{questturnedin="The Horn of the Beast"},{questaccepted="Proof of Deed"}},
			mapzone="Loch Modan",
			level=51,
			mapnote=84010220,
		}, {
			"Go northeast to Thelsamar",
			completion={{location={mapzone="Loch Modan",x=35.1,y=46.9, dist=3}}},
			mapzone="Loch Modan",
			level=51,
		}, {
			"Fly to Ironforge",
			completion={{location={mapzone="City of Ironforge"}}},
			mapzone="Loch Modan",
			level=51,
		}, {
			"Go to 68,8",
			"	a. Talk to Curator Thorius",
			"		i. Turn in "..cq("Proof of Deed"),
			"		ii. Accept "..cq("At Last!"),
			completion={{questturnedin="Proof of Deed"},{questaccepted="At Last!"}},
			mapzone="Ironforge",
			level=51,
			mapnote=8307610,
		}, {
			"Go to "..cl(76,23),
			"	a. Talk to Laris Geardawdle",
			"		i. Accept "..cq("A Little Slime Goes a Long Way part 1"),
			completion={{questaccepted="A Little Slime Goes a Long Way part 1"}},
			mapzone="Ironforge",
			level=51,
			mapnote=23409920,
		}, {
			"Fly to Thelsamar",
			completion={{location={mapzone="Loch Modan",x=35.1,y=46.9, dist=3}}},
			mapzone="Ironforge",
			level=51,
		}, {
			"Go southwest to "..cl(18,84),
			"	a. Talk to Mountaineer Pebblebitty",
			"		i. Turn in "..cq("At Last!"),
			completion={{questturnedin="At Last!"}},
			mapzone="Loch Modan",
			level=51,
			mapnote=84010220,
		}, {
			"Go northeast to Thelsamar",
			completion={{location={mapzone="Loch Modan",x=35.1,y=46.9, dist=3}}},
			mapzone="Loch Modan",
			level=51,
		}, {
			"Fly to Thorium Point",
			completion={{location={mapzone="Searing Gorge",x=35.9,y=27.7, dist=3}}},
			mapzone="Loch Modan",
			level=51,
		}, {
			"Go southwest to "..cl(41,54),
			"	a. The entrance to the Slag Pit is here",
			"	b. It's up on the Metal Riser Walkway things",
			completion={{location={mapzone="Searing Gorge",x=41.5,y=54.7, dist=0.5}}},
			mapzone="Searing Gorge",
			level=51,
			mapnote=53809510,
		}, {
			"Follow the path, go left though the Jail Door",
			completion={{location={mapzone="Searing Gorge",x=37.6,y=44.3, dist=0.5}}},
			mapzone="Searing Gorge",
			level=51,
		}, {
			"Go to "..cl(41,26),
			"	a. Talk to the Dying Archeologist",
			"		i. Turn in "..cq("Dwarven Justice"),
			"		ii. Accept "..cq("Release Them"),
			completion={{questturnedin="Dwarven Justice"},{questaccepted="Release Them"}},
			mapzone="Searing Gorge",
			level=51,
			mapnote=25506670,
		}, {
			"While in the Slag Pit:",
			"	a. Kill 15 Dark Iron Taskmasters",
			"	b. Kill 15 Dark Iron Slavers",
			completion={{questgoal={"*","Dark Iron Taskmaster slain",15}},{questgoal={"*","Dark Iron Slaver slain",15}}},
			mapzone="Searing Gorge",
			level=51,
		}, {
			"Go up the big metal ramp into the big room",
			completion={{location={mapzone="Searing Gorge",x=42.9,y=33.2, dist=0.5}}},
			mapzone="Searing Gorge",
			level=51,
		}, {
			"Go southwest to "..cl(41,36),
			"	a. Kill Overseer Maltorius",
			"	b. Get his head",
			completion={{questgoal={"*","Head of Overseer Maltorius",1}}},
			mapzone="Searing Gorge",
			level=51,
			mapnote=35807670,
		}, {
			"Also at "..cl(41,36),	
			"	a. Click the Secret Plans: Fiery Flux, behind Overseer Maltorius",
			"	b. Get the Secret Plans: Fiery Flux",
			completion={{questgoal={"*","Secret Plans: Fiery Flux",1}}},
			mapzone="Searing Gorge",
			level=51,
			mapnote=35707620,
		}, {
			"Go southeast to "..cl(48,42),
			"	a. Jump off the bridge to the path below",
			completion={{location={mapzone="Searing Gorge",x=47.6,y=41.9, dist=0.3}}},
			mapzone="Searing Gorge",
			level=51,
			mapnote=41808950,
		}, {
			"Go northeast to "..cl(52,37),
			"	a. Kill 20 Incendosaurs",
			completion={{questgoal={"*","Incendosaur slain",20}}},
			mapzone="Searing Gorge",
			level=51,
			mapnote=37208870,
		}, {
			"Go to Thorium Point",
			completion={{location={mapzone="Searing Gorge",x=35.9,y=27.7, dist=3}}},
			mapzone="Searing Gorge",
			level=51,
		}, {
			"Go to "..cl(38,28),
			"	a. Talk to Lookout Captain Lolo Longstriker",
			"		i. Turn in "..cq("WANTED: Overseer Maltorius"),
			completion={{questturnedin="WANTED: Overseer Maltorius"}},
			mapzone="Searing Gorge",
			level=51,
			mapnote=26506410,
		}, {
			"Go to "..cl(39,28),
			"	a. Talk to Hansel Heavyhands",
			"		i. Turn in "..cq("Incendosaurs? Whateverosaur is More Like It"),
			completion={{questturnedin="Incendosaurs? Whateverosaur is More Like It"}},
			mapzone="Searing Gorge",
			level=51,
			mapnote=27806640,
		}, {
			"Also at "..cl(39,28),	
			"	a. Talk to Taskmaster Scrange",
			"		i. Turn in "..cq("JOB OPPORTUNITY: Culling the Competition"),
			completion={{questturnedin="JOB OPPORTUNITY: Culling the Competition"}},
			mapzone="Searing Gorge",
			level=51,
			mapnote=27506650,
		}, {
			"Go to "..cl(39,29),
			"	a. Talk to Master Smith Burninate",
			"		i. Turn in "..cq("What the Flux?"),
			completion={{questturnedin="What the Flux?"}},
			mapzone="Searing Gorge",
			level=51,
			mapnote=28506730,
		}, {
			"Go northwest to "..cl(29,26),
			"	a. Slowly work your way to this spot",
			"	b. Jump onto the red crystal in the lava",
			"	c. Click it and get the Mysterious Artifact",
			"	d. Kill Twilight mobs around the lava",
			"	e. Get the Symbol of Ragnaros",
			completion={{questgoal={"*","Mysterious Artifact",1}},{questgoal={"*","Symbol of Ragnaros",1}}},
			mapzone="Searing Gorge",
			level=51,
			mapnote=25905500,
		}, {
			"Also at "..cl(29,26),	
			"	a. Talk to Zamael Lunthistle",
			"		i. Accept "..cq("Prayer to Elune part 1"),
			"		ii. Turn in "..cq("Prayer to Elune part 1"),
			"		iii. Accept "..cq("Prayer to Elune part 2"),
			"	g. Kill Twilight mobs",
			"	h. Get the Prayer to Elune",
			completion={{questaccepted="Prayer to Elune part 1"},{questturnedin="Prayer to Elune part 1"},{questaccepted="Prayer to Elune part 2"},{questgoal={"*","Prayer to Elune",1}}},
			mapzone="Searing Gorge",
			level=51,
			mapnote=26405600,
		}, {
			"Go southeast to "..cl(39,39),
			"	a. Talk to Kalaran Windblade",
			"		i. Turn in "..cq("The Flame's Casing"),
			"		ii. Accept "..cq("The Torch of Retribution part 1"),
			"		iii. Turn in "..cq("The Torch of Retribution part 1"),
			"		iv. Accept "..cq("The Torch of Retribution part 2"),
			"	b. Click the green glowing floating Torch of Retribution",
			"		i. Turn in "..cq("The Torch of Retribution part 2"),
			"		ii. Accept "..cq("Squire Maltrake"),
			"	c. Talk to Squire Maltrake",
			"		i. Turn in "..cq("Squire Maltrake"),
			"		ii. Accept "..cq("Set Them Ablaze!"),
			completion={{questturnedin="The Flame's Casing"},{questaccepted="The Torch of Retribution part 1"},{questturnedin="The Torch of Retribution part 1"},{questaccepted="The Torch of Retribution part 2"},{questturnedin="The Torch of Retribution part 2"},{questaccepted="Squire Maltrake"},{questturnedin="Squire Maltrake"},{questaccepted="Set Them Ablaze!"}},
			mapzone="Searing Gorge",
			level=51,
			mapnote=38907790,
		}, {
			"Grind to level 52",
			completion={{level=52}},
			mapzone="Searing Gorge",
			level=51,
		}, {
			"Go into the Slag Pit",
			completion={{location={mapzone="Searing Gorge",x=41.5,y=54.7, dist=0.5}}},
			mapzone="Searing Gorge",
			level=52,
		}, {
			"Go to "..cl(41,26),
			"	a. Click the Altar of Suntara",
			"		i. Turn in "..cq("Release Them"),
			"	b. Talk to the Dying Archeologist",
			"		i. Accept "..cq("Rise, Obsidion!"),
			"	c. Kill Lathoric the Black",
			"	d. Get the Head of Lathoric the Black",
			"	e. Kill Obsidion",
			"	f. Get the Heart of Obsidion",
			completion={{questturnedin="Release Them"},{questaccepted="Rise, Obsidion!"},{questgoal={"*","Head of Lathoric the Black",1}},{questgoal={"*","Heart of Obsidion",1}}},
			mapzone="Searing Gorge",
			level=52,
			mapnote=25506670,
		}, {
			"Leave the Slag Pit, go up top of the Cauldron",
			mapzone="Searing Gorge",
			level=52,
		}, {
			"Equip the Torch of Retribution",
			mapzone="Searing Gorge",
			level=52,
		}, {
			"Go to "..cl(50,55),
			"	a. Click the metal blazer at the top of the tower",
			"	b. Set the Eastern Tower Ablaze",
			completion={{questgoal={"*","Eastern Tower Ablaze",1}}},
			mapzone="Searing Gorge",
			level=52,
			mapnote=54710480,
		}, {
			"Go southwest to "..cl(44,61),
			"	a. Click the metal blazer at the top of the tower",
			"	b. Set the Southern Tower Ablaze",
			completion={{questgoal={"*","Southern Tower Ablaze",1}}},
			mapzone="Searing Gorge",
			level=52,
			mapnote=60910490,
		}, {
			"Go west to "..cl(36,61),
			"	a. Click the metal blazer at the top of the tower",
			"	b. Set the Western Tower Ablaze",
			completion={{questgoal={"*","Western Tower Ablaze",1}}},
			mapzone="Searing Gorge",
			level=52,
			mapnote=60709640,
		}, {
			"Go northwest to "..cl(33,54),
			"	a. Click the metal blazer at the top of the tower",
			"	b. Set the Northern Tower Ablaze",
			completion={{questgoal={"*","Northern Tower Ablaze",1}}},
			mapzone="Searing Gorge",
			level=52,
			mapnote=54508780,
		}, {
			"Go northeast to "..cl(39,39),
			"	a. Talk to Squire Maltrake",
			"		i. Turn in "..cq("Set Them Ablaze!"),
			"	b. Click the small grey chest on the ground",
			"		i. Accept "..cq("Trinkets..."),
			"	c. Click the chest again",
			"		i. Turn in "..cq("Trinkets..."),
			"	d. Make sure to save the Black Dragonflight Molt",
			completion={{questturnedin="Set Them Ablaze!"},{questaccepted="Trinkets..."},{questturnedin="Trinkets..."}},
			mapzone="Searing Gorge",
			level=52,
			mapnote=38907790,
		}, {
			"Go north to Thorium Point",
			completion={{location={mapzone="Searing Gorge",x=35.9,y=27.7, dist=3}}},
			mapzone="Searing Gorge",
			level=52,
		}, {
			"Fly to Nethergarde Keep",
			completion={{location={mapzone="Blasted Lands",x=65.4,y=19.2, dist=9}}},
			mapzone="Searing Gorge",
			level=52,
		}, {
			"Go to "..cl(67,19),
			"	a. Talk to Thadius Grimshade",
			"		i. Turn in "..cq("Thadius Grimshade"),
			completion={{questturnedin="Thadius Grimshade"}},
			mapzone="Blasted Lands",
			level=52,
			mapnote=19408640,
		}, {
			"Go to "..cl(68,19),
			"	a. Talk to Ambassador Ardalan",
			"		i. Accept "..cq("Petty Squabbles"),
			completion={{questaccepted="Petty Squabbles"}},
			mapzone="Blasted Lands",
			level=52,
			mapnote=19308680,
		}, {
			"Go northwest to the Swamp of Sorrows",
			completion={{location={mapzone="Swamp of Sorrows"}}},
			mapzone="Blasted Lands",
			level=52,
		}, {
			"Go to "..cl(34,66),
			"	a. Talk to the Fallen Hero of the Horde",
			"		i. Turn in "..cq("Petty Squabbles"),
			"		ii. Accept "..cq("A Tale of Sorrow"),
			"	b. Talk to the Fallen Hero of the Horde",
			"		i. Listen to his story",
			"		ii. Turn in "..cq("A Tale of Sorrow"),
			completion={{questturnedin="Petty Squabbles"},{questaccepted="A Tale of Sorrow"},{questturnedin="A Tale of Sorrow"}},
			mapzone="Swamp of Sorrows",
			level=52,
			mapnote=66110040,
		}, {
			"Go east to "..cl(93,62),
			"	a. Kill Jarquia",
			"	b. Get Goodsteel's Balanced Flameberge",
			completion={{questgoal={"*","Goodsteel's Balanced Flameberge",1}}},
			mapzone="Swamp of Sorrows",
			level=52,
			mapnote=61615500,
		}, {
			"Hearth to Ironforge",
			completion={{location={mapzone="City of Ironforge"}}},
			mapzone="Swamp of Sorrows",
			level=52,
		}, {
			"Go to "..cl(68,8),
			"	a. Talk to Curator Thorius",
			"		i. Turn in "..cq("Rise, Obsidion!"),
			completion={{questturnedin="Rise, Obsidion!"}},
			mapzone="Ironforge",
			level=52,
			mapnote=8307610,
		}, {
			"Fly to Menethil Harbor",
			completion={{location={mapzone="Wetlands",x=10.1,y=56.7, dist=9}}},
			mapzone="Ironforge",
			level=52,
		}, {
			"Ride the boat to Auberdine",
			completion={{location={mapzone="Darkshore",x=32.8,y=42.0, dist=9}}},
			mapzone="Wetlands",
			level=52,
		}, {
			"Fly to Rut'theran Village",
			completion={{location={mapzone="Teldrassil",x=56.3,y=92.4, dist=6}}},
			mapzone="Darkshore",
			level=52,
		}, {
			"Go to Darnassus",
			completion={{location={mapzone="Darnassus"}}},
			mapzone="Teldrassil",
			level=52,
		}, {
			"Go to "..cl(38,81),
			"	a. Talk to Astarii Starseeker",
			"		i. Turn in "..cq("Prayer to Elune part 2"),
			completion={{questturnedin="Prayer to Elune part 2"}},
			mapzone="Darnassus",
			level=52,
			mapnote=80911920,
		}, {
			"Go to "..cl(42,86),
			"	a. Talk to Gracina Spiritmight",
			"		i. Turn in "..cq("Rise of the Silithid"),
			"		ii. Accept "..cq("March of the Silithid"),
			completion={{questturnedin="Rise of the Silithid"},{questaccepted="March of the Silithid"}},
			mapzone="Darnassus",
			level=52,
			mapnote=85612740,
		}, {
			"Go to 35,9",
			"	a. Talk to Arch Druid Fandral Staghelm",
			"		i. Turn in "..cq("Assisting Arch Druid Staghelm"),
			"		ii. Accept "..cq("Un'Goro Soil"),
			completion={{questturnedin="Assisting Arch Druid Staghelm"},{questaccepted="Un'Goro Soil"}},
			mapzone="Darnassus",
			level=52,
			mapnote=9104420,
		}, {
			"Fly to Theramore",
			completion={{location={mapzone="Dustwallow Marsh",x=67.5,y=50.3, dist=9}}},
			mapzone="Darnassus",
			level=52,
		}, {
			"Go west to "..cl(54,56),
			"	a. Click the Damaged Crate",
			"	b. Get the Overdue Package",
			completion={{questgoal={"*","Overdue Package",1}}},
			mapzone="Dustwallow Marsh",
			level=52,
			mapnote=55911000,
		}, {
			"Go southwest to "..cl(31,66),
			"	a. Click the Musty Scroll",
			"		i. Turn in "..cq("Cortello's Riddle part 2"),
			completion={{questturnedin="Cortello's Riddle part 2"}},
			mapzone="Dustwallow Marsh",
			level=52,
			mapnote=66209730,
		}, {
			"Go southeast to Mudsprocket",
			completion={{location={mapzone="Dustwallow Marsh",x=42.0,y=73.3, dist=2}}},
			mapzone="Dustwallow Marsh",
			level=52,
		}, {
			"Fly to Gadgetzan",
			completion={{location={mapzone="Tanaris",x=51.7,y=27.8, dist=6}}},
			mapzone="Dustwallow Marsh",
			level=52,
		}, {
			"Go to "..cl(51,29),
			"	a. Talk to Krinkle Goodsteel",
			"		i. Turn in "..cq("Ledger fromo Tanaris"),
			completion={{questturnedin="Ledger from Tanaris"}},
			mapzone="Tanaris",
			level=52,
			mapnote=28808030,
		}, {
			"Go to "..cl(52,27),
			"	a. Talk to Tran'rek",
			"		i. Accept "..cq("Super Sticky"),
			completion={{questaccepted="Super Sticky"}},
			mapzone="Tanaris",
			level=52,
			mapnote=26807840,
		}, {
			"Go to "..cl(51,27),
			"	a. Talk to Alchemist Pestlezugg",
			"		i. Turn in "..cq("March of the Silithid"),
			"		ii. Accept "..cq("Bungle in the Jungle"),
			completion={{questturnedin="March of the Silithid"},{questaccepted="Bungle in the Jungle"}},
			mapzone="Tanaris",
			level=52,
			mapnote=27007790,
		}, {
			"Go southwest to the Un'Goro Crater",
			completion={{location={mapzone="Un'Goro Crater"}}},
			mapzone="Tanaris",
			level=52,
		}, {
			"Go north to "..cl(72,76),
			"	a. Talk to Torwa Pathfinder",
			"		i. Accept "..cq("The Apes of Un'Goro"),
			"		ii. Accept "..cq("The Fare of Lar'korwi"),
			completion={{questaccepted="The Apes of Un'Goro"},{questaccepted="The Fare of Lar'korwi"}},
			mapzone="Un'Goro Crater",
			level=52,
			mapnote=76014760,
		}, {
			"While walking around Un'Goro Crater, look for the following on the ground:",
			"	a. Green Power Crystals: Get 7 of these",
			"	b. Red Power Crystals: Get 7 of these",
			"	c. Blue Power Crystals: Get 7 of these",
			"	d. Yellow Power Crystals: Get 7 of these",
			"	e. Bloodpetal Sprouts: get as many as you can, try for a lot",
			mapzone="Un'Goro Crater",
			level=52,
		}, {
			"Go west to "..cl(68,76),
			"	a. Kill Ravasaurs",
			"	b. Get A Mangled Journal",
			"	c. Click the Mangled Journal",
			"		i. Accept "..cq("Williden's Journal"),
			completion={{questaccepted="Williden's Journal"}},
			mapzone="Un'Goro Crater",
			level=52,
			mapnote=75814400,
		}, {
			"Go northwest to "..cl(63,69),
			"	a. Click the Wrecked Raft",
			"		i. Accept "..cq("It's a Secret to Everybody part 1"),
			completion={{questaccepted="It's a Secret to Everybody part 1"}},
			mapzone="Un'Goro Crater",
			level=52,
			mapnote=68513150,
		}, {
			"Also at "..cl(63,69),	
			"	a. Click the Small Pack underwater next to the shore",
			"		i. Turn in "..cq("It's a Secret to Everybody part 1"),
			"		ii. Accept "..cq("It's a Secret to Everybody part 2"),
			"	b. Click the Small Pack in your bags",
			"		i. Get the Large Compass",
			"		ii. Get the Curled Map Parchment",
			"		iii. Get the Lion-headed Key",
			completion={{questturnedin="It's a Secret to Everybody part 1"},{questaccepted="It's a Secret to Everybody part 2"},{questgoal={"*","Large Compass",1}},{questgoal={"*","Curled Map Parchment",1}},{questgoal={"*","Lion-headed Key",1}}},
			mapzone="Un'Goro Crater",
			level=52,
			mapnote=69113220,
		}, {
			"Go northeast to "..cl(69,57),
			"	a. Click the Fresh Threshadon Carcass",
			"	b. Get a Piece of Threshadon Carcass",
			completion={{questgoal={"*","Piece of Threshadon Carcass",1}}},
			mapzone="Un'Goro Crater",
			level=52,
			mapnote=56712530,
		}, {
			"Go southeast to "..cl(72,76),
			"	a. Talk to Torwa Pathfinder",
			"		i. Turn in "..cq("The Fare of Lar'korwi"),
			"		ii. Accept "..cq("The Scent of Lar'korwi"),
			completion={{questturnedin="The Fare of Lar'korwi"},{questaccepted="The Scent of Lar'korwi"}},
			mapzone="Un'Goro Crater",
			level=52,
			mapnote=76014760,
		}, {
			"Go northwest to "..cl(67,73),
			"	a. Kill raptors near egg nests",
			"	b. Stand on the egg nests around this area",
			"	c. Kill Lar'korwi Mates",
			"	d. Get 2 Ravasaur Pheromone Glands",
			completion={{questgoal={"*","Ravasaur Pheromone Gland",2}}},
			mapzone="Un'Goro Crater",
			level=52,
			mapnote=73114040,
		}, {
			"Go southeast to "..cl(72,76),
			"	a. Talk to Torwa Pathfinder",
			"		i. Turn in "..cq("The Scent of Lar'korwi"),
			"		ii. Accept "..cq("The Bait for Lar'korwi"),
			completion={{questturnedin="The Scent of Lar'korwi"},{questaccepted="The Bait for Lar'korwi"}},
			mapzone="Un'Goro Crater",
			level=52,
			mapnote=76014760,
		}, {
			"Go northeast to "..cl(80,50),
			"	a. Stand on the big grey flat rock",
			"	b. Click Torwa's Pouch in your bags",
			"	c. Click the Preserved Threshadon Meat in your bags",
			"	d. Click the Preserved Pheromone Mixture in your bags",
			"	e. Kill Lar'korwi",
			"	f. Get Lar'korwi's Head",
			completion={{questgoal={"*","Lar'korwi's Head",1}}},
			mapzone="Un'Goro Crater",
			level=52,
			mapnote=49912980,
		}, {
			"Go northwest to "..cl(66,16),
			"	a. Kill Un'Goro Gorillas inside the cave",
			"	b. Get 2 Un'Goro Gorilla Pelts",
			"	c. Kill Un'Goro Stompers inside the cave",
			"	d. Get 2 Un'Goro Stomper Pelts",
			"	e. Kill Un'Goro Thunderers inside the cave",
			"	f. Get 2 Un'Goro Thunderer Pelts",
			completion={{questgoal={"*","Un'Goro Gorilla Pelt",2}},{questgoal={"*","Un'Goro Stomper Pelt",2}},{questgoal={"*","Un'Goro Thunderer Pelt",2}}},
			mapzone="Un'Goro Crater",
			level=52,
			mapnote=15508120,
		}, {
			"Go west to "..cl(46,13),
			"	a. Talk to Karna Remtravel",
			"		i. Accept "..cq("Chasing A-Me 01"),
			completion={{questaccepted="Chasing A-Me 01"}},
			mapzone="Un'Goro Crater",
			level=52,
			mapnote=13405980,
		}, {
			"Go northwest to "..cl(45,8),
			"	a. Talk to Linken",
			"		i. Turn in "..cq("It's a Secret to Everybody part 2"),
			"		ii. Accept "..cq("It's a Secret to Everybody part 3"),
			completion={{questturnedin="It's a Secret to Everybody part 2"},{questaccepted="It's a Secret to Everybody part 3"}},
			mapzone="Un'Goro Crater",
			level=52,
			mapnote=8105280,
		}, {
			"Go to "..cl(45,6),
			"	a. Talk to Gryfe",
			"		i. Get the Marshal's Refuge Flight Path",
			completion={{flightpath="Marshal's Refuge"}},
			mapzone="Un'Goro Crater",
			level=52,
			mapnote=5805100,
		}, {
			"Go to "..cl(44,7),
			"	a. Talk to Williden Marshal",
			"		i. Turn in "..cq("Williden's Journal"),
			"		ii. Accept "..cq("Expedition Salvation"),
			"	b. Talk to Hol'anyee Marshal",
			"		i. Accept "..cq("Alien Ecology"),
			completion={{questturnedin="Williden's Journal"},{questaccepted="Expedition Salvation"},{questaccepted="Alien Ecology"}},
			mapzone="Un'Goro Crater",
			level=52,
			mapnote=7205110,
		}, {
			"Go to "..cl(43,7),
			"	a. Talk to Spark Nilminer",
			"		i. Accept "..cq("Roll the Bones"),
			completion={{questaccepted="Roll the Bones"}},
			mapzone="Un'Goro Crater",
			level=52,
			mapnote=7405090,
		}, {
			"Go to "..cl(44,8),
			"	a. Click the sign",
			"		i. Accept "..cq("Beware of Pterrordax"),
			"	b. Talk to Spraggle Frock",
			"		i. Accept "..cq("Lost!"),
			completion={{questaccepted="Beware of Pterrordax"},{questaccepted="Lost!"}},
			mapzone="Un'Goro Crater",
			level=52,
			mapnote=8505210,
		}, {
			"Go to "..cl(43,10),
			"	a. Talk to Muigin",
			"		i. Accept "..cq("Muigin and Larion"),
			completion={{questaccepted="Muigin and Larion"}},
			mapzone="Un'Goro Crater",
			level=52,
			mapnote=9605250,
		}, {
			"Go to "..cl(44,12),
			"	a. Talk to Shizzle",
			"		i. Accept "..cq("Shizzle's Flyer"),
			completion={{questaccepted="Shizzle's Flyer"}},
			mapzone="Un'Goro Crater",
			level=52,
			mapnote=11605580,
		}, {
			"Go to "..cl(42,3),
			"	a. Talk to J.D. Collie inside the cave",
			"		i. Accept "..cq("Crystals of Power"),
			"		ii. Turn in "..cq("Crystals of Power"),
			"		iii. Accept "..cq("The Northern Pylon"),
			"		iv. Accept "..cq("The Eastern Pylon"),
			"		v. Accept "..cq("The Western Pylon"),
			completion={{questaccepted="Crystals of Power"},{questturnedin="Crystals of Power"},{questaccepted="The Northern Pylon"},{questaccepted="The Eastern Pylon"},{questaccepted="The Western Pylon"}},
			mapzone="Un'Goro Crater",
			level=52,
			mapnote=2704460,
		}, {
			"Go south to "..cl(47,19),
			"	a. Kill Tar mobs",
			"	b. Get 12 Super Sticky Tar",
			completion={{questgoal={"*","Super Sticky Tar",12}}},
			mapzone="Un'Goro Crater",
			level=52,
			mapnote=18706590,
		}, {
			"Grind to level 53",
			completion={{level=53}},
			mapzone="Un'Goro Crater",
			level=52,
		}, {
			"Go northeast to "..cl(57,12),
			"	a. Go up the hill",
			"	b. Click the Northern Pylon",
			"	c. Examine the Northern Pylon",
			completion={{questgoal={"*","Discover and examine the Northern Crystal Pylon",1}}},
			mapzone="Un'Goro Crater",
			level=53,
			mapnote=12406890,
		}, {
			"Go north to 57,9",
			"	a. Kill 10 Pterrordaxes",
			completion={{questgoal={"*","Pterrordax slain",10}}},
			mapzone="Un'Goro Crater",
			level=53,
			mapnote=8606550,
		}, {
			"Go east into the gorilla cave",
			completion={{location={mapzone="Un'Goro Crater",x=63.1,y=17.1, dist=1}}},
			mapzone="Un'Goro Crater",
			level=53,
		}, {
			"Go to "..cl(68,17),
			"	a. Talk to A-Me 01",
			"		i. Turn in "..cq("Chasing A-Me 01"),
			completion={{questturnedin="Chasing A-Me 01"}},
			mapzone="Un'Goro Crater",
			level=53,
			mapnote=16808450,
		}, {
			"Go south to "..cl(67,33),
			"	a. Kill Pterrordaxes",
			"	b. Get 8 Webbed Pterrordax Scales",
			"	c. Kill Diemetradons",
			"	d. Get 8 Webbed Diemetradon Scales",
			"	e. Get 8 Dinosaur Bones",
			completion={{questgoal={"*","Webbed Pterrordax Scale",8}},{questgoal={"*","Webbed Diemetradon Scale",8}},{questgoal={"*","Dinosaur Bone",8}}},
			mapzone="Un'Goro Crater",
			level=53,
			mapnote=32609990,
		}, {
			"Go southwest to "..cl(66,36),
			"	a. Kill Bloodpetals",
			"	b. Get 15 Bloodpetals",
			completion={{questgoal={"*","Bloodpetal",15}}},
			mapzone="Un'Goro Crater",
			level=53,
			mapnote=36010210,
		}, {
			"Go east to "..cl(69,37),
			"	a. Click the Crate of Foodstuffs",
			"	b. Get the Crate of Foodstuffs",
			completion={{questgoal={"*","Crate of Foodstuffs",1}}},
			mapzone="Un'Goro Crater",
			level=53,
			mapnote=36510500,
		}, {
			"Go southeast to "..cl(77,50),
			"	a. Go up the hill",
			"	b. Click the Eastern Pylon",
			"	c. Examine the Eastern Pylon",
			completion={{questgoal={"*","Discover and examine the Eastern Crystal Pylon",1}}},
			mapzone="Un'Goro Crater",
			level=53,
			mapnote=50012720,
		}, {
			"Go southwest to "..cl(72,76),
			"	a. Talk to Torwa Pathfiner",
			"		i. Turn in "..cq("The Bait for Lar'korwi"),
			"		ii. Turn in "..cq("The Apes of Un'Goro"),
			completion={{questturnedin="The Bait for Lar'korwi"},{questturnedin="The Apes of Un'Goro"}},
			mapzone="Un'Goro Crater",
			level=53,
			mapnote=76014760,
		}, {
			"Go west to "..cl(50,78),
			"	a. The path down into the Slithering Scar starts here",
			completion={{location={mapzone="Un'Goro Crater",x=50.5,y=78.4, dist=0.5}}},
			mapzone="Un'Goro Crater",
			level=53,
			mapnote=78412890,
		}, {
			"Also at "..cl(50,78),	
			"	a. Go down the path",
			"	b. Go left at the fork into the circular room",
			"	c. In the middle of the room, use your Unused Scraping Vial",
			"	d. Get a Hive Wall Sample",
			completion={{questgoal={"*","Hive Wall Sample",1}}},
			mapzone="Un'Goro Crater",
			level=53,
			mapnote=85313400,
		}, {
			"Go out of the hive",
			"	a. Kill Gorishi insects",
			"	b. Get a Gorishi Scent Gland",
			completion={{questgoal={"*","Gorishi Scent Gland",1}}},
			mapzone="Un'Goro Crater",
			level=53,
			mapnote=78412890,
		}, {
			"Go northwest to "..cl(38,66),
			"	a. Click the Research Equipment",
			"	b. Get the Research Equipment",
			completion={{questgoal={"*","Research Equipment",1}}},
			mapzone="Un'Goro Crater",
			level=53,
			mapnote=66110460,
		}, {
			"Go northwest to "..cl(24,59),
			"	a. Go up the hill",
			"	b. Click the Western Pylon",
			"	c. Examine the Western Pylon",
			completion={{questgoal={"*","Discover and examine the Western Crystal Pylon",1}}},
			mapzone="Un'Goro Crater",
			level=53,
			mapnote=59208300,
		}, {
			"Go west to "..cl(21,59),
			"	a. Kill 15 Frenzied Pterrordaxes",
			completion={{questgoal={"*","Frenzied Pterrordax slain",15}}},
			mapzone="Un'Goro Crater",
			level=53,
			mapnote=59408080,
		}, {
			"Go northeast to "..cl(31,50),
			"	a. Talk to Krakle",
			"		i. Accept "..cq("Finding the Source"),
			completion={{questaccepted="Finding the Source"}},
			mapzone="Un'Goro Crater",
			level=53,
			mapnote=50408130,
		}, {
			"Go southeast to "..cl(46,53),
			"	a. Kill fire elementals",
			"	b. Get 9 Un'Goro Ash",
			completion={{questgoal={"*","Un'Goro Ash",9}}},
			mapzone="Un'Goro Crater",
			level=53,
			mapnote=53209900,
		}, {
			"Follow the path up the moutain",
			mapzone="Un'Goro Crater",
			level=53,
		}, {
			"Go northeast to "..cl(50,46),
			"	a. Use Krakle's Thermometer on the Fire Plume Ridge Hot Spot",
			"	b. Find the hottest area of Fire Plume Ridge",
			completion={{questgoal={"*","Find the hottest area of Fire Plume Ridge",1}}},
			mapzone="Un'Goro Crater",
			level=53,
			mapnote=45709540,
		}, {
			"Go west to "..cl(31,50),
			"	a. Talk to Krakle",
			"		i. Turn in "..cq("Finding the Source"),
			"		ii. Accept "..cq("The New Springs"),
			completion={{questturnedin="Finding the Source"},{questaccepted="The New Springs"}},
			mapzone="Un'Goro Crater",
			level=53,
			mapnote=50408130,
		}, {
			"Go east to "..cl(52,50),
			"	a. Talk to Ringo",
			"		i. Go up the path on the mountain, he's inside the purple glowing cave",
			"		ii. Turn in "..cq("Lost!"),
			"		iii. Accept "..cq("A Little Help From My Friends"),
			"	b. Escort Ringo to Marshal's Refuge",
			"	c. When he passes out, use Sproggle's Canteen on him to revive him",
			completion={{questturnedin="Lost!"},{questaccepted="A Little Help From My Friends"},{questgoal={"*","Escort Ringo to Spraggle Frock at Marshal's Refuge",1}}},
			mapzone="Un'Goro Crater",
			level=53,
			mapnote=49910180,
		}, {
			"Go to "..cl(44,8),
			"	a. Talk to Spraggle Frock",
			"		i. Turn in "..cq("Beware of Pterrordax"),
			"		ii. Turn in "..cq("A Little Help From My Friends"),
			completion={{questturnedin="Beware of Pterrordax"},{questturnedin="A Little Help From My Friends"}},
			mapzone="Un'Goro Crater",
			level=53,
			mapnote=8505210,
		}, {
			"Go to "..cl(44,7),
			"	a. Talk to Williden Marshal",
			"		i. Turn in "..cq("Expedition Salvation"),
			"	b. Talk to Hol'anyee Marshal",
			"		i. Turn in "..cq("Alien Ecology"),
			completion={{questturnedin="Expedition Salvation"},{questturnedin="Alien Ecology"}},
			mapzone="Un'Goro Crater",
			level=53,
			mapnote=7205110,
		}, {
			"Go to "..cl(43,7),
			"	a. Talk to Spark Nilminer",
			"		i. Turn in "..cq("Roll the Bones"),
			completion={{questturnedin="Roll the Bones"}},
			mapzone="Un'Goro Crater",
			level=53,
			mapnote=7405090,
		}, {
			"Go to "..cl(42,3),
			"	a. Talk to J.D. Collie inside the cave",
			"		i. Turn in "..cq("The Northern Pylon"),
			"		ii. Turn in "..cq("The Eastern Pylon"),
			"		iii. Turn in "..cq("The Western Pylon"),
			"		iv. Accept "..cq("Making Sense of It"),
			"		v. Turn in "..cq("Making Sense of It"),
			completion={{questturnedin="The Northern Pylon"},{questturnedin="The Eastern Pylon"},{questturnedin="The Western Pylon"},{questaccepted="Making Sense of It"},{questturnedin="Making Sense of It"}},
			mapzone="Un'Goro Crater",
			level=53,
			mapnote=2704460,
		}, {
			"Go to "..cl(43,10),
			"	a. Talk to Muigin",
			"		i. Turn in "..cq("Muigin and Larion"),
			"		ii. Accept "..cq("A Visit to Gregan"),
			completion={{questturnedin="Muigin and Larion"},{questaccepted="A Visit to Gregan"}},
			mapzone="Un'Goro Crater",
			level=53,
			mapnote=9605250,
		}, {
			"Go to "..cl(44,12),
			"	a. Talk to Shizzle",
			"		i. Turn in "..cq("Shizzle's Flyer"),
			completion={{questturnedin="Shizzle's Flyer"}},
			mapzone="Un'Goro Crater",
			level=53,
			mapnote=11605580,
		}, {
			"Grind to level 54",
			completion={{level=54}},
			mapzone="Un'Goro Crater",
			level=53,
		}, {
			"Go southwest to "..cl(29,22),
			"	a. The path over to Silithus starts here",
			completion={{location={mapzone="Un'Goro Crater",x=29.3,y=22.2, dist=0.5}}},
			mapzone="Un'Goro Crater",
			level=54,
			mapnote=22205150,
		}, {
			"Go to Silithus",
			completion={{location={mapzone="Silithus"}}},
			mapzone="Un'Goro Crater",
			level=54,
		}, {
			"Go southwest to Cenarion Hold",
			completion={{location={mapzone="Silithus",x=50.4,y=36.5, dist=3}}},
			mapzone="Silithus",
			level=54,
		}, {
			"Go to "..cl(51,35),
			"	a. Talk to Cloud Skydancer",
			"		i. Get the Cenarion Hold Flight Path",
			completion={{flightpath="Cenarion Hold"}},
			mapzone="Silithus",
			level=54,
			mapnote=34508510,
		}, {
			"Fly to Gadgetzan",
			completion={{location={mapzone="Tanaris",x=51.7,y=27.8, dist=6}}},
			mapzone="Silithus",
			level=54,
		}, {
			"Go to "..cl(52,27),
			"	a. Talk to Tran'rek",
			"		i. Turn in "..cq("Super Sticky"),
			completion={{questturnedin="Super Sticky"}},
			mapzone="Tanaris",
			level=54,
			mapnote=26807840,
		}, {
			"Go to "..cl(51,27),
			"	a. Talk to Alchemist Pestlezugg",
			"		i. Turn in "..cq("Bungle in the Jungle"),
			completion={{questturnedin="Bungle in the Jungle"}},
			mapzone="Tanaris",
			level=54,
			mapnote=27007790,
		}, {
			"Fly to Rut'theran Village",
			completion={{location={mapzone="Teldrassil",x=56.3,y=92.4, dist=6}}},
			mapzone="Tanaris",
			level=54,
		}, {
			"Go to Darnassus",
			completion={{location={mapzone="Darnassus"}}},
			mapzone="Teldrassil",
			level=54,
		}, {
			"Go to "..cl(31,8),
			"	a. Talk to Jenal",
			"		i. Turn in "..cq("Un'Goro Soil"),
			completion={{questturnedin="Un'Goro Soil"}},
			mapzone="Darnassus",
			level=54,
			mapnote=8203970,
		}, {
			"Go to "..cl(35,9),
			"	a. Talk to Arch Druid Fandral Staghelm",
			"		i. Accept "..cq("Morrowgrain Research part 1"),
			completion={{questaccepted="Morrowgrain Research part 1"}},
			mapzone="Darnassus",
			level=54,
			mapnote=9104420,
		}, {
			"Go to "..cl(35,8),
			"	a. Talk to Mathrengyl Bearwalker",
			"		i. Turn in "..cq("Morrowgrain Research part 1"),
			completion={{questturnedin="Morrowgrain Research part 1"}},
			mapzone="Darnassus",
			level=54,
			mapnote=8404380,
		}, {
			"Go to Rut'theran Village",
			completion={{location={mapzone="Teldrassil",x=56.3,y=92.4, dist=6}}},
			mapzone="Darnassus",
			level=54,
		}, {
			"Go to "..cl(55,92),
			"	a. Talk to Erelas Ambersky",
			"		i. Accept "..cq("Moontouched Wildkin"),
			completion={{questaccepted="Moontouched Wildkin"}},
			mapzone="Teldrassil",
			level=54,
			mapnote=92014750,
		}, {
			"Fly to Astranaar",
			completion={{location={mapzone="Ashenvale",x=35.5,y=50.2, dist=5}}},
			mapzone="Teldrassil",
			level=54,
		}, {
			"Make Astranaar your home",
			completion={{home="Astranaar"}},
			mapzone="Ashenvale",
			level=54,
		}, {
			"Fly to Talrendis Point in Azshara",
			completion={{location={mapzone="Azshara",x=11.9,y=77.6, dist=1}}},
			mapzone="Ashenvale",
			level=54,
		}, {
			"Go to "..cl(11,78),
			"	a. Talk to Loh'atu",
			"		i. Accept "..cq("Spiritual Unrest"),
			"		ii. Accept "..cq("A Land Filled with Hatred"),
			completion={{questaccepted="Spiritual Unrest"},{questaccepted="A Land Filled with Hatred"}},
			mapzone="Azshara",
			level=54,
			mapnote=78208960,
		}, {
			"Go northeast to "..cl(14,72),
			"	a. Kill 6 Highborne Apparitions",
			"	b. Kill 6 Highborne Lichlings",
			completion={{questgoal={"*","Highborne Apparition slain",6}},{questgoal={"*","Highborne Lichling slain",6}}},
			mapzone="Azshara",
			level=54,
			mapnote=72408610,
		}, {
			"Go northeast to "..cl(19,62),
			"	a. Kill 6 Haldarr Satyrs",
			"	b. Kill 2 Haldarr Tricksters",
			"	c. Kill 2 Hladarr Felsworn",
			completion={{questgoal={"*","Haldarr Satyr slain",6}},{questgoal={"*","Haldarr Trickster slain",2}},{questgoal={"*","Haldarr Felsworn slain",2}}},
			mapzone="Azshara",
			level=54,
			mapnote=62408170,
		}, {
			"Go southwest to "..cl(11,78),
			"	a. Talk to Loh'atu",
			"		i. Turn in "..cq("Spiritual Unrest"),
			"		ii. Turn in "..cq("A Land Filled with Hatred"),
			completion={{questturnedin="Spiritual Unrest"},{questturnedin="A Land Filled with Hatred"}},
			mapzone="Azshara",
			level=54,
			mapnote=78208960,
		}, {
			"Go northeast to "..cl(42,64),
			"	a. Use your Drawing Kit on the Rune of Sael'hai",
			"	b. Get the Rubbing: Rune of Sael'hai",
			completion={{questgoal={"*","Rubbing: Rune of Sael'hai",1}}},
			mapzone="Azshara",
			level=54,
			mapnote=64110640,
		}, {
			"Go northwest to "..cl(39,56),
			"	a. Use your Drawing Kit on the Rune of Markri",
			"	b. Get the Rubbing: Rune of Markri",
			completion={{questgoal={"*","Rubbing: Rune of Markri",1}}},
			mapzone="Azshara",
			level=54,
			mapnote=55509480,
		}, {
			"Go north to "..cl(39,50),
			"	a. Use your Drawing Kit on the Rune of Jin'yael",
			"	b. Get the Rubbing: Rune of Jin'yael",
			completion={{questgoal={"*","Rubbing: Rune of Jin'yael",1}}},
			mapzone="Azshara",
			level=54,
			mapnote=50208970,
		}, {
			"Go southwest to "..cl(37,53),
			"	a. Use your Drawing Kit on the Rune of Beth'Amara",
			"	b. Get the Rubbing: Rune of Beth'Amara",
			completion={{questgoal={"*","Rubbing: Rune of Beth'Amara",1}}},
			mapzone="Azshara",
			level=54,
			mapnote=53209010,
		}, {
			"Follow the road west out of the canyon",
			completion={{location={mapzone="Azshara",x=31.1,y=57.6, dist=0.5}}},
			mapzone="Azshara",
			level=54,
		}, {
			"Go northeast to "..cl(53,20),
			"	a. The path up to Kim'Jael starts here",
			"	b. Follow the path up",
			completion={{location={mapzone="Azshara",x=52.9,y=19.6, dist=0.3}}},
			mapzone="Azshara",
			level=54,
			mapnote=19607250,
		}, {
			"Go south to "..cl(53,22),
			"	a. Talk to Kim'Jael",
			"		i. Accept "..cq("Kim'jael Indeed!"),
			completion={{questaccepted="Kim'jael Indeed!"}},
			mapzone="Azshara",
			level=54,
			mapnote=21807530,
		}, {
			"Go southeast to "..cl(59,26),
			"	a. Click Kim'Jael's Equipment box #1",
			mapzone="Azshara",
			level=54,
			mapnote=26008460,
		}, {
			"Go south to "..cl(58,29),
			"	a. Click Kim'Jael's Equipment box #2",
			mapzone="Azshara",
			level=54,
			mapnote=29008690,
		}, {
			"Also at "..cl(58,29),
			"	b. Click Kim'Jael's Equipment box #3",
			mapzone="Azshara",
			level=54,
			mapnote=29208780,
		}, {
			"Keep clicking these 3 boxes until you have found:",
			"	a. Kim'Jael's Compass",
			"	b. Kim'Jael's Scope",
			"	c. Kim'Jael's Stuffed Chicken",
			"	d. Kim'Jael's Wizzlegoober",
			completion={{questgoal={"*","Kim'Jael's Compass",1}},{questgoal={"*","Kim'Jael's Scope",1}},{questgoal={"*","Kim'Jael's Stuffed Chicken",1}},{questgoal={"*","Kim'Jael's Wizzlegoober",1}}},
			mapzone="Azshara",
			level=54,
		}, {
			"Go northwest to "..cl(53,22),
			"	a. Talk to Kim'Jael",
			"		i. Turn in "..cq("Kim'jael Indeed!"),
			"		ii. Accept "..cq("Kim'jael's 'Missing' Equipment"),
			completion={{questturnedin="Kim'jael Indeed!"},{questaccepted="Kim'jael's 'Missing' Equipment"}},
			mapzone="Azshara",
			level=54,
			mapnote=21807530,
		}, {
			"Go southwest to "..cl(35,54),
			"	a. Kill nagas",
			"	b. Get a Some Rune",
			completion={{questgoal={"*","Some Rune",1}}},
			mapzone="Azshara",
			level=54,
			mapnote=54108940,
		}, {
			"Go northeast to "..cl(53,22),
			"	a. Talk to Kim'Jael",
			"		i. Turn in "..cq("Kim'jael's 'Missing' Equipment"),
			completion={{questturnedin="Kim'jael's 'Missing' Equipment"}},
			mapzone="Azshara",
			level=54,
			mapnote=21807530,
		}, {
			"Go southeast to "..cl(78,91),
			"	a. Stand on the landing pad on the small island",
			"	b. Use your Standard Issue Flare Gun",
			"		i. Turn in "..cq("Arcane Runes"),
			"		ii. Accept "..cq("Return to Tymor"),
			completion={{questturnedin="Arcane Runes"},{questaccepted="Return to Tymor"}},
			mapzone="Azshara",
			level=54,
			mapnote=91316910,
		}, {
			"Hearth to Astranaar",
			completion={{location={mapzone="Ashenvale",x=35.5,y=50.2, dist=5}}},
			mapzone="Azshara",
			level=54,
		}, {
			"Go northeast to Felwood",
			completion={{location={mapzone="Felwood"}}},
			mapzone="Ashenvale",
			level=54,
		}, {
			"Go north to "..cl(54,87),
			"	a. Talk to Arathandris Silversky",
			"		i. Accept "..cq("Cleansing Felwood"),
			completion={{questaccepted="Cleansing Felwood"}},
			mapzone="Felwood",
			level=54,
			mapnote=86814100,
		}, {
			"Go northwest to "..cl(51,85),
			"	a. Talk to Grazle",
			"		i. Accept "..cq("Timbermaw Ally"),
			completion={{questaccepted="Timbermaw Ally"}},
			mapzone="Felwood",
			level=54,
			mapnote=85013590,
		}, {
			"Go north to "..cl(51,82),
			"	a. Talk to Greta Mosshoof",
			"		i. Accept "..cq("Forces of Jaedenar"),
			completion={{questaccepted="Forces of Jaedenar"}},
			mapzone="Felwood",
			level=54,
			mapnote=82313350,
		}, {
			"Also at "..cl(51,82),	
			"	a. Talk to Eridan Bluewind",
			"		i. Accept "..cq("The Corruption of the Jadefire"),
			completion={{questaccepted="The Corruption of the Jadefire"}},
			mapzone="Felwood",
			level=54,
			mapnote=81513280,
		}, {
			"Also at "..cl(51,82),	
			"	a. Talk to Taronn Redfeather",
			"		i. Accept "..cq("Verifying the Corruption"),
			"	b. Talk to Ivy Leafrunner",
			"		i. Accept "..cq("To Winterspring!"),
			completion={{questaccepted="Verifying the Corruption"},{questaccepted="To Winterspring!"}},
			mapzone="Felwood",
			level=54,
			mapnote=81713260,
		}, {
			"Go to "..cl(52,82),
			"	a. Talk to Gorrim",
			"		i. Get the Emerald Sanctuary Flight Path",
			completion={{flightpath="Emerald Sanctuary"}},
			mapzone="Felwood",
			level=54,
			mapnote=82213370,
		}, {
			"Go southwest to "..cl(49,89),
			"	a. Kill 6 Deadwood Warriors",
			"	b. Kill 6 Deadwood Pathfinders",
			"	c. Kill 6 Deadwood Gardeners",
			completion={{questgoal={"*","Deadwood Warrior slain",6}},{questgoal={"*","Deadwood Pathfinder slain",6}},{questgoal={"*","Deadwood Gardener slain",6}}},
			mapzone="Felwood",
			level=54,
			mapnote=89113820,
		}, {
			"Go northeast to "..cl(51,85),
			"	a. Talk to Grazle",
			"		i. Turn in "..cq("Timbermaw Ally"),
			"		ii. Accept "..cq("Speak to Nafien"),
			completion={{questturnedin="Timbermaw Ally"},{questaccepted="Speak to Nafien"}},
			mapzone="Felwood",
			level=54,
			mapnote=85013590,
		}, {
			"Go northwest to "..cl(42,68),
			"	a. Kill Cursed Oozes",
			"	b. Use your Empty Cursed Ooze Jars on their corpses",
			"	c. Get 6 Filled Cursed Ooze Jars",
			completion={{questgoal={"*","Filled Cursed Ooze Jar",6}}},
			mapzone="Felwood",
			level=54,
			mapnote=68211010,
		}, {
			"Go north to "..cl(41,60),
			"	a. Kill Tainted Oozes",
			"	b. Use your Empty Tainted Ooze Jars on their corpses",
			"	c. Get 6 Filled Tainted Ooze Jars",
			completion={{questgoal={"*","Filled Tainted Ooze Jar",6}}},
			mapzone="Felwood",
			level=54,
			mapnote=59710070,
		}, {
			"Go west to "..cl(39,59),
			"	a. Kill 4 Jaedenar Hounds",
			"	b. Kill 4 Jaedenar Guardians",
			"	c. Kill 6 Jaedenar Adepts",
			"	d. Kill 6 Jaedenar Cultists",
			completion={{questgoal={"*","Jaedenar Hound slain",4}},{questgoal={"*","Jaedenar Guardian slain",4}},{questgoal={"*","Jaedenar Adept slain",6}},{questgoal={"*","Jaedenar Cultist slain",6}}},
			mapzone="Felwood",
			level=54,
			mapnote=59209770,
		}, {
			"Go southwest to "..cl(38,68),
			"	a. Kill 11 Jadefire Felsworn",
			"	b. Kill 9 Jadefire Shadowstalkers",
			"	c. Kill 9 Jadefire Rogues",
			completion={{questgoal={"*","Jadefire Felsworn slain",11}},{questgoal={"*","Jadefire Shadowstalker slain",9}},{questgoal={"*","Jadefire Rogue slain",9}}},
			mapzone="Felwood",
			level=54,
			mapnote=68410590,
		}, {
			"Go west to "..cl(32,67),
			"	a. Kill Xavathras",
			completion={{questgoal={"*","Xavathras slain",1}}},
			mapzone="Felwood",
			level=54,
			mapnote=67109930,
		}, {
			"Go southeast to "..cl(51,82),
			"	a. Talk to Greta Mosshoof",
			"		i. Turn in "..cq("Forces of Jaedenar"),
			"		ii. Accept "..cq("Collection of the Corrupt Water"),
			completion={{questturnedin="Forces of Jaedenar"},{questaccepted="Collection of the Corrupt Water"}},
			mapzone="Felwood",
			level=54,
			mapnote=82313350,
		}, {
			"Also at "..cl(51,82),	
			"	a. Talk to Eridan Bluewind",
			"		i. Turn in "..cq("The Corruption of the Jadefire"),
			"		ii. Accept "..cq("Further Corruption"),
			completion={{questturnedin="The Corruption of the Jadefire"},{questaccepted="Further Corruption"}},
			mapzone="Felwood",
			level=54,
			mapnote=81513280,
		}, {
			"Grind to level 55",
			completion={{level=55}},
			mapzone="Felwood",
			level=54,
		}
	  },
	},
	{ sectiontitle = "Levels (55-60)",
	  steps = {
		{
			"Go northwest to "..cl(35,60),
			"	a. Use your Empty Canteen near the green moonwell",
			"	b. Get a Corrupt Moonwell Water",
			completion={{questgoal={"*","Corrupt Moonwell Water",1}}},
			mapzone="Felwood",
			level=55,
			mapnote=59809500,
		}, {
			"Go southeast to "..cl(51,82),
			"	a. Talk to Greta Mosshoof",
			"		i. Turn in "..cq("Collection of the Corrupt Water"),
			"		ii. Accept "..cq("Seeking Spiritual Aid"),
			completion={{questturnedin="Collection of the Corrupt Water"},{questaccepted="Seeking Spiritual Aid"}},
			mapzone="Felwood",
			level=55,
			mapnote=82313350,
		}, {
			"Go northwest to "..cl(41,42),
			"	a. Kill 2 Entropic Beasts",
			"	b. Kill 2 Entropic Horrors",
			"	c. Explore the craters in the Shatter Scar Vale",
			completion={{questgoal={"*","Explore the craters in Shatter Scar Vale",1}},{questgoal={"*","Entropic Beast slain",2}},{questgoal={"*","Entropic Horror slain",2}}},
			mapzone="Felwood",
			level=55,
			mapnote=42408370,
		}, {
			"Go north to "..cl(43,21),
			"	a. The path up to 'Further Corruption' starts here",
			completion={{location={mapzone="Felwood",x=43.1,y=21.3, dist=0.5}}},
			mapzone="Felwood",
			level=55,
			mapnote=21306440,
		}, {
			"Go northwest to "..cl(42,19),
			"	a. Kill 8 Jadefire Hellcallers",
			"	b. Kill 8 Jadefire Betrayers",
			"	c. Kill 8 Jadefire Tricksters",
			completion={{questgoal={"*","Jadefire Hellcaller slain",8}},{questgoal={"*","Jadefire Betrayer slain",8}},{questgoal={"*","Jadefire Trickster slain",8}}},
			mapzone="Felwood",
			level=55,
			mapnote=19206120,
		}, {
			"Go southwest to "..cl(39,22),
			"	a. Kill Xavaric",
			"	b. Get the Flute of Xavaric",
			"	c. Click the Flute of Xavaric",
			"		i. Accept "..cq("Flute of Xavaric"),
			completion={{questgoal={"*","Xavaric slain",1}},{questaccepted="Flute of Xavaric"}},
			mapzone="Felwood",
			level=55,
			mapnote=22306140,
		}, {
			"Go north to "..cl(39,21),
			"	a. Kill Jadefire demons",
			"	b. Get 5 Jadefire Felbind",
			completion={{questgoal={"*","Jadefire Felbind",5}}},
			mapzone="Felwood",
			level=55,
			mapnote=21406070,
		}, {
			"Go northeast to "..cl(54,17),
			"	a. Kill Warpwood Tree Elementals",
			"	b. Get 15 Blood Amber",
			completion={{questgoal={"*","Blood Amber",15}}},
			mapzone="Felwood",
			level=55,
			mapnote=16507080,
		}, {
			"Go southeast to "..cl(62,24),
			"	a. Talk to Mishellena",
			"		i. Get the Talonbranch Glade Flight Path",
			completion={{flightpath="Talonbranch Glade"}},
			mapzone="Felwood",
			level=55,
			mapnote=24208670,
		}, {
			"Go northeast to "..cl(65,8),
			"	a. Talk to Nafien",
			"		i. Turn in "..cq("Speak to Nafien"),
			"		ii. Accept "..cq("Deadwood of the North"),
			completion={{questturnedin="Speak to Nafien"},{questaccepted="Deadwood of the North"}},
			mapzone="Felwood",
			level=55,
			mapnote=8107290,
		}, {
			"Go west to "..cl(63,9),
			"	a. Kill 6 Deadwood Den Watchers",
			"	b. Kill 6 Deadwood Avengers",
			"	c. Kill 6 Deadwood Shamans",
			completion={{questgoal={"*","Deadwood Den Watcher slain",6}},{questgoal={"*","Deadwood Avenger slain",6}},{questgoal={"*","Deadwood Shaman slain",6}}},
			mapzone="Felwood",
			level=55,
			mapnote=8907200,
		}, {
			"Go east to "..cl(65,8),
			"	a. Talk to Nafien",
			"		i. Turn in "..cq("Deadwood of the North"),
			"		ii. Accept "..cq("Speak to Salfa"),
			completion={{questturnedin="Deadwood of the North"},{questaccepted="Speak to Salfa"}},
			mapzone="Felwood",
			level=55,
			mapnote=8107290,
		}, {
			"Go through the tunnel to Winterspring",
			"	a. At the fork, the tunnel heading east is the tunnel to Winterspring",
			completion={{location={mapzone="Winterspring"}}},
			mapzone="Felwood",
			level=55,
		}, {
			"Right outside the tunnel at "..cl(28,35),
			"	a. Talk to Salfa",
			"		i. Turn in "..cq("Speak to Salfa"),
			completion={{questturnedin="Speak to Salfa"}},
			mapzone="Winterspring",
			level=55,
			mapnote=34506220,
		}, {
			"Go southeast to "..cl(31,45),
			"	a. Talk to Donova Snowden",
			"		i. Turn in "..cq("The New Springs"),
			"		ii. Accept "..cq("Strange Sources"),
			"		iii. Turn in "..cq("It's a Secret to Everybody part 3"),
			"		iv. Accept "..cq("The Videre Elixir"),
			"		v. Accept "..cq("Threat of the Winterfall"),
			completion={{questturnedin="The New Springs"},{questaccepted="Strange Sources"},{questturnedin="It's a Secret to Everybody part 3"},{questaccepted="The Videre Elixir"},{questaccepted="Threat of the Winterfall"}},
			mapzone="Winterspring",
			level=55,
			mapnote=45207650,
		}, {
			"Go northwest into the tunnel",
			completion={{location={mapzone="Felwood",x=68.2,y=5.6, dist=0.3}}},
			mapzone="Winterspring",
			level=55,
		}, {
			"Go north at the fork into Moonglade",
			completion={{location={mapzone="Moonglade"}}},
			mapzone="Winterspring",
			level=55,
		}, {
			"Go northeast to "..cl(48,67),
			"	a. Talk to Sindrayl",
			"		i. Get the Moonglade Flight Path",
			completion={{flightpath="Moonglade"}},
			mapzone="Moonglade",
			level=55,
			mapnote=67411550,
		}, {
			"Hearth to Astranaar",
			completion={{location={mapzone="Ashenvale",x=35.5,y=50.2, dist=5}}},
			mapzone="Moonglade",
			level=55,
		}, {
			"Fly to Feathermoon Stronghold",
			completion={{location={mapzone="Feralas",x=31.0,y=44.0, dist=5}}},
			mapzone="Ashenvale",
			level=55,
		}, {
			"Go to "..cl(31,43),
			"	a. Talk to Innkeeper Shyria",
			"		i. Accept "..cq("Jonespyre's Request"),
			completion={{questaccepted="Jonespyre's Request"}},
			mapzone="Feralas",
			level=55,
			mapnote=43507450,
		}, {
			"Go to "..cl(32,44),
			"	a. Talk to Quintis Jonespyre",
			"		i. Turn in "..cq("Jonespyre's Request"),
			completion={{questturnedin="Jonespyre's Request"}},
			mapzone="Feralas",
			level=55,
			mapnote=43807620,
		}, {
			"Ride the boat to the main continent of Feralas",
			completion={{location={mapzone="Feralas",x=43.5,y=42.7, dist=1}}},
			mapzone="Feralas",
			level=55,
		}, {
			"Go north to "..cl(45,26),
			"	a. Talk to Gregan Brewspewer",
			"		i. Turn in "..cq("A Visit to Gregan"),
			"		ii. Buy a Bait from him",
			completion={{questgoal={"*","Bait",1}},{questturnedin="A Visit to Gregan"}},
			mapzone="Feralas",
			level=55,
			mapnote=25607070,
		}, {
			"Go north to "..cl(45,11),
			"	a. Click the Bait in your bags and place it here",
			"	b. Miblan Snarltooth will run over to the bait and start eating it",
			"	c. The door behind him will slide open",
			mapzone="Feralas",
			level=55,
			mapnote=10905570,
		}, {
			"Go into the stone building to "..cl(45,10),
			"	a. Click the Evoroot on the pedastool",
			"	b. Get an Evoroot",
			completion={{questgoal={"*","Evoroot",1}}},
			mapzone="Feralas",
			level=55,
			mapnote=10105460,
		}, {
			"Go south to "..cl(45,26),
			"	a. Talk to Gregan Brewspewer",
			"		i. Give him the Evoroot",
			"		ii. Get 3 Videre Elixirs",
			completion={{questgoal={"*","Videre Elixir",3}}},
			mapzone="Feralas",
			level=55,
			mapnote=25607070,
		}, {
			"Go south to "..cl(43,43),
			"	a. Ride the boat to Feathermoon Stronghold",
			completion={{location={mapzone="Feralas",x=43.5,y=42.7, dist=0.5}}},
			mapzone="Feralas",
			level=55,
			mapnote=42808630,
		}, {
			"Fly to Emerald Sanctuary",
			completion={{location={mapzone="Felwood",x=51.1,y=81.6, dist=2}}},
			mapzone="Feralas",
			level=55,
		}, {
			"Go to "..cl(51,82),
			"	a. Talk to Eridan Bluewind",
			"		i. Turn in "..cq("Flute of Xavaric"),
			"		ii. Turn in "..cq("Further Corruption"),
			"		iii. Accept "..cq("Felbound Ancients"),
			completion={{questturnedin="Flute of Xavaric"},{questturnedin="Further Corruption"},{questaccepted="Felbound Ancients"}},
			mapzone="Felwood",
			level=55,
			mapnote=81513280,
		}, {
			"Also at "..cl(51,82),
			"	a. Talk to Taronn Redfeather",
			"		i. Turn in "..cq("Verifying the Corruption"),
			completion={{questturnedin="Verifying the Corruption"}},
			mapzone="Felwood",
			level=55,
			mapnote=81713260,
		}, {
			"Go southeast to "..cl(54,87),
			"	a. Talk to Arathandris Silversky",
			"		i. Turn in "..cq("Cleansing Felwood"),
			completion={{questturnedin="Cleansing Felwood"}},
			mapzone="Felwood",
			level=55,
			mapnote=86814100,
		}, {
			"Fly to Talonbranch Glade",
			completion={{location={mapzone="Felwood",x=62.3,y=25.0, dist=2}}},
			mapzone="Felwood",
			level=55,
		}, {
			"Go north to Winterspring through the tunnel",
			completion={{location={mapzone="Winterspring"}}},
			mapzone="Felwood",
			level=55,
		}, {
			"Outside the tunnel to the right at "..cl(28,35),
			"	a. Talk to Salfa",
			"		i. Accept "..cq("Winterfall Activity"),
			completion={{questaccepted="Winterfall Activity"}},
			mapzone="Winterspring",
			level=55,
			mapnote=34506220,
		}, {
			"Go southeast to "..cl(31,45),
			"	a. Talk to Donova Snowden",
			"		i. Turn in "..cq("The Videre Elixir"),
			"		ii. Accept "..cq("Meet at the Grave"),
			completion={{questturnedin="The Videre Elixir"},{questaccepted="Meet at the Grave"}},
			mapzone="Winterspring",
			level=55,
			mapnote=45207650,
		}, {
			"Go northeast to "..cl(62,37),
			"	a. Talk to Maethrya",
			"		i. Get the Everlook Flight Path",
			completion={{flightpath="Everlook"}},
			mapzone="Winterspring",
			level=55,
			mapnote=36609890,
		}, {
			"Fly to Ratchet",
			completion={{location={mapzone="The Barrens",x=63.0,y=38.1, dist=2}}},
			mapzone="Winterspring",
			level=55,
		}, {
			"Go to "..cl(62,39),
			"	a. Talk to Liv Rizzlefix",
			"		i. Turn in "..cq("Volcanic Activity"),
			completion={{questturnedin="Volcanic Activity"}},
			mapzone="The Barrens",
			level=55,
			mapnote=38710110,
		}, {
			"Go southeast to "..cl(66,44),
			"	a. Talk to Islen Waterseeker",
			"		i. Turn in "..cq("Seeking Spiritual Aid"),
			"		ii. Accept "..cq("Cleansed Water Returns to Felwood"),
			completion={{questturnedin="Seeking Spiritual Aid"},{questaccepted="Cleansed Water Returns to Felwood"}},
			mapzone="The Barrens",
			level=55,
			mapnote=43810960,
		}, {
			"Go northwest to Ratchet",
			completion={{location={mapzone="The Barrens",x=63.0,y=38.1, dist=2}}},
			mapzone="The Barrens",
			level=55,
		}, {
			"Fly to Theramore",
			completion={{location={mapzone="Dustwallow Marsh",x=67.5,y=50.3, dist=9}}},
			mapzone="The Barrens",
			level=55,
		}, {
			"Ride the boat to Menethil Harbor",
			completion={{location={mapzone="Wetlands",x=4.6,y=56.8, dist=9}}},
			mapzone="Dustwallow Marsh",
			level=55,
		}, {
			"Fly to Ironforge",
			completion={{location={mapzone="City of Ironforge"}}},
			mapzone="Wetlands",
			level=55,
		}, {
			"Go to "..cl(76,23),
			"	a. Talk to Laris Geardawdle",
			"		i. Turn in "..cq("A Little Slime Goes a Long Way part 1"),
			"		ii. Accept "..cq("A Little Slime Goes a Long Way part 2"),
			completion={{questturnedin="A Little Slime Goes a Long Way part 1"},{questaccepted="A Little Slime Goes a Long Way part 2"}},
			mapzone="Ironforge",
			level=55,
			mapnote=23409920,
		}, {
			"Go to "..cl(31,5),
			"	a. Talk to Tymor",
			"		i. Turn in "..cq("Return to Tymor"),
			completion={{questturnedin="Return to Tymor"}},
			mapzone="Ironforge",
			level=55,
			mapnote=4803580,
		}, {
			"Go to "..cl(29,22),
			"	a. Talk to Courier Hammerfall",
			"		i. He wanders around Ironforge",
			"		ii. Accept "..cq("The New Frontier part 1"),
			completion={{questaccepted="The New Frontier part 1"}},
			mapzone="Ironforge",
			level=55,
			mapnote=22105150,
		}, {
			"Make sure you have a Mithril Casing in your bags",
			completion={{questgoal={"*","Mithril Casing",1}}},
			mapzone="Ironforge",
			level=55,
		}, {
			"Fly to Menethil Harbor",
			completion={{location={mapzone="Wetlands",x=10.1,y=56.7, dist=9}}},
			mapzone="Ironforge",
			level=55,
		}, {
			"Ride the boat to Theramore",
			completion={{location={mapzone="Dustwallow Marsh",x=67.5,y=50.3, dist=9}}},
			mapzone="Wetlands",
			level=55,
		}, {
			"Fly to Gadgetzan",
			completion={{location={mapzone="Tanaris",x=51.7,y=27.8, dist=6}}},
			mapzone="Dustwallow Marsh",
			level=55,
		}, {
			"Go east to "..cl(54,29),
			"	a. Drink a Videre Elixir",
			"	b. You will die, but DON'T resurrect yet",
			mapzone="Tanaris",
			level=55,
			mapnote=28708270,
		}, {
			"Go north as a ghost to "..cl(54,23),
			"	a. Talk to Gaeriyan",
			"		i. Turn in "..cq("Meet at the Grave"),
			"		ii. Accept "..cq("A Grave Situation"),
			completion={{questturnedin="Meet at the Grave"},{questaccepted="A Grave Situation"}},
			mapzone="Tanaris",
			level=55,
			mapnote=23407740,
		}, {
			"Go south as a ghost to the graveyard",
			"	a. Resurrect now in the graveyard",
			mapzone="Tanaris",
			level=55,
		}, {
			"Go to "..cl(54,29),
			"	a. Click the Conspicuous Gravestone",
			"		i. Turn in "..cq("A Grave Situation"),
			"		ii. Accept "..cq("Linken's Sword"),
			completion={{questturnedin="A Grave Situation"},{questaccepted="Linken's Sword"}},
			mapzone="Tanaris",
			level=55,
			mapnote=29108290,
		}, {
			"Go southwest to Un'Goro Crater",
			completion={{location={mapzone="Un'Goro Crater"}}},
			mapzone="Tanaris",
			level=55,
		}, {
			"Kill Glutinous Oozes as you see them in Un'Goro Crater",
			"	a. Use your Empty Pure Sample Jars on their corpses",
			"	b. Get 10 Filled Pure Sample Jars",
			mapzone="Un'Goro Crater",
			level=55,
		}, {
			"Go north to "..cl(72,76),
			"	a. Talk to Torwa Pathfinder",
			"		i. Accept "..cq("The Mighty U'cha"),
			completion={{questaccepted="The Mighty U'cha"}},
			mapzone="Un'Goro Crater",
			level=55,
			mapnote=76014760,
		}, {
			"Go north to "..cl(68,13),
			"	a. Inside the cave, follow the path up",
			"	b. Kill U'cha",
			"	c. Get U'cha's Pelt",
			completion={{questgoal={"*","U'cha's Pelt",1}}},
			mapzone="Un'Goro Crater",
			level=55,
			mapnote=12708100,
		}, {
			"Go south in the cave to "..cl(68,17),
			"	a. Talk to A-Me 01",
			"		i. Accept "..cq("Chasing A-Me 01 part 2"),
			"		ii. Turn in "..cq("Chasing A-Me 01 part 2"),
			"		iii. Accept "..cq("Chasing A-Me 01 part 3"),
			"	b. Escort A-Me 01 to Karna Remtravel",
			completion={{questaccepted="Chasing A-Me 01 part 2"},{questturnedin="Chasing A-Me 01 part 2"},{questaccepted="Chasing A-Me 01 part 3"},{questgoal={"*","Protect A-Me 01 until you reach Karna Remtravel",1}}},
			mapzone="Un'Goro Crater",
			level=55,
			mapnote=16808450,
		}, {
			"At "..cl(46,13),
			"	a. Talk to Karna Remtravel",
			"		i. Turn in "..cq("Chasing A-Me 01 part 3"),
			completion={{questturnedin="Chasing A-Me 01 part 3"}},
			mapzone="Un'Goro Crater",
			level=55,
			mapnote=13405980,
		}, {
			"Grind to level 56",
			completion={{level=56}},
			mapzone="Un'Goro Crater",
			level=55,
		}, {
			"Go to "..cl(45,8),
			"	a. Talk to Linken",
			"		i. Turn in "..cq("Linken's Sword"),
			"		ii. Accept "..cq("A Gnome's Assistance"),
			completion={{questturnedin="Linken's Sword"},{questaccepted="A Gnome's Assistance"}},
			mapzone="Un'Goro Crater",
			level=56,
			mapnote=8105280,
		}, {
			"Go to "..cl(42,3),
			"	a. Talk to J.D. Collie",
			"		i. Turn in "..cq("A Gnome's Assistance"),
			"		ii. Accept "..cq("Linken's Memory"),
			completion={{questturnedin="A Gnome's Assistance"},{questaccepted="Linken's Memory"}},
			mapzone="Un'Goro Crater",
			level=56,
			mapnote=2704460,
		}, {
			"Go southeast to "..cl(72,76),
			"	a. Talk to Torwa Pathfinder",
			"		i. Turn in "..cq("The Mighty U'cha"),
			completion={{questturnedin="The Mighty U'cha"}},
			mapzone="Un'Goro Crater",
			level=56,
			mapnote=76014760,
		}, {
			"Make sure you have 10 Filled Pure Sample Jars",
			completion={{questgoal={"*","Filled Pure Sample Jar",10}}},
			mapzone="Un'Goro Crater",
			level=56,
		}, {
			"Hearth to Astranaar",
			completion={{location={mapzone="Ashenvale",x=35.5,y=50.2, dist=5}}},
			mapzone="Un'Goro Crater",
			level=56,
		}, {
			"Fly to Rut'theran Village",
			completion={{location={mapzone="Teldrassil",x=56.3,y=92.4, dist=6}}},
			mapzone="Ashenvale",
			level=56,
		}, {
			"Go to Darnassus",
			completion={{location={mapzone="Darnassus"}}},
			mapzone="Teldrassil",
			level=56,
		}, {
			"Go to 40,84 inside the Temple of the Moon",
			"	a. Use Eridan's Vial at the moonwell in the Temple of the Moon",
			"	b. Get a Vial of Blessed Water",
			completion={{questgoal={"*","Vial of Blessed Water",1}}},
			mapzone="Darnassus",
			level=56,
			mapnote=83912340,
		}, {
			"Go to Rut'theran Village",
			completion={{location={mapzone="Teldrassil",x=56.3,y=92.4, dist=6}}},
			mapzone="Darnassus",
			level=56,
		}, {
			"Fly to Emerald Sanctuary",
			completion={{location={mapzone="Felwood",x=51.1,y=81.6, dist=2}}},
			mapzone="Teldrassil",
			level=56,
		}, {
			"Go to "..cl(51,82),
			"	a. Talk to Greta Mosshoof",
			"		i. Turn in "..cq("Cleansed Water Returns to Felwood"),
			"		ii. Accept "..cq("Dousing the Flames of Protection"),
			completion={{questturnedin="Cleansed Water Returns to Felwood"},{questaccepted="Dousing the Flames of Protection"}},
			mapzone="Felwood",
			level=56,
			mapnote=82313350,
		}, {
			"Also at "..cl(51,82),
			"	a. Talk to Eridan Bluewind",
			"		i. Turn in "..cq("Felbound Ancients"),
			"		ii. Accept "..cq("Purified!"),
			"		iii. Turn in "..cq("Purified!"),
			"		iv. Turn in "..cq("Linken's Memory"),
			"		v. Accept "..cq("Silver Heart"),
			completion={{questturnedin="Felbound Ancients"},{questaccepted="Purified!"},{questturnedin="Purified!"},{questturnedin="Linken's Memory"},{questaccepted="Silver Heart"}},
			mapzone="Felwood",
			level=56,
			mapnote=81513280,
		}, {
			"Go northwest to "..cl(49,79),
			"	a. Kill wolves and bears",
			"	b. Get 11 Silvery Claws",
			completion={{questgoal={"*","Silvery Claws",11}}},
			mapzone="Felwood",
			level=56,
			mapnote=79212790,
		}, {
			"Go northwest to the cave at "..cl(35,58),
			completion={{location={mapzone="Felwood",x=35.4,y=58.8, dist=0.3}}},
			mapzone="Felwood",
			level=56,
		}, {
			"Go northeast to "..cl(36,56),
			"	a. Use your Purified Moonwell Water on the Brazier of Pain",
			"	b. Extinguish the Brazier of Pain",
			completion={{questgoal={"*","Extinguish the Brazier of Pain",1}}},
			mapzone="Felwood",
			level=56,
			mapnote=56309260,
		}, {
			"Go north to "..cl(36,55),
			"	a. Use your Purified Moonwell Water on the Brazier of Hatred",
			"	b. Extinguish the Brazier of Hatred",
			completion={{questgoal={"*","Extinguish the Brazier of Hatred",1}}},
			mapzone="Felwood",
			level=56,
			mapnote=55209170,
		}, {
			"Go north to "..cl(37,53),
			"	a. Use your Purified Moonwell Water on the Brazier of Suffering",
			"	b. Extinguish the Brazier of Suffering",
			completion={{questgoal={"*","Extinguish the Brazier of Suffering",1}}},
			mapzone="Felwood",
			level=56,
			mapnote=53309000,
		}, {
			"Go northeast to "..cl(38,53),
			"	a. Use your Purified Moonwell Water on the Brazier of Malice",
			"	b. Extinguish the Brazier of Malice",
			completion={{questgoal={"*","Extinguish the Brazier of Malice",1}}},
			mapzone="Felwood",
			level=56,
			mapnote=52709040,
		}, {
			"Exit the cave",
			mapzone="Felwood",
			level=56,
		}, {
			"Go northeast to "..cl(48,20),
			"	a. Kill Irontree Stompers",
			"	b. Get an Irontree Heart",
			completion={{questgoal={"*","Irontree Heart",1}}},
			mapzone="Felwood",
			level=56,
			mapnote=20206870,
		}, {
			"Go east to Talonbranch Glade",
			completion={{location={mapzone="Felwood",x=62.3,y=25.0, dist=2}}},
			mapzone="Felwood",
			level=56,
		}, {
			"Fly to Emerald Sanctuary",
			completion={{location={mapzone="Felwood",x=51.1,y=81.6, dist=2}}},
			mapzone="Felwood",
			level=56,
		}, {
			"Go to "..cl(51,82),
			"	a. Talk to Greta Mosshoof",
			"		i. Turn in "..cq("Dousing the Flames of Protection"),
			completion={{questturnedin="Dousing the Flames of Protection"}},
			mapzone="Felwood",
			level=56,
			mapnote=82313350,
		}, {
			"Also at "..cl(51,82),
			"	a. Talk to Eridan Bluewind",
			"		i. Turn in "..cq("Silver Heart"),
			"		ii. Accept "..cq("Aquementas"),
			completion={{questturnedin="Silver Heart"},{questaccepted="Aquementas"}},
			mapzone="Felwood",
			level=56,
			mapnote=81513280,
		}, {
			"Fly to Everlook",
			completion={{location={mapzone="Winterspring",x=61.2,y=38.3, dist=3}}},
			mapzone="Felwood",
			level=56,
		}, {
			"Go to "..cl(61,38),
			"	a. Talk to Harlo Wigglesworth",
			"		i. Accept "..cq("Enraged Wildkin part 1"),
			completion={{questaccepted="Enraged Wildkin part 1"}},
			mapzone="Winterspring",
			level=56,
			mapnote=38409950,
		}, {
			"Go to "..cl(61,39),
			"	a. Talk to Jessica Redpath",
			"		i. Accept "..cq("Sister Pamela"),
			"	b. Talk to Gregor Greystone",
			"		i. Accept "..cq("The Everlook Report"),
			"		ii. Accept "..cq("Duke Nicholas Zverenhoff"),
			completion={{questaccepted="Sister Pamela"},{questaccepted="The Everlook Report"},{questaccepted="Duke Nicholas Zverenhoff"}},
			mapzone="Winterspring",
			level=56,
			mapnote=39010030,
		}, {
			"Make Everlook your home",
			completion={{home="Everlook"}},
			mapzone="Winterspring",
			level=56,
		}, {
			"Go to "..cl(61,38),
			"	a. Talk to Umi Rumplesnicker",
			"		i. Accept "..cq("Are We There, Yeti? part 1"),
			completion={{questaccepted="Are We There, Yeti? part 1"}},
			mapzone="Winterspring",
			level=56,
			mapnote=37609850,
		}, {
			"As you run around Winterspring, look for big blue feathers on the ground:",
			"	a. Click them and get 10 Moontouched Feathers",
			mapzone="Winterspring",
			level=56,
		}, {
			"Go northwest to Starfall Village",
			completion={{location={mapzone="Winterspring",x=51.6,y=29.2, dist=2}}},
			mapzone="Winterspring",
			level=56,
		}, {
			"Go to "..cl(52,30),
			"	a. Talk to Wynd Nightchaser",
			"		i. Turn in "..cq("To Winterspring!"),
			"		ii. Accept "..cq("The Ruins of Kel'Theril"),
			"	b. Talk to Jaron Stoneshaper",
			"		i. Turn in "..cq("Enraged Wildkin part 1"),
			"		ii. Turn in "..cq("The Ruins of Kel'Theril"),
			completion={{questturnedin="To Winterspring!"},{questaccepted="The Ruins of Kel'Theril"},{questturnedin="Enraged Wildkin part 1"},{questturnedin="The Ruins of Kel'Theril"}},
			mapzone="Winterspring",
			level=56,
			mapnote=30408250,
		}, {
			"Go west to "..cl(39,44),
			"	a. Kill 8 Winterfall Pathfinders",
			"	b. Kill 8 Winterfall Den Watchers",
			"	c. Kill 8 Winterfall Totemics",
			"	d. Kill Winterfall furbolgs",
			"	e. Get an Empty Firewater Flask",
			"	f. Click the Empty Firewater Flask",
			"		i. Accept "..cq("Winterfall Firewater"),
			completion={{questgoal={"*","Winterfall Pathfinder slain",8}},{questgoal={"*","Winterfall Den Watcher slain",8}},{questgoal={"*","Winterfall Totemic slain",8}},{questaccepted="Winterfall Firewater"}},
			mapzone="Winterspring",
			level=56,
			mapnote=43808320,
		}, {
			"Go east to "..cl(65,42),
			"	a. Kill yetis",
			"	b. Get 10 Thick Yeti Furs",
			completion={{questgoal={"*","Thick Yeti Fur",10}}},
			mapzone="Winterspring",
			level=56,
			mapnote=41610660,
		}, {
			"Go northwest to Everlook",
			completion={{location={mapzone="Winterspring",x=61.2,y=38.3, dist=3}}},
			mapzone="Winterspring",
			level=56,
		}, {
			"Go to "..cl(61,38),
			"	a. Talk to Umi Rumplesnicker",
			"		i. Turn in "..cq("Are We There, Yeti? part 1"),
			"		ii. Accept "..cq("Are We There. Yeti? part 2"),
			completion={{questturnedin="Are We There, Yeti? part 1"},{questaccepted="Are We There. Yeti? part 2"}},
			mapzone="Winterspring",
			level=56,
			mapnote=37609850,
		}, {
			"Go southeast to "..cl(66,43),
			"	a. Kill Ice Thistle Matriarchs",
			"	b. Kill Ice Thistle Patriarchs",
			"	c. Get 2 Pristine Yeti Horns",
			completion={{questgoal={"*","Pristine Yeti Horn",2}}},
			mapzone="Winterspring",
			level=56,
			mapnote=42810880,
		}, {
			"Grind to level 57",
			completion={{level=57}},
			mapzone="Winterspring",
			level=56,
		}, {
			"Go southwest to "..cl(60,74),
			"	a. Discover Darkwhisper Gorge",
			completion={{questgoal={"*","Discover Darkwhisper Gorge",1}}},
			mapzone="Winterspring",
			level=57,
			mapnote=74313410,
		}, {
			"Hearth to Everlook",
			completion={{location={mapzone="Winterspring",x=61.2,y=38.3, dist=3}}},
			mapzone="Winterspring",
			level=57,
		}, {
			"Go to "..cl(61,38),
			"	a. Talk to Umi Rumplesnicker",
			"		i. Turn in "..cq("Are We There. Yeti? part 2"),
			"		ii. Accept "..cq("Are We There, Yeti? part 3"),
			completion={{questturnedin="Are We There. Yeti? part 2"},{questaccepted="Are We There, Yeti? part 3"}},
			mapzone="Winterspring",
			level=57,
			mapnote=37609850,
		}, {
			"Go to "..cl(62,39),
			"	a. Use Umi's Mechanical Yeti on Legacki",
			"	b. Scare Legacki",
			completion={{questgoal={"*","Scare Legacki",1}}},
			mapzone="Winterspring",
			level=57,
			mapnote=38510000,
		}, {
			"Go northeast to "..cl(67,35),
			"	a. Kill 8 Winterfall Shamans",
			"	b. Kill 8 Winterfall Den Watchers (you have these from before)",
			"	c. Kill 8 Winterfall Ursas",
			completion={{questgoal={"*","Winterfall Shaman slain",8}},{questgoal={"*","Winterfall Den Watcher slain",8}},{questgoal={"*","Winterfall Ursa slain",8}}},
			mapzone="Winterspring",
			level=57,
			mapnote=35010190,
		}, {
			"Make sure you have 10 Moontouched Feathers in your bags",
			completion={{questgoal={"*","Moontouched Feather",10}}},
			mapzone="Winterspring",
			level=57,
		}, {
			"Go west to "..cl(31,45),
			"	a. Talk to Donova Snowden",
			"		i. Turn in "..cq("Strange Sources"),
			"		ii. Turn in "..cq("Threat of the Winterfall"),
			"		iii. Turn in "..cq("Winterfall Firewater"),
			"		iv. Accept "..cq("Falling to Corruption"),
			completion={{questturnedin="Strange Sources"},{questturnedin="Threat of the Winterfall"},{questturnedin="Winterfall Firewater"},{questaccepted="Falling to Corruption"}},
			mapzone="Winterspring",
			level=57,
			mapnote=45207650,
		}, {
			"Go northwest to "..cl(28,35),
			"	a. Talk to Salfa",
			"		i. Turn in "..cq("Winterfall Activity"),
			completion={{questturnedin="Winterfall Activity"}},
			mapzone="Winterspring",
			level=57,
			mapnote=34506220,
		}, {
			"Go through the tunnel to Felwood",
			completion={{location={mapzone="Felwood"}}},
			mapzone="Winterspring",
			level=57,
		}, {
			"Go west to "..cl(60,6),
			"	a. You may need help with this, if so, find a partner",
			"	b. Click the Deadwood Cauldron",
			"		i. Turn in "..cq("Falling to Corruption"),
			"		ii. Accept "..cq("Mystery Goo"),
			completion={{questturnedin="Falling to Corruption"},{questaccepted="Mystery Goo"}},
			mapzone="Felwood",
			level=57,
			mapnote=5806600,
		}, {
			"Go through the tunnel to Winterspring",
			completion={{location={mapzone="Winterspring"}}},
			mapzone="Felwood",
			level=57,
		}, {
			"Go southeast to "..cl(31,45),
			"	a. Talk to Donova Snowden",
			"		i. Turn in "..cq("Mystery Goo"),
			"		ii. Accept "..cq("Toxic Horrors"),
			completion={{questturnedin="Mystery Goo"},{questaccepted="Toxic Horrors"}},
			mapzone="Winterspring",
			level=57,
			mapnote=45207650,
		}, {
			"Go northwest through the tunnel to Felwood",
			completion={{location={mapzone="Felwood"}}},
			mapzone="Winterspring",
			level=57,
		}, {
			"Go southwest to "..cl(50,26),
			"	a. Kill Toxic Horrors",
			"	b. Get 3 Toxic Horror Droplets",
			completion={{questgoal={"*","Toxic Horror Droplet",3}}},
			mapzone="Felwood",
			level=57,
			mapnote=26407680,
		}, {
			"Go northeast through the tunnel to Winterspring",
			completion={{location={mapzone="Winterspring"}}},
			mapzone="Felwood",
			level=57,
		}, {
			"Go southeast to "..cl(31,45),
			"	a. Talk to Donova Snowden",
			"		i. Turn in "..cq("Toxic Horrors"),
			completion={{questturnedin="Toxic Horrors"}},
			mapzone="Winterspring",
			level=57,
			mapnote=45207650,
		}, {
			"Go northeast to Everlook",
			completion={{location={mapzone="Winterspring",x=61.2,y=38.3, dist=3}}},
			mapzone="Winterspring",
			level=57,
		}, {
			"Fly to Rut'theran Village",
			completion={{location={mapzone="Teldrassil",x=56.3,y=92.4, dist=6}}},
			mapzone="Winterspring",
			level=57,
		}, {
			"Go to "..cl(56,92),
			"	a. Talk to Erelas Ambersky",
			"		i. Turn in "..cq("Moontouched Wildkin"),
			completion={{questturnedin="Moontouched Wildkin"}},
			mapzone="Teldrassil",
			level=57,
			mapnote=92014750,
		}, {
			"Go to Darnassus",
			completion={{location={mapzone="Darnassus"}}},
			mapzone="Teldrassil",
			level=57,
		}, {
			"Go to "..cl(35,9),
			"	a. Talk to Arch Druid Fandral Staghelm",
			"		i. Turn in "..cq("The New Frontier part 1"),
			"		ii. Accept "..cq("The New Frontier part 2"),
			completion={{questturnedin="The New Frontier part 1"},{questaccepted="The New Frontier part 2"}},
			mapzone="Darnassus",
			level=57,
			mapnote=9104420,
		}, {
			"Go to "..cl(35,8),
			"	a. Talk to Mathrengyl Bearwalker",
			"		i. Turn in "..cq("The New Frontier part 2"),
			"		ii. Accept "..cq("Rabine Saturna"),
			completion={{questturnedin="The New Frontier part 2"},{questaccepted="Rabine Saturna"}},
			mapzone="Darnassus",
			level=57,
			mapnote=8404380,
		}, {
			"Go to Rut'theran Village",
			completion={{location={mapzone="Teldrassil",x=56.3,y=92.4, dist=6}}},
			mapzone="Darnassus",
			level=57,
		}, {
			"Fly to Moonglade",
			completion={{location={mapzone="Moonglade"}}},
			mapzone="Teldrassil",
			level=57,
		}, {
			"Go north to "..cl(52,45),
			"	a. Talk to Rabine Saturna",
			"		i. Turn in "..cq("Rabine Saturna"),
			"		ii. Accept "..cq("Wasteland"),
			completion={{questturnedin="Rabine Saturna"},{questaccepted="Wasteland"}},
			mapzone="Moonglade",
			level=57,
			mapnote=45109680,
		}, {
			"Fly to Auberdine",
			completion={{location={mapzone="Darkshore",x=38.1,y=43.1, dist=9}}},
			mapzone="Moonglade",
			level=57,
		}, {
			"Ride the boat to Menethil Harbor",
			completion={{location={mapzone="Wetlands",x=4.6,y=56.8, dist=9}}},
			mapzone="Darkshore",
			level=57,
		}, {
			"Fly to Ironforge",
			completion={{location={mapzone="City of Ironforge"}}},
			mapzone="Wetlands",
			level=57,
		}, {
			"Go to "..cl(59,47),
			"	a. Talk to Cenarion Emissary Jademoon",
			"		i. Accept "..cq("Taking Back Silithus"),
			completion={{questaccepted="Taking Back Silithus"}},
			mapzone="Ironforge",
			level=57,
			mapnote=47310590,
		}, {
			"Go to "..cl(76,23),
			"	a. Talk to Laris Geardawdle",
			"		i. Turn in "..cq("A Little Slime Goes a Long Way part 2"),
			completion={{questturnedin="A Little Slime Goes a Long Way part 2"}},
			mapzone="Ironforge",
			level=57,
			mapnote=23409920,
		}, {
			"Go to "..cl(38,55),
			"	a. Talk to Royal Historian Archesonus",
			"		i. Accept "..cq("The Smoldering Ruins of Thaurissan part 1"),
			"		ii. Turn in "..cq("The Smoldering Ruins of Thaurissan part 1"),
			"		iii. Accept "..cq("The Smoldering Ruins of Thaurissan part 2"),
			completion={{questaccepted="The Smoldering Ruins of Thaurissan part 1"},{questturnedin="The Smoldering Ruins of Thaurissan part 1"},{questaccepted="The Smoldering Ruins of Thaurissan part 2"}},
			mapzone="Ironforge",
			level=57,
			mapnote=55309370,
		}, {
			"Fly to Lakeshire",
			completion={{location={mapzone="Redridge Mountains",x=26.9,y=44.8, dist=5}}},
			mapzone="Ironforge",
			level=57,
		}, {
			"Make Lakeshire your home",
			completion={{home="Lakeshire"}},
			mapzone="Redridge Mountains",
			level=57,
		}, {
			"Make sure you have your Black Dragonflight Molt in your bags",
			completion={{questgoal={"*","Black DragonFlight Molt",1}}},
			mapzone="Redridge Mountains",
			level=57,
		}, {
			"Go northeast to the Burning Steppes",
			completion={{location={mapzone="Burning Steppes"}}},
			mapzone="Redridge Mountains",
			level=57,
		}, {
			"Go northeast to "..cl(83,63),
			"	a. The path up to Morgan's Vigil starts here",
			completion={{location={mapzone="Burning Steppes",x=82.8,y=63.4, dist=0.3}}},
			mapzone="Burning Steppes",
			level=57,
			mapnote=63314610,
		}, {
			"Go to "..cl(84,68),
			"	a. Talk to Borgus Stoutarm",
			"		i. Get the Morgan's Vigil Flight Path",
			completion={{flightpath="Morgan's Vigil"}},
			mapzone="Burning Steppes",
			level=57,
			mapnote=68315260,
		}, {
			"Go to "..cl(85,69),
			"	a. Talk to Oralius",
			"		i. Accept "..cq("Extinguish the Firegut"),
			"		ii. Accept "..cq("FIFTY! YEP!"),
			completion={{questaccepted="Extinguish the Firegut"},{questaccepted="FIFTY! YEP!"}},
			mapzone="Burning Steppes",
			level=57,
			mapnote=68715330,
		}, {
			"Go to "..cl(86,69),
			"	a. Talk to Helendis Riverhorn",
			"		i. Accept "..cq("Dragonkin Menace"),
			completion={{questaccepted="Dragonkin Menace"}},
			mapzone="Burning Steppes",
			level=57,
			mapnote=68915470,
		}, {
			"Go northwest to "..cl(64,42),
			"	a. Click the Thaurissan Relics",
			"	b. Gather Information from 12 Thaurissan Relics",
			completion={{questgoal={"*","Information Recovered",12}}},
			mapzone="Burning Steppes",
			level=57,
			mapnote=41810590,
		}, {
			"Go north to "..cl(66,22),
			"	a. Talk to Yuka Screwspigot",
			"		i. Turn in "..cq("Yuka Screwspigot"),
			completion={{questturnedin="Yuka Screwspigot"}},
			mapzone="Burning Steppes",
			level=57,
			mapnote=21908800,
		}, {
			"Go south to "..cl(65,24),
			"	a. Talk to Tinkee Steamboil",
			"		i. Accept "..cq("Broodling Essence"),
			"	b. Talk to Maxwort Uberglint",
			"		i. Accept "..cq("Tablet of the Seven"),
			completion={{questaccepted="Broodling Essence"},{questaccepted="Tablet of the Seven"}},
			mapzone="Burning Steppes",
			level=57,
			mapnote=23908910,
		}, {
			"Go southwest to "..cl(54,41),
			"	a. Click the Tablet of Seven to Transcribe it",
			"	b. Get a Tablet Transcript",
			completion={{questgoal={"*","Tablet Transcript",1}}},
			mapzone="Burning Steppes",
			level=57,
			mapnote=40709480,
		}, {
			"Go northwest to "..cl(44,36),
			"	a. Kill Blackrock orcs",
			"	b. Get 50 Blackrock Medallions",
			completion={{questgoal={"*","Blackrock Medallion",50}}},
			mapzone="Burning Steppes",
			level=57,
			mapnote=36408080,
		}, {
			"Go east to "..cl(75,42),
			"	a. Kill 15 Firegut Ogre Mages",
			"	b. Kill 7 Firegut Ogres",
			"	c. Kill 7 Firegut Brutes",
			completion={{questgoal={"*","Firegut Ogre Mage slain",15}},{questgoal={"*","Firegut Ogre slain",7}},{questgoal={"*","Firegut Brute slain",7}}},
			mapzone="Burning Steppes",
			level=57,
			mapnote=42011670,
		}, {
			"Go southeast to Morgan's Vigil",
			completion={{location={mapzone="Burning Steppes",x=84.9,y=69.1, dist=2}}},
			mapzone="Burning Steppes",
			level=57,
		}, {
			"Go to "..cl(85,69),
			"	a. Talk to Oralius",
			"		i. Turn in "..cq("Extinguish the Firegut"),
			"		ii. Accept "..cq("Gor'tesh the Brute Lord"),
			"		iii. Turn in "..cq("FIFTY! YEP!"),
			completion={{questturnedin="Extinguish the Firegut"},{questaccepted="Gor'tesh the Brute Lord"},{questturnedin="FIFTY! YEP!"}},
			mapzone="Burning Steppes",
			level=57,
			mapnote=68715330,
		}, {
			"Go northeast to "..cl(90,56),
			"	a. Kill 15 Black Broodlings",
			"	b. Kill 10 Black Dragonspawns",
			"	c. Kill 1 Black Drake",
			"	d. Kill 4 Black Wyrmkins",
			"	e. Use your Draco-Incarcinatrix 900 on Black Broodlings and kill them",
			"	f. Click the red crystals that float over their corpses",
			"	g. Get 8 Broodling Essences",
			completion={{questgoal={"*","Black Broodling slain",15}},{questgoal={"*","Black Dragonspawn slain",10}},{questgoal={"*","Black Drake slain",1}},{questgoal={"*","Black Wyrmkin slain",4}},{questgoal={"*","Broodling Essence",8}}},
			mapzone="Burning Steppes",
			level=57,
			mapnote=55914630,
		}, {
			"Go northeast to "..cl(95,32),
			"	a. Talk to Cyrus Therepentous",
			"		i. Accept "..cq("A Taste of Flame part 1"),
			"		ii. Turn in "..cq("A Taste of Flame part 1"),
			completion={{questaccepted="A Taste of Flame part 1"},{questturnedin="A Taste of Flame part 1"}},
			mapzone="Burning Steppes",
			level=57,
			mapnote=31612670,
		}, {
			"Go west to "..cl(65,24),
			"	a. Talk to Tinkee Steamboil",
			"		i. Turn in "..cq("Broodling Essence"),
			"		ii. Accept "..cq("Felnok Steelspring"),
			"	b. Talk to Maxwort Uberglint",
			"		i. Turn in "..cq("Tablet of the Seven"),
			completion={{questturnedin="Broodling Essence"},{questaccepted="Felnok Steelspring"},{questturnedin="Tablet of the Seven"}},
			mapzone="Burning Steppes",
			level=57,
			mapnote=23908910,
		}, {
			"Grind to level 58",
			completion={{level=58}},
			mapzone="Burning Steppes",
			level=57,
		}, {
			"Go southwest to "..cl(39,55),
			"	a. Kill Gor'tesh",
			"	b. Get Gor'tesh's Lopped Off Head",
			completion={{questgoal={"*","Gor'tesh's Lopped Off Head",1}}},
			mapzone="Burning Steppes",
			level=58,
			mapnote=55409470,
		}, {
			"Go southeast to Morgan's Vigil",
			completion={{location={mapzone="Burning Steppes",x=84.9,y=69.1, dist=2}}},
			mapzone="Burning Steppes",
			level=58,
		}, {
			"Go to "..cl(85,69),
			"	a. Talk to Oralius",
			"		i. Turn in "..cq("Gor'tesh the Brute Lord"),
			"		ii. Accept "..cq("Ogre Head On A Stick = Party"),
			completion={{questturnedin="Gor'tesh the Brute Lord"},{questaccepted="Ogre Head On A Stick = Party"}},
			mapzone="Burning Steppes",
			level=58,
			mapnote=68715330,
		}, {
			"Go to "..cl(86,69),
			"	a. Talk to Helendis Riverhorn",
			"		i. Turn in "..cq("Dragonkin Menace"),
			"		ii. Accept "..cq("The True Masters part 1"),
			completion={{questturnedin="Dragonkin Menace"},{questaccepted="The True Masters part 1"}},
			mapzone="Burning Steppes",
			level=58,
			mapnote=68915470,
		}, {
			"Go north to "..cl(81,47),
			"	a. Go to the top of Dreadmaul Rock",
			"	b. Plant Gor'tesh's Head in the Soft Dirt Mound",
			completion={{questgoal={"*","Soft Dirt Mound",1}}},
			mapzone="Burning Steppes",
			level=58,
			mapnote=46812780,
		}, {
			"Go south to Morgan's Vigil",
			completion={{location={mapzone="Burning Steppes",x=84.9,y=69.1, dist=2}}},
			mapzone="Burning Steppes",
			level=58,
		}, {
			"Go to "..cl(85,69),
			"	a. Talk to Oralius",
			"		i. Turn in "..cq("Ogre Head On A Stick = Party"),
			completion={{questturnedin="Ogre Head On A Stick = Party"}},
			mapzone="Burning Steppes",
			level=58,
			mapnote=68715330,
		}, {
			"Fly to Lakeshire",
			completion={{location={mapzone="Redridge Mountains",x=26.9,y=44.8, dist=5}}},
			mapzone="Burning Steppes",
			level=58,
		}, {
			"Go to "..cl(30,44),
			"	a. Talk to Magistrate Solomon",
			"		i. Turn in "..cq("The True Masters part 1"),
			"		ii. Accept "..cq("The True Masters part 2"),
			completion={{questturnedin="The True Masters part 1"},{questaccepted="The True Masters part 2"}},
			mapzone="Redridge Mountains",
			level=58,
			mapnote=44407440,
		}, {
			"Fly to Stormwind",
			completion={{location={mapzone="Stormwind City"}}},
			mapzone="Redridge Mountains",
			level=58,
		}, {
			"Go to "..cl(78,18),
			"	a. Talk to Highlord Bolvar Fordragon",
			"		i. Turn in "..cq("The True Masters part 2"),
			"		ii. Accept "..cq("The True Masters part 3"),
			"	b. Talk to Lady Katrana Prestor",
			"	c. Talk to Highlord Bolvar Fordragon",
			"		i. Turn in "..cq("The True Masters part 3"),
			"		ii. Accept "..cq("The True Masters part 4"),
			completion={{questturnedin="The True Masters part 2"},{questaccepted="The True Masters part 3"},{questturnedin="The True Masters part 3"},{questaccepted="The True Masters part 4"}},
			mapzone="Stormwind City",
			level=58,
			mapnote=18009620,
		}, {
			"Fly to Lakeshire",
			completion={{location={mapzone="Redridge Mountains",x=26.9,y=44.8, dist=5}}},
			mapzone="Stormwind City",
			level=58,
		}, {
			"Go to "..cl(30,44),
			"	a. Talk to Magistrate Solomon",
			"		i. Turn in "..cq("The True Masters part 4"),
			"		ii. Accept "..cq("The True Masters part 5"),
			completion={{questturnedin="The True Masters part 4"},{questaccepted="The True Masters part 5"}},
			mapzone="Redridge Mountains",
			level=58,
			mapnote=44407440,
		}, {
			"Fly to Morgan's Vigil",
			completion={{location={mapzone="Burning Steppes",x=84.9,y=69.1, dist=2}}},
			mapzone="Redridge Mountains",
			level=58,
		}, {
			"Go to "..cl(85,69),
			"	a. Talk to Marshal Maxwell",
			"		i. Turn in "..cq("The True Masters part 5"),
			"		ii. Accept "..cq("The True Masters part 6"),
			completion={{questturnedin="The True Masters part 5"},{questaccepted="The True Masters part 6"}},
			mapzone="Burning Steppes",
			level=58,
			mapnote=69015370,
		}, {
			"Go northwest to "..cl(65,24),
			"	a. Talk to Ragged John",
			"		i. Listen to Ragged John's story",
			mapzone="Burning Steppes",
			level=58,
			mapnote=23808880,
		}, {
			"Go southeast to Morgan's Vigil",
			completion={{location={mapzone="Burning Steppes",x=84.9,y=69.1, dist=2}}},
			mapzone="Burning Steppes",
			level=58,
		}, {
			"Go to "..cl(85,69),
			"	a. Talk to Marshal Maxwell",
			"		i. Turn in "..cq("The True Masters part 6"),
			completion={{questturnedin="The True Masters part 6"}},
			mapzone="Burning Steppes",
			level=58,
			mapnote=69015370,
		}, {
			"Hearth to Lakeshire",
			completion={{location={mapzone="Redridge Mountains",x=26.9,y=44.8, dist=5}}},
			mapzone="Burning Steppes",
			level=58,
		}, {
			"Fly to Ironforge",
			completion={{location={mapzone="City of Ironforge"}}},
			mapzone="Redridge Mountains",
			level=58,
		}, {
			"Go to "..cl(38,55),
			"	a. Talk to Royal Historian Archesonus",
			"		i. Turn in "..cq("The Smoldering Ruins of Thaurissan part 2"),
			completion={{questturnedin="The Smoldering Ruins of Thaurissan part 2"}},
			mapzone="Ironforge",
			level=58,
			mapnote=55309370,
		}, {
			"Fly to Menethil Harbor",
			completion={{location={mapzone="Wetlands",x=10.1,y=56.7, dist=9}}},
			mapzone="Ironforge",
			level=58,
		}, {
			"Ride the boat to Theramore",
			completion={{location={mapzone="Dustwallow Marsh",x=67.5,y=50.3, dist=9}}},
			mapzone="Wetlands",
			level=58,
		}, {
			"Fly to Gadgetzan",
			completion={{location={mapzone="Tanaris",x=51.7,y=27.8, dist=6}}},
			mapzone="Dustwallow Marsh",
			level=58,
		}, {
			"Go to "..cl(51,27),
			"	a. Use Umi's Mechanical Yeti on Sprinkle",
			"	b. Scare Sprinkle",
			completion={{questgoal={"*","Scare Sprinkle",1}}},
			mapzone="Tanaris",
			level=58,
			mapnote=26907800,
		}, {
			"Make Gadgetzan your home",
			completion={{home="Gadgetzan"}},
			mapzone="Tanaris",
			level=58,
		}, {
			"Go southeast to "..cl(70,50),
			"	a. Unpack Eridan's Supplies into your bags",
			"	b. Use the Book of Aquor to summon Aquementas inside the circle of stones",
			"	c. Kill Aquementas",
			"	d. Get the Silver Totem of Aquementas",
			completion={{questgoal={"*","Silver Totem of Aquementas",1}}},
			mapzone="Tanaris",
			level=58,
			mapnote=49912030,
		}, {
			"Hearth to Gadgetzan",
			completion={{location={mapzone="Tanaris",x=51.7,y=27.8, dist=6}}},
			mapzone="Tanaris",
			level=58,
		}, {
			"Fly to Marshal's Refuge",
			completion={{location={mapzone="Un'Goro Crater",x=44.9,y=8.2, dist=3}}},
			mapzone="Tanaris",
			level=58,
		}, {
			"Go to "..cl(44,9),
			"	a. Use Umi's Mechanical Yeti on Quixxil",
			"	b. Scare Quixxil",
			completion={{questgoal={"*","Scare Quixxil",1}}},
			mapzone="Un'Goro Crater",
			level=58,
			mapnote=9405310,
		}, {
			"Go to "..cl(42,3),
			"	a. Talk to J.D. Collie",
			"		i. Turn in "..cq("Aquementas"),
			"		ii. Accept "..cq("Linken's Adventure"),
			completion={{questturnedin="Aquementas"},{questaccepted="Linken's Adventure"}},
			mapzone="Un'Goro Crater",
			level=58,
			mapnote=2704460,
		}, {
			"Go to "..cl(45,8),
			"	a. Talk to Linken",
			"		i. Turn in "..cq("Linken's Adventure"),
			completion={{questturnedin="Linken's Adventure"}},
			mapzone="Un'Goro Crater",
			level=58,
			mapnote=8105280,
		}, {
			"Fly to Cenarion Hold in Silithus",
			completion={{location={mapzone="Silithus",x=50.4,y=36.5, dist=3}}},
			mapzone="Un'Goro Crater",
			level=58,
		}, {
			"Go to "..cl(50,38),
			"	a. Talk to Geologist Larksbane",
			"		i. Accept "..cq("The Twilight Mystery"),
			completion={{questaccepted="The Twilight Mystery"}},
			mapzone="Silithus",
			level=58,
			mapnote=37508720,
		}, {
			"Go to "..cl(51,38),
			"	a. Talk to Windcaller Proudhorn",
			"		i. Turn in "..cq("Taking Back Silithus"),
			"		ii. Accept "..cq("Securing the Supply Lines"),
			completion={{questturnedin="Taking Back Silithus"},{questaccepted="Securing the Supply Lines"}},
			mapzone="Silithus",
			level=58,
			mapnote=38308950,
		}, {
			"Make Cenarion Hold your home",
			completion={{home="Cenarion Hold"}},
			mapzone="Silithus",
			level=58,
		}, {
			"Go to "..cl(52,39),
			"	a. Talk to Beetix Ficklespragg",
			"		i. Accept "..cq("Deadly Desert Venom"),
			completion={{questaccepted="Deadly Desert Venom"}},
			mapzone="Silithus",
			level=58,
			mapnote=38609020,
		}, {
			"Go northeast to "..cl(54,31),
			"	a. Kill 15 Dredge Strikers",
			"	b. Kill Stonelash Scorpids",
			"	c. Kill Sand Skitterers",
			"	d. Get 8 Stonelash Scorpid Stingers",
			"	e. Get 8 Sand Skitterer Fangs",
			completion={{questgoal={"*","Dredge Striker slain",15}},{questgoal={"*","Stonelash Scorpid Stinger",8}},{questgoal={"*","Sand Skitterer Fang",8}}},
			mapzone="Silithus",
			level=58,
			mapnote=30608500,
		}, {
			"Go northeast to "..cl(82,19),
			"	a. Talk to Layo Starstrike",
			"		i. Turn in "..cq("Wasteland"),
			"		ii. Accept "..cq("The Spirits of Southwind"),
			completion={{questturnedin="Wasteland"},{questaccepted="The Spirits of Southwind"}},
			mapzone="Silithus",
			level=58,
			mapnote=18910080,
		}, {
			"Go west to "..cl(25,10),
			"	a. Click Twilight Tablet Fragments",
			"	b. Get 8 Twilight Tablet Fragments",
			completion={{questgoal={"*","Twilight Tablet Fragment",8}}},
			mapzone="Silithus",
			level=58,
			mapnote=10403520,
		}, {
			"Hearth to Cenarion Hold",
			completion={{location={mapzone="Silithus",x=50.4,y=36.5, dist=3}}},
			mapzone="Silithus",
			level=58,
		}, {
			"Go to "..cl(52,39),
			"	a. Talk to Beetix Ficklespragg",
			"		i. Turn in "..cq("Deadly Desert Venom"),
			"		ii. Accept "..cq("Noggle's Last Hope"),
			completion={{questturnedin="Deadly Desert Venom"},{questaccepted="Noggle's Last Hope"}},
			mapzone="Silithus",
			level=58,
			mapnote=38609020,
		}, {
			"Go to "..cl(51,38),
			"	a. Talk to Windcaller Proudhorn",
			"		i. Turn in "..cq("Securing the Supply Lines"),
			"		ii. Accept "..cq("Stepping Up Security"),
			completion={{questturnedin="Securing the Supply Lines"},{questaccepted="Stepping Up Security"}},
			mapzone="Silithus",
			level=58,
			mapnote=38308950,
		}, {
			"Go to "..cl(50,38),
			"	a. Talk to Geologist Larksbane",
			"		i. Turn in "..cq("The Twilight Mystery"),
			"		ii. Accept "..cq("The Deserter"),
			completion={{questturnedin="The Twilight Mystery"},{questaccepted="The Deserter"}},
			mapzone="Silithus",
			level=58,
			mapnote=37508720,
		}, {
			"Go southeast to "..cl(61,48),
			"	a. Kill 8 Tortured Druids",
			"	b. Kill 8 Tortured Sentinels",
			completion={{questgoal={"*","Tortured Druid slain",8}},{questgoal={"*","Tortured Sentinel slain",8}}},
			mapzone="Silithus",
			level=58,
			mapnote=48110890,
		}, {
			"Go southwest to "..cl(55,60),
			"	a. Kill 20 Dredge Crushers",
			"	b. Kill Stonelash Pincers",
			"	c. Get 3 Stonelash Pincer Stingers",
			completion={{questgoal={"*","Dredge Crusher slain",20}},{questgoal={"*","Stonelash Pincer Stinger",3}}},
			mapzone="Silithus",
			level=58,
			mapnote=59711480,
		}, {
			"Go southeast to 67,70 inside the cave",
			"	a. Talk to Hermit Ortell",
			"		i. Turn in "..cq("The Deserter"),
			completion={{questturnedin="The Deserter"}},
			mapzone="Silithus",
			level=58,
			mapnote=69813700,
		}, {
			"Go southwest to "..cl(65,75),
			"	a. Kill Stonelash Flayers",
			"	b. Kill Rock Stalkers",
			"	c. Get 3 Stonelash Flayer Stingers",
			"	d. Get 3 Rock Stalker Fangs",
			completion={{questgoal={"*","Stonelash Flayer Stinger",3}},{questgoal={"*","Rock Stalker Fang",3}}},
			mapzone="Silithus",
			level=58,
			mapnote=74713990,
		}, {
			"Grind to level 59",
			completion={{level=59}},
			mapzone="Silithus",
			level=58,
		}, {
			"Go northwest to Cenarion Hold",
			completion={{location={mapzone="Silithus",x=50.4,y=36.5, dist=3}}},
			mapzone="Silithus",
			level=59,
		}, {
			"Go to "..cl(52,39),
			"	a. Talk to Beetix Ficklespragg",
			"		i. Turn in "..cq("Noggle's Last Hope"),
			completion={{questturnedin="Noggle's Last Hope"}},
			mapzone="Silithus",
			level=59,
			mapnote=38609020,
		}, {
			"Go to "..cl(51,38),
			"	a. Talk to Windcaller Proudhorn",
			"		i. Turn in "..cq("Stepping Up Security"),
			completion={{questturnedin="Stepping Up Security"}},
			mapzone="Silithus",
			level=59,
			mapnote=38308950,
		}, {
			"Go northeast to "..cl(82,19),
			"	a. Talk to Layo Starstrike",
			"		i. Turn in "..cq("The Spirits of Southwind"),
			completion={{questturnedin="The Spirits of Southwind"}},
			mapzone="Silithus",
			level=59,
			mapnote=18910080,
		}, {
			"Go southwest to Cenarion Hold",
			completion={{location={mapzone="Silithus",x=50.4,y=36.5, dist=3}}},
			mapzone="Silithus",
			level=59,
		}, {
			"Fly to Theramore",
			completion={{location={mapzone="Dustwallow Marsh",x=67.5,y=50.3, dist=9}}},
			mapzone="Silithus",
			level=59,
		}, {
			"Ride the boat to Menethil Harbor",
			completion={{location={mapzone="Wetlands",x=4.6,y=56.8, dist=9}}},
			mapzone="Dustwallow Marsh",
			level=59,
		}, {
			"Fly to Ironforge",
			completion={{location={mapzone="City of Ironforge"}}},
			mapzone="Wetlands",
			level=59,
		}, {
			"Go to "..cl(29,22),
			"	a. Talk to Courier Hammerfall",
			"		i. He wanders around Ironforge",
			"		ii. Accept "..cq("A Call to Arms: The Plaguelands!"),
			completion={{questaccepted="A Call to Arms: The Plaguelands!"}},
			mapzone="Ironforge",
			level=59,
			mapnote=22105150,
		}, {
			"Make Ironforge your home",
			completion={{home="Ironforge"}},
			mapzone="Ironforge",
			level=59,
		}, {
			"Fly to Southshore",
			completion={{location={mapzone="Hillsbrad Foothills",x=50.0,y=56.9, dist=8}}},
			mapzone="Ironforge",
			level=59,
		}, {
			"Go north to the Alterac Mountains",
			completion={{location={mapzone="Alterac Mountains"}}},
			mapzone="Hillsbrad Foothills",
			level=59,
		}, {
			"Go northeast to the Western Plaguelands",
			completion={{location={mapzone="Western Plaguelands"}}},
			mapzone="Alterac Mountains",
			level=59,
		}, {
			"Go north to Chillwind Camp",
			completion={{location={mapzone="Western Plaguelands",x=43.0,y=84.3, dist=1.5}}},
			mapzone="Western Plaguelands",
			level=59,
		}, {
			"Go to "..cl(43,84),
			"	a. Talk to Argent Officer Pureheart",
			"		i. Turn in "..cq("The Everlook Report"),
			"		ii. Turn in "..cq("Argent Dawn Commission"),
			"	b. Equip the Argent Dawn Commission Trinket you just got",
			completion={{questturnedin="The Everlook Report"},{questturnedin="Argent Dawn Commission"}},
			mapzone="Western Plaguelands",
			level=59,
			mapnote=83512650,
		}, {
			"Also at "..cl(43,84),
			"	a. Talk to Commander Ashlam Valorfist",
			"		i. Turn in "..cq("A Call to Arms: The Plaguelands!"),
			"		ii. Accept "..cq("Clear the Way"),
			completion={{questturnedin="A Call to Arms: The Plaguelands!"},{questaccepted="Clear the Way"}},
			mapzone="Western Plaguelands",
			level=59,
			mapnote=84012670,
		}, {
			"Also at "..cl(43,84),
			"	a. Talk to Anchorite Truuen",
			"		i. Accept "..cq("The Mark of the Lightbringer"),
			completion={{questaccepted="The Mark of the Lightbringer"}},
			mapzone="Western Plaguelands",
			level=59,
			mapnote=84512740,
		}, {
			"Go to "..cl(43,85),
			"	a. Talk to Bibilfaz Featherwhistle",
			"		i. Get the Chillwind Camp Flight Path",
			completion={{flightpath="Chillwind Camp"}},
			mapzone="Western Plaguelands",
			level=59,
			mapnote=85112800,
		}, {
			"Go northeast to "..cl(48,81),
			"	a. Kill 10 Skeletal Flayers",
			"	b. Kill 10 Slavering Ghouls",
			completion={{questgoal={"*","Skeletal Flayer slain",10}},{questgoal={"*","Slavering Ghoul slain",10}}},
			mapzone="Western Plaguelands",
			level=59,
			mapnote=81212940,
		}, {
			"Go southwest to Chillwind Camp",
			completion={{location={mapzone="Western Plaguelands",x=43.0,y=84.3, dist=1.5}}},
			mapzone="Western Plaguelands",
			level=59,
		}, {
			"Go to "..cl(43,84),
			"	a. Talk to Commander Ashlam Valorfist",
			"		i. Turn in "..cq("Clear the Way"),
			"		ii. Accept "..cq("The Scourge Cauldrons"),
			"		iii. Accept "..cq("All Along the Watchtowers"),
			completion={{questturnedin="Clear the Way"},{questaccepted="The Scourge Cauldrons"},{questaccepted="All Along the Watchtowers"}},
			mapzone="Western Plaguelands",
			level=59,
			mapnote=84012670,
		}, {
			"Go to "..cl(43,84),
			"	a. Talk to High Priestess MacDonnell",
			"		i. Turn in "..cq("The Scourge Cauldrons"),
			"		ii. Accept "..cq("Target: Felstone Field"),
			completion={{questturnedin="The Scourge Cauldrons"},{questaccepted="Target: Felstone Field"}},
			mapzone="Western Plaguelands",
			level=59,
			mapnote=84512740,
		}, {
			"Go northeast to "..cl(49,73),
			"	a. Enter the Ruins of Andorhal from this bridge",
			completion={{location={mapzone="Western Plaguelands",x=49.3,y=73.2, dist=0.3}}},
			mapzone="Western Plaguelands",
			level=59,
			mapnote=73212250,
		}, {
			"Go northwest to "..cl(47,71),
			"	a. Use your Beacon Torch near the tower entrance",
			"	b. Mark Tower Four",
			completion={{questgoal={"*","Tower Four marked",1}}},
			mapzone="Western Plaguelands",
			level=59,
			mapnote=71111770,
		}, {
			"Go west to "..cl(40,72),
			"	a. Use your Beacon Torch near the tower entrance",
			"	b. Mark Tower One",
			completion={{questgoal={"*","Tower One marked",1}}},
			mapzone="Western Plaguelands",
			level=59,
			mapnote=71611160,
		}, {
			"Go northeast to "..cl(42,66),
			"	a. Use your Beacon Torch near the tower entrance",
			"	b. Mark Tower Two",
			completion={{questgoal={"*","Tower Two marked",1}}},
			mapzone="Western Plaguelands",
			level=59,
			mapnote=66310860,
		}, {
			"Go northeast to "..cl(44,63),
			"	a. Use your Beacon Torch near the tower entrance",
			"	b. Mark Tower Three",
			completion={{questgoal={"*","Tower Three marked",1}}},
			mapzone="Western Plaguelands",
			level=59,
			mapnote=63310760,
		}, {
			"Go northwest to "..cl(37,57),
			"	a. Kill Cauldron Lord Bilemaw",
			"	b. Get the Felstone Field Cauldron Key",
			"	c. Click the Scourge Cauldron",
			"		i. Turn in "..cq("Target: Felstone Field"),
			"		ii. Accept "..cq("Return to Chillwind Camp"),
			completion={{questturnedin="Target: Felstone Field"},{questaccepted="Return to Chillwind Camp"}},
			mapzone="Western Plaguelands",
			level=59,
			mapnote=57109410,
		}, {
			"Go northeast to "..cl(38,54),
			"	a. Talk to Janice Felstone",
			"		i. Accept "..cq("Better Late Than Never part 1"),
			completion={{questaccepted="Better Late Than Never part 1"}},
			mapzone="Western Plaguelands",
			level=59,
			mapnote=54009240,
		}, {
			"Go south to "..cl(39,55),
			"	a. Click Janice's Parcel",
			"		i. Turn in "..cq("Better Late Than Never part 1"),
			"		ii. Accept "..cq("Better Late Than Never part 2"),
			completion={{questturnedin="Better Late Than Never part 1"},{questaccepted="Better Late Than Never part 2"}},
			mapzone="Western Plaguelands",
			level=59,
			mapnote=55309400,
		}, {
			"Go southeast to Chillwind Camp",
			completion={{location={mapzone="Western Plaguelands",x=43.0,y=84.3, dist=1.5}}},
			mapzone="Western Plaguelands",
			level=59,
		}, {
			"Go to "..cl(43,84),
			"	a. Talk to Commander Ashlam Valorfist",
			"		i. Turn in "..cq("All Along the Watchtowers"),
			"		ii. Accept "..cq("Scholomance"),
			"	b. Talk to Alchemist Arbington",
			"		i. Turn in "..cq("Scholomance"),
			"		ii. Accept "..cq("Skeletal Fragments"),
			completion={{questturnedin="All Along the Watchtowers"},{questaccepted="Scholomance"},{questturnedin="Scholomance"},{questaccepted="Skeletal Fragments"}},
			mapzone="Western Plaguelands",
			level=59,
			mapnote=84012670,
		}, {
			"Also at "..cl(43,84),
			"	a. Talk to High Priestess MacDonnell",
			"		i. Turn in "..cq("Return to Chillwind Camp"),
			"		ii. Accept "..cq("Target: Dalson's Tears"),
			completion={{questturnedin="Return to Chillwind Camp"},{questaccepted="Target: Dalson's Tears"}},
			mapzone="Western Plaguelands",
			level=59,
			mapnote=84512740,
		}, {
			"Go northeast to "..cl(46,52),
			"	a. Kill Cauldron Lord Malvinious",
			"	b. Get the Dalson's Tears Cauldron Key",
			"	c. Click the Scourge Cauldron",
			"		i. Turn in "..cq("Target: Dalson's Tears"),
			"		ii. Accept "..cq("Return to Chillwind Camp"),
			completion={{questturnedin="Target: Dalson's Tears"},{questaccepted="Return to Chillwind Camp"}},
			mapzone="Western Plaguelands",
			level=59,
			mapnote=52409860,
		}, {
			"Go northeast to "..cl(48,51),
			"	a. Click Mrs. Dalson's Diary",
			"		i. Turn in "..cq("Mrs. Dalson's Diary"),
			completion={{questturnedin="Mrs. Dalson's Diary"}},
			mapzone="Western Plaguelands",
			level=59,
			mapnote=50709840,
		}, {
			"Go north to "..cl(48,50),
			"	a. Kill a Wandering Skeleton",
			"	b. Get the Dalson Outhouse Key",
			"	c. Unlock the Outhouse with the Dalson Outhouse Key",
			"	d. Kill Farmer Dalson",
			"	e. Get the Dalson Cabinet Key",
			completion={{questgoal={"*","Dalson Cabinet Key",1}}},
			mapzone="Western Plaguelands",
			level=59,
			mapnote=49709780,
		}, {
			"Go west to "..cl(47,50),
			"	a. Unlock the Locked Cabinet with the Dalson Cabinet Key",
			"		i. Turn in "..cq("Locked Away"),
			completion={{questturnedin="Locked Away"}},
			mapzone="Western Plaguelands",
			level=59,
			mapnote=49709710,
		}, {
			"Go north to "..cl(50,31),
			"	a. The path down to Kirsta Deepshadow starts here",
			"	b. Follow the path down",
			completion={{location={mapzone="Western Plaguelands",x=50.0,y=30.4, dist=0.5}}},
			mapzone="Western Plaguelands",
			level=59,
			mapnote=30508050,
		}, {
			"Go northeast to "..cl(52,28),
			"	a. Talk to Kirsta Deepshadow",
			"		i. Accept "..cq("Unfinished Business part 1"),
			completion={{questaccepted="Unfinished Business part 1"}},
			mapzone="Western Plaguelands",
			level=59,
			mapnote=28007990,
		}, {
			"Go south to "..cl(50,41),
			"	a. Kill 2 Scarlet Knights",
			"	b. Kill 2 Scarlet Mages",
			completion={{questgoal={"*","Scarlet Knight slain",2}},{questgoal={"*","Scarlet Mage slain",2}}},
			mapzone="Western Plaguelands",
			level=59,
			mapnote=41509180,
		}, {
			"Go southeast to "..cl(51,44),
			"	a. Kill 2 Scarlet Hunters",
			"	b. Kill 2 Scarlet Medics",
			completion={{questgoal={"*","Scarlet Hunter slain",2}},{questgoal={"*","Scarlet Medic slain",2}}},
			mapzone="Western Plaguelands",
			level=59,
			mapnote=43709480,
		}, {
			"Go northeast to "..cl(52,28),
			"	a. Talk to Kirsta Deepshadow",
			"		i. Turn in "..cq("Unfinished Business part 1"),
			"		ii. Accept "..cq("Unfinished Business part 2"),
			completion={{questturnedin="Unfinished Business part 1"},{questaccepted="Unfinished Business part 2"}},
			mapzone="Western Plaguelands",
			level=59,
			mapnote=28007990,
		}, {
			"Go southeast to "..cl(56,34),
			"	a. The path up to Huntsman Radley starts here",
			"	b. Follow the path up",
			completion={{location={mapzone="Western Plaguelands",x=56.4,y=34.0, dist=0.3}}},
			mapzone="Western Plaguelands",
			level=59,
			mapnote=34009040,
		}, {
			"Go southeast to "..cl(58,36),
			"	a. Kill Hunstman Radley",
			completion={{questgoal={"*","Huntsman Radley slain",1}}},
			mapzone="Western Plaguelands",
			level=59,
			mapnote=36309400,
		}, {
			"Go northwest to "..cl(54,24),
			"	a. Kill Cavalier Durgen when he comes out in front of the tower",
			"	b. Go to the top of the tower",
			"	c. Click the small brown chest",
			"	d. Get the Mark of the Lightbringer",
			"		i. You may need help with this  if so, find a partner",
			completion={{questgoal={"*","Cavalier Durgen slain",1}},{questgoal={"*","Mark of the Lightbringer",1}}},
			mapzone="Western Plaguelands",
			level=59,
			mapnote=24207840,
		}, {
			"Go west to "..cl(53,25),
			"	a. Jump off the cliff down to Kirsta Deepshadow",
			completion={{location={mapzone="Western Plaguelands",x=52.8,y=25.2, dist=0.3}}},
			mapzone="Western Plaguelands",
			level=59,
			mapnote=25207770,
		}, {
			"Go south to "..cl(52,28),
			"	a. Talk to Kirsta Deepshadow",
			"		i. Turn in "..cq("Unfinished Business part 2"),
			completion={{questturnedin="Unfinished Business part 2"}},
			mapzone="Western Plaguelands",
			level=59,
			mapnote=28007990,
		}, {
			"Go southwest to Chillwind Camp",
			completion={{location={mapzone="Western Plaguelands",x=43.0,y=84.3, dist=1.5}}},
			mapzone="Western Plaguelands",
			level=59,
		}, {
			"Go to "..cl(43,84),
			"	a. Talk to High Priestess MacDonnell",
			"		i. Turn in "..cq("Return to Chillwind Camp"),
			"		ii. Accept "..cq("Target: Writhing Haunt"),
			completion={{questturnedin="Return to Chillwind Camp"},{questaccepted="Target: Writhing Haunt"}},
			mapzone="Western Plaguelands",
			level=59,
			mapnote=84512740,
		}, {
			"Fly to Stormwind",
			completion={{location={mapzone="Stormwind City"}}},
			mapzone="Western Plaguelands",
			level=59,
		}, {
			"Go to "..cl(49,31),
			"	a. Talk to Royal Factor Bathrilor",
			"		i. Turn in "..cq("Better Late Than Never part 2"),
			"		ii. Accept "..cq("Good Natured Emma"),
			completion={{questturnedin="Better Late Than Never part 2"},{questaccepted="Good Natured Emma"}},
			mapzone="Stormwind City",
			level=59,
			mapnote=30607910,
		}, {
			"Go to "..cl(52,42),
			"	a. Talk to Ol' Emma",
			"		i. Turn in "..cq("Good Natured Emma"),
			"		ii. Accept "..cq("Good Luck Charm"),
			completion={{questturnedin="Good Natured Emma"},{questaccepted="Good Luck Charm"}},
			mapzone="Stormwind City",
			level=59,
			mapnote=42109450,
		}, {
			"Go to "..cl(78,18),
			"	a. Talk to Highlord Bolvar Fordragon",
			"		i. Accept "..cq("The First and the Last"),
			completion={{questaccepted="The First and the Last"}},
			mapzone="Stormwind City",
			level=59,
			mapnote=18009620,
		}, {
			"Go to "..cl(76,60),
			"	a. Talk to Master Mathias Shaw",
			"		i. Turn in "..cq("The First and the Last"),
			"		ii. Accept "..cq("Honor the Dead"),
			"		iii. Turn in "..cq("Honor the Dead"),
			"		iv. Accept "..cq("Flint Shadowmore"),
			completion={{questturnedin="The First and the Last"},{questaccepted="Honor the Dead"},{questturnedin="Honor the Dead"},{questaccepted="Flint Shadowmore"}},
			mapzone="Stormwind City",
			level=59,
			mapnote=59813580,
		}, {
			"Fly to Chillwind Camp",
			completion={{location={mapzone="Western Plaguelands",x=43.0,y=84.3, dist=1.5}}},
			mapzone="Stormwind City",
			level=59,
		}, {
			"Go to "..cl(44,85),
			"	a. Talk to Flint Shadowmore",
			"		i. Turn in "..cq("Flint Shadowmore"),
			"		ii. Accept "..cq("The Eastern Plagues"),
			completion={{questturnedin="Flint Shadowmore"},{questaccepted="The Eastern Plagues"}},
			mapzone="Western Plaguelands",
			level=59,
			mapnote=84512810,
		}, {
			"Go north to "..cl(38,54),
			"	a. Talk to Janice Felstone",
			"		i. Turn in "..cq("Good Luck Charm"),
			"		ii. Accept "..cq("Two Halves Become One"),
			completion={{questturnedin="Good Luck Charm"},{questaccepted="Two Halves Become One"}},
			mapzone="Western Plaguelands",
			level=59,
			mapnote=54009240,
		}, {
			"Go southwest to "..cl(38,55),
			"	a. Kill a Jabbering Ghoul outside the house",
			"	b. Get the Good Luck Other-Half Charm",
			"	c. Click the Good Luck Other-Half Charm in your bags",
			"	d. Get the Good Luck Charm",
			"	e. Kill skeletons",
			"	f. Get 15 Skeletal Fragments",
			completion={{questgoal={"*","Good Luck Charm",1}},{questgoal={"*","Skeletal Fragments",15}}},
			mapzone="Western Plaguelands",
			level=59,
			mapnote=55009250,
		}, {
			"Go northeast to "..cl(38,54),
			"	a. Talk to Janice Felstone",
			"		i. Combine the two halves of the charm",
			"		ii. Turn in "..cq("Two Halves Become One"),
			completion={{questturnedin="Two Halves Become One"}},
			mapzone="Western Plaguelands",
			level=59,
			mapnote=54009240,
		}, {
			"Go southeast to "..cl(53,66),
			"	a. Kill Cauldron Lord Razarch",
			"	b. Get the Writhing Haunt Cauldron Key",
			"	c. Click the Scourge Cauldron",
			"		i. Turn in "..cq("Target: Writhing Haunt"),
			"		ii. Accept "..cq("Return to Chillwind Camp"),
			completion={{questturnedin="Target: Writhing Haunt"},{questaccepted="Return to Chillwind Camp"}},
			mapzone="Western Plaguelands",
			level=59,
			mapnote=66011900,
		}, {
			"Grind to level 60",
			completion={{level=60}},
			"	a. You have 2 options here.  The guide continues to level you to halfway to level 61 using quests in Azeroth before going to Outland.  This is to prevent you from having to grind half a level in Hellfire Peninsula in Outland.  If you do not mind grinding half a level in Outland, or would prefer to run the Ramparts instance in Outland, you can do that if you wish whenever the guide tells you to grind half the level. If you would like to level using purely quests, continue following the guide.  If not, continue to the Outlands guide section.",
			mapzone="Western Plaguelands",
			level=60,
		}, {
			"Go southwest to Chillwind Camp",
			completion={{location={mapzone="Western Plaguelands",x=43.0,y=84.3, dist=1.5}}},
			mapzone="Western Plaguelands",
			level=60,
		}, {
			"Go to "..cl(43,84),
			"	a. Talk to Alchemist Arbington",
			"		i. Turn in "..cq("Skeletal Fragments"),
			completion={{questturnedin="Skeletal Fragments"}},
			mapzone="Western Plaguelands",
			level=60,
			mapnote=84012670,
		}, {
			"Also at "..cl(43,84),
			"	a. Talk to High Priestess MacDonnell",
			"		i. Turn in "..cq("Return to Chillwind Camp"),
			"		ii. Accept "..cq("Target: Gahrron's Withering"),
			"	b. Talk to Anchorite Truuen",
			"		i. Turn in "..cq("The Mark of the Lightbringer"),
			"		ii. Accept "..cq("Tomb of the Lightbringer"),
			"		iii. Escort Anchorite Truuen",
			completion={{questturnedin="Return to Chillwind Camp"},{questaccepted="Target: Gahrron's Withering"},{questturnedin="The Mark of the Lightbringer"},{questaccepted="Tomb of the Lightbringer"},{questgoal={"*","Escort Anchorite Truuen to Uther's Tomb",1}}},
			mapzone="Western Plaguelands",
			level=60,
			mapnote=84512740,
		}, {
			"Go north to "..cl(54,65),
			"	a. Talk to Mulgris Deepriver",
			"		i. Accept "..cq("The Wildlife Suffers Too part 1"),
			completion={{questaccepted="The Wildlife Suffers Too part 1"}},
			mapzone="Western Plaguelands",
			level=60,
			mapnote=64711840,
		}, {
			"Go northwest to "..cl(46,47),
			"	a. Kill 4 Diseased Wolves",
			completion={{questgoal={"*","Diseased Wolf slain",4}}},
			mapzone="Western Plaguelands",
			level=60,
			mapnote=47409300,
		}, {
			"Go southwest to "..cl(43,55),
			"	a. Kill 4 Diseased Wolves",
			completion={{questgoal={"*","Diseased Wolf slain",4}}},
			mapzone="Western Plaguelands",
			level=60,
			mapnote=55409820,
		}, {
			"Go southeast to "..cl(54,65),
			"	a. Talk to Mulgris Deepriver",
			"		i. Turn in "..cq("The Wildlife Suffers Too part 1"),
			"		ii. Accept "..cq("The Wildlife Suffers Too part 2"),
			completion={{questturnedin="The Wildlife Suffers Too part 1"},{questaccepted="The Wildlife Suffers Too part 2"}},
			mapzone="Western Plaguelands",
			level=60,
			mapnote=64711840,
		}, {
			"Go northeast to "..cl(58,61),
			"	a. Kill 8 Diseased Grizzlies",
			completion={{questgoal={"*","Diseased Grizzly slain",8}}},
			mapzone="Western Plaguelands",
			level=60,
			mapnote=61211910,
		}, {
			"Go southwest to "..cl(54,65),
			"	a. Talk to Mulgris Deepriver",
			"		i. Turn in "..cq("The Wildlife Suffers Too part 2"),
			completion={{questturnedin="The Wildlife Suffers Too part 2"}},
			mapzone="Western Plaguelands",
			level=60,
			mapnote=64711840,
		}, {
			"Go northeast to "..cl(63,60),
			"	a. Kill Cauldron Lord Soulwrath",
			"	b. Get the Gahrron's Withering Cauldron Key",
			"	c. Click the Scourge Cauldron",
			"		i. Turn in "..cq("Target: Gahrron's Withering"),
			"		ii. Accept "..cq("Return to Chillwind Camp"),
			completion={{questturnedin="Target: Gahrron's Withering"},{questaccepted="Return to Chillwind Camp"}},
			mapzone="Western Plaguelands",
			level=60,
			mapnote=59912250,
		}, {
			"Go northeast to the Eastern Plaguelands",
			completion={{location={mapzone="Eastern Plaguelands"}}},
			mapzone="Western Plaguelands",
			level=60,
		}, {
			"Go north up the coast to "..cl(8,44),
			"	a. Talk to Tirion Fordring",
			"		i. Accept "..cq("Demon Dogs"),
			"		ii. Accept "..cq("Blood Tinged Skies"),
			"		iii. Accept "..cq("Carrion Grubbage"),
			completion={{questaccepted="Demon Dogs"},{questaccepted="Blood Tinged Skies"},{questaccepted="Carrion Grubbage"}},
			mapzone="Eastern Plaguelands",
			level=60,
			mapnote=43605110,
		}, {
			"Go southeast to "..cl(29,80),
			"	a. Click the Mangled Human Remains",
			"	b. Get the SI:7 Insignia (Rutger)",
			completion={{questgoal={"*","SI:7 Insignia (Rutger)",1}}},
			mapzone="Eastern Plaguelands",
			level=60,
			mapnote=79910870,
		}, {
			"Go north to "..cl(29,75),
			"	a. Click the Mangled Human Remains",
			"	b. Get the SI:7 Insignia (Turyen)",
			completion={{questgoal={"*","SI:7 Insignia (Turyen)",1}}},
			mapzone="Eastern Plaguelands",
			level=60,
			mapnote=74910370,
		}, {
			"Go west to "..cl(27,75),
			"	a. Click the Mangled Human Remains",
			"	b. Get the SI:7 Insignia (Fredo)",
			"	c. See a message saying you Uncovered the Blightcaller",
			completion={{questgoal={"*","SI:7 Insignia (Fredo)",1}},{questgoal={"*","The Blightcaller Uncovered",1}}},
			mapzone="Eastern Plaguelands",
			level=60,
			mapnote=75010220,
		}, {
			"Go northeast to "..cl(35,68),
			"	a. Kill 20 Plaguehound Runts",
			"	b. Kill 30 Plaguebats",
			"	c. Kill Carrion Grubs",
			"	d. Get 15 Slabs of Carrion Worm Meat",
			completion={{questgoal={"*","Plaguehound Runt slain",20}},{questgoal={"*","Plaguebat slain",30}},{questgoal={"*","Slab of Carrion Worm Meat",15}}},
			mapzone="Eastern Plaguelands",
			level=60,
			mapnote=68310350,
		}, {
			"Go southeast to "..cl(37,91),
			"	a. Talk to Pamela Redpath",
			"		i. Turn in "..cq("Sister Pamela"),
			"		ii. Accept "..cq("Pamela's Doll"),
			completion={{questturnedin="Sister Pamela"},{questaccepted="Pamela's Doll"}},
			mapzone="Eastern Plaguelands",
			level=60,
			mapnote=90712720,
		}, {
			"Go east to "..cl(39,92),
			"	a. The doll parts spawn in the houses here, except the house Pamela is in",
			"	b. Get Pamela's Doll's Head",
			"	c. Get Pamela's Doll's Left Side",
			"	d. Get Pamela's Doll's Right Side",
			"	e. Put the doll parts together to make Pamela's Doll",
			completion={{questgoal={"*","Pamela's Doll",1}}},
			mapzone="Eastern Plaguelands",
			level=60,
			mapnote=91513060,
		}, {
			"Go west to "..cl(37,91),
			"	a. Talk to Pamela Redpath",
			"		i. Turn in "..cq("Pamela's Doll"),
			"		ii. Accept "..cq("Uncle Carlin"),
			"		iii. Accept "..cq("Auntie Marlene"),
			completion={{questturnedin="Pamela's Doll"},{questaccepted="Uncle Carlin"},{questaccepted="Auntie Marlene"}},
			mapzone="Eastern Plaguelands",
			level=60,
			mapnote=90712720,
		}, {
			"Go northeast to "..cl(55,55),
			"	a. Kill 5 Plaguehounds",
			completion={{questgoal={"*","Plaguehound slain",5}}},
			mapzone="Eastern Plaguelands",
			level=60,
			mapnote=55010950,
		}, {
			"Go northeast to "..cl(63,48),
			"	a. Kill 5 Frenzied Plaguehounds",
			completion={{questgoal={"*","Frenzied Plaguehound slain",5}}},
			mapzone="Eastern Plaguelands",
			level=60,
			mapnote=48111080,
		}, {
			"Go southeast to "..cl(81,60),
			"	a. Talk to Duke Nicholas Zverenhoff",
			"		i. Turn in "..cq("Duke Nicholas Zverenhoff"),
			"	b. Talk to Carlin Redpath",
			"		i. Turn in "..cq("Uncle Carlin"),
			"		ii. Accept "..cq("Defenders of Darrowshire"),
			completion={{questturnedin="Duke Nicholas Zverenhoff"},{questturnedin="Uncle Carlin"},{questaccepted="Defenders of Darrowshire"}},
			mapzone="Eastern Plaguelands",
			level=60,
			mapnote=59814120,
		}, {
			"Go to "..cl(82,59),
			"	a. Talk to Khaelyn Steelwing",
			"		i. Get the Light's Hope Chapel Flight Path",
			completion={{flightpath="Light's Hope Chapel"}},
			mapzone="Eastern Plaguelands",
			level=60,
			mapnote=59314090,
		}, {
			"Go southwest to "..cl(80,64),
			"	a. Talk to Caretaker Alen",
			"		i. Accept "..cq("Zaeldarr the Outcast"),
			completion={{questaccepted="Zaeldarr the Outcast"}},
			mapzone="Eastern Plaguelands",
			level=60,
			mapnote=63914350,
		}, {
			"Fly to Chillwind Camp",
			completion={{location={mapzone="Western Plaguelands",x=43.0,y=84.3, dist=1.5}}},
			mapzone="Eastern Plaguelands",
			level=60,
		}, {
			"Go to "..cl(43,84),
			"	a. Talk to High Priestess MacDonnell",
			"		i. Turn in "..cq("Tomb of the Lightbringer"),
			"		ii. Turn in "..cq("Return to Chillwind Camp"),
			completion={{questturnedin="Tomb of the Lightbringer"},{questturnedin="Return to Chillwind Camp"}},
			mapzone="Western Plaguelands",
			level=60,
			mapnote=84512740,
		}, {
			"Also at "..cl(43,84),
			"	a. Talk to Commander Ashlam Valorfist",
			"		i. Turn in "..cq("Mission Accomplished!"),
			completion={{questturnedin="Mission Accomplished!"}},
			mapzone="Western Plaguelands",
			level=60,
			mapnote=84012670,
		}, {
			"Go to "..cl(44,85),
			"	a. Talk to Flint Shadowmore",
			"		i. Turn in "..cq("The Eastern Plagues"),
			"		ii. Accept "..cq("The Blightcaller Cometh"),
			completion={{questturnedin="The Eastern Plagues"},{questaccepted="The Blightcaller Cometh"}},
			mapzone="Western Plaguelands",
			level=60,
			mapnote=84512810,
		}, {
			"Fly to Stormwind",
			completion={{location={mapzone="Stormwind City"}}},
			mapzone="Western Plaguelands",
			level=60,
		}, {
			"Go to "..cl(78,18),
			"	a. Talk to Highlord Bolvar Fordragon",
			"		i. Turn in "..cq("The Blightcaller Cometh"),
			completion={{questturnedin="The Blightcaller Cometh"}},
			mapzone="Stormwind City",
			level=60,
			mapnote=18009620,
		}, {
			"Fly to Chillwind Camp",
			completion={{location={mapzone="Western Plaguelands",x=43.0,y=84.3, dist=1.5}}},
			mapzone="Stormwind City",
			level=60,
		}, {
			"Go northeast to "..cl(49,79),
			"	a. Talk to Marlene Redpath",
			"		i. Turn in "..cq("Auntie Marlene"),
			"		ii. Accept "..cq("A Strange Historian"),
			completion={{questturnedin="Auntie Marlene"},{questaccepted="A Strange Historian"}},
			mapzone="Western Plaguelands",
			level=60,
			mapnote=78512770,
		}, {
			"Go northeast to "..cl(50,77),
			"	a. Click Joseph Redpath's Monument",
			"	b. Get Joseph's Wedding Ring",
			completion={{questgoal={"*","Joseph's Wedding Ring",1}}},
			mapzone="Western Plaguelands",
			level=60,
			mapnote=76812650,
		}, {
			"Go northwest to "..cl(40,67),
			"	a. Talk to Chromie",
			"		i. Turn in "..cq("A Strange Historian"),
			"		ii. Accept "..cq("The Annals of Darrowshire"),
			"		iii. Accept "..cq("A Matter of Time"),
			completion={{questturnedin="A Strange Historian"},{questaccepted="The Annals of Darrowshire"},{questaccepted="A Matter of Time"}},
			mapzone="Western Plaguelands",
			level=60,
			mapnote=66810630,
		}, {
			"Go southeast to "..cl(44,69),
			"	a. Get the Annals of Darrowshire",
			completion={{questgoal={"*","Annals of Darrowshire",1}}},
			mapzone="Western Plaguelands",
			level=60,
			mapnote=69411290,
		}, {
			"Go northeast to "..cl(47,66),
			"	a. Use your Temporal Displacer on the disco ball towers",
			"	b. Kill 15 Temporal Parasites",
			completion={{questgoal={"*","Temporal Parasite slain",15}}},
			mapzone="Western Plaguelands",
			level=60,
			mapnote=65711260,
		}, {
			"Go west to "..cl(40,67),
			"	a. Talk to Chromie",
			"		i. Turn in "..cq("The Annals of Darrowshire"),
			"		ii. Accept "..cq("Brother Carlin"),
			"		iii. Turn in "..cq("A Matter of Time"),
			"		iv. Accept "..cq("Counting Out Time"),
			completion={{questturnedin="The Annals of Darrowshire"},{questaccepted="Brother Carlin"},{questturnedin="A Matter of Time"},{questaccepted="Counting Out Time"}},
			mapzone="Western Plaguelands",
			level=60,
			mapnote=66810630,
		}, {
			"Go southwest to "..cl(39,68),
			"	a. Click the Small Lockboxes on the ground in the crumbled houses",
			"	b. Get 5 Andorhal Watches",
			completion={{questgoal={"*","Andorhal Watch",5}}},
			mapzone="Western Plaguelands",
			level=60,
			mapnote=68310710,
		}, {
			"Go northeast to "..cl(40,67),
			"	a. Talk to Chromie",
			"		i. Turn in "..cq("Counting Out Time"),
			completion={{questturnedin="Counting Out Time"}},
			mapzone="Western Plaguelands",
			level=60,
			mapnote=66810630,
		}, {
			"Go northeast to the Eastern Plaguelands",
			completion={{location={mapzone="Eastern Plaguelands"}}},
			mapzone="Western Plaguelands",
			level=60,
		}, {
			"Go north up the coast to "..cl(8,44),
			"	a. Talk to Tirion Fordring",
			"		i. Turn in "..cq("Demon Dogs"),
			"		ii. Turn in "..cq("Blood Tinged Skies"),
			"		iii. Turn in "..cq("Carrion Grubbage"),
			"		iv. Accept "..cq("Redemption"),
			"		v. Turn in "..cq("Redemption"),
			"		vi. Accept "..cq("Of Forgotten Memories"),
			completion={{questturnedin="Demon Dogs"},{questturnedin="Blood Tinged Skies"},{questturnedin="Carrion Grubbage"},{questaccepted="Redemption"},{questturnedin="Redemption"},{questaccepted="Of Forgotten Memories"}},
			mapzone="Eastern Plaguelands",
			level=60,
			mapnote=43605110,
		}, {
			"Go southeast to "..cl(28,87),
			"	a. Click the Loose Dirt Mound",
			"	b. Kill Mercutio",
			"	c. Get Taelan's Hammer",
			"	d. You may need help with this  if so, get a partner",
			completion={{questgoal={"*","Taelan's Hammer",1}}},
			mapzone="Eastern Plaguelands",
			level=60,
			mapnote=86911520,
		}, {
			"Go northwest into the crypt at"..cl(28,85),
			"	a. Kill Zaeldarr the Outcast",
			"	b. Get Zaeldarr's Head",
			completion={{questgoal={"*","Zaeldarr's Head",1}}},
			mapzone="Eastern Plaguelands",
			level=60,
			mapnote=84811230,
		}, {
			"Go northwest to "..cl(8,44),
			"	a. Talk to Tirion Fordring",
			"		i. Turn in "..cq("Of Forgotten Memories"),
			completion={{questturnedin="Of Forgotten Memories"}},
			mapzone="Eastern Plaguelands",
			level=60,
			mapnote=43605110,
		}, {
			"Go southeast to "..cl(58,71),
			"	a. Kill ghouls",
			"	b. Free 15 Darrowshire Spirits",
			completion={{questgoal={"*","Darrowshire Spirits Freed",15}}},
			mapzone="Eastern Plaguelands",
			level=60,
			mapnote=70712830,
		}, {
			"Go northeast to "..cl(80,64),
			"	a. Talk to Caretaker Alen",
			"		i. Turn in "..cq("Zaeldarr the Outcast"),
			completion={{questturnedin="Zaeldarr the Outcast"}},
			mapzone="Eastern Plaguelands",
			level=60,
			mapnote=63914350,
		}, {
			"Go northeast to "..cl(81,60),
			"	a. Talk to Carlin Redpath",
			"		i. Turn in "..cq("Brother Carlin"),
			"		ii. Turn in "..cq("Defenders of Darrowshire"),
			completion={{questturnedin="Brother Carlin"},{questturnedin="Defenders of Darrowshire"}},
			mapzone="Eastern Plaguelands",
			level=60,
			mapnote=59814120,
		}, {
			"Hearth to Ironforge",
			completion={{location={mapzone="City of Ironforge"}}},
			mapzone="Eastern Plaguelands",
			level=60,
		}, {
			"Fly to Menethil Harbor",
			completion={{location={mapzone="Wetlands",x=10.1,y=56.7, dist=9}}},
			mapzone="Ironforge",
			level=60,
		}, {
			"Ride the boat to Auberdine",
			completion={{location={mapzone="Darkshore",x=32.8,y=42.0, dist=9}}},
			mapzone="Wetlands",
			level=60,
		}, {
			"Fly to Everlook",
			completion={{location={mapzone="Winterspring",x=61.2,y=38.3, dist=3}}},
			mapzone="Darkshore",
			level=60,
		}, {
			"Go to "..cl(61,38),
			"	a. Talk to Umi Rumplesnicker",
			"		i. Turn in "..cq("Are We There, Yeti? part 3"),
			completion={{questturnedin="Are We There, Yeti? part 3"}},
			mapzone="Winterspring",
			level=60,
			mapnote=37609850,
		}, {
			"Go to "..cl(62,39),
			"	a. Talk to Felnok Steelspring",
			"		i. Turn in "..cq("Felnok Steelspring"),
			completion={{questturnedin="Felnok Steelspring"}},
			mapzone="Winterspring",
			level=60,
			mapnote=38610020,
		}, {

			"Grind until you are halfway to level 61",
			mapzone="Winterspring",
			level=60,
		}
	  },
	},
	{ sectiontitle = "Outlands (60-62)",
	  steps = {
		{
			"Go to the Blasted Lands",
			completion={{location={mapzone="Blasted Lands"}}},
			mapzone="Winterspring",
			level=60,
		}, {			
			"Go to inside Nethergarde Keep at "..cl(62,17),
			"	a. Talk to Bernie Heisten",
			"		i. Buy a Nethergarde Bitter",
			completion={{questgoal={"*","Nethergarde Bitter",1}}},
			mapzone="Blasted Lands",
			level=60,
			mapnote=17007950,
		}, {
			"Go south to "..cl(58,56),
			"	a. Talk to Watch Commander Netherwane",
			"		i. Accept "..cq("Through the Dark Portal"),
			completion={{questaccepted="Through the Dark Portal"}},
			mapzone="Blasted Lands",
			level=60,
			mapnote=55911420,
		}, {
			"Go into the big green portal to the Outlands",
			completion={{location={mapzone="Hellfire Peninsula"}}},
			mapzone="Blasted Lands",
			level=60,
		}, {
			"Go to "..cl(87,51),
			"	a. Talk to Commander Duron",
			"		i. Turn in "..cq("Through the Dark Portal"),
			"		i. Accept "..cq("Arrival in Outland"),
			completion={{questturnedin="Through the Dark Portal"},{questaccepted="Arrival in Outland"}},
			mapzone="Hellfire Peninsula",
			level=60,
			mapnote=50713800,
		}, {
			"Go south to "..cl(87,52),
			"	a. Talk to Amish Wildhammer",
			"		i. Turn in "..cq("Arrival in Outland"),
			"		ii. Accept "..cq("Journey to Honor Hold"),
			"		iii. Fly to Honor Hold",
			completion={{questturnedin="Arrival in Outland"},{questaccepted="Journey to Honor Hold"},{location={mapzone="Hellfire Peninsula",x=55.7,y=63.3, dist=5}}},
			mapzone="Hellfire Peninsula",
			level=60,
			mapnote=52413980,
		}, {
			"Go to "..cl(54,63),
			"	a. Talk to Marshal Isildor",
			"		i. Turn in "..cq("Journey to Honor Hold"),
			"		ii. Accept "..cq("Force Commander Danath"),
			completion={{questturnedin="Journey to Honor Hold"},{questaccepted="Force Commander Danath"}},
			mapzone="Hellfire Peninsula",
			level=60,
			mapnote=62811730,
		}, {
			"Make Honor Hold your home",
			completion={{home="Honor Hold"}},
			mapzone="Hellfire Peninsula",
			level=60,
		}, {
			"Go to "..cl(57,67),
			"	a. Talk to Force Commander Danath Trollbane",
			"		i. Turn in "..cq("Force Commander Danath"),
			"		ii. Accept "..cq("The Legion Reborn"),
			"		iii. Accept "..cq("Know your Enemy"),
			completion={{questturnedin="Force Commander Danath"},{questaccepted="The Legion Reborn"},{questaccepted="Know your Enemy"}},
			mapzone="Hellfire Peninsula",
			level=60,
			mapnote=66712330,
		}, {
			"Go northwest to "..cl(51,60),
			"	a. Talk to Dumphry",
			"		i. Accept "..cq("Waste Not, Want Not"),
			completion={{questaccepted="Waste Not, Want Not"}},
			mapzone="Hellfire Peninsula",
			level=60,
			mapnote=60011120,
		}, {
			"Also at "..cl(51,60),
			"	a. Talk to Lieutenant Amadi",
			"		i. Turn in "..cq("Know your Enemy"),
			"		ii. Accept "..cq("Fel Orc Scavengers"),
			completion={{questturnedin="Know your Enemy"},{questaccepted="Fel Orc Scavengers"}},
			mapzone="Hellfire Peninsula",
			level=60,
			mapnote=60211110,
		}, {
			"Go east to "..cl(62,61),
			"	a. Talk to Sergeant Altumus",
			"		i. Turn in "..cq("The Legion Reborn"),
			"		ii. Accept "..cq("The Path of Anguish"),
			completion={{questturnedin="The Legion Reborn"},{questaccepted="The Path of Anguish"}},
			mapzone="Hellfire Peninsula",
			level=60,
			mapnote=60812250,
		}, {
			"Go north to "..cl(60,52),
			"	a. Kill 20 Bonechewer Orcs",
			"	b. Get 8 Salvaged Metal",
			"	c. Get 8 Salvaged Wood",
			completion={{questgoal={"*","Bonechewer Orc slain",20}},{questgoal={"*","Salvaged Metal",8}},{questgoal={"*","Salvaged Wood",8}}},
			mapzone="Hellfire Peninsula",
			level=60,
			mapnote=52111250,
		}, {
			"Go east to "..cl(68,52),
			"	a. Be on the lookout for the giant Fel Reavers",
			"	b. Kill 1 Dreadcaller",
			"	c. Kill 4 Flamewaker Imps",
			"	d. Kill 6 Infernal Warbringers",
			completion={{questgoal={"*","Dreadcaller slain",1}},{questgoal={"*","Flamewaker Imp slain",4}},{questgoal={"*","Infernal Warbringer slain",6}}},
			mapzone="Hellfire Peninsula",
			level=60,
			mapnote=52111960,
		}, {
			"Go southwest to "..cl(62,61),
			"	a. Talk to Sergeant Altumus",
			"		i. Turn in "..cq("The Path of Anguish"),
			"		ii. Accept "..cq("Expedition Point"),
			completion={{questturnedin="The Path of Anguish"},{questaccepted="Expedition Point"}},
			mapzone="Hellfire Peninsula",
			level=60,
			mapnote=60812250,
		}, {
			"Go west to "..cl(51,60),
			"	a. Talk to Dumphry",
			"		i. Turn in "..cq("Waste Not, Want Not"),
			"		ii. Accept "..cq("Laying Waste to the Unwanted"),
			completion={{questturnedin="Waste Not, Want Not"},{questaccepted="Laying Waste to the Unwanted"}},
			mapzone="Hellfire Peninsula",
			level=60,
			mapnote=60011120,
		}, {	
			"Also at "..cl(51,60),
			"	a. Talk to Lieutenant Amadi",
			"		i. Turn in "..cq("Fel Orc Scavengers"),
			"		ii. Accept "..cq("Ill Omens"),
			completion={{questturnedin="Fel Orc Scavengers"},{questaccepted="Ill Omens"}},
			mapzone="Hellfire Peninsula",
			level=60,
			mapnote=60211110,
		}, {
			"Go east to "..cl(71,63),
			"	a. Talk to Forward Commander Kingston",
			"		i. Turn in "..cq("Expedition Point"),
			"		ii. Accept "..cq("Disrupt Their Reinforcements"),
			completion={{questturnedin="Expedition Point"},{questaccepted="Disrupt Their Reinforcements"}},
			mapzone="Hellfire Peninsula",
			level=60,
			mapnote=62813410,
		}, {
			"Go northeast to "..cl(73,59),
			"	a. Kill the demons here",
			"	b. Get 4 Demonic Rune Stones",
			"	c. Stand inside the portal and click it to destroy it",
			completion={{questgoal={"*","Disrupt Portal Kaalez",1}}},
			mapzone="Hellfire Peninsula",
			level=60,
			mapnote=59013170,
		}, {
			"Go northwest to "..cl(71,55),
			"	a. Kill the demons here",
			"	b. Get 4 Demonic Rune Stones",
			"	c. Stand inside the portal and click it to destroy it",
			completion={{questgoal={"*","Disrupt Portal Grimh",1}}},
			mapzone="Hellfire Peninsula",
			level=60,
			mapnote=55212660,
		}, {
			"Go south to "..cl(71,63),
			"	a. Talk to Forward Commander Kingston",
			"		i. Turn in "..cq("Disrupt Their Reinforcements"),
			"		ii. Accept "..cq("Mission: The Murketh and Shaadraz Gateways"),
			"	b. Talk to Wing Commander Dabir'ee",
			"		i. Take the flight",
			"		ii. Click the bomb in your bags, bomb Gateway Murketh",
			"		iii. Click the bomb in your bags, bomb Gateway Shaadraz",
			"	c. Talk to Forward Commander Kingston",
			"		i. Turn in "..cq("Mission: The Murketh and Shaadraz Gateways"),
			"		ii. Accept "..cq("Shatter Point"),
			"	d. Talk to Wing Commander Dabir'ee",
			"		i. Fly to Shatter Point",
			completion={{questturnedin="Disrupt Their Reinforcements"},{questaccepted="Mission: The Murketh and Shaadraz Gateways"},{questgoal={"*","Gateway Murketh Destroyed",1}},{questgoal={"*","Gateway Shaadraz Destroyed",1}},{questturnedin="Mission: The Murketh and Shaadraz Gateways"},{questaccepted="Shatter Point"},{location={mapzone="Hellfire Peninsula",x=78.5,y=35.1, dist=1}}},
			mapzone="Hellfire Peninsula",
			level=60,
			mapnote=62813410,
		}, {
			"When you land in Shatter Point",
			"	a. Talk to Runetog Wildhammer",
			"		i. Get the Shatter Point Flight Path",
			"		ii. Turn in "..cq("Shatter Point"),
			"		iii. Accept "..cq("Wing Commander Gryphongar"),
			completion={{flightpath="Shatter Point"},{questturnedin="Shatter Point"},{questaccepted="Wing Commander Gryphongar"}},
			mapzone="Hellfire Peninsula",
			level=60,
			mapnote=34911330,
		}, {
			"Go northeast to "..cl(79,34),
			"	a. Talk to Wing Commander Gryphongar",
			"		i. Turn in "..cq("Wing Commander Gryphongar"),
			"		ii. Accept "..cq("Mission: The Abyssal Shelf"),
			completion={{questturnedin="Wing Commander Gryphongar"},{questaccepted="Mission: The Abyssal Shelf"}},
			mapzone="Hellfire Peninsula",
			level=60,
			mapnote=33911320,
		}, {
			"Go southwest to "..cl(78,34),
			"	a. Talk to Gryphoneer Windbellow",
			"	b. Take a flight to the Abyssal Shelf",
			"	c. Use the bomb in your bags to bomb the mobs",
			"		i. Kill 20 Gan'arg Peons",
			"		ii. Kill 5 Mo'arg Overseers",
			"		iii. Destroy 5 Fel Cannons",
			"		iv. If you don't complete this in the first run, you can keep flying until it's done",
			completion={{questgoal={"*","Gan'arg Peon slain",20}},{questgoal={"*","Mo'arg Overseer slain",5}},{questgoal={"*","Fel Cannon Destroyed",5}}},
			mapzone="Hellfire Peninsula",
			level=60,
			mapnote=34511280,
		}, {
			"Go northeast to "..cl(79,34),
			"	a. Talk to Wing Commander Gryphongar",
			"		i. Turn in "..cq("Mission: Abyssal Shelf"),
			"		ii. Accept "..cq("Go to the Front"),
			completion={{questturnedin="Mission: Abyssal Shelf"},{questaccepted="Go to the Front"}},
			mapzone="Hellfire Peninsula",
			level=60,
			mapnote=33911320,
		}, {
			"Go southwest to "..cl(78,35),
			"	a. Talk Gryphoneer Windbellow",
			"		i. Fly to Honor Point",
			completion={{location={mapzone="Hellfire Peninsula",x=68.7,y=28.2, dist=1}}},
			mapzone="Hellfire Peninsula",
			level=60,
			mapnote=34511280,
		}, {
			"Go to "..cl(68,28),
			"	a. Talk to Field Marshal Brock",
			"		i. Turn in "..cq("Go to the Front"),
			completion={{questturnedin="Go to the Front"}},
			mapzone="Hellfire Peninsula",
			level=60,
			mapnote=28609690,
		}, {
			"Go to Honor Hold",
			completion={{location={mapzone="Hellfire Peninsula",x=55.7,y=63.3, dist=5}}},
			mapzone="Hellfire Peninsula",
			level=60,
		}, {
			"Go to "..cl(54,63),
			"	a. Talk to Father Malgor Devidicus",
			"		i. Accept "..cq("An Old Gift"),
			"	b. Talk to Sid Limbardi",
			"		i. Accept "..cq("The Longbeards"),
			completion={{questaccepted="An Old Gift"},{questaccepted="The Longbeards"}},
			mapzone="Hellfire Peninsula",
			level=60,
			mapnote=63411770,
		}, {
			"Go southeast to "..cl(57,67),
			"	a. Talk to Warp-Scryer Kryv",
			"		i. Accept "..cq("The Path of Glory"),
			completion={{questaccepted="The Path of Glory"}},
			mapzone="Hellfire Peninsula",
			level=60,
			mapnote=66512320,
		}, {
			"Go northwest to "..cl(51,60),
			"	a. Talk to Honor Guard Wesilow",
			"		i. Accept "..cq("Unyielding Souls"),
			completion={{questaccepted="Unyielding Souls"}},
			mapzone="Hellfire Peninsula",
			level=60,
			mapnote=60211110,
		}, {
			"Go southeast to "..cl(52,63),
			"	a. Talk to Foreman Biggums",
			"		i. Accept "..cq("A Job for an Intelligent Man"),
			"		ii. Accept "..cq("When This Mine's a-Rockin'"),
			completion={{questaccepted="A Job for an Intelligent Man"},{questaccepted="When This Mine's a-Rockin'"}},
			mapzone="Hellfire Peninsula",
			level=60,
			mapnote=62611460,
		}, {
			"Go inside the cave to "..cl(55,63),
			"	a. Kill 12 Gan'arg Sappers",
			completion={{questgoal={"*","Gan'arg Sapper slain",12}}},
			mapzone="Hellfire Peninsula",
			level=60,
			mapnote=62911780,
		}, {
			"Go outside the cave to "..cl(52,63),
			"	a. Talk to Foreman Biggums",
			"		i. Turn in "..cq("When This Mine's a-Rockin'"),
			"		ii. Accept "..cq("The Mastermind"),
			completion={{questturnedin="When This Mine's a-Rockin'"},{questaccepted="The Mastermind"}},
			mapzone="Hellfire Peninsula",
			level=60,
			mapnote=62611460,
		}, {
			"Go inside the cave to "..cl(56,62),
			"	a. Kill Z'kral",
			completion={{questgoal={"*","Z'kral slain",1}}},
			mapzone="Hellfire Peninsula",
			level=60,
			mapnote=61411770,
		}, {
			"Go outside the cave to "..cl(52,63),
			"	a. Talk to Foreman Biggums",
			"		i. Turn in "..cq("The Mastermind"),
			completion={{questturnedin="The Mastermind"}},
			mapzone="Hellfire Peninsula",
			level=60,
			mapnote=62611460,
		}, {
			"Go northeast to "..cl(66,49),
			"	a. They look like little brown ribcages and spines",
			"	b. Use your Daenei Holy Water on the Trampled Skeletons",
			"	c. Cleanse 8 Trampled Skeletons",
			completion={{questgoal={"*","Cleanse Trampled Skeleton",8}}},
			mapzone="Hellfire Peninsula",
			level=60,
			mapnote=48811490,
		}, {
			"Go west to "..cl(59,47),
			"	a. It's a big catapult",
			"	b. Use your Flaming Torch on the Eastern Thrower to burn it",
			completion={{questgoal={"*","Eastern Thrower Burned",1}}},
			mapzone="Hellfire Peninsula",
			level=60,
			mapnote=47010570,
		}, {
			"Go west to "..cl(56,47),
			"	a. It's a big catapult",
			"	b. Use your Flaming Torch on the Central Eastern Thrower to burn it",
			completion={{questgoal={"*","Central Eastern Thrower Burned",1}}},
			mapzone="Hellfire Peninsula",
			level=60,
			mapnote=46710260,
		}, {
			"Go west to "..cl(54,47),
			"	a. It's a big catapult",
			"	b. Use your Flaming Torch on the Central Western Thrower to burn it",
			completion={{questgoal={"*","Central Western Thrower Burned",1}}},
			mapzone="Hellfire Peninsula",
			level=60,
			mapnote=47210070,
		}, {
			"Go west to "..cl(53,47),
			"	a. It's a big catapult",
			"	b. Use your Flaming Torch on the Western Thrower to burn it",
			completion={{questgoal={"*","Western Thrower Burned",1}}},
			mapzone="Hellfire Peninsula",
			level=60,
			mapnote=47109990,
		}, {
			"Go southeast to "..cl(66,67),
			"	a. Kill Bleeding Hollow orcs",
			"	b. Get a Cursed Talisman",
			completion={{questgoal={"*","Cursed Talisman",1}}},
			mapzone="Hellfire Peninsula",
			level=60,
			mapnote=67213300,
		}, {
			"Go northeast to "..cl(71,63),
			"	a. Talk to Corporal Ironridge",
			"		i. Turn in "..cq("Ill Omens"),
			"		ii. Accept "..cq("Cursed Talismans"),
			completion={{questturnedin="Ill Omens"},{questaccepted="Cursed Talismans"}},
			mapzone="Hellfire Peninsula",
			level=60,
			mapnote=63413440,
		}, {
			"Go southwest to "..cl(58,79),
			"	a. Kill 12 Unyielding Footmen",
			"	b. Kill 10 Unyielding Sorcerers",
			"	c. Kill 5 Unyielding Knights",
			completion={{questgoal={"*","Unyielding Footman slain",12}},{questgoal={"*","Unyielding Sorcerer slain",10}},{questgoal={"*","Unyielding Knight slain",5}}},
			mapzone="Hellfire Peninsula",
			level=60,
			mapnote=79013700,
		}, {
			"Go southwest to "..cl(55,87),
			"	a. It's a small white book laying on the steps of the house",
			"	b. Click the small book",
			"	c. Get the Mysteries of the Light",
			completion={{questgoal={"*","Mysteries of the Light",1}}},
			mapzone="Hellfire Peninsula",
			level=60,
			mapnote=86814180,
		}, {
			"Go northwest to "..cl(49,75),
			"	a. Talk to 'Screaming' Screed Luckheed",
			"		i. Accept "..cq("In Case of Emergency..."),
			"	b. Talk to Legassi",
			"		i. Accept "..cq("Ravager Egg Roundup"),
			completion={{questaccepted="In Case of Emergency..."},{questaccepted="Ravager Egg Roundup"}},
			mapzone="Hellfire Peninsula",
			level=60,
			mapnote=74812400,
		}, {
			"Go northeast to "..cl(58,71),
			"	a. They look like scraps of metal all over the ground",
			"	b. Get 30 Zeppelin Debris",
			completion={{questgoal={"*","Zeppelin Debris",30}}},
			mapzone="Hellfire Peninsula",
			level=60,
			mapnote=71312940,
		}, {
			"Go southwest to "..cl(49,75),
			"	a. Talk to 'Screaming' Screed Luckheed",
			"		i. Turn in "..cq("In Case of Emergency..."),
			"		ii. Accept "..cq("Voidwalkers Gone Wild"),
			completion={{questturnedin="In Case of Emergency..."},{questaccepted="Voidwalkers Gone Wild"}},
			mapzone="Hellfire Peninsula",
			level=60,
			mapnote=74812400,
		}, {
			"Go northwest to "..cl(48,66),
			"	a. Get close to the jumping piles of rocks",
			"	b. Kill 15 Marauding Crust Bursters",
			"	c. Kill Marauding Crustbusters",
			"	d. Get an Eroded Leather Case",
			"	e. Click the Eroded Leather Case",
			"		i. Accept "..cq("Missing Missive"),
			completion={{questgoal={"*","Marauding Crust Burster slain",15}},{questaccepted="Missing Missive"}},
			mapzone="Hellfire Peninsula",
			level=60,
			mapnote=65811360,
		}, {
			"Grind to level 61",
			completion={{level=61}},
			mapzone="Hellfire Peninsula",
			level=60,
		}, {
			"Go northeast to "..cl(52,63),
			"	a. Talk to Foreman Biggums",
			"		i. Turn in "..cq("A Job for an Intelligent Man"),
			completion={{questturnedin="A Job for an Intelligent Man"}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=62611460,
		}, {
			"Go northwest to "..cl(52,60),
			"	a. Talk to Dumphry",
			"		i. Turn in "..cq("Laying Waste to the Unwanted"),
			completion={{questturnedin="Laying Waste to the Unwanted"}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=60011120,
		}, {
			"Go to "..cl(51,60),
			"	a. Talk to Honor Guard Wesilow",
			"		i. Turn in "..cq("Unyielding Souls"),
			"		ii. Accept "..cq("Looking to the Leadership"),
			completion={{questturnedin="Unyielding Souls"},{questaccepted="Looking to the Leadership"}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=60211110,
		}, {
			"Go southeast to "..cl(54,64),
			"	a. Talk to Father Malgor Devidicus",
			"		i. Turn in "..cq("An Old Gift"),
			completion={{questturnedin="An Old Gift"}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=63411770,
		}, {
			"Go to "..cl(57,67),
			"	a. Talk to Warp-Scryer Kryv",
			"		i. Turn in "..cq("The Path of Glory"),
			"		ii. Accept "..cq("The Temple of Telhamat"),
			completion={{questturnedin="The Path of Glory"},{questaccepted="The Temple of Telhamat"}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=66512320,
		}, {
			"Go northwest to the Temple of Telhamat",
			completion={{location={mapzone="Hellfire Peninsula",x=23.4,y=37.2, dist=3}}},
			mapzone="Hellfire Peninsula",
			level=61,
		}, {
			"Go to "..cl(23,40),
			"	a. Talk to Achorite Obadei",
			"		i. Accept "..cq("In Search of Sedai"),
			"	b. Talk to Ikan",
			"		i. Accept "..cq("Cruel Taskmasters"),
			completion={{questaccepted="In Search of Sedai"},{questaccepted="Cruel Taskmasters"}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=40306340,
		}, {
			"Also at "..cl(23,40),
			"	a. Talk to Scout Vanura",
			"		i. She wanders up the steps and back",
			"		ii. Accept "..cq("Deadly Predators"),
			completion={{questaccepted="Deadly Predators"}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=39706310,
		}, {
			"Go to "..cl(23,37),
			"	a. Talk to Amaan the Wise",
			"		i. Turn in "..cq("The Temple of Telhamat"),
			"		ii. Accept "..cq("The Pools of Aggonar"),
			"	b. Talk to Elsaana",
			"		i. Accept "..cq("An Ambitious Plan"),
			completion={{questturnedin="The Temple of Telhamat"},{questaccepted="The Pools of Aggonar"},{questaccepted="An Ambitious Plan"}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=36505990,
		}, {
			"Make the Temple of Telhamat your home",
			completion={{home="the Temple of Telhamat"}},
			mapzone="Hellfire Peninsula",
			level=61,
		}, {
			"Go to "..cl(25,37),
			"	a. Talk to Kuma",
			"		i. Get the Temple of Telhamat Flight Path",
			completion={{flightpath="Temple of Telhamat"}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=37206240,
		}, {
			"Go east to "..cl(27,37),
			"	a. Click Sedai's Corpse",
			"		i. Turn in "..cq("In Search of Sedai"),
			"		ii. Accept "..cq("Return to Obadei"),
			completion={{questturnedin="In Search of Sedai"},{questaccepted="Return to Obadei"}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=37406430,
		}, {
			"Go west to the Temple of Telhamat",
			completion={{location={mapzone="Hellfire Peninsula",x=23.4,y=37.2, dist=3}}},
			mapzone="Hellfire Peninsula",
			level=61,
		}, {
			"Go to "..cl(23,40),
			"	a. Talk to Anchorite Obadei",
			"		i. Turn in "..cq("Return to Obadei"),
			"	b. Talk to Makuru",
			"		i. Accept "..cq("Makuru's Vengeance"),
			completion={{questturnedin="Return to Obadei"},{questaccepted="Makuru's Vengeance"}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=40306340,
		}, {
			"Go northeast to "..cl(35,35),
			"	a. Kill Mag'har orcs",
			"	b. Get 10 Mag'har Ancestral Beads",
			completion={{questgoal={"*","Mag'har Ancestral Beads",10}}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=34706930,
		}, {
			"Go east to "..cl(40,36),
			"	a. Kill 6 Terrorfiends",
			"	b. Kill 6 Blistering Rots",
			completion={{questgoal={"*","Terrorfiend slain",6}},{questgoal={"*","Blistering Rot slain",6}}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=36107550,
		}, {
			"Go west to the Temple of Telhamat",
			completion={{location={mapzone="Hellfire Peninsula",x=23.4,y=37.2, dist=3}}},
			mapzone="Hellfire Peninsula",
			level=61,
		}, {
			"Go to "..cl(23,40),
			"	a. Talk to Makuru",
			"		i. Turn in "..cq("Makuru's Vengeance"),
			"	b. Talk to Anchorite Obadei",
			"		i. Accept "..cq("Atonement"),
			completion={{questturnedin="Makuru's Vengeance"},{questaccepted="Atonement"}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=40306340,
		}, {
			"Go to "..cl(23,37),
			"	a. Talk to Amaan the Wise",
			"		i. Turn in "..cq("Atonement"),
			"		ii. Turn in "..cq("The Pools of Aggonar"),
			"		iii. Accept "..cq("Sha'naar Relics"),
			"		iv. Accept "..cq("Cleansing the Waters"),
			"		v. Accept "..cq("Helping the Cenarion Post"),
			completion={{questturnedin="Atonement"},{questturnedin="The Pools of Aggonar"},{questaccepted="Sha'naar Relics"},{questaccepted="Cleansing the Waters"},{questaccepted="Helping the Cenarion Post"}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=36505990,
		}, {
			"Go northeast to "..cl(40,31),
			"	a. Empty your Cleansing Vial in this spot",
			"	b. Get close to the ribcage of the skeleton and next to the poisoned water",
			"	c. Kill Aggonis when he spawns",
			completion={{questgoal={"*","Aggonar's Presence Cleansed",1}}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=30907120,
		}, {
			"Go southwest to the Temple of Telhamat",
			completion={{location={mapzone="Hellfire Peninsula",x=23.4,y=37.2, dist=3}}},
			mapzone="Hellfire Peninsula",
			level=61,
		}, {
			"Go to "..cl(23,37),
			"	a. Talk to Amaan the Wise",
			"		i. Turn in "..cq("Cleansing the Waters"),
			completion={{questturnedin="Cleansing the Waters"}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=36505990,
		}, {
			"Go southwest to "..cl(16,52),
			"	a. Talk to Thiah Redmane",
			"		i. Turn in "..cq("Missing Missive"),
			"		ii. Turn in "..cq("Helping the Cenarion Post"),
			"		iii. Accept "..cq("Demonic Contamination"),
			completion={{questturnedin="Missing Missive"},{questturnedin="Helping the Cenarion Post"},{questaccepted="Demonic Contamination"}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=52006770,
		}, {
			"Go east to "..cl(25,54),
			"	a. Kill Hulking Helboars",
			"	b. Get 6 Helboar Blood Samples",
			completion={{questgoal={"*","Helboar Blood Sample",6}}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=54307920,
		}, {
			"Go west to "..cl(16,52),
			"	a. Talk to Thiah Redmane",
			"		i. Turn in "..cq("Demonic Contamination"),
			"		ii. Accept "..cq("Testing the Antidote"),
			completion={{questturnedin="Demonic Contamination"},{questaccepted="Testing the Antidote"}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=52006770,
		}, {
			"Go east to "..cl(25,54),
			"	a. Use the Cenarion Antidote on a Hulking Helboar",
			completion={{questgoal={"*","Administer Antidote",1}}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=52006770,
		}, {
			"Go west to "..cl(16,52),
			"	a. Talk to Thiah Redmane",
			"		i. Turn in "..cq("Testing the Antidote"),
			completion={{questturnedin="Testing the Antidote"}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=52006770,
		}, {
			"Go south to "..cl(15,56),
			"	a. Kill 4 Illidari Taskmasters",
			"		i. If you kill the taskmaster first, his friends leave you alone",
			"	b. The Sha'naar Relics look like little blue vases on the ground",
			"	c. Get 10 Sha'naar Relics",
			completion={{questgoal={"*","Illidari Taskmaster slain",4}},{questgoal={"*","Sha'naar Relic",10}}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=55707080,
		}, {
			"Go south to "..cl(16,59),
			"	a. Talk to Akoru the Firecaller",
			"		i. Accept "..cq("Naladu"),
			completion={{questaccepted="Naladu"}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=58807440,
		}, {
			"Go southeast to "..cl(16,65),
			"	a. Talk to Naladu",
			"		i. Turn in "..cq("Naladu"),
			"		ii. Accept "..cq("A Traitor Among Us"),
			completion={{questturnedin="Naladu"},{questaccepted="A Traitor Among Us"}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=65108140,
		}, {
			"Go northwest to "..cl(14,64),
			"	a. Click the metal coffer in the big red hut",
			"	b. Get the Sha'naar Key",
			completion={{questgoal={"*","Sha'naar Key",1}}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=63507780,
		}, {
			"Go southeast to "..cl(16,65),
			"	a. Talk to Naladu",
			"		i. Turn in "..cq("A Traitor Among Us"),
			"		ii. Accept "..cq("The Dreghood Elders"),
			completion={{questturnedin="A Traitor Among Us"},{questaccepted="The Dreghood Elders"}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=65108140,
		}, {
			"Go north to "..cl(16,59),
			"	a. Free Akoru the Firecaller",
			completion={{questgoal={"*","Akoru Freed",1}}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=58807440,
		}, {
			"Go west to "..cl(13,58),
			"	a. Free Aylaan the Waterwaker",
			completion={{questgoal={"*","Aylaan Freed",1}}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=58407140,
		}, {
			"Go south to "..cl(13,61),
			"	a. Free Morod the Windstirrer",
			completion={{questgoal={"*","Morod Freed",1}}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=61007410,
		}, {
			"Go southwest to "..cl(16,65),
			"	a. Talk to Naladu",
			"		i. Turn in "..cq("The Dreghood Elders"),
			"		ii. Accept "..cq("Arzeth's Demise"),
			completion={{questturnedin="The Dreghood Elders"},{questaccepted="Arzeth's Demise"}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=65108140,
		}, {
			"Go northwest to "..cl(14,62),
			"	a. Wait until Arzeth the Merciless is up top of the stairs by himself",
			"	b. Use the Staff of the Dreghood Elders on Arzeth the Merciless",
			"	c. Kill Arzeth the Powerless",
			completion={{questgoal={"*","Arzeth the Powerless slain",1}}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=62307670,
		}, {
			"Go southeast to "..cl(16,65),
			"	a. Talk to Naladu",
			"		i. Turn in "..cq("Arzeth's Demise"),
			completion={{questturnedin="Arzeth's Demise"}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=65108140,
		}, {
			"Go southeast to "..cl(24,72),
			"	a. Talk to Gremni Longbeard",
			"		i. Turn in "..cq("The Longbeards"),
			"		ii. Accept "..cq("The Arakkoa Threat"),
			"		iii. Accept "..cq("Rampaging Ravagers"),
			"	b. Talk to Mirren Longbeard",
			"		i. Accept "..cq("Gaining Mirren's Trust"),
			"		ii. Turn in "..cq("Gaining Mirren's Trust"),
			"		iii. Accept "..cq("The Finest Down"),
			completion={{questturnedin="The Longbeards"},{questaccepted="The Arakkoa Threat"},{questaccepted="Rampaging Ravagers"},{questaccepted="Gaining Mirren's Trust"},{questturnedin="Gaining Mirren's Trust"},{questaccepted="The Finest Down"}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=72109610,
		}, {
			"Go northeast to "..cl(26,70),
			"	a. Kill 4 Haal'eshi Windwalkers",
			"	b. Kill 6 Haal'eshi Talonguards",
			completion={{questgoal={"*","Haal'eshi Windwalker slain",4}},{questgoal={"*","Haal'eshi Talonguard slain",6}}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=70309590,
		}, {
			"Go south to "..cl(25,72),
			"	a. Kill Kaliri birds",
			"	b. Click the Kaliri nests",
			"		i. The nests are small and round with 3 glowing pinkish eggs in them",
			"	c. Get 8 Kaliri Feathers",
			completion={{questgoal={"*","Kaliri Feather",8}}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=71609700,
		}, {
			"Go south to "..cl(26,77),
			"	a. The path up to Avruu starts here",
			"	b. Go up the path, over the bridge, then to the left",
			completion={{location={mapzone="Hellfire Peninsula",x=26.1,y=77.1, dist=0.5}}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=77110330,
		}, {
			"Go to "..cl(26,75),
			"	a. Kill Avruu",
			"	b. Get Avruu's Orb",
			"	c. Click Avruu's Orb",
			"		i. Accept "..cq("Avruu's Orb"),
			completion={{questaccepted="Avruu's Orb"}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=75110080,
		}, {
			"Go southeast to "..cl(29,81),
			"	a. It looks like an orb sitting in a claw thing",
			"	b. Click the Haal'eshi Altar",
			"	c. Fight Aeranas until he's almost dead",
			"	d. Talk to Aeranas",
			"		i. Turn in "..cq("Avruu's Orb"),
			completion={{questturnedin="Avruu's Orb"}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=81511050,
		}, {
			"Go northwest to "..cl(24,72),
			"	a. Talk to Gremni Longbeard",
			"		i. Turn in "..cq("The Arakkoa Threat"),
			"	b. Talk to Mirren Longbeard",
			"		i. Turn in "..cq("The Finest Down"),
			completion={{questturnedin="The Arakkoa Threat"},{questturnedin="The Finest Down"}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=72109610,
		}, {
			"Go north to "..cl(24,69),
			"	a. Kill Quillfang Skitterers",
			"	b. Get 12 Ravager Eggs",
			"	c. Kill 10 Quillfang Ravagers",
			completion={{questgoal={"*","Ravager Egg",12}},{questgoal={"*","Quillfang Ravager slain",10}}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=69209290,
		}, {
			"Go south to "..cl(24,72),
			"	a. Talk to Gremni Longbeard",
			"		i. Turn in "..cq("Rampaging Ravagers"),
			completion={{questturnedin="Rampaging Ravagers"}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=72109610,
		}, {
			"Go northeast to "..cl(27,69),
			"	a. Kill 8 Stonescythe Whelps",
			completion={{questgoal={"*","Stonescythe Whelp slain",8}}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=69509640,
		}, {
			"Go northeast to "..cl(34,62),
			"	a. Kill 2 Stonescythe Alphas",
			completion={{questgoal={"*","Stonescythe Alpha slain",2}}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=62109580,
		}, {
			"Go southeast to "..cl(37,68),
			"	a. Kill 2 Stonescythe Alphas",
			completion={{questgoal={"*","Stonescythe Alpha slain",2}}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=68010460,
		}, {
			"Go southeast to "..cl(49,75),
			"	a. Talk to Legassi",
			"		i. Turn in "..cq("Ravager Egg Roundup"),
			"		ii. Accept "..cq("Helboar, the Other White Meat"),
			completion={{questturnedin="Ravager Egg Roundup"},{questaccepted="Helboar, the Other White Meat"}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=74812400,
		}, {
			"Go east to "..cl(50,75),
			"	a. Kill Helboars",
			"	b. Get Tainted Helboar Meat",
			"	c. Use your Purification Mixture on the Tainted Helboar Meat",
			"	d. Get 8 Purified Helboar Meat",
			"		i. The meat won't become purified every time, it can become Toxic as well",
			completion={{questgoal={"*","Purified Helboar Meat",8}}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=74812500,
		}, {
			"Go west to "..cl(49,75),
			"	a. Talk to Legassi",
			"		i. Turn in "..cq("Helboar, the Other White Meat"),
			"		ii. Accept "..cq("Smooth as Butter"),
			completion={{questturnedin="Helboar, the Other White Meat"},{questaccepted="Smooth as Butter"}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=74812400,
		}, {
			"Go northeast to "..cl(62,67),
			"	a. Kill Bonestripper Buzzards",
			"	b. Get 12 Plump Buzzard Wings",
			completion={{questgoal={"*","Plump Buzzard Wing",12}}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=67312990,
		}, {
			"Go southwest to "..cl(49,75),
			"	a. Talk to Legassi",
			"		i. Turn in "..cq("Smooth as Butter"),
			completion={{questturnedin="Smooth as Butter"}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=74812400,
		}, {
			"Go south to "..cl(49,82),
			"	a. Kill voidwalkers",
			"	b. Get 10 Condensed Voidwalker Essences",
			"	c. Use your Sanctified Crystal on an Uncontrolled Voidwalker when it's almost dead",
			"	d. Click the red floating crystal over its corpse",
			"	e. Get a Glowing Sanctified Crystal",
			completion={{questgoal={"*","Condensed Voidwalker Essence",10}},{questgoal={"*","Glowing Sanctified Crystal",1}}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=81813130,
		}, {
			"Go east to "..cl(54,81),
			"	a. Kill Arch Mage Xintor",
			completion={{questgoal={"*","Arch Mage Xintor slain",1}}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=81113470,
		}, {
			"Go southeast to "..cl(55,84),
			"	a. Kill Lieutenant Commander Thalvos",
			completion={{questgoal={"*","Lieutenant Commander Thalvos slain",1}}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=83713840,
		}, {
			"Go northwest to "..cl(49,75),
			"	a. Talk to 'Screaming' Screed Luckheed",
			"		i. Turn in "..cq("Voidwalkers Gone Wild"),
			completion={{questturnedin="Voidwalkers Gone Wild"}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=74812400,
		}, {
			"Hearth to the Temple of Telhamat",
			completion={{location={mapzone="Hellfire Peninsula",x=23.4,y=37.2, dist=3}}},
			mapzone="Hellfire Peninsula",
			level=61,
		}, {
			"Go to "..cl(23,37),
			"	a. Talk to Amaan the Wise",
			"		i. Turn in "..cq("Sha'naar Relics"),
			"		ii. Accept "..cq("The Seer's Relic"),
			"	b. Talk to Elsaana",
			"		i. Turn in "..cq("An Ambitious Plan"),
			completion={{questturnedin="Sha'naar Relics"},{questaccepted="The Seer's Relic"},{questturnedin="An Ambitious Plan"}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=36505990,
		}, {
			"Go to "..cl(23,40),
			"	a. Talk to Scout Vanura",
			"		i. Turn in "..cq("Deadly Predators"),
			completion={{questturnedin="Deadly Predators"}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=39706310,
		}, {
			"Also at "..cl(23,40),
			"	a. Talk to Ikan",
			"		i. Turn in "..cq("Cruel Taskmasters"),
			completion={{questturnedin="Cruel Taskmasters"}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=40306340,
		}, {
			"Go northeast to "..cl(27,37),
			"	a. Use the Seer's Relic on Sedai's Corpse",
			completion={{questgoal={"*","Vision Granted",1}}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=37406430,
		}, {
			"Go west to "..cl(23,37),
			"	a. Talk to Amaan the Wise",
			"		i. Turn in "..cq("The Seer's Relic"),
			completion={{questturnedin="The Seer's Relic"}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=36505990,
		}, {
			"Fly to Honor Hold",
			completion={{location={mapzone="Hellfire Peninsula",x=55.7,y=63.3, dist=5}}},
			mapzone="Hellfire Peninsula",
			level=61,
		}, {
			"Go to "..cl(51,60),
			"	a. Talk to Honor Guard Wesilow",
			"		i. Turn in "..cq("Looking to the Leadership"),
			completion={{questturnedin="Looking to the Leadership"}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=60211110,
		}, {
			"Go southeast to "..cl(64,72),
			"	a. Kill Bleeding Hollow Orcs",
			"	b. Get 12 Cursed Talismans",
			completion={{questgoal={"*","Cursed Talisman",12}}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=71813600,
		}, {
			"Go northeast to "..cl(71,63),
			"	a. Talk to Corporal Ironridge",
			"		i. Turn in "..cq("Cursed Talismans"),
			"		ii. Accept "..cq("Warlord of the Bleeding Hollow"),
			completion={{questturnedin="Cursed Talismans"},{questaccepted="Warlord of the Bleeding Hollow"}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=63413440,
		}, {
			"Also at "..cl(71,63),
			"	a. Talk to Wing Commander Dabir'ee",
			"		i. Accept "..cq("Zeth'Gor Must Burn!"),
			completion={{questaccepted="Zeth'Gor Must Burn!"}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=62813410,
		}, {
			"Go south to "..cl(70,69),
			"	a. Use your Smoke Beacon under the tower",
			"	b. Mark the Forge Tower",
			completion={{questgoal={"*","Forge Tower Marked",1}}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=69113920,
		}, {
			"Go south to "..cl(71,71),
			"	a. Use your Smoke Beacon under the tower",
			"	b. Mark the Foothill Tower",
			completion={{questgoal={"*","Foothill Tower Marked",1}}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=71314220,
		}, {
			"Go south to "..cl(70,77),
			"	a. Kill Warlord Morkh",
			"	b. Get Morkh's Shattered Armor",
			completion={{questgoal={"*","Morkh's Shattered Armor",1}}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=76914700,
		}, {
			"Go west to "..cl(66,77),
			"	a. Use your Smoke Beacon under the tower",
			"	b. Mark the Southern Tower",
			completion={{questgoal={"*","Southern Tower Marked",1}}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=76614300,
		}, {
			"Go northeast to "..cl(68,67),
			"	a. Use your Smoke Beacon under the tower",
			"	b. Mark the Northern Tower",
			completion={{questgoal={"*","Northern Tower Marked",1}}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=67013490,
		}, {
			"Go northeast to "..cl(71,63),
			"	a. Talk to Corporal Ironridge",
			"		i. Turn in "..cq("Warlord of the Bleeding Hollow"),
			"		ii. Accept "..cq("Return to Honor Hold"),
			completion={{questturnedin="Warlord of the Bleeding Hollow"},{questaccepted="Return to Honor Hold"}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=63413440,
		}, {
			"Also at "..cl(71,63),
			"	a. Talk to Wing Commander Dabir'ee",
			"		i. Turn in "..cq("Zeth'Gor Must Burn!"),
			completion={{questturnedin="Zeth'Gor Must Burn!"}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=62813410,
		}, {
			"Go west to Honor Hold",
			completion={{location={mapzone="Hellfire Peninsula",x=55.7,y=63.3, dist=5}}},
			mapzone="Hellfire Peninsula",
			level=61,
		}, {
			"Go to "..cl(54,64),
			"	a. Talk to Assistant Klatu",
			"		i. Turn in "..cq("Return to Honor Hold"),
			"		ii. Accept "..cq("Fel Spirits"),
			completion={{questturnedin="Return to Honor Hold"},{questaccepted="Fel Spirits"}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=63611790,
		}, {
			"Go southwest to "..cl(45,75),
			"	a. Use the Anchorite Relic in your bags",
			"	b. Pull orcs to the relic",
			"	c. Kill the orcs and a Fel Spirit will spawn",
			"	d. Kill the Fel Spirit",
			"	e. Kill 10 Fel Spirits",
			completion={{questgoal={"*","Jules Avenged",10}}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=75012000,
		}, {
			"Go northeast to Honor Hold",
			completion={{location={mapzone="Hellfire Peninsula",x=55.7,y=63.3, dist=5}}},
			mapzone="Hellfire Peninsula",
			level=61,
		}, {
			"Go to "..cl(54,64),
			"	a. Talk to Assistant Klatu",
			"		i. Turn in "..cq("Fel Spirits"),
			"		ii. Accept "..cq("The Exorcism of Colonel Jules"),
			completion={{questturnedin="Fel Spirits"},{questaccepted="The Exorcism of Colonel Jules"}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=63611790,
		}, {
			"Go to the room next door",
			"	a. Talk to Anchorite Barada",
			"		i. Click "..cq("I am ready..."),
			"		ii. Target the purple skulls and oozes",
			"		iii. Use the Prayer Beads when enemies are in the room",
			"		iv. After the exorcism is done, Talk to Colonel Jules on the bed",
			completion={{questgoal={"*","Colonel Jules Saved",1}}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=63611750,
		}, {
			"Go to "..cl(54,64),
			"	a. Talk to Assistant Klatu",
			"		i. Turn in "..cq("The Exorcism of Colonel Jules"),
			"		ii. Accept "..cq("Trollbane is Looking for You"),
			completion={{questturnedin="The Exorcism of Colonel Jules"},{questaccepted="Trollbane is Looking for You"}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=63611790,
		}, {
			"Go to "..cl(57,67),
			"	a. Talk to Force Commander Trollbane",
			"		i. Turn in "..cq("Trollbane is Looking for You"),
			completion={{questturnedin="Trollbane is Looking for You"}},
			mapzone="Hellfire Peninsula",
			level=61,
			mapnote=66712330,
		}, {
			"Grind to level 62",
			completion={{level=62}},
			mapzone="Hellfire Peninsula",
			level=61,
		}
	  },
	},
	{ sectiontitle = "Levels (62-64)",
	  steps = {
		{
			"Fly to the Temple of Telhamat",
			completion={{location={mapzone="Hellfire Peninsula",x=23.4,y=37.2, dist=3}}},
			mapzone="Hellfire Peninsula",
			level=62,
		}, {
			"Go southwest to "..cl(16,52),
			"	a. Talk to Amythiel Mistwalker",
			"		i. Accept "..cq("The Cenarion Expedition"),
			"	b. Talk to Mahuram Stouthoof",
			"		i. Accept "..cq("Keep Thornfang Hill Clear!"),
			completion={{questaccepted="The Cenarion Expedition"},{questaccepted="Keep Thornfang Hill Clear!"}},
			mapzone="Hellfire Peninsula",
			level=62,
			mapnote=52006770,
		}, {
			"Go northwest to "..cl(12,50),
			"	a. Kill 8 Thornfang Ravagers",
			"	b. Kill 8 Thornfang Venomspitters",
			completion={{questgoal={"*","Thornfang Ravager slain",8}},{questgoal={"*","Thornfang Venomspitter slain",8}}},
			mapzone="Hellfire Peninsula",
			level=62,
			mapnote=49906220,
		}, {
			"Go southeast to "..cl(16,52),
			"	a. Talk to Mahuram Stouthoof",
			"		i. Turn in "..cq("Keep Thornfang Hill Clear!"),
			completion={{questturnedin="Keep Thornfang Hill Clear!"}},
			mapzone="Hellfire Peninsula",
			level=62,
			mapnote=52006770,
		}, {
			"Go northwest to Zangarmarsh",
			completion={{location={mapzone="Zangarmarsh"}}},
			mapzone="Hellfire Peninsula",
			level=62,
		}, {
			"Go to "..cl(80,64),
			"	a. Talk to Lauranna Thar'well",
			"		i. Accept "..cq("Plants of Zangarmarsh"),
			"	b. Talk to Ikeyan",
			"		i. Accept "..cq("The Umbrafen Tribe"),
			completion={{questaccepted="Plants of Zangarmarsh"},{questaccepted="The Umbrafen Tribe"}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=64214460,
		}, {
			"Go to "..cl(79,65),
			"	a. Talk to Warden Hamoot",
			"		i. Accept "..cq("A Warm Welcome"),
			completion={{questaccepted="A Warm Welcome"}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=65314440,
		}, {
			"Go to "..cl(79,63),
			"	a. Talk to Lethyn Moonfire",
			"		i. Accept "..cq("The Dying Balance"),
			completion={{questaccepted="The Dying Balance"}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=63114160,
		}, {
			"Also at "..cl(79,63),
			"	a. Talk to Ysiel Windsinger",
			"		i. Turn in "..cq("The Cenarion Expedition"),
			"		ii. Accept "..cq("Disturbance at Umbrafen Lake"),
			completion={{questturnedin="The Cenarion Expedition"},{questaccepted="Disturbance at Umbrafen Lake"}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=62014040,
		}, {
			"Go south to "..cl(80,73),
			"	a. Kill all mobs in this area",
			"	b. Get 10 Unidentified Plant Parts",
			completion={{questgoal={"*","Unidentified Plant Parts",10}}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=73315340,
		}, {
			"Go northeast to "..cl(81,72),
			"	a. Kill Boglash",
			completion={{questgoal={"*","Boglash slain",1}}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=72215320,
		}, {
			"Go east to "..cl(83,72),
			"	a. Kill Boglash and Fen Striders",
			"	b. Get 10 Fertile Spores",
			completion={{item={"Fertile Spores",10}}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=72315490,
		}, {
			"Go northwest to "..cl(80,64),
			"	a. Talk to Lauranna Thar'well",
			"		i. Turn in "..cq("Plants of Zangarmarsh"),
			completion={{questturnedin="Plants of Zangarmarsh"}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=64214460,
		}, {
			"Go to "..cl(79,63),
			"	a. Talk to Lethyn Moonfire",
			"		i. Turn in "..cq("The Dying Balance"),
			completion={{questturnedin="The Dying Balance"}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=63114160,
		}, {
			"Go southeast to "..cl(85,84),
			"	a. Kill 6 Umbrafen Oracles",
			"	b. Kill 8 Umbrafen Seers",
			"	c. Kill 6 Umbrafen Witchdoctors",
			completion={{questgoal={"*","Umbrafen Oracle slain",6}},{questgoal={"*","Umbrafen Seer slain",8}},{questgoal={"*","Umbrafen Witchdoctor slain",6}}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=84416920,
		}, {
			"Go south "..cl(85,91),
			"	a. Kill Kataru",
			completion={{questgoal={"*","Kataru slain",1}}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=90917620,
		}, {
			"Go northwest to "..cl(83,85),
			"	a. Talk to Kayra Longmane",
			"		i. Accept "..cq("Escape from Umbrafen"),
			"		ii. Escort Kayra Longmane",
			completion={{questaccepted="Escape from Umbrafen"},{questgoal={"*","Escort Kayra Longmane to safety",1}}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=85516890,
		}, {
			"Go to "..cl(80,64),
			"	a. Talk to Ikeyen",
			"		i. Turn in "..cq("The Umbrafen Tribe"),
			"		ii. Accept "..cq("A Damp, Dark Place"),
			"	b. Talk to Lauranna Thar'well",
			"		i. Accept "..cq("Saving the Sporeloks"),
			completion={{questturnedin="The Umbrafen Tribe"},{questaccepted="A Damp, Dark Place"},{questaccepted="Saving the Sporeloks"}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=64214460,
		}, {
			"Go to "..cl(80,65),
			"	a. Talk to Windcaller Blackhoof",
			"		i. Accept "..cq("Safeguarding the Watchers"),
			completion={{questaccepted="Safeguarding the Watchers"}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=64714510,
		}, {
			"Go to "..cl(78,62),
			"	a. Talk to Ysiel Windsinger",
			"		i. Turn in "..cq("Escape from Umbrafen"),
			completion={{questturnedin="Escape from Umbrafen"}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=62014040,
		}, {
			"Go southwest to "..cl(76,90),
			"	a. Kill 10 Marsh Lurkers",
			"	b. Kill 10 Marsh Dredgers",
			completion={{questgoal={"*","Marsh Lurker slain",10}},{questgoal={"*","Marsh Dredger slain",10}}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=90216590,
		}, {
			"Go southwest inside the cave to "..cl(70,98),
			"	a. Get Ikeyen's Belongings",
			completion={{questgoal={"*","Ikeyen's Belongings",1}}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=97916840,
		}, {
			"Go northeast inside the cave to "..cl(73,94),
			"	a. Kill Lord Klaq",
			completion={{questgoal={"*","Lord Klaq slain",1}}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=94016650,
		}, {
			"Go northwest to "..cl(71,82),
			"	a. Stand here to Investigate Umbrafen Lake",
			"	b. Kill nagas",
			"	c. Get 30 Naga Claws",
			completion={{questgoal={"*","Umbrafen Lake Investigated",1}},{questgoal={"*","Naga Claws",30}}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=82115300,
		}, {
			"Go northeast to Cenarion Refuge",
			completion={{location={mapzone="Zangarmarsh",x=79.7,y=64.6, dist=2}}},
			mapzone="Zangarmarsh",
			level=62,
		}, {
			"Go to "..cl(80,65),
			"	a. Talk to Windcaller Blackhoof",
			"		i. Turn in "..cq("Safeguarding the Watchers"),
			completion={{questturnedin="Safeguarding the Watchers"}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=64714510,
		}, {
			"Go to "..cl(80,64),
			"	a. Talk to Ikeyen",
			"		i. Turn in "..cq("A Damp, Dark Place"),
			"	b. Talk to Lauranna Thar'well",
			"		i. Turn in "..cq("Saving the Sporeloks"),
			"		ii. Turn in any stacks of 10 Unidentified Plant Parts you have",
			"		iii. If you found an Uncatalogued Species, turn that in too",
			completion={{questturnedin="A Damp, Dark Place"},{questturnedin="Saving the Sporeloks"}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=64214460,
		}, {
			"Go to "..cl(80,65),
			"	a. Talk to Windcaller Blackhoof",
			"		i. Accept "..cq("Blessings of the Ancients"),
			completion={{questaccepted="Blessings of the Ancients"}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=64714510,
		}, {
			"Go to "..cl(79,65),
			"	a. Talk to Warden Hamoot",
			"		i. Turn in "..cq("A Warm Welcome"),
			completion={{questturnedin="A Warm Welcome"}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=65314440,
		}, {
			"Go to "..cl(79,63),
			"	a. Talk to Lethyn Moonfire",
			"		i. Accept "..cq("Watcher Leesa'oh"),
			"		ii. Accept "..cq("What's Wrong at Cenarion Thicket?"),
			completion={{questaccepted="Watcher Leesa'oh"},{questaccepted="What's Wrong at Cenarion Thicket?"}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=63114160,
		}, {
			"Go to "..cl(78,62),
			"	a. Talk to Ysiel Windsinger",
			"		i. Turn in "..cq("Disturbance at Umbrafen Lake"),
			"		ii. Accept "..cq("As the Crow Flies"),
			"		iii. Watch yourself fly as a crow",
			"		iv. Turn in "..cq("As the Crow Flies"),
			"		v. Accept "..cq("Balance Must Be Preserved"),
			completion={{questturnedin="Disturbance at Umbrafen Lake"},{questaccepted="As the Crow Flies"},{questturnedin="As the Crow Flies"},{questaccepted="Balance Must Be Preserved"}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=62014040,
		}, {
			"Go to "..cl(78,64),
			"	a. Talk to Keleth",
			"		i. Get the Mark of War",
			completion={{questgoal={"*","Mark of War",1}}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=63814190,
		}, {
			"Go to "..cl(81,64),
			"	a. Talk to Aheyen",
			"		i. Get the Mark of Lore",
			completion={{questgoal={"*","Mark of Lore",1}}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=63914500,
		}, {
			"Go to "..cl(80,65),
			"	a. Talk to Windcaller Blackhoof",
			"		i. Turn in "..cq("Blessings of the Ancients"),
			completion={{questturnedin="Blessings of the Ancients"}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=64714510,
		}, {
			"Go southwest to "..cl(71,80),
			"	a. Use your Ironvine Seeds on the Umbrafen Lake Pump Controls",
			"	b. Disable the Umbrafen Lake Pump Controls",
			completion={{questgoal={"*","Umbrafen Lake Controls Disabled",1}}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=80315090,
		}, {
			"Go northwest to "..cl(63,64),
			"	a. Use your Ironvine Seeds on the Lagoon Pump Controls",
			"	b. Disable the Lagoon Pump Controls",
			completion={{questgoal={"*","Lagoon Controls Disabled",1}}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=64112720,
		}, {
			"Go northeast to Telredor",
			completion={{location={mapzone="Zangarmarsh",x=68.3,y=49.2, dist=2}}},
			mapzone="Zangarmarsh",
			level=62,
		}, {
			"Go to "..cl(68,50),
			"	a. Talk to Vindicator Idaar",
			"		i. Accept "..cq("The Fate of Tuurem"),
			"		ii. Accept "..cq("The Dead Mire"),
			completion={{questaccepted="The Fate of Tuurem"},{questaccepted="The Dead Mire"}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=50111840,
		}, {
			"Go to "..cl(68,49),
			"	a. Talk to Anchorite Ahuurn",
			"		i. Accept "..cq("The Orebor Harborage"),
			"		ii. Accept "..cq("The Boha'mu Ruins"),
			completion={{questaccepted="The Orebor Harborage"},{questaccepted="The Boha'mu Ruins"}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=49411760,
		}, {
			"Go to "..cl(69,49),
			"	a. Talk to Prospector Conall",
			"		i. Accept "..cq("Unfinished Business"),
			completion={{questaccepted="Unfinished Business"}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=49411800,
		}, {
			"Also at "..cl(69,49),
			"	a. Talk to Ruam",
			"		i. Accept "..cq("Fulgor Spores"),
			completion={{questaccepted="Fulgor Spores"}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=48711730,
		}, {
			"Go to "..cl(68,48),
			"	a. Talk to Haalrun",
			"		i. Accept "..cq("Too Many Mouths to Feed"),
			"	b. Talk to Noraani",
			"		i. Accept "..cq("Menacing Marshfangs"),
			completion={{questaccepted="Too Many Mouths to Feed"},{questaccepted="Menacing Marshfangs"}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=48011570,
		}, {
			"Go to "..cl(68,51),
			"	a. Talk to Munci",
			"		i. Get the Telredor Flight Path",
			completion={{flightpath="Telredor"}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=51511930,
		}, {
			"Go northwest to "..cl(71,47),
			"	a. Click the little green glowing mushrooms",
			"	b. Get 6 Fulgor Spores",
			completion={{questgoal={"*","Fulgor Spore",6}}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=46911820,
		}, {
			"Go northeast to "..cl(73,41),
			"	a. Kill 10 Marshfang Rippers",
			completion={{questgoal={"*","Marshfang Ripper slain",10}}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=41511470,
		}, {
			"Go southeast to "..cl(77,46),
			"	a. Kill Sporewing",
			completion={{questgoal={"*","Sporewing slain",1}}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=45912310,
		}, {
			"Go northeast to "..cl(81,43),
			"	a. Click the Dead Mire Soil mound",
			"	b. Get a Dead Mire Soil Sample",
			completion={{questgoal={"*","Dead Mire Soil Sample",1}}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=43412410,
		}, {
			"Go southwest to Telredor",
			completion={{location={mapzone="Zangarmarsh",x=68.3,y=49.2, dist=2}}},
			mapzone="Zangarmarsh",
			level=62,
		}, {
			"Go to "..cl(68,50),
			"	a. Talk Vindicator Idaar",
			"		i. Turn in "..cq("The Dead Mire"),
			"		ii. Accept "..cq("An Unnatural Drought"),
			completion={{questturnedin="The Dead Mire"},{questaccepted="An Unnatural Drought"}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=50111840,
		}, {
			"Go to "..cl(69,49),
			"	a. Talk to Prospector Conall ",
			"		i. Turn in "..cq("Unfinished Business"),
			"		ii. Accept "..cq("Blacksting's Bane"),
			completion={{questturnedin="Unfinished Business"},{questaccepted="Blacksting's Bane"}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=49411800,
		}, {
			"Also at "..cl(69,49),
			"	a. Talk to Ruam",
			"		i. Turn in "..cq("Fulgor Spores"),
			completion={{questturnedin="Fulgor Spores"}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=48711730,
		}, {
			"Go to "..cl(68,48),
			"	a. Talk to Noraani",
			"		i. Turn in "..cq("Menacing Marshfangs"),
			"		ii. Accept "..cq("Umbrafen Eel Filets"),
			completion={{questturnedin="Menacing Marshfangs"},{questaccepted="Umbrafen Eel Filets"}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=48011570,
		}, {
			"Go northeast to "..cl(78,45),
			"	a. Kill 12 Withered Giants",
			"	b. Kill Withered Bog Lords",
			"	c. Get 6 Bog Lord Tendrils",
			"	d. Kill Withered mobs",
			"	e. Get a Withered Basidium",
			"	f. Click the Withered Basidium",
			"		i. Accept "..cq("Withered Basidium"),
			completion={{questgoal={"*","Withered Giant slain",12}},{questgoal={"*","Bog Lord Tendril",6}},{questaccepted="Withered Basidium"}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=45212350,
		}, {
			"Go southwest to "..cl(74,61),
			"	a. Kill 10 Mire Hydras",
			"	b. Kill Umbrafen Eels",
			"	c. Get 8 Eel Filets",
			completion={{questgoal={"*","Mire Hydra slain",10}},{questgoal={"*","Eel Filet",8}}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=60713490,
		}, {
			"Go northwest to Telredor",
			completion={{location={mapzone="Zangarmarsh",x=68.3,y=49.2, dist=2}}},
			mapzone="Zangarmarsh",
			level=62,
		}, {
			"Go to "..cl(68,50),
			"	a. Talk to Vindicator Idaar",
			"		i. Turn in "..cq("An Unnatural Drought"),
			completion={{questturnedin="An Unnatural Drought"}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=50111840,
		}, {
			"Go to "..cl(69,49),
			"	a. Talk to Ruam",
			"		i. Turn in "..cq("Withered Basidium"),
			"		ii. Accept "..cq("Withered Flesh"),
			completion={{questturnedin="Withered Basidium"},{questaccepted="Withered Flesh"}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=48711730,
		}, {
			"Go to "..cl(68,48),
			"	a. Talk to Noraani",
			"		i. Turn in "..cq("Umbrafen Eel Filets"),
			"	b. Talk to Haalrun",
			"		i. Turn in "..cq("Too Many Mouths to Feed"),
			"		ii. Accept "..cq("Diaphanous Wings"),
			completion={{questturnedin="Umbrafen Eel Filets"},{questturnedin="Too Many Mouths to Feed"},{questaccepted="Diaphanous Wings"}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=48011570,
		}, {
			"Go southeast to "..cl(80,70),
			"	a. Kill Umbraglow Stingers",
			"	b. Get 8 Diaphanous Wings",
			completion={{questgoal={"*","Diaphanous Wing",8}}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=70114980,
		}, {
			"Go northeast to "..cl(83,44),
			"	a. Kill Parched Hydras",
			"	b. Get 5 Parched Hydra Samples",
			"	c. Kill Withered Bog Lords",
			"	d. Get 5 Withered Bog Lord Samples",
			completion={{questgoal={"*","Parched Hydra Sample",5}},{questgoal={"*","Withered Bog Lord Sample",5}}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=43712630,
		}, {
			"Go southwest to Telredor",
			completion={{location={mapzone="Zangarmarsh",x=68.3,y=49.2, dist=2}}},
			mapzone="Zangarmarsh",
			level=62,
		}, {
			"Go to "..cl(69,49),
			"	a. Talk to Ruam",
			"		i. Turn in "..cq("Withered Flesh"),
			completion={{questturnedin="Withered Flesh"}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=48711730,
		}, {
			"Go to "..cl(68,48),
			"	a. Talk to Haalrun",
			"		i. Turn in "..cq("Diaphanous Wings"),
			completion={{questturnedin="Diaphanous Wings"}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=48011570,
		}, {
			"Go northwest to "..cl(62,42),
			"	a. Use your Ironvine Seeds on the Serpent Lake Controls",
			"	b. Disable the Serpent Lake Controls",
			"	c. Kill Steam Pump Overseers, Bloodscale Overseers, and Bloodscale Wavecallers",
			"		i. Get a Drain Schematics",
			"	d. Click the Drain Schematics in your bags",
			"		i. Accept "..cq("Drain Schematics"),
			completion={{questgoal={"*","Serpent Lake Controls Disabled",1}},{questaccepted="Drain Schematics"}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=40810280,
		}, {
			"Go southwest to "..cl(49,59),
			"	a. Kill Blacksting",
			"	b. Get Blacksting's Stinger",
			completion={{questgoal={"*","Blacksting's Stinger",1}}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=59210870,
		}, {
			"Go southwest to "..cl(45,66),
			"	a. The path up to 'The Boha'mu Ruins' starts here",
			completion={{location={mapzone="Zangarmarsh",x=44.5,y=66.1, dist=0.5}}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=66211070,
		}, {
			"Go south to "..cl(44,69),
			"	a. Explore the Boha'mu Ruins",
			completion={{questgoal={"*","Explore the Boha'mu Ruins",1}}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=68811290,
		}, {
			"Go northwest to "..cl(32,59),
			"	a. Kill 'Count' Ungula",
			"	b. Get 'Count' Ungula's Mandible",
			"	c. Click 'Count' Ungula's Mandible",
			"		i. Accept "..cq("The Count of the Marshes"),
			completion={{questaccepted="The Count of the Marshes"}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=59109190,
		}, {
			"Go southwest to "..cl(23,66),
			"	a. Talk to Watcher Leesa'oh",
			"		i. Turn in "..cq("Watcher Leesa'oh"),
			"		ii. Accept "..cq("Observing the Sporelings"),
			"		iii. Turn in "..cq("The Count of the Marshes"),
			completion={{questturnedin="Watcher Leesa'oh"},{questaccepted="Observing the Sporelings"},{questturnedin="The Count of the Marshes"}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=66208950,
		}, {
			"Go northwest to "..cl(19,64),
			"	a. Talk to Fahssn",
			"		i. Accept "..cq("The Sporelings' Plight"),
			"		ii. Accept "..cq("Natural Enemies"),
			"		iii. Turn in "..cq("Natural Enemies"),
			completion={{questaccepted="The Sporelings' Plight"},{questaccepted="Natural Enemies"},{questturnedin="Natural Enemies"}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=63908300,
		}, {
			"Go northwest to "..cl(14,62),
			"	a. Get 30 Mature Spore Sacs",
			completion={{questgoal={"*","Mature Spore Sac",30}}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=61607610,
		}, {
			"Go northwest to "..cl(14,60),
			"	a. Go here to Investigate the Spawning Glen",
			completion={{questgoal={"*","Investigate the Spawning Glen",1}}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=59807340,
		}, {
			"Go southeast to "..cl(19,64),
			"	a. Talk to Fahssn",
			"		i. Turn in "..cq("The Sporelings' Plight"),
			"		ii. Accept "..cq("Sporeggar"),
			"		iii. Turn in all your Mature Spore Sacs",
			completion={{questturnedin="The Sporelings' Plight"},{questaccepted="Sporeggar"}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=63908300,
		}, {
			"Go southeast to "..cl(23,66),
			"	a. Talk to Watcher Leesa'oh",
			"		i. Turn in "..cq("Observing the Sporelings"),
			"		ii. Accept "..cq("A Question of Gluttony"),
			completion={{questturnedin="Observing the Sporelings"},{questaccepted="A Question of Gluttony"}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=66208950,
		}, {
			"Go northeast to "..cl(27,63),
			"	a. Get 10 Discarded Nutriments",
			completion={{questgoal={"*","Discarded Nutriment",10}}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=63309030,
		}, {
			"Go southwest to "..cl(23,66),
			"	a. Talk to Watcher Leesa'oh",
			"		i. Turn in "..cq("A Question of Gluttony"),
			"		ii. Accept "..cq("Familiar Fungi"),
			completion={{questturnedin="A Question of Gluttony"},{questaccepted="Familiar Fungi"}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=66208950,
		}, {
			"Go northwest to "..cl(20,52),
			"	a. Talk to Msshi'fn",
			"		i. Turn in "..cq("Sporeggar"),
			completion={{questturnedin="Sporeggar"}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=52107180,
		}, {
			"Go to "..cl(19,50),
			"	a. Talk to Gzhun'tt",
			"		i. Accept "..cq("Now That We're Friends..."),
			completion={{questaccepted="Now That We're Friends..."}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=50006950,
		}, {
			"Also at "..cl(19,50),
			"	a. Talk to Gshaff",
			"		i. Accept "..cq("Fertile Spores"),
			"		ii. Turn in "..cq("Fertile Spores"),
			completion={{questaccepted="Fertile Spores"},{questturnedin="Fertile Spores"}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=49406860,
		}, {
			"Go northeast to "..cl(25,43),
			"	a. Use your ironvine Seeds on the Marshlight Lake Pump Controls",
			"	b. Disable the Marshlight Lake Pump Controls",
			completion={{questgoal={"*","Marshlight Lake Controls Disabled",1}}},
			mapzone="Zangarmarsh",
			level=63,
			mapnote=42906830,
		}, {
			"Go east to "..cl(27,43),
			"	a. Kill 12 Bloodscale Slavedrivers",
			"	b. Kill 12 Bloodscale Enchantresses",
			completion={{questgoal={"*","Bloodscale Slavedriver slain",12}},{questgoal={"*","Bloodscale Enchantress slain",12}}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=43006980,
		}, {
			"Go southwest to "..cl(19,50),
			"	a. Talk to Gzhun'tt",
			"		i. Turn in "..cq("Now That We're Friends..."),
			completion={{questturnedin="Now That We're Friends..."}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=50006950,
		}, {
			"Go northeast to Orebor Harborage",
			completion={{location={mapzone="Zangarmarsh",x=41.8,y=26.6, dist=4}}},
			mapzone="Zangarmarsh",
			level=62,
		}, {
			"Go to "..cl(41,29),
			"	a. Talk to Halu",
			"		i. Get the Orebor Harborage Flight Path",
			completion={{flightpath="Orebor Harborage"}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=29007030,
		}, {
			"Also at "..cl(41,29),
			"	a. Talk to Timothy Daniels",
			"		i. Accept "..cq("Secrets of the Daggerfen"),
			completion={{questaccepted="Secrets of the Daggerfen"}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=28706990,
		}, {
			"Go to "..cl(42,27),
			"	a. Click the Wanted Poster",
			"		i. Accept "..cq("Wanted: Chieftain Mummaki"),
			completion={{questaccepted="Wanted: Chieftain Mummaki"}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=27306900,
		}, {
			"Also at "..cl(42,27),
			"	a. Talk to Ikuti",
			"		i. Turn in "..cq("The Orebor Harborage"),
			"		ii. Accept "..cq("Ango'rosh Encroachment"),
			"		iii. Accept "..cq("Daggerfen Deviance"),
			completion={{questturnedin="The Orebor Harborage"},{questaccepted="Ango'rosh Encroachment"},{questaccepted="Daggerfen Deviance"}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=27206910,
		}, {
			"Go northwest to "..cl(28,22),
			"	a. Kill 3 Daggerfen Assassins",
			"	b. Kill 15 Daggerfen Muckdwellers",
			completion={{questgoal={"*","Daggerfen Assassin slain",3}},{questgoal={"*","Daggerfen Muckdweller slain",15}}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=22105030,
		}, {
			"Go southwest to "..cl(26,23),
			"	a. Get the Daggerfen Poison Vial",
			completion={{questgoal={"*","Daggerfen Poison Vial",1}}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=22804920,
		}, {
			"Go southwest to "..cl(25,27),
			"	a. Get the Daggerfen Poison Manual",
			completion={{questgoal={"*","Daggerfen Poison Manual",1}}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=27005140,
		}, {
			"Go west to "..cl(24,27),
			"	a. Kill Chieftain Mummaki",
			"	b. Get Chieftain Mummaki's Totem",
			completion={{questgoal={"*","Chieftain Mummaki's Totem",1}}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=26805060,
		}, {
			"Go east to "..cl(30,28),
			"	a. Kill 5 Ango'rosh Shamans",
			"	b. Kill 10 Ango'rosh Ogres",
			"	c. Get 15 Mushroom Samples",
			completion={{questgoal={"*","Ango'rosh Shaman slain",5}},{questgoal={"*","Ango'rosh Ogre slain",10}},{questgoal={"*","Mushroom Sample",15}}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=28305790,
		}, {
			"Go east to Orebor Harborage",
			completion={{location={mapzone="Zangarmarsh",x=41.8,y=26.6, dist=4}}},
			mapzone="Zangarmarsh",
			level=62,
		}, {
			"Go to "..cl(41,29),
			"	a. Talk to Timothy Daniels",
			"		i. Turn in "..cq("Secrets of the Daggerfen"),
			completion={{questturnedin="Secrets of the Daggerfen"}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=28706990,
		}, {
			"Go to "..cl(42,27),
			"	a. Talk to Ikuti",
			"		i. Turn in "..cq("Ango'rosh Encroachment"),
			"		ii. Accept "..cq("Overlord Gorefist"),
			"		iii. Turn in "..cq("Wanted: Chieftain Mummaki"),
			"		iv. Turn in "..cq("Daggerfen Deviance"),
			completion={{questturnedin="Ango'rosh Encroachment"},{questaccepted="Overlord Gorefist"},{questturnedin="Wanted: Chieftain Mummaki"},{questturnedin="Daggerfen Deviance"}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=27206910,
		}, {
			"Make Orebor Harborage your home",
			completion={{home="Orebor Harborage"}},
			mapzone="Zangarmarsh",
			level=62,
		}, {
			"Go to "..cl(42,27),
			"	a. Talk to Maktu",
			"		i. Accept "..cq("Natural Armor"),
			completion={{questaccepted="Natural Armor"}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=27306890,
		}, {
			"Go to "..cl(41,29),
			"	a. Talk to Puluu",
			"		i. Accept "..cq("Stinger Venom"),
			"		ii. Accept "..cq("Lines of Communication"),
			"		iii. Accept "..cq("The Terror of Marshlight Lake"),
			completion={{questaccepted="Stinger Venom"},{questaccepted="Lines of Communication"},{questaccepted="The Terror of Marshlight Lake"}},
			mapzone="Zangarmarsh",
			level=62,
			mapnote=28706950,
		}, {
			"Grind to level 63",
			completion={{level=63}},
			mapzone="Zangarmarsh",
			level=62,
		}, {
			"Go southeast to "..cl(48,38),
			"	a. Kill Fenclaw Thrashers",
			"	b. Get 6 Fenclaw Hides",
			completion={{questgoal={"*","Fenclaw Hide",6}}},
			mapzone="Zangarmarsh",
			level=63,
			mapnote=38408650,
		}, {
			"Go southeast to "..cl(51,41),
			"	a. Swim straight down at this spot",
			"	b. Locate the drain in Serpent Lake",
			completion={{questgoal={"*","Drain Located",1}}},
			mapzone="Zangarmarsh",
			level=63,
			mapnote=40809120,
		}, {
			"Go southwest to "..cl(37,54),
			"	a. Kill 12 Marshfang Slicers",
			completion={{questgoal={"*","Marshfang Slicer slain",12}}},
			mapzone="Zangarmarsh",
			level=63,
			mapnote=54409160,
		}, {
			"Go southwest to "..cl(23,66),
			"	a. Talk to Watcher Leesa'oh",
			"		i. Turn in "..cq("Familiar Fungi"),
			"		ii. Accept "..cq("Stealing Back the Mushrooms"),
			completion={{questturnedin="Familiar Fungi"},{questaccepted="Stealing Back the Mushrooms"}},
			mapzone="Zangarmarsh",
			level=63,
			mapnote=66208950,
		}, {
			"Go north to "..cl(22,46),
			"	a. Kill Terrorclaw",
			completion={{questgoal={"*","Terrorclaw slain",1}}},
			mapzone="Zangarmarsh",
			level=63,
			mapnote=46106850,
		}, {
			"Go northwest to "..cl(17,14),
			"	a. Kill 10 Ango'rosh Maulers",
			"	b. Get 10 Boxes of Mushrooms",
			completion={{questgoal={"*","Ango'rosh Mauler slain",10}},{questgoal={"*","Box of Mushrooms",10}}},
			mapzone="Zangarmarsh",
			level=63,
			mapnote=14303130,
		}, {
			"Go northeast to "..cl(18,7),
			"	a. Kill Overlord Gorefist",
			completion={{questgoal={"*","Overlord Gorefist slain",1}}},
			mapzone="Zangarmarsh",
			level=63,
			mapnote=7702600,
		}, {
			"In the northwestern part of the map:",
			"	a. Kill Marshlight Bleeders",
			"	b. Get 6 Marshlight Bleeder Venom",
			completion={{questgoal={"*","Marshlight Bleeder Venom",6}}},
			mapzone="Zangarmarsh",
			level=63,
		}, {
			"Go to Orebor Harborage",
			completion={{location={mapzone="Zangarmarsh",x=41.8,y=26.6, dist=4}}},
			mapzone="Zangarmarsh",
			level=63,
		}, {
			"Go to "..cl(41,29),
			"	a. Talk to Puluu",
			"		i. Turn in "..cq("Stinger Venom"),
			"		ii. Turn in "..cq("Lines of Communication"),
			"		iii. Turn in "..cq("The Terror of Marshlight Lake"),
			completion={{questturnedin="Stinger Venom"},{questturnedin="Lines of Communication"},{questturnedin="The Terror of Marshlight Lake"}},
			mapzone="Zangarmarsh",
			level=63,
			mapnote=28706950,
		}, {
			"Go to "..cl(42,27),
			"	a. Talk to Maktu",
			"		i. Turn in "..cq("Natural Armor"),
			"		ii. Accept "..cq("Maktu's Revenge"),
			completion={{questturnedin="Natural Armor"},{questaccepted="Maktu's Revenge"}},
			mapzone="Zangarmarsh",
			level=63,
			mapnote=27306890,
		}, {
			"Also at "..cl(42,27),
			"	a. Talk to Ikuti",
			"		i. Turn in "..cq("Overlord Gorefist"),
			completion={{questturnedin="Overlord Gorefist"}},
			mapzone="Zangarmarsh",
			level=63,
			mapnote=27206910,
		}, {
			"Go south to "..cl(42,41),
			"	a. Kill Mragesh",
			completion={{questgoal={"*","Mragesh slain",1}}},
			mapzone="Zangarmarsh",
			level=63,
			mapnote=41408360,
		}, {
			"Go southwest to "..cl(23,66),
			"	a. Talk to Watcher Leesa'oh",
			"		i. Turn in "..cq("Stealing Back the Mushrooms"),
			"		ii. Don't follow her when she walks away",
			completion={{questturnedin="Stealing Back the Mushrooms"}},
			mapzone="Zangarmarsh",
			level=63,
			mapnote=66208950,
		}, {
			"Go to Orebor Harborage",
			completion={{location={mapzone="Zangarmarsh",x=41.8,y=26.6, dist=4}}},
			mapzone="Zangarmarsh",
			level=63,
		}, {
			"Go to "..cl(42,27),
			"	a. Talk to Maktu",
			"		i. Turn in "..cq("Maktu's Revenge"),
			completion={{questturnedin="Maktu's Revenge"}},
			mapzone="Zangarmarsh",
			level=63,
			mapnote=27306890,
		}, {
			"Fly to Telredor",
			completion={{location={mapzone="Zangarmarsh",x=68.3,y=49.2, dist=2}}},
			mapzone="Zangarmarsh",
			level=63,
		}, {
			"Go to "..cl(68,49),
			"	a. Talk to Anchorite Ahuurn",
			"		i. Turn in "..cq("The Boha'mu Ruins"),
			"		ii. Accept "..cq("Idols of the Feralfen"),
			completion={{questturnedin="The Boha'mu Ruins"},{questaccepted="Idols of the Feralfen"}},
			mapzone="Zangarmarsh",
			level=63,
			mapnote=49411760,
		}, {
			"Go to "..cl(69,49),
			"	a. Talk to Prospector Conall",
			"		i. Turn in "..cq("Blacksting's Bane"),
			completion={{questturnedin="Blacksting's Bane"}},
			mapzone="Zangarmarsh",
			level=63,
			mapnote=49411800,
		}, {
			"Go southwest to "..cl(49,61),
			"	a. Get 6 Feralfen Idols",
			completion={{questgoal={"*","Feralfen Idol",6}}},
			mapzone="Zangarmarsh",
			level=63,
			mapnote=60610990,
		}, {
			"Go northeast to Telredor",
			completion={{location={mapzone="Zangarmarsh",x=68.3,y=49.2, dist=2}}},
			mapzone="Zangarmarsh",
			level=63,
		}, {
			"Go to "..cl(68,49),
			"	a. Talk to Anchorite Ahuurn",
			"		i. Turn in "..cq("Idols of the Feralfen"),
			"		ii. Accept "..cq("Gathering the Reagents"),
			completion={{questturnedin="Idols of the Feralfen"},{questaccepted="Gathering the Reagents"}},
			mapzone="Zangarmarsh",
			level=63,
			mapnote=49411760,
		}, {
			"Go southwest to "..cl(63,52),
			"	a. Kill Spore Bats",
			"	b. Get 4 Spore Bat Eyes",
			"	c. Kill Fen Striders",
			"	d. Get 4 Fen Strider Tentacles",
			completion={{questgoal={"*","Spore Bat Eye",4}},{questgoal={"*","Fen Strider Tentacle",4}}},
			mapzone="Zangarmarsh",
			level=63,
			mapnote=52111540,
		}, {
			"Go northeast to Telredor",
			completion={{location={mapzone="Zangarmarsh",x=68.3,y=49.2, dist=2}}},
			mapzone="Zangarmarsh",
			level=63,
		}, {
			"Go to "..cl(68,49),
			"	a. Talk to Anchorite Ahuurn",
			"		i. Turn in "..cq("Gathering the Reagents"),
			"		ii. Accept "..cq("Messenger to the Feralfen"),
			completion={{questturnedin="Gathering the Reagents"},{questaccepted="Messenger to the Feralfen"}},
			mapzone="Zangarmarsh",
			level=63,
			mapnote=49411760,
		}, {
			"Go southwest to "..cl(44,70),
			"	a. Drink Ahuurn's Elixir",
			"	b. Walk up the big steps",
			"	c. Talk to Elder Kuruti",
			completion={{questgoal={"*","Elder Kuruti's Response",1}}},
			mapzone="Zangarmarsh",
			level=63,
			mapnote=69411350,
		}, {
			"Go northeast to Telredor",
			completion={{location={mapzone="Zangarmarsh",x=68.3,y=49.2, dist=2}}},
			mapzone="Zangarmarsh",
			level=63,
		}, {
			"Go to "..cl(68,49),
			"	a. Talk to Anchorite Ahuurn",
			"		i. Turn in "..cq("Messenger to the Feralfen"),
			completion={{questturnedin="Messenger to the Feralfen"}},
			mapzone="Zangarmarsh",
			level=63,
			mapnote=49411760,
		}, {
			"Go southeast to Cenarion Refuge",
			completion={{location={mapzone="Zangarmarsh",x=79.7,y=64.6, dist=2}}},
			mapzone="Zangarmarsh",
			level=63,
		}, {
			"Go to "..cl(78,62),
			"	a. Talk to Ysiel Windsinger",
			"		i. Turn in "..cq("Balance Must Be Preserved"),
			"		ii. Turn in "..cq("Drain Schematics"),
			"		iii. Accept "..cq("Warning the Cenarion Circle"),
			completion={{questturnedin="Balance Must Be Preserved"},{questturnedin="Drain Schematics"},{questaccepted="Warning the Cenarion Circle"}},
			mapzone="Zangarmarsh",
			level=63,
			mapnote=62014040,
		}, {
			"Go east to Hellfire Peninsula",
			completion={{location={mapzone="Hellfire Peninsula"}}},
			mapzone="Zangarmarsh",
			level=63,
		}, {
			"Go to "..cl(16,52),
			"	a. Talk to Amythiel Mistwalker",
			"		i. Turn in "..cq("Warning the Cenarion Circle"),
			"		ii. Accept "..cq("Return to the Marsh"),
			completion={{questturnedin="Warning the Cenarion Circle"},{questaccepted="Return to the Marsh"}},
			mapzone="Hellfire Peninsula",
			level=63,
			mapnote=52006770,
		}, {
			"Go west to Zangarmarsh",
			completion={{location={mapzone="Zangarmarsh"}}},
			mapzone="Hellfire Peninsula",
			level=63,
		}, {
			"Go to "..cl(78,62),
			"	a. Talk to Ysiel Windsinger",
			"		i. Turn in "..cq("Return to the Marsh"),
			completion={{questturnedin="Return to the Marsh"}},
			mapzone="Zangarmarsh",
			level=63,
			mapnote=62014040,
		}, {
			"Go south to Terokkar Forest",
			completion={{location={mapzone="Terokkar Forest"}}},
			mapzone="Zangarmarsh",
			level=63,
		}, {
			"Go south to Shattrath City",
			completion={{location={mapzone="Shattrath City"}}},
			mapzone="Terrokar Forest",
			level=63,
		}, {
			"Go to "..cl(61,13),
			"	a. Talk to the Haggard War Veteran",
			"		i. Accept "..cq("A'dal"),
			completion={{questaccepted="A'dal"}},
			mapzone="Shattrath City",
			level=63,
			mapnote=12607380,
		}, {
			"Go to "..cl(54,45),
			"	a. Talk to A'dal",
			"		i. Turn in "..cq("A'dal"),
			completion={{questturnedin="A'dal"}},
			mapzone="Shattrath City",
			level=63,
			mapnote=44809880,
		}, {
			"Go to "..cl(55,44),
			"	a. Talk to Khadgar",
			"		i. Accept "..cq("City of Light"),
			"		ii. Follow the pink voidwalker",
			completion={{questaccepted="City of Light"}},
			mapzone="Shattrath City",
			level=63,
			mapnote=44309910,
		}, {
			"As you follow the pink voidwalker:",
			"	a. Talk to Seth at "..cl(64,16),
			"		i. Accept "..cq("Rather Be Fishin'"),
			completion={{questaccepted="Rather Be Fishin'"}},
			mapzone="Shattrath City",
			level=63,
			mapnote=15507950,
		}, {
			"Also while following the pink voidwalker:",
			"	a. Talk to Rilak the Redeemed at "..cl(53,21),
			"		i. Accept "..cq("The Eyes of Skettis"),
			completion={{questaccepted="The Eyes of Skettis"}},
			mapzone="Shattrath City",
			level=63,
			mapnote=21007360,
		}, {
			"Go to "..cl(55,44),
			"	a. Talk to Khadgar",
			"		i. Turn in "..cq("City of Light"),
			"		ii. Accept "..cq("Allegiance of the Aldor"),
			"		iii. Accept "..cq("Ishanah"),
			completion={{questturnedin="City of Light"},{questaccepted="Allegiance of the Aldor"},{questaccepted="Ishanah"}},
			mapzone="Shattrath City",
			level=63,
			mapnote=44309910,
		}, {
			"Ride the elevator up to the Aldor Rise",
			completion={{location={mapzone="Shattrath City",x=41.7,y=38.6, dist=0.5}}},
			mapzone="Shattrath City",
			level=63,
		}, {
			"Go to "..cl(31,35),
			"	a. Talk to Adyen the Lightwarden",
			"		i. Accept "..cq("Marks of Kil'jaeden"),
			completion={{questaccepted="Marks of Kil'jaeden"}},
			mapzone="Shattrath City",
			level=63,
			mapnote=34606530,
		}, {
			"Go to "..cl(24,30),
			"	a. Talk to Ishanah",
			"		i. Turn in "..cq("Ishanah"),
			"		ii. Accept "..cq("Restoring the Light"),
			completion={{questturnedin="Ishanah"},{questaccepted="Restoring the Light"}},
			mapzone="Shattrath City",
			level=63,
			mapnote=29705370,
		}, {
			"Make Shattrath City your home",
			completion={{home="Shattrath City"}},
			mapzone="Shattrath City",
			level=63,
		}, {
			"Go to "..cl(64,41),
			"	a. Talk to Nutral",
			"		i. Get the Shattrath City Flight Path",
			completion={{flightpath="Shattrath City"}},
			mapzone="Shattrath City",
			level=63,
			mapnote=41110510,
		}, {
			"Go outside to Terokkar Forest",
			completion={{location={mapzone="Terokkar Forest"}}},
			mapzone="Shattrath City",
			level=63,
		}, {
			"Go northeast to 39,8",
			"	a. Kill Shimmerscale Eels",
			"	b. Get 8 Pristine Shimmerscale Eels",
			completion={{questgoal={"*","Pristine Shimmerscale Eel",8}}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=8504710,
		}, {
			"Go southeast to "..cl(44,26),
			"	a. Talk to Earthbinder Tavgren",
			"		i. Turn in "..cq("What's Wrong at Cenarion Thicket?"),
			"		ii. Accept "..cq("Strange Energy"),
			"		iii. Accept "..cq("Clues in the Thicket"),
			completion={{questturnedin="What's Wrong at Cenarion Thicket?"},{questaccepted="Strange Energy"},{questaccepted="Clues in the Thicket"}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=26307060,
		}, {
			"Go northeast to "..cl(45,23),
			"	a. Talk to Warden Treelos",
			"		i. Accept "..cq("It's Watching You!"),
			completion={{questaccepted="It's Watching You!"}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=22506750,
		}, {
			"Go north to "..cl(45,22),
			"	a. Examine the Strange Object",
			completion={{questgoal={"*","Strange Object examined",1}}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=21806690,
		}, {
			"Go south to "..cl(44,26),
			"	a. Talk to Earthbinder Tavgren",
			"		i. Turn in "..cq("Clues in the Thicket"),
			completion={{questturnedin="Clues in the Thicket"}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=26307060,
		}, {
			"Go north to "..cl(43,22),
			"	a. Kill Naphthal'ar",
			completion={{questgoal={"*","Naphthal'ar slain",1}}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=22106550,
		}, {
			"Go east to "..cl(45,23),
			"	a. Talk to Warden Treelos",
			"		i. Turn in "..cq("It's Watching You!"),
			completion={{questturnedin="It's Watching You!"}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=22506750,
		}, {
			"Go southwest to "..cl(44,24),
			"	a. Kill Vicious Teromoths",
			"	b. Get 4 Vicious Teromoth Samples",
			completion={{questgoal={"*","Vicious Teromoth Sample",4}}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=23806790,
		}, {
			"Go southeast to "..cl(46,30),
			"	a. Kill Teromoths",
			"	b. Get 4 Teromoth Samples",
			completion={{questgoal={"*","Teromoth Sample",4}}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=29807560,
		}, {
			"Go northwest to "..cl(44,26),
			"	a. Talk to Earthbinder Tavgren",
			"		i. Turn in "..cq("Strange Energy"),
			"		ii. Accept "..cq("By Any Means Necessary"),
			completion={{questturnedin="Strange Energy"},{questaccepted="By Any Means Necessary"}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=26307060,
		}, {
			"Go east to "..cl(47,27),
			"	a. Fight Empoor until he's almost dead",
			"	b. Talk to Empoor",
			"		i. Turn in "..cq("By Any Means Necessary"),
			"		ii. Accept "..cq("Wind Trader Lathrai"),
			completion={{questturnedin="By Any Means Necessary"},{questaccepted="Wind Trader Lathrai"}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=27007410,
		}, {
			"Go northeast to "..cl(49,20),
			"	a. Click the Eastern Altar",
			"	b. Purify the Eastern Altar",
			completion={{questgoal={"*","Eastern Altar",1}}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=20306950,
		}, {
			"Go northeast to "..cl(50,19),
			"	a. The path up to the Eye of Veil Reskk starts here",
			completion={{location={mapzone="Terokkar Forest",x=49.9,y=16.5, dist=0.3}}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=16506640,
		}, {
			"Also at "..cl(50,19),
			"	a. Get the Eye of Veil Reskk",
			completion={{questgoal={"*","Eye of Veil Reskk",1}}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=19406950,
		}, {
			"Go north to "..cl(51,17),
			"	a. Click the Northern Altar",
			"	b. Purify the Northern Altar",
			completion={{questgoal={"*","Northern Altar",1}}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=16606730,
		}, {
			"Go northwest to "..cl(48,14),
			"	a. Click the Western Altar",
			"	b. Purify the Western Altar",
			completion={{questgoal={"*","Western Altar",1}}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=14506260,
		}, {
			"Go southeast to "..cl(58,23),
			"	a. Get the Eye of Veil Shienor",
			completion={{questgoal={"*","Eye of Veil Shienor",1}}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=23208110,
		}, {
			"Go to Shattrath City",
			completion={{location={mapzone="Shattrath City"}}},
			mapzone="Terokkar Forest",
			level=63,
		}, {
			"Go to "..cl(24,30),
			"	a. Talk to Ishanah",
			"		i. Turn in "..cq("Restoring the Light"),
			completion={{questturnedin="Restoring the Light"}},
			mapzone="Shattrath City",
			level=63,
			mapnote=29705370,
		}, {
			"Go to "..cl(53,21),
			"	a. Talk to Rilak the Redeemed",
			"		i. Turn in "..cq("The Eyes of Skettis"),
			"		ii. Accept "..cq("Seek Out Kirrik"),
			completion={{questturnedin="The Eyes of Skettis"},{questaccepted="Seek Out Kirrik"}},
			mapzone="Shattrath City",
			level=63,
			mapnote=21007360,
		}, {
			"Go to "..cl(64,16),
			"	a. Talk to Seth",
			"		i. Turn in "..cq("Rather Be Fishin'"),
			completion={{questturnedin="Rather Be Fishin'"}},
			mapzone="Shattrath City",
			level=63,
			mapnote=15507950,
		}, {
			"Go to "..cl(72,31),
			"	a. Talk to Wind Trader Lathrai",
			"		i. Turn in "..cq("Wind Trader Lathrai"),
			"		ii. Accept "..cq("A Personal Favor"),
			completion={{questturnedin="Wind Trader Lathrai"},{questaccepted="A Personal Favor"}},
			mapzone="Shattrath City",
			level=63,
			mapnote=30710290,
		}, {
			"Go outside to Terokkar Forest",
			completion={{location={mapzone="Terokkar Forest"}}},
			mapzone="Shattrath City",
			level=63,
		}, {
			"Go southeast to "..cl(37,51),
			"	a. Talk to Kirrik the Awakened",
			"		i. Turn in "..cq("Seek Out Kirrik"),
			"		ii. Accept "..cq("Veil Skith: Darkstone of Terokk"),
			completion={{questturnedin="Seek Out Kirrik"},{questaccepted="Veil Skith: Darkstone of Terokk"}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=51508890,
		}, {
			"Go to "..cl(38,51),
			"	a. Talk to Ethan",
			"		i. Accept "..cq("Missing Friends"),
			completion={{questaccepted="Missing Friends"}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=51308900,
		}, {
			"Go to "..cl(37,51),
			"	a. Talk to Mekeda",
			"		i. Accept "..cq("Before Darkness Falls"),
			completion={{questaccepted="Before Darkness Falls"}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=51208860,
		}, {
			"Go to "..cl(38,52),
			"	a. Talk to Lakotae",
			"		i. Accept "..cq("The Infested Protectors"),
			completion={{questaccepted="The Infested Protectors"}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=51708960,
		}, {
			"Go northwest to "..cl(35,49),
			"	a. Kill Infested Root-walkers",
			"	b. Kill the Wood Mites that come out of their corpses",
			"	c. Kill 25 Wood Mites",
			completion={{questgoal={"*","Wood Mite slain",25}}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=48808400,
		}, {
			"Go southwest to "..cl(35,53),
			"	a. Kill Cabal orcs",
			"	b. Get 10 Marks of Kil'jaeden",
			"	c. Get the Cabal Orders",
			"	d. Click the Cabal Orders",
			"		i. Accept "..cq("Cabal Orders"),
			"	e. Kill 8 Cabal Skirmishers",
			completion={{questgoal={"*","Mark of Kil'jaeden",10}},{questgoal={"*","Cabal Skirmisher slain",8}},{questaccepted="Cabal Orders"}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=52808500,
		}, {
			"Go east to "..cl(37,51),
			"	a. Talk to Mekeda",
			"		i. Turn in "..cq("Cabal Orders"),
			"		ii. Accept "..cq("The Shadow Tomb"),
			completion={{questturnedin="Cabal Orders"},{questaccepted="The Shadow Tomb"}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=51208860,
		}, {
			"Go to "..cl(38,52),
			"	a. Talk to Lakotae",
			"		i. Turn in "..cq("The Infested Protectors"),
			completion={{questturnedin="The Infested Protectors"}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=51708960,
		}, {
			"Go southeast to "..cl(39,55),
			"	a. Kill 4 Cabal Spell-weavers",
			"	b. Kill 2 Cabal Initiates",
			completion={{questgoal={"*","Cabal Spell-weaver slain",4}},{questgoal={"*","Cabal Initiate slain",2}}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=55109450,
		}, {
			"Go northwest to "..cl(37,51),
			"	a. Talk to Mekeda",
			"		i. Turn in "..cq("Before Darkness Falls"),
			completion={{questturnedin="Before Darkness Falls"}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=51208860,
		}, {
			"Find a partner or a group if you can't solo the next few things",
			mapzone="Terokkar Forest",
			level=63,
		}, {
			"Go west to "..cl(30,52),
			"	a. Click the Cabal Chest",
			"	b. Get the Gavel of K'alen",
			completion={{questgoal={"*","Gavel of K'alen",1}}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=51708140,
		}, {
			"Go east to "..cl(32,51),
			"	a. Click the Cabal Chest",
			"	b. Get the Drape of Arunen",
			completion={{questgoal={"*","Drape of Arunen",1}}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=51208330,
		}, {
			"Go north to "..cl(31,47),
			"	a. Click the Cabal Chest",
			"	b. Get the Scroll of Atalor",
			completion={{questgoal={"*","Scroll of Atalor",1}}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=46707790,
		}, {
			"Go east to "..cl(37,51),
			"	a. Talk to Mekeda",
			"		i. Turn in "..cq("The Shadow Tomb"),
			completion={{questturnedin="The Shadow Tomb"}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=51208860,
		}, {
			"Go northwest to "..cl(32,42),
			"	a. Kill arakkoas",
			"	b. Get 5 Lathrai's Stolen Goods",
			"	c. Get Veil Skith Prison Keys",
			"	d. Click the yellow cages",
			"	e. Rescue 12 Children",
			completion={{questgoal={"*","Lathrai's Stolen Goods",5}},{questgoal={"*","Children Rescued",12}}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=41707400,
		}, {
			"Go west to "..cl(31,42),
			"	a. Use the Rod of Purification on the Darkstone of Terokk",
			"	b. Purify the Darkstone of Terokk",
			completion={{questgoal={"*","Attempt to purify the Darkstone of Terrok",1}}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=42107290,
		}, {
			"Go southeast to "..cl(37,51),
			"	a. Talk to Kirrik the Awakened",
			"		i. Turn in "..cq("Veil Skith: Darkstone of Terokk"),
			"		ii. Accept "..cq("Veil Rhaze: Unliving Evil"),
			completion={{questturnedin="Veil Skith: Darkstone of Terokk"},{questaccepted="Veil Rhaze: Unliving Evil"}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=51508890,
		}, {
			"Go to "..cl(38,51),
			"	a. Talk to Ethan",
			"		i. Turn in "..cq("Missing Friends"),
			completion={{questturnedin="Missing Friends"}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=51308900,
		}, {
			"Go west to "..cl(30,51),
			"	a. Kill 4 Deathtalon Spirits",
			"	b. Kill 4 Screeching Spirits",
			"	c. Kill 2 Spirit Ravens",
			completion={{questgoal={"*","Deathtalon Spirit slain",4}},{questgoal={"*","Screeching Spirit slain",4}},{questgoal={"*","Spirit Raven slain",2}}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=51108130,
		}, {
			"Go east to "..cl(37,51),
			"	a. Talk to Kirrik the Awakened",
			"		i. Turn in "..cq("Veil Rhaze: Unliving Evil"),
			"		ii. Accept "..cq("Veil Lithic: Preemptive Strike"),
			completion={{questturnedin="Veil Rhaze: Unliving Evil"},{questaccepted="Veil Lithic: Preemptive Strike"}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=51508890,
		}, {
			"Go southwest to "..cl(24,70),
			"	a. Open the eggs on the ground",
			"	b. Redeem 3 Hatchlings",
			"	c. Kill 3 Malevolent Hatchlings",
			completion={{questgoal={"*","Hatchlings Redeemed",3}},{questgoal={"*","Malevolent Hatchling slain",3}}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=70509470,
		}, {
			"Go southeast to "..cl(31,76),
			"	a. Talk to Commander Ra'vaj",
			"		i. Accept "..cq("An Improper Burial"),
			"	b. Talk to Chief Archaeologist Letoll",
			"		i. Accept "..cq("Digging Through Bones"),
			"		ii. Escort the Archaeologists",
			"	c. Talk to Dwarfowitz",
			"		i. Turn in "..cq("Digging Through Bones"),
			completion={{questaccepted="An Improper Burial"},{questaccepted="Digging Through Bones"},{questgoal={"*","Protect the Explorers",1}},{questturnedin="Digging Through Bones"}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=76110710,
		}, {
			"Go east to "..cl(35,76),
			"	a. Use your Sha'tari Torch on corpses",
			"	b. Burn 8 Slain Sha'tar Vindicator corpses",
			"	c. Burn 8 Slain Auchenai Warrior corpses",
			completion={{questgoal={"*","Slain Sha'tar Vindicator corpse burned",8}},{questgoal={"*","Slain Auchenai Warrior corpse burned",8}}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=76511150,
		}, {
			"Go west to "..cl(31,76),
			"	a. Talk to Commander Ra'vaj",
			"		i. Turn in "..cq("An Improper Burial"),
			"		ii. Accept "..cq("A Hero Is Needed"),
			completion={{questturnedin="An Improper Burial"},{questaccepted="A Hero Is Needed"}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=76110710,
		}, {
			"Go east to "..cl(37,74),
			"	a. Kill 12 Auchenai Initiates",
			"	b. Kill 5 Auchenai Doomsayers",
			completion={{questgoal={"*","Auchenai Initiate slain",12}},{questgoal={"*","Auchenai Doomsayer slain",5}}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=74411110,
		}, {
			"Go west to "..cl(31,76),
			"	a. Talk to Commander Ra'vaj",
			"		i. Turn in "..cq("A Hero Is Needed"),
			"		ii. Accept "..cq("The Fallen Exarch"),
			completion={{questturnedin="A Hero Is Needed"},{questaccepted="The Fallen Exarch"}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=76110710,
		}, {
			"Go northeast to "..cl(36,66),
			"	a. Click the black coffin",
			"	b. Kill the Reanimated Exarch that appears",
			completion={{questgoal={"*","Contents of the Auchenai Coffin destroyed",1}},{questgoal={"*","Reanimated Exarch slain",1}}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=65710160,
		}, {
			"Go southwest to "..cl(31,76),
			"	a. Talk to Commander Ra'vaj",
			"		i. Turn in "..cq("The Fallen Exarch"),
			completion={{questturnedin="The Fallen Exarch"}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=76110710,
		}, {
			"Go northeast to "..cl(37,51),
			"	a. Talk to Kirrik the Awakened",
			"		i. Turn in "..cq("Veil Lithic: Preemptive Strike"),
			"		ii. Accept "..cq("Veil Shalas: Signal Fires"),
			completion={{questturnedin="Veil Lithic: Preemptive Strike"},{questaccepted="Veil Shalas: Signal Fires"}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=51508890,
		}, {
			"Also at "..cl(37,51),
			"	a. Talk to High Priest Orglum",
			"		i. Accept "..cq("The Tomb of Lights"),
			completion={{questaccepted="The Tomb of Lights"}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=50808830,
		}, {
			"Go southeast to "..cl(46,57),
			"	a. Kill 10 Ethereal Nethermancers",
			"	b. Kill 10 Ethereal Plunderers",
			completion={{questgoal={"*","Ethereal Nethermancer slain",10}},{questgoal={"*","Ethereal Plunderer slain",10}}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=56510280,
		}, {
			"Go southeast to "..cl(55,66),
			"	a. The path up to Veil Shalas starts here",
			completion={{location={mapzone="Terokkar Forest",x=54.9,y=66.0, dist=0.5}}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=66112100,
		}, {
			"Go northeast to "..cl(57,65),
			"	a. The path up to the Sapphire Signal Fire starts here",
			completion={{location={mapzone="Terokkar Forest",x=57.3,y=65.0, dist=0.3}}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=65012230,
		}, {
			"Go to "..cl(55,67),
			"	a. Click the Sapphire Signal Fire",
			"	b. Extinguish the Sapphire Signal Fire",
			completion={{questgoal={"*","Sapphire Fire Extinguished",1}}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=67112230,
		}, {
			"Go southeast to "..cl(57,72),
			"	a. The path up to the Emerald Signal Fire starts here",
			completion={{location={mapzone="Terokkar Forest",x=57.0,y=71.8, dist=0.3}}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=71812880,
		}, {
			"Go to "..cl(56,70),
			"	a. Click the Emerald Signal Fire",
			"	b. Extinguish the Emerald Signal Fire",
			completion={{questgoal={"*","Emerald Fire Extinguished",1}}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=69712520,
		}, {
			"Go south to "..cl(56,73),
			"	a. The path up to the Bloodstone and Violet Signal Fires starts here",
			"	b. Go up the path",
			completion={{location={mapzone="Terokkar Forest",x=56.0,y=72.7, dist=0.3}}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=72712870,
		}, {
			"Also at "..cl(56,73),
			"	a. Click the Bloodstone Signal Fire",
			"	b. Extinguish the Bloodstone Signal Fire",
			completion={{questgoal={"*","Bloodstone Fire Extinguished",1}}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=72412850,
		}, {
			"Go to "..cl(57,69),
			"	a. Click the Violet Signal Fire",
			"	b. Extinguish the Violet Signal Fire",
			completion={{questgoal={"*","Violet Fire Extinguished",1}}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=69212590,
		}, {
			"Go northwest to "..cl(37,51),
			"	a. Talk to Kirrik the Awakened",
			"		i. Turn in "..cq("Veil Shalas: Signal Fires"),
			"		ii. Accept "..cq("Return to Shattrath"),
			"	b. Talk to High Priest Orglum",
			"		i. Turn in "..cq("The Tomb of Lights"),
			completion={{questturnedin="Veil Shalas: Signal Fires"},{questaccepted="Return to Shattrath"},{questturnedin="The Tomb of Lights"}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=51508890,
		}, {
			"Go east to Allerian Stronghold",
			completion={{location={mapzone="Terokkar Forest",x=57.5,y=54.2, dist=3}}},
			mapzone="Terokkar Forest",
			level=63,
		}, {
			"Go to "..cl(57,55),
			"	a. Click the Wanted Poster",
			"		i. Accept "..cq("Wanted: Bonelashers Dead!"),
			completion={{questaccepted="Wanted: Bonelashers Dead!"}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=54711230,
		}, {
			"Also at "..cl(57,55),
			"	a. Talk to Ros'eleth",
			"		i. Accept "..cq("Olemba Seeds"),
			completion={{questaccepted="Olemba Seeds"}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=55411280,
		}, {
			"Go to "..cl(58,56),
			"	a. Talk to Lieutenant Gravelhammer",
			"		i. Accept "..cq("Speak with Private Weeks"),
			"		ii. Accept "..cq("Thin the Flock"),
			completion={{questaccepted="Speak with Private Weeks"},{questaccepted="Thin the Flock"}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=55811330,
		}, {
			"Go to "..cl(58,54),
			"	a. Talk to Thander",
			"		i. Accept "..cq("Stymying the Arakkoa"),
			completion={{questaccepted="Stymying the Arakkoa"}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=54311210,
		}, {
			"Go to "..cl(58,55),
			"	a. Talk to Bertelm",
			"		i. Accept "..cq("Unruly Neighbors"),
			"		ii. Accept "..cq("Timber Worg Tails"),
			completion={{questaccepted="Unruly Neighbors"},{questaccepted="Timber Worg Tails"}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=54811310,
		}, {
			"Go to "..cl(59,54),
			"	a. Talk to Andarl",
			"		i. Turn in "..cq("The Fate of Tuurem"),
			"		ii. Accept "..cq("Magical Disturbances"),
			completion={{questturnedin="The Fate of Tuurem"},{questaccepted="Magical Disturbances"}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=53611210,
		}, {
			"Make Allerian Stronghold your home",
			completion={{home="Allerian Stronghold"}},
			mapzone="Terokkar Forest",
			level=63,
		}, {
			"Go to "..cl(60,55),
			"	a. Talk to Furnan Skysoar",
			"		i. Get the Allerian Stronghold Flight Path",
			completion={{flightpath="Allerian Stronghold"}},
			mapzone="Terokkar Forest",
			level=63,
			mapnote=55411480,
		}, {
			"Fly to Shattrath City",
			completion={{location={mapzone="Shattrath City"}}},
			mapzone="Terokkar Forest",
			level=63,
		}, {
			"Go to "..cl(72,31),
			"	a. Talk to Wind Trader Lathrai",
			"		i. Turn in "..cq("A Personal Favor"),
			"		ii. Accept "..cq("Investigate Tuurem"),
			completion={{questturnedin="A Personal Favor"},{questaccepted="Investigate Tuurem"}},
			mapzone="Shattrath City",
			level=63,
			mapnote=30710290,
		}, {
			"You may need help with the next step",
			mapzone="Shattrath City",
			level=63,
		}, {
			"Go to "..cl(53,21),
			"	a. Talk to Rilak the Redeemed",
			"		i. Turn in "..cq("Return to Shattrath"),
			"	b. Talk to Defender Grashna",
			"		i. Accept "..cq("The Skettis Offensive"),
			"	c. Kill the little birds that come to attack",
			"	d. Kill the big bird that attacks last",
			"	e. Thwart the Attack",
			"	f. Talk to Rilak the Redeemed",
			"		i. Turn in "..cq("The Skettis Offensive"),
			completion={{questturnedin="Return to Shattrath"},{questaccepted="The Skettis Offensive"},{questgoal={"*","Attack thwarted",1}},{questturnedin="The Skettis Offensive"}},
			mapzone="Shattrath City",
			level=63,
			mapnote=21007360,
		}, {
			"Go to "..cl(31,35),
			"	a. Talk to Adyen the Lightwarden",
			"		i. Turn in "..cq("Marks of Kil'jaeden"),
			"		ii. Turn in all your Marks of Kil'jaeden now",
			completion={{questturnedin="Marks of Kil'jaeden"}},
			mapzone="Shattrath City",
			level=63,
			mapnote=34606530,
		}, {
			"Fly to Allerian Stronghold",
			completion={{location={mapzone="Terokkar Forest",x=57.5,y=54.2, dist=3}}},
			mapzone="Shattrath City",
			level=63,
		}, {
			"Grind to level 64",
			completion={{level=64}},
			mapzone="Terokkar Forest",
			level=63,
		}
	  },
	},
	{ sectiontitle = "Levels (64-66)",
	  steps = {
		{
			"Go west to "..cl(42,52),
			"	a. Kill 20 Bonelashers",
			completion={{questgoal={"*","Bonelasher slain",20}}},
			mapzone="Terokkar Forest",
			level=64,
			mapnote=51609320,
		}, {
			"Go northwest to "..cl(35,43),
			"	a. Click the Olemba Cones",
			"	b. Get 30 Olemba Seeds",
			"	c. Kill Timber Worg Alphas",
			"	d. Get 12 Timber Worg Tails",
			"	e. Kill 10 Warp Stalkers",
			completion={{questgoal={"*","Olemba Seed",30}},{questgoal={"*","Timber Worg Tail",12}},{questgoal={"*","Warp Stalker slain",10}}},
			mapzone="Terokkar Forest",
			level=64,
			mapnote=42807770,
		}, {
			"Go west to "..cl(30,42),
			"	a. The path up to Urdak starts here",
			completion={{location={mapzone="Terokkar Forest",x=30.1,y=42.5, dist=0.3}}},
			mapzone="Terokkar Forest",
			level=64,
			mapnote=42407250,
		}, {
			"Go to "..cl(31,43),
			"	a. Kill Urdak",
			completion={{questgoal={"*","Urdak slain",1}}},
			mapzone="Terokkar Forest",
			level=64,
			mapnote=42507390,
		}, {
			"Go northeast to "..cl(41,36),
			"	a. Talk to Private Weeks",
			"		i. Turn in "..cq("Speak with Private Weeks"),
			"		ii. Accept "..cq("Who Are They?"),
			completion={{questturnedin="Speak with Private Weeks"},{questaccepted="Who Are They?"}},
			mapzone="Terokkar Forest",
			level=64,
			mapnote=36207670,
		}, {
			"He puts an orc disguise on you",
			"	a. Be careful, the hunter in the camp can see through the disguise",
			"		i. The hunter is the guy walking around the camp with a group of mobs",
			mapzone="Terokkar Forest",
			level=64,
		}, {
			"Go south to "..cl(40,39),
			"	a. Talk to the Shadowy Advisor",
			completion={{questgoal={"*","Shadowy Advisor Spoken To",1}}},
			mapzone="Terokkar Forest",
			level=64,
			mapnote=39107940,
		}, {
			"Go west to "..cl(39,40),
			"	a. Talk to the Shadowy Initiate",
			completion={{questgoal={"*","Shadowy Initiate Spoken To",1}}},
			mapzone="Terokkar Forest",
			level=64,
			mapnote=39707870,
		}, {
			"Go west to "..cl(38,39),
			"	a. Talk to the Shadowy Laborer",
			completion={{questgoal={"*","Shadowy Laborer Spoken To",1}}},
			mapzone="Terokkar Forest",
			level=64,
			mapnote=39307770,
		}, {
			"Go northeast to "..cl(41,36),
			"	a. Talk to Private Weeks",
			"		i. Turn in "..cq("Who Are They?"),
			"		ii. Accept "..cq("Kill the Shadow Council!"),
			completion={{questturnedin="Who Are They?"},{questaccepted="Kill the Shadow Council!"}},
			mapzone="Terokkar Forest",
			level=64,
			mapnote=36207670,
		}, {
			"Go south to "..cl(40,41),
			"	a. Kill 10 Shadowy Executioners",
			"	b. Kill 10 Shadowy Summoners",
			completion={{questgoal={"*","Shadowy Executioner slain",10}},{questgoal={"*","Shadowy Summoner slain",10}}},
			mapzone="Terokkar Forest",
			level=64,
			mapnote=40808060,
		}, {
			"Go north to "..cl(40,39),
			"	a. Kill Shadowmaster Grieve",
			completion={{questgoal={"*","Shadowmaster Grieve slain",1}}},
			mapzone="Terokkar Forest",
			level=64,
			mapnote=39107940,
		}, {
			"Go northeast to "..cl(54,30),
			"	a. Click the Sealed Box",
			"	b. Get the Sealed Box",
			completion={{questgoal={"*","Sealed Box",1}}},
			mapzone="Terokkar Forest",
			level=64,
			mapnote=30008400,
		}, {
			"Go west to "..cl(44,26),
			"	a. Talk to Earthbinder Tavgren",
			"		i. Turn in "..cq("Investigate Tuurem"),
			"		ii. Accept "..cq("What Are These Things?"),
			completion={{questturnedin="Investigate Tuurem"},{questaccepted="What Are These Things?"}},
			mapzone="Terokkar Forest",
			level=64,
			mapnote=26307060,
		}, {
			"Go northeast to "..cl(49,18),
			"	a. Kill 14 Shienor Talonites",
			"	b. Kill 6 Shienor Sorcerers",
			completion={{questgoal={"*","Shienor Talonite slain",14}},{questgoal={"*","Shienor Sorcerer slain",6}}},
			mapzone="Terokkar Forest",
			level=64,
			mapnote=17306620,
		}, {
			"Go northeast to "..cl(50,16),
			"	a. The path up to Ashkaz starts here",
			completion={{location={mapzone="Terokkar Forest",x=49.9,y=16.5, dist=0.3}}},
			mapzone="Terokkar Forest",
			level=64,
			mapnote=16506640,
		}, {
			"Go to "..cl(49,17),
			"	a. Kill Ashkaz",
			completion={{questgoal={"*","Ashkaz slain",1}}},
			mapzone="Terokkar Forest",
			level=64,
			mapnote=16906600,
		}, {
			"Go southeast to "..cl(59,23),
			"	a. Kill Ayit",
			completion={{questgoal={"*","Ayit slain",1}}},
			mapzone="Terokkar Forest",
			level=64,
			mapnote=23408280,
		}, {
			"Go southeast to "..cl(65,51),
			"	a. Kill 12 Warped Peons",
			completion={{questgoal={"*","Warped Peon slain",12}}},
			mapzone="Terokkar Forest",
			level=64,
			mapnote=50611610,
		}, {
			"Go northeast to "..cl(70,44),
			"	a. Talk to Theloria Shadecloak",
			"		i. Turn in "..cq("Unruly Neighbors"),
			"		ii. Accept "..cq("The Firewing Liaison"),
			"		iii. Accept "..cq("Thinning the Ranks"),
			completion={{questturnedin="Unruly Neighbors"},{questaccepted="The Firewing Liaison"},{questaccepted="Thinning the Ranks"}},
			mapzone="Terokkar Forest",
			level=64,
			mapnote=44211390,
		}, {
			"Go south to "..cl(69,53),
			"	a. Kill 10 Bonechewer Devastators",
			"	b. Kill 6 Bonechewer Backbreakers",
			completion={{questgoal={"*","Bonechewer Devastator slain",10}},{questgoal={"*","Bonechewer Backbreaker slain",6}}},
			mapzone="Terokkar Forest",
			level=64,
			mapnote=53012210,
		}, {
			"Go west to "..cl(68,53),
			"	a. Kill Lisaile Fireweaver",
			completion={{questgoal={"*","Lisaile Fireweaver slain",1}}},
			mapzone="Terokkar Forest",
			level=64,
			mapnote=53212120,
		}, {
			"Go northeast to "..cl(70,44),
			"	a. Talk to Theloria Shadecloak",
			"		i. Turn in "..cq("The Firewing Liaison"),
			"		ii. Turn in "..cq("Thinning the Ranks"),
			completion={{questturnedin="The Firewing Liaison"},{questturnedin="Thinning the Ranks"}},
			mapzone="Terokkar Forest",
			level=64,
			mapnote=44211390,
		}, {
			"Hearth to Allerian Stronghold",
			completion={{location={mapzone="Terokkar Forest",x=57.5,y=54.2, dist=3}}},
			mapzone="Terokkar Forest",
			level=64,
		}, {
			"Go to "..cl(57,54),
			"	a. Talk to Jenai Starwhisper",
			"		i. Turn in "..cq("What Are These Things?"),
			"		ii. Accept "..cq("Report to the Allerian Post"),
			completion={{questturnedin="What Are These Things?"},{questaccepted="Report to the Allerian Post"}},
			mapzone="Terokkar Forest",
			level=64,
			mapnote=53511050,
		}, {
			"Go to "..cl(57,55),
			"	a. Talk to Ros'eleth",
			"		i. Turn in "..cq("Olemba Seeds"),
			"		ii. Accept "..cq("Vessels of Power"),
			completion={{questturnedin="Olemba Seeds"},{questaccepted="Vessels of Power"}},
			mapzone="Terokkar Forest",
			level=64,
			mapnote=55411280,
		}, {
			"Go to "..cl(58,56),
			"	a. Talk to Lieutenant Gravelhammer",
			"		i. Turn in "..cq("Kill the Shadow Council!"),
			"		ii. Turn in "..cq("Thin the Flock"),
			completion={{questturnedin="Kill the Shadow Council!"},{questturnedin="Thin the Flock"}},
			mapzone="Terokkar Forest",
			level=64,
			mapnote=55811330,
		}, {
			"Go to "..cl(58,54),
			"	a. Talk to Thander",
			"		i. Turn in "..cq("Stymying the Arakkoa"),
			completion={{questturnedin="Stymying the Arakkoa"}},
			mapzone="Terokkar Forest",
			level=64,
			mapnote=54311210,
		}, {
			"Go to "..cl(58,55),
			"	a. Talk to Bertelm",
			"		i. Turn in "..cq("Timber Worg Tails"),
			"		ii. Accept "..cq("The Elusive Ironjaw"),
			completion={{questturnedin="Timber Worg Tails"},{questaccepted="The Elusive Ironjaw"}},
			mapzone="Terokkar Forest",
			level=64,
			mapnote=54811310,
		}, {
			"Go to "..cl(59,54),
			"	a. Talk to Andarl",
			"		i. Turn in "..cq("Magical Disturbances"),
			completion={{questturnedin="Magical Disturbances"}},
			mapzone="Terokkar Forest",
			level=64,
			mapnote=53611210,
		}, {
			"Go to "..cl(58,53),
			"	a. Talk to Taela Everstride",
			"		i. Turn in "..cq("Wanted: Bonelashers Dead!"),
			completion={{questturnedin="Wanted: Bonelashers Dead!"}},
			mapzone="Terokkar Forest",
			level=64,
			mapnote=53411150,
		}, {
			"Go northeast to "..cl(70,44),
			"	a. Talk to Lieutenant Meridan",
			"		i. Turn in "..cq("Report to the Allerian Post"),
			"		ii. Accept "..cq("Attack on Firewing Point"),
			completion={{questturnedin="Report to the Allerian Post"},{questaccepted="Attack on Firewing Point"}},
			mapzone="Terokkar Forest",
			level=64,
			mapnote=44211390,
		}, {
			"Go northwest to "..cl(66,35),
			"	a. Kill Ironjaw",
			"	b. Get Ironjaw's Pelt",
			completion={{questgoal={"*","Ironjaw's Pelt",1}}},
			mapzone="Terokkar Forest",
			level=64,
			mapnote=34710100,
		}, {
			"Go southeast to "..cl(68,37),
			"	a. Kill 10 Firewing Defenders",
			"	b. Kill 10 Firewing Bloodwarders",
			"	c. Kill 10 Firewing Warlocks",
			completion={{questgoal={"*","Firewing Defender slain",10}},{questgoal={"*","Firewing Bloodwarder slain",10}},{questgoal={"*","Firewing Warlock slain",10}}},
			mapzone="Terokkar Forest",
			level=64,
			mapnote=36510460,
		}, {
			"Go northeast to "..cl(74,35),
			"	a. Talk to Isla Starmane",
			"		i. Accept "..cq("Escape from Firewing Point!"),
			"		ii. Escort Isla Starmane to safety",
			completion={{questaccepted="Escape from Firewing Point!"},{questgoal={"*","Escort Isla Starmane to safety",1}}},
			mapzone="Terokkar Forest",
			level=64,
			mapnote=35210910,
		}, {
			"Go northwest to "..cl(54,32),
			"	a. Click the Draenei Vessels on the ground",
			"	b. Get 8 Draenei Vessels",
			completion={{questgoal={"*","Draenei Vessel",8}}},
			mapzone="Terokkar Forest",
			level=64,
			mapnote=32108620,
		}, {
			"Hearth to Allerian Stronghold",
			completion={{location={mapzone="Terokkar Forest",x=57.5,y=54.2, dist=3}}},
			mapzone="Terokkar Forest",
			level=64,
		}, {
			"Go to "..cl(57,55),
			"	a. Talk to Ros'eleth",
			"		i. Turn in "..cq("Vessels of Power"),
			completion={{questturnedin="Vessels of Power"}},
			mapzone="Terokkar Forest",
			level=64,
			mapnote=55411280,
		}, {
			"Go to "..cl(57,56),
			"	a. Talk to Captain Auric Sunchaser",
			"		i. Turn in "..cq("Escape from Firewing Point!"),
			completion={{questturnedin="Escape from Firewing Point!"}},
			mapzone="Terokkar Forest",
			level=64,
			mapnote=55711290,
		}, {
			"Go to "..cl(58,55),
			"	a. Talk to Bertelm",
			"		i. Turn in "..cq("The Elusive Ironjaw"),
			completion={{questturnedin="The Elusive Ironjaw"}},
			mapzone="Terokkar Forest",
			level=64,
			mapnote=54811310,
		}, {
			"Go northeast to "..cl(70,44),
			"	a. Talk to Lieutenant Meridian",
			"		i. Turn in "..cq("Attack on Firewing Point"),
			"		ii. Accept "..cq("The Final Code"),
			completion={{questturnedin="Attack on Firewing Point"},{questaccepted="The Final Code"}},
			mapzone="Terokkar Forest",
			level=64,
			mapnote=44211390,
		}, {
			"Go northeast to "..cl(73,34),
			"	a. Click the Orb of Translocation",
			"	b. It will teleport you to the top of the tower",
			mapzone="Terokkar Forest",
			level=64,
			mapnote=34610790,
		}, {
			"Go to "..cl(74,36),
			"	a. Kill Sharth Voldoun",
			"	b. Get the Final Code",
			completion={{item={"The Final Code",1}}},
			mapzone="Terokkar Forest",
			level=64,
			mapnote=35810970,
		}, {
			"Go to "..cl(74,37),
			"	a. Click the Orb of Translocation",
			"	b. It will teleport you to the bottom of the tower",
			mapzone="Terokkar Forest",
			level=64,
			mapnote=36511070,
		}, {
			"Go west to "..cl(71,34),
			"	a. Click the Mana Bomb",
			"	b. Activate the Mana Bomb using the Final Code",
			completion={{questgoal={"*","Mana Bomb Activated",1}}},
			mapzone="Terokkar Forest",
			level=64,
			mapnote=37410870,
		}, {
			"Go southwest to Allerian Stronghold",
			completion={{location={mapzone="Terokkar Forest",x=57.5,y=54.2, dist=3}}},
			mapzone="Terokkar Forest",
			level=64,
		}, {
			"Go to "..cl(57,54),
			"	a. Talk to Jenai Starwhisper",
			"		i. Turn in "..cq("The Final Code"),
			"		ii. Accept "..cq("Letting Earthbinder Tavgren Know"),
			completion={{questturnedin="The Final Code"},{questaccepted="Letting Earthbinder Tavgren Know"}},
			mapzone="Terokkar Forest",
			level=64,
			mapnote=53511050,
		}, {
			"Fly to Shattrath City",
			completion={{location={mapzone="Shattrath City"}}},
			mapzone="Terokkar Forest",
			level=64,
		}, {
			"Leave Shattrath City and go outside",
			completion={{location={mapzone="Terokkar Forest"}}},
			mapzone="Shattrath City",
			level=64,
		}, {
			"Go east to "..cl(44,26),
			"	a. Talk to Earthbinder Tavgren",
			"		i. Turn in "..cq("Letting Earthbinder Tavgren Know"),
			completion={{questturnedin="Letting Earthbinder Tavgren Know"}},
			mapzone="Terokkar Forest",
			level=64,
			mapnote=26307060,
		}, {

			"Go west to Shattrath City",
			completion={{location={mapzone="Shattrath City"}}},
			mapzone="Terokkar Forest",
			level=64,
		}, {
			"Fly to Orebor Harborage",
			completion={{location={mapzone="Zangarmarsh",x=41.8,y=26.6, dist=4}}},
			mapzone="Shattrath City",
			level=64,
		}, {
			"Go to "..cl(42,27),
			"	a. Talk to Ikuti",
			"		i. Accept "..cq("A Message to Telaar"),
			completion={{questaccepted="A Message to Telaar"}},
			mapzone="Zangarmarsh",
			level=64,
			mapnote=27206910,
		}, {
			"Fly to to Telredor",
			completion={{location={mapzone="Zangarmarsh",x=68.3,y=49.2, dist=2}}},
			mapzone="Zangarmarsh",
			level=64,
		}, {
			"Go south to Nagrand",
			completion={{location={mapzone="Nagrand"}}},
			mapzone="Zangarmarsh",
			level=64,
		}, {
			"Go southwest to "..cl(71,41),
			"	a. Talk to Shado 'Fitz' Farstrider",
			"		i. Accept "..cq("Windroc Mastery part 1"),
			"	b. Talk to Hemet Nesingwary",
			"		i. Accept "..cq("Clefthoof Mastery part 1"),
			"	c. Talk to Harold Lane",
			"		i. Accept "..cq("Talbuk Mastery part 1"),
			completion={{questaccepted="Windroc Mastery part 1"},{questaccepted="Clefthoof Mastery part 1"},{questaccepted="Talbuk Mastery part 1"}},
			mapzone="Nagrand",
			level=64,
			mapnote=40511210,
		}, {
			"Go north to "..cl(72,39),
			"	a. Kill 30 Talbuk Stags",
			completion={{questgoal={"*","Talbuk Stag slain",30}}},
			mapzone="Nagrand",
			level=64,
			mapnote=38411060,
		}, {
			"Go west to "..cl(66,39),
			"	a. Kill 30 Windrocs",
			completion={{questgoal={"*","Windroc slain",30}}},
			mapzone="Nagrand",
			level=64,
			mapnote=39510600,
		}, {
			"Go southwest to "..cl(64,45),
			"	a. Kill 30 Clefthoofs",
			"	b. Kill Dust Howlers",
			"	c. Get a Howling Wind",
			"	d. Click the Howling Wind",
			"		i. Accept "..cq("The Howling Wind"),
			"	e. Kill Elekks",
			"	f. Get 3 Pair of Ivory Tusks",
			completion={{questgoal={"*","Clefthoof slain",30}},{item={"Pair of Ivory Tusks",3}},{questaccepted="The Howling Wind"}},
			mapzone="Nagrand",
			level=64,
			mapnote=45110910,
		}, {
			"Go northeast to "..cl(71,41),
			"	a. Talk to Shado 'Fitz' Farstrider",
			"		i. Turn in "..cq("Windroc Mastery part 1"),
			"		ii. Accept "..cq("Windroc Mastery part 2"),
			"	b. Talk to Hemet Nesingwary",
			"		i. Turn in "..cq("Clefthoof Mastery part 1"),
			"		ii. Accept "..cq("Clefthoof Mastery part 2"),
			"	c. Talk to Harold Lane",
			"		i. Turn in "..cq("Talbuk Mastery part 1"),
			"		ii. Accept "..cq("Talbuk Mastery part 2"),
			completion={{questturnedin="Windroc Mastery part 1"},{questaccepted="Windroc Mastery part 2"},{questturnedin="Clefthoof Mastery part 1"},{questaccepted="Clefthoof Mastery part 2"},{questturnedin="Talbuk Mastery part 1"},{questaccepted="Talbuk Mastery part 2"}},
			mapzone="Nagrand",
			level=64,
			mapnote=40511210,
		}, {
			"Go northwest to the Throne of the Elements",
			completion={{location={mapzone="Nagrand",x=60.8,y=22.4, dist=4}}},
			mapzone="Nagrand",
			level=64,
		}, {
			"Go to "..cl(61,22),
			"	a. Talk to Elementalist Morgh",
			"		i. Turn in "..cq("The Howling Wind"),
			"		ii. Accept "..cq("Murkblood Corrupters"),
			"	b. Talk to Elementalist Untrag",
			"		i. Accept "..cq("The Underneath"),
			"	c. Talk to Elementalist Lo'ap",
			"		i. Accept "..cq("A Rare Bean"),
			"		ii. Accept "..cq("Muck Diving"),
			completion={{questturnedin="The Howling Wind"},{questaccepted="Murkblood Corrupters"},{questaccepted="The Underneath"},{questaccepted="A Rare Bean"},{questaccepted="Muck Diving"}},
			mapzone="Nagrand",
			level=64,
			mapnote=22408290,
		}, {
			"Go to "..cl(62,24),
			"	a. Talk to Gordawg",
			"		i. Turn in "..cq("The Underneath"),
			"		ii. Accept "..cq("The Tortured Earth"),
			completion={{questturnedin="The Underneath"},{questaccepted="The Tortured Earth"}},
			mapzone="Nagrand",
			level=64,
			mapnote=24408620,
		}, {
			"Go west to "..cl(52,25),
			"	a. Click the Dung on the ground",
			"	b. Get 15 Digested Caracoli",
			"	c. Kill 30 Talbuk Thorngrazers",
			completion={{questgoal={"*","Digested Caracoli",15}},{questgoal={"*","Talbuk Thorngrazer slain",30}}},
			mapzone="Nagrand",
			level=64,
			mapnote=25607770,
		}, {
			"Go south to "..cl(51,31),
			"	a. Kill 30 Clefthoof Bulls",
			completion={{questgoal={"*","Clefthoof Bull slain",30}}},
			mapzone="Nagrand",
			level=64,
			mapnote=30808240,
		}, {
			"Go southwest to Halaa if it is under Alliance control",
			completion={{location={mapzone="Nagrand",x=42.5,y=44.0, dist=4}}},
			mapzone="Nagrand",
			level=64,
		}, {
			"Go to "..cl(41,44),
			"	a. Talk to Chief Researcher Kartos",
			"		i. Accept "..cq("Oshu'gun Crystal Powder"),
			"		ii. Turn in "..cq("Oshu'gun Crystal Powder"),
			completion={{questaccepted="Oshu'gun Crystal Powder"},{questturnedin="Oshu'gun Crystal Powder"}},
			mapzone="Nagrand",
			level=64,
			mapnote=44308550,
		}, {
			"Go north to "..cl(42,41),
			"	a. Kill Muck Spawns in the water",
			"	b. Get 5 Muck-ridden Cores",
			completion={{questgoal={"*","Muck-ridden Core",5}}},
			mapzone="Nagrand",
			level=64,
			mapnote=40908240,
		}, {
			"Go west to "..cl(34,44),
			"	a. Kill 8 Murkblood Putrifiers",
			completion={{questgoal={"*","Murkblood Putrifier slain",8}}},
			mapzone="Nagrand",
			level=64,
			mapnote=43707750,
		}, {
			"Grind to level 65",
			completion={{level=65}},
			mapzone="Nagrand",
			level=64,
		}, {
			"Go south to "..cl(31,58),
			"	a. Talk to Zerid",
			"		i. Accept "..cq("Gava'xi"),
			"		ii. Accept "..cq("Matters of Security"),
			completion={{questaccepted="Gava'xi"},{questaccepted="Matters of Security"}},
			mapzone="Nagrand",
			level=65,
			mapnote=58108890,
		}, {
			"Also at "..cl(31,58),
			"	a. Talk to Gezhe",
			"		i. Accept "..cq("Stealing from Thieves"),
			completion={{questaccepted="Stealing from Thieves"}},
			mapzone="Nagrand",
			level=65,
			mapnote=57808920,
		}, {
			"Go to "..cl(32,57),
			"	a. Talk to Shadrek",
			"		i. Accept "..cq("A Head Full of Ivory"),
			"		ii. Turn in "..cq("A Head Full of Ivory"),
			"		iii. Turn in any more Pairs of Ivory Tusks you have",
			completion={{questaccepted="A Head Full of Ivory"},{questturnedin="A Head Full of Ivory"}},
			mapzone="Nagrand",
			level=65,
			mapnote=56808860,
		}, {
			"Go southeast to "..cl(33,62),
			"	a. Click the Oshu'gun Crystal Fragments on the ground",
			"	b. Kill the mobs here",
			"	c. Get 10 Oshu'gun Crystal Fragments",
			completion={{questgoal={"*","Oshu'gun Crystal Fragment",10}}},
			mapzone="Nagrand",
			level=65,
			mapnote=62409580,
		}, {
			"Go southwest to "..cl(31,67),
			"	a. Kill 12 Voidspawns",
			completion={{questgoal={"*","Voidspawn slain",12}}},
			mapzone="Nagrand",
			level=65,
			mapnote=67509810,
		}, {
			"Go southeast to "..cl(42,74),
			"	a. Kill Gava'xi",
			completion={{questgoal={"*","Gava'xi slain",1}}},
			mapzone="Nagrand",
			level=65,
			mapnote=73511590,
		}, {
			"Go northeast to "..cl(48,61),
			"	a. Kill 30 Ravenous Windrocs",
			completion={{questgoal={"*","Ravenous Windroc slain",30}}},
			mapzone="Nagrand",
			level=65,
			mapnote=61510990,
		}, {
			"Go west to "..cl(31,58),
			"	a. Talk to Zerid",
			"		i. Turn in "..cq("Gava'xi"),
			"		ii. Turn in "..cq("Matters of Security"),
			completion={{questturnedin="Gava'xi"},{questturnedin="Matters of Security"}},
			mapzone="Nagrand",
			level=65,
			mapnote=58108890,
		}, {
			"Also at "..cl(31,58),
			"	a. Talk to Gezhe",
			"		i. Turn in "..cq("Stealing from Thieves"),
			completion={{questturnedin="Stealing from Thieves"}},
			mapzone="Nagrand",
			level=65,
			mapnote=57808920,
		}, {
			"Go southeast to Telaar",
			completion={{location={mapzone="Nagrand",x=54.4,y=72.8, dist=5}}},
			mapzone="Nagrand",
			level=65,
		}, {
			"Go to "..cl(56,72),
			"	a. Talk to Huntress Kima",
			"		i. Accept "..cq("The Ravaged Caravan"),
			completion={{questaccepted="The Ravaged Caravan"}},
			mapzone="Nagrand",
			level=65,
			mapnote=70012420,
		}, {
			"Go to "..cl(56,69),
			"	a. Talk to Elementalist Ioki",
			"		i. Accept "..cq("The Throne of the Elements"),
			completion={{questaccepted="The Throne of the Elements"}},
			mapzone="Nagrand",
			level=65,
			mapnote=68812430,
		}, {
			"Go to "..cl(55,71),
			"	a. Talk to Huntress Bintook",
			"		i. Accept "..cq("Do My Eyes Deceive Me"),
			completion={{questaccepted="Do My Eyes Deceive Me"}},
			mapzone="Nagrand",
			level=65,
			mapnote=70512550,
		}, {
			"Also at "..cl(55,71),
			"	a. Click the Telaar Bulletin Board",
			"		i. Accept "..cq("Wanted: Giselda the Crone"),
			"		ii. Accept "..cq("Wanted: Zorbo the Advisor"),
			completion={{questaccepted="Wanted: Giselda the Crone"},{questaccepted="Wanted: Zorbo the Advisor"}},
			mapzone="Nagrand",
			level=65,
			mapnote=70712530,
		}, {
			"Also at "..cl(55,71),
			"	a. Talk to Warden Iolol",
			"		i. Accept "..cq("Fierce Enemies"),
			"	b. Talk to Nahuud",
			"		i. Turn in "..cq("A Message to Telaar"),
			completion={{questaccepted="Fierce Enemies"},{questturnedin="A Message to Telaar"}},
			mapzone="Nagrand",
			level=65,
			mapnote=71012580,
		}, {
			"Go to "..cl(54,72),
			"	a. Talk to Otonbu the Sage",
			"		i. Accept "..cq("Stopping the Spread"),
			"	b. Talk to Poli'lukluk the Wiser",
			"		i. Accept "..cq("Solving the Problem"),
			completion={{questaccepted="Stopping the Spread"},{questaccepted="Solving the Problem"}},
			mapzone="Nagrand",
			level=65,
			mapnote=72212670,
		}, {
			"Go to "..cl(54,75),
			"	a. Talk to Furgu",
			"		i. Get the Telaar Flight Path",
			completion={{flightpath="Telaar"}},
			mapzone="Nagrand",
			level=65,
			mapnote=75112930,
		}, {
			"Go northeast to "..cl(62,67),
			"	a. Talk to Wazat",
			"		i. Accept "..cq("I Must Have Them!"),
			completion={{questaccepted="I Must Have Them!"}},
			mapzone="Nagrand",
			level=65,
			mapnote=67112880,
		}, {
			"Go southeast to "..cl(63,73),
			"	a. Kill Boulderfist Hunters",
			"	b. Get the Boulderfist Plans",
			"	c. Get some of the 10 Obsidian Warbeads you need",
			completion={{questgoal={"*","Boulderfist Plans",1}}},
			mapzone="Nagrand",
			level=65,
			mapnote=73213630,
		}, {
			"Go northeast to "..cl(65,71),
			"	a. Kill 15 Tortured Earth Spirits",
			completion={{questgoal={"*","Tortured Earth Spirit slain",15}}},
			mapzone="Nagrand",
			level=65,
			mapnote=70813620,
		}, {
			"Go southeast to "..cl(68,79),
			"	a. Kill 15 Kil'sorrow mobs",
			completion={{questgoal={"*","Kil'sorrow Agent slain",15}}},
			mapzone="Nagrand",
			level=65,
			mapnote=79314720,
		}, {
			"Go southeast to "..cl(71,82),
			"	a. Kill Giselda the Crone",
			completion={{questgoal={"*","Giselda the Crone slain",1}}},
			mapzone="Nagrand",
			level=65,
			mapnote=82415350,
		}, {
			"Go north to "..cl(73,71),
			"	a. Talk to Corki",
			"		i. Accept "..cq("HELP!"),
			"	b. Kill Boulderfist ogres",
			"	c. Get a Boulderfist Key",
			"	d. Free Corki",
			completion={{questaccepted="HELP!"},{questgoal={"*","Corki Freed",1}}},
			mapzone="Nagrand",
			level=65,
			mapnote=70714330,
		}, {
			"Go northwest to "..cl(69,60),
			"	a. Kill a Dust Howlers",
			"	b. Get 3 Air Elemental Gas",
			completion={{questgoal={"*","Air Elemental Gas",3}}},
			mapzone="Nagrand",
			level=65,
			mapnote=56912630,
		}, {
			"Go northeast to "..cl(71,41),
			"	a. Talk to Harold Lane",
			"		i. Turn in "..cq("Talbuk Mastery part 2"),
			"	b. Talk to Hemet Nesingwary",
			"		i. Turn in "..cq("Clefthoof Mastery part 2"),
			"	c. Talk to Shado 'Fitz' Farstrider",
			"		i. Turn in "..cq("Windroc Mastery part 2"),
			completion={{questturnedin="Talbuk Mastery part 2"},{questturnedin="Clefthoof Mastery part 2"},{questturnedin="Windroc Mastery part 2"}},
			mapzone="Nagrand",
			level=65,
			mapnote=40511210,
		}, {
			"Go northwest to the Throne of the Elements",
			completion={{location={mapzone="Nagrand",x=60.8,y=22.4, dist=4}}},
			mapzone="Nagrand",
			level=65,
		}, {
			"Go to "..cl(62,25),
			"	a. Talk to Gordawg",
			"		i. Turn in "..cq("The Tortured Earth"),
			"		ii. Accept "..cq("Eating Damnation"),
			completion={{questturnedin="The Tortured Earth"},{questaccepted="Eating Damnation"}},
			mapzone="Nagrand",
			level=65,
			mapnote=24408620,
		}, {
			"Go to "..cl(60,23),
			"	a. Talk to Elementalist Lo'ap",
			"		i. Turn in "..cq("A Rare Bean"),
			"		ii. Accept "..cq("Agitated Spirits of Skysong"),
			"		iii. Turn in "..cq("Muck Diving"),
			"	b. Talk to Elementalist Sharvak",
			"		i. Turn in "..cq("The Throne of the Elements"),
			"	c. Talk to Elementalist Morgh",
			"		i. Turn in "..cq("Murkblood Corruptors"),
			completion={{questturnedin="A Rare Bean"},{questaccepted="Agitated Spirits of Skysong"},{questturnedin="Muck Diving"},{questturnedin="The Throne of the Elements"},{questturnedin="Murkblood Corrupters"}},
			mapzone="Nagrand",
			level=65,
			mapnote=22408290,
		}, {
			"Go south to "..cl(60,27),
			"	a. Kill 12 Lake Spirits",
			completion={{questgoal={"*","Lake Spirit slain",12}}},
			mapzone="Nagrand",
			level=65,
			mapnote=27308700,
		}, {
			"Go north to "..cl(60,23),
			"	a. Talk to Elementalist Lo'ap",
			"		i. Turn in "..cq("Agitated Spirits of Skysong"),
			"		ii. Accept "..cq("Blessing of Incineratus"),
			completion={{questturnedin="Agitated Spirits of Skysong"},{questaccepted="Blessing of Incineratus"}},
			mapzone="Nagrand",
			level=65,
			mapnote=22408290,
		}, {
			"Go west to "..cl(52,20),
			"	a. Kill Enraged Crushers",
			"	b. Get 15 Enraged Crusher Cores",
			completion={{questgoal={"*","Enraged Crusher Core",15}}},
			mapzone="Nagrand",
			level=65,
			mapnote=20207220,
		}, {
			"Go west to "..cl(48,21),
			"	a. Kill 10 Warmaul Shamans",
			"	b. Kill 10 Warmaul Reavers",
			"	c. Kill Warmaul mobs",
			"	d. Get the rest of the 10 Obsidian Warbeads you need",
			completion={{questgoal={"*","Warmaul Shaman slain",10}},{questgoal={"*","Warmaul Reaver slain",10}},{questgoal={"*","Obsidian Warbeads",10}}},
			mapzone="Nagrand",
			level=65,
			mapnote=21506980,
		}, {
			"Go northwest to "..cl(46,18),
			"	a. Kill Zorbo the Advisor",
			completion={{questgoal={"*","Zorbo the Advisor slain",1}}},
			mapzone="Nagrand",
			level=65,
			mapnote=18206470,
		}, {
			"Go southeast to "..cl(62,24),
			"	a. Talk to Gordawg",
			"		i. Turn in "..cq("Eating Damnation"),
			"		ii. Accept "..cq("Shattering the Veil"),
			completion={{questturnedin="Eating Damnation"},{questaccepted="Shattering the Veil"}},
			mapzone="Nagrand",
			level=65,
			mapnote=24408620,
		}, {
			"Go southeast to "..cl(71,51),
			"	a. Go inside the hut",
			"	b. Use your Living Fire",
			"	c. Burn the Western Hut",
			completion={{questgoal={"*","Western Hut Destroyed",1}}},
			mapzone="Nagrand",
			level=65,
			mapnote=51212200,
		}, {
			"Go east to "..cl(72,50),
			"	a. Go inside the hut",
			"	b. Use your Living Fire",
			"	c. Burn the Large Hut",
			completion={{questgoal={"*","Large Hut Destroyed",1}}},
			mapzone="Nagrand",
			level=65,
			mapnote=50312270,
		}, {
			"Go south to "..cl(73,55),
			"	a. Go inside the hut",
			"	b. Use your Living Fire",
			"	c. Burn the Eastern Hut",
			completion={{questgoal={"*","Eastern Hut Destroyed",1}}},
			mapzone="Nagrand",
			level=65,
			mapnote=54712750,
		}, {
			"Go southwest to "..cl(71,53),
			"	a. Go inside the hut",
			"	b. Use your Living Fire",
			"	c. Burn the Southern Hut",
			completion={{questgoal={"*","Southern Hut Destroyed",1}}},
			mapzone="Nagrand",
			level=65,
			mapnote=53212440,
		}, {
			"Go northwest to the Throne of the Elements",
			completion={{location={mapzone="Nagrand",x=60.8,y=22.4, dist=4}}},
			mapzone="Nagrand",
			level=65,
		}, {
			"Go to "..cl(60,23),
			"	a. Talk to Elementalist Lo'ap",
			"		i. Turn in "..cq("Blessing of Incineratus"),
			"		ii. Accept "..cq("The Spirit Polluted"),
			completion={{questturnedin="Blessing of Incineratus"},{questaccepted="The Spirit Polluted"}},
			mapzone="Nagrand",
			level=65,
			mapnote=22408290,
		}, {
			"Go west to "..cl(28,30),
			"	a. Get 20 Telaar Supply Crates",
			completion={{questgoal={"*","Telaar Supply Crate",20}}},
			mapzone="Nagrand",
			level=65,
			mapnote=29705760,
		}, {
			"Go southeast to Sunspring Post",
			completion={{location={mapzone="Nagrand",x=32.5,y=41.9, dist=3}}},
			mapzone="Nagrand",
			level=65,
		}, {
			"Go south to "..cl(29,43),
			"	a. Kill 20 Murkblood Scavengers",
			"	b. Kill 10 Murkblood Raiders",
			completion={{questgoal={"*","Murkblood Scavenger slain",20}},{questgoal={"*","Murkblood Raider slain",10}}},
			mapzone="Nagrand",
			level=65,
			mapnote=43507300,
		}, {
			"Go southeast to "..cl(33,48),
			"	a. Use the Torch of Liquid Fire on Sunspring Villager Corpses in the water",
			"	b. Burn 10 Sunspring Villager Corpses",
			completion={{questgoal={"*","Sunspring Villager Corpse Burned",10}}},
			mapzone="Nagrand",
			level=65,
			mapnote=47708090,
		}, {
			"Go southeast to "..cl(34,49),
			"	a. Kill 10 Lake Surgers",
			completion={{questgoal={"*","Lake Surger slain",10}}},
			mapzone="Nagrand",
			level=65,
			mapnote=48908270,
		}, {
			"Go southwest to "..cl(33,51),
			"	a. Kill Watoosun's Polluted Essence",
			completion={{questgoal={"*","Watoosun's Polluted Essence slain",1}}},
			mapzone="Nagrand",
			level=65,
			mapnote=50808390,
		}, {
			"Go south to "..cl(28,78),
			"	a. Use Gordawg's Boulder on Shattered Rumblers",
			"	b. Kill the Minions of Gurok",
			"	c. Kill 30 Minions of Gurok",
			completion={{questgoal={"*","Minion of Gurok slain",30}}},
			mapzone="Nagrand",
			level=65,
			mapnote=77610550,
		}, {
			"Go east to Telaar",
			completion={{location={mapzone="Nagrand",x=54.4,y=72.8, dist=5}}},
			mapzone="Nagrand",
			level=65,
		}, {
			"Go to "..cl(54,72),
			"	a. Talk to Poli'lukluk the Wiser",
			"		i. Turn in "..cq("Solving the Problem"),
			"	b. Talk to Otonbu the Sage",
			"		i. Turn in "..cq("Stopping the Spread"),
			completion={{questturnedin="Solving the Problem"},{questturnedin="Stopping the Spread"}},
			mapzone="Nagrand",
			level=65,
			mapnote=72212670,
		}, {
			"Go to "..cl(56,72),
			"	a. Talk to Huntress Kima",
			"		i. Turn in "..cq("The Ravaged Caravan"),
			completion={{questturnedin="The Ravaged Caravan"}},
			mapzone="Nagrand",
			level=65,
			mapnote=70012420,
		}, {
			"Go to "..cl(55,69),
			"	a. Talk to Arechron",
			"		i. Turn in "..cq("HELP!"),
			"		ii. Accept "..cq("Corki's Gone Missing Again!"),
			completion={{questturnedin="HELP!"},{questaccepted="Corki's Gone Missing Again!"}},
			mapzone="Nagrand",
			level=65,
			mapnote=68812430,
		}, {
			"Go to "..cl(55,71),
			"	a. Talk to Huntress Bintook",
			"		i. Turn in "..cq("Do My Eyes Deceive Me"),
			"		ii. Accept "..cq("Not On My Watch!"),
			completion={{questturnedin="Do My Eyes Deceive Me"},{questaccepted="Not On My Watch!"}},
			mapzone="Nagrand",
			level=65,
			mapnote=70512550,
		}, {
			"Go to "..cl(55,71),
			"	a. Talk to Warden Iolol",
			"		i. Turn in "..cq("Wanted: Giselda the Crone"),
			"		ii. Turn in "..cq("Wanted: Zorbo the Advisor"),
			"		iii. Turn in "..cq("Fierce Enemies"),
			completion={{questturnedin="Wanted: Giselda the Crone"},{questturnedin="Wanted: Zorbo the Advisor"},{questturnedin="Fierce Enemies"}},
			mapzone="Nagrand",
			level=65,
			mapnote=71012580,
		}, {
			"Go east to "..cl(62,67),
			"	a. Talk to Wazat",
			"		i. Turn in "..cq("I Must Have Them!"),
			completion={{questturnedin="I Must Have Them!"}},
			mapzone="Nagrand",
			level=65,
			mapnote=67112880,
		}, {
			"Go south to "..cl(63,71),
			"	a. Fight Lump until he's almost dead",
			"	b. Talk to Lump",
			completion={{questgoal={"*","Lump Interrogated",1}}},
			mapzone="Nagrand",
			level=65,
			mapnote=71413410,
		}, {
			"Go west to Telaar",
			completion={{location={mapzone="Nagrand",x=54.4,y=72.8, dist=5}}},
			mapzone="Nagrand",
			level=65,
		}, {
			"Go to "..cl(55,71),
			"	a. Talk to Huntress Bintook",
			"		i. Turn in "..cq("Not On My Watch!"),
			"		ii. Accept "..cq("Mo'mor the Breaker"),
			completion={{questturnedin="Not On My Watch!"},{questaccepted="Mo'mor the Breaker"}},
			mapzone="Nagrand",
			level=65,
			mapnote=70512550,
		}, {
			"Go to "..cl(55,72),
			"	a. Talk to Mo'mor the Breaker",
			"		i. Turn in "..cq("Mo'mor the Breaker"),
			"		ii. Accept "..cq("The Ruins of Burning Blade"),
			completion={{questturnedin="Mo'mor the Breaker"},{questaccepted="The Ruins of Burning Blade"}},
			mapzone="Nagrand",
			level=65,
			mapnote=72212670,
		}, {
			"Go east to the Burning Blade Ruins",
			completion={{location={mapzone="Nagrand",x=75.6,y=66.5, dist=5}}},
			mapzone="Nagrand",
			level=65,
		}, {
			"Go to "..cl(73,70),
			"	a. Kill 15 Boulderfist Crushers",
			"	b. Kill 15 Boulderfist Mystics",
			completion={{questgoal={"*","Boulderfist Crusher slain",15}},{questgoal={"*","Boulderfist Mystic slain",15}}},
			mapzone="Nagrand",
			level=65,
			mapnote=69814270,
		}, {
			"Go west to Telaar",
			completion={{location={mapzone="Nagrand",x=54.4,y=72.8, dist=5}}},
			mapzone="Nagrand",
			level=65,
		}, {
			"Go to "..cl(55,72),
			"	a. Talk to Mo'mor the Breaker",
			"		i. Turn in "..cq("The Ruins of Burning Blade"),
			"		ii. Accept "..cq("The Twin Clefts of Nagrand"),
			completion={{questturnedin="The Ruins of Burning Blade"},{questaccepted="The Twin Clefts of Nagrand"}},
			mapzone="Nagrand",
			level=65,
			mapnote=72212670,
		}, {
			"Go northwest to "..cl(50,56),
			"	a. Kill 25 Boulderfist Warriors",
			"	b. Kill 25 Boulderfist Mages",
			"	c. Kill ogres",
			"	d. Get a Northwind Cleft Key",
			completion={{questgoal={"*","Boulderfist Warrior slain",25}},{questgoal={"*","Boulderfist Mage slain",25}}},
			mapzone="Nagrand",
			level=65,
			mapnote=56510630,
		}, {
			"Go northwest to "..cl(39,27),
			"	a. Free Corki inside the cave",
			completion={{questgoal={"*","Corki Freed Again",1}}},
			mapzone="Nagrand",
			level=65,
			mapnote=27506680,
		}, {
			"Go to Telaar",
			completion={{location={mapzone="Nagrand",x=54.4,y=72.8, dist=5}}},
			mapzone="Nagrand",
			level=65,
		}, {
			"Go to "..cl(55,72),
			"	a. Talk to Mo'mor the Breaker",
			"		i. Turn in "..cq("The Twin Clefts of Nagrand"),
			"		ii. Accept "..cq("Diplomatic Measures"),
			completion={{questturnedin="The Twin Clefts of Nagrand"},{questaccepted="Diplomatic Measures"}},
			mapzone="Nagrand",
			level=65,
			mapnote=72212670,
		}, {
			"Go to "..cl(55,69),
			"	a. Talk to Arechron",
			"		i. Turn in "..cq("Corki's Gone Missing Again!"),
			completion={{questturnedin="Corki's Gone Missing Again!"}},
			mapzone="Nagrand",
			level=65,
			mapnote=68812430,
		}, {
			"Go east to the Burning Blade Ruins",
			completion={{location={mapzone="Nagrand",x=75.6,y=66.5, dist=5}}},
			mapzone="Nagrand",
			level=65,
		}, {
			"Go to "..cl(74,68),
			"	The path up to Lantressor of the Blade starts here",
			completion={{location={mapzone="Nagrand",x=73.8,y=68.1, dist=0.5}}},
			mapzone="Nagrand",
			level=65,
			mapnote=68114190,
		}, {
			"Go north to "..cl(74,62),
			"	a. Talk to Lantressor of the Blade",
			"		i. Listen to his story",
			"		ii. Turn in "..cq("Diplomatic Measures"),
			"		iii. Accept "..cq("Armaments for Deception"),
			"		iv. Accept "..cq("Ruthless Cunning"),
			completion={{questturnedin="Diplomatic Measures"},{questaccepted="Armaments for Deception"},{questaccepted="Ruthless Cunning"}},
			mapzone="Nagrand",
			level=65,
			mapnote=62613640,
		}, {
			"Go southwest to "..cl(71,79),
			"	a. Click the Kil'sorrow Armaments on the ground",
			"	b. Get 20 Kil'sorrow Armaments",
			"	c. Kill Kil'sorrow mobs",
			"	d. Use your Warmaul Ogre Banners on their corpses",
			"	e. Plant 20 Warmaul Ogre Banners",
			completion={{questgoal={"*","Kil'sorrow Armaments",20}},{questgoal={"*","Warmaul Ogre Banner Planted",20}}},
			mapzone="Nagrand",
			level=65,
			mapnote=79415080,
		}, {
			"Go northeast to "..cl(74,62),
			"	a. Talk to Lantressor of the Blade",
			"		i. Turn in "..cq("Armaments for Deception"),
			"		ii. Turn in "..cq("Ruthless Cunning"),
			"		iii. Accept "..cq("Returning the Favor"),
			"		iv. Accept "..cq("Body of Evidence"),
			completion={{questturnedin="Armaments for Deception"},{questturnedin="Ruthless Cunning"},{questaccepted="Returning the Favor"},{questaccepted="Body of Evidence"}},
			mapzone="Nagrand",
			level=65,
			mapnote=62613640,
		}, {
			"Go northwest to the Throne of the Elements",
			completion={{location={mapzone="Nagrand",x=60.8,y=22.4, dist=4}}},
			mapzone="Nagrand",
			level=65,
		}, {
			"Go to "..cl(62,24),
			"	a. Talk to Gordawg",
			"		i. Turn in "..cq("Shattering the Veil"),
			completion={{questturnedin="Shattering the Veil"}},
			mapzone="Nagrand",
			level=65,
			mapnote=24408620,
		}, {
			"Go to "..cl(60,22),
			"	a. Talk to Elementalist Lo'ap",
			"		i. Turn in "..cq("The Spirit Polluted"),
			completion={{questturnedin="The Spirit Polluted"}},
			mapzone="Nagrand",
			level=65,
			mapnote=22408290,
		}, {
			"Go west to "..cl(46,24),
			"	a. Kill 20 Warmaul ogres",
			"	b. Use your Kil'sorrow Banners on their corpses",
			"	c. Plant 20 Kil'sorrow Banners",
			"	d. Use the Damp Woolen Blanket on the Blazing Warmaul Pyre",
			"	e. Defend the 2 ogres that appear until they are done placing the corpses",
			completion={{questgoal={"*","Kil'sorrow Banner Planted",20}},{questgoal={"*","Kil'sorrow Bodies Planted",1}}},
			mapzone="Nagrand",
			level=65,
			mapnote=24307080,
		}, {
			"Grind to level 66",
			completion={{level=66}},
			mapzone="Nagrand",
			level=65,
		}
	  },
	},
	{ sectiontitle = "Levels (66-68)",
	  steps = {
		{
			"Go to Telaar",
			completion={{location={mapzone="Nagrand",x=54.4,y=72.8, dist=5}}},
			mapzone="Nagrand",
			level=66,
		}, {
			"Go northeast to "..cl(74,62),
			"	a. Talk to Lantressor of the Blade",
			"		i. Turn in "..cq("Returning the Favor"),
			"		ii. Turn in "..cq("Body of Evidence"),
			"		iii. Accept "..cq("Message to Telaar"),
			completion={{questturnedin="Returning the Favor"},{questturnedin="Body of Evidence"},{questaccepted="Message to Telaar"}},
			mapzone="Nagrand",
			level=66,
			mapnote=62613640,
		}, {
			"Go southwest to Telaar",
			completion={{location={mapzone="Nagrand",x=54.4,y=72.8, dist=5}}},
			mapzone="Nagrand",
			level=66,
		}, {
			"Go to "..cl(55,69),
			"	a. Talk to Arechron",
			"		i. Turn in "..cq("Message to Telaar"),
			completion={{questturnedin="Message to Telaar"}},
			mapzone="Nagrand",
			level=66,
			mapnote=68812430,
		}, {
			"Fly to Orebor Harborage",
			completion={{location={mapzone="Zangarmarsh",x=41.8,y=26.6, dist=4}}},
			mapzone="Nagrand",
			level=66,
		}, {
			"Go to "..cl(41,29),
			"	a. Talk to Timothy Daniels",
			"		i. Accept "..cq("No Time for Curiosity"),
			completion={{questaccepted="No Time for Curiosity"}},
			mapzone="Zangarmarsh",
			level=66,
			mapnote=28706990,
		}, {
			"Go north to Blade's Edge Mountains",
			completion={{location={mapzone="Blade's Edge Mountains"}}},
			mapzone="Zangarmarsh",
			level=66,
		}, {
			"Go to "..cl(32,91),
			"	a. Talk to Sentinel Moonwhisper",
			"		i. Accept "..cq("Killing the Crawlers"),
			completion={{questaccepted="Killing the Crawlers"}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=91112330,
		}, {
			"Go into the tunnel",
			completion={{location={mapzone="Blade's Edge Mountains",x=32.7,y=90.6, dist=0.3}}},
			mapzone="Blade's Edge Mountains",
			level=66,
		}, {
			"Inside the tunnel:",
			"	a. Kill 6 Cavern Crawlers before you reach the other side",
			completion={{questgoal={"*","Cavern Crawler slain",6}}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=87312180,
		}, {
			"Go north to Sylvanaar",
			completion={{location={mapzone="Blade's Edge Mountains",x=38.3,y=65.3, dist=3}}},
			mapzone="Blade's Edge Mountains",
			level=66,
		}, {
			"Go to "..cl(36,68),
			"	a. Talk to Kialon Nightblade",
			"		i. Turn in "..cq("No Time for Curiosity"),
			completion={{questturnedin="No Time for Curiosity"}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=67810380,
		}, {
			"Go to "..cl(36,67),
			"	a. Talk to Rina Moonspring",
			"		i. Accept "..cq("The Encroaching Wilderness"),
			completion={{questaccepted="The Encroaching Wilderness"}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=67110330,
		}, {
			"Also at "..cl(36,67),
			"	a. Click the Wanted Poster",
			"		i. Accept "..cq("The Den Mother"),
			completion={{questaccepted="The Den Mother"}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=67310390,
		}, {
			"Go to "..cl(36,66),
			"	a. Talk to Commander Skyshadow",
			"		i. Turn in "..cq("Killing the Crawlers"),
			"		ii. Accept "..cq("The Bloodmaul Ogres"),
			completion={{questturnedin="Killing the Crawlers"},{questaccepted="The Bloodmaul Ogres"}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=66210250,
		}, {
			"Go to "..cl(37,66),
			"	a. Talk to Daranelle",
			"		i. Accept "..cq("Malaise"),
			completion={{questaccepted="Malaise"}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=65610270,
		}, {
			"Make Sylvanaar your home",
			completion={{home="Sylvanaar"}},
			mapzone="Blade's Edge Mountains",
			level=66,
		}, {
			"Go to "..cl(37,65),
			"	a. Talk to Bronwyn Stouthammer",
			"		i. Accept "..cq("Into the Draenethyst Mine"),
			completion={{questaccepted="Into the Draenethyst Mine"}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=65010240,
		}, {
			"Also at "..cl(37,65),
			"	a. Talk to Borgrim Stouthammer",
			"		i. Accept "..cq("Strange Brew"),
			completion={{questaccepted="Strange Brew"}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=64610200,
		}, {
			"Go south to "..cl(37,70),
			"	a. Kill 12 Grovestalker Lynxes",
			completion={{questgoal={"*","Grovestalker Lynx slain",12}}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=70510760,
		}, {
			"Go southwest to "..cl(35,74),
			"	a. Kill Lashh'an bird men",
			"	b. Get 18 Plucked Lashh'an Feathers",
			completion={{questgoal={"*","Plucked Lashh'an Feather",18}}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=74410940,
		}, {
			"Go south to "..cl(34,77),
			"	a. Click the Lashh'an Tome",
			"		i. Turn in "..cq("Malaise"),
			"		ii. Accept "..cq("Scratches"),
			completion={{questturnedin="Malaise"},{questaccepted="Scratches"}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=77411170,
		}, {
			"Go east to "..cl(35,77),
			"	a. Walk inside the Lashh'an Summoning Circle",
			"	b. Use the Fistful of Feathers in your bag",
			"	c. Get the Kaliri aura cast on you",
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=77311250,
		}, {
			"Go north to Sylvanaar",
			completion={{location={mapzone="Blade's Edge Mountains",x=38.3,y=65.3, dist=3}}},
			mapzone="Blade's Edge Mountains",
			level=66,
		}, {
			"Go to "..cl(36,67),
			"	a. Talk to Rina Moonspring",
			"		i. Turn in "..cq("The Encroaching Wilderness"),
			"		ii. Accept "..cq("Marauding Wolves"),
			completion={{questturnedin="The Encroaching Wilderness"},{questaccepted="Marauding Wolves"}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=67110330,
		}, {
			"Go to "..cl(37,66),
			"	a. Talk to Daranelle",
			"		i. Turn in "..cq("Scratches"),
			completion={{questturnedin="Scratches"}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=65610270,
		}, {
			"Go south to "..cl(39,76),
			"	a. The path down to the Bloodmaul Ravine starts here",
			completion={{location={mapzone="Blade's Edge Mountains",x=39.0,y=76.6, dist=0.3}}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=76611560,
		}, {
			"Go southeast to "..cl(42,79),
			"	a. Kill 30 Bloodmaul ogres",
			"	b. Kill Bloodmaul Brewmasters",
			"	c. Click the Bloodmaul Brew Kegs",
			"	d. Get 16 Bloodmaul Brutebane Brew",
			completion={{questgoal={"*","Bloodmaul Ogres killed",30}},{questgoal={"*","Bloodmaul Brutebane Brew",16}}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=79412180,
		}, {
			"Go south to "..cl(42,83),
			"	a. Go inside the cave",
			"	b. Get 5 Draenethyst Mine Crystals",
			completion={{questgoal={"*","Draenethyst Mine Crystal",5}}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=83412580,
		}, {
			"Go to Sylvanaar",
			completion={{location={mapzone="Blade's Edge Mountains",x=38.3,y=65.3, dist=3}}},
			mapzone="Blade's Edge Mountains",
			level=66,
		}, {
			"Go to "..cl(36,66),
			"	a. Talk to Commander Skyshadow",
			"		i. Turn in "..cq("The Bloodmaul Ogres"),
			"		ii. Accept "..cq("The Bladespire Ogres"),
			completion={{questturnedin="The Bloodmaul Ogres"},{questaccepted="The Bladespire Ogres"}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=66210250,
		}, {
			"Go to "..cl(37,65),
			"	a. Talk to Bronwyn Stouthammer",
			"		i. Turn in "..cq("Into the Draenethyst Mine"),
			completion={{questturnedin="Into the Draenethyst Mine"}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=65010240,
		}, {
			"Also at "..cl(37,65),
			"	a. Talk to Borgrim Stouthammer",
			"		i. Turn in "..cq("Strange Brew"),
			"		ii. Accept "..cq("Getting the Bladespire Tanked"),
			completion={{questturnedin="Strange Brew"},{questaccepted="Getting the Bladespire Tanked"}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=64610200,
		}, {
			"Go east across the bridge",
			completion={{location={mapzone="Blade's Edge Mountains",x=48.6,y=65.8, dist=0.5}}},
			mapzone="Blade's Edge Mountains",
			level=66,
		}, {
			"Go to "..cl(51,65),
			"	a. Kill Thunderlord Dire Wolves",
			"	b. Get 4 Thunderlord Dire Wolf Tails",
			completion={{questgoal={"*","Thunderlord Dire Wolf Tail",4}}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=65511680,
		}, {
			"Go south to "..cl(52,75),
			"	a. Kill Rema at the mouth of the cave",
			completion={{questgoal={"*","Rema slain",1}}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=75012660,
		}, {
			"Go northeast to "..cl(60,69),
			"	a. Talk to Nickwinkle the Metro-Gnome",
			"		i. Accept "..cq("Crystal Clear"),
			completion={{questaccepted="Crystal Clear"}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=68912910,
		}, {
			"Go to "..cl(61,69),
			"	a. Talk to Toshley",
			"		i. Accept "..cq("Picking Up Some Power Converters"),
			completion={{questaccepted="Picking Up Some Power Converters"}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=69012950,
		}, {
			"Go to "..cl(61,70),
			"	a. The path up to the Toshley's Station Flight Path starts here",
			completion={{location={mapzone="Blade's Edge Mountains",x=60.7,y=69.5, dist=0.3}}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=69513020,	
		}, {
			"Go to "..cl(61,70),
			"	a. Talk to Rip Pedalslam",
			"		i. Get the Toshley's Station Flight Path",
			completion={{flightpath="Toshley's Station"}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=70413160,
		}, {
			"Go to "..cl(61,68),
			"	a. Talk to Fizit 'Doc' Clocktock",
			"		i. Accept "..cq("What Came First, the Drake or the Egg?"),
			completion={{questaccepted="What Came First, the Drake or the Egg?"}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=68112910,
		}, {
			"Go to "..cl(60,68),
			"	a. Talk to Tally Zapnabber",
			"		i. Accept "..cq("Test Flight: The Zephyrium Capacitorium"),
			completion={{questaccepted="Test Flight: The Zephyrium Capacitorium"}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=68412870,
		}, {
			"Go to "..cl(60,69),
			"	a. Talk to Rally Zapnabber",
			"		i. Test the Zephyrium Capacitorium",
			completion={{questgoal={"*","Test Tally's Experiment",1}}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=68912910,
		}, {
			"Run back to Toshley's Station",
			completion={{location={mapzone="Blade's Edge Mountains",x=60.7,y=69.3, dist=2}}},
			mapzone="Blade's Edge Mountains",
			level=66,
		}, {
			"Go to "..cl(60,68),
			"	a. Talk to Tally Zapnabber",
			"		i. Turn in "..cq("Test Flight: The Zephyrium Capacitorium"),
			"		ii. Accept "..cq("Test Flight: The Singing Ridge"),
			completion={{questturnedin="Test Flight: The Zephyrium Capacitorium"},{questaccepted="Test Flight: The Singing Ridge"}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=68412870,
		}, {
			"Go north to "..cl(56,59),
			"	a. Click the Power Converters on the ground",
			"	b. Use your Protovoltaic Magneto Converter on the Electromentals that spawn",
			"	c. Get 5 Electromentals",
			completion={{questgoal={"*","Electromentals collected",5}}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=59211760,
		}, {
			"Go south to Toshley's Station",
			completion={{location={mapzone="Blade's Edge Mountains",x=60.7,y=69.3, dist=2}}},
			mapzone="Blade's Edge Mountains",
			level=66,
		}, {
			"Go to "..cl(61,69),
			"	a. Talk to Toshley",
			"		i. Turn in "..cq("Picking Up Some Power Converters"),
			"		ii. Accept "..cq("Ride the Lightning"),
			completion={{questturnedin="Picking Up Some Power Converters"},{questaccepted="Ride the Lightning"}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=69012950,
		}, {
			"Go to "..cl(60,69),
			"	a. Talk to Dizzy Dina",
			"		i. Accept "..cq("Ridgespine Menace"),
			completion={{questaccepted="Ridgespine Menace"}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=68812920,
		}, {
			"Also at "..cl(60,69),
			"	a. Talk to Razak Ironsides",
			"		i. Accept "..cq("Cutting Your Teeth"),
			completion={{questaccepted="Cutting Your Teeth"}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=68412890,
		}, {
			"Also at "..cl(60,69),
			"	a. Talk to Rally Zapnabber",
			"		i. Sign Tally's Waiver in your bags",
			"		ii. Go to the Singing Ridge",
			completion={{location={mapzone="Blade's Edge Mountains",x=67.0,y=72.0, dist=2}}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=68912910,
		}, {
			"Go to "..cl(68,73),
			"	a. Kill Scalewing Serpents",
			"	b. Get 5 Scalewing Lightning Glands",
			"	c. Use your Repolarized Magneto Sphere when fighting Scalewing Serpents",
			"	d. Absorb 25 Lightning Strikes",
			"		i. Put your pet on passive, if you have one, to make this go faster",
			completion={{questgoal={"*","Scalewing Lightning Gland",5}},{questgoal={"*","Lightning Strikes Absorbed",25}}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=72914080,
		}, {
			"Go south to "..cl(68,76),
			"	a. Kill 10 Crystal Flayers",
			completion={{questgoal={"*","Crystal Flayer slain",10}}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=76214440,
		}, {
			"Go west to "..cl(66,76),
			"	a. Click the Nether Drake Eggs",
			"	b. Use the Temporal Phase Modulator on the Nether Whelps that spawn",
			"		i. You can use the Modulator repeatedly to get the desired type of drake",
			"	c. Kill the changed drakes",
			"	d. Get 3 Proto-Nether Drake Essences",
			"	e. Get 3 Adolescent Nether Drake Essences",
			"	f. Get 3 Mature Nether Drake Essences",
			completion={{questgoal={"*","Proto-Nether Drake Essence",3}},{questgoal={"*","Adolescent Nether Drake Essence",3}},{questgoal={"*","Mature Nether Drake Essence",3}}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=75614120,
		}, {
			"Go north to "..cl(65,55),
			"	a. Kill Daggermaw Lashtails",
			"	b. Get 5 Extra Sharp Daggermaw Teeth",
			"	c. Kill 10 Ridgespine Stalkers",
			completion={{questgoal={"*","Extra Sharp Daggermaw Tooth",5}},{questgoal={"*","Ridgespine Stalker slain",10}}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=55212020,
		}, {
			"Go southwest to Toshley's Station",
			completion={{location={mapzone="Blade's Edge Mountains",x=60.7,y=69.3, dist=2}}},
			mapzone="Blade's Edge Mountains",
			level=66,
		}, {
			"Go to "..cl(60,69),
			"	a. Talk to Razak Ironsides",
			"		i. Turn in "..cq("Cutting Your Teeth"),
			completion={{questturnedin="Cutting Your Teeth"}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=68412890,
		}, {
			"Go to "..cl(60,68),
			"	a. Talk to Tally Zapnabber",
			"		i. Turn in "..cq("Test Flight: The Singing Ridge"),
			completion={{questturnedin="Test Flight: The Singing Ridge"}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=68412870,
		}, {
			"Go to "..cl(61,68),
			"	a. Talk to Fizit 'Doc Clocktock",
			"		i. Turn in "..cq("What Came First, the Drake or the Egg?"),
			completion={{questturnedin="What Came First, the Drake or the Egg?"}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=68112910,
		}, {
			"Go to "..cl(61,69),
			"	a. Talk to Toshley",
			"		i. Turn in "..cq("Ride the Lightning"),
			"		ii. Accept "..cq("Trapping the Light Fantastic"),
			completion={{questturnedin="Ride the Lightning"},{questaccepted="Trapping the Light Fantastic"}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=69012950,
		}, {
			"Go to "..cl(60,69),
			"	a. Talk to Dizzy Dina",
			"		i. Turn in "..cq("Ridgespine Menace"),
			"		ii. Accept "..cq("More than a Pound of Flesh"),
			completion={{questturnedin="Ridgespine Menace"},{questaccepted="More than a Pound of Flesh"}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=68812920,
		}, {
			"Also at "..cl(60,69),
			"	a. Talk to Nickwinkle the Metro-Gnome",
			"		i. Turn in "..cq("Crystal Clear"),
			"		ii. Accept "..cq("Gauging the Resonant Frequency"),
			completion={{questturnedin="Crystal Clear"},{questaccepted="Gauging the Resonant Frequency"}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=68912910,
		}, {
			"Go to "..cl(60,68),
			"	a. Talk to Tally Zapnabber",
			"		i. Accept "..cq("Test Flight: Razaan's Landing"),
			completion={{questaccepted="Test Flight: Razaan's Landing"}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=68412870,
		}, {
			"Make Toshley's Station your home",
			completion={{home="Toshley's Station"}},
			mapzone="Blade's Edge Mountains",
			level=66,
		}, {
			"Go to "..cl(60,69),
			"	a. Talk to Rally Zapnabber",
			"		i. Go to the Singing Ridge",
			completion={{location={mapzone="Blade's Edge Mountains",x=67.0,y=72.0, dist=4}}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=68912910,
		}, {
			"Go south to "..cl(66,76),
			"	a. Clear out a good big area so you are safe",
			"	b. Place the Oscillating Frequency Scanners on the ground kind of far apart",
			"	c. Try to place them so that the lines overlap each other, like a star",
			"	d. Stand in the middle of the design you made",
			"	e. Gauge the Singing Crystal Resonant Frequency",
			completion={{questgoal={"*","Singing crystal resonant frequency gauged",1}}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=75914230,
		}, {
			"Hearth to Toshley's Station",
			completion={{location={mapzone="Blade's Edge Mountains",x=60.7,y=69.3, dist=2}}},
			mapzone="Blade's Edge Mountains",
			level=66,
		}, {
			"Go to "..cl(60,69),
			"	a. Talk to Nickwinkle the Metro-Gnome",
			"		i. Turn in "..cq("Gauging the Resonant Frequency"),
			"	b. Talk to Rally Zapnabber",
			"		i. Go to Razaan's Landing",
			completion={{questturnedin="Gauging the Resonant Frequency"},{location={mapzone="Blade's Edge Mountains",x=66.8,y=49.9, dist=2}}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=68912910,
		}, {
			"Go to "..cl(65,47),
			"	a. Lay the Multi-Spectrum Light Trap at the foot of this pole",
			"		i. The pole has a purple lightning circle on it",
			"	b. Trap 15 Razaani Light Orbs",
			completion={{questgoal={"*","Razaani Light Orbs trapped",15}}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=46611210,
		}, {
			"Go north to "..cl(66,46),
			"	a. Kill Fiendling Flesh Beasts",
			"	b. Get 5 Ether-Energized Flesh",
			completion={{questgoal={"*","Ether-Energized Flesh",5}}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=45811160,
		}, {
			"Go southwest to Toshley's Station",
			completion={{location={mapzone="Blade's Edge Mountains",x=60.7,y=69.3, dist=2}}},
			mapzone="Blade's Edge Mountains",
			level=66,
		}, {
			"Go to "..cl(60,68),
			"	a. Talk to Tally Zapnabber",
			"		i. Turn in "..cq("Test Flight: Razaan's Landing"),
			completion={{questturnedin="Test Flight: Razaan's Landing"}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=68412870,
		}, {
			"Go to "..cl(60,69),
			"	a. Talk to Dizzy Dina",
			"		i. Turn in "..cq("More than a Pound of Flesh"),
			completion={{questturnedin="More than a Pound of Flesh"}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=68812920,
		}, {
			"Go to "..cl(61,69),
			"	a. Talk to Toshley",
			"		i. Turn in "..cq("Trapping the Light Fantastic"),
			"		ii. Accept "..cq("Show Them Gnome Mercy!"),
			completion={{questturnedin="Trapping the Light Fantastic"},{questaccepted="Show Them Gnome Mercy!"}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=69012950,
		}, {
			"Go to "..cl(66,44),
			"	a. Kill Razaani mummies around the portal until Nexus-Prince Razaan comes out",
			"	b. Kill Nexus-Prince Razaan",
			"	c. Click the Collection of Souls floating above his corpse",
			"	d. Get the Collection of Souls",
			completion={{questgoal={"*","Collection of Souls",1}}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=44311060,
		}, {
			"Go southwest to Toshley's Station",
			completion={{location={mapzone="Blade's Edge Mountains",x=60.7,y=69.3, dist=2}}},
			mapzone="Blade's Edge Mountains",
			level=66,
		}, {
			"Go to "..cl(61,69),
			"	a. Talk to Toshley",
			"		i. Turn in "..cq("Show Them Gnome Mercy!"),
			completion={{questturnedin="Show Them Gnome Mercy!"}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=69012950,
		}, {
			"Fly to Sylvanaar",
			completion={{location={mapzone="Blade's Edge Mountains",x=38.3,y=65.3, dist=3}}},
			mapzone="Blade's Edge Mountains",
			level=66,
		}, {
			"Go to "..cl(36,66),
			"	a. Talk to Commander Skyshadow",
			"		i. Turn in "..cq("The Den Mother"),
			completion={{questturnedin="The Den Mother"}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=66210250,
		}, {
			"Go to "..cl(36,67),
			"	a. Talk to Rina Moonspring",
			"		i. Turn in "..cq("Marauding Wolves"),
			"		ii. Accept "..cq("Protecting Our Own"),
			completion={{questturnedin="Marauding Wolves"},{questaccepted="Protecting Our Own"}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=67110330,
		}, {
			"Make Sylvanaar your home",
			completion={{home="Sylvanaar"}},
			mapzone="Blade's Edge Mountains",
			level=66,
		}, {
			"Go south to "..cl(37,71),
			"	a. Use Rina's Bough on the Grove Seedlings on the ground",
			"	b. Summon 5 Living Grove Defenders",
			completion={{questgoal={"*","Living Grove Defenders summoned",5}}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=70710740,
		}, {
			"Go north to Sylvanaar",
			completion={{location={mapzone="Blade's Edge Mountains",x=38.3,y=65.3, dist=3}}},
			mapzone="Blade's Edge Mountains",
			level=66,
		}, {
			"Go to "..cl(36,67),
			"	a. Talk to Rina Moonspring",
			"		i. Turn in "..cq("Protecting Our Own"),
			"		ii. Accept "..cq("A Dire Situation"),
			completion={{questturnedin="Protecting Our Own"},{questaccepted="A Dire Situation"}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=67110330,
		}, {
			"Go southeast to Bloodmaul Ravine",
			completion={{location={mapzone="Blade's Edge Mountains",x=39.0,y=76.6, dist=0.3}}},
			mapzone="Blade's Edge Mountains",
			level=66,
		}, {
			"Go to "..cl(42,80),
			"	a. Use Rina's Diminution Powder on Bloodmaul Dire Wolves",
			"	b. Weaken 5 Bloodmaul Dire Wolves",
			completion={{questgoal={"*","Bloodmaul Dire Wolf weakened",5}}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=79812210,
		}, {
			"Go to "..cl(44,52),
			"	a. Talk to Vindicator Vuuleen",
			"		i. Accept "..cq("The Trappings of a Vindicator"),
			completion={{questaccepted="The Trappings of a Vindicator"}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=51909590,
		}, {
			"Go west to "..cl(40,53),
			"	a. Kill 30 Bladespire ogres",
			"	b. Use your Bloodmaul Brutebane Keg when semi-close to an ogre",
			"		i. Don't aggro the ogre, though",
			"	c. The ogre will run up to the beer and drink it",
			"	d. Get 5 Bladespire ogres drunk",
			completion={{questgoal={"*","Bladespire Ogres killed",30}},{questgoal={"*","Bladespire Ogres drunk",5}}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=53009330,
		}, {
			"Go west to "..cl(39,53),
			"	a. Pull the 2 non-elite guards one at a time and kill them",
			"	b. Place a beer in front of the fire",
			"		i. Don't aggro the ogres, though",
			"	c. Droggam will run up for the beer",
			"	d. Pull Droggam outside and kill him",
			"	e. Get Vindicator Vuuleen's Blade",
			completion={{questgoal={"*","Vindicator Vuuleen's Blade",1}}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=53009230,
		}, {
			"Go southeast to "..cl(42,58),
			"	a. Pull the 2 non-elite guards one at a time and kill them",
			"	b. Place a beer in front of the fire",
			"		i. Don't aggro the ogres, though",
			"	c. Mugdorg will run up for the beer",
			"	d. Pull Mugdorg outside and kill him",
			"	e. Get Vindicator Vuuleen's Shield",
			completion={{questgoal={"*","Vindicator Vuuleen's Shield",1}}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=57809990,
		}, {
			"Go northeast to "..cl(44,52),
			"	a. Talk to Vindicator Vuuleen",
			"		i. Turn in "..cq("The Trappings of a Vindicator"),
			"		ii. Accept "..cq("Gorr'Dim, Your Time Has Come..."),
			completion={{questturnedin="The Trappings of a Vindicator"},{questaccepted="Gorr'Dim, Your Time Has Come..."}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=51909590,
		}, {
			"Go northwest to "..cl(40,50),
			"	a. Place a beer in front of the fire",
			"		i. Don't aggro the ogres, though",
			"	b. Gorr'dim will run up for the beer",
			"	c. Pull Gorr'dim outside and kill him",
			completion={{questgoal={"*","Gorr'Dim slain",1}}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=49608950,
		}, {
			"Go southeast to "..cl(44,52),
			"	a. Talk to Vindicator Vuuleen",
			"		i. Turn in "..cq("Gorr'Dim, Your Time Has Come..."),
			completion={{questturnedin="Gorr'Dim, Your Time Has Come..."}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=51909590,
		}, {
			"Hearth to Sylvanaar",
			completion={{location={mapzone="Blade's Edge Mountains",x=38.3,y=65.3, dist=3}}},
			mapzone="Blade's Edge Mountains",
			level=66,
		}, {
			"Go to "..cl(37,65),
			"	a. Talk to Borgrim Stouthammer",
			"		i. Turn in "..cq("Getting the Bladespire Tanked"),
			completion={{questturnedin="Getting the Bladespire Tanked"}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=64610200,
		}, {
			"Go to "..cl(36,66),
			"	a. Talk to Commander Skyshadow",
			"		i. Turn in "..cq("The Bladespire Ogres"),
			completion={{questturnedin="The Bladespire Ogres"}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=66210250,
		}, {
			"Go to "..cl(36,67),
			"	a. Talk to Rina Moonspring",
			"		i. Turn in "..cq("A Dire Situation"),
			completion={{questturnedin="A Dire Situation"}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=67110330,
		}, {
			"Fly to Toshley's Station",
			completion={{location={mapzone="Blade's Edge Mountains",x=60.7,y=69.3, dist=2}}},
			mapzone="Blade's Edge Mountains",
			level=66,
		}, {
			"Go to "..cl(60,68),
			"	a. Talk to Tally Zapnabber",
			"		i. Accept "..cq("Test Flight: Ruuan Weald"),
			completion={{questaccepted="Test Flight: Ruuan Weald"}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=68412870,
		}, {
			"Go to 60,69 ",
			"	a. Talk to Rally Zapnabber",
			"		i. Go to Ruuan Weald",
			"		ii. Use your Nether-weather Vane while in flight",
			"		iii. Get a Spinning Nether-weather Vane",
			completion={{questgoal={"*","Launch to Ruuan Weald.",1}},{questgoal={"*","Spinning Nether-weather Vane",1}},{location={mapzone="Blade's Edge Mountains",x=61.9,y=39.8, dist=2}}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=68912910,
		}, {
			"Go to "..cl(62,39),
			"	a. Talk to Tree Warden Chawn",
			"		i. Accept "..cq("A Time for Negotiation..."),
			completion={{questaccepted="A Time for Negotiation..."}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=39510150,
		}, {
			"Go to "..cl(62,40),
			"	a. Talk to Fhyn Leafshadow",
			"		i. Get the Evergrove Flight Path",
			completion={{flightpath="Evergrove"}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=39610130,
		}, {
			"Go to "..cl(61,38),
			"	a. Talk to Mosswood the Ancient",
			"		i. Accept "..cq("Little Embers"),
			"		ii. Accept "..cq("From the Ashes"),
			completion={{questaccepted="Little Embers"},{questaccepted="From the Ashes"}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=38409960,
		}, {
			"Go to "..cl(62,39),
			"	a. Talk to Timeon",
			"		i. Accept "..cq("Creating the Pendant"),
			completion={{questaccepted="Creating the Pendant"}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=39110130,
		}, {
			"Go to "..cl(62,38),
			"	a. Talk to Commander Haephus Stonewall",
			"		i. Accept "..cq("A Date with Dorgok"),
			"	b. Talk to Lieutenant Fairweather",
			"		i. Accept "..cq("Crush the Bloodmaul Camp!"),
			completion={{questaccepted="A Date with Dorgok"},{questaccepted="Crush the Bloodmaul Camp!"}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=38010000,
		}, {
			"Also at "..cl(62,38),
			"	a. Talk to Faradrella",
			"		i. Accept "..cq("Culling the Wild"),
			completion={{questaccepted="Culling the Wild"}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=38210080,
		}, {
			"Go to "..cl(63,40),
			"	a. Talk to O'Mally Zapnabber",
			"		i. Turn in "..cq("Test Flight: Ruuan Weald"),
			completion={{questturnedin="Test Flight: Ruuan Weald"}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=40410310,
		}, {
			"Go northeast to "..cl(69,35),
			"	a. Kill 2 Fel Corrupters ",
			"	b. Kill 4 Felsworn Scalewings",
			"	c. Kill 4 Felsworn Daggermaws",
			"	d. Kill Fel Corrupters",
			"	e. Get a Damaged Mask",
			"	f. Click the Damaged Mask",
			"		i. Accept "..cq("Damaged Mask"),
			completion={{questgoal={"*","Fel Corrupter slain",2}},{questgoal={"*","Felsworn Scalewing slain",4}},{questgoal={"*","Felsworn Daggermaw slain",4}},{questaccepted="Damaged Mask"}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=35610450,
		}, {
			"Go northeast to "..cl(72,22),
			"	a. Click the Fertile Volcanic Soil",
			"	b. Plant the Ironroot Seeds",
			completion={{questgoal={"*","Southern Volcanic Soil",1}}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=22409410,
		}, {
			"Go north to "..cl(72,20),
			"	a. Click the Fertile Volcanic Soil",
			"	b. Plant the Ironroot Seeds",
			completion={{questgoal={"*","Central Volcanic Soil",1}}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=20309190,
		}, {
			"Go west to "..cl(71,20),
			"	a. Kill 8 Scorch Imps",
			completion={{questgoal={"*","Scorch Imp slain",8}}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=20209090,
		}, {
			"Go northeast to "..cl(72,18),
			"	a. Click the Fertile Volcanic Soil",
			"	b. Plant the Ironroot Seeds",
			completion={{questgoal={"*","Northern Volcanic Soil",1}}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=18509010,
		}, {
			"Go southwest to Evergrove",
			completion={{location={mapzone="Blade's Edge Mountains",x=62.4,y=38.4, dist=3}}},
			mapzone="Blade's Edge Mountains",
			level=66,
		}, {
			"Go to "..cl(62,38),
			"	a. Talk to Faradrella",
			"		i. Turn in "..cq("Culling the Wild"),
			completion={{questturnedin="Culling the Wild"}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=38210080,
		}, {
			"Go to "..cl(63,40),
			"	a. Talk to O'Mally Zapnabber",
			"		i. Turn in "..cq("Damaged Mask"),
			"		ii. Accept "..cq("Mystery Mask"),
			completion={{questturnedin="Damaged Mask"},{questaccepted="Mystery Mask"}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=40410310,
		}, {
			"Go to "..cl(61,39),
			"	a. Talk to Wildlord Antelarion",
			"		i. Turn in "..cq("Mystery Mask"),
			"		ii. Accept "..cq("Felsworn Gas Mask"),
			completion={{questturnedin="Mystery Mask"},{questaccepted="Felsworn Gas Mask"}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=40110230,
		}, {
			"Go to "..cl(61,38),
			"	a. Talk to Mosswood the Ancient",
			"		i. Turn in "..cq("Little Embers"),
			"		ii. Turn in "..cq("From the Ash"),
			completion={{questturnedin="Little Embers"},{questturnedin="From the Ash"}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=38409960,
		}, {
			"Go west to "..cl(59,39),
			"	a. Talk to Overseer Nuuar",
			"		i. He wanders around the Wyrmcult camps",
			completion={{questgoal={"*","Negotiations with Overseer Nuaar complete",1}}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=39109790,
		}, {
			"Go east to Evergrove",
			completion={{location={mapzone="Blade's Edge Mountains",x=62.4,y=38.4, dist=3}}},
			mapzone="Blade's Edge Mountains",
			level=66,
		}, {
			"Go to "..cl(62,39),
			"	a. Talk to Tree Warden Chawn",
			"		i. Turn in "..cq("A Time for Negotiation..."),
			"		ii. Accept "..cq("...and a Time for Action"),
			"	b. Talk to Samia Inkling",
			"		i. Accept "..cq("Poaching from Poachers"),
			completion={{questturnedin="A Time for Negotiation..."},{questaccepted="...and a Time for Action"},{questaccepted="Poaching from Poachers"}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=39510150,
		}, {
			"Go west to "..cl(60,38),
			"	a. Kill 10 Wyrmcult Hewers",
			"	b. Kill Wyrmcult Poachers",
			"	c. Get 5 Wyrmcult Nets",
			"	d. Kill Wyrmcult mobs",
			"	e. Get a Meeting Note",
			"	f. Click the Meeting Note",
			"		i. Accept "..cq("Did You Get The Note?"),
			completion={{questgoal={"*","Wyrmcult Hewer slain",10}},{questgoal={"*","Wyrmcult Net",5}},{questaccepted="Did You Get The Note?"}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=37809770,
		}, {
			"Go east to Evergrove",
			completion={{location={mapzone="Blade's Edge Mountains",x=62.4,y=38.4, dist=3}}},
			mapzone="Blade's Edge Mountains",
			level=66,
		}, {
			"Go to "..cl(62,39),
			"	a. Talk to Samia Inkling",
			"		i. Turn in "..cq("Poaching from Poachers"),
			"		ii. Accept "..cq("Whelps of the Wyrmcult"),
			"	b. Talk to Tree Warden Chawn",
			"		i. Turn in "..cq("...and a Time for Action"),
			"		ii. Turn in "..cq("Did You Get The Note?"),
			"		iii. Accept "..cq("Wyrmskull Watcher"),
			completion={{questturnedin="Poaching from Poachers"},{questaccepted="Whelps of the Wyrmcult"},{questturnedin="...and a Time for Action"},{questturnedin="Did You Get The Note?"},{questaccepted="Wyrmskull Watcher"}},
			mapzone="Blade's Edge Mountains",
			level=66,
			mapnote=39510150,
		}, {
			"Make sure you have your Felsworn Gas Mask in your bags",
			"	a. It has a 60 minute timer on it",
			"	b. If you need another one, talk to Wildlord Antelarion at Evergrove",
			mapzone="Blade's Edge Mountains",
			level=66,
		}, {
			"Go east to Forge Camp Anger",
			completion={{location={mapzone="Blade's Edge Mountains",x=73.7,y=41.0, dist=2}}},
			mapzone="Blade's Edge Mountains",
			level=66,
		}, {
			"Grind to level 67",
			completion={{level=67}},
			mapzone="Blade's Edge Mountains",
			level=66,
		}, {
			"Put on your Felsworn Gas Mask",
			mapzone="Blade's Edge Mountains",
			level=67,
		}, {
			"Go to "..cl(73,40),
			"	a. Click the Legion Communicator",
			"		i. Turn in "..cq("Felsworn Gas Mask"),
			"		ii. Accept "..cq("Deceive thy Enemy"),
			completion={{questturnedin="Felsworn Gas Mask"},{questaccepted="Deceive thy Enemy"}},
			mapzone="Blade's Edge Mountains",
			level=67,
			mapnote=40011320,
		}, {
			"Go east to "..cl(75,40),
			"	a. Kill 4 Doomforge Attendants",
			"	b. Kill 4 Doomforge Engineers",
			completion={{questgoal={"*","Doomforge Attendant slain",4}},{questgoal={"*","Doomforge Engineer slain",4}}},
			mapzone="Blade's Edge Mountains",
			level=67,
			mapnote=39911480,
		}, {
			"Go west to "..cl(73,40),
			"	a. Put on your Felsworn Gas Mask",
			"	b. Click the Legion Communicator",
			"		i. Turn in "..cq("Deceive thy Enemy"),
			completion={{questturnedin="Deceive thy Enemy"}},
			mapzone="Blade's Edge Mountains",
			level=67,
			mapnote=40011320,
		}, {
			"Go northwest to "..cl(64,31),
			"	a. Kill Ruuan'ok arakkoas",
			"	b. Get 6 Ruuan'ok Claws",
			completion={{item={"Ruuan'ok Claw",6}}},
			mapzone="Blade's Edge Mountains",
			level=67,
			mapnote=31509540,
		}, {
			"Go southeast to "..cl(64,33),
			"	a. Use the 6 Ruuan'ok Claws inside the glowing circle",
			"	b. Kill the Harbinger of the Raven",
			"	c. Get the Harbinger's Pendant",
			completion={{questgoal={"*","Harbinger's Pendant",1}}},
			mapzone="Blade's Edge Mountains",
			level=67,
			mapnote=31509540,
		}, {
			"Go northwest to "..cl(56,27),
			"	a. Kill 10 Bloodmaul Maulers",
			"	b. Kill 5 Bloodmaul Warlocks",
			completion={{questgoal={"*","Bloodmaul Mauler slain",10}},{questgoal={"*","Bloodmaul Warlock slain",5}}},
			mapzone="Blade's Edge Mountains",
			level=67,
			mapnote=26708290,
		}, {
			"Go northwest to "..cl(55,24),
			"	a. Go up the ramp on the side of the tower",
			"	b. Kill Dorgok",
			"	c. Get Gorgrom's Favor",
			"	d. Click Gorgrom's Favor",
			"		i. Accept "..cq("Favor of the Gronn"),
			completion={{questgoal={"*","Dorgok slain",1}},{questaccepted="Favor of the Gronn"}},
			mapzone="Blade's Edge Mountains",
			level=67,
			mapnote=24007920,
		}, {
			"Go southeast to Evergrove",
			completion={{location={mapzone="Blade's Edge Mountains",x=62.4,y=38.4, dist=3}}},
			mapzone="Blade's Edge Mountains",
			level=67,
		}, {
			"Go to "..cl(62,38),
			"	a. Talk to Lieutenant Fairweather",
			"		i. Turn in "..cq("Crush the Bloodmaul Camp!"),
			"	b. Talk to Commander Haephus Stonewall",
			"		i. Turn in "..cq("A Date with Dorgok"),
			"		ii. Turn in "..cq("Favor of the Gronn"),
			"		iii. Accept "..cq("Pay the Baron a Visit"),
			completion={{questturnedin="Crush the Bloodmaul Camp!"},{questturnedin="A Date with Dorgok"},{questturnedin="Favor of the Gronn"},{questaccepted="Pay the Baron a Visit"}},
			mapzone="Blade's Edge Mountains",
			level=67,
			mapnote=38010000,
		}, {
			"Go to "..cl(62,39),
			"	a. Talk to Timeon",
			"		i. Turn in "..cq("Creating the Pendant"),
			"		ii. Accept "..cq("Whispers of the Raven God"),
			completion={{questturnedin="Creating the Pendant"},{questaccepted="Whispers of the Raven God"}},
			mapzone="Blade's Edge Mountains",
			level=67,
			mapnote=39110130,
		}, {
			"Go north to "..cl(53,41),
			"	a. Talk to Baron Sablemane",
			"		i. Turn in "..cq("Pay the Baron a Visit"),
			"		ii. Accept "..cq("Into the Churning Gulch"),
			completion={{questturnedin="Pay the Baron a Visit"},{questaccepted="Into the Churning Gulch"}},
			mapzone="Blade's Edge Mountains",
			level=67,
			mapnote=41209450,
		}, {
			"Go southwest to "..cl(49,44),
			"	a. Kill Greater Crust Bursters",
			"	b. Kill Young Crust Bursters",
			"	c. Get 7 Crust Burster Venom Glands",
			completion={{questgoal={"*","Crust Burster Venom Gland",7}}},
			mapzone="Blade's Edge Mountains",
			level=67,
			mapnote=44509350,
		}, {
			"Go northeast to "..cl(53,41),
			"	a. Talk to Baron Sablemane",
			"		i. Turn in "..cq("Into the Churning Gulch"),
			"		ii. Accept "..cq("Goodnight, Gronn"),
			completion={{questturnedin="Into the Churning Gulch"},{questaccepted="Goodnight, Gronn"}},
			mapzone="Blade's Edge Mountains",
			level=67,
			mapnote=41209450,
		}, {
			"Go southeast to "..cl(60,48),
			"	a. Use Sablemane's Sleeping Powder on Grulloc",
			"	b. Get Grulloc's Sack and run away",
			completion={{questgoal={"*","Grulloc's Sack",1}}},
			mapzone="Blade's Edge Mountains",
			level=67,
			mapnote=47610780,
		}, {
			"Go northwest to "..cl(53,41),
			"	a. Talk to Baron Sablemane",
			"		i. Turn in "..cq("Goodnight, Gronn"),
			"		ii. Accept "..cq("It's a Trap!"),
			completion={{questturnedin="Goodnight, Gronn"},{questaccepted="It's a Trap!"}},
			mapzone="Blade's Edge Mountains",
			level=67,
			mapnote=41209450,
		}, {
			"Go northeast to Evergrove",
			completion={{location={mapzone="Blade's Edge Mountains",x=62.4,y=38.4, dist=3}}},
			mapzone="Blade's Edge Mountains",
			level=67,
		}, {
			"Go to "..cl(62,38),
			"	a. Talk to Commander Haephus Stonewall",
			"		i. Turn in "..cq("It's a Trap!"),
			"		ii. Accept "..cq("Gorgrom the Dragon-Eater"),
			"	b. Talk to Lieutenant Fairweather",
			"		i. Accept "..cq("Slaughter at Boulder'mok"),
			completion={{questturnedin="It's a Trap!"},{questaccepted="Gorgrom the Dragon-Eater"},{questaccepted="Slaughter at Boulder'mok"}},
			mapzone="Blade's Edge Mountains",
			level=67,
			mapnote=38010000,
		}, {
			"Go west across the bridge",
			completion={{location={mapzone="Blade's Edge Mountains",x=53.1,y=37.9, dist=0.5}}},
			mapzone="Blade's Edge Mountains",
			level=67,
		}, {
			"Go to "..cl(50,36),
			"	a. Talk to Watcher Moonshade",
			"		i. Turn in "..cq("Wyrmskull Watcher"),
			"		ii. Accept "..cq("Longtail is the Lynchpin"),
			completion={{questturnedin="Wyrmskull Watcher"},{questaccepted="Longtail is the Lynchpin"}},
			mapzone="Blade's Edge Mountains",
			level=67,
			mapnote=35908580,
		}, {
			"Go into the tunnel",
			completion={{location={mapzone="Blade's Edge Mountains",x=49.5,y=35.8, dist=0.3}}},
			mapzone="Blade's Edge Mountains",
			level=67,
		}, {
			"Go northwest to "..cl(47,32),
			"	a. Kill Draaca Longtail",
			completion={{questgoal={"*","Draaca Longtail slain",1}}},
			mapzone="Blade's Edge Mountains",
			level=67,
			mapnote=32907960,
		}, {
			"Go southeast to "..cl(50,36),
			"	a. Talk to Watcher Moonshade",
			"		i. Turn in "..cq("Longtail is the Lynchpin"),
			"		ii. Accept "..cq("Meeting at the Blackwing Coven"),
			completion={{questturnedin="Longtail is the Lynchpin"},{questaccepted="Meeting at the Blackwing Coven"}},
			mapzone="Blade's Edge Mountains",
			level=67,
			mapnote=35908580,
		}, {
			"Go northwest trough the tunnel to Grishnath",
			completion={{location={mapzone="Blade's Edge Mountains",x=43.1,y=29.9, dist=0.3}}},
			mapzone="Blade's Edge Mountains",
			level=67,
		}, {
			"Kill arakkoas",
			"	a. Get the Understanding Ravenspeech buff",
			"		i. Must be within melee range to receive the buff",
			"	b. The buff lasts for 2 minutes",
			"	c. Anytime the buff wears off, kill arakkoas again to get it back",
			mapzone="Blade's Edge Mountains",
			level=67,
		}, {
			"Go to "..cl(41,19),
			"	a. Stand next to the wooden totem with the Understanding Ravenspeech buff on you",
			"	b. Receive the Third Prophecy",
			completion={{questgoal={"*","Receive the Third Prophecy",1}}},
			mapzone="Blade's Edge Mountains",
			level=67,
			mapnote=18705940,
		}, {
			"Go northwest to "..cl(39,17),
			"	a. Stand next to the wooden totem with the Understanding Ravenspeech buff on you",
			"	b. Receive the First Prophecy",
			completion={{questgoal={"*","Receive the First Prophecy",1}}},
			mapzone="Blade's Edge Mountains",
			level=67,
			mapnote=17205620,
		}, {
			"Go southeast to "..cl(42,22),
			"	a. Stand next to the wooden totem with the Understanding Ravenspeech buff on you",
			"	b. Receive the Second Prophecy",
			completion={{questgoal={"*","Receive the Second Prophecy",1}}},
			mapzone="Blade's Edge Mountains",
			level=67,
			mapnote=21606410,
		}, {
			"Go southwest to "..cl(40,23),
			"	a. Stand next to the wooden totem with the Understanding Ravenspeech buff on you",
			"	b. Receive the Fourth Prophecy",
			"	c. Kill arakkoas",
			"	d. Get the Orb of the Grishna",
			"	e. Click the Orb of the Grishna",
			"		i. Accept "..cq("The Truth Unorbed"),
			completion={{questgoal={"*","Receive the Fourth Prophecy",1}},{questaccepted="The Truth Unorbed"}},
			mapzone="Blade's Edge Mountains",
			level=67,
			mapnote=23006320,
		}, {
			"Go southwest to "..cl(32,35),
			"	a. Go inside the cave",
			"	b. Use the Blackwhelp Net on Wyrmcult Blackwhelps",
			"	c. Capture 10 Wyrmcult Blackwhelps",
			"	d. Kill Wyrmcultists",
			"	e. Get 5 Costume Scraps",
			completion={{questgoal={"*","Wyrmcult Blackwhelp",10}},{item={"Costume Scraps",5}}},
			mapzone="Blade's Edge Mountains",
			level=67,
			mapnote=34906720,
		}, {
			"Go south to "..cl(33,38),
			"	a. Combine your 5 Costume Scraps to make an Overseer Disguise",
			"	b. Put on the Overseer Disguise",
			"	c. Talk to Kolphis Darkscale",
			"		i. Attend the meeting with Kolphis Darkscale",
			completion={{questgoal={"*","Meeting with Kolphis Darkscale attended",1}}},
			mapzone="Blade's Edge Mountains",
			level=67,
			mapnote=37507010,
		}, {
			"Go northwest to "..cl(30,25),
			"	a. Kill 5 Boulder'mok Brutes",
			"	b. Kill 3 Boulder'mok Shamans",
			"	c. Kill Boulder'mok mobs",
			"	d. Get 3 Grisly Totems",
			completion={{questgoal={"*","Boulder'mok Brute slain",5}},{questgoal={"*","Boulder'mok Shaman slain",3}},{item={"Grisly Totem",3}}},
			mapzone="Blade's Edge Mountains",
			level=67,
			mapnote=24605490,
		}, {
			"Go north to "..cl(31,22),
			"	a. Click Gorgrom's Altar",
			"	b. He will run up to the altar and die",
			"	c. Use the Grisly Totems on his corpse",
			"	d. Plant 3 Grisly Totems",
			completion={{questgoal={"*","Plant Grisly Totem",3}}},
			mapzone="Blade's Edge Mountains",
			level=67,
			mapnote=22205280,
		}, {
			"Go east to Evergrove",
			completion={{location={mapzone="Blade's Edge Mountains",x=62.4,y=38.4, dist=3}}},
			mapzone="Blade's Edge Mountains",
			level=67,
		}, {
			"Go to "..cl(62,39),
			"	a. Talk to Samia Inkling",
			"		i. Turn in "..cq("Whelps of the Wyrmcult"),
			"	b. Talk to Tree Warden Chawn",
			"		i. Turn in "..cq("Meeting at the Blackwing Coven"),
			"		ii. Accept "..cq("Maxnar Must Die!"),
			"		iii. Turn in "..cq("The Trurth Unorbed"),
			"		iv. Accept "..cq("Treebole Must Know"),
			completion={{questturnedin="Whelps of the Wyrmcult"},{questturnedin="Meeting at the Blackwing Coven"},{questaccepted="Maxnar Must Die!"},{questturnedin="The Trurth Unorbed"},{questaccepted="Treebole Must Know"}},
			mapzone="Blade's Edge Mountains",
			level=67,
			mapnote=39510150,
		}, {
			"Also at "..cl(62,39),
			"	a. Talk to Timeon",
			"		i. Turn in "..cq("Whispers of the Raven God"),
			completion={{questturnedin="Whispers of the Raven God"}},
			mapzone="Blade's Edge Mountains",
			level=67,
			mapnote=39110130,
		}, {
			"Go to "..cl(62,38),
			"	a. Talk to Commander Haephus Stonewall",
			"		i. Turn in "..cq("Gorgrom the Dragon-Eater"),
			"		ii. Accept "..cq("Baron Sablemane Has Requested Your Presence"),
			"	b. Talk to Lieutenant Fairweather",
			"		i. Turn in "..cq("Slaughter at Boulder'mok"),
			completion={{questturnedin="Gorgrom the Dragon-Eater"},{questaccepted="Baron Sablemane Has Requested Your Presence"},{questturnedin="Slaughter at Boulder'mok"}},
			mapzone="Blade's Edge Mountains",
			level=67,
			mapnote=38010000,
		}, {
			"Go to "..cl(53,41),
			"	a. Talk to Baron Sablemane",
			"		i. Turn in "..cq("Baron Sablemane Has Requested Your Presence"),
			completion={{questturnedin="Baron Sablemane Has Requested Your Presence"}},
			mapzone="Blade's Edge Mountains",
			level=67,
			mapnote=41209450,
		}, {
			"Go northwest through the tunnel to Raven's Wood",
			completion={{location={mapzone="Blade's Edge Mountains",x=43.1,y=29.9, dist=0.3}}},
			mapzone="Blade's Edge Mountains",
			level=67,
		}, {
			"Go to "..cl(37,22),
			"	a. Talk to Treebole",
			"		i. Turn in "..cq("Treebole Must Know"),
			"		ii. Accept "..cq("Exorcising the Trees"),
			completion={{questturnedin="Treebole Must Know"},{questaccepted="Exorcising the Trees"}},
			mapzone="Blade's Edge Mountains",
			level=67,
			mapnote=22505940,
		}, {
			"Go northeast to "..cl(39,20),
			"	a. Click the purple balls in the claw looking rods",
			"	b. Get 5 Grishnath Orbs",
			completion={{item={"Grishnath Orb",5}}},
			mapzone="Blade's Edge Mountains",
			level=67,
			mapnote=20205950,
		}, {
			"Go southwest to "..cl(30,29),
			"	a. Kill Dire Ravens",
			"	b. Get 5 Dire Pinfeathers",
			completion={{item={"Dire Pinfeather",5}}},
			mapzone="Blade's Edge Mountains",
			level=67,
			mapnote=28605870,
		}, {
			"Go east to "..cl(34,29),
			"	a. Click your Grishnath Orbs to combine the orbs and pinfeathers",
			"	b. Create 5 Exorcism Feathers",
			"	c. Use the Exorcism Feathers on the Raven's Wood Leafbeards",
			"	d. Kill the Koi Koi spirits that spawn to free the trees",
			"	e. Free 5 Raven's Wood Leafbeards",
			completion={{questgoal={"*","Leafbeard Exorcised",5}}},
			mapzone="Blade's Edge Mountains",
			level=67,
			mapnote=29406320,
		}, {
			"Go south to the Blackwing Coven",
			completion={{location={mapzone="Blade's Edge Mountains",x=31.9,y=33.1, dist=0.5}}},
			mapzone="Blade's Edge Mountains",
			level=67,
		}, {
			"Go inside the cave",
			completion={{location={mapzone="Blade's Edge Mountains",x=32.1,y=34.1, dist=0.3}}},
			mapzone="Blade's Edge Mountains",
			level=67,
		}, {
			"Go to "..cl(34,35),
			"	a. Kill Maxnar the Ashmaw",
			completion={{questgoal={"*","Maxnar the Ashmaw slain",1}}},
			mapzone="Blade's Edge Mountains",
			level=67,
			mapnote=35406930,
		}, {
			"Go northeast to "..cl(37,22),
			"	a. Talk to Treebole",
			"		i. Turn in "..cq("Exorcising the Trees"),
			completion={{questturnedin="Exorcising the Trees"}},
			mapzone="Blade's Edge Mountains",
			level=67,
			mapnote=22505940,
		}, {
			"Go southeast to Evergrove",
			completion={{location={mapzone="Blade's Edge Mountains",x=62.4,y=38.4, dist=3}}},
			mapzone="Blade's Edge Mountains",
			level=67,
		}, {
			"Go to "..cl(62,39),
			"	a. Talk to Tree Warden Chawn",
			"		i. Turn in "..cq("Maxnar Must Die!"),
			completion={{questturnedin="Maxnar Must Die!"}},
			mapzone="Blade's Edge Mountains",
			level=67,
			mapnote=39510150,
		}, {
			"Go northeast to Netherstorm",
			completion={{location={mapzone="Netherstorm"}}},
			mapzone="Blade's Edge Mountains",
			level=67,
		}, {
			"Go to 21,56 on the bridge",
			"	a. Talk to Netherologist Coppernickels",
			"		i. Accept "..cq("Off To Area 52"),
			completion={{questaccepted="Off To Area 52"}},
			mapzone="Netherstorm",
			level=67,
			mapnote=55607690,
		}, {
			"Go east to "..cl(32,57),
			"	a. Talk to Bot-Specialist Alley",
			"		i. Accept "..cq("Recharging the Batteries"),
			completion={{questaccepted="Recharging the Batteries"}},
			mapzone="Netherstorm",
			level=67,
			mapnote=56608810,
		}, {
			"Go northwest to "..cl(26,52),
			"	a. Kill Phase Hunters",
			"	b. You will see a message in your chat window saying "..cq("Phase Hunter is very weak"),
			"	c. Use your Battery Recharging Blaster on them when you see this message",
			"	d. Get 10 Battery Charge Levels",
			completion={{questgoal={"*","Battery Charge Level",10}}},
			mapzone="Netherstorm",
			level=67,
			mapnote=51907840,
		}, {
			"Go southeast to "..cl(32,57),
			"	a. Talk to Bot-Specialist Alley",
			"		i. Turn in "..cq("Recharging the Batteries"),
			completion={{questturnedin="Recharging the Batteries"}},
			mapzone="Netherstorm",
			level=67,
			mapnote=56608810,
		}, {
			"Go south to Area 52",
			completion={{location={mapzone="Netherstorm",x=32.3,y=65.5, dist=3}}},
			mapzone="Netherstorm",
			level=67,
		}, {
			"Go to "..cl(32,64),
			"	a. Talk to Boots",
			"		i. Accept "..cq("Securing the Shaleskin Shale"),
			completion={{questaccepted="Securing the Shaleskin Shale"}},
			mapzone="Netherstorm",
			level=67,
			mapnote=63909620,
		}, {
			"Go to "..cl(33,64),
			"	a. Talk to Nether-Stalker Khay'ji",
			"		i. Accept "..cq("Consortium Crystal Collection"),
			completion={{questaccepted="Consortium Crystal Collection"}},
			mapzone="Netherstorm",
			level=67,
			mapnote=64209660,
		}, {
			"Go to "..cl(32,64),
			"	a. Talk to Exarch Orelis",
			"		i. Accept "..cq("Distraction at Manaforge B'naar"),
			completion={{questaccepted="Distraction at Manaforge B'naar"}},
			mapzone="Netherstorm",
			level=67,
			mapnote=64209630,
		}, {
			"Make Area 52 your home",
			completion={{home="Area 52"}},
			mapzone="Netherstorm",
			level=67,
		}, {
			"Go to "..cl(33,65),
			"	a. Talk to Rocket-Chief Fuselage",
			"		i. Turn in "..cq("Off to Area 52"),
			"		ii. Accept "..cq("You're Hired!"),
			completion={{questturnedin="Off to Area 52"},{questaccepted="You're Hired!"}},
			mapzone="Netherstorm",
			level=67,
			mapnote=65009770,
		}, {
			"Go to "..cl(31,66),
			"	a. Talk to Ravandwyr",
			"		i. Accept "..cq("The Archmage's Staff"),
			completion={{questaccepted="The Archmage's Staff"}},
			mapzone="Netherstorm",
			level=67,
			mapnote=66209760,
		}, {
			"Go north to "..cl(33,60),
			"	a. Kill Shaleskin Flayers",
			"	b. Get 5 Shaleskin Shales",
			completion={{questgoal={"*","Shaleskin Shale",5}}},
			mapzone="Netherstorm",
			level=67,
			mapnote=60009310,
		}, {
			"Go northwest to "..cl(32,57),
			"	a. Talk to Maxx A. Million Mk. V",
			"		i. Accept "..cq("Mark V is Alive!"),
			"	b. Escort Maxx A. Million Mk. V",
			"	c. While escorting Maxx A. Million Mk. V:",
			"		i. Click the red glowing crystals on the ground",
			"		ii. Get 10 Etherlithium Matrix Crystals",
			completion={{questgoal={"*","Etherlithium Matrix Crystal",10}},{questaccepted="Mark V is Alive!"},{questgoal={"*","Escort the Maxx A. Million Mk. V safely through the Ruins of Enkaat",1}}},
			mapzone="Netherstorm",
			level=67,
			mapnote=56608810,
		}, {
			"Go to "..cl(32,57),
			"	a. Talk to Bot-Specialist Alley",
			"		i. Turn in "..cq("Mark V is Alive!"),
			completion={{questturnedin="Mark V is Alive!"}},
			mapzone="Netherstorm",
			level=67,
			mapnote=56608810,
		}, {
			"Go south to Area 52",
			completion={{location={mapzone="Netherstorm",x=32.3,y=65.5, dist=3}}},
			mapzone="Netherstorm",
			level=67,
		}, {
			"Go to "..cl(32,64),
			"	a. Talk to Boots",
			"		i. Turn in "..cq("Securing the Shaleskin Shale"),
			"		ii. Accept "..cq("That Little Extra Kick"),
			completion={{questturnedin="Securing the Shaleskin Shale"},{questaccepted="That Little Extra Kick"}},
			mapzone="Netherstorm",
			level=67,
			mapnote=63909620,
		}, {
			"Go to "..cl(33,65),
			"	a. Talk to Rocket-Chief Fuselage",
			"		i. Turn in "..cq("You're Hired!"),
			"		ii. Accept "..cq("Invaluable Asset Zapping"),
			"		iii. Accept "..cq("Report to Engineering"),
			completion={{questturnedin="You're Hired!"},{questaccepted="Invaluable Asset Zapping"},{questaccepted="Report to Engineering"}},
			mapzone="Netherstorm",
			level=67,
			mapnote=65009770,
		}, {
			"Go to "..cl(33,67),
			"	a. Talk to Chief Engineer Trep",
			"		i. Turn in "..cq("Report to Engineering"),
			"		ii. Accept "..cq("Essence for the Engines"),
			completion={{questturnedin="Report to Engineering"},{questaccepted="Essence for the Engines"}},
			mapzone="Netherstorm",
			level=67,
			mapnote=66809920,
		}, {
			"Go northeast to "..cl(35,59),
			"	a. Kill Mana Wraiths",
			"	b. Get 7 Mana Wraith Essences",
			completion={{questgoal={"*","Mana Wraith Essence",7}}},
			mapzone="Netherstorm",
			level=67,
			mapnote=59109390,
		}, {
			"Go west to "..cl(32,61),
			"	a. Kill Nether Rays",
			"		i. They are uncommon, so just grind in this area",
			"	b. Get 5 Nether Ray Stingers",
			completion={{questgoal={"*","Nether Ray Stinger",5}}},
			mapzone="Netherstorm",
			level=67,
			mapnote=60609270,
		}, {
			"Go south to Area 52",
			completion={{location={mapzone="Netherstorm",x=32.3,y=65.5, dist=3}}},
			mapzone="Netherstorm",
			level=67,
		}, {
			"Go to "..cl(32,64),
			"	a. Talk to Boots",
			"		i. Turn in "..cq("That Little Extra Kick"),
			completion={{questturnedin="That Little Extra Kick"}},
			mapzone="Netherstorm",
			level=67,
			mapnote=63909620,
		}, {
			"Go to "..cl(33,67),
			"	a. Talk to Chief Engineer Trep",
			"		i. Turn in "..cq("Essence for the Engines"),
			"		ii. Accept "..cq("Elemental Power Extraction"),
			completion={{questturnedin="Essence for the Engines"},{questaccepted="Elemental Power Extraction"}},
			mapzone="Netherstorm",
			level=67,
			mapnote=66809920,
		}, {
			"Go west to "..cl(26,67),
			"	a. Kill 8 Sunfury Magisters",
			"	b. Kill 8 Sunfury Bloodwarders",
			completion={{questgoal={"*","Sunfury Magister slain",8}},{questgoal={"*","Sunfury Bloodwarder slain",8}}},
			mapzone="Netherstorm",
			level=67,
			mapnote=66709300,
		}, {
			"Go southeast to "..cl(35,77),
			"	a. Use the Elemental Power Extractor on Sundered Rumblers and Warp Aberrations",
			"	b. Kill them",
			"	c. Click the blue crystal floating above their corpses",
			"	d. Get 5 Elemental Powers",
			completion={{questgoal={"*","Elemental Power",5}}},
			mapzone="Netherstorm",
			level=67,
			mapnote=76511190,
		}, {
			"Go northeast to "..cl(40,73),
			"	a. Click the tall metal turret with the gun pointing at the ground",
			"	b. Retrieve the Multi-Spectrum Terrain Analyzer",
			completion={{questgoal={"*","Multi-Spectrum Terrain Analyzer retrieved",1}}},
			mapzone="Netherstorm",
			level=67,
			mapnote=72911320,
		}, {
			"Go southeast to "..cl(41,74),
			"	a. Click the wooden cart with a big digging wheel on it",
			"	b. Retrieve the Hyper Rotational Dig-A-Matic",
			completion={{questgoal={"*","Hyper Rotational Dig-A-Matic retrieved",1}}},
			mapzone="Netherstorm",
			level=67,
			mapnote=73811480,
		}, {
			"Go northeast to "..cl(42,73),
			"	a. Kill Pentatharon",
			"	b. Get the Arklon Crystal Artifact",
			completion={{questgoal={"*","Arklon Crystal Artifact",1}}},
			mapzone="Netherstorm",
			level=67,
			mapnote=72811520,
		}, {
			"Go north to "..cl(43,72),
			"	a. Click the wagon with a bunch of explosives on it",
			"	b. Retrieve the Big Wagon Full of Explosives",
			completion={{questgoal={"*","Big Wagon Full of Explosives retrieved",1}}},
			mapzone="Netherstorm",
			level=67,
			mapnote=72211470,
		}, {
			"Go west to "..cl(41,72),
			"	a. Click the crane digging machine with a bunch of gears on it",
			"	b. Retrieve the Servo-Pneumatic Dredging Claw",
			completion={{questgoal={"*","Servo-Pneumatic Dredging Claw retrieved",1}}},
			mapzone="Netherstorm",
			level=67,
			mapnote=71811320,
		}, {
			"Go southwest to "..cl(41,73),
			"	a. Get next to the broken, smoking altar on the small hill",
			"	b. Use your Conjuring Powder to summon Ekkorash",
			"	c. Kill Ekkorash",
			"	d. Get Archmage Vargoth's Staff",
			completion={{questgoal={"*","Archmage Vargoth's Staff",1}}},
			mapzone="Netherstorm",
			level=67,
			mapnote=72511340,
		}, {
			"Go northwest to "..cl(34,68),
			"	a. Talk to Lead Sapper Blastfizzle",
			"		i. Turn in "..cq("Invaluable Asset Zapping"),
			"		ii. Accept "..cq("Dr. Boom!"),
			completion={{questturnedin="Invaluable Asset Zapping"},{questaccepted="Dr. Boom!"}},
			mapzone="Netherstorm",
			level=67,
			mapnote=68110230,
		}, {
			"Go north to Area 52",
			completion={{location={mapzone="Netherstorm",x=32.3,y=65.5, dist=3}}},
			mapzone="Netherstorm",
			level=67,
		}, {
			"Go to "..cl(31,66),
			"	a. Talk to Ravandwyr",
			"		i. Turn in "..cq("The Archmage's Staff"),
			"		ii. Accept "..cq("Rebuilding the Staff"),
			completion={{questturnedin="The Archmage's Staff"},{questaccepted="Rebuilding the Staff"}},
			mapzone="Netherstorm",
			level=67,
			mapnote=66209760,
		}, {
			"Go to "..cl(33,67),
			"	a. Talk to Chief Engineer Trep",
			"		i. Turn in "..cq("Elemental Power Extraction"),
			completion={{questturnedin="Elemental Power Extraction"}},
			mapzone="Netherstorm",
			level=67,
			mapnote=66809920,
		}, {
			"Go to "..cl(33,64),
			"	a. Talk to Nether-Stalker Khay'ji",
			"		i. Turn in "..cq("Consortium Crystal Collection"),
			"		ii. Accept "..cq("A Heap of Ethereals"),
			completion={{questturnedin="Consortium Crystal Collection"},{questaccepted="A Heap of Ethereals"}},
			mapzone="Netherstorm",
			level=67,
			mapnote=64209660,
		}, {
			"Go to "..cl(32,64),
			"	a. Talk to Exarch Orelis",
			"		i. Turn in "..cq("Distraction at Manaforge B'naar"),
			"		ii. Accept "..cq("Measuring Warp Energies"),
			"	b. Talk to Anchorite Karja",
			"		i. Accept "..cq("Naaru Technology"),
			completion={{questturnedin="Distraction at Manaforge B'naar"},{questaccepted="Measuring Warp Energies"},{questaccepted="Naaru Technology"}},
			mapzone="Netherstorm",
			level=67,
			mapnote=64209630,
		}, {
			"Go to "..cl(33,65),
			"	a. Talk to Papa Wheeler",
			"		i. Accept "..cq("Pick Your Part"),
			completion={{questaccepted="Pick Your Part"}},
			mapzone="Netherstorm",
			level=67,
			mapnote=64709770,
		}, {
			"Go to "..cl(34,53),
			"	a. Kill Disembodied Ghosts",
			"	b. Get 4 Flawless Crystal Shards",
			completion={{questgoal={"*","Flawless Crystal Shard",4}}},
			mapzone="Netherstorm",
			level=67,
			mapnote=53008650,
		}, {
			"Go southeast to "..cl(35,60),
			"	a. Dr. Boom sends out little walking bombs that blow up",
			"		i. Don't let them hit you, they hurt really bad",
			"	b. When you see a clear path to Dr. Boom:",
			"		i. Click Boom's Doom in your bags",
			"		ii. Run up and throw the bomb at Dr. Boom",
			"	c. Repeat until Dr. Boom is dead",
			completion={{questgoal={"*","Dr. Boom slain",1}}},
			mapzone="Netherstorm",
			level=67,
			mapnote=59609460,
		}, {
			"Go south to Area 52",
			completion={{location={mapzone="Netherstorm",x=32.3,y=65.5, dist=3}}},
			mapzone="Netherstorm",
			level=67,
		}, {
			"Go to "..cl(31,66),
			"	a. Talk to Ravandwyr",
			"		i. Turn in "..cq("Rebuilding the Staff"),
			"		ii. Accept "..cq("Curse of the Violet Tower"),
			completion={{questturnedin="Rebuilding the Staff"},{questaccepted="Curse of the Violet Tower"}},
			mapzone="Netherstorm",
			level=67,
			mapnote=66209760,
		}, {
			"Go to "..cl(34,68),
			"	a. Talk to Lead Sapper Blastfizzle",
			"		i. Turn in "..cq("Dr. Boom!"),
			completion={{questturnedin="Dr. Boom!"}},
			mapzone="Netherstorm",
			level=67,
			mapnote=68110230,
		}, {
			"Go northwest to "..cl(26,61),
			"	a. Get next to the Northern Pipeline",
			"	b. Use your Warp-Attuned Orb",
			"	c. Measure the Northern Pipeline",
			completion={{questgoal={"*","Northern Pipeline Measured",1}}},
			mapzone="Netherstorm",
			level=67,
			mapnote=60608630,
		}, {
			"Go southwest to "..cl(21,67),
			"	a. Get next to the Western Pipeline",
			"	b. Use your Warp-Attuned Orb",
			"	c. Measure the Western Pipeline",
			completion={{questgoal={"*","Western Pipeline Measured",1}}},
			mapzone="Netherstorm",
			level=67,
			mapnote=66908780,
		}, {
			"Go south to "..cl(21,71),
			"	a. Get next to the Southern Pipeline",
			"	b. Use your Warp-Attuned Orb",
			"	c. Measure the Southern Pipeline",
			completion={{questgoal={"*","Southern Pipeline Measured",1}}},
			mapzone="Netherstorm",
			level=67,
			mapnote=70709140,
		}, {
			"Go to "..cl(23,68),
			"	a. Click the B'naar Control Console",
			"		i. Turn in "..cq("Naaru Technology"),
			"		ii. Accept "..cq("B'naar Console Transcription"),
			completion={{questturnedin="Naaru Technology"},{questaccepted="B'naar Console Transcription"}},
			mapzone="Netherstorm",
			level=67,
			mapnote=68209140,
		}, {
			"Go east to "..cl(29,73),
			"	a. Get next to the Eastern Pipeline",
			"	b. Use your Warp-Attuned Orb",
			"	c. Measure the Eastern Pipeline",
			completion={{questgoal={"*","Eastern Pipeline Measured",1}}},
			mapzone="Netherstorm",
			level=67,
			mapnote=72710170,
		}, {
			"Go southeast to "..cl(30,76),
			"	a. Kill Zaxxis mummies",
			"	b. Get 10 Zaxxis Insignias",
			"	c. Click the Ethereal Technology on the ground",
			"	d. Get 10 Ethereal Technology",
			completion={{questgoal={"*","Ethereal Technology",10}},{questgoal={"*","Zaxxis Insignia",10}}},
			mapzone="Netherstorm",
			level=67,
			mapnote=75510570,
		}, {
			"Go northeast to Area 52",
			completion={{location={mapzone="Netherstorm",x=32.3,y=65.5, dist=3}}},
			mapzone="Netherstorm",
			level=67,
		}, {
			"Go to "..cl(33,65),
			"	a. Talk to Papa Wheeler",
			"		i. Turn in "..cq("Pick Your Part"),
			"		ii. Accept "..cq("In A Scrap With The Legion"),
			"		iii. Accept "..cq("Help Mama Wheeler"),
			completion={{questturnedin="Pick Your Part"},{questaccepted="In A Scrap With The Legion"},{questaccepted="Help Mama Wheeler"}},
			mapzone="Netherstorm",
			level=67,
			mapnote=64709770,
		}, {
			"Go to "..cl(33,64),
			"	a. Talk to Nether-Stalker Khay'ji",
			"		i. Turn in "..cq("A Heap of Ethereals"),
			"		ii. Accept "..cq("Warp-Raider Nesaad"),
			completion={{questturnedin="A Heap of Ethereals"},{questaccepted="Warp-Raider Nesaad"}},
			mapzone="Netherstorm",
			level=67,
			mapnote=64209660,
		}, {
			"Go to "..cl(32,64),
			"	a. Talk to Exarch Orelis",
			"		i. Turn in "..cq("Measuring Warp Energies"),
			"	b. Talk to Anchorite Karja",
			"		i. Turn in "..cq("B'naar Console Transcription"),
			"		ii. Accept "..cq("Shutting Down Manaforge B'naar"),
			completion={{questturnedin="Measuring Warp Energies"},{questturnedin="B'naar Console Transcription"},{questaccepted="Shutting Down Manaforge B'naar"}},
			mapzone="Netherstorm",
			level=67,
			mapnote=64209630,
		}, {
			"Go southwest to Manaforge B'naar",
			completion={{location={mapzone="Netherstorm",x=23.4,y=68.6, dist=3}}},
			mapzone="Netherstorm",
			level=67,
		}, {
			"Go inside Manaforge B'naar",
			completion={{location={mapzone="Netherstorm",x=23.3,y=68.6, dist=1.5}}},
			mapzone="Netherstorm",
			level=67,
		}, {
			"Go to "..cl(24,71),
			"	a. Kill Overseer Theredis",
			"	b. Get the B'naar Access Crystal",
			completion={{questgoal={"*","B'naar Access Crystal",1}}},
			mapzone="Netherstorm",
			level=67,
			mapnote=70709460,
		}, {
			"Go to "..cl(23,70),
			"	a. Use the B'naar Access Crystal to shut down Manaforge B'naar",
			"	b. Kill the technicians as they come to try to save the Manaforge",
			"		i. Only takes 2 minutes",
			completion={{questgoal={"*","Manaforge B'naar Shut Down",1}}},
			mapzone="Netherstorm",
			level=67,
			mapnote=68509150,
		}, {
			"Go northeast to Area 52",
			completion={{location={mapzone="Netherstorm",x=32.3,y=65.5, dist=3}}},
			mapzone="Netherstorm",
			level=67,
		}, {
			"Go to "..cl(32,64),
			"	a. Talk to Anchorite Karja",
			"		i. Turn in "..cq("Shutting Down Manaforge B'naar"),
			"		ii. Accept "..cq("Shutting Down Manaforge Coruu"),
			"	b. Talk to Exarch Orelis",
			"		i. Accept "..cq("Attack on Manaforge Coruu"),
			completion={{questturnedin="Shutting Down Manaforge B'naar"},{questaccepted="Shutting Down Manaforge Coruu"},{questaccepted="Attack on Manaforge Coruu"}},
			mapzone="Netherstorm",
			level=67,
			mapnote=64209630,
		}, {
			"Go southwest to "..cl(28,79),
			"	a. Kill Warp-Raider Nesaad",
			completion={{questgoal={"*","Warp-Raider Nesaad slain",1}}},
			mapzone="Netherstorm",
			level=67,
			mapnote=79410760,
		}, {
			"Go northeast to Area 52",
			completion={{location={mapzone="Netherstorm",x=32.3,y=65.5, dist=3}}},
			mapzone="Netherstorm",
			level=67,
		}, {
			"Go to "..cl(33,64),
			"	a. Talk to Nether-Stalker Khay'ji",
			"		i. Turn in "..cq("Warp-Raider Nesaad"),
			"		ii. Accept "..cq("Request for Assistance"),
			completion={{questturnedin="Warp-Raider Nesaad"},{questaccepted="Request for Assistance"}},
			mapzone="Netherstorm",
			level=67,
			mapnote=64209660,
		}, {
			"Go southeast to "..cl(46,79),
			"	a. Kill 5 Sunfury Researchers",
			"	b. Kill 8 Sunfury Arcanists",
			completion={{questgoal={"*","Sunfury Researcher slain",5}},{questgoal={"*","Sunfury Arcanist slain",8}}},
			mapzone="Netherstorm",
			level=67,
			mapnote=79412530,
		}, {
			"Go to "..cl(49,82),
			"	a. Kill Overseer Seylanna",
			"	b. Get the Coruu Access Crystal",
			"	c. Use the Coruu Access Crystal to shut down Manaforge Coruu",
			"	d. Kill the technicians as they come to try to save the Manaforge",
			"		i. Only takes 2 minutes",
			completion={{questgoal={"*","Coruu Access Crystal",1}},{questgoal={"*","Manaforge Coruu Shut Down",1}}},
			mapzone="Netherstorm",
			level=67,
			mapnote=81513050,
		}, {
			"Go southeast to Kirin'Var Village",
			completion={{location={mapzone="Netherstorm",x=59.8,y=89.2, dist=6}}},
			mapzone="Netherstorm",
			level=67,
		}, {
			"Go to "..cl(58,85),
			"	a. Talk to Thadell",
			"		i. Accept "..cq("Needs More Cowbell"),
			"	b. Talk to Apprentice Andrethan",
			"		i. Accept "..cq("Indispensable Tools"),
			completion={{questaccepted="Needs More Cowbell"},{questaccepted="Indispensable Tools"}},
			mapzone="Netherstorm",
			level=67,
			mapnote=85214290,
		}, {
			"Go to "..cl(58,86),
			"	a. Talk to Custodian Dieworth",
			"		i. Accept "..cq("Malevolent Remnants"),
			"	b. Use Archmage Vargoth's Staff",
			"	c. Talk to the Image of Archmage Vargoth",
			"		i. Turn in "..cq("Curse of the Violet Tower"),
			"		ii. Accept "..cq("The Sigil of Krasus"),
			"	d. Talk to Lieutenant-Sorcerer Morran",
			"		i. Accept "..cq("The Unending Invasion"),
			"	e. Talk to Custodian Dieworth",
			"		i. Accept "..cq("A Fate Worse Than Death"),
			completion={{questaccepted="Malevolent Remnants"},{questturnedin="Curse of the Violet Tower"},{questaccepted="The Sigil of Krasus"},{questaccepted="The Unending Invasion"},{questaccepted="A Fate Worse Than Death"}},
			mapzone="Netherstorm",
			level=67,
			mapnote=86314380,
		}, {
			"Kill 20 Severed Spirits as you quest around in this area",
			completion={{questgoal={"*","Severed Spirit slain",20}}},
			mapzone="Netherstorm",
			level=67,
		}, {
			"Go northeast to "..cl(59,79),
			"	a. Talk to Bessy",
			"		i. Turn in "..cq("Needs More Cowbell"),
			"		ii. Accept "..cq("When the Cows Come Home"),
			"	b. Escort Bessy to Thadell",
			"		i. Let her get hit first or she won't help you fight",
			completion={{questturnedin="Needs More Cowbell"},{questaccepted="When the Cows Come Home"},{questgoal={"*","Escort Bessy on her way home.",1}}},
			mapzone="Netherstorm",
			level=67,
			mapnote=78813790,
		}, {
			"At "..cl(58,85),
			"	a. Talk to Thadell",
			"		i. Turn in "..cq("When the Cows Come Home"),
			completion={{questturnedin="When the Cows Come Home"}},
			mapzone="Netherstorm",
			level=67,
			mapnote=85214290,
		}, {
			"Go south to "..cl(58,88),
			"	a. Kill Abjurist Belmara",
			"	b. Get Belmara's Tome",
			"	c. Click Belmara's Tome",
			"		i. Accept "..cq("Abjurist Belmara"),
			completion={{questaccepted="Abjurist Belmara"}},
			mapzone="Netherstorm",
			level=67,
			mapnote=88314670,
		}, {
			"Go east to "..cl(60,88),
			"	a. Kill Cohlien Frostweaver",
			"	b. Get Cohlien's Cap",
			"	c. Click Cohlien's Cap",
			"		i. Accept "..cq("Cohlien Frostweaver"),
			completion={{questaccepted="Cohlien Frostweaver"}},
			mapzone="Netherstorm",
			level=67,
			mapnote=87714730,
		}, {
			"Also at "..cl(60,88),
			"	a. Go inside the town hall looking building",
			"	b. Kill Battle-Mage Dathric",
			"	c. Get Dathric's Blade",
			"	d. Click Dathric's Blade",
			"		i. Accept "..cq("Battle-Mage Dathric"),
			completion={{questaccepted="Battle-Mage Dathric"}},
			mapzone="Netherstorm",
			level=67,
			mapnote=88014840,
		}, {
			"Go north to "..cl(60,86),
			"	a. Kill Conjurer Luminrath",
			"	b. Get Luminrath's Mantle",
			"	c. Click Luminrath's Mantle",
			"		i. Accept "..cq("Conjurer Luminrath"),
			completion={{questaccepted="Conjurer Luminrath"}},
			mapzone="Netherstorm",
			level=67,
			mapnote=85614550,
		}, {
			"Go east to "..cl(61,85),
			"	a. Kill Kirin'Var Apprentices",
			"	b. Get a Smithing Hammer",
			completion={{questgoal={"*","Smithing Hammer",1}}},
			mapzone="Netherstorm",
			level=67,
			mapnote=85014600,
		}, {
			"Go west to "..cl(58,85),
			"	a. Talk to Apprentice Andrethan",
			"		i. Turn in "..cq("Indispensable Tools"),
			"		ii. Accept "..cq("Master Smith Rhonsus"),
			completion={{questturnedin="Indispensable Tools"},{questaccepted="Master Smith Rhonsus"}},
			mapzone="Netherstorm",
			level=67,
			mapnote=85214290,
		}, {
			"Go to "..cl(58,86),
			"	a. Talk to Custodian Dieworth",
			"		i. Turn in "..cq("Malevolent Remnants"),
			"		ii. Accept "..cq("The Annals of Kirin'Var"),
			completion={{questturnedin="Malevolent Remnants"},{questaccepted="The Annals of Kirin'Var"}},
			mapzone="Netherstorm",
			level=67,
			mapnote=86314380,
		}, {
			"Go east to "..cl(62,85),
			"	a. Kill Master Smith Rhonsus",
			completion={{questgoal={"*","Rhonsus slain",1}}},
			mapzone="Netherstorm",
			level=67,
			mapnote=85014630,
		}, {
			"Go west to "..cl(58,85),
			"	a. Talk to Apprentice Andrethan",
			"		i. Turn in "..cq("Master Smith Rhonsus"),
			completion={{questturnedin="Master Smith Rhonsus"}},
			mapzone="Netherstorm",
			level=67,
			mapnote=85214290,
		}, {
			"Kill 10 Mana Seekers and 10 Mageslayers as you do the following quests",
			completion={{questgoal={"*","Mana Seeker slain",10}},{questgoal={"*","Mageslayer slain",10}}},
			mapzone="Netherstorm",
			level=67,
		}, {
			"Go south "..cl(57,87),
			"	a. Go inside the little house",
			"	b. Click Dathric's Blade when standing next to the Weapon Rack",
			"	c. Put Dathric's Spirit to Rest",
			completion={{questgoal={"*","Put Dathric's Spirit to Rest",1}}},
			mapzone="Netherstorm",
			level=67,
			mapnote=86814370,
		}, {
			"Go south to "..cl(56,88),
			"	a. Go inside the little house",
			"	b. Click Luminrath's Mantle when standing next to the Dresser",
			"	c. Put Luminrath's Spirit to Rest",
			completion={{questgoal={"*","Put Luminrath's Spirit to Rest",1}}},
			mapzone="Netherstorm",
			level=67,
			mapnote=87814420,
		}, {
			"Go west to "..cl(56,87),
			"	a. Click the big white ball with blue dots on it",
			"	b. Get the Mana Bomb Fragment",
			completion={{questgoal={"*","Mana Bomb Fragment",1}}},
			mapzone="Netherstorm",
			level=67,
			mapnote=87214290,
		}, {
			"Go west to "..cl(55,88),
			"	a. The Foot Locker is in a pile of junk in a house with no roof",
			"	b. Click Cohlien's Cap when standing next to the Foot Locker",
			"	c. Put Cohlien's Spirit to Rest",
			completion={{questgoal={"*","Put Cohlien's Spirit to Rest",1}}},
			mapzone="Netherstorm",
			level=67,
			mapnote=87514260,
		}, {
			"Go north to "..cl(56,86),
			"	a. Go inside the house with a huge log laying diagonally into it",
			"	b. Click Belmara's Tome when standing next to the Bookshelf",
			"	c. Put Belmara's Spirit to Rest",
			completion={{questgoal={"*","Put Belmara's Spirit to Rest",1}}},
			mapzone="Netherstorm",
			level=67,
			mapnote=86514200,
		}, {
			"Go east to "..cl(58,86),
			"	a. Talk to Custodian Dieworth",
			"		i. Turn in "..cq("A Fate Worse Than Death"),
			"		ii. Turn in "..cq("Abjurist Belmara"),
			"		iii. Turn in "..cq("Conjurer Luminrath"),
			"		iv. Turn in "..cq("Cohlien Frostweaver"),
			"		v. Turn in "..cq("Battle-Mage Dathric"),
			"	b. Talk to Lieutenant-Sorcerer Morran",
			"		i. Turn in "..cq("The Unending Invasion"),
			"		ii. Accept "..cq("Potential Energy Source"),
			completion={{questturnedin="A Fate Worse Than Death"},{questturnedin="Abjurist Belmara"},{questturnedin="Conjurer Luminrath"},{questturnedin="Cohlien Frostweaver"},{questturnedin="Battle-Mage Dathric"},{questturnedin="The Unending Invasion"},{questaccepted="Potential Energy Source"}},
			mapzone="Netherstorm",
			level=67,
			mapnote=86314380,
		}, {
			"Grind to level 68",
			completion={{level=68}},
			mapzone="Netherstorm",
			level=67,
		}
	  },
	},
	{ sectiontitle = "Levels (68-70)",
	  steps = {
		{
			"Go east to "..cl(60,88),
			"	a. Kill Battle-Mage Dathric",
			"	b. Get The Annals of Kirin'Var",
			completion={{questgoal={"*","Annals of Kirin'Var",1}}},
			mapzone="Netherstorm",
			level=68,
			mapnote=88014840,
		}, {
			"Go west to "..cl(58,86),
			"	a. Talk to Custodian Dieworth",
			"		i. Turn in "..cq("The Annals of Kirin'Var"),
			"		ii. Accept "..cq("Searching for Evidence"),
			completion={{questturnedin="The Annals of Kirin'Var"},{questaccepted="Searching for Evidence"}},
			mapzone="Netherstorm",
			level=68,
			mapnote=86314380,
		}, {
			"Go northeast to "..cl(60,78),
			"	a. Go inside the barn",
			"	b. Click the Necromantic Focus",
			"		i. Turn in "..cq("Searching for Evidence"),
			"		ii. Accept "..cq("A Lingering Suspicion"),
			completion={{questturnedin="Searching for Evidence"},{questaccepted="A Lingering Suspicion"}},
			mapzone="Netherstorm",
			level=68,
			mapnote=78013830,
		}, {
			"Go south to "..cl(60,79),
			"	a. Kill ghosts around this area",
			"	b. Get 10 Loathsome Remnants",
			completion={{questgoal={"*","Loathsome Remnant",10}}},
			mapzone="Netherstorm",
			level=68,
			mapnote=79513930,
		}, {
			"Go southwest to "..cl(58,86),
			"	a. Talk to Custodian Dieworth",
			"		i. Turn in "..cq("A Lingering Suspicion"),
			"		ii. Accept "..cq("Capturing the Phylactery"),
			completion={{questturnedin="A Lingering Suspicion"},{questaccepted="Capturing the Phylactery"}},
			mapzone="Netherstorm",
			level=68,
			mapnote=86314380,
		}, {
			"Go northeast to "..cl(60,80),
			"	a. Go behind the first building on the right as you walk over the bridge",
			"	b. Click the Supicious Outhouse",
			"	c. Get Naberius's Phylactery",
			completion={{questgoal={"*","Naberius's Phylactery",1}}},
			mapzone="Netherstorm",
			level=68,
			mapnote=80414030,
		}, {
			"Go southwest to "..cl(58,86),
			"	a. Talk to Custodian Dieworth",
			"		i. Turn in "..cq("Capturing the Phylactery"),
			completion={{questturnedin="Capturing the Phylactery"}},
			mapzone="Netherstorm",
			level=68,
			mapnote=86314380,
		}, {
			"Go northwest to "..cl(51,83),
			"	a. Click the little clear boxes with purple light in them on the ground",
			"	b. Get 10 Energy Isolation Cubes",
			completion={{questgoal={"*","Energy Isolation Cube",10}}},
			mapzone="Netherstorm",
			level=68,
			mapnote=82513360,
		}, {
			"Go north to "..cl(51,81),
			"	a. Kill Spellbinder Maryana",
			"	b. Get the Sigil of Krasus",
			"	c. Use Archmage Vargoth's Staff",
			"	d. Talk to the Image of Archmage Vargoth",
			"		i. Turn in "..cq("The Sigil of Krasus"),
			"		ii. Accept "..cq("Krasus's Compendium"),
			completion={{questturnedin="The Sigil of Krasus"},{questaccepted="Krasus's Compendium"}},
			mapzone="Netherstorm",
			level=68,
			mapnote=80713180,
		}, {
			"Go southeast to "..cl(58,86),
			"	a. Talk to Lieutenant-Sorcerer Morran",
			"		i. Turn in "..cq("Potential Energy Source"),
			"		ii. Accept "..cq("Building a Perimeter"),
			completion={{questturnedin="Potential Energy Source"},{questaccepted="Building a Perimeter"}},
			mapzone="Netherstorm",
			level=68,
			mapnote=86314380,
		}, {
			"Go south to "..cl(58,90),
			"	a. Click the glowing scroll on the ground in the small house",
			"	b. Get Krasus's Compendium: Chapter 2",
			completion={{questgoal={"*","Krasus's Compendium - Chapter 2",1}}},
			mapzone="Netherstorm",
			level=68,
			mapnote=89614720,
		}, {
			"Go east to "..cl(59,89),
			"	a. Click the glowing scroll on a table in the small house",
			"	b. Get Krasus's Compendium: Chapter 1",
			completion={{questgoal={"*","Krasus's Compendium - Chapter 1",1}}},
			mapzone="Netherstorm",
			level=68,
			mapnote=89214780,
		}, {
			"Go north to "..cl(59,88),
			"	a. Click the glowing scroll on the ground in the small house",
			"	b. Get Krasus's Compendium: Chapter 3",
			"	c. Use Archmage Vargoth's Staff",
			"	d. Talk to the Image of Archmage Vargoth",
			"		i. Turn in "..cq("Krasus's Compendium"),
			"		ii. Accept "..cq("Unlocking the Compendium"),
			completion={{questturnedin="Krasus's Compendium"},{questaccepted="Unlocking the Compendium"}},
			mapzone="Netherstorm",
			level=68,
			mapnote=87914670,
		}, {
			"Go southeast to "..cl(59,85),
			"	a. Use your Rune Activation Device on the blue floating symbol",
			"	b. Activate the Eastern Rune",
			completion={{questgoal={"*","Activate Eastern Rune",1}}},
			mapzone="Netherstorm",
			level=68,
			mapnote=85414460,
		}, {
			"Go northwest to "..cl(57,83),
			"	a. Use your Rune Activation Device on the blue floating symbol",
			"	b. Activate the Northeastern Rune",
			completion={{questgoal={"*","Activate Northeastern Rune",1}}},
			mapzone="Netherstorm",
			level=68,
			mapnote=82914020,
		}, {
			"Go west to "..cl(54,86),
			"	a. Use your Rune Activation Device on the blue floating symbol",
			"	b. Activate the Western Rune",
			completion={{questgoal={"*","Activate Western Rune",1}}},
			mapzone="Netherstorm",
			level=68,
			mapnote=86114040,
		}, {
			"Go east to "..cl(58,86),
			"	a. Talk to Lieutenant-Sorcerer Morran",
			"		i. Turn in "..cq("Building a Perimeter"),
			"		ii. Accept "..cq("Torching Sunfury Hold"),
			"	b. Talk to Custodian Dieworth",
			"		i. Accept "..cq("The Sunfury Garrison"),
			completion={{questturnedin="Building a Perimeter"},{questaccepted="Torching Sunfury Hold"},{questaccepted="The Sunfury Garrison"}},
			mapzone="Netherstorm",
			level=68,
			mapnote=86314380,
		}, {
			"Go north to "..cl(56,80),
			"	a. Kill 10 Sunfury Archers",
			completion={{questgoal={"*","Sunfury Archer slain",10}}},
			mapzone="Netherstorm",
			level=68,
			mapnote=80113650,
		}, {
			"Go north to "..cl(56,79),
			"	a. Kill Spellweaver Marathelle",
			"	b. Get the Heliotrope Oculus",
			completion={{questgoal={"*","Heliotrope Oculus",1}}},
			mapzone="Netherstorm",
			level=68,
			mapnote=78513500,
		}, {
			"Go east to "..cl(57,79),
			"	a. Kill a Sunfury Flamekeeper",
			"	b. Get a Flaming Torch",
			"	c. Use the torch on the tall hut looking things and the big spear gun cars",
			"	d. Destroy 4 Sunfury Ballistas",
			"	e. Destroy 4 Sunfury Tents",
			completion={{questgoal={"*","Sunfury Ballista Destroyed",4}},{questgoal={"*","Sunfury Tent Destroyed",4}}},
			mapzone="Netherstorm",
			level=68,
			mapnote=78513530,
		}, {
			"Go south to Kirin'Var Village",
			completion={{location={mapzone="Netherstorm",x=59.8,y=89.2, dist=6}}},
			mapzone="Netherstorm",
			level=68,
		}, {
			"Use Archmage Vargoth's Staff",
			"	a. Talk to the Image of Archmage Vargoth",
			"		i. Turn in "..cq("Unlocking the Compendium"),
			"		ii. Accept "..cq("Summoner Kanthin's Prize"),
			completion={{questturnedin="Unlocking the Compendium"},{questaccepted="Summoner Kanthin's Prize"}},
			mapzone="Netherstorm",
			level=68,
		}, {
			"Go to "..cl(58,86),
			"	a. Talk to Lieutenant-Sorcerer Morran",
			"		i. Turn in "..cq("Torching Sunfury Hold"),
			"	b. Talk to Custodian Dieworth",
			"		i. Turn in "..cq("The Sunfury Garrison"),
			"		ii. Accept "..cq("Down With Daellis"),
			completion={{questturnedin="Torching Sunfury Hold"},{questturnedin="The Sunfury Garrison"},{questaccepted="Down With Daellis"}},
			mapzone="Netherstorm",
			level=68,
			mapnote=86314380,
		}, {
			"Go to Area 52",
			completion={{location={mapzone="Netherstorm",x=32.3,y=65.5, dist=3}}},
			mapzone="Netherstorm",
			level=68,
		}, {
			"Go to "..cl(32,64),
			"	a. Talk to Exarch Orelis",
			"		i. Turn in "..cq("Attack on Manaforge Coruu"),
			"	b. Talk to Anchorite Karja",
			"		i. Turn in "..cq("Shutting Down Manaforge Coruu"),
			"		ii. Accept "..cq("Shutting Down Manaforge Duro"),
			"	c. Talk to Exarch Orelis",
			"		i. Accept "..cq("Sunfury Briefings"),
			completion={{questturnedin="Attack on Manaforge Coruu"},{questturnedin="Shutting Down Manaforge Coruu"},{questaccepted="Shutting Down Manaforge Duro"},{questaccepted="Sunfury Briefings"}},
			mapzone="Netherstorm",
			level=68,
			mapnote=64209630,
		}, {
			"Go northeast to Eco-Dome Midrealm",
			completion={{location={mapzone="Netherstorm",x=45.5,y=53.1, dist=6}}},
			mapzone="Netherstorm",
			level=68,
		}, {
			"Go to "..cl(47,57),
			"	a. Talk to Gahruj",
			"		i. Turn in "..cq("Request for Assistance"),
			"		ii. Accept "..cq("Rightful Repossession"),
			"		iii. Accept "..cq("Drijya Needs Your Help"),
			completion={{questturnedin="Request for Assistance"},{questaccepted="Rightful Repossession"},{questaccepted="Drijya Needs Your Help"}},
			mapzone="Netherstorm",
			level=68,
			mapnote=56910360,
		}, {
			"Also at "..cl(47,57),
			"	a. Talk to Mama Wheeler",
			"		i. Turn in "..cq("Help Mama Wheeler"),
			"		ii. Accept "..cq("One Demon's Trash..."),
			completion={{questturnedin="Help Mama Wheeler"},{questaccepted="One Demon's Trash..."}},
			mapzone="Netherstorm",
			level=68,
			mapnote=56510310,
		}, {
			"Go to "..cl(47,56),
			"	a. Talk to Mehrdad",
			"		i. Accept "..cq("Run a Diagnostic!"),
			"		ii. Accept "..cq("New Opportunities"),
			completion={{questaccepted="Run a Diagnostic!"},{questaccepted="New Opportunities"}},
			mapzone="Netherstorm",
			level=68,
			mapnote=56410290,
		}, {
			"Also at "..cl(47,56),
			"	a. Talk to Shauly Pore",
			"		i. Accept "..cq("Keeping Up Appearances"),
			completion={{questaccepted="Keeping Up Appearances"}},
			mapzone="Netherstorm",
			level=68,
			mapnote=56010250,
		}, {
			"Go northeast to "..cl(48,55),
			"	a. Click the Diagnostic Equipment",
			"	b. Get the Diagnostic Results",
			completion={{questgoal={"*","Diagnostic Results",1}}},
			mapzone="Netherstorm",
			level=68,
			mapnote=55010320,
		}, {
			"Go north to "..cl(48,54),
			"	a. Click the tall flowers with pinkish purple heads",
			"	b. Get 15 Ivory Bells",
			completion={{questgoal={"*","Ivory Bell",15}}},
			mapzone="Netherstorm",
			level=68,
			mapnote=53710190,
		}, {
			"Go northwest to "..cl(43,50),
			"	a. Kill Ripfang Lynxes",
			"	b. Get 10 Ripfang Lynx Pelts",
			completion={{questgoal={"*","Ripfang Lynx Pelt",10}}},
			mapzone="Netherstorm",
			level=68,
			mapnote=50409360,
		}, {
			"Go southeast to "..cl(47,56),
			"	a. Talk to Mehrdad",
			"		i. Turn in "..cq("Run a Diagnostic!"),
			"		ii. Accept "..cq("Deal With the Saboteurs"),
			"		iii. Turn in "..cq("New Opportunities"),
			completion={{questturnedin="Run a Diagnostic!"},{questaccepted="Deal With the Saboteurs"},{questturnedin="New Opportunities"}},
			mapzone="Netherstorm",
			level=68,
			mapnote=56410290,
		}, {
			"Also at "..cl(47,56),
			"	a. Talk to Shauly Pore",
			"		i. Turn in "..cq("Keeping Up Appearances"),
			"		ii. Accept "..cq("The Dynamic Duo"),
			completion={{questturnedin="Keeping Up Appearances"},{questaccepted="The Dynamic Duo"}},
			mapzone="Netherstorm",
			level=68,
			mapnote=56010250,
		}, {
			"Go north to "..cl(47,54),
			"	a. Kill 8 Barbscale Crocolisks",
			completion={{questgoal={"*","Barbscale Crocolisk slain",8}}},
			mapzone="Netherstorm",
			level=68,
			mapnote=54410170,
		}, {
			"Go south to "..cl(47,56),
			"	a. Talk to Mehrdad",
			"		i. Turn in "..cq("Deal With the Saboteurs"),
			"		ii. Accept "..cq("To the Stormspire"),
			completion={{questturnedin="Deal With the Saboteurs"},{questaccepted="To the Stormspire"}},
			mapzone="Netherstorm",
			level=68,
			mapnote=56410290,
		}, {
			"Go southeast to "..cl(49,52),
			"	a. Click the brown clumps of metal on the ground",
			"	b. Get 10 Fel Reaver Parts",
			completion={{questgoal={"*","Fel Reaver Part",10}}},
			mapzone="Netherstorm",
			level=68,
			mapnote=59310840,
		}, {
			"Go east to "..cl(50,60),
			"	a. Kill 5 Mo'arg Doomsmiths",
			"	b. Kill 15 Gan'arg Engineers",
			completion={{questgoal={"*","Mo'arg Doomsmith slain",5}},{questgoal={"*","Gan'arg Engineer slain",15}}},
			mapzone="Netherstorm",
			level=68,
			mapnote=59710970,
		}, {
			"Go northwest to "..cl(47,57),
			"	a. Talk to Mama Wheeler",
			"		i. Turn in "..cq("One Demon's Trash..."),
			"		ii. Accept "..cq("Declawing Doomclaw"),
			completion={{questturnedin="One Demon's Trash..."},{questaccepted="Declawing Doomclaw"}},
			mapzone="Netherstorm",
			level=68,
			mapnote=56510310,
		}, {
			"Go east to "..cl(51,57),
			"	a. Kill Doomclaw",
			"	b. Get Doomclaw's Hand",
			completion={{questgoal={"*","Doomclaw's Hand",1}}},
			mapzone="Netherstorm",
			level=68,
			mapnote=57210790,
		}, {
			"Go west to "..cl(47,57),
			"	a. Talk to Mama Wheeler",
			"		i. Turn in "..cq("Declawing Doomclaw"),
			"		ii. Accept "..cq("Warn Area 52!"),
			completion={{questturnedin="Declawing Doomclaw"},{questaccepted="Warn Area 52!"}},
			mapzone="Netherstorm",
			level=68,
			mapnote=56510310,
		}, {
			"Go south to "..cl(48,63),
			"	a. Talk to Drijya",
			"		i. Turn in "..cq("Drijya Needs Your Help"),
			completion={{questturnedin="Drijya Needs Your Help"}},
			mapzone="Netherstorm",
			level=68,
			mapnote=63511160,
		}, {
			"Go east to "..cl(56,64),
			"	a. Kill Sunfury Bowmen and Sunfury Centurions",
			"	b. Get the Sunfury Military Briefing",
			"	c. Kill Sunfury Conjurers",
			"	d. Get the Sunfury Arcane Briefing",
			completion={{questgoal={"*","Sunfury Military Briefing",1}},{questgoal={"*","Sunfury Arcane Briefing",1}}},
			mapzone="Netherstorm",
			level=68,
			mapnote=63811940,
		}, {
			"Go east to "..cl(57,64),
			"	a. Click the little white boxes on the ground",
			"	b. Get 10 Boxes of Surveying Equipment",
			completion={{questgoal={"*","Box of Surveying Equipment",10}}},
			mapzone="Netherstorm",
			level=68,
			mapnote=64112080,
		}, {
			"Go northeast to "..cl(58,63),
			"	a. Kill Summoner Kanthin",
			"		i. He wanders around this area",
			"	b. Get the Stone of Glacius",
			"	c. Use Archmage Vargoth's Staff",
			"	d. Talk to the Image of Archmage Vargoth",
			"		i. Turn in "..cq("Summoner Kanthin's Prize"),
			"		ii. Accept "..cq("Ar'kelos the Guardian"),
			completion={{questturnedin="Summoner Kanthin's Prize"},{questaccepted="Ar'kelos the Guardian"}},
			mapzone="Netherstorm",
			level=68,
			mapnote=63012090,
		}, {
			"Go southwest to "..cl(57,66),
			"	a. Kill Master Daellis Dawnstrike",
			"		i. He walks along the cliff here",
			completion={{questgoal={"*","Master Daellis Dawnstrike slain",1}}},
			mapzone="Netherstorm",
			level=68,
			mapnote=65712250,
		}, {
			"Go inside Manaforge Duro to "..cl(60,69),
			"	a. Kill Overseer Athanel",
			"	b. Get the Duro Access Crystal",
			completion={{questgoal={"*","Duro Access Crystal",1}}},
			mapzone="Netherstorm",
			level=68,
			mapnote=68512850,
		}, {
			"Go northwest to "..cl(59,68),
			"	a. Use the Duro Access Crystal to shut down Manaforge Duro",
			"	b. Kill the technicians as they come to try to save the Manaforge",
			"		i. Only takes 2 minutes",
			completion={{questgoal={"*","Manaforge Duro Shut Down",1}}},
			mapzone="Netherstorm",
			level=68,
			mapnote=66812590,
		}, {
			"Go east to "..cl(65,67),
			"	a. Talk to Harpax",
			"		i. Get the Cosmowrench Flight Path",
			completion={{flightpath="Cosmowrench"}},
			mapzone="Netherstorm",
			level=68,
			mapnote=66813200,
		}, {
			"Go southwest to Kirin'Var Village",
			completion={{location={mapzone="Netherstorm",x=59.8,y=89.2, dist=6}}},
			mapzone="Netherstorm",
			level=68,
		}, {
			"Go to "..cl(58,87),
			"	a. Kill Ar'kelos the Guardian",
			completion={{questgoal={"*","Ar'kelos slain",1}}},
			mapzone="Netherstorm",
			level=68,
			mapnote=86514470,
		}, {
			"Go to the top of the tower",
			mapzone="Netherstorm",
			level=68,
		}, {
			"Go to "..cl(58,86),
			"	a. Talk to Archmage Vargoth",
			"		i. Turn in "..cq("Ar'kelos the Guardian"),
			completion={{questturnedin="Ar'kelos the Guardian"}},
			mapzone="Netherstorm",
			level=68,
			mapnote=86414470,
		}, {
			"Go out of the tower",
			mapzone="Netherstorm",
			level=68,
		}, {
			"Go to "..cl(58,86),
			"	a. Talk to Custodian Dieworth",
			"		i. Turn in "..cq("Down With Daellis"),
			completion={{questturnedin="Down With Daellis"}},
			mapzone="Netherstorm",
			level=68,
			mapnote=86314380,
		}, {
			"Go to Area 52",
			completion={{location={mapzone="Netherstorm",x=32.3,y=65.5, dist=3}}},
			mapzone="Netherstorm",
			level=68,
		}, {
			"Go to "..cl(33,65),
			"	a. Talk to Papa Wheeler",
			"		i. Turn in "..cq("In a Scrap With The Legion"),
			completion={{questturnedin="In a Scrap With The Legion"}},
			mapzone="Netherstorm",
			level=68,
			mapnote=64709770,
		}, {
			"Also at "..cl(33,65),
			"	a. Talk to Rocket-Chief Fuselage",
			"		i. Turn in "..cq("Warn Area 52!"),
			completion={{questturnedin="Warn Area 52!"}},
			mapzone="Netherstorm",
			level=68,
			mapnote=65009770,
		}, {
			"Go to "..cl(32,64),
			"	a. Talk to Exarch Orelis",
			"		i. Turn in "..cq("Sunfury Briefings"),
			"		ii. Accept "..cq("Outside Assistance"),
			"	b. Talk to Anchorite Karja",
			"		i. Turn in "..cq("Shutting Down Manaforge Duro"),
			completion={{questturnedin="Sunfury Briefings"},{questaccepted="Outside Assistance"},{questturnedin="Shutting Down Manaforge Duro"}},
			mapzone="Netherstorm",
			level=68,
			mapnote=64209630,
		}, {
			"Fly to Cosmowrench",
			completion={{location={mapzone="Netherstorm",x=66.3,y=67.1, dist=2}}},
			mapzone="Netherstorm",
			level=68,
		}, {
			"Go to "..cl(66,67),
			"	a. Talk to Sab'aoth",
			"		i. Accept "..cq("Bloody Imp-ossible!"),
			completion={{questaccepted="Bloody Imp-ossible!"}},
			mapzone="Netherstorm",
			level=68,
			mapnote=67313370,
		}, {
			"Go northwest to "..cl(64,64),
			"	a. Use Zeppit's Crystal to summon Zeppit",
			"	b. He will follow you around",
			"	c. Kill Warp Chasers",
			"	d. Zeppit will run up to their corpses and create a Warp Chaser Blood for you",
			"	e. Get 8 Warp Chaser Blood",
			completion={{questgoal={"*","Warp Chaser Blood",8}}},
			mapzone="Netherstorm",
			level=68,
			mapnote=64212860,
		}, {
			"Go southeast to Cosmowrench",
			completion={{location={mapzone="Netherstorm",x=66.3,y=67.1, dist=2}}},
			mapzone="Netherstorm",
			level=68,
		}, {
			"Go to "..cl(66,67),
			"	a. Talk to Sab'aoth",
			"		i. Turn in "..cq("Bloody Imp-ossible!"),
			completion={{questturnedin="Bloody Imp-ossible!"}},
			mapzone="Netherstorm",
			level=68,
			mapnote=67313370,
		}, {
			"Go northwest to Eco-Dome Midrealm",
			completion={{location={mapzone="Netherstorm",x=45.5,y=53.1, dist=6}}},
			mapzone="Netherstorm",
			level=68,
		}, {
			"Go to "..cl(47,57),
			"	a. Talk to Gahruj",
			"		i. Turn in "..cq("Rightful Repossession"),
			"		ii. Accept "..cq("An Audience with the Prince"),
			completion={{questturnedin="Rightful Repossession"},{questaccepted="An Audience with the Prince"}},
			mapzone="Netherstorm",
			level=68,
			mapnote=56910360,
		}, {
			"Go north to the Stormspire",
			completion={{location={mapzone="Netherstorm",x=44.8,y=35.6, dist=6}}},
			mapzone="Netherstorm",
			level=68,
		}, {
			"Go to "..cl(42,33),
			"	a. Talk to Aurine Moonblaze",
			"		i. Accept "..cq("Flora of the Eco-Domes"),
			completion={{questaccepted="Flora of the Eco-Domes"}},
			mapzone="Netherstorm",
			level=68,
			mapnote=32607490,
		}, {
			"Go up the lift",
			mapzone="Netherstorm",
			level=68,
		}, {
			"Go to "..cl(44,35),
			"	a. Talk to Ghabar",
			"		i. Turn in "..cq("To the Stormspire"),
			"		ii. Accept "..cq("Diagnosis: Critical"),
			completion={{questturnedin="To the Stormspire"},{questaccepted="Diagnosis: Critical"}},
			mapzone="Netherstorm",
			level=68,
			mapnote=35107860,
		}, {
			"Make the Stormspire your home",
			completion={{home="the Stormspire"}},
			mapzone="Netherstorm",
			level=68,
		}, {
			"Go to "..cl(45,37),
			"	a. Talk to Audi the Needle",
			"		i. Turn in "..cq("The Dynamic Duo"),
			"		ii. Accept "..cq("Retrieving the Goods"),
			completion={{questturnedin="The Dynamic Duo"},{questaccepted="Retrieving the Goods"}},
			mapzone="Netherstorm",
			level=68,
			mapnote=36708140,
		}, {
			"Go to "..cl(46,36),
			"	a. Talk to the Image of Nexus-Prince Haramad",
			"		i. Turn in "..cq("An Audience with the Prince"),
			"		ii. Accept "..cq("Triangulation Point One"),
			completion={{questturnedin="An Audience with the Prince"},{questaccepted="Triangulation Point One"}},
			mapzone="Netherstorm",
			level=68,
			mapnote=36008190,
		}, {
			"Go to "..cl(45,35),
			"	a. Talk to Grennik",
			"		i. Get the Stormspire Flight Path",
			completion={{flightpath="Stormspire"}},
			mapzone="Netherstorm",
			level=68,
			mapnote=34908020,
		}, {
			"Also at "..cl(45,35),
			"	a. Talk to Nether-Stalker Nauthis",
			"		i. Accept "..cq("The Minions of Culuthas"),
			"		ii. Accept "..cq("Fel Reavers, No Thanks!"),
			"	b. Talk to Zephyrion",
			"		i. Accept "..cq("Surveying the Ruins"),
			completion={{questaccepted="The Minions of Culuthas"},{questaccepted="Fel Reavers, No Thanks!"},{questaccepted="Surveying the Ruins"}},
			mapzone="Netherstorm",
			level=68,
			mapnote=34907960,
		}, {
			"Go northwest to "..cl(41,32),
			"	a. Use your Energy Field Modulator on Farahlon Lashers",
			"	b. Kill them to Test the Energy Modulator",
			"	c. Test the Energy Modulator 10 times",
			completion={{questgoal={"*","Test Energy Modulator",10}}},
			mapzone="Netherstorm",
			level=68,
			mapnote=32207310,
		}, {
			"Go east to "..cl(42,33),
			"	a. Talk to Aurine Moonblaze",
			"		i. Turn in "..cq("Flora of the Eco-Domes"),
			"		ii. Accept "..cq("Creatures of the Eco-Domes"),
			completion={{questturnedin="Flora of the Eco-Domes"},{questaccepted="Creatures of the Eco-Domes"}},
			mapzone="Netherstorm",
			level=68,
			mapnote=32607490,
		}, {
			"Go north to "..cl(43,30),
			"	a. Fight Talbuk Sires and Talbuk Does until they are almost dead",
			"	b. Use your Talbuk Tagger to tag them",
			"	c. Tag 12 Talbuks",
			completion={{questgoal={"*","Talbuk Tagged",12}}},
			mapzone="Netherstorm",
			level=68,
			mapnote=29907310,
		}, {
			"Go northeast to "..cl(47,27),
			"	a. Stand in the small camp of equipment",
			"	b. Use your Diagnostic Device",
			"	c. Get the Diagnostic Results",
			completion={{questgoal={"*","Diagnostic Results",1}}},
			mapzone="Netherstorm",
			level=68,
			mapnote=26807440,
		}, {
			"Go northeast to "..cl(49,23),
			"	a. Kill 10 Hounds of Culuthas",
			"	b. Kill 5 Eyes of Culuthas",
			completion={{questgoal={"*","Hound of Culuthas slain",10}},{questgoal={"*","Eye of Culuthas slain",5}}},
			mapzone="Netherstorm",
			level=68,
			mapnote=22507190,
		}, {
			"Go northeast to "..cl(52,21),
			"	a. Get next to the leaning, purple glowing flag",
			"	b. Use your Surveying Markers",
			"	c. Mark Survey Marker One",
			completion={{questgoal={"*","Surveying Marker One placed",1}}},
			mapzone="Netherstorm",
			level=68,
			mapnote=20507210,
		}, {
			"Go southeast to "..cl(54,23),
			"	a. Get next to the leaning, purple glowing flag",
			"	b. Use your Surveying Markers",
			"	c. Mark Survey Marker Two",
			completion={{questgoal={"*","Surveying Marker Two placed",1}}},
			mapzone="Netherstorm",
			level=68,
			mapnote=22807740,
		}, {
			"Go northeast to "..cl(56,20),
			"	a. Get next to the leaning, purple glowing flag",
			"	b. Use your Surveying Markers",
			"	c. Mark Survey Marker Three",
			completion={{questgoal={"*","Surveying Marker Three placed",1}}},
			mapzone="Netherstorm",
			level=68,
			mapnote=19907570,
		}, {
			"Go northwest to "..cl(44,15),
			"	a. Click the little clear cases in the raptor nests with purple eggs",
			"	b. Get 10 Dome Generator Segments",
			completion={{questgoal={"*","Dome Generator Segment",10}}},
			mapzone="Netherstorm",
			level=68,
			mapnote=14705880,
		}, {
			"Go southwest to "..cl(39,26),
			"	a. Kill Gan'arg Mekgineers",
			"	b. Get 5 Condensed Nether Gas",
			completion={{item={"Condensed Nether Gas",5}}},
			mapzone="Netherstorm",
			level=68,
			mapnote=26206560,
		}, {
			"Go northwest to "..cl(38,26),
			"	a. Make sure you have 5 Condensed Nether Gas",
			"	b. Talk to the Inactive Fel Reaver",
			"		i. Destroy the Inactive Fel Reaver",
			completion={{questgoal={"*","Inactive Fel Reaver Destroyed",1}}},
			mapzone="Netherstorm",
			level=68,
			mapnote=25706370,
		}, {
			"Go southwest to "..cl(35,38),
			"	a. Talk to Nether-Stalker Oazul",
			"		i. Accept "..cq("Neutralizing the Nethermancers"),
			"	b. Talk to Wind Trader Tuluman",
			"		i. Accept "..cq("Dealing with the Foreman"),
			completion={{questaccepted="Neutralizing the Nethermancers"},{questaccepted="Dealing with the Foreman"}},
			mapzone="Netherstorm",
			level=68,
			mapnote=37807240,
		}, {
			"Also at "..cl(35,38),
			"	a. Talk to Kaylaan",
			"		i. Turn in "..cq("Outside Assistance"),
			"		ii. Accept "..cq("A Dark Pact"),
			completion={{questturnedin="Outside Assistance"},{questaccepted="A Dark Pact"}},
			mapzone="Netherstorm",
			level=68,
			mapnote=38307310,
		}, {
			"Go southwest to "..cl(31,41),
			"	a. Kill 15 Sunfury Nethermancers",
			"	b. Kill 3 Daughters of Destiny",
			completion={{questgoal={"*","Sunfury Nethermancer slain",15}},{questgoal={"*","Daughter of Destiny slain",3}}},
			mapzone="Netherstorm",
			level=68,
			mapnote=41407230,
		}, {
			"Go southwest to "..cl(29,43),
			"	a. Kill 6 Gan'arg Warp-Tinkers",
			"		i. You can also kill these inside the mine to the west",
			completion={{questgoal={"*","Gan'arg Warp-Tinker slain",6}}},
			mapzone="Netherstorm",
			level=68,
			mapnote=43307250,
		}, {
			"Go west into the mine",
			completion={{location={mapzone="Netherstorm",x=26.4,y=43.9, dist=0.3}}},
			mapzone="Netherstorm",
			level=68,
		}, {
			"Go to "..cl(26,42),
			"	a. Talk to Foreman Sundown",
			"		i. Turn in "..cq("Dealing with the Foreman"),
			"		ii. Accept "..cq("Dealing with the Overmaster"),
			completion={{questturnedin="Dealing with the Foreman"},{questaccepted="Dealing with the Overmaster"}},
			mapzone="Netherstorm",
			level=68,
			mapnote=42306870,
		}, {
			"While inside the cave:",
			"	a. Kill 3 Mo'arg Warp-Masters",
			completion={{questgoal={"*","Mo'arg Warp-Master slain",3}}},
			mapzone="Netherstorm",
			level=68,
		}, {
			"Go north to "..cl(27,36),
			"	a. Kill Overmaster Grindgarr",
			"		i. He's at the very back of the cave",
			completion={{questgoal={"*","Overmaster Grindgarr slain",1}}},
			mapzone="Netherstorm",
			level=68,
			mapnote=35806260,
		}, {
			"Hearth to the Stormspire",
			completion={{location={mapzone="Netherstorm",x=44.8,y=35.6, dist=6}}},
			mapzone="Netherstorm",
			level=68,
		}, {
			"Go to "..cl(45,37),
			"	a. Talk to Audi the Needle",
			"		i. Turn in "..cq("Retrieving the Goods"),
			completion={{questturnedin="Retrieving the Goods"}},
			mapzone="Netherstorm",
			level=68,
			mapnote=36708140,
		}, {
			"Go to "..cl(45,35),
			"	a. Talk to Nether-Stalker Nauthis",
			"		i. Turn in "..cq("The Minions of Culuthas"),
			"		ii. Turn in "..cq("Fel Reavers, No Thanks!"),
			"		iii. Accept "..cq("The Best Defense"),
			"	b. Talk to Zephyrion",
			"		i. Turn in "..cq("Surveying the Ruins"),
			completion={{questturnedin="The Minions of Culuthas"},{questturnedin="Fel Reavers, No Thanks!"},{questaccepted="The Best Defense"},{questturnedin="Surveying the Ruins"}},
			mapzone="Netherstorm",
			level=68,
			mapnote=34907960,
		}, {
			"Go to "..cl(44,35),
			"	a. Talk to Ghabar",
			"		i. Turn in "..cq("Diagnosis: Critical"),
			"		ii. Accept "..cq("Testing the Prototype"),
			completion={{questturnedin="Diagnosis: Critical"},{questaccepted="Testing the Prototype"}},
			mapzone="Netherstorm",
			level=68,
			mapnote=35107860,
		}, {
			"Go to "..cl(42,33),
			"	a. Talk to Aurine Moonblaze",
			"		i. Turn in "..cq("Creatures of the Eco-Domes"),
			"		ii. Accept "..cq("When Nature Goes Too Far"),
			completion={{questturnedin="Creatures of the Eco-Domes"},{questaccepted="When Nature Goes Too Far"}},
			mapzone="Netherstorm",
			level=68,
			mapnote=32607490,
		}, {
			"Grind to level 69",
			completion={{level=69}},
			mapzone="Netherstorm",
			level=68,
		}, {
			"Go northeast to "..cl(45,29),
			"	a. Kill Markaru",
			"	b. Get the Hulking Hydra Heart",
			completion={{questgoal={"*","Hulking Hydra Heart",1}}},
			mapzone="Netherstorm",
			level=69,
			mapnote=28507310,
		}, {
			"Go north to "..cl(45,14),
			"	a. Talk to Tashar",
			"		i. Turn in "..cq("Testing the Prototype"),
			"		ii. Accept "..cq("All Clear!"),
			completion={{questturnedin="Testing the Prototype"},{questaccepted="All Clear!"}},
			mapzone="Netherstorm",
			level=69,
			mapnote=14605930,
		}, {
			"Go northwest to "..cl(44,13),
			"	a. Kill 12 Scythetooth Raptors",
			completion={{questgoal={"*","Scythetooth Raptor slain",12}}},
			mapzone="Netherstorm",
			level=69,
			mapnote=13405740,
		}, {
			"Go southeast to "..cl(45,14),
			"	a. Talk to Tashar",
			"		i. Turn in "..cq("All Clear!"),
			"		ii. Accept "..cq("Success!"),
			completion={{questturnedin="All Clear!"},{questaccepted="Success!"}},
			mapzone="Netherstorm",
			level=69,
			mapnote=14605930,
		}, {
			"Go southwest to "..cl(42,23),
			"	a. Kill 12 Wrathbringers",
			completion={{questgoal={"*","Wrathbringer slain",12}}},
			mapzone="Netherstorm",
			level=69,
			mapnote=23506560,
		}, {
			"Go southwest to "..cl(35,38),
			"	a. Talk to Nether-Stalker Oazul",
			"		i. Turn in "..cq("Neutralizing the Nethermancers"),
			"	b. Talk to Wind Trader Tuluman",
			"		i. Turn in "..cq("Dealing with the Overmaster"),
			completion={{questturnedin="Neutralizing the Nethermancers"},{questturnedin="Dealing with the Overmaster"}},
			mapzone="Netherstorm",
			level=69,
			mapnote=37807240,
		}, {
			"Also at "..cl(35,38),
			"	a. Talk to Kaylaan",
			"		i. Turn in "..cq("A Dark Pact"),
			"		ii. Accept "..cq("Aldor No More"),
			completion={{questturnedin="A Dark Pact"},{questaccepted="Aldor No More"}},
			mapzone="Netherstorm",
			level=69,
			mapnote=38307310,
		}, {
			"Go east to the Stormspire",
			completion={{location={mapzone="Netherstorm",x=44.8,y=35.6, dist=6}}},
			mapzone="Netherstorm",
			level=69,
		}, {
			"Go to "..cl(42,33),
			"	a. Talk to Aurine Moonblaze",
			"		i. Turn in "..cq("When Nature Goes Too Far"),
			completion={{questturnedin="When Nature Goes Too Far"}},
			mapzone="Netherstorm",
			level=69,
			mapnote=32607490,
		}, {
			"Go to "..cl(44,35),
			"	a. Talk to Ghabar",
			"		i. Turn in "..cq("Success!"),
			completion={{questturnedin="Success!"}},
			mapzone="Netherstorm",
			level=69,
			mapnote=35107860,
		}, {
			"Go to "..cl(45,35),
			"	a. Talk to Nether-Stalker Nauthis",
			"		i. Turn in "..cq("The Best Defense"),
			completion={{questturnedin="The Best Defense"}},
			mapzone="Netherstorm",
			level=69,
			mapnote=34907960,
		}, {
			"Go east to "..cl(58,32),
			"	a. Talk to Wind Trader Marid",
			"		i. Accept "..cq("A Not-So-Modest Proposal"),
			completion={{questaccepted="A Not-So-Modest Proposal"}},
			mapzone="Netherstorm",
			level=69,
			mapnote=31709000,
		}, {
			"Go to "..cl(59,33),
			"	a. Talk to Researcher Navuud",
			"		i. Accept "..cq("Electro-Shock Goodness!"),
			completion={{questaccepted="Electro-Shock Goodness!"}},
			mapzone="Netherstorm",
			level=69,
			mapnote=32609180,
		}, {
			"Also at "..cl(60,32),
			"	a. Talk to Flesh Handler Viridius",
			"		i. Accept "..cq("Captain Tyralius"),
			completion={{questaccepted="Captain Tyralius"}},
			mapzone="Netherstorm",
			level=69,
			mapnote=32109120,
		}, {
			"Also at "..cl(60,32),
			"	a. Talk to Professor Dabiri",
			"		i. Accept "..cq("Recipe for Destruction"),
			completion={{questaccepted="Recipe for Destruction"}},
			mapzone="Netherstorm",
			level=69,
			mapnote=31709180,
		}, {
			"Go southwest to "..cl(56,39),
			"	a. Use Navuud's Concoction",
			"	b. Kill Void Wastes",
			"	c. Kill the Void Waste Globules that spawn",
			"	d. Kill 30 Void Waste Globules",
			completion={{questgoal={"*","Void Waste Globule slain",30}}},
			mapzone="Netherstorm",
			level=69,
			mapnote=39309520,
		}, {
			"Go southwest to "..cl(54,41),
			"	a. Kill Warden Icoshock",
			"	b. Get The Warden's Key",
			completion={{item={"The Warden's Key",1}}},
			mapzone="Netherstorm",
			level=69,
			mapnote=41109550,
		}, {
			"Go west to "..cl(53,41),
			"	a. Click the big pink bubble looking thing",
			"	b. Free Captain Tyralius",
			completion={{questgoal={"*","Captain Tyralius Freed",1}}},
			mapzone="Netherstorm",
			level=69,
			mapnote=41409480,
		}, {
			"Go southeast to "..cl(59,45),
			"	a. Talk to Agent Araxes",
			"		i. Accept "..cq("The Flesh Lies..."),
			completion={{questaccepted="The Flesh Lies..."}},
			mapzone="Netherstorm",
			level=69,
			mapnote=45010440,
		}, {
			"Go southeast to "..cl(61,46),
			"	a. Use your Protectorate Ignitor on Withered Corpses here and inside the mine",
			"	b. Don't get too close or the corpses turn into a monster",
			"	c. Burn 12 Withered Corpses",
			completion={{questgoal={"*","Withered Corpses Burned",12}}},
			mapzone="Netherstorm",
			level=69,
			mapnote=46510740,
		}, {
			"Go into the mine",
			completion={{location={mapzone="Netherstorm",x=61.1,y=45.4, dist=0.3}}},
			mapzone="Netherstorm",
			level=69,
		}, {
			"Go to "..cl(61,41),
			"	a. Talk to Agent Ya-six",
			"		i. Accept "..cq("Arconus the Insatiable"),
			"	b. Click the Teleporter Power Pack",
			"	c. Get the Teleporter Power Pack",
			completion={{questaccepted="Arconus the Insatiable"},{questgoal={"*","Teleporter Power Pack",1}}},
			mapzone="Netherstorm",
			level=69,
			mapnote=41510240,
		}, {
			"Go to "..cl(60,40),
			"	a. Kill Arconus the Insatiable",
			completion={{questgoal={"*","Arconus the Insatiable slain",1}}},
			mapzone="Netherstorm",
			level=69,
			mapnote=39909990,
		}, {
			"Leave the mine",
			completion={{location={mapzone="Netherstorm",x=61.1,y=45.4, dist=0.3}}},
			mapzone="Netherstorm",
			level=69,
		}, {
			"Go west to "..cl(59,45),
			"	a. Talk to Agent Araxes",
			"		i. Turn in "..cq("The Flesh Lies..."),
			completion={{questturnedin="The Flesh Lies..."}},
			mapzone="Netherstorm",
			level=69,
			mapnote=45010440,
		}, {
			"Go east to "..cl(64,47),
			"	a. Use Navuud's Concoction",
			"	b. Kill Seeping Sludges",
			"	c. Kill the Seeping Sludge Globules that spawn",
			"	d. Kill 30 Seeping Sludge Globules",
			completion={{questgoal={"*","Seeping Sludge Globule slain",30}}},
			mapzone="Netherstorm",
			level=69,
			mapnote=47111110,
		}, {
			"Go northeast to "..cl(66,42),
			"	a. Kill Voidshriekers",
			"	b. Kill Unstable Voidwraiths",
			"	c. Get 8 Fragments of Dimensius",
			completion={{questgoal={"*","Fragment of Dimensius",8}}},
			mapzone="Netherstorm",
			level=69,
			mapnote=42110850,
		}, {
			"Go north to "..cl(67,34),
			"	a. Use your Triangulation Device",
			"	b. Walk to the red arrow",
			"	c. Discover the First Triangulation Point",
			completion={{questgoal={"*","First triangulation point discovered",1}}},
			mapzone="Netherstorm",
			level=69,
			mapnote=33810050,
		}, {
			"Go east down the path into Celestial Ridge",
			completion={{location={mapzone="Netherstorm",x=71.0,y=40.0, dist=0.5}}},
			mapzone="Netherstorm",
			level=69,
		}, {
			"Go to "..cl(71,39),
			"	a. Click the Teleport Pad",
			"	b. Talk to the Image of Wind Trader Marid",
			"		i. Turn in "..cq("A Not-So-Modest Proposal"),
			"		ii. Accept "..cq("Getting Down to Business"),
			completion={{questturnedin="A Not-So-Modest Proposal"},{questaccepted="Getting Down to Business"}},
			mapzone="Netherstorm",
			level=69,
			mapnote=39011010,
		}, {
			"Go northeast to "..cl(72,38),
			"	a. Kill Nether Drakes",
			"	b. Kill Nether Dragons",
			"	c. Get 8 Nether Dragon Essences",
			completion={{questgoal={"*","Nether Dragon Essence",8}}},
			mapzone="Netherstorm",
			level=69,
			mapnote=38211040,
		}, {
			"Go southwest to "..cl(71,39),
			"	a. Talk to the Shrouded Figure",
			"		i. Turn in "..cq("Getting Down to Business"),
			"		ii. Accept "..cq("Formal Introductions"),
			completion={{questturnedin="Getting Down to Business"},{questaccepted="Formal Introductions"}},
			mapzone="Netherstorm",
			level=69,
			mapnote=38810970,
		}, {
			"Go north to "..cl(71,35),
			"	a. Talk to Tyri",
			"		i. Turn in "..cq("Formal Introductions"),
			"		ii. Accept "..cq("A Promising Start"),
			completion={{questturnedin="Formal Introductions"},{questaccepted="A Promising Start"}},
			mapzone="Netherstorm",
			level=69,
			mapnote=35110630,
		}, {
			"Go south to "..cl(72,36),
			"	a. Click the dark colored eggs with spikes on them",
			"	b. Get 15 Nether Dragonkin Eggs",
			completion={{questgoal={"*","Nether Dragonkin Egg",15}}},
			mapzone="Netherstorm",
			level=69,
			mapnote=36310790,
		}, {
			"Go north to "..cl(71,35),
			"	a. Talk to Tyri",
			"		i. Turn in "..cq("A Promising Start"),
			"		ii. Accept "..cq("Troublesome Distractions"),
			completion={{questturnedin="A Promising Start"},{questaccepted="Troublesome Distractions"}},
			mapzone="Netherstorm",
			level=69,
			mapnote=35110630,
		}, {
			"Go west to "..cl(60,32),
			"	a. Talk to Professor Dabiri",
			"		i. Turn in "..cq("Recipe for Destruction"),
			"		ii. Accept "..cq("On Nethery Wings"),
			completion={{questturnedin="Recipe for Destruction"},{questaccepted="On Nethery Wings"}},
			mapzone="Netherstorm",
			level=69,
			mapnote=31709180,
		}, {
			"Also at "..cl(60,32),
			"	a. Talk to Commander Ameer",
			"		i. Turn in "..cq("Arconus the Insatiable"),
			completion={{questturnedin="Arconus the Insatiable"}},
			mapzone="Netherstorm",
			level=69,
			mapnote=32409190,
		}, {
			"Also at "..cl(60,32),
			"	a. Talk to Flesh Handler Viridius",
			"		i. Turn in "..cq("Captain Tyralius"),
			completion={{questturnedin="Captain Tyralius"}},
			mapzone="Netherstorm",
			level=69,
			mapnote=32109120,
		}, {
			"Go to "..cl(60,33),
			"	a. Talk to Researcher Navuud",
			"		i. Turn in "..cq("Electro-Shock Goodness!"),
			completion={{questturnedin="Electro-Shock Goodness!"}},
			mapzone="Netherstorm",
			level=69,
			mapnote=32609180,
		}, {
			"Go to "..cl(58,31),
			"	a. Talk to Dealer Hazzin",
			"		i. Turn in "..cq("Triangulation Point One"),
			"		ii. Accept "..cq("Triangulation Point Two"),
			completion={{questturnedin="Triangulation Point One"},{questaccepted="Triangulation Point Two"}},
			mapzone="Netherstorm",
			level=69,
			mapnote=31308960,
		}, {
			"Go to "..cl(58,32),
			"	a. Talk to Wind Trader Marid",
			"		i. Lure Wind Trader Marid away",
			"		ii. Kill Wind Trader Marid",
			completion={{questgoal={"*","Wind Trader Marid slain",1}}},
			mapzone="Netherstorm",
			level=69,
			mapnote=31709000,
		}, {
			"Go to "..cl(60,32),
			"	a. Talk to the Protectorate Nether Drake next to Professor Dabiri",
			"	c. Put the Phase Disruptor in a slot on your spell bar",
			"	d. Click it repeatedly while you ride the Nether Drake",
			"	e. Destroy the Void Conduit",
			"	b. Talk to Professor Dabiri",
			"		i. Turn in "..cq("On Nethery Wings"),
			completion={{questturnedin="On Nethery Wings"}},
			mapzone="Netherstorm",
			level=69,
			mapnote=31709180,
		}, {
			"Go east into the Celestial Ridge",
			completion={{location={mapzone="Netherstorm",x=71.0,y=40.0, dist=0.5}}},
			mapzone="Netherstorm",
			level=69,
		}, {
			"Go to "..cl(71,35),
			"	a. Talk to Tyri",
			"		i. Turn in "..cq("Troublesome Distractions"),
			completion={{questturnedin="Troublesome Distractions"}},
			mapzone="Netherstorm",
			level=69,
			mapnote=35110630,
		}, {
			"Hearth to the Stormspire",
			completion={{location={mapzone="Netherstorm",x=44.8,y=35.6, dist=6}}},
			mapzone="Netherstorm",
			level=69,
		}, {
			"Go southwest to "..cl(29,41),
			"	a. Use your Triangulation Device",
			"	b. Walk up on the rocks to the red arrow",
			"	c. Discover the Second Triangulation Point",
			completion={{questgoal={"*","Second triangulation point discovered",1}}},
			mapzone="Netherstorm",
			level=69,
			mapnote=41307020,
		}, {
			"Go east to "..cl(35,38),
			"	a. Talk to Wind Trader Tuluman",
			"		i. Turn in "..cq("Triangulation Point Two"),
			completion={{questturnedin="Triangulation Point Two"}},
			mapzone="Netherstorm",
			level=69,
			mapnote=37807240,
		}, {
			"Go east to the Stormspire",
			completion={{location={mapzone="Netherstorm",x=44.8,y=35.6, dist=6}}},
			mapzone="Netherstorm",
			level=69,
		}, {
			"Fly to Area 52",
			completion={{location={mapzone="Netherstorm",x=32.3,y=65.5, dist=3}}},
			mapzone="Netherstorm",
			level=69,
		}, {
			"Go to "..cl(32,64),
			"	a. Talk to Exarch Orelis",
			"		i. Turn in "..cq("Aldor No More"),
			completion={{questturnedin="Aldor No More"}},
			mapzone="Netherstorm",
			level=69,
			mapnote=64209630,
		}, {
			"Fly to Allerian Stronghold",
			completion={{location={mapzone="Terokkar Forest",x=57.5,y=54.2, dist=3}}},
			mapzone="Netherstorm",
			level=69,
		}, {
			"Go east to Shadowmoon Valley",
			completion={{location={mapzone="Shadowmoon Valley"}}},
			mapzone="Terokkar Forest",
			level=69,
		}, {
			"Go southeast to Wildhammer Stronghold",
			completion={{location={mapzone="Shadowmoon Valley",x=37.8,y=55.4, dist=4}}},
			mapzone="Shadowmoon Valley",
			level=69,
		}, {
			"Go to "..cl(40,54),
			"	a. Talk to Wing Commander Nuainn",
			"		i. Accept "..cq("Besieged!"),
			completion={{questaccepted="Besieged!"}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=53709320,
		}, {
			"Go northeast to "..cl(40,53),
			"	a. Kill 10 Infernal Attackers",
			completion={{questgoal={"*","Infernal Attacker slain",10}}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=52809290,
		}, {
			"Go southwest to "..cl(40,54),
			"	a. Talk to Wing Commander Nauinn",
			"		i. Turn in "..cq("Besieged!"),
			"		ii. Accept "..cq("To Legion Hold"),
			completion={{questturnedin="Besieged!"},{questaccepted="To Legion Hold"}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=53709320,
		}, {
			"Go to "..cl(39,54),
			"	a. Talk to Gryphonrider Kiernan",
			"		i. Accept "..cq("The Sketh'lon Wreckage"),
			completion={{questaccepted="The Sketh'lon Wreckage"}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=54209300,
		}, {
			"Go to "..cl(38,55),
			"	a. Talk to Brubeck Stormfoot",
			"		i. Get the Wildhammer Stronghold Flight Path",
			completion={{flightpath="Wildhammer Stronghold"}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=55509310,
		}, {
			"Go to "..cl(37,55),
			"	a. Talk to Zorus the Judicator",
			"		i. He walks around town",
			"		ii. Accept "..cq("A Ghost in the Machine"),
			completion={{questaccepted="A Ghost in the Machine"}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=54709150,
		}, {
			"Go to "..cl(36,55),
			"	a. Talk to Gnomus",
			"		i. Accept "..cq("Spleendid!"),
			completion={{questaccepted="Spleendid!"}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=55209170,
		}, {
			"Go to "..cl(36,57),
			"	a. Talk to Earthmender Sophurus",
			"		i. Accept "..cq("The Hand of Gul'dan"),
			"	a. Talk to Thane Yoregar",
			"		ii. Accept "..cq("Put On Yer Kneepads..."),
			completion={{questaccepted="The Hand of Gul'dan"},{questaccepted="Put On Yer Kneepads..."}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=57009330,
		}, {
			"Make Wildhammer Stronghold your home",
			completion={{home="Wildhammer Stronghold"}},
			mapzone="Shadowmoon Valley",
			level=69,
		}, {
			"Kill 20 Shadowmoon Valley Wildlife as you quest in Shadowmoon Valley",
			"	a. The Shadowmoon Valley Wildlife are:",
			"		i. Felboars",
			"		ii. Vilewing Chimeras",
			"		iii. Scorchshell Pincers",
			completion={{questgoal={"*","Shadowmoon Valley Wildlife slain",20}}},
			mapzone="Shadowmoon Valley",
			level=69,
		}, {
			"Go southeast to "..cl(48,61),
			"	a. Kill Felfire Diemetradons",
			"	b. Get 8 Felfire Spleens",
			"	c. Click the little volcanos that puff green smoke around the pool",
			"	d. Get 15 Ever-burning Ash",
			completion={{questgoal={"*","Ever-burning Ash",15}},{questgoal={"*","Felfire Spleen",8}}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=60710850,
		}, {
			"Go northwest to "..cl(42,45),
			"	a. Talk to Earthmender Torlok",
			"		i. Turn in "..cq("The Hand of Gul'dan"),
			"		ii. Accept "..cq("Enraged Spirits of Fire and Earth"),
			completion={{questturnedin="The Hand of Gul'dan"},{questaccepted="Enraged Spirits of Fire and Earth"}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=45108730,
		}, {
			"Go southeast to "..cl(43,48),
			"	a. Use your Totem of Spirits",
			"	b. Kill Enraged Earth Spirits near the totem",
			"	c. Capture 8 Earthen Souls",
			completion={{questgoal={"*","Earthen Soul Captured",8}}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=48009100,
		}, {
			"Go east to "..cl(47,48),
			"	a. Use your Totem of Spirits",
			"	b. Kill Enraged Fire Spirits near the totem",
			"	c. Capture 8 Fiery Souls",
			completion={{questgoal={"*","Fiery Soul Captured",8}}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=48109470,
		}, {
			"Go northwest to "..cl(42,45),
			"	a. Talk to Earthmender Torlok",
			"		i. Turn in "..cq("Enraged Spirits of Fire and Earth"),
			"		ii. Accept "..cq("Enraged Spirits of Water"),
			completion={{questturnedin="Enraged Spirits of Fire and Earth"},{questaccepted="Enraged Spirits of Water"}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=45108730,
		}, {
			"Go northeast to "..cl(50,25),
			"	a. Use your Totem of Spirits",
			"	b. Kill Enraged Water Spirits near the totem",
			"	c. Capture 5 Watery Souls",
			completion={{questgoal={"*","Watery Soul Captured",5}}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=24707520,
		}, {
			"Go southwest to "..cl(40,30),
			"	a. Kill Dark Conclave arakkoas",
			"	b. Get the Sketh'lon Commander's Journal Page 1",
			"	c. Get the Sketh'lon Commander's Journal Page 2",
			"	d. Get the Sketh'lon Commander's Journal Page 3",
			completion={{questgoal={"*","Sketh'lon Commander's Journal - Page 1",1}},{questgoal={"*","Sketh'lon Commander's Journal - Page 2",1}},{questgoal={"*","Sketh'lon Commander's Journal - Page 3",1}}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=30507080,
		}, {
			"Go southwest to Legion Hold",
			completion={{location={mapzone="Shadowmoon Valley",x=23.4,y=38.3, dist=4}}},
			mapzone="Shadowmoon Valley",
			level=69,
		}, {
			"Go up the big platform wall type thing",
			completion={{location={mapzone="Shadowmoon Valley",x=23.4,y=38.3, dist=0.5}}},
			mapzone="Shadowmoon Valley",
			level=69,
		}, {
			"Go to "..cl(24,37),
			"	a. Use the Box 'o Tricks next to the Legion Communication Device",
			"	b. Watch the conversation",
			"	c. Discover Legion's Plans",
			completion={{questgoal={"*","Discover Legion's Plans",1}}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=36906050,
		}, {
			"Hearth to Wildhammer Stronghold",
			completion={{location={mapzone="Shadowmoon Valley",x=37.8,y=55.4, dist=4}}},
			mapzone="Shadowmoon Valley",
			level=69,
		}, {
			"Go to "..cl(37,55),
			"	a. Talk to Zorus the Judicator",
			"		i. He walks around town",
			"		ii. Turn in "..cq("A Ghost in the Machine"),
			"		iii. Accept "..cq("Harbingers of Shadowmoon"),
			completion={{questturnedin="A Ghost in the Machine"},{questaccepted="Harbingers of Shadowmoon"}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=54709150,
		}, {
			"Go to "..cl(36,57),
			"	a. Talk to Thane Yoregar",
			"		i. Turn in "..cq("Put On Yer Kneepads..."),
			completion={{questturnedin="Put On Yer Kneepads..."}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=57009330,
		}, {
			"Go to "..cl(36,55),
			"	a. Talk to Gnomus",
			"		i. Turn in "..cq("Spleendid!"),
			"		ii. Accept "..cq("The Second Course..."),
			completion={{questturnedin="Spleendid!"},{questaccepted="The Second Course..."}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=55209170,
		}, {
			"Go to "..cl(39,54),
			"	a. Talk to Gryphonrider Kiernan",
			"		i. Turn in "..cq("The Sketh'lon Wreckage"),
			"		ii. Accept "..cq("Find the Deserter"),
			completion={{questturnedin="The Sketh'lon Wreckage"},{questaccepted="Find the Deserter"}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=54209300,
		}, {
			"Go to "..cl(40,54),
			"	a. Talk to Wing Commander Nuainn",
			"		i. Turn in "..cq("To Legion Hold"),
			"		ii. Accept "..cq("Setting Up the Bomb"),
			completion={{questturnedin="To Legion Hold"},{questaccepted="Setting Up the Bomb"}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=53709320,
		}, {
			"Go to "..cl(37,57),
			"	a. Use the Spectracles in your bags to see the Shadowmoon Harbingers",
			"	b. Kill 12 Shadowmoon Harbingers around town",
			completion={{questgoal={"*","Shadowmoon Harbinger slain",12}}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=56509370,
		}, {
			"Go to "..cl(37,55),
			"	a. Talk to Zorus the Judicator",
			"		i. He walks around town",
			"		ii. Turn in "..cq("Harbingers of Shadowmoon"),
			"		iii. Accept "..cq("Teron Gorefiend  Lore and Legend"),
			completion={{questturnedin="Harbingers of Shadowmoon"},{questaccepted="Teron Gorefiend - Lore and Legend"}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=54709150,
		}, {
			"Go northeast to "..cl(42,45),
			"	a. Talk to Earthmender Torlok",
			"		i. Turn in "..cq("Enraged Spirits of Water"),
			"		ii. Accept "..cq("Enraged Spirits of Air"),
			completion={{questturnedin="Enraged Spirits of Water"},{questaccepted="Enraged Spirits of Air"}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=45108730,
		}, {
			"Go northwest to "..cl(35,40),
			"	a. Talk to Parshah",
			"		i. He walks north and south on this road",
			"		ii. Turn in "..cq("Find the Deserter"),
			"		iii. Accept "..cq("Asghar's Totem"),
			completion={{questturnedin="Find the Deserter"},{questaccepted="Asghar's Totem"}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=39907510,
		}, {
			"Go northeast to "..cl(40,29),
			"	a. Kill Asghar",
			"		i. He wanders around the arakkoa camp",
			"	b. Get the Sketh'lon War Totem",
			completion={{questgoal={"*","Sketh'lon War Totem",1}}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=29206940,
		}, {
			"Go northeast to "..cl(48,21),
			"	a. Kill Greater Felfire Diemetradons",
			"	b. Get an Overdeveloped Felfire Gizzard",
			completion={{questgoal={"*","Overdeveloped Felfire Gizzard",1}}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=21106870,
		}, {
			"Go southwest to "..cl(35,40),
			"	a. Talk to Parshah",
			"		i. He walks north and south on this road",
			"		ii. Turn in "..cq("Asghar's Totem"),
			"		iii. Accept "..cq("The Rod of Lianthe"),
			completion={{questturnedin="Asghar's Totem"},{questaccepted="The Rod of Lianthe"}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=39907510,
		}, {
			"Go west to Legion Hold",
			completion={{location={mapzone="Shadowmoon Valley",x=23.4,y=38.3, dist=4}}},
			mapzone="Shadowmoon Valley",
			level=69,
		}, {
			"Go northwest to "..cl(22,35),
			"	a. Click the big green glowing helmet on the ground",
			"	b. Get the Fel Reaver Armor Plate",
			"	c. Kill mobs around this area",
			"	d. Get an Illidari-Bane Shard",
			"	e. Click the Illidari-Bane Shard",
			"		i. Accept "..cq("Illidari-Bane Shard"),
			completion={{questgoal={"*","Fel Reaver Armor Plate",1}},{questaccepted="Illidari-Bane Shard"}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=35505770,
		}, {
			"Go southeast to "..cl(26,41),
			"	a. Click the jetpack looking thing underwater in the middle of the lake",
			"	b. Get the Fel Reaver Power Core",
			completion={{questgoal={"*","Fel Reaver Power Core",1}}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=41206750,
		}, {
			"Go southeast to Wildhammer Stronghold",
			completion={{location={mapzone="Shadowmoon Valley",x=37.8,y=55.4, dist=4}}},
			mapzone="Shadowmoon Valley",
			level=69,
		}, {
			"Go to "..cl(40,54),
			"	a. Talk to Wing Commander Nuainn",
			"		i. Turn in "..cq("Setting Up the Bomb"),
			"		ii. Accept "..cq("Blast the Infernals!"),
			completion={{questturnedin="Setting Up the Bomb"},{questaccepted="Blast the Infernals!"}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=53709320,
		}, {
			"Go to "..cl(37,55),
			"	a. Talk to Ordinn Thunderfist",
			"		i. Turn in "..cq("Illidari-Bane Shard"),
			completion={{questturnedin="Illidari-Bane Shard"}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=54909170,
		}, {
			"Go to "..cl(36,55),
			"	a. Talk to Gnomus",
			"		i. Turn in "..cq("The Second Course..."),
			"		ii. Accept "..cq("The Main Course!"),
			completion={{questturnedin="The Second Course..."},{questaccepted="The Main Course!"}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=55209170,
		}, {
			"Go northwest to Legion Hold",
			completion={{location={mapzone="Shadowmoon Valley",x=23.4,y=38.3, dist=4}}},
			mapzone="Shadowmoon Valley",
			level=69,
		}, {
			"Go to "..cl(23,40),
			"	a. Stand inside the green summoning circle looking thing",
			"	b. Use your Fel Bomb",
			"	c. Destroy the Legion Hold Infernals",
			completion={{questgoal={"*","Destroy Legion Hold Infernals",1}}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=40006270,
		}, {
			"Go southeast to Wildhammer Stronghold",
			completion={{location={mapzone="Shadowmoon Valley",x=37.8,y=55.4, dist=4}}},
			mapzone="Shadowmoon Valley",
			level=69,
		}, {
			"Go to "..cl(40,54),
			"	a. Talk to Wing Commander Nuainn",
			"		i. Turn in "..cq("Blast the Infernals!"),
			"		ii. Accept "..cq("The Deathforge"),
			completion={{questturnedin="Blast the Infernals!"},{questaccepted="The Deathforge"}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=53709320,
		}, {
			"Go southeast to "..cl(48,66),
			"	a. Kill Eclipsion blood elves",
			"	b. Get Lianthe's Key",
			completion={{questgoal={"*","Lianthe's Key",1}}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=66411390,
		}, {
			"Go south to "..cl(48,72),
			"	a. Click Lianthe's Strongbox in the hut with red curtains",
			"	b. Get the Rod of Lianthe",
			completion={{questgoal={"*","Rod of Lianthe",1}}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=71711920,
		}, {
			"Go northeast to "..cl(62,55),
			"	a. Use your Totem of Spirits",
			"	b. Kill Enraged Air Spirits near the totem",
			"	c. Get 10 Airy Souls",
			completion={{questgoal={"*","Airy Soul Captured",10}}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=54511650,
		}, {
			"Go south to "..cl(62,63),
			"	a. The path to the Ancient Shadowmoon Spirit starts here",
			completion={{location={mapzone="Shadowmoon Valley",x=62.5,y=62.6, dist=0.5}}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=62612500,
		}, {
			"Go southwest to "..cl(58,71),
			"	a. Talk to the Ancient Shadowmoon Spirit",
			"		i. Turn in "..cq("Teron Gorefiend - Lore and Legend"),
			completion={{questturnedin="Teron Gorefiend - Lore and Legend"}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=70812900,
		}, {
			"Go north to "..cl(56,41),
			"	a. Kill Felspine",
			"	b. Get Felspine's Hide",
			completion={{questgoal={"*","Felspine's Hide",1}}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=41109690,
		}, {
			"Go northeast to the Altar of Sha'tar",
			completion={{location={mapzone="Shadowmoon Valley",x=62.2,y=30.0, dist=3}}},
			mapzone="Shadowmoon Valley",
			level=69,
		}, {
			"Go to "..cl(61,28),
			"	a. Talk to Exarch Onaala",
			"		i. Accept "..cq("Karabor Training Grounds"),
			"	b. Talk to Vindicator Aluumen",
			"		i. Accept "..cq("The Ashtongue Tribe"),
			completion={{questaccepted="Karabor Training Grounds"},{questaccepted="The Ashtongue Tribe"}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=29209040,
		}, {
			"Make the Altar of Sha'tar your home",
			completion={{home="the Altar of Sha'tar"}},
			mapzone="Shadowmoon Valley",
			level=69,
		}, {
			"Go to "..cl(63,28),
			"	a. Talk to Anchorite Ceyla",
			"		i. Accept "..cq("Tablets of Baa'ri"),
			completion={{questaccepted="Tablets of Baa'ri"}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=28409100,
		}, {
			"Go to "..cl(63,30),
			"	a. Talk to Maddix",
			"		i. Get the Altar of Sha'tar Flight Path",
			completion={{flightpath="Altar of Sha'tar"}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=30409370,
		}, {
			"Go south to "..cl(61,38),
			"	a. Kill Ashtongue Workers",
			"	b. Click the little green glowing shards on the ground up the hill",
			"	c. Get 12 Baa'ri Tablet Fragments",
			completion={{questgoal={"*","Baa'ri Tablet Fragment",12}}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=38209950,
		}, {
			"Go northwest to "..cl(60,35),
			"	a. Kill 3 Ashtongue Handlers",
			"	b. Kill 4 Ashtongue Warriors",
			"	c. Kill 6 Ashtongue Shamans",
			completion={{questgoal={"*","Ashtongue Handler slain",3}},{questgoal={"*","Ashtongue Warrior slain",4}},{questgoal={"*","Ashtongue Shaman slain",6}}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=34809440,
		}, {
			"Go southeast to "..cl(67,46),
			"	a. The path up to the Ruins of Karabor starts here",
			completion={{location={mapzone="Shadowmoon Valley",x=66.6,y=45.8, dist=0.3}}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=45811240,
		}, {
			"Go southeast to "..cl(68,51),
			"	a. Kill Demon Hunter Supplicants",
			"	b. Kill Demon Hunter Initiates",
			"	c. Get 8 Sunfury Glaives",
			completion={{questgoal={"*","Sunfury Glaive",8}}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=50511860,
		}, {
			"Go northwest to the Altar of Sha'tar",
			completion={{location={mapzone="Shadowmoon Valley",x=62.2,y=30.0, dist=3}}},
			mapzone="Shadowmoon Valley",
			level=69,
		}, {
			"Go to "..cl(61,29),
			"	a. Talk to Vindicator Aluumen",
			"		i. Turn in "..cq("The Ashtongue Tribe"),
			"	b. Talk to Exarch Onaala",
			"		i. Turn in "..cq("Karabor Training Grounds"),
			completion={{questturnedin="The Ashtongue Tribe"},{questturnedin="Karabor Training Grounds"}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=29209040,
		}, {
			"Go to "..cl(63,28),
			"	a. Talk to Anchorite Ceyla",
			"		i. Turn in "..cq("Tablets of Baa'ri"),
			completion={{questturnedin="Tablets of Baa'ri"}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=28409100,
		}, {
			"Fly to Wildhammer Stronghold",
			completion={{location={mapzone="Shadowmoon Valley",x=37.8,y=55.4, dist=4}}},
			mapzone="Shadowmoon Valley",
			level=69,
		}, {
			"Go to "..cl(36,55),
			"	a. Talk to Gnomus",
			"		i. Turn in "..cq("The Main Course!"),
			completion={{questturnedin="The Main Course!"}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=55209170,
		}, {
			"Go northeast to "..cl(42,45),
			"	a. Talk to Earthmender Torlok",
			"		i. Turn in "..cq("Enraged Spirits of Air"),
			"		ii. Accept "..cq("Oronok Torn-heart"),
			completion={{questturnedin="Enraged Spirits of Air"},{questaccepted="Oronok Torn-heart"}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=45108730,
		}, {
			"Go northwest to "..cl(41,41),
			"	a. Talk to Stormer Ewan Wildwing",
			"		i. Turn in "..cq("The Deathforge"),
			"		ii. Accept "..cq("Minions of the Shadow Council"),
			completion={{questturnedin="The Deathforge"},{questaccepted="Minions of the Shadow Council"}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=41308180,
		}, {
			"Go north to "..cl(40,36),
			"	a. Kill 10 Deathforge Guardians",
			"	b. Kill 5 Deathforge Summoners",
			completion={{questgoal={"*","Deathforge Guardian slain",10}},{questgoal={"*","Deathforge Summoner slain",5}}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=36307640,
		}, {
			"Go south to "..cl(41,41),
			"	a. Talk to Stormer Ewan Wildwing",
			"		i. Turn in "..cq("Minions of the Shadow Council"),
			completion={{questturnedin="Minions of the Shadow Council"}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=41308180,
		}, {
			"Go west to "..cl(35,40),
			"	a. Talk to Parshah",
			"		i. He walks north and south on this road",
			"		ii. Turn in "..cq("The Rod of Lianthe"),
			"		iii. Accept "..cq("Sketh'lon Feathers"),
			completion={{questturnedin="The Rod of Lianthe"},{questaccepted="Sketh'lon Feathers"}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=39907510,
		}, {
			"Go northeast to "..cl(54,24),
			"	a. Talk to Oronok Torn-heart",
			"		i. Turn in "..cq("Oronok Torn-heart"),
			"		ii. Accept "..cq("I Was A Lot Of Things..."),
			completion={{questturnedin="Oronok Torn-heart"},{questaccepted="I Was A Lot Of Things..."}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=23507740,
		}, {
			"Go northwest to "..cl(52,17),
			"	a. The Shadowmoon Tubers look like carrots sticking out of the ground",
			"	b. Use Oronok's Boar Whistle next to the Shadowmoon Tubers",
			"		i. If a boar is near, it will run up and dig up the Shadowmoon Tuber for you",
			"	c. Click the Shadowmoon Tuber",
			"	d. Get 10 Shadowmoon Tubers",
			completion={{questgoal={"*","Shadowmoon Tuber",10}}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=17106890,
		}, {
			"Go southeast to "..cl(54,24),
			"	a. Talk to Oronok Torn-heart",
			"		i. Turn in "..cq("I Was A Lot Of Things..."),
			"		ii. Accept "..cq("A Lesson Learned"),
			completion={{questturnedin="I Was A Lot Of Things..."},{questaccepted="A Lesson Learned"}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=23507740,
		}, {
			"Go northeast to "..cl(55,17),
			"	a. Click the brown eggs on the ground",
			"	b. Destroy 10 Ravenous Flayer Eggs",
			completion={{questgoal={"*","Ravenous Flayer Egg Destroyed",10}}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=17207240,
		}, {
			"Go southwest to "..cl(54,24),
			"	a. Talk to Oronok Torn-heart",
			"		i. Turn in "..cq("A Lesson Learned"),
			"		ii. Accept "..cq("The Cipher of Damnation - Truth and History"),
			"		iii. Listen to Oronok Torn-heart's story",
			"		iv. Turn in "..cq("The Cipher of Damnation - Truth and History"),
			completion={{questturnedin="A Lesson Learned"},{questaccepted="The Cipher of Damnation - Truth and History"},{questturnedin="The Cipher of Damnation - Truth and History"}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=23507740,
		}, {
			"Hearth to Wildhammer Stronghold",
			completion={{location={mapzone="Shadowmoon Valley",x=37.8,y=55.4, dist=4}}},
			mapzone="Shadowmoon Valley",
			level=69,
		}, {
			"Go east to "..cl(43,56),
			"	a. Click the big red and black feathers on the ground",
			"	b. Get 8 Sketh'lon Feathers",
			completion={{questgoal={"*","Sketh'lon Feather",8}}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=56009860,
		}, {
			"Go northwest to "..cl(35,40),
			"	a. Talk to Parshah",
			"		i. He walks north and south on this road",
			"		ii. Turn in "..cq("Sketh'lon Feathers"),
			"		iii. Accept "..cq("Imbuing the Headpiece"),
			completion={{questturnedin="Sketh'lon Feathers"},{questaccepted="Imbuing the Headpiece"}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=39907510,
		}, {
			"Go southeast to "..cl(43,45),
			"	a. Equip the Unfinished Headpiece when you are NOT close to the altar",
			"	b. Wait for the cooldown to be done",
			"	c. Go up to the altar",
			"	d. Use the Unfinished Headpiece",
			"	e. Energize the Headpiece",
			completion={{questgoal={"*","Energized Headpiece",1}}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=44908790,
		}, {
			"Go northwest to "..cl(35,40),
			"	a. Talk to Parshah",
			"		i. He walks north and south on this road",
			"		ii. Turn in "..cq("Imbuing the Headpiece"),
			completion={{questturnedin="Imbuing the Headpiece"}},
			mapzone="Shadowmoon Valley",
			level=69,
			mapnote=39907510,
		}, {
			"Grind to level 70",
			completion={{level=70}},
			mapzone="Shadowmoon Valley",
			level=69,
		}
	  }
	}
}