local BS = LibStub("LibBabble-Spell-3.0"):GetLookupTable()

local spells = {
	BS["Snake Trap"],
	BS["Freezing Trap"],
	BS["Frost Trap"],
	BS["Immolation Trap"],
	BS["Explosive Trap"],
	BS["Feign Death"]
}

function ZTrap:UpdateSpells()
	self:ResetSpells()
	for i = 1, #spells do
		self:AddSpell(spells[ZHunterMod_Saved["ZTrap"]["order"][i]])
	end
end

function ZTrap:Initialize()
	local vars = ZHunterMod_Saved.ZTrap
	self:UpdateSpells()
	self:SetSize(vars.size)
	self:SetCount(vars.count)
	self:SetHorizontal(vars.horizontal)
	self:SetVertical(vars.vertical)
	self:SetPerRow(vars.perRow)
	self:SetRoundButton(vars.roundButton)
	self:SetExpandType(vars.expandType)
	self:SetBackgroundColor(vars.bgColor)
	self:SetCooldownDisplay(vars.cooldownDisplay)
	if not ZHunterMod_Saved["ZTrap"].enabled then
		self:SetCount(0)
		self:Hide()
	end
end

ZHunterModOptions.args.trap = {
	type = "group",
	name = "Trap Bar",
	desc = "Options to customize the Trap bar.",
	order = 4,
	args = {}
}
ZHunterModOptions_SetSpellOptions("ZTrap", ZHunterModOptions.args.trap.args, spells)