local BS = LibStub("LibBabble-Spell-3.0"):GetLookupTable()

local spells = {
	BS["Track Hidden"],
	BS["Track Humanoids"],
	BS["Track Beasts"],
	BS["Track Demons"],
	BS["Track Elementals"],
	BS["Track Undead"],
	BS["Track Dragonkin"],
	BS["Track Giants"],
	BS["Find Minerals"],
	BS["Find Herbs"],
	BS["Find Treasure"],
	BS["Find Fish"]
}

function ZTrack:UpdateSpells()
	self:ResetSpells()
	for i = 1, #spells do
		self:AddSpell(spells[ZHunterMod_Saved["ZTrack"]["order"][i]])
	end
end

function ZTrack:Initialize()
	local vars = ZHunterMod_Saved.ZTrack
	self:UpdateSpells()
	self:SetSize(vars.size)
	self:SetCount(vars.count)
	self:SetHorizontal(vars.horizontal)
	self:SetVertical(vars.vertical)
	self:SetPerRow(vars.perRow)
	self:SetRoundButton(vars.roundButton)
	self:SetExpandType(vars.expandType)
	self:SetBackgroundColor(vars.bgColor)
	self:SetCooldownDisplay(vars.cooldownDisplay)
	if not ZHunterMod_Saved["ZTrack"].enabled then
		self:SetCount(0)
		self:Hide()
	end
end

ZHunterModOptions.args.track = {
	type = "group",
	name = "Track Bar",
	desc = "Options to customize the Track bar.",
	order = 3,
	args = {}
}
ZHunterModOptions_SetSpellOptions("ZTrack", ZHunterModOptions.args.track.args, spells)